/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Net;
using System.Net.Mime;
using Pieces.Os.Core.Client;
using Pieces.Os.Core.Client.Auth;
using Pieces.Os.Core.SdkModel;

namespace Pieces.Os.Core.Api
{

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public interface IAuth0ApiSync : IApiAccessor
    {
        #region Synchronous Operations
        /// <summary>
        /// https://auth.pieces.services/v2/logout [GET]
        /// </summary>
        /// <remarks>
        /// https://auth0.com/docs/api/authentication#logout
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="clientId">The client ID of the Auth0 Instance (optional)</param>
        /// <param name="returnTo">The URL that the logout endpoint will return to (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>string</returns>
        string Auth0Logout(string clientId = default(string), string returnTo = default(string), int operationIndex = 0);

        /// <summary>
        /// https://auth.pieces.services/v2/logout [GET]
        /// </summary>
        /// <remarks>
        /// https://auth0.com/docs/api/authentication#logout
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="clientId">The client ID of the Auth0 Instance (optional)</param>
        /// <param name="returnTo">The URL that the logout endpoint will return to (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of string</returns>
        ApiResponse<string> Auth0LogoutWithHttpInfo(string clientId = default(string), string returnTo = default(string), int operationIndex = 0);
        /// <summary>
        /// https://auth.pieces.services/authorize [GET]
        /// </summary>
        /// <remarks>
        /// An endpoint that is used locally authenticate via a PKCE Flow.  Example https://auth.pieces.services /authorize?audience&#x3D;https%3A%2F%2Fpieces.us.auth0.com%2Fapi%2Fv2%2F&amp;scope&#x3D;email+profile+offline_access+openid&amp;response_type&#x3D;code&amp;client_id&#x3D;9sW4Pa1LEjX67l6VO14u0207NLYeXnu1&amp;redirect_uri&#x3D;http%3A%2F%2Flocalhost%3A3000%2Fpkce%2Fresponse%2Fcode&amp;code_challenge_method&#x3D;S256&amp;code_challenge&#x3D;yxRssZxdfBpMigRmDxAety1QU72Bd5WnDUbtlsCZOnk&amp;response_mode&#x3D;form_post&amp;state&#x3D;4bd0b9a389b4b229602346c33913b4c3c199628a90011ab3a901302ab62b3832
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="audience"> The unique identifier of the target API you want to access.</param>
        /// <param name="scope">The scopes which you want to request authorization for. These must be separated by a space. You can request any of the standard OpenID Connect (OIDC) scopes about users, such as profile and email, custom claims that must conform to a namespaced format, or any scopes supported by the target API (for example, read:contacts). Include offline_access to get a Refresh Token.</param>
        /// <param name="responseType">Indicates to Auth0 which OAuth 2.0 Flow you want to perform. Use code for Authorization Code Grant (PKCE) Flow.</param>
        /// <param name="clientId">Your application&#39;s Client ID.</param>
        /// <param name="codeChallengeMethod">Method used to generate the challenge. The PKCE spec defines two methods, S256 and plain, however, Auth0 supports only S256 since the latter is discouraged.</param>
        /// <param name="codeChallenge">Generated challenge from the code_verifier.</param>
        /// <param name="responseMode"></param>
        /// <param name="state">An opaque value the clients adds to the initial request that Auth0 includes when redirecting the back to the client. This value must be used by the client to prevent CSRF attacks. (optional)</param>
        /// <param name="redirectUri">The URL to which Auth0 will redirect the browser after authorization has been granted by the user. (optional)</param>
        /// <param name="connection">The name of the connection configured to your application. (optional)</param>
        /// <param name="prompt">To initiate a silent authentication request, use prompt&#x3D;none (see Remarks for more info). (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ResultedPKCE</returns>
        ResultedPKCE AuthorizeAuth0(string audience, List<string> scope, string responseType, string clientId, string codeChallengeMethod, string codeChallenge, string responseMode, string state = default(string), string redirectUri = default(string), string connection = default(string), string prompt = default(string), int operationIndex = 0);

        /// <summary>
        /// https://auth.pieces.services/authorize [GET]
        /// </summary>
        /// <remarks>
        /// An endpoint that is used locally authenticate via a PKCE Flow.  Example https://auth.pieces.services /authorize?audience&#x3D;https%3A%2F%2Fpieces.us.auth0.com%2Fapi%2Fv2%2F&amp;scope&#x3D;email+profile+offline_access+openid&amp;response_type&#x3D;code&amp;client_id&#x3D;9sW4Pa1LEjX67l6VO14u0207NLYeXnu1&amp;redirect_uri&#x3D;http%3A%2F%2Flocalhost%3A3000%2Fpkce%2Fresponse%2Fcode&amp;code_challenge_method&#x3D;S256&amp;code_challenge&#x3D;yxRssZxdfBpMigRmDxAety1QU72Bd5WnDUbtlsCZOnk&amp;response_mode&#x3D;form_post&amp;state&#x3D;4bd0b9a389b4b229602346c33913b4c3c199628a90011ab3a901302ab62b3832
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="audience"> The unique identifier of the target API you want to access.</param>
        /// <param name="scope">The scopes which you want to request authorization for. These must be separated by a space. You can request any of the standard OpenID Connect (OIDC) scopes about users, such as profile and email, custom claims that must conform to a namespaced format, or any scopes supported by the target API (for example, read:contacts). Include offline_access to get a Refresh Token.</param>
        /// <param name="responseType">Indicates to Auth0 which OAuth 2.0 Flow you want to perform. Use code for Authorization Code Grant (PKCE) Flow.</param>
        /// <param name="clientId">Your application&#39;s Client ID.</param>
        /// <param name="codeChallengeMethod">Method used to generate the challenge. The PKCE spec defines two methods, S256 and plain, however, Auth0 supports only S256 since the latter is discouraged.</param>
        /// <param name="codeChallenge">Generated challenge from the code_verifier.</param>
        /// <param name="responseMode"></param>
        /// <param name="state">An opaque value the clients adds to the initial request that Auth0 includes when redirecting the back to the client. This value must be used by the client to prevent CSRF attacks. (optional)</param>
        /// <param name="redirectUri">The URL to which Auth0 will redirect the browser after authorization has been granted by the user. (optional)</param>
        /// <param name="connection">The name of the connection configured to your application. (optional)</param>
        /// <param name="prompt">To initiate a silent authentication request, use prompt&#x3D;none (see Remarks for more info). (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of ResultedPKCE</returns>
        ApiResponse<ResultedPKCE> AuthorizeAuth0WithHttpInfo(string audience, List<string> scope, string responseType, string clientId, string codeChallengeMethod, string codeChallenge, string responseMode, string state = default(string), string redirectUri = default(string), string connection = default(string), string prompt = default(string), int operationIndex = 0);
        /// <summary>
        /// https://auth.pieces.services/oauth/token [POST]
        /// </summary>
        /// <remarks>
        /// An endpoint to generate a OAuth Token for an authentication flow. 
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="grantType">Denotes the flow you are using. For Authorization Code, use authorization_code or refresh_token.</param>
        /// <param name="clientId">Your application&#39;s Client ID.</param>
        /// <param name="code">The Authorization Code received from the initial /authorize call.</param>
        /// <param name="redirectUri">This is required only if it was set at the GET /authorize endpoint. The values must match.</param>
        /// <param name="codeVerifier">Cryptographically random key that was used to generate the code_challenge passed to /authorize.</param>
        /// <param name="schema"> (optional)</param>
        /// <param name="audience">The audience domain: i.e. https://pieces.us.auth0.com (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>OAuthToken</returns>
        OAuthToken ExchangeForAuth0Token(string grantType, string clientId, string code, string redirectUri, string codeVerifier, EmbeddedModelSchema schema = default(EmbeddedModelSchema), string audience = default(string), int operationIndex = 0);

        /// <summary>
        /// https://auth.pieces.services/oauth/token [POST]
        /// </summary>
        /// <remarks>
        /// An endpoint to generate a OAuth Token for an authentication flow. 
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="grantType">Denotes the flow you are using. For Authorization Code, use authorization_code or refresh_token.</param>
        /// <param name="clientId">Your application&#39;s Client ID.</param>
        /// <param name="code">The Authorization Code received from the initial /authorize call.</param>
        /// <param name="redirectUri">This is required only if it was set at the GET /authorize endpoint. The values must match.</param>
        /// <param name="codeVerifier">Cryptographically random key that was used to generate the code_challenge passed to /authorize.</param>
        /// <param name="schema"> (optional)</param>
        /// <param name="audience">The audience domain: i.e. https://pieces.us.auth0.com (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of OAuthToken</returns>
        ApiResponse<OAuthToken> ExchangeForAuth0TokenWithHttpInfo(string grantType, string clientId, string code, string redirectUri, string codeVerifier, EmbeddedModelSchema schema = default(EmbeddedModelSchema), string audience = default(string), int operationIndex = 0);
        /// <summary>
        /// https://auth.pieces.services/userinfo [GET]
        /// </summary>
        /// <remarks>
        /// Get the users info from the Auth0 API
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>Auth0User</returns>
        Auth0User GetAuth0UserInfo(int operationIndex = 0);

        /// <summary>
        /// https://auth.pieces.services/userinfo [GET]
        /// </summary>
        /// <remarks>
        /// Get the users info from the Auth0 API
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Auth0User</returns>
        ApiResponse<Auth0User> GetAuth0UserInfoWithHttpInfo(int operationIndex = 0);
        #endregion Synchronous Operations
    }

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public interface IAuth0ApiAsync : IApiAccessor
    {
        #region Asynchronous Operations
        /// <summary>
        /// https://auth.pieces.services/v2/logout [GET]
        /// </summary>
        /// <remarks>
        /// https://auth0.com/docs/api/authentication#logout
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="clientId">The client ID of the Auth0 Instance (optional)</param>
        /// <param name="returnTo">The URL that the logout endpoint will return to (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of string</returns>
        System.Threading.Tasks.Task<string> Auth0LogoutAsync(string clientId = default(string), string returnTo = default(string), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// https://auth.pieces.services/v2/logout [GET]
        /// </summary>
        /// <remarks>
        /// https://auth0.com/docs/api/authentication#logout
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="clientId">The client ID of the Auth0 Instance (optional)</param>
        /// <param name="returnTo">The URL that the logout endpoint will return to (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (string)</returns>
        System.Threading.Tasks.Task<ApiResponse<string>> Auth0LogoutWithHttpInfoAsync(string clientId = default(string), string returnTo = default(string), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// https://auth.pieces.services/authorize [GET]
        /// </summary>
        /// <remarks>
        /// An endpoint that is used locally authenticate via a PKCE Flow.  Example https://auth.pieces.services /authorize?audience&#x3D;https%3A%2F%2Fpieces.us.auth0.com%2Fapi%2Fv2%2F&amp;scope&#x3D;email+profile+offline_access+openid&amp;response_type&#x3D;code&amp;client_id&#x3D;9sW4Pa1LEjX67l6VO14u0207NLYeXnu1&amp;redirect_uri&#x3D;http%3A%2F%2Flocalhost%3A3000%2Fpkce%2Fresponse%2Fcode&amp;code_challenge_method&#x3D;S256&amp;code_challenge&#x3D;yxRssZxdfBpMigRmDxAety1QU72Bd5WnDUbtlsCZOnk&amp;response_mode&#x3D;form_post&amp;state&#x3D;4bd0b9a389b4b229602346c33913b4c3c199628a90011ab3a901302ab62b3832
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="audience"> The unique identifier of the target API you want to access.</param>
        /// <param name="scope">The scopes which you want to request authorization for. These must be separated by a space. You can request any of the standard OpenID Connect (OIDC) scopes about users, such as profile and email, custom claims that must conform to a namespaced format, or any scopes supported by the target API (for example, read:contacts). Include offline_access to get a Refresh Token.</param>
        /// <param name="responseType">Indicates to Auth0 which OAuth 2.0 Flow you want to perform. Use code for Authorization Code Grant (PKCE) Flow.</param>
        /// <param name="clientId">Your application&#39;s Client ID.</param>
        /// <param name="codeChallengeMethod">Method used to generate the challenge. The PKCE spec defines two methods, S256 and plain, however, Auth0 supports only S256 since the latter is discouraged.</param>
        /// <param name="codeChallenge">Generated challenge from the code_verifier.</param>
        /// <param name="responseMode"></param>
        /// <param name="state">An opaque value the clients adds to the initial request that Auth0 includes when redirecting the back to the client. This value must be used by the client to prevent CSRF attacks. (optional)</param>
        /// <param name="redirectUri">The URL to which Auth0 will redirect the browser after authorization has been granted by the user. (optional)</param>
        /// <param name="connection">The name of the connection configured to your application. (optional)</param>
        /// <param name="prompt">To initiate a silent authentication request, use prompt&#x3D;none (see Remarks for more info). (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ResultedPKCE</returns>
        System.Threading.Tasks.Task<ResultedPKCE> AuthorizeAuth0Async(string audience, List<string> scope, string responseType, string clientId, string codeChallengeMethod, string codeChallenge, string responseMode, string state = default(string), string redirectUri = default(string), string connection = default(string), string prompt = default(string), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// https://auth.pieces.services/authorize [GET]
        /// </summary>
        /// <remarks>
        /// An endpoint that is used locally authenticate via a PKCE Flow.  Example https://auth.pieces.services /authorize?audience&#x3D;https%3A%2F%2Fpieces.us.auth0.com%2Fapi%2Fv2%2F&amp;scope&#x3D;email+profile+offline_access+openid&amp;response_type&#x3D;code&amp;client_id&#x3D;9sW4Pa1LEjX67l6VO14u0207NLYeXnu1&amp;redirect_uri&#x3D;http%3A%2F%2Flocalhost%3A3000%2Fpkce%2Fresponse%2Fcode&amp;code_challenge_method&#x3D;S256&amp;code_challenge&#x3D;yxRssZxdfBpMigRmDxAety1QU72Bd5WnDUbtlsCZOnk&amp;response_mode&#x3D;form_post&amp;state&#x3D;4bd0b9a389b4b229602346c33913b4c3c199628a90011ab3a901302ab62b3832
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="audience"> The unique identifier of the target API you want to access.</param>
        /// <param name="scope">The scopes which you want to request authorization for. These must be separated by a space. You can request any of the standard OpenID Connect (OIDC) scopes about users, such as profile and email, custom claims that must conform to a namespaced format, or any scopes supported by the target API (for example, read:contacts). Include offline_access to get a Refresh Token.</param>
        /// <param name="responseType">Indicates to Auth0 which OAuth 2.0 Flow you want to perform. Use code for Authorization Code Grant (PKCE) Flow.</param>
        /// <param name="clientId">Your application&#39;s Client ID.</param>
        /// <param name="codeChallengeMethod">Method used to generate the challenge. The PKCE spec defines two methods, S256 and plain, however, Auth0 supports only S256 since the latter is discouraged.</param>
        /// <param name="codeChallenge">Generated challenge from the code_verifier.</param>
        /// <param name="responseMode"></param>
        /// <param name="state">An opaque value the clients adds to the initial request that Auth0 includes when redirecting the back to the client. This value must be used by the client to prevent CSRF attacks. (optional)</param>
        /// <param name="redirectUri">The URL to which Auth0 will redirect the browser after authorization has been granted by the user. (optional)</param>
        /// <param name="connection">The name of the connection configured to your application. (optional)</param>
        /// <param name="prompt">To initiate a silent authentication request, use prompt&#x3D;none (see Remarks for more info). (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (ResultedPKCE)</returns>
        System.Threading.Tasks.Task<ApiResponse<ResultedPKCE>> AuthorizeAuth0WithHttpInfoAsync(string audience, List<string> scope, string responseType, string clientId, string codeChallengeMethod, string codeChallenge, string responseMode, string state = default(string), string redirectUri = default(string), string connection = default(string), string prompt = default(string), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// https://auth.pieces.services/oauth/token [POST]
        /// </summary>
        /// <remarks>
        /// An endpoint to generate a OAuth Token for an authentication flow. 
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="grantType">Denotes the flow you are using. For Authorization Code, use authorization_code or refresh_token.</param>
        /// <param name="clientId">Your application&#39;s Client ID.</param>
        /// <param name="code">The Authorization Code received from the initial /authorize call.</param>
        /// <param name="redirectUri">This is required only if it was set at the GET /authorize endpoint. The values must match.</param>
        /// <param name="codeVerifier">Cryptographically random key that was used to generate the code_challenge passed to /authorize.</param>
        /// <param name="schema"> (optional)</param>
        /// <param name="audience">The audience domain: i.e. https://pieces.us.auth0.com (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of OAuthToken</returns>
        System.Threading.Tasks.Task<OAuthToken> ExchangeForAuth0TokenAsync(string grantType, string clientId, string code, string redirectUri, string codeVerifier, EmbeddedModelSchema schema = default(EmbeddedModelSchema), string audience = default(string), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// https://auth.pieces.services/oauth/token [POST]
        /// </summary>
        /// <remarks>
        /// An endpoint to generate a OAuth Token for an authentication flow. 
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="grantType">Denotes the flow you are using. For Authorization Code, use authorization_code or refresh_token.</param>
        /// <param name="clientId">Your application&#39;s Client ID.</param>
        /// <param name="code">The Authorization Code received from the initial /authorize call.</param>
        /// <param name="redirectUri">This is required only if it was set at the GET /authorize endpoint. The values must match.</param>
        /// <param name="codeVerifier">Cryptographically random key that was used to generate the code_challenge passed to /authorize.</param>
        /// <param name="schema"> (optional)</param>
        /// <param name="audience">The audience domain: i.e. https://pieces.us.auth0.com (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (OAuthToken)</returns>
        System.Threading.Tasks.Task<ApiResponse<OAuthToken>> ExchangeForAuth0TokenWithHttpInfoAsync(string grantType, string clientId, string code, string redirectUri, string codeVerifier, EmbeddedModelSchema schema = default(EmbeddedModelSchema), string audience = default(string), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// https://auth.pieces.services/userinfo [GET]
        /// </summary>
        /// <remarks>
        /// Get the users info from the Auth0 API
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of Auth0User</returns>
        System.Threading.Tasks.Task<Auth0User> GetAuth0UserInfoAsync(int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// https://auth.pieces.services/userinfo [GET]
        /// </summary>
        /// <remarks>
        /// Get the users info from the Auth0 API
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (Auth0User)</returns>
        System.Threading.Tasks.Task<ApiResponse<Auth0User>> GetAuth0UserInfoWithHttpInfoAsync(int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        #endregion Asynchronous Operations
    }

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public interface IAuth0Api : IAuth0ApiSync, IAuth0ApiAsync
    {

    }

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public partial class Auth0Api : IAuth0Api
    {
        private Pieces.Os.Core.Client.ExceptionFactory _exceptionFactory = (name, response) => null;

        /// <summary>
        /// Initializes a new instance of the <see cref="Auth0Api"/> class.
        /// </summary>
        /// <returns></returns>
        public Auth0Api() : this((string)null)
        {
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="Auth0Api"/> class.
        /// </summary>
        /// <returns></returns>
        public Auth0Api(string basePath)
        {
            this.Configuration = Pieces.Os.Core.Client.Configuration.MergeConfigurations(
                Pieces.Os.Core.Client.GlobalConfiguration.Instance,
                new Pieces.Os.Core.Client.Configuration { BasePath = basePath }
            );
            this.Client = new Pieces.Os.Core.Client.ApiClient(this.Configuration.BasePath);
            this.AsynchronousClient = new Pieces.Os.Core.Client.ApiClient(this.Configuration.BasePath);
            this.ExceptionFactory = Pieces.Os.Core.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="Auth0Api"/> class
        /// using Configuration object
        /// </summary>
        /// <param name="configuration">An instance of Configuration</param>
        /// <returns></returns>
        public Auth0Api(Pieces.Os.Core.Client.Configuration configuration)
        {
            if (configuration == null) throw new ArgumentNullException("configuration");

            this.Configuration = Pieces.Os.Core.Client.Configuration.MergeConfigurations(
                Pieces.Os.Core.Client.GlobalConfiguration.Instance,
                configuration
            );
            this.Client = new Pieces.Os.Core.Client.ApiClient(this.Configuration.BasePath);
            this.AsynchronousClient = new Pieces.Os.Core.Client.ApiClient(this.Configuration.BasePath);
            ExceptionFactory = Pieces.Os.Core.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="Auth0Api"/> class
        /// using a Configuration object and client instance.
        /// </summary>
        /// <param name="client">The client interface for synchronous API access.</param>
        /// <param name="asyncClient">The client interface for asynchronous API access.</param>
        /// <param name="configuration">The configuration object.</param>
        public Auth0Api(Pieces.Os.Core.Client.ISynchronousClient client, Pieces.Os.Core.Client.IAsynchronousClient asyncClient, Pieces.Os.Core.Client.IReadableConfiguration configuration)
        {
            if (client == null) throw new ArgumentNullException("client");
            if (asyncClient == null) throw new ArgumentNullException("asyncClient");
            if (configuration == null) throw new ArgumentNullException("configuration");

            this.Client = client;
            this.AsynchronousClient = asyncClient;
            this.Configuration = configuration;
            this.ExceptionFactory = Pieces.Os.Core.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// The client for accessing this underlying API asynchronously.
        /// </summary>
        public Pieces.Os.Core.Client.IAsynchronousClient AsynchronousClient { get; set; }

        /// <summary>
        /// The client for accessing this underlying API synchronously.
        /// </summary>
        public Pieces.Os.Core.Client.ISynchronousClient Client { get; set; }

        /// <summary>
        /// Gets the base path of the API client.
        /// </summary>
        /// <value>The base path</value>
        public string GetBasePath()
        {
            return this.Configuration.BasePath;
        }

        /// <summary>
        /// Gets or sets the configuration object
        /// </summary>
        /// <value>An instance of the Configuration</value>
        public Pieces.Os.Core.Client.IReadableConfiguration Configuration { get; set; }

        /// <summary>
        /// Provides a factory method hook for the creation of exceptions.
        /// </summary>
        public Pieces.Os.Core.Client.ExceptionFactory ExceptionFactory
        {
            get
            {
                if (_exceptionFactory != null && _exceptionFactory.GetInvocationList().Length > 1)
                {
                    throw new InvalidOperationException("Multicast delegate for ExceptionFactory is unsupported.");
                }
                return _exceptionFactory;
            }
            set { _exceptionFactory = value; }
        }

        /// <summary>
        /// https://auth.pieces.services/v2/logout [GET] https://auth0.com/docs/api/authentication#logout
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="clientId">The client ID of the Auth0 Instance (optional)</param>
        /// <param name="returnTo">The URL that the logout endpoint will return to (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>string</returns>
        public string Auth0Logout(string clientId = default(string), string returnTo = default(string), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.ApiResponse<string> localVarResponse = Auth0LogoutWithHttpInfo(clientId, returnTo);
            return localVarResponse.Data;
        }

        /// <summary>
        /// https://auth.pieces.services/v2/logout [GET] https://auth0.com/docs/api/authentication#logout
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="clientId">The client ID of the Auth0 Instance (optional)</param>
        /// <param name="returnTo">The URL that the logout endpoint will return to (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of string</returns>
        public Pieces.Os.Core.Client.ApiResponse<string> Auth0LogoutWithHttpInfo(string clientId = default(string), string returnTo = default(string), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/html"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            if (clientId != null)
            {
                localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "client_id", clientId));
            }
            if (returnTo != null)
            {
                localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "returnTo", returnTo));
            }

            localVarRequestOptions.Operation = "Auth0Api.Auth0Logout";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Get<string>("/v2/logout", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("Auth0Logout", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// https://auth.pieces.services/v2/logout [GET] https://auth0.com/docs/api/authentication#logout
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="clientId">The client ID of the Auth0 Instance (optional)</param>
        /// <param name="returnTo">The URL that the logout endpoint will return to (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of string</returns>
        public async System.Threading.Tasks.Task<string> Auth0LogoutAsync(string clientId = default(string), string returnTo = default(string), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            Pieces.Os.Core.Client.ApiResponse<string> localVarResponse = await Auth0LogoutWithHttpInfoAsync(clientId, returnTo, operationIndex, cancellationToken).ConfigureAwait(false);
            return localVarResponse.Data;
        }

        /// <summary>
        /// https://auth.pieces.services/v2/logout [GET] https://auth0.com/docs/api/authentication#logout
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="clientId">The client ID of the Auth0 Instance (optional)</param>
        /// <param name="returnTo">The URL that the logout endpoint will return to (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (string)</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<string>> Auth0LogoutWithHttpInfoAsync(string clientId = default(string), string returnTo = default(string), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/html"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            if (clientId != null)
            {
                localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "client_id", clientId));
            }
            if (returnTo != null)
            {
                localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "returnTo", returnTo));
            }

            localVarRequestOptions.Operation = "Auth0Api.Auth0Logout";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.GetAsync<string>("/v2/logout", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("Auth0Logout", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// https://auth.pieces.services/authorize [GET] An endpoint that is used locally authenticate via a PKCE Flow.  Example https://auth.pieces.services /authorize?audience&#x3D;https%3A%2F%2Fpieces.us.auth0.com%2Fapi%2Fv2%2F&amp;scope&#x3D;email+profile+offline_access+openid&amp;response_type&#x3D;code&amp;client_id&#x3D;9sW4Pa1LEjX67l6VO14u0207NLYeXnu1&amp;redirect_uri&#x3D;http%3A%2F%2Flocalhost%3A3000%2Fpkce%2Fresponse%2Fcode&amp;code_challenge_method&#x3D;S256&amp;code_challenge&#x3D;yxRssZxdfBpMigRmDxAety1QU72Bd5WnDUbtlsCZOnk&amp;response_mode&#x3D;form_post&amp;state&#x3D;4bd0b9a389b4b229602346c33913b4c3c199628a90011ab3a901302ab62b3832
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="audience"> The unique identifier of the target API you want to access.</param>
        /// <param name="scope">The scopes which you want to request authorization for. These must be separated by a space. You can request any of the standard OpenID Connect (OIDC) scopes about users, such as profile and email, custom claims that must conform to a namespaced format, or any scopes supported by the target API (for example, read:contacts). Include offline_access to get a Refresh Token.</param>
        /// <param name="responseType">Indicates to Auth0 which OAuth 2.0 Flow you want to perform. Use code for Authorization Code Grant (PKCE) Flow.</param>
        /// <param name="clientId">Your application&#39;s Client ID.</param>
        /// <param name="codeChallengeMethod">Method used to generate the challenge. The PKCE spec defines two methods, S256 and plain, however, Auth0 supports only S256 since the latter is discouraged.</param>
        /// <param name="codeChallenge">Generated challenge from the code_verifier.</param>
        /// <param name="responseMode"></param>
        /// <param name="state">An opaque value the clients adds to the initial request that Auth0 includes when redirecting the back to the client. This value must be used by the client to prevent CSRF attacks. (optional)</param>
        /// <param name="redirectUri">The URL to which Auth0 will redirect the browser after authorization has been granted by the user. (optional)</param>
        /// <param name="connection">The name of the connection configured to your application. (optional)</param>
        /// <param name="prompt">To initiate a silent authentication request, use prompt&#x3D;none (see Remarks for more info). (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ResultedPKCE</returns>
        public ResultedPKCE AuthorizeAuth0(string audience, List<string> scope, string responseType, string clientId, string codeChallengeMethod, string codeChallenge, string responseMode, string state = default(string), string redirectUri = default(string), string connection = default(string), string prompt = default(string), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.ApiResponse<ResultedPKCE> localVarResponse = AuthorizeAuth0WithHttpInfo(audience, scope, responseType, clientId, codeChallengeMethod, codeChallenge, responseMode, state, redirectUri, connection, prompt);
            return localVarResponse.Data;
        }

        /// <summary>
        /// https://auth.pieces.services/authorize [GET] An endpoint that is used locally authenticate via a PKCE Flow.  Example https://auth.pieces.services /authorize?audience&#x3D;https%3A%2F%2Fpieces.us.auth0.com%2Fapi%2Fv2%2F&amp;scope&#x3D;email+profile+offline_access+openid&amp;response_type&#x3D;code&amp;client_id&#x3D;9sW4Pa1LEjX67l6VO14u0207NLYeXnu1&amp;redirect_uri&#x3D;http%3A%2F%2Flocalhost%3A3000%2Fpkce%2Fresponse%2Fcode&amp;code_challenge_method&#x3D;S256&amp;code_challenge&#x3D;yxRssZxdfBpMigRmDxAety1QU72Bd5WnDUbtlsCZOnk&amp;response_mode&#x3D;form_post&amp;state&#x3D;4bd0b9a389b4b229602346c33913b4c3c199628a90011ab3a901302ab62b3832
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="audience"> The unique identifier of the target API you want to access.</param>
        /// <param name="scope">The scopes which you want to request authorization for. These must be separated by a space. You can request any of the standard OpenID Connect (OIDC) scopes about users, such as profile and email, custom claims that must conform to a namespaced format, or any scopes supported by the target API (for example, read:contacts). Include offline_access to get a Refresh Token.</param>
        /// <param name="responseType">Indicates to Auth0 which OAuth 2.0 Flow you want to perform. Use code for Authorization Code Grant (PKCE) Flow.</param>
        /// <param name="clientId">Your application&#39;s Client ID.</param>
        /// <param name="codeChallengeMethod">Method used to generate the challenge. The PKCE spec defines two methods, S256 and plain, however, Auth0 supports only S256 since the latter is discouraged.</param>
        /// <param name="codeChallenge">Generated challenge from the code_verifier.</param>
        /// <param name="responseMode"></param>
        /// <param name="state">An opaque value the clients adds to the initial request that Auth0 includes when redirecting the back to the client. This value must be used by the client to prevent CSRF attacks. (optional)</param>
        /// <param name="redirectUri">The URL to which Auth0 will redirect the browser after authorization has been granted by the user. (optional)</param>
        /// <param name="connection">The name of the connection configured to your application. (optional)</param>
        /// <param name="prompt">To initiate a silent authentication request, use prompt&#x3D;none (see Remarks for more info). (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of ResultedPKCE</returns>
        public Pieces.Os.Core.Client.ApiResponse<ResultedPKCE> AuthorizeAuth0WithHttpInfo(string audience, List<string> scope, string responseType, string clientId, string codeChallengeMethod, string codeChallenge, string responseMode, string state = default(string), string redirectUri = default(string), string connection = default(string), string prompt = default(string), int operationIndex = 0)
        {
            // verify the required parameter 'audience' is set
            if (audience == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'audience' when calling Auth0Api->AuthorizeAuth0");
            }

            // verify the required parameter 'scope' is set
            if (scope == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'scope' when calling Auth0Api->AuthorizeAuth0");
            }

            // verify the required parameter 'responseType' is set
            if (responseType == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'responseType' when calling Auth0Api->AuthorizeAuth0");
            }

            // verify the required parameter 'clientId' is set
            if (clientId == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'clientId' when calling Auth0Api->AuthorizeAuth0");
            }

            // verify the required parameter 'codeChallengeMethod' is set
            if (codeChallengeMethod == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'codeChallengeMethod' when calling Auth0Api->AuthorizeAuth0");
            }

            // verify the required parameter 'codeChallenge' is set
            if (codeChallenge == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'codeChallenge' when calling Auth0Api->AuthorizeAuth0");
            }

            // verify the required parameter 'responseMode' is set
            if (responseMode == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'responseMode' when calling Auth0Api->AuthorizeAuth0");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/x-www-form-urlencoded"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "audience", audience));
            localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("ssv", "scope", scope));
            localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "response_type", responseType));
            localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "client_id", clientId));
            if (state != null)
            {
                localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "state", state));
            }
            if (redirectUri != null)
            {
                localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "redirect_uri", redirectUri));
            }
            localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "code_challenge_method", codeChallengeMethod));
            localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "code_challenge", codeChallenge));
            if (connection != null)
            {
                localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "connection", connection));
            }
            if (prompt != null)
            {
                localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "prompt", prompt));
            }
            localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "response_mode", responseMode));

            localVarRequestOptions.Operation = "Auth0Api.AuthorizeAuth0";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Get<ResultedPKCE>("/authorize", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("AuthorizeAuth0", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// https://auth.pieces.services/authorize [GET] An endpoint that is used locally authenticate via a PKCE Flow.  Example https://auth.pieces.services /authorize?audience&#x3D;https%3A%2F%2Fpieces.us.auth0.com%2Fapi%2Fv2%2F&amp;scope&#x3D;email+profile+offline_access+openid&amp;response_type&#x3D;code&amp;client_id&#x3D;9sW4Pa1LEjX67l6VO14u0207NLYeXnu1&amp;redirect_uri&#x3D;http%3A%2F%2Flocalhost%3A3000%2Fpkce%2Fresponse%2Fcode&amp;code_challenge_method&#x3D;S256&amp;code_challenge&#x3D;yxRssZxdfBpMigRmDxAety1QU72Bd5WnDUbtlsCZOnk&amp;response_mode&#x3D;form_post&amp;state&#x3D;4bd0b9a389b4b229602346c33913b4c3c199628a90011ab3a901302ab62b3832
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="audience"> The unique identifier of the target API you want to access.</param>
        /// <param name="scope">The scopes which you want to request authorization for. These must be separated by a space. You can request any of the standard OpenID Connect (OIDC) scopes about users, such as profile and email, custom claims that must conform to a namespaced format, or any scopes supported by the target API (for example, read:contacts). Include offline_access to get a Refresh Token.</param>
        /// <param name="responseType">Indicates to Auth0 which OAuth 2.0 Flow you want to perform. Use code for Authorization Code Grant (PKCE) Flow.</param>
        /// <param name="clientId">Your application&#39;s Client ID.</param>
        /// <param name="codeChallengeMethod">Method used to generate the challenge. The PKCE spec defines two methods, S256 and plain, however, Auth0 supports only S256 since the latter is discouraged.</param>
        /// <param name="codeChallenge">Generated challenge from the code_verifier.</param>
        /// <param name="responseMode"></param>
        /// <param name="state">An opaque value the clients adds to the initial request that Auth0 includes when redirecting the back to the client. This value must be used by the client to prevent CSRF attacks. (optional)</param>
        /// <param name="redirectUri">The URL to which Auth0 will redirect the browser after authorization has been granted by the user. (optional)</param>
        /// <param name="connection">The name of the connection configured to your application. (optional)</param>
        /// <param name="prompt">To initiate a silent authentication request, use prompt&#x3D;none (see Remarks for more info). (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ResultedPKCE</returns>
        public async System.Threading.Tasks.Task<ResultedPKCE> AuthorizeAuth0Async(string audience, List<string> scope, string responseType, string clientId, string codeChallengeMethod, string codeChallenge, string responseMode, string state = default(string), string redirectUri = default(string), string connection = default(string), string prompt = default(string), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            Pieces.Os.Core.Client.ApiResponse<ResultedPKCE> localVarResponse = await AuthorizeAuth0WithHttpInfoAsync(audience, scope, responseType, clientId, codeChallengeMethod, codeChallenge, responseMode, state, redirectUri, connection, prompt, operationIndex, cancellationToken).ConfigureAwait(false);
            return localVarResponse.Data;
        }

        /// <summary>
        /// https://auth.pieces.services/authorize [GET] An endpoint that is used locally authenticate via a PKCE Flow.  Example https://auth.pieces.services /authorize?audience&#x3D;https%3A%2F%2Fpieces.us.auth0.com%2Fapi%2Fv2%2F&amp;scope&#x3D;email+profile+offline_access+openid&amp;response_type&#x3D;code&amp;client_id&#x3D;9sW4Pa1LEjX67l6VO14u0207NLYeXnu1&amp;redirect_uri&#x3D;http%3A%2F%2Flocalhost%3A3000%2Fpkce%2Fresponse%2Fcode&amp;code_challenge_method&#x3D;S256&amp;code_challenge&#x3D;yxRssZxdfBpMigRmDxAety1QU72Bd5WnDUbtlsCZOnk&amp;response_mode&#x3D;form_post&amp;state&#x3D;4bd0b9a389b4b229602346c33913b4c3c199628a90011ab3a901302ab62b3832
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="audience"> The unique identifier of the target API you want to access.</param>
        /// <param name="scope">The scopes which you want to request authorization for. These must be separated by a space. You can request any of the standard OpenID Connect (OIDC) scopes about users, such as profile and email, custom claims that must conform to a namespaced format, or any scopes supported by the target API (for example, read:contacts). Include offline_access to get a Refresh Token.</param>
        /// <param name="responseType">Indicates to Auth0 which OAuth 2.0 Flow you want to perform. Use code for Authorization Code Grant (PKCE) Flow.</param>
        /// <param name="clientId">Your application&#39;s Client ID.</param>
        /// <param name="codeChallengeMethod">Method used to generate the challenge. The PKCE spec defines two methods, S256 and plain, however, Auth0 supports only S256 since the latter is discouraged.</param>
        /// <param name="codeChallenge">Generated challenge from the code_verifier.</param>
        /// <param name="responseMode"></param>
        /// <param name="state">An opaque value the clients adds to the initial request that Auth0 includes when redirecting the back to the client. This value must be used by the client to prevent CSRF attacks. (optional)</param>
        /// <param name="redirectUri">The URL to which Auth0 will redirect the browser after authorization has been granted by the user. (optional)</param>
        /// <param name="connection">The name of the connection configured to your application. (optional)</param>
        /// <param name="prompt">To initiate a silent authentication request, use prompt&#x3D;none (see Remarks for more info). (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (ResultedPKCE)</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<ResultedPKCE>> AuthorizeAuth0WithHttpInfoAsync(string audience, List<string> scope, string responseType, string clientId, string codeChallengeMethod, string codeChallenge, string responseMode, string state = default(string), string redirectUri = default(string), string connection = default(string), string prompt = default(string), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'audience' is set
            if (audience == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'audience' when calling Auth0Api->AuthorizeAuth0");
            }

            // verify the required parameter 'scope' is set
            if (scope == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'scope' when calling Auth0Api->AuthorizeAuth0");
            }

            // verify the required parameter 'responseType' is set
            if (responseType == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'responseType' when calling Auth0Api->AuthorizeAuth0");
            }

            // verify the required parameter 'clientId' is set
            if (clientId == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'clientId' when calling Auth0Api->AuthorizeAuth0");
            }

            // verify the required parameter 'codeChallengeMethod' is set
            if (codeChallengeMethod == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'codeChallengeMethod' when calling Auth0Api->AuthorizeAuth0");
            }

            // verify the required parameter 'codeChallenge' is set
            if (codeChallenge == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'codeChallenge' when calling Auth0Api->AuthorizeAuth0");
            }

            // verify the required parameter 'responseMode' is set
            if (responseMode == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'responseMode' when calling Auth0Api->AuthorizeAuth0");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/x-www-form-urlencoded"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "audience", audience));
            localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("ssv", "scope", scope));
            localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "response_type", responseType));
            localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "client_id", clientId));
            if (state != null)
            {
                localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "state", state));
            }
            if (redirectUri != null)
            {
                localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "redirect_uri", redirectUri));
            }
            localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "code_challenge_method", codeChallengeMethod));
            localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "code_challenge", codeChallenge));
            if (connection != null)
            {
                localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "connection", connection));
            }
            if (prompt != null)
            {
                localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "prompt", prompt));
            }
            localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "response_mode", responseMode));

            localVarRequestOptions.Operation = "Auth0Api.AuthorizeAuth0";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.GetAsync<ResultedPKCE>("/authorize", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("AuthorizeAuth0", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// https://auth.pieces.services/oauth/token [POST] An endpoint to generate a OAuth Token for an authentication flow. 
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="grantType">Denotes the flow you are using. For Authorization Code, use authorization_code or refresh_token.</param>
        /// <param name="clientId">Your application&#39;s Client ID.</param>
        /// <param name="code">The Authorization Code received from the initial /authorize call.</param>
        /// <param name="redirectUri">This is required only if it was set at the GET /authorize endpoint. The values must match.</param>
        /// <param name="codeVerifier">Cryptographically random key that was used to generate the code_challenge passed to /authorize.</param>
        /// <param name="schema"> (optional)</param>
        /// <param name="audience">The audience domain: i.e. https://pieces.us.auth0.com (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>OAuthToken</returns>
        public OAuthToken ExchangeForAuth0Token(string grantType, string clientId, string code, string redirectUri, string codeVerifier, EmbeddedModelSchema schema = default(EmbeddedModelSchema), string audience = default(string), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.ApiResponse<OAuthToken> localVarResponse = ExchangeForAuth0TokenWithHttpInfo(grantType, clientId, code, redirectUri, codeVerifier, schema, audience);
            return localVarResponse.Data;
        }

        /// <summary>
        /// https://auth.pieces.services/oauth/token [POST] An endpoint to generate a OAuth Token for an authentication flow. 
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="grantType">Denotes the flow you are using. For Authorization Code, use authorization_code or refresh_token.</param>
        /// <param name="clientId">Your application&#39;s Client ID.</param>
        /// <param name="code">The Authorization Code received from the initial /authorize call.</param>
        /// <param name="redirectUri">This is required only if it was set at the GET /authorize endpoint. The values must match.</param>
        /// <param name="codeVerifier">Cryptographically random key that was used to generate the code_challenge passed to /authorize.</param>
        /// <param name="schema"> (optional)</param>
        /// <param name="audience">The audience domain: i.e. https://pieces.us.auth0.com (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of OAuthToken</returns>
        public Pieces.Os.Core.Client.ApiResponse<OAuthToken> ExchangeForAuth0TokenWithHttpInfo(string grantType, string clientId, string code, string redirectUri, string codeVerifier, EmbeddedModelSchema schema = default(EmbeddedModelSchema), string audience = default(string), int operationIndex = 0)
        {
            // verify the required parameter 'grantType' is set
            if (grantType == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'grantType' when calling Auth0Api->ExchangeForAuth0Token");
            }

            // verify the required parameter 'clientId' is set
            if (clientId == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'clientId' when calling Auth0Api->ExchangeForAuth0Token");
            }

            // verify the required parameter 'code' is set
            if (code == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'code' when calling Auth0Api->ExchangeForAuth0Token");
            }

            // verify the required parameter 'redirectUri' is set
            if (redirectUri == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'redirectUri' when calling Auth0Api->ExchangeForAuth0Token");
            }

            // verify the required parameter 'codeVerifier' is set
            if (codeVerifier == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'codeVerifier' when calling Auth0Api->ExchangeForAuth0Token");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/x-www-form-urlencoded"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            if (schema != null)
            {
                localVarRequestOptions.FormParameters.Add("schema", Pieces.Os.Core.Client.ClientUtils.Serialize(schema)); // form parameter
            }
            localVarRequestOptions.FormParameters.Add("grant_type", Pieces.Os.Core.Client.ClientUtils.ParameterToString(grantType)); // form parameter
            localVarRequestOptions.FormParameters.Add("client_id", Pieces.Os.Core.Client.ClientUtils.ParameterToString(clientId)); // form parameter
            localVarRequestOptions.FormParameters.Add("code", Pieces.Os.Core.Client.ClientUtils.ParameterToString(code)); // form parameter
            localVarRequestOptions.FormParameters.Add("redirect_uri", Pieces.Os.Core.Client.ClientUtils.ParameterToString(redirectUri)); // form parameter
            localVarRequestOptions.FormParameters.Add("code_verifier", Pieces.Os.Core.Client.ClientUtils.ParameterToString(codeVerifier)); // form parameter
            if (audience != null)
            {
                localVarRequestOptions.FormParameters.Add("audience", Pieces.Os.Core.Client.ClientUtils.ParameterToString(audience)); // form parameter
            }

            localVarRequestOptions.Operation = "Auth0Api.ExchangeForAuth0Token";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<OAuthToken>("/oauth/token", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("ExchangeForAuth0Token", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// https://auth.pieces.services/oauth/token [POST] An endpoint to generate a OAuth Token for an authentication flow. 
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="grantType">Denotes the flow you are using. For Authorization Code, use authorization_code or refresh_token.</param>
        /// <param name="clientId">Your application&#39;s Client ID.</param>
        /// <param name="code">The Authorization Code received from the initial /authorize call.</param>
        /// <param name="redirectUri">This is required only if it was set at the GET /authorize endpoint. The values must match.</param>
        /// <param name="codeVerifier">Cryptographically random key that was used to generate the code_challenge passed to /authorize.</param>
        /// <param name="schema"> (optional)</param>
        /// <param name="audience">The audience domain: i.e. https://pieces.us.auth0.com (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of OAuthToken</returns>
        public async System.Threading.Tasks.Task<OAuthToken> ExchangeForAuth0TokenAsync(string grantType, string clientId, string code, string redirectUri, string codeVerifier, EmbeddedModelSchema schema = default(EmbeddedModelSchema), string audience = default(string), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            Pieces.Os.Core.Client.ApiResponse<OAuthToken> localVarResponse = await ExchangeForAuth0TokenWithHttpInfoAsync(grantType, clientId, code, redirectUri, codeVerifier, schema, audience, operationIndex, cancellationToken).ConfigureAwait(false);
            return localVarResponse.Data;
        }

        /// <summary>
        /// https://auth.pieces.services/oauth/token [POST] An endpoint to generate a OAuth Token for an authentication flow. 
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="grantType">Denotes the flow you are using. For Authorization Code, use authorization_code or refresh_token.</param>
        /// <param name="clientId">Your application&#39;s Client ID.</param>
        /// <param name="code">The Authorization Code received from the initial /authorize call.</param>
        /// <param name="redirectUri">This is required only if it was set at the GET /authorize endpoint. The values must match.</param>
        /// <param name="codeVerifier">Cryptographically random key that was used to generate the code_challenge passed to /authorize.</param>
        /// <param name="schema"> (optional)</param>
        /// <param name="audience">The audience domain: i.e. https://pieces.us.auth0.com (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (OAuthToken)</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<OAuthToken>> ExchangeForAuth0TokenWithHttpInfoAsync(string grantType, string clientId, string code, string redirectUri, string codeVerifier, EmbeddedModelSchema schema = default(EmbeddedModelSchema), string audience = default(string), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'grantType' is set
            if (grantType == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'grantType' when calling Auth0Api->ExchangeForAuth0Token");
            }

            // verify the required parameter 'clientId' is set
            if (clientId == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'clientId' when calling Auth0Api->ExchangeForAuth0Token");
            }

            // verify the required parameter 'code' is set
            if (code == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'code' when calling Auth0Api->ExchangeForAuth0Token");
            }

            // verify the required parameter 'redirectUri' is set
            if (redirectUri == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'redirectUri' when calling Auth0Api->ExchangeForAuth0Token");
            }

            // verify the required parameter 'codeVerifier' is set
            if (codeVerifier == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'codeVerifier' when calling Auth0Api->ExchangeForAuth0Token");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/x-www-form-urlencoded"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            if (schema != null)
            {
                localVarRequestOptions.FormParameters.Add("schema", Pieces.Os.Core.Client.ClientUtils.Serialize(schema)); // form parameter
            }
            localVarRequestOptions.FormParameters.Add("grant_type", Pieces.Os.Core.Client.ClientUtils.ParameterToString(grantType)); // form parameter
            localVarRequestOptions.FormParameters.Add("client_id", Pieces.Os.Core.Client.ClientUtils.ParameterToString(clientId)); // form parameter
            localVarRequestOptions.FormParameters.Add("code", Pieces.Os.Core.Client.ClientUtils.ParameterToString(code)); // form parameter
            localVarRequestOptions.FormParameters.Add("redirect_uri", Pieces.Os.Core.Client.ClientUtils.ParameterToString(redirectUri)); // form parameter
            localVarRequestOptions.FormParameters.Add("code_verifier", Pieces.Os.Core.Client.ClientUtils.ParameterToString(codeVerifier)); // form parameter
            if (audience != null)
            {
                localVarRequestOptions.FormParameters.Add("audience", Pieces.Os.Core.Client.ClientUtils.ParameterToString(audience)); // form parameter
            }

            localVarRequestOptions.Operation = "Auth0Api.ExchangeForAuth0Token";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<OAuthToken>("/oauth/token", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("ExchangeForAuth0Token", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// https://auth.pieces.services/userinfo [GET] Get the users info from the Auth0 API
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>Auth0User</returns>
        public Auth0User GetAuth0UserInfo(int operationIndex = 0)
        {
            Pieces.Os.Core.Client.ApiResponse<Auth0User> localVarResponse = GetAuth0UserInfoWithHttpInfo();
            return localVarResponse.Data;
        }

        /// <summary>
        /// https://auth.pieces.services/userinfo [GET] Get the users info from the Auth0 API
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Auth0User</returns>
        public Pieces.Os.Core.Client.ApiResponse<Auth0User> GetAuth0UserInfoWithHttpInfo(int operationIndex = 0)
        {
            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }


            localVarRequestOptions.Operation = "Auth0Api.GetAuth0UserInfo";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (auth0) required
            // oauth required
            if (!localVarRequestOptions.HeaderParameters.ContainsKey("Authorization"))
            {
                if (!string.IsNullOrEmpty(this.Configuration.AccessToken))
                {
                    localVarRequestOptions.HeaderParameters.Add("Authorization", "Bearer " + this.Configuration.AccessToken);
                }
                else if (!string.IsNullOrEmpty(this.Configuration.OAuthTokenUrl) &&
                         !string.IsNullOrEmpty(this.Configuration.OAuthClientId) &&
                         !string.IsNullOrEmpty(this.Configuration.OAuthClientSecret) &&
                         this.Configuration.OAuthFlow != null)
                {
                    localVarRequestOptions.OAuth = true;
                }
            }
            // authentication (auth0) required
            // oauth required
            if (!localVarRequestOptions.HeaderParameters.ContainsKey("Authorization"))
            {
                if (!string.IsNullOrEmpty(this.Configuration.AccessToken))
                {
                    localVarRequestOptions.HeaderParameters.Add("Authorization", "Bearer " + this.Configuration.AccessToken);
                }
                else if (!string.IsNullOrEmpty(this.Configuration.OAuthTokenUrl) &&
                         !string.IsNullOrEmpty(this.Configuration.OAuthClientId) &&
                         !string.IsNullOrEmpty(this.Configuration.OAuthClientSecret) &&
                         this.Configuration.OAuthFlow != null)
                {
                    localVarRequestOptions.OAuth = true;
                }
            }
            // authentication (auth0) required
            // oauth required
            if (!localVarRequestOptions.HeaderParameters.ContainsKey("Authorization"))
            {
                if (!string.IsNullOrEmpty(this.Configuration.AccessToken))
                {
                    localVarRequestOptions.HeaderParameters.Add("Authorization", "Bearer " + this.Configuration.AccessToken);
                }
                else if (!string.IsNullOrEmpty(this.Configuration.OAuthTokenUrl) &&
                         !string.IsNullOrEmpty(this.Configuration.OAuthClientId) &&
                         !string.IsNullOrEmpty(this.Configuration.OAuthClientSecret) &&
                         this.Configuration.OAuthFlow != null)
                {
                    localVarRequestOptions.OAuth = true;
                }
            }

            // make the HTTP request
            var localVarResponse = this.Client.Get<Auth0User>("/userinfo", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("GetAuth0UserInfo", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// https://auth.pieces.services/userinfo [GET] Get the users info from the Auth0 API
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of Auth0User</returns>
        public async System.Threading.Tasks.Task<Auth0User> GetAuth0UserInfoAsync(int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            Pieces.Os.Core.Client.ApiResponse<Auth0User> localVarResponse = await GetAuth0UserInfoWithHttpInfoAsync(operationIndex, cancellationToken).ConfigureAwait(false);
            return localVarResponse.Data;
        }

        /// <summary>
        /// https://auth.pieces.services/userinfo [GET] Get the users info from the Auth0 API
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (Auth0User)</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Auth0User>> GetAuth0UserInfoWithHttpInfoAsync(int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }


            localVarRequestOptions.Operation = "Auth0Api.GetAuth0UserInfo";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (auth0) required
            // oauth required
            if (!localVarRequestOptions.HeaderParameters.ContainsKey("Authorization"))
            {
                if (!string.IsNullOrEmpty(this.Configuration.AccessToken))
                {
                    localVarRequestOptions.HeaderParameters.Add("Authorization", "Bearer " + this.Configuration.AccessToken);
                }
                else if (!string.IsNullOrEmpty(this.Configuration.OAuthTokenUrl) &&
                         !string.IsNullOrEmpty(this.Configuration.OAuthClientId) &&
                         !string.IsNullOrEmpty(this.Configuration.OAuthClientSecret) &&
                         this.Configuration.OAuthFlow != null)
                {
                    localVarRequestOptions.OAuth = true;
                }
            }
            // authentication (auth0) required
            // oauth required
            if (!localVarRequestOptions.HeaderParameters.ContainsKey("Authorization"))
            {
                if (!string.IsNullOrEmpty(this.Configuration.AccessToken))
                {
                    localVarRequestOptions.HeaderParameters.Add("Authorization", "Bearer " + this.Configuration.AccessToken);
                }
                else if (!string.IsNullOrEmpty(this.Configuration.OAuthTokenUrl) &&
                         !string.IsNullOrEmpty(this.Configuration.OAuthClientId) &&
                         !string.IsNullOrEmpty(this.Configuration.OAuthClientSecret) &&
                         this.Configuration.OAuthFlow != null)
                {
                    localVarRequestOptions.OAuth = true;
                }
            }
            // authentication (auth0) required
            // oauth required
            if (!localVarRequestOptions.HeaderParameters.ContainsKey("Authorization"))
            {
                if (!string.IsNullOrEmpty(this.Configuration.AccessToken))
                {
                    localVarRequestOptions.HeaderParameters.Add("Authorization", "Bearer " + this.Configuration.AccessToken);
                }
                else if (!string.IsNullOrEmpty(this.Configuration.OAuthTokenUrl) &&
                         !string.IsNullOrEmpty(this.Configuration.OAuthClientId) &&
                         !string.IsNullOrEmpty(this.Configuration.OAuthClientSecret) &&
                         this.Configuration.OAuthFlow != null)
                {
                    localVarRequestOptions.OAuth = true;
                }
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.GetAsync<Auth0User>("/userinfo", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("GetAuth0UserInfo", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

    }
}
