/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Net;
using System.Net.Mime;
using Pieces.Os.Core.Client;
using Pieces.Os.Core.Client.Auth;
using Pieces.Os.Core.SdkModel;

namespace Pieces.Os.Core.Api
{

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public interface IAssetApiSync : IApiAccessor
    {
        #region Synchronous Operations
        /// <summary>
        /// /asset/{asset}/persons/associate/{anchor} [POST]
        /// </summary>
        /// <remarks>
        /// associates an anchor and an asset. It performs the same action as the anchor equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        void AssetAssociateAnchor(Guid asset, string anchor, int operationIndex = 0);

        /// <summary>
        /// /asset/{asset}/persons/associate/{anchor} [POST]
        /// </summary>
        /// <remarks>
        /// associates an anchor and an asset. It performs the same action as the anchor equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> AssetAssociateAnchorWithHttpInfo(Guid asset, string anchor, int operationIndex = 0);
        /// <summary>
        /// /asset/{asset}/conversations/associate/{conversation} [POST]
        /// </summary>
        /// <remarks>
        /// associates a conversation and an asset. It performs the same action as the conversation equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        void AssetAssociateConversation(Guid asset, string conversation, int operationIndex = 0);

        /// <summary>
        /// /asset/{asset}/conversations/associate/{conversation} [POST]
        /// </summary>
        /// <remarks>
        /// associates a conversation and an asset. It performs the same action as the conversation equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> AssetAssociateConversationWithHttpInfo(Guid asset, string conversation, int operationIndex = 0);
        /// <summary>
        /// /asset/{asset}/hints/associate/{hint} [POST]
        /// </summary>
        /// <remarks>
        /// associates an asset and a hint. It performs the same action as the hint equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="hint">This is a specific hint uuid</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        void AssetAssociateHint(Guid asset, string hint, int operationIndex = 0);

        /// <summary>
        /// /asset/{asset}/hints/associate/{hint} [POST]
        /// </summary>
        /// <remarks>
        /// associates an asset and a hint. It performs the same action as the hint equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="hint">This is a specific hint uuid</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> AssetAssociateHintWithHttpInfo(Guid asset, string hint, int operationIndex = 0);
        /// <summary>
        /// /asset/{asset}/persons/associate/{person} [POST]
        /// </summary>
        /// <remarks>
        /// associates a person and an asset. It performs the same action as the person equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="person">This is a uuid that represents a person.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        void AssetAssociatePerson(Guid asset, string person, int operationIndex = 0);

        /// <summary>
        /// /asset/{asset}/persons/associate/{person} [POST]
        /// </summary>
        /// <remarks>
        /// associates a person and an asset. It performs the same action as the person equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="person">This is a uuid that represents a person.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> AssetAssociatePersonWithHttpInfo(Guid asset, string person, int operationIndex = 0);
        /// <summary>
        /// /asset/{asset}/tags/associate/{tag} [POST]
        /// </summary>
        /// <remarks>
        /// Associates a tag with a specified asset. It performs the same action as the tag equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="tag">tag id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        void AssetAssociateTag(Guid asset, string tag, int operationIndex = 0);

        /// <summary>
        /// /asset/{asset}/tags/associate/{tag} [POST]
        /// </summary>
        /// <remarks>
        /// Associates a tag with a specified asset. It performs the same action as the tag equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="tag">tag id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> AssetAssociateTagWithHttpInfo(Guid asset, string tag, int operationIndex = 0);
        /// <summary>
        /// /asset/{asset}/websites/associate/{website} [POST]
        /// </summary>
        /// <remarks>
        /// Associates a website with an asset. It performs the same action as its website equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="website">website id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        void AssetAssociateWebsite(Guid asset, string website, int operationIndex = 0);

        /// <summary>
        /// /asset/{asset}/websites/associate/{website} [POST]
        /// </summary>
        /// <remarks>
        /// Associates a website with an asset. It performs the same action as its website equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="website">website id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> AssetAssociateWebsiteWithHttpInfo(Guid asset, string website, int operationIndex = 0);
        /// <summary>
        /// /asset/{asset}/workstream_summaries/associate/{workstream_summary} [POST]
        /// </summary>
        /// <remarks>
        /// This will associate a asset with a workstream summary. This will do the same thing as the workstreamSummary equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="workstreamSummary">This is a identifier that is used to identify a specific workstream_summary.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        void AssetAssociateWorkstreamSummary(Guid asset, string workstreamSummary, int operationIndex = 0);

        /// <summary>
        /// /asset/{asset}/workstream_summaries/associate/{workstream_summary} [POST]
        /// </summary>
        /// <remarks>
        /// This will associate a asset with a workstream summary. This will do the same thing as the workstreamSummary equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="workstreamSummary">This is a identifier that is used to identify a specific workstream_summary.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> AssetAssociateWorkstreamSummaryWithHttpInfo(Guid asset, string workstreamSummary, int operationIndex = 0);
        /// <summary>
        /// /asset/{asset}/anchors/disassociate/{anchor} [POST]
        /// </summary>
        /// <remarks>
        /// Disassociates a anchor from an asset. It performs the same action as the anchor equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        void AssetDisassociateAnchor(Guid asset, string anchor, int operationIndex = 0);

        /// <summary>
        /// /asset/{asset}/anchors/disassociate/{anchor} [POST]
        /// </summary>
        /// <remarks>
        /// Disassociates a anchor from an asset. It performs the same action as the anchor equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> AssetDisassociateAnchorWithHttpInfo(Guid asset, string anchor, int operationIndex = 0);
        /// <summary>
        /// /asset/{asset}/conversations/disassociate/{conversation} [POST]
        /// </summary>
        /// <remarks>
        /// Disassociates a conversation from an asset. It performs the same action as the conversation equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        void AssetDisassociateConversation(Guid asset, string conversation, int operationIndex = 0);

        /// <summary>
        /// /asset/{asset}/conversations/disassociate/{conversation} [POST]
        /// </summary>
        /// <remarks>
        /// Disassociates a conversation from an asset. It performs the same action as the conversation equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> AssetDisassociateConversationWithHttpInfo(Guid asset, string conversation, int operationIndex = 0);
        /// <summary>
        /// /asset/{asset}/hints/disassociate/{hint} [POST]
        /// </summary>
        /// <remarks>
        /// Disassociates an asset from a hint. It performs the same action as the hint equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="hint">This is a specific hint uuid</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        void AssetDisassociateHint(Guid asset, string hint, int operationIndex = 0);

        /// <summary>
        /// /asset/{asset}/hints/disassociate/{hint} [POST]
        /// </summary>
        /// <remarks>
        /// Disassociates an asset from a hint. It performs the same action as the hint equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="hint">This is a specific hint uuid</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> AssetDisassociateHintWithHttpInfo(Guid asset, string hint, int operationIndex = 0);
        /// <summary>
        /// /asset/{asset}/persons/disassociate/{person} [POST]
        /// </summary>
        /// <remarks>
        /// Disassociates a person from an asset. It performs the same action as the person equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="person">This is a uuid that represents a person.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        void AssetDisassociatePerson(Guid asset, string person, int operationIndex = 0);

        /// <summary>
        /// /asset/{asset}/persons/disassociate/{person} [POST]
        /// </summary>
        /// <remarks>
        /// Disassociates a person from an asset. It performs the same action as the person equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="person">This is a uuid that represents a person.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> AssetDisassociatePersonWithHttpInfo(Guid asset, string person, int operationIndex = 0);
        /// <summary>
        /// /asset/{asset}/tags/disassociate/{tag} [POST]
        /// </summary>
        /// <remarks>
        /// Disassociates a tag from an asset. It performs the same action as the tag equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="tag">tag id</param>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        void AssetDisassociateTag(string tag, Guid asset, int operationIndex = 0);

        /// <summary>
        /// /asset/{asset}/tags/disassociate/{tag} [POST]
        /// </summary>
        /// <remarks>
        /// Disassociates a tag from an asset. It performs the same action as the tag equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="tag">tag id</param>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> AssetDisassociateTagWithHttpInfo(string tag, Guid asset, int operationIndex = 0);
        /// <summary>
        /// /asset/{asset}/websites/disassociate/{website} [POST]
        /// </summary>
        /// <remarks>
        /// Disassociates a website from an asset. It performs the same action as the website equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="website">website id</param>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        void AssetDisassociateWebsite(string website, Guid asset, int operationIndex = 0);

        /// <summary>
        /// /asset/{asset}/websites/disassociate/{website} [POST]
        /// </summary>
        /// <remarks>
        /// Disassociates a website from an asset. It performs the same action as the website equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="website">website id</param>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> AssetDisassociateWebsiteWithHttpInfo(string website, Guid asset, int operationIndex = 0);
        /// <summary>
        /// /asset/{asset}/workstream_summaries/disassociate/{workstream_summary} [POST]
        /// </summary>
        /// <remarks>
        /// This will enable us to disassociate an asset from a workstream summary. This will do the same thing as the workstreamSummary equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="workstreamSummary">This is a identifier that is used to identify a specific workstream_summary.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        void AssetDisassociateWorkstreamSummary(Guid asset, string workstreamSummary, int operationIndex = 0);

        /// <summary>
        /// /asset/{asset}/workstream_summaries/disassociate/{workstream_summary} [POST]
        /// </summary>
        /// <remarks>
        /// This will enable us to disassociate an asset from a workstream summary. This will do the same thing as the workstreamSummary equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="workstreamSummary">This is a identifier that is used to identify a specific workstream_summary.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> AssetDisassociateWorkstreamSummaryWithHttpInfo(Guid asset, string workstreamSummary, int operationIndex = 0);
        /// <summary>
        /// /asset/{asset}/formats [GET] Scoped To Asset
        /// </summary>
        /// <remarks>
        /// Retrieves the formats available for a specified asset.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>Formats</returns>
        Formats AssetFormats(Guid asset, bool? transferables = default(bool?), int operationIndex = 0);

        /// <summary>
        /// /asset/{asset}/formats [GET] Scoped To Asset
        /// </summary>
        /// <remarks>
        /// Retrieves the formats available for a specified asset.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Formats</returns>
        ApiResponse<Formats> AssetFormatsWithHttpInfo(Guid asset, bool? transferables = default(bool?), int operationIndex = 0);
        /// <summary>
        /// /asset/reclassify [POST]
        /// </summary>
        /// <remarks>
        /// Retrieves the formats available for a specified asset.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="assetReclassification">This will accept a Reclassification that includeds and assetand a language that this assets needs to be reclassified to. We will just return an Asset that has been reclassified. (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>Asset</returns>
        Asset AssetReclassify(bool? transferables = default(bool?), AssetReclassification assetReclassification = default(AssetReclassification), int operationIndex = 0);

        /// <summary>
        /// /asset/reclassify [POST]
        /// </summary>
        /// <remarks>
        /// Retrieves the formats available for a specified asset.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="assetReclassification">This will accept a Reclassification that includeds and assetand a language that this assets needs to be reclassified to. We will just return an Asset that has been reclassified. (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Asset</returns>
        ApiResponse<Asset> AssetReclassifyWithHttpInfo(bool? transferables = default(bool?), AssetReclassification assetReclassification = default(AssetReclassification), int operationIndex = 0);
        /// <summary>
        /// /asset/{asset}/scores/increment [POST]
        /// </summary>
        /// <remarks>
        /// Increments the scores associated with the specified asset based on the provided SeededScoreIncrement data in the request body.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="seededScoreIncrement"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        void AssetScoresIncrement(Guid asset, SeededScoreIncrement seededScoreIncrement = default(SeededScoreIncrement), int operationIndex = 0);

        /// <summary>
        /// /asset/{asset}/scores/increment [POST]
        /// </summary>
        /// <remarks>
        /// Increments the scores associated with the specified asset based on the provided SeededScoreIncrement data in the request body.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="seededScoreIncrement"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> AssetScoresIncrementWithHttpInfo(Guid asset, SeededScoreIncrement seededScoreIncrement = default(SeededScoreIncrement), int operationIndex = 0);
        /// <summary>
        /// /asset/{asset} [GET] Scoped To Asset
        /// </summary>
        /// <remarks>
        /// Retrieves the snapshot of a specific asset
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>Asset</returns>
        Asset AssetSnapshot(Guid asset, bool? transferables = default(bool?), int operationIndex = 0);

        /// <summary>
        /// /asset/{asset} [GET] Scoped To Asset
        /// </summary>
        /// <remarks>
        /// Retrieves the snapshot of a specific asset
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Asset</returns>
        ApiResponse<Asset> AssetSnapshotWithHttpInfo(Guid asset, bool? transferables = default(bool?), int operationIndex = 0);
        /// <summary>
        /// /asset/{asset} [POST] Scoped to an Asset
        /// </summary>
        /// <remarks>
        /// Retrieves a snapshot of a specific asset, along with the user requesting the snapshot.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="seededAccessor"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>Asset</returns>
        Asset AssetSnapshotPost(Guid asset, bool? transferables = default(bool?), SeededAccessor seededAccessor = default(SeededAccessor), int operationIndex = 0);

        /// <summary>
        /// /asset/{asset} [POST] Scoped to an Asset
        /// </summary>
        /// <remarks>
        /// Retrieves a snapshot of a specific asset, along with the user requesting the snapshot.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="seededAccessor"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Asset</returns>
        ApiResponse<Asset> AssetSnapshotPostWithHttpInfo(Guid asset, bool? transferables = default(bool?), SeededAccessor seededAccessor = default(SeededAccessor), int operationIndex = 0);
        /// <summary>
        /// /asset/{asset}/activities [GET]
        /// </summary>
        /// <remarks>
        /// Retrieves activity events specific to the given asset.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>Activities</returns>
        Activities AssetSpecificAssetActivities(Guid asset, bool? transferables = default(bool?), int operationIndex = 0);

        /// <summary>
        /// /asset/{asset}/activities [GET]
        /// </summary>
        /// <remarks>
        /// Retrieves activity events specific to the given asset.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Activities</returns>
        ApiResponse<Activities> AssetSpecificAssetActivitiesWithHttpInfo(Guid asset, bool? transferables = default(bool?), int operationIndex = 0);
        /// <summary>
        /// /asset/{asset}/conversations [GET]
        /// </summary>
        /// <remarks>
        /// Retrieves conversations specific to the given asset.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>Conversations</returns>
        Conversations AssetSpecificAssetConversations(Guid asset, bool? transferables = default(bool?), int operationIndex = 0);

        /// <summary>
        /// /asset/{asset}/conversations [GET]
        /// </summary>
        /// <remarks>
        /// Retrieves conversations specific to the given asset.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Conversations</returns>
        ApiResponse<Conversations> AssetSpecificAssetConversationsWithHttpInfo(Guid asset, bool? transferables = default(bool?), int operationIndex = 0);
        /// <summary>
        /// /asset/{asset}/export [GET]
        /// </summary>
        /// <remarks>
        /// Retrieves an export version of the specified asset.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="exportType">This specifies the type of export the user wants.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ExportedAsset</returns>
        ExportedAsset AssetSpecificAssetExport(Guid asset, string exportType, int operationIndex = 0);

        /// <summary>
        /// /asset/{asset}/export [GET]
        /// </summary>
        /// <remarks>
        /// Retrieves an export version of the specified asset.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="exportType">This specifies the type of export the user wants.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of ExportedAsset</returns>
        ApiResponse<ExportedAsset> AssetSpecificAssetExportWithHttpInfo(Guid asset, string exportType, int operationIndex = 0);
        /// <summary>
        /// /asset/update [POST] Scoped to Asset
        /// </summary>
        /// <remarks>
        /// Allows the user to update an existing Asset. It accepts the Asset object that needs updating and returns the fully updated Asset.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="asset">This endpoint allows the user to update an existing Asset. It accepts the Asset object that needs updating and returns the fully updated Asset. (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>Asset</returns>
        Asset AssetUpdate(bool? transferables = default(bool?), Asset asset = default(Asset), int operationIndex = 0);

        /// <summary>
        /// /asset/update [POST] Scoped to Asset
        /// </summary>
        /// <remarks>
        /// Allows the user to update an existing Asset. It accepts the Asset object that needs updating and returns the fully updated Asset.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="asset">This endpoint allows the user to update an existing Asset. It accepts the Asset object that needs updating and returns the fully updated Asset. (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Asset</returns>
        ApiResponse<Asset> AssetUpdateWithHttpInfo(bool? transferables = default(bool?), Asset asset = default(Asset), int operationIndex = 0);
        #endregion Synchronous Operations
    }

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public interface IAssetApiAsync : IApiAccessor
    {
        #region Asynchronous Operations
        /// <summary>
        /// /asset/{asset}/persons/associate/{anchor} [POST]
        /// </summary>
        /// <remarks>
        /// associates an anchor and an asset. It performs the same action as the anchor equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task AssetAssociateAnchorAsync(Guid asset, string anchor, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /asset/{asset}/persons/associate/{anchor} [POST]
        /// </summary>
        /// <remarks>
        /// associates an anchor and an asset. It performs the same action as the anchor equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> AssetAssociateAnchorWithHttpInfoAsync(Guid asset, string anchor, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /asset/{asset}/conversations/associate/{conversation} [POST]
        /// </summary>
        /// <remarks>
        /// associates a conversation and an asset. It performs the same action as the conversation equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task AssetAssociateConversationAsync(Guid asset, string conversation, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /asset/{asset}/conversations/associate/{conversation} [POST]
        /// </summary>
        /// <remarks>
        /// associates a conversation and an asset. It performs the same action as the conversation equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> AssetAssociateConversationWithHttpInfoAsync(Guid asset, string conversation, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /asset/{asset}/hints/associate/{hint} [POST]
        /// </summary>
        /// <remarks>
        /// associates an asset and a hint. It performs the same action as the hint equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="hint">This is a specific hint uuid</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task AssetAssociateHintAsync(Guid asset, string hint, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /asset/{asset}/hints/associate/{hint} [POST]
        /// </summary>
        /// <remarks>
        /// associates an asset and a hint. It performs the same action as the hint equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="hint">This is a specific hint uuid</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> AssetAssociateHintWithHttpInfoAsync(Guid asset, string hint, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /asset/{asset}/persons/associate/{person} [POST]
        /// </summary>
        /// <remarks>
        /// associates a person and an asset. It performs the same action as the person equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="person">This is a uuid that represents a person.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task AssetAssociatePersonAsync(Guid asset, string person, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /asset/{asset}/persons/associate/{person} [POST]
        /// </summary>
        /// <remarks>
        /// associates a person and an asset. It performs the same action as the person equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="person">This is a uuid that represents a person.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> AssetAssociatePersonWithHttpInfoAsync(Guid asset, string person, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /asset/{asset}/tags/associate/{tag} [POST]
        /// </summary>
        /// <remarks>
        /// Associates a tag with a specified asset. It performs the same action as the tag equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="tag">tag id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task AssetAssociateTagAsync(Guid asset, string tag, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /asset/{asset}/tags/associate/{tag} [POST]
        /// </summary>
        /// <remarks>
        /// Associates a tag with a specified asset. It performs the same action as the tag equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="tag">tag id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> AssetAssociateTagWithHttpInfoAsync(Guid asset, string tag, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /asset/{asset}/websites/associate/{website} [POST]
        /// </summary>
        /// <remarks>
        /// Associates a website with an asset. It performs the same action as its website equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="website">website id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task AssetAssociateWebsiteAsync(Guid asset, string website, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /asset/{asset}/websites/associate/{website} [POST]
        /// </summary>
        /// <remarks>
        /// Associates a website with an asset. It performs the same action as its website equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="website">website id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> AssetAssociateWebsiteWithHttpInfoAsync(Guid asset, string website, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /asset/{asset}/workstream_summaries/associate/{workstream_summary} [POST]
        /// </summary>
        /// <remarks>
        /// This will associate a asset with a workstream summary. This will do the same thing as the workstreamSummary equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="workstreamSummary">This is a identifier that is used to identify a specific workstream_summary.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task AssetAssociateWorkstreamSummaryAsync(Guid asset, string workstreamSummary, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /asset/{asset}/workstream_summaries/associate/{workstream_summary} [POST]
        /// </summary>
        /// <remarks>
        /// This will associate a asset with a workstream summary. This will do the same thing as the workstreamSummary equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="workstreamSummary">This is a identifier that is used to identify a specific workstream_summary.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> AssetAssociateWorkstreamSummaryWithHttpInfoAsync(Guid asset, string workstreamSummary, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /asset/{asset}/anchors/disassociate/{anchor} [POST]
        /// </summary>
        /// <remarks>
        /// Disassociates a anchor from an asset. It performs the same action as the anchor equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task AssetDisassociateAnchorAsync(Guid asset, string anchor, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /asset/{asset}/anchors/disassociate/{anchor} [POST]
        /// </summary>
        /// <remarks>
        /// Disassociates a anchor from an asset. It performs the same action as the anchor equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> AssetDisassociateAnchorWithHttpInfoAsync(Guid asset, string anchor, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /asset/{asset}/conversations/disassociate/{conversation} [POST]
        /// </summary>
        /// <remarks>
        /// Disassociates a conversation from an asset. It performs the same action as the conversation equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task AssetDisassociateConversationAsync(Guid asset, string conversation, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /asset/{asset}/conversations/disassociate/{conversation} [POST]
        /// </summary>
        /// <remarks>
        /// Disassociates a conversation from an asset. It performs the same action as the conversation equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> AssetDisassociateConversationWithHttpInfoAsync(Guid asset, string conversation, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /asset/{asset}/hints/disassociate/{hint} [POST]
        /// </summary>
        /// <remarks>
        /// Disassociates an asset from a hint. It performs the same action as the hint equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="hint">This is a specific hint uuid</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task AssetDisassociateHintAsync(Guid asset, string hint, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /asset/{asset}/hints/disassociate/{hint} [POST]
        /// </summary>
        /// <remarks>
        /// Disassociates an asset from a hint. It performs the same action as the hint equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="hint">This is a specific hint uuid</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> AssetDisassociateHintWithHttpInfoAsync(Guid asset, string hint, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /asset/{asset}/persons/disassociate/{person} [POST]
        /// </summary>
        /// <remarks>
        /// Disassociates a person from an asset. It performs the same action as the person equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="person">This is a uuid that represents a person.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task AssetDisassociatePersonAsync(Guid asset, string person, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /asset/{asset}/persons/disassociate/{person} [POST]
        /// </summary>
        /// <remarks>
        /// Disassociates a person from an asset. It performs the same action as the person equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="person">This is a uuid that represents a person.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> AssetDisassociatePersonWithHttpInfoAsync(Guid asset, string person, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /asset/{asset}/tags/disassociate/{tag} [POST]
        /// </summary>
        /// <remarks>
        /// Disassociates a tag from an asset. It performs the same action as the tag equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="tag">tag id</param>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task AssetDisassociateTagAsync(string tag, Guid asset, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /asset/{asset}/tags/disassociate/{tag} [POST]
        /// </summary>
        /// <remarks>
        /// Disassociates a tag from an asset. It performs the same action as the tag equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="tag">tag id</param>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> AssetDisassociateTagWithHttpInfoAsync(string tag, Guid asset, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /asset/{asset}/websites/disassociate/{website} [POST]
        /// </summary>
        /// <remarks>
        /// Disassociates a website from an asset. It performs the same action as the website equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="website">website id</param>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task AssetDisassociateWebsiteAsync(string website, Guid asset, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /asset/{asset}/websites/disassociate/{website} [POST]
        /// </summary>
        /// <remarks>
        /// Disassociates a website from an asset. It performs the same action as the website equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="website">website id</param>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> AssetDisassociateWebsiteWithHttpInfoAsync(string website, Guid asset, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /asset/{asset}/workstream_summaries/disassociate/{workstream_summary} [POST]
        /// </summary>
        /// <remarks>
        /// This will enable us to disassociate an asset from a workstream summary. This will do the same thing as the workstreamSummary equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="workstreamSummary">This is a identifier that is used to identify a specific workstream_summary.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task AssetDisassociateWorkstreamSummaryAsync(Guid asset, string workstreamSummary, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /asset/{asset}/workstream_summaries/disassociate/{workstream_summary} [POST]
        /// </summary>
        /// <remarks>
        /// This will enable us to disassociate an asset from a workstream summary. This will do the same thing as the workstreamSummary equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="workstreamSummary">This is a identifier that is used to identify a specific workstream_summary.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> AssetDisassociateWorkstreamSummaryWithHttpInfoAsync(Guid asset, string workstreamSummary, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /asset/{asset}/formats [GET] Scoped To Asset
        /// </summary>
        /// <remarks>
        /// Retrieves the formats available for a specified asset.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of Formats</returns>
        System.Threading.Tasks.Task<Formats> AssetFormatsAsync(Guid asset, bool? transferables = default(bool?), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /asset/{asset}/formats [GET] Scoped To Asset
        /// </summary>
        /// <remarks>
        /// Retrieves the formats available for a specified asset.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (Formats)</returns>
        System.Threading.Tasks.Task<ApiResponse<Formats>> AssetFormatsWithHttpInfoAsync(Guid asset, bool? transferables = default(bool?), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /asset/reclassify [POST]
        /// </summary>
        /// <remarks>
        /// Retrieves the formats available for a specified asset.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="assetReclassification">This will accept a Reclassification that includeds and assetand a language that this assets needs to be reclassified to. We will just return an Asset that has been reclassified. (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of Asset</returns>
        System.Threading.Tasks.Task<Asset> AssetReclassifyAsync(bool? transferables = default(bool?), AssetReclassification assetReclassification = default(AssetReclassification), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /asset/reclassify [POST]
        /// </summary>
        /// <remarks>
        /// Retrieves the formats available for a specified asset.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="assetReclassification">This will accept a Reclassification that includeds and assetand a language that this assets needs to be reclassified to. We will just return an Asset that has been reclassified. (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (Asset)</returns>
        System.Threading.Tasks.Task<ApiResponse<Asset>> AssetReclassifyWithHttpInfoAsync(bool? transferables = default(bool?), AssetReclassification assetReclassification = default(AssetReclassification), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /asset/{asset}/scores/increment [POST]
        /// </summary>
        /// <remarks>
        /// Increments the scores associated with the specified asset based on the provided SeededScoreIncrement data in the request body.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="seededScoreIncrement"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task AssetScoresIncrementAsync(Guid asset, SeededScoreIncrement seededScoreIncrement = default(SeededScoreIncrement), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /asset/{asset}/scores/increment [POST]
        /// </summary>
        /// <remarks>
        /// Increments the scores associated with the specified asset based on the provided SeededScoreIncrement data in the request body.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="seededScoreIncrement"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> AssetScoresIncrementWithHttpInfoAsync(Guid asset, SeededScoreIncrement seededScoreIncrement = default(SeededScoreIncrement), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /asset/{asset} [GET] Scoped To Asset
        /// </summary>
        /// <remarks>
        /// Retrieves the snapshot of a specific asset
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of Asset</returns>
        System.Threading.Tasks.Task<Asset> AssetSnapshotAsync(Guid asset, bool? transferables = default(bool?), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /asset/{asset} [GET] Scoped To Asset
        /// </summary>
        /// <remarks>
        /// Retrieves the snapshot of a specific asset
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (Asset)</returns>
        System.Threading.Tasks.Task<ApiResponse<Asset>> AssetSnapshotWithHttpInfoAsync(Guid asset, bool? transferables = default(bool?), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /asset/{asset} [POST] Scoped to an Asset
        /// </summary>
        /// <remarks>
        /// Retrieves a snapshot of a specific asset, along with the user requesting the snapshot.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="seededAccessor"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of Asset</returns>
        System.Threading.Tasks.Task<Asset> AssetSnapshotPostAsync(Guid asset, bool? transferables = default(bool?), SeededAccessor seededAccessor = default(SeededAccessor), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /asset/{asset} [POST] Scoped to an Asset
        /// </summary>
        /// <remarks>
        /// Retrieves a snapshot of a specific asset, along with the user requesting the snapshot.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="seededAccessor"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (Asset)</returns>
        System.Threading.Tasks.Task<ApiResponse<Asset>> AssetSnapshotPostWithHttpInfoAsync(Guid asset, bool? transferables = default(bool?), SeededAccessor seededAccessor = default(SeededAccessor), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /asset/{asset}/activities [GET]
        /// </summary>
        /// <remarks>
        /// Retrieves activity events specific to the given asset.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of Activities</returns>
        System.Threading.Tasks.Task<Activities> AssetSpecificAssetActivitiesAsync(Guid asset, bool? transferables = default(bool?), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /asset/{asset}/activities [GET]
        /// </summary>
        /// <remarks>
        /// Retrieves activity events specific to the given asset.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (Activities)</returns>
        System.Threading.Tasks.Task<ApiResponse<Activities>> AssetSpecificAssetActivitiesWithHttpInfoAsync(Guid asset, bool? transferables = default(bool?), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /asset/{asset}/conversations [GET]
        /// </summary>
        /// <remarks>
        /// Retrieves conversations specific to the given asset.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of Conversations</returns>
        System.Threading.Tasks.Task<Conversations> AssetSpecificAssetConversationsAsync(Guid asset, bool? transferables = default(bool?), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /asset/{asset}/conversations [GET]
        /// </summary>
        /// <remarks>
        /// Retrieves conversations specific to the given asset.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (Conversations)</returns>
        System.Threading.Tasks.Task<ApiResponse<Conversations>> AssetSpecificAssetConversationsWithHttpInfoAsync(Guid asset, bool? transferables = default(bool?), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /asset/{asset}/export [GET]
        /// </summary>
        /// <remarks>
        /// Retrieves an export version of the specified asset.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="exportType">This specifies the type of export the user wants.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ExportedAsset</returns>
        System.Threading.Tasks.Task<ExportedAsset> AssetSpecificAssetExportAsync(Guid asset, string exportType, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /asset/{asset}/export [GET]
        /// </summary>
        /// <remarks>
        /// Retrieves an export version of the specified asset.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="exportType">This specifies the type of export the user wants.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (ExportedAsset)</returns>
        System.Threading.Tasks.Task<ApiResponse<ExportedAsset>> AssetSpecificAssetExportWithHttpInfoAsync(Guid asset, string exportType, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /asset/update [POST] Scoped to Asset
        /// </summary>
        /// <remarks>
        /// Allows the user to update an existing Asset. It accepts the Asset object that needs updating and returns the fully updated Asset.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="asset">This endpoint allows the user to update an existing Asset. It accepts the Asset object that needs updating and returns the fully updated Asset. (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of Asset</returns>
        System.Threading.Tasks.Task<Asset> AssetUpdateAsync(bool? transferables = default(bool?), Asset asset = default(Asset), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /asset/update [POST] Scoped to Asset
        /// </summary>
        /// <remarks>
        /// Allows the user to update an existing Asset. It accepts the Asset object that needs updating and returns the fully updated Asset.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="asset">This endpoint allows the user to update an existing Asset. It accepts the Asset object that needs updating and returns the fully updated Asset. (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (Asset)</returns>
        System.Threading.Tasks.Task<ApiResponse<Asset>> AssetUpdateWithHttpInfoAsync(bool? transferables = default(bool?), Asset asset = default(Asset), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        #endregion Asynchronous Operations
    }

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public interface IAssetApi : IAssetApiSync, IAssetApiAsync
    {

    }

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public partial class AssetApi : IAssetApi
    {
        private Pieces.Os.Core.Client.ExceptionFactory _exceptionFactory = (name, response) => null;

        /// <summary>
        /// Initializes a new instance of the <see cref="AssetApi"/> class.
        /// </summary>
        /// <returns></returns>
        public AssetApi() : this((string)null)
        {
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="AssetApi"/> class.
        /// </summary>
        /// <returns></returns>
        public AssetApi(string basePath)
        {
            this.Configuration = Pieces.Os.Core.Client.Configuration.MergeConfigurations(
                Pieces.Os.Core.Client.GlobalConfiguration.Instance,
                new Pieces.Os.Core.Client.Configuration { BasePath = basePath }
            );
            this.Client = new Pieces.Os.Core.Client.ApiClient(this.Configuration.BasePath);
            this.AsynchronousClient = new Pieces.Os.Core.Client.ApiClient(this.Configuration.BasePath);
            this.ExceptionFactory = Pieces.Os.Core.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="AssetApi"/> class
        /// using Configuration object
        /// </summary>
        /// <param name="configuration">An instance of Configuration</param>
        /// <returns></returns>
        public AssetApi(Pieces.Os.Core.Client.Configuration configuration)
        {
            if (configuration == null) throw new ArgumentNullException("configuration");

            this.Configuration = Pieces.Os.Core.Client.Configuration.MergeConfigurations(
                Pieces.Os.Core.Client.GlobalConfiguration.Instance,
                configuration
            );
            this.Client = new Pieces.Os.Core.Client.ApiClient(this.Configuration.BasePath);
            this.AsynchronousClient = new Pieces.Os.Core.Client.ApiClient(this.Configuration.BasePath);
            ExceptionFactory = Pieces.Os.Core.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="AssetApi"/> class
        /// using a Configuration object and client instance.
        /// </summary>
        /// <param name="client">The client interface for synchronous API access.</param>
        /// <param name="asyncClient">The client interface for asynchronous API access.</param>
        /// <param name="configuration">The configuration object.</param>
        public AssetApi(Pieces.Os.Core.Client.ISynchronousClient client, Pieces.Os.Core.Client.IAsynchronousClient asyncClient, Pieces.Os.Core.Client.IReadableConfiguration configuration)
        {
            if (client == null) throw new ArgumentNullException("client");
            if (asyncClient == null) throw new ArgumentNullException("asyncClient");
            if (configuration == null) throw new ArgumentNullException("configuration");

            this.Client = client;
            this.AsynchronousClient = asyncClient;
            this.Configuration = configuration;
            this.ExceptionFactory = Pieces.Os.Core.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// The client for accessing this underlying API asynchronously.
        /// </summary>
        public Pieces.Os.Core.Client.IAsynchronousClient AsynchronousClient { get; set; }

        /// <summary>
        /// The client for accessing this underlying API synchronously.
        /// </summary>
        public Pieces.Os.Core.Client.ISynchronousClient Client { get; set; }

        /// <summary>
        /// Gets the base path of the API client.
        /// </summary>
        /// <value>The base path</value>
        public string GetBasePath()
        {
            return this.Configuration.BasePath;
        }

        /// <summary>
        /// Gets or sets the configuration object
        /// </summary>
        /// <value>An instance of the Configuration</value>
        public Pieces.Os.Core.Client.IReadableConfiguration Configuration { get; set; }

        /// <summary>
        /// Provides a factory method hook for the creation of exceptions.
        /// </summary>
        public Pieces.Os.Core.Client.ExceptionFactory ExceptionFactory
        {
            get
            {
                if (_exceptionFactory != null && _exceptionFactory.GetInvocationList().Length > 1)
                {
                    throw new InvalidOperationException("Multicast delegate for ExceptionFactory is unsupported.");
                }
                return _exceptionFactory;
            }
            set { _exceptionFactory = value; }
        }

        /// <summary>
        /// /asset/{asset}/persons/associate/{anchor} [POST] associates an anchor and an asset. It performs the same action as the anchor equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        public void AssetAssociateAnchor(Guid asset, string anchor, int operationIndex = 0)
        {
            AssetAssociateAnchorWithHttpInfo(asset, anchor);
        }

        /// <summary>
        /// /asset/{asset}/persons/associate/{anchor} [POST] associates an anchor and an asset. It performs the same action as the anchor equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public Pieces.Os.Core.Client.ApiResponse<Object> AssetAssociateAnchorWithHttpInfo(Guid asset, string anchor, int operationIndex = 0)
        {
            // verify the required parameter 'anchor' is set
            if (anchor == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'anchor' when calling AssetApi->AssetAssociateAnchor");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("asset", Pieces.Os.Core.Client.ClientUtils.ParameterToString(asset)); // path parameter
            localVarRequestOptions.PathParameters.Add("anchor", Pieces.Os.Core.Client.ClientUtils.ParameterToString(anchor)); // path parameter

            localVarRequestOptions.Operation = "AssetApi.AssetAssociateAnchor";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Object>("/asset/{asset}/anchors/associate/{anchor}", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("AssetAssociateAnchor", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /asset/{asset}/persons/associate/{anchor} [POST] associates an anchor and an asset. It performs the same action as the anchor equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task AssetAssociateAnchorAsync(Guid asset, string anchor, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            await AssetAssociateAnchorWithHttpInfoAsync(asset, anchor, operationIndex, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// /asset/{asset}/persons/associate/{anchor} [POST] associates an anchor and an asset. It performs the same action as the anchor equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Object>> AssetAssociateAnchorWithHttpInfoAsync(Guid asset, string anchor, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'anchor' is set
            if (anchor == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'anchor' when calling AssetApi->AssetAssociateAnchor");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("asset", Pieces.Os.Core.Client.ClientUtils.ParameterToString(asset)); // path parameter
            localVarRequestOptions.PathParameters.Add("anchor", Pieces.Os.Core.Client.ClientUtils.ParameterToString(anchor)); // path parameter

            localVarRequestOptions.Operation = "AssetApi.AssetAssociateAnchor";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Object>("/asset/{asset}/anchors/associate/{anchor}", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("AssetAssociateAnchor", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /asset/{asset}/conversations/associate/{conversation} [POST] associates a conversation and an asset. It performs the same action as the conversation equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        public void AssetAssociateConversation(Guid asset, string conversation, int operationIndex = 0)
        {
            AssetAssociateConversationWithHttpInfo(asset, conversation);
        }

        /// <summary>
        /// /asset/{asset}/conversations/associate/{conversation} [POST] associates a conversation and an asset. It performs the same action as the conversation equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public Pieces.Os.Core.Client.ApiResponse<Object> AssetAssociateConversationWithHttpInfo(Guid asset, string conversation, int operationIndex = 0)
        {
            // verify the required parameter 'conversation' is set
            if (conversation == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'conversation' when calling AssetApi->AssetAssociateConversation");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("asset", Pieces.Os.Core.Client.ClientUtils.ParameterToString(asset)); // path parameter
            localVarRequestOptions.PathParameters.Add("conversation", Pieces.Os.Core.Client.ClientUtils.ParameterToString(conversation)); // path parameter

            localVarRequestOptions.Operation = "AssetApi.AssetAssociateConversation";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Object>("/asset/{asset}/conversations/associate/{conversation}", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("AssetAssociateConversation", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /asset/{asset}/conversations/associate/{conversation} [POST] associates a conversation and an asset. It performs the same action as the conversation equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task AssetAssociateConversationAsync(Guid asset, string conversation, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            await AssetAssociateConversationWithHttpInfoAsync(asset, conversation, operationIndex, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// /asset/{asset}/conversations/associate/{conversation} [POST] associates a conversation and an asset. It performs the same action as the conversation equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Object>> AssetAssociateConversationWithHttpInfoAsync(Guid asset, string conversation, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'conversation' is set
            if (conversation == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'conversation' when calling AssetApi->AssetAssociateConversation");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("asset", Pieces.Os.Core.Client.ClientUtils.ParameterToString(asset)); // path parameter
            localVarRequestOptions.PathParameters.Add("conversation", Pieces.Os.Core.Client.ClientUtils.ParameterToString(conversation)); // path parameter

            localVarRequestOptions.Operation = "AssetApi.AssetAssociateConversation";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Object>("/asset/{asset}/conversations/associate/{conversation}", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("AssetAssociateConversation", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /asset/{asset}/hints/associate/{hint} [POST] associates an asset and a hint. It performs the same action as the hint equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="hint">This is a specific hint uuid</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        public void AssetAssociateHint(Guid asset, string hint, int operationIndex = 0)
        {
            AssetAssociateHintWithHttpInfo(asset, hint);
        }

        /// <summary>
        /// /asset/{asset}/hints/associate/{hint} [POST] associates an asset and a hint. It performs the same action as the hint equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="hint">This is a specific hint uuid</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public Pieces.Os.Core.Client.ApiResponse<Object> AssetAssociateHintWithHttpInfo(Guid asset, string hint, int operationIndex = 0)
        {
            // verify the required parameter 'hint' is set
            if (hint == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'hint' when calling AssetApi->AssetAssociateHint");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("asset", Pieces.Os.Core.Client.ClientUtils.ParameterToString(asset)); // path parameter
            localVarRequestOptions.PathParameters.Add("hint", Pieces.Os.Core.Client.ClientUtils.ParameterToString(hint)); // path parameter

            localVarRequestOptions.Operation = "AssetApi.AssetAssociateHint";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Object>("/asset/{asset}/hints/associate/{hint}", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("AssetAssociateHint", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /asset/{asset}/hints/associate/{hint} [POST] associates an asset and a hint. It performs the same action as the hint equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="hint">This is a specific hint uuid</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task AssetAssociateHintAsync(Guid asset, string hint, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            await AssetAssociateHintWithHttpInfoAsync(asset, hint, operationIndex, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// /asset/{asset}/hints/associate/{hint} [POST] associates an asset and a hint. It performs the same action as the hint equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="hint">This is a specific hint uuid</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Object>> AssetAssociateHintWithHttpInfoAsync(Guid asset, string hint, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'hint' is set
            if (hint == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'hint' when calling AssetApi->AssetAssociateHint");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("asset", Pieces.Os.Core.Client.ClientUtils.ParameterToString(asset)); // path parameter
            localVarRequestOptions.PathParameters.Add("hint", Pieces.Os.Core.Client.ClientUtils.ParameterToString(hint)); // path parameter

            localVarRequestOptions.Operation = "AssetApi.AssetAssociateHint";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Object>("/asset/{asset}/hints/associate/{hint}", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("AssetAssociateHint", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /asset/{asset}/persons/associate/{person} [POST] associates a person and an asset. It performs the same action as the person equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="person">This is a uuid that represents a person.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        public void AssetAssociatePerson(Guid asset, string person, int operationIndex = 0)
        {
            AssetAssociatePersonWithHttpInfo(asset, person);
        }

        /// <summary>
        /// /asset/{asset}/persons/associate/{person} [POST] associates a person and an asset. It performs the same action as the person equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="person">This is a uuid that represents a person.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public Pieces.Os.Core.Client.ApiResponse<Object> AssetAssociatePersonWithHttpInfo(Guid asset, string person, int operationIndex = 0)
        {
            // verify the required parameter 'person' is set
            if (person == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'person' when calling AssetApi->AssetAssociatePerson");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("asset", Pieces.Os.Core.Client.ClientUtils.ParameterToString(asset)); // path parameter
            localVarRequestOptions.PathParameters.Add("person", Pieces.Os.Core.Client.ClientUtils.ParameterToString(person)); // path parameter

            localVarRequestOptions.Operation = "AssetApi.AssetAssociatePerson";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Object>("/asset/{asset}/persons/associate/{person}", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("AssetAssociatePerson", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /asset/{asset}/persons/associate/{person} [POST] associates a person and an asset. It performs the same action as the person equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="person">This is a uuid that represents a person.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task AssetAssociatePersonAsync(Guid asset, string person, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            await AssetAssociatePersonWithHttpInfoAsync(asset, person, operationIndex, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// /asset/{asset}/persons/associate/{person} [POST] associates a person and an asset. It performs the same action as the person equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="person">This is a uuid that represents a person.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Object>> AssetAssociatePersonWithHttpInfoAsync(Guid asset, string person, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'person' is set
            if (person == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'person' when calling AssetApi->AssetAssociatePerson");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("asset", Pieces.Os.Core.Client.ClientUtils.ParameterToString(asset)); // path parameter
            localVarRequestOptions.PathParameters.Add("person", Pieces.Os.Core.Client.ClientUtils.ParameterToString(person)); // path parameter

            localVarRequestOptions.Operation = "AssetApi.AssetAssociatePerson";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Object>("/asset/{asset}/persons/associate/{person}", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("AssetAssociatePerson", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /asset/{asset}/tags/associate/{tag} [POST] Associates a tag with a specified asset. It performs the same action as the tag equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="tag">tag id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        public void AssetAssociateTag(Guid asset, string tag, int operationIndex = 0)
        {
            AssetAssociateTagWithHttpInfo(asset, tag);
        }

        /// <summary>
        /// /asset/{asset}/tags/associate/{tag} [POST] Associates a tag with a specified asset. It performs the same action as the tag equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="tag">tag id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public Pieces.Os.Core.Client.ApiResponse<Object> AssetAssociateTagWithHttpInfo(Guid asset, string tag, int operationIndex = 0)
        {
            // verify the required parameter 'tag' is set
            if (tag == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'tag' when calling AssetApi->AssetAssociateTag");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("asset", Pieces.Os.Core.Client.ClientUtils.ParameterToString(asset)); // path parameter
            localVarRequestOptions.PathParameters.Add("tag", Pieces.Os.Core.Client.ClientUtils.ParameterToString(tag)); // path parameter

            localVarRequestOptions.Operation = "AssetApi.AssetAssociateTag";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Object>("/asset/{asset}/tags/associate/{tag}", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("AssetAssociateTag", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /asset/{asset}/tags/associate/{tag} [POST] Associates a tag with a specified asset. It performs the same action as the tag equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="tag">tag id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task AssetAssociateTagAsync(Guid asset, string tag, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            await AssetAssociateTagWithHttpInfoAsync(asset, tag, operationIndex, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// /asset/{asset}/tags/associate/{tag} [POST] Associates a tag with a specified asset. It performs the same action as the tag equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="tag">tag id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Object>> AssetAssociateTagWithHttpInfoAsync(Guid asset, string tag, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'tag' is set
            if (tag == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'tag' when calling AssetApi->AssetAssociateTag");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("asset", Pieces.Os.Core.Client.ClientUtils.ParameterToString(asset)); // path parameter
            localVarRequestOptions.PathParameters.Add("tag", Pieces.Os.Core.Client.ClientUtils.ParameterToString(tag)); // path parameter

            localVarRequestOptions.Operation = "AssetApi.AssetAssociateTag";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Object>("/asset/{asset}/tags/associate/{tag}", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("AssetAssociateTag", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /asset/{asset}/websites/associate/{website} [POST] Associates a website with an asset. It performs the same action as its website equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="website">website id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        public void AssetAssociateWebsite(Guid asset, string website, int operationIndex = 0)
        {
            AssetAssociateWebsiteWithHttpInfo(asset, website);
        }

        /// <summary>
        /// /asset/{asset}/websites/associate/{website} [POST] Associates a website with an asset. It performs the same action as its website equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="website">website id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public Pieces.Os.Core.Client.ApiResponse<Object> AssetAssociateWebsiteWithHttpInfo(Guid asset, string website, int operationIndex = 0)
        {
            // verify the required parameter 'website' is set
            if (website == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'website' when calling AssetApi->AssetAssociateWebsite");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("asset", Pieces.Os.Core.Client.ClientUtils.ParameterToString(asset)); // path parameter
            localVarRequestOptions.PathParameters.Add("website", Pieces.Os.Core.Client.ClientUtils.ParameterToString(website)); // path parameter

            localVarRequestOptions.Operation = "AssetApi.AssetAssociateWebsite";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Object>("/asset/{asset}/websites/associate/{website}", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("AssetAssociateWebsite", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /asset/{asset}/websites/associate/{website} [POST] Associates a website with an asset. It performs the same action as its website equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="website">website id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task AssetAssociateWebsiteAsync(Guid asset, string website, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            await AssetAssociateWebsiteWithHttpInfoAsync(asset, website, operationIndex, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// /asset/{asset}/websites/associate/{website} [POST] Associates a website with an asset. It performs the same action as its website equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="website">website id</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Object>> AssetAssociateWebsiteWithHttpInfoAsync(Guid asset, string website, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'website' is set
            if (website == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'website' when calling AssetApi->AssetAssociateWebsite");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("asset", Pieces.Os.Core.Client.ClientUtils.ParameterToString(asset)); // path parameter
            localVarRequestOptions.PathParameters.Add("website", Pieces.Os.Core.Client.ClientUtils.ParameterToString(website)); // path parameter

            localVarRequestOptions.Operation = "AssetApi.AssetAssociateWebsite";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Object>("/asset/{asset}/websites/associate/{website}", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("AssetAssociateWebsite", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /asset/{asset}/workstream_summaries/associate/{workstream_summary} [POST] This will associate a asset with a workstream summary. This will do the same thing as the workstreamSummary equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="workstreamSummary">This is a identifier that is used to identify a specific workstream_summary.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        public void AssetAssociateWorkstreamSummary(Guid asset, string workstreamSummary, int operationIndex = 0)
        {
            AssetAssociateWorkstreamSummaryWithHttpInfo(asset, workstreamSummary);
        }

        /// <summary>
        /// /asset/{asset}/workstream_summaries/associate/{workstream_summary} [POST] This will associate a asset with a workstream summary. This will do the same thing as the workstreamSummary equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="workstreamSummary">This is a identifier that is used to identify a specific workstream_summary.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public Pieces.Os.Core.Client.ApiResponse<Object> AssetAssociateWorkstreamSummaryWithHttpInfo(Guid asset, string workstreamSummary, int operationIndex = 0)
        {
            // verify the required parameter 'workstreamSummary' is set
            if (workstreamSummary == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'workstreamSummary' when calling AssetApi->AssetAssociateWorkstreamSummary");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("asset", Pieces.Os.Core.Client.ClientUtils.ParameterToString(asset)); // path parameter
            localVarRequestOptions.PathParameters.Add("workstream_summary", Pieces.Os.Core.Client.ClientUtils.ParameterToString(workstreamSummary)); // path parameter

            localVarRequestOptions.Operation = "AssetApi.AssetAssociateWorkstreamSummary";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Object>("/asset/{asset}/workstream_summaries/associate/{workstream_summary}", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("AssetAssociateWorkstreamSummary", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /asset/{asset}/workstream_summaries/associate/{workstream_summary} [POST] This will associate a asset with a workstream summary. This will do the same thing as the workstreamSummary equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="workstreamSummary">This is a identifier that is used to identify a specific workstream_summary.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task AssetAssociateWorkstreamSummaryAsync(Guid asset, string workstreamSummary, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            await AssetAssociateWorkstreamSummaryWithHttpInfoAsync(asset, workstreamSummary, operationIndex, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// /asset/{asset}/workstream_summaries/associate/{workstream_summary} [POST] This will associate a asset with a workstream summary. This will do the same thing as the workstreamSummary equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="workstreamSummary">This is a identifier that is used to identify a specific workstream_summary.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Object>> AssetAssociateWorkstreamSummaryWithHttpInfoAsync(Guid asset, string workstreamSummary, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'workstreamSummary' is set
            if (workstreamSummary == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'workstreamSummary' when calling AssetApi->AssetAssociateWorkstreamSummary");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("asset", Pieces.Os.Core.Client.ClientUtils.ParameterToString(asset)); // path parameter
            localVarRequestOptions.PathParameters.Add("workstream_summary", Pieces.Os.Core.Client.ClientUtils.ParameterToString(workstreamSummary)); // path parameter

            localVarRequestOptions.Operation = "AssetApi.AssetAssociateWorkstreamSummary";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Object>("/asset/{asset}/workstream_summaries/associate/{workstream_summary}", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("AssetAssociateWorkstreamSummary", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /asset/{asset}/anchors/disassociate/{anchor} [POST] Disassociates a anchor from an asset. It performs the same action as the anchor equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        public void AssetDisassociateAnchor(Guid asset, string anchor, int operationIndex = 0)
        {
            AssetDisassociateAnchorWithHttpInfo(asset, anchor);
        }

        /// <summary>
        /// /asset/{asset}/anchors/disassociate/{anchor} [POST] Disassociates a anchor from an asset. It performs the same action as the anchor equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public Pieces.Os.Core.Client.ApiResponse<Object> AssetDisassociateAnchorWithHttpInfo(Guid asset, string anchor, int operationIndex = 0)
        {
            // verify the required parameter 'anchor' is set
            if (anchor == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'anchor' when calling AssetApi->AssetDisassociateAnchor");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("asset", Pieces.Os.Core.Client.ClientUtils.ParameterToString(asset)); // path parameter
            localVarRequestOptions.PathParameters.Add("anchor", Pieces.Os.Core.Client.ClientUtils.ParameterToString(anchor)); // path parameter

            localVarRequestOptions.Operation = "AssetApi.AssetDisassociateAnchor";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Object>("/asset/{asset}/anchors/disassociate/{anchor}", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("AssetDisassociateAnchor", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /asset/{asset}/anchors/disassociate/{anchor} [POST] Disassociates a anchor from an asset. It performs the same action as the anchor equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task AssetDisassociateAnchorAsync(Guid asset, string anchor, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            await AssetDisassociateAnchorWithHttpInfoAsync(asset, anchor, operationIndex, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// /asset/{asset}/anchors/disassociate/{anchor} [POST] Disassociates a anchor from an asset. It performs the same action as the anchor equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Object>> AssetDisassociateAnchorWithHttpInfoAsync(Guid asset, string anchor, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'anchor' is set
            if (anchor == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'anchor' when calling AssetApi->AssetDisassociateAnchor");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("asset", Pieces.Os.Core.Client.ClientUtils.ParameterToString(asset)); // path parameter
            localVarRequestOptions.PathParameters.Add("anchor", Pieces.Os.Core.Client.ClientUtils.ParameterToString(anchor)); // path parameter

            localVarRequestOptions.Operation = "AssetApi.AssetDisassociateAnchor";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Object>("/asset/{asset}/anchors/disassociate/{anchor}", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("AssetDisassociateAnchor", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /asset/{asset}/conversations/disassociate/{conversation} [POST] Disassociates a conversation from an asset. It performs the same action as the conversation equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        public void AssetDisassociateConversation(Guid asset, string conversation, int operationIndex = 0)
        {
            AssetDisassociateConversationWithHttpInfo(asset, conversation);
        }

        /// <summary>
        /// /asset/{asset}/conversations/disassociate/{conversation} [POST] Disassociates a conversation from an asset. It performs the same action as the conversation equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public Pieces.Os.Core.Client.ApiResponse<Object> AssetDisassociateConversationWithHttpInfo(Guid asset, string conversation, int operationIndex = 0)
        {
            // verify the required parameter 'conversation' is set
            if (conversation == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'conversation' when calling AssetApi->AssetDisassociateConversation");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("asset", Pieces.Os.Core.Client.ClientUtils.ParameterToString(asset)); // path parameter
            localVarRequestOptions.PathParameters.Add("conversation", Pieces.Os.Core.Client.ClientUtils.ParameterToString(conversation)); // path parameter

            localVarRequestOptions.Operation = "AssetApi.AssetDisassociateConversation";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Object>("/asset/{asset}/conversations/disassociate/{conversation}", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("AssetDisassociateConversation", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /asset/{asset}/conversations/disassociate/{conversation} [POST] Disassociates a conversation from an asset. It performs the same action as the conversation equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task AssetDisassociateConversationAsync(Guid asset, string conversation, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            await AssetDisassociateConversationWithHttpInfoAsync(asset, conversation, operationIndex, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// /asset/{asset}/conversations/disassociate/{conversation} [POST] Disassociates a conversation from an asset. It performs the same action as the conversation equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Object>> AssetDisassociateConversationWithHttpInfoAsync(Guid asset, string conversation, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'conversation' is set
            if (conversation == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'conversation' when calling AssetApi->AssetDisassociateConversation");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("asset", Pieces.Os.Core.Client.ClientUtils.ParameterToString(asset)); // path parameter
            localVarRequestOptions.PathParameters.Add("conversation", Pieces.Os.Core.Client.ClientUtils.ParameterToString(conversation)); // path parameter

            localVarRequestOptions.Operation = "AssetApi.AssetDisassociateConversation";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Object>("/asset/{asset}/conversations/disassociate/{conversation}", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("AssetDisassociateConversation", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /asset/{asset}/hints/disassociate/{hint} [POST] Disassociates an asset from a hint. It performs the same action as the hint equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="hint">This is a specific hint uuid</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        public void AssetDisassociateHint(Guid asset, string hint, int operationIndex = 0)
        {
            AssetDisassociateHintWithHttpInfo(asset, hint);
        }

        /// <summary>
        /// /asset/{asset}/hints/disassociate/{hint} [POST] Disassociates an asset from a hint. It performs the same action as the hint equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="hint">This is a specific hint uuid</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public Pieces.Os.Core.Client.ApiResponse<Object> AssetDisassociateHintWithHttpInfo(Guid asset, string hint, int operationIndex = 0)
        {
            // verify the required parameter 'hint' is set
            if (hint == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'hint' when calling AssetApi->AssetDisassociateHint");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("asset", Pieces.Os.Core.Client.ClientUtils.ParameterToString(asset)); // path parameter
            localVarRequestOptions.PathParameters.Add("hint", Pieces.Os.Core.Client.ClientUtils.ParameterToString(hint)); // path parameter

            localVarRequestOptions.Operation = "AssetApi.AssetDisassociateHint";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Object>("/asset/{asset}/hints/disassociate/{hint}", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("AssetDisassociateHint", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /asset/{asset}/hints/disassociate/{hint} [POST] Disassociates an asset from a hint. It performs the same action as the hint equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="hint">This is a specific hint uuid</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task AssetDisassociateHintAsync(Guid asset, string hint, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            await AssetDisassociateHintWithHttpInfoAsync(asset, hint, operationIndex, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// /asset/{asset}/hints/disassociate/{hint} [POST] Disassociates an asset from a hint. It performs the same action as the hint equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="hint">This is a specific hint uuid</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Object>> AssetDisassociateHintWithHttpInfoAsync(Guid asset, string hint, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'hint' is set
            if (hint == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'hint' when calling AssetApi->AssetDisassociateHint");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("asset", Pieces.Os.Core.Client.ClientUtils.ParameterToString(asset)); // path parameter
            localVarRequestOptions.PathParameters.Add("hint", Pieces.Os.Core.Client.ClientUtils.ParameterToString(hint)); // path parameter

            localVarRequestOptions.Operation = "AssetApi.AssetDisassociateHint";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Object>("/asset/{asset}/hints/disassociate/{hint}", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("AssetDisassociateHint", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /asset/{asset}/persons/disassociate/{person} [POST] Disassociates a person from an asset. It performs the same action as the person equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="person">This is a uuid that represents a person.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        public void AssetDisassociatePerson(Guid asset, string person, int operationIndex = 0)
        {
            AssetDisassociatePersonWithHttpInfo(asset, person);
        }

        /// <summary>
        /// /asset/{asset}/persons/disassociate/{person} [POST] Disassociates a person from an asset. It performs the same action as the person equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="person">This is a uuid that represents a person.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public Pieces.Os.Core.Client.ApiResponse<Object> AssetDisassociatePersonWithHttpInfo(Guid asset, string person, int operationIndex = 0)
        {
            // verify the required parameter 'person' is set
            if (person == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'person' when calling AssetApi->AssetDisassociatePerson");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("asset", Pieces.Os.Core.Client.ClientUtils.ParameterToString(asset)); // path parameter
            localVarRequestOptions.PathParameters.Add("person", Pieces.Os.Core.Client.ClientUtils.ParameterToString(person)); // path parameter

            localVarRequestOptions.Operation = "AssetApi.AssetDisassociatePerson";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Object>("/asset/{asset}/persons/disassociate/{person}", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("AssetDisassociatePerson", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /asset/{asset}/persons/disassociate/{person} [POST] Disassociates a person from an asset. It performs the same action as the person equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="person">This is a uuid that represents a person.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task AssetDisassociatePersonAsync(Guid asset, string person, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            await AssetDisassociatePersonWithHttpInfoAsync(asset, person, operationIndex, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// /asset/{asset}/persons/disassociate/{person} [POST] Disassociates a person from an asset. It performs the same action as the person equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="person">This is a uuid that represents a person.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Object>> AssetDisassociatePersonWithHttpInfoAsync(Guid asset, string person, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'person' is set
            if (person == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'person' when calling AssetApi->AssetDisassociatePerson");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("asset", Pieces.Os.Core.Client.ClientUtils.ParameterToString(asset)); // path parameter
            localVarRequestOptions.PathParameters.Add("person", Pieces.Os.Core.Client.ClientUtils.ParameterToString(person)); // path parameter

            localVarRequestOptions.Operation = "AssetApi.AssetDisassociatePerson";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Object>("/asset/{asset}/persons/disassociate/{person}", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("AssetDisassociatePerson", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /asset/{asset}/tags/disassociate/{tag} [POST] Disassociates a tag from an asset. It performs the same action as the tag equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="tag">tag id</param>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        public void AssetDisassociateTag(string tag, Guid asset, int operationIndex = 0)
        {
            AssetDisassociateTagWithHttpInfo(tag, asset);
        }

        /// <summary>
        /// /asset/{asset}/tags/disassociate/{tag} [POST] Disassociates a tag from an asset. It performs the same action as the tag equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="tag">tag id</param>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public Pieces.Os.Core.Client.ApiResponse<Object> AssetDisassociateTagWithHttpInfo(string tag, Guid asset, int operationIndex = 0)
        {
            // verify the required parameter 'tag' is set
            if (tag == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'tag' when calling AssetApi->AssetDisassociateTag");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("tag", Pieces.Os.Core.Client.ClientUtils.ParameterToString(tag)); // path parameter
            localVarRequestOptions.PathParameters.Add("asset", Pieces.Os.Core.Client.ClientUtils.ParameterToString(asset)); // path parameter

            localVarRequestOptions.Operation = "AssetApi.AssetDisassociateTag";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Object>("/asset/{asset}/tags/disassociate/{tag}", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("AssetDisassociateTag", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /asset/{asset}/tags/disassociate/{tag} [POST] Disassociates a tag from an asset. It performs the same action as the tag equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="tag">tag id</param>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task AssetDisassociateTagAsync(string tag, Guid asset, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            await AssetDisassociateTagWithHttpInfoAsync(tag, asset, operationIndex, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// /asset/{asset}/tags/disassociate/{tag} [POST] Disassociates a tag from an asset. It performs the same action as the tag equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="tag">tag id</param>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Object>> AssetDisassociateTagWithHttpInfoAsync(string tag, Guid asset, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'tag' is set
            if (tag == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'tag' when calling AssetApi->AssetDisassociateTag");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("tag", Pieces.Os.Core.Client.ClientUtils.ParameterToString(tag)); // path parameter
            localVarRequestOptions.PathParameters.Add("asset", Pieces.Os.Core.Client.ClientUtils.ParameterToString(asset)); // path parameter

            localVarRequestOptions.Operation = "AssetApi.AssetDisassociateTag";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Object>("/asset/{asset}/tags/disassociate/{tag}", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("AssetDisassociateTag", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /asset/{asset}/websites/disassociate/{website} [POST] Disassociates a website from an asset. It performs the same action as the website equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="website">website id</param>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        public void AssetDisassociateWebsite(string website, Guid asset, int operationIndex = 0)
        {
            AssetDisassociateWebsiteWithHttpInfo(website, asset);
        }

        /// <summary>
        /// /asset/{asset}/websites/disassociate/{website} [POST] Disassociates a website from an asset. It performs the same action as the website equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="website">website id</param>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public Pieces.Os.Core.Client.ApiResponse<Object> AssetDisassociateWebsiteWithHttpInfo(string website, Guid asset, int operationIndex = 0)
        {
            // verify the required parameter 'website' is set
            if (website == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'website' when calling AssetApi->AssetDisassociateWebsite");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("website", Pieces.Os.Core.Client.ClientUtils.ParameterToString(website)); // path parameter
            localVarRequestOptions.PathParameters.Add("asset", Pieces.Os.Core.Client.ClientUtils.ParameterToString(asset)); // path parameter

            localVarRequestOptions.Operation = "AssetApi.AssetDisassociateWebsite";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Object>("/asset/{asset}/websites/disassociate/{website}", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("AssetDisassociateWebsite", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /asset/{asset}/websites/disassociate/{website} [POST] Disassociates a website from an asset. It performs the same action as the website equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="website">website id</param>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task AssetDisassociateWebsiteAsync(string website, Guid asset, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            await AssetDisassociateWebsiteWithHttpInfoAsync(website, asset, operationIndex, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// /asset/{asset}/websites/disassociate/{website} [POST] Disassociates a website from an asset. It performs the same action as the website equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="website">website id</param>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Object>> AssetDisassociateWebsiteWithHttpInfoAsync(string website, Guid asset, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'website' is set
            if (website == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'website' when calling AssetApi->AssetDisassociateWebsite");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("website", Pieces.Os.Core.Client.ClientUtils.ParameterToString(website)); // path parameter
            localVarRequestOptions.PathParameters.Add("asset", Pieces.Os.Core.Client.ClientUtils.ParameterToString(asset)); // path parameter

            localVarRequestOptions.Operation = "AssetApi.AssetDisassociateWebsite";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Object>("/asset/{asset}/websites/disassociate/{website}", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("AssetDisassociateWebsite", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /asset/{asset}/workstream_summaries/disassociate/{workstream_summary} [POST] This will enable us to disassociate an asset from a workstream summary. This will do the same thing as the workstreamSummary equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="workstreamSummary">This is a identifier that is used to identify a specific workstream_summary.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        public void AssetDisassociateWorkstreamSummary(Guid asset, string workstreamSummary, int operationIndex = 0)
        {
            AssetDisassociateWorkstreamSummaryWithHttpInfo(asset, workstreamSummary);
        }

        /// <summary>
        /// /asset/{asset}/workstream_summaries/disassociate/{workstream_summary} [POST] This will enable us to disassociate an asset from a workstream summary. This will do the same thing as the workstreamSummary equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="workstreamSummary">This is a identifier that is used to identify a specific workstream_summary.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public Pieces.Os.Core.Client.ApiResponse<Object> AssetDisassociateWorkstreamSummaryWithHttpInfo(Guid asset, string workstreamSummary, int operationIndex = 0)
        {
            // verify the required parameter 'workstreamSummary' is set
            if (workstreamSummary == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'workstreamSummary' when calling AssetApi->AssetDisassociateWorkstreamSummary");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("asset", Pieces.Os.Core.Client.ClientUtils.ParameterToString(asset)); // path parameter
            localVarRequestOptions.PathParameters.Add("workstream_summary", Pieces.Os.Core.Client.ClientUtils.ParameterToString(workstreamSummary)); // path parameter

            localVarRequestOptions.Operation = "AssetApi.AssetDisassociateWorkstreamSummary";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Object>("/asset/{asset}/workstream_summaries/disassociate/{workstream_summary}", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("AssetDisassociateWorkstreamSummary", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /asset/{asset}/workstream_summaries/disassociate/{workstream_summary} [POST] This will enable us to disassociate an asset from a workstream summary. This will do the same thing as the workstreamSummary equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="workstreamSummary">This is a identifier that is used to identify a specific workstream_summary.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task AssetDisassociateWorkstreamSummaryAsync(Guid asset, string workstreamSummary, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            await AssetDisassociateWorkstreamSummaryWithHttpInfoAsync(asset, workstreamSummary, operationIndex, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// /asset/{asset}/workstream_summaries/disassociate/{workstream_summary} [POST] This will enable us to disassociate an asset from a workstream summary. This will do the same thing as the workstreamSummary equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="workstreamSummary">This is a identifier that is used to identify a specific workstream_summary.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Object>> AssetDisassociateWorkstreamSummaryWithHttpInfoAsync(Guid asset, string workstreamSummary, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'workstreamSummary' is set
            if (workstreamSummary == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'workstreamSummary' when calling AssetApi->AssetDisassociateWorkstreamSummary");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("asset", Pieces.Os.Core.Client.ClientUtils.ParameterToString(asset)); // path parameter
            localVarRequestOptions.PathParameters.Add("workstream_summary", Pieces.Os.Core.Client.ClientUtils.ParameterToString(workstreamSummary)); // path parameter

            localVarRequestOptions.Operation = "AssetApi.AssetDisassociateWorkstreamSummary";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Object>("/asset/{asset}/workstream_summaries/disassociate/{workstream_summary}", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("AssetDisassociateWorkstreamSummary", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /asset/{asset}/formats [GET] Scoped To Asset Retrieves the formats available for a specified asset.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>Formats</returns>
        public Formats AssetFormats(Guid asset, bool? transferables = default(bool?), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.ApiResponse<Formats> localVarResponse = AssetFormatsWithHttpInfo(asset, transferables);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /asset/{asset}/formats [GET] Scoped To Asset Retrieves the formats available for a specified asset.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Formats</returns>
        public Pieces.Os.Core.Client.ApiResponse<Formats> AssetFormatsWithHttpInfo(Guid asset, bool? transferables = default(bool?), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("asset", Pieces.Os.Core.Client.ClientUtils.ParameterToString(asset)); // path parameter
            if (transferables != null)
            {
                localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "transferables", transferables));
            }

            localVarRequestOptions.Operation = "AssetApi.AssetFormats";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Get<Formats>("/asset/{asset}/formats", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("AssetFormats", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /asset/{asset}/formats [GET] Scoped To Asset Retrieves the formats available for a specified asset.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of Formats</returns>
        public async System.Threading.Tasks.Task<Formats> AssetFormatsAsync(Guid asset, bool? transferables = default(bool?), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            Pieces.Os.Core.Client.ApiResponse<Formats> localVarResponse = await AssetFormatsWithHttpInfoAsync(asset, transferables, operationIndex, cancellationToken).ConfigureAwait(false);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /asset/{asset}/formats [GET] Scoped To Asset Retrieves the formats available for a specified asset.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (Formats)</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Formats>> AssetFormatsWithHttpInfoAsync(Guid asset, bool? transferables = default(bool?), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("asset", Pieces.Os.Core.Client.ClientUtils.ParameterToString(asset)); // path parameter
            if (transferables != null)
            {
                localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "transferables", transferables));
            }

            localVarRequestOptions.Operation = "AssetApi.AssetFormats";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.GetAsync<Formats>("/asset/{asset}/formats", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("AssetFormats", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /asset/reclassify [POST] Retrieves the formats available for a specified asset.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="assetReclassification">This will accept a Reclassification that includeds and assetand a language that this assets needs to be reclassified to. We will just return an Asset that has been reclassified. (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>Asset</returns>
        public Asset AssetReclassify(bool? transferables = default(bool?), AssetReclassification assetReclassification = default(AssetReclassification), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.ApiResponse<Asset> localVarResponse = AssetReclassifyWithHttpInfo(transferables, assetReclassification);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /asset/reclassify [POST] Retrieves the formats available for a specified asset.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="assetReclassification">This will accept a Reclassification that includeds and assetand a language that this assets needs to be reclassified to. We will just return an Asset that has been reclassified. (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Asset</returns>
        public Pieces.Os.Core.Client.ApiResponse<Asset> AssetReclassifyWithHttpInfo(bool? transferables = default(bool?), AssetReclassification assetReclassification = default(AssetReclassification), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            if (transferables != null)
            {
                localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "transferables", transferables));
            }
            localVarRequestOptions.Data = assetReclassification;

            localVarRequestOptions.Operation = "AssetApi.AssetReclassify";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Asset>("/asset/reclassify", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("AssetReclassify", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /asset/reclassify [POST] Retrieves the formats available for a specified asset.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="assetReclassification">This will accept a Reclassification that includeds and assetand a language that this assets needs to be reclassified to. We will just return an Asset that has been reclassified. (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of Asset</returns>
        public async System.Threading.Tasks.Task<Asset> AssetReclassifyAsync(bool? transferables = default(bool?), AssetReclassification assetReclassification = default(AssetReclassification), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            Pieces.Os.Core.Client.ApiResponse<Asset> localVarResponse = await AssetReclassifyWithHttpInfoAsync(transferables, assetReclassification, operationIndex, cancellationToken).ConfigureAwait(false);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /asset/reclassify [POST] Retrieves the formats available for a specified asset.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="assetReclassification">This will accept a Reclassification that includeds and assetand a language that this assets needs to be reclassified to. We will just return an Asset that has been reclassified. (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (Asset)</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Asset>> AssetReclassifyWithHttpInfoAsync(bool? transferables = default(bool?), AssetReclassification assetReclassification = default(AssetReclassification), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            if (transferables != null)
            {
                localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "transferables", transferables));
            }
            localVarRequestOptions.Data = assetReclassification;

            localVarRequestOptions.Operation = "AssetApi.AssetReclassify";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Asset>("/asset/reclassify", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("AssetReclassify", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /asset/{asset}/scores/increment [POST] Increments the scores associated with the specified asset based on the provided SeededScoreIncrement data in the request body.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="seededScoreIncrement"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        public void AssetScoresIncrement(Guid asset, SeededScoreIncrement seededScoreIncrement = default(SeededScoreIncrement), int operationIndex = 0)
        {
            AssetScoresIncrementWithHttpInfo(asset, seededScoreIncrement);
        }

        /// <summary>
        /// /asset/{asset}/scores/increment [POST] Increments the scores associated with the specified asset based on the provided SeededScoreIncrement data in the request body.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="seededScoreIncrement"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public Pieces.Os.Core.Client.ApiResponse<Object> AssetScoresIncrementWithHttpInfo(Guid asset, SeededScoreIncrement seededScoreIncrement = default(SeededScoreIncrement), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("asset", Pieces.Os.Core.Client.ClientUtils.ParameterToString(asset)); // path parameter
            localVarRequestOptions.Data = seededScoreIncrement;

            localVarRequestOptions.Operation = "AssetApi.AssetScoresIncrement";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Object>("/asset/{asset}/scores/increment", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("AssetScoresIncrement", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /asset/{asset}/scores/increment [POST] Increments the scores associated with the specified asset based on the provided SeededScoreIncrement data in the request body.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="seededScoreIncrement"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task AssetScoresIncrementAsync(Guid asset, SeededScoreIncrement seededScoreIncrement = default(SeededScoreIncrement), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            await AssetScoresIncrementWithHttpInfoAsync(asset, seededScoreIncrement, operationIndex, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// /asset/{asset}/scores/increment [POST] Increments the scores associated with the specified asset based on the provided SeededScoreIncrement data in the request body.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="seededScoreIncrement"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Object>> AssetScoresIncrementWithHttpInfoAsync(Guid asset, SeededScoreIncrement seededScoreIncrement = default(SeededScoreIncrement), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("asset", Pieces.Os.Core.Client.ClientUtils.ParameterToString(asset)); // path parameter
            localVarRequestOptions.Data = seededScoreIncrement;

            localVarRequestOptions.Operation = "AssetApi.AssetScoresIncrement";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Object>("/asset/{asset}/scores/increment", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("AssetScoresIncrement", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /asset/{asset} [GET] Scoped To Asset Retrieves the snapshot of a specific asset
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>Asset</returns>
        public Asset AssetSnapshot(Guid asset, bool? transferables = default(bool?), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.ApiResponse<Asset> localVarResponse = AssetSnapshotWithHttpInfo(asset, transferables);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /asset/{asset} [GET] Scoped To Asset Retrieves the snapshot of a specific asset
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Asset</returns>
        public Pieces.Os.Core.Client.ApiResponse<Asset> AssetSnapshotWithHttpInfo(Guid asset, bool? transferables = default(bool?), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("asset", Pieces.Os.Core.Client.ClientUtils.ParameterToString(asset)); // path parameter
            if (transferables != null)
            {
                localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "transferables", transferables));
            }

            localVarRequestOptions.Operation = "AssetApi.AssetSnapshot";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Get<Asset>("/asset/{asset}", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("AssetSnapshot", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /asset/{asset} [GET] Scoped To Asset Retrieves the snapshot of a specific asset
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of Asset</returns>
        public async System.Threading.Tasks.Task<Asset> AssetSnapshotAsync(Guid asset, bool? transferables = default(bool?), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            Pieces.Os.Core.Client.ApiResponse<Asset> localVarResponse = await AssetSnapshotWithHttpInfoAsync(asset, transferables, operationIndex, cancellationToken).ConfigureAwait(false);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /asset/{asset} [GET] Scoped To Asset Retrieves the snapshot of a specific asset
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (Asset)</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Asset>> AssetSnapshotWithHttpInfoAsync(Guid asset, bool? transferables = default(bool?), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("asset", Pieces.Os.Core.Client.ClientUtils.ParameterToString(asset)); // path parameter
            if (transferables != null)
            {
                localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "transferables", transferables));
            }

            localVarRequestOptions.Operation = "AssetApi.AssetSnapshot";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.GetAsync<Asset>("/asset/{asset}", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("AssetSnapshot", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /asset/{asset} [POST] Scoped to an Asset Retrieves a snapshot of a specific asset, along with the user requesting the snapshot.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="seededAccessor"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>Asset</returns>
        public Asset AssetSnapshotPost(Guid asset, bool? transferables = default(bool?), SeededAccessor seededAccessor = default(SeededAccessor), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.ApiResponse<Asset> localVarResponse = AssetSnapshotPostWithHttpInfo(asset, transferables, seededAccessor);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /asset/{asset} [POST] Scoped to an Asset Retrieves a snapshot of a specific asset, along with the user requesting the snapshot.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="seededAccessor"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Asset</returns>
        public Pieces.Os.Core.Client.ApiResponse<Asset> AssetSnapshotPostWithHttpInfo(Guid asset, bool? transferables = default(bool?), SeededAccessor seededAccessor = default(SeededAccessor), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("asset", Pieces.Os.Core.Client.ClientUtils.ParameterToString(asset)); // path parameter
            if (transferables != null)
            {
                localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "transferables", transferables));
            }
            localVarRequestOptions.Data = seededAccessor;

            localVarRequestOptions.Operation = "AssetApi.AssetSnapshotPost";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Asset>("/asset/{asset}", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("AssetSnapshotPost", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /asset/{asset} [POST] Scoped to an Asset Retrieves a snapshot of a specific asset, along with the user requesting the snapshot.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="seededAccessor"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of Asset</returns>
        public async System.Threading.Tasks.Task<Asset> AssetSnapshotPostAsync(Guid asset, bool? transferables = default(bool?), SeededAccessor seededAccessor = default(SeededAccessor), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            Pieces.Os.Core.Client.ApiResponse<Asset> localVarResponse = await AssetSnapshotPostWithHttpInfoAsync(asset, transferables, seededAccessor, operationIndex, cancellationToken).ConfigureAwait(false);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /asset/{asset} [POST] Scoped to an Asset Retrieves a snapshot of a specific asset, along with the user requesting the snapshot.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="seededAccessor"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (Asset)</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Asset>> AssetSnapshotPostWithHttpInfoAsync(Guid asset, bool? transferables = default(bool?), SeededAccessor seededAccessor = default(SeededAccessor), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("asset", Pieces.Os.Core.Client.ClientUtils.ParameterToString(asset)); // path parameter
            if (transferables != null)
            {
                localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "transferables", transferables));
            }
            localVarRequestOptions.Data = seededAccessor;

            localVarRequestOptions.Operation = "AssetApi.AssetSnapshotPost";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Asset>("/asset/{asset}", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("AssetSnapshotPost", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /asset/{asset}/activities [GET] Retrieves activity events specific to the given asset.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>Activities</returns>
        public Activities AssetSpecificAssetActivities(Guid asset, bool? transferables = default(bool?), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.ApiResponse<Activities> localVarResponse = AssetSpecificAssetActivitiesWithHttpInfo(asset, transferables);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /asset/{asset}/activities [GET] Retrieves activity events specific to the given asset.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Activities</returns>
        public Pieces.Os.Core.Client.ApiResponse<Activities> AssetSpecificAssetActivitiesWithHttpInfo(Guid asset, bool? transferables = default(bool?), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("asset", Pieces.Os.Core.Client.ClientUtils.ParameterToString(asset)); // path parameter
            if (transferables != null)
            {
                localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "transferables", transferables));
            }

            localVarRequestOptions.Operation = "AssetApi.AssetSpecificAssetActivities";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Get<Activities>("/asset/{asset}/activities", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("AssetSpecificAssetActivities", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /asset/{asset}/activities [GET] Retrieves activity events specific to the given asset.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of Activities</returns>
        public async System.Threading.Tasks.Task<Activities> AssetSpecificAssetActivitiesAsync(Guid asset, bool? transferables = default(bool?), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            Pieces.Os.Core.Client.ApiResponse<Activities> localVarResponse = await AssetSpecificAssetActivitiesWithHttpInfoAsync(asset, transferables, operationIndex, cancellationToken).ConfigureAwait(false);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /asset/{asset}/activities [GET] Retrieves activity events specific to the given asset.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (Activities)</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Activities>> AssetSpecificAssetActivitiesWithHttpInfoAsync(Guid asset, bool? transferables = default(bool?), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("asset", Pieces.Os.Core.Client.ClientUtils.ParameterToString(asset)); // path parameter
            if (transferables != null)
            {
                localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "transferables", transferables));
            }

            localVarRequestOptions.Operation = "AssetApi.AssetSpecificAssetActivities";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.GetAsync<Activities>("/asset/{asset}/activities", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("AssetSpecificAssetActivities", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /asset/{asset}/conversations [GET] Retrieves conversations specific to the given asset.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>Conversations</returns>
        public Conversations AssetSpecificAssetConversations(Guid asset, bool? transferables = default(bool?), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.ApiResponse<Conversations> localVarResponse = AssetSpecificAssetConversationsWithHttpInfo(asset, transferables);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /asset/{asset}/conversations [GET] Retrieves conversations specific to the given asset.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Conversations</returns>
        public Pieces.Os.Core.Client.ApiResponse<Conversations> AssetSpecificAssetConversationsWithHttpInfo(Guid asset, bool? transferables = default(bool?), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("asset", Pieces.Os.Core.Client.ClientUtils.ParameterToString(asset)); // path parameter
            if (transferables != null)
            {
                localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "transferables", transferables));
            }

            localVarRequestOptions.Operation = "AssetApi.AssetSpecificAssetConversations";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Get<Conversations>("/asset/{asset}/conversations", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("AssetSpecificAssetConversations", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /asset/{asset}/conversations [GET] Retrieves conversations specific to the given asset.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of Conversations</returns>
        public async System.Threading.Tasks.Task<Conversations> AssetSpecificAssetConversationsAsync(Guid asset, bool? transferables = default(bool?), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            Pieces.Os.Core.Client.ApiResponse<Conversations> localVarResponse = await AssetSpecificAssetConversationsWithHttpInfoAsync(asset, transferables, operationIndex, cancellationToken).ConfigureAwait(false);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /asset/{asset}/conversations [GET] Retrieves conversations specific to the given asset.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (Conversations)</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Conversations>> AssetSpecificAssetConversationsWithHttpInfoAsync(Guid asset, bool? transferables = default(bool?), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("asset", Pieces.Os.Core.Client.ClientUtils.ParameterToString(asset)); // path parameter
            if (transferables != null)
            {
                localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "transferables", transferables));
            }

            localVarRequestOptions.Operation = "AssetApi.AssetSpecificAssetConversations";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.GetAsync<Conversations>("/asset/{asset}/conversations", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("AssetSpecificAssetConversations", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /asset/{asset}/export [GET] Retrieves an export version of the specified asset.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="exportType">This specifies the type of export the user wants.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ExportedAsset</returns>
        public ExportedAsset AssetSpecificAssetExport(Guid asset, string exportType, int operationIndex = 0)
        {
            Pieces.Os.Core.Client.ApiResponse<ExportedAsset> localVarResponse = AssetSpecificAssetExportWithHttpInfo(asset, exportType);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /asset/{asset}/export [GET] Retrieves an export version of the specified asset.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="exportType">This specifies the type of export the user wants.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of ExportedAsset</returns>
        public Pieces.Os.Core.Client.ApiResponse<ExportedAsset> AssetSpecificAssetExportWithHttpInfo(Guid asset, string exportType, int operationIndex = 0)
        {
            // verify the required parameter 'exportType' is set
            if (exportType == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'exportType' when calling AssetApi->AssetSpecificAssetExport");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("asset", Pieces.Os.Core.Client.ClientUtils.ParameterToString(asset)); // path parameter
            localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "export_type", exportType));

            localVarRequestOptions.Operation = "AssetApi.AssetSpecificAssetExport";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Get<ExportedAsset>("/asset/{asset}/export", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("AssetSpecificAssetExport", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /asset/{asset}/export [GET] Retrieves an export version of the specified asset.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="exportType">This specifies the type of export the user wants.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ExportedAsset</returns>
        public async System.Threading.Tasks.Task<ExportedAsset> AssetSpecificAssetExportAsync(Guid asset, string exportType, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            Pieces.Os.Core.Client.ApiResponse<ExportedAsset> localVarResponse = await AssetSpecificAssetExportWithHttpInfoAsync(asset, exportType, operationIndex, cancellationToken).ConfigureAwait(false);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /asset/{asset}/export [GET] Retrieves an export version of the specified asset.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="exportType">This specifies the type of export the user wants.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (ExportedAsset)</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<ExportedAsset>> AssetSpecificAssetExportWithHttpInfoAsync(Guid asset, string exportType, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'exportType' is set
            if (exportType == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'exportType' when calling AssetApi->AssetSpecificAssetExport");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("asset", Pieces.Os.Core.Client.ClientUtils.ParameterToString(asset)); // path parameter
            localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "export_type", exportType));

            localVarRequestOptions.Operation = "AssetApi.AssetSpecificAssetExport";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.GetAsync<ExportedAsset>("/asset/{asset}/export", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("AssetSpecificAssetExport", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /asset/update [POST] Scoped to Asset Allows the user to update an existing Asset. It accepts the Asset object that needs updating and returns the fully updated Asset.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="asset">This endpoint allows the user to update an existing Asset. It accepts the Asset object that needs updating and returns the fully updated Asset. (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>Asset</returns>
        public Asset AssetUpdate(bool? transferables = default(bool?), Asset asset = default(Asset), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.ApiResponse<Asset> localVarResponse = AssetUpdateWithHttpInfo(transferables, asset);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /asset/update [POST] Scoped to Asset Allows the user to update an existing Asset. It accepts the Asset object that needs updating and returns the fully updated Asset.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="asset">This endpoint allows the user to update an existing Asset. It accepts the Asset object that needs updating and returns the fully updated Asset. (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Asset</returns>
        public Pieces.Os.Core.Client.ApiResponse<Asset> AssetUpdateWithHttpInfo(bool? transferables = default(bool?), Asset asset = default(Asset), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            if (transferables != null)
            {
                localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "transferables", transferables));
            }
            localVarRequestOptions.Data = asset;

            localVarRequestOptions.Operation = "AssetApi.AssetUpdate";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Asset>("/asset/update", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("AssetUpdate", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /asset/update [POST] Scoped to Asset Allows the user to update an existing Asset. It accepts the Asset object that needs updating and returns the fully updated Asset.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="asset">This endpoint allows the user to update an existing Asset. It accepts the Asset object that needs updating and returns the fully updated Asset. (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of Asset</returns>
        public async System.Threading.Tasks.Task<Asset> AssetUpdateAsync(bool? transferables = default(bool?), Asset asset = default(Asset), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            Pieces.Os.Core.Client.ApiResponse<Asset> localVarResponse = await AssetUpdateWithHttpInfoAsync(transferables, asset, operationIndex, cancellationToken).ConfigureAwait(false);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /asset/update [POST] Scoped to Asset Allows the user to update an existing Asset. It accepts the Asset object that needs updating and returns the fully updated Asset.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="asset">This endpoint allows the user to update an existing Asset. It accepts the Asset object that needs updating and returns the fully updated Asset. (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (Asset)</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Asset>> AssetUpdateWithHttpInfoAsync(bool? transferables = default(bool?), Asset asset = default(Asset), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            if (transferables != null)
            {
                localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "transferables", transferables));
            }
            localVarRequestOptions.Data = asset;

            localVarRequestOptions.Operation = "AssetApi.AssetUpdate";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Asset>("/asset/update", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("AssetUpdate", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

    }
}
