/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Net;
using System.Net.Mime;
using Pieces.Os.Core.Client;
using Pieces.Os.Core.Client.Auth;
using Pieces.Os.Core.SdkModel;

namespace Pieces.Os.Core.Api
{

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public interface IAnnotationsApiSync : IApiAccessor
    {
        #region Synchronous Operations
        /// <summary>
        /// /annotations/create [POST]
        /// </summary>
        /// <remarks>
        /// This will create an annotation.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="seededAnnotation"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>Annotation</returns>
        Annotation AnnotationsCreateNewAnnotation(SeededAnnotation seededAnnotation = default(SeededAnnotation), int operationIndex = 0);

        /// <summary>
        /// /annotations/create [POST]
        /// </summary>
        /// <remarks>
        /// This will create an annotation.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="seededAnnotation"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Annotation</returns>
        ApiResponse<Annotation> AnnotationsCreateNewAnnotationWithHttpInfo(SeededAnnotation seededAnnotation = default(SeededAnnotation), int operationIndex = 0);
        /// <summary>
        /// /annotations/{annotation}/delete [POST]
        /// </summary>
        /// <remarks>
        /// this will delete a specific annotation
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="annotation">This is a specific annotation uuid.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        void AnnotationsDeleteSpecificAnnotation(string annotation, int operationIndex = 0);

        /// <summary>
        /// /annotations/{annotation}/delete [POST]
        /// </summary>
        /// <remarks>
        /// this will delete a specific annotation
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="annotation">This is a specific annotation uuid.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> AnnotationsDeleteSpecificAnnotationWithHttpInfo(string annotation, int operationIndex = 0);
        /// <summary>
        /// /annotations [GET]
        /// </summary>
        /// <remarks>
        /// This will get a snapshot of all the annotations.  This will take an optional filter as a query param.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="annotationTypeFilter">This is an AnnotationTypeEnum as a optional filter. (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>Annotations</returns>
        Annotations AnnotationsSnapshot(string annotationTypeFilter = default(string), int operationIndex = 0);

        /// <summary>
        /// /annotations [GET]
        /// </summary>
        /// <remarks>
        /// This will get a snapshot of all the annotations.  This will take an optional filter as a query param.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="annotationTypeFilter">This is an AnnotationTypeEnum as a optional filter. (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Annotations</returns>
        ApiResponse<Annotations> AnnotationsSnapshotWithHttpInfo(string annotationTypeFilter = default(string), int operationIndex = 0);
        /// <summary>
        /// /annotations/stream/identifiers [WS]
        /// </summary>
        /// <remarks>
        /// Provides a WebSocket connection that emits changes to your annotation identifiers (UUIDs).
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>StreamedIdentifiers</returns>
        StreamedIdentifiers AnnotationsStreamIdentifiers(int operationIndex = 0);

        /// <summary>
        /// /annotations/stream/identifiers [WS]
        /// </summary>
        /// <remarks>
        /// Provides a WebSocket connection that emits changes to your annotation identifiers (UUIDs).
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of StreamedIdentifiers</returns>
        ApiResponse<StreamedIdentifiers> AnnotationsStreamIdentifiersWithHttpInfo(int operationIndex = 0);
        /// <summary>
        /// /annotations/search [POST]
        /// </summary>
        /// <remarks>
        /// This will search your annotations for a specific annotation  note: we will just search the annotation value
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="searchInput"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>SearchedAnnotations</returns>
        SearchedAnnotations SearchAnnotations(bool? transferables = default(bool?), SearchInput searchInput = default(SearchInput), int operationIndex = 0);

        /// <summary>
        /// /annotations/search [POST]
        /// </summary>
        /// <remarks>
        /// This will search your annotations for a specific annotation  note: we will just search the annotation value
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="searchInput"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of SearchedAnnotations</returns>
        ApiResponse<SearchedAnnotations> SearchAnnotationsWithHttpInfo(bool? transferables = default(bool?), SearchInput searchInput = default(SearchInput), int operationIndex = 0);
        #endregion Synchronous Operations
    }

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public interface IAnnotationsApiAsync : IApiAccessor
    {
        #region Asynchronous Operations
        /// <summary>
        /// /annotations/create [POST]
        /// </summary>
        /// <remarks>
        /// This will create an annotation.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="seededAnnotation"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of Annotation</returns>
        System.Threading.Tasks.Task<Annotation> AnnotationsCreateNewAnnotationAsync(SeededAnnotation seededAnnotation = default(SeededAnnotation), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /annotations/create [POST]
        /// </summary>
        /// <remarks>
        /// This will create an annotation.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="seededAnnotation"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (Annotation)</returns>
        System.Threading.Tasks.Task<ApiResponse<Annotation>> AnnotationsCreateNewAnnotationWithHttpInfoAsync(SeededAnnotation seededAnnotation = default(SeededAnnotation), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /annotations/{annotation}/delete [POST]
        /// </summary>
        /// <remarks>
        /// this will delete a specific annotation
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="annotation">This is a specific annotation uuid.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task AnnotationsDeleteSpecificAnnotationAsync(string annotation, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /annotations/{annotation}/delete [POST]
        /// </summary>
        /// <remarks>
        /// this will delete a specific annotation
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="annotation">This is a specific annotation uuid.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> AnnotationsDeleteSpecificAnnotationWithHttpInfoAsync(string annotation, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /annotations [GET]
        /// </summary>
        /// <remarks>
        /// This will get a snapshot of all the annotations.  This will take an optional filter as a query param.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="annotationTypeFilter">This is an AnnotationTypeEnum as a optional filter. (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of Annotations</returns>
        System.Threading.Tasks.Task<Annotations> AnnotationsSnapshotAsync(string annotationTypeFilter = default(string), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /annotations [GET]
        /// </summary>
        /// <remarks>
        /// This will get a snapshot of all the annotations.  This will take an optional filter as a query param.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="annotationTypeFilter">This is an AnnotationTypeEnum as a optional filter. (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (Annotations)</returns>
        System.Threading.Tasks.Task<ApiResponse<Annotations>> AnnotationsSnapshotWithHttpInfoAsync(string annotationTypeFilter = default(string), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /annotations/stream/identifiers [WS]
        /// </summary>
        /// <remarks>
        /// Provides a WebSocket connection that emits changes to your annotation identifiers (UUIDs).
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of StreamedIdentifiers</returns>
        System.Threading.Tasks.Task<StreamedIdentifiers> AnnotationsStreamIdentifiersAsync(int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /annotations/stream/identifiers [WS]
        /// </summary>
        /// <remarks>
        /// Provides a WebSocket connection that emits changes to your annotation identifiers (UUIDs).
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (StreamedIdentifiers)</returns>
        System.Threading.Tasks.Task<ApiResponse<StreamedIdentifiers>> AnnotationsStreamIdentifiersWithHttpInfoAsync(int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /annotations/search [POST]
        /// </summary>
        /// <remarks>
        /// This will search your annotations for a specific annotation  note: we will just search the annotation value
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="searchInput"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of SearchedAnnotations</returns>
        System.Threading.Tasks.Task<SearchedAnnotations> SearchAnnotationsAsync(bool? transferables = default(bool?), SearchInput searchInput = default(SearchInput), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /annotations/search [POST]
        /// </summary>
        /// <remarks>
        /// This will search your annotations for a specific annotation  note: we will just search the annotation value
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="searchInput"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (SearchedAnnotations)</returns>
        System.Threading.Tasks.Task<ApiResponse<SearchedAnnotations>> SearchAnnotationsWithHttpInfoAsync(bool? transferables = default(bool?), SearchInput searchInput = default(SearchInput), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        #endregion Asynchronous Operations
    }

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public interface IAnnotationsApi : IAnnotationsApiSync, IAnnotationsApiAsync
    {

    }

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public partial class AnnotationsApi : IAnnotationsApi
    {
        private Pieces.Os.Core.Client.ExceptionFactory _exceptionFactory = (name, response) => null;

        /// <summary>
        /// Initializes a new instance of the <see cref="AnnotationsApi"/> class.
        /// </summary>
        /// <returns></returns>
        public AnnotationsApi() : this((string)null)
        {
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="AnnotationsApi"/> class.
        /// </summary>
        /// <returns></returns>
        public AnnotationsApi(string basePath)
        {
            this.Configuration = Pieces.Os.Core.Client.Configuration.MergeConfigurations(
                Pieces.Os.Core.Client.GlobalConfiguration.Instance,
                new Pieces.Os.Core.Client.Configuration { BasePath = basePath }
            );
            this.Client = new Pieces.Os.Core.Client.ApiClient(this.Configuration.BasePath);
            this.AsynchronousClient = new Pieces.Os.Core.Client.ApiClient(this.Configuration.BasePath);
            this.ExceptionFactory = Pieces.Os.Core.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="AnnotationsApi"/> class
        /// using Configuration object
        /// </summary>
        /// <param name="configuration">An instance of Configuration</param>
        /// <returns></returns>
        public AnnotationsApi(Pieces.Os.Core.Client.Configuration configuration)
        {
            if (configuration == null) throw new ArgumentNullException("configuration");

            this.Configuration = Pieces.Os.Core.Client.Configuration.MergeConfigurations(
                Pieces.Os.Core.Client.GlobalConfiguration.Instance,
                configuration
            );
            this.Client = new Pieces.Os.Core.Client.ApiClient(this.Configuration.BasePath);
            this.AsynchronousClient = new Pieces.Os.Core.Client.ApiClient(this.Configuration.BasePath);
            ExceptionFactory = Pieces.Os.Core.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="AnnotationsApi"/> class
        /// using a Configuration object and client instance.
        /// </summary>
        /// <param name="client">The client interface for synchronous API access.</param>
        /// <param name="asyncClient">The client interface for asynchronous API access.</param>
        /// <param name="configuration">The configuration object.</param>
        public AnnotationsApi(Pieces.Os.Core.Client.ISynchronousClient client, Pieces.Os.Core.Client.IAsynchronousClient asyncClient, Pieces.Os.Core.Client.IReadableConfiguration configuration)
        {
            if (client == null) throw new ArgumentNullException("client");
            if (asyncClient == null) throw new ArgumentNullException("asyncClient");
            if (configuration == null) throw new ArgumentNullException("configuration");

            this.Client = client;
            this.AsynchronousClient = asyncClient;
            this.Configuration = configuration;
            this.ExceptionFactory = Pieces.Os.Core.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// The client for accessing this underlying API asynchronously.
        /// </summary>
        public Pieces.Os.Core.Client.IAsynchronousClient AsynchronousClient { get; set; }

        /// <summary>
        /// The client for accessing this underlying API synchronously.
        /// </summary>
        public Pieces.Os.Core.Client.ISynchronousClient Client { get; set; }

        /// <summary>
        /// Gets the base path of the API client.
        /// </summary>
        /// <value>The base path</value>
        public string GetBasePath()
        {
            return this.Configuration.BasePath;
        }

        /// <summary>
        /// Gets or sets the configuration object
        /// </summary>
        /// <value>An instance of the Configuration</value>
        public Pieces.Os.Core.Client.IReadableConfiguration Configuration { get; set; }

        /// <summary>
        /// Provides a factory method hook for the creation of exceptions.
        /// </summary>
        public Pieces.Os.Core.Client.ExceptionFactory ExceptionFactory
        {
            get
            {
                if (_exceptionFactory != null && _exceptionFactory.GetInvocationList().Length > 1)
                {
                    throw new InvalidOperationException("Multicast delegate for ExceptionFactory is unsupported.");
                }
                return _exceptionFactory;
            }
            set { _exceptionFactory = value; }
        }

        /// <summary>
        /// /annotations/create [POST] This will create an annotation.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="seededAnnotation"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>Annotation</returns>
        public Annotation AnnotationsCreateNewAnnotation(SeededAnnotation seededAnnotation = default(SeededAnnotation), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.ApiResponse<Annotation> localVarResponse = AnnotationsCreateNewAnnotationWithHttpInfo(seededAnnotation);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /annotations/create [POST] This will create an annotation.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="seededAnnotation"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Annotation</returns>
        public Pieces.Os.Core.Client.ApiResponse<Annotation> AnnotationsCreateNewAnnotationWithHttpInfo(SeededAnnotation seededAnnotation = default(SeededAnnotation), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.Data = seededAnnotation;

            localVarRequestOptions.Operation = "AnnotationsApi.AnnotationsCreateNewAnnotation";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Annotation>("/annotations/create", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("AnnotationsCreateNewAnnotation", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /annotations/create [POST] This will create an annotation.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="seededAnnotation"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of Annotation</returns>
        public async System.Threading.Tasks.Task<Annotation> AnnotationsCreateNewAnnotationAsync(SeededAnnotation seededAnnotation = default(SeededAnnotation), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            Pieces.Os.Core.Client.ApiResponse<Annotation> localVarResponse = await AnnotationsCreateNewAnnotationWithHttpInfoAsync(seededAnnotation, operationIndex, cancellationToken).ConfigureAwait(false);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /annotations/create [POST] This will create an annotation.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="seededAnnotation"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (Annotation)</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Annotation>> AnnotationsCreateNewAnnotationWithHttpInfoAsync(SeededAnnotation seededAnnotation = default(SeededAnnotation), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.Data = seededAnnotation;

            localVarRequestOptions.Operation = "AnnotationsApi.AnnotationsCreateNewAnnotation";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Annotation>("/annotations/create", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("AnnotationsCreateNewAnnotation", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /annotations/{annotation}/delete [POST] this will delete a specific annotation
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="annotation">This is a specific annotation uuid.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        public void AnnotationsDeleteSpecificAnnotation(string annotation, int operationIndex = 0)
        {
            AnnotationsDeleteSpecificAnnotationWithHttpInfo(annotation);
        }

        /// <summary>
        /// /annotations/{annotation}/delete [POST] this will delete a specific annotation
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="annotation">This is a specific annotation uuid.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public Pieces.Os.Core.Client.ApiResponse<Object> AnnotationsDeleteSpecificAnnotationWithHttpInfo(string annotation, int operationIndex = 0)
        {
            // verify the required parameter 'annotation' is set
            if (annotation == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'annotation' when calling AnnotationsApi->AnnotationsDeleteSpecificAnnotation");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("annotation", Pieces.Os.Core.Client.ClientUtils.ParameterToString(annotation)); // path parameter

            localVarRequestOptions.Operation = "AnnotationsApi.AnnotationsDeleteSpecificAnnotation";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Object>("/annotations/{annotation}/delete", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("AnnotationsDeleteSpecificAnnotation", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /annotations/{annotation}/delete [POST] this will delete a specific annotation
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="annotation">This is a specific annotation uuid.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task AnnotationsDeleteSpecificAnnotationAsync(string annotation, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            await AnnotationsDeleteSpecificAnnotationWithHttpInfoAsync(annotation, operationIndex, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// /annotations/{annotation}/delete [POST] this will delete a specific annotation
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="annotation">This is a specific annotation uuid.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Object>> AnnotationsDeleteSpecificAnnotationWithHttpInfoAsync(string annotation, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'annotation' is set
            if (annotation == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'annotation' when calling AnnotationsApi->AnnotationsDeleteSpecificAnnotation");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("annotation", Pieces.Os.Core.Client.ClientUtils.ParameterToString(annotation)); // path parameter

            localVarRequestOptions.Operation = "AnnotationsApi.AnnotationsDeleteSpecificAnnotation";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Object>("/annotations/{annotation}/delete", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("AnnotationsDeleteSpecificAnnotation", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /annotations [GET] This will get a snapshot of all the annotations.  This will take an optional filter as a query param.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="annotationTypeFilter">This is an AnnotationTypeEnum as a optional filter. (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>Annotations</returns>
        public Annotations AnnotationsSnapshot(string annotationTypeFilter = default(string), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.ApiResponse<Annotations> localVarResponse = AnnotationsSnapshotWithHttpInfo(annotationTypeFilter);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /annotations [GET] This will get a snapshot of all the annotations.  This will take an optional filter as a query param.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="annotationTypeFilter">This is an AnnotationTypeEnum as a optional filter. (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Annotations</returns>
        public Pieces.Os.Core.Client.ApiResponse<Annotations> AnnotationsSnapshotWithHttpInfo(string annotationTypeFilter = default(string), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            if (annotationTypeFilter != null)
            {
                localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "annotation_type_filter", annotationTypeFilter));
            }

            localVarRequestOptions.Operation = "AnnotationsApi.AnnotationsSnapshot";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Get<Annotations>("/annotations", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("AnnotationsSnapshot", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /annotations [GET] This will get a snapshot of all the annotations.  This will take an optional filter as a query param.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="annotationTypeFilter">This is an AnnotationTypeEnum as a optional filter. (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of Annotations</returns>
        public async System.Threading.Tasks.Task<Annotations> AnnotationsSnapshotAsync(string annotationTypeFilter = default(string), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            Pieces.Os.Core.Client.ApiResponse<Annotations> localVarResponse = await AnnotationsSnapshotWithHttpInfoAsync(annotationTypeFilter, operationIndex, cancellationToken).ConfigureAwait(false);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /annotations [GET] This will get a snapshot of all the annotations.  This will take an optional filter as a query param.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="annotationTypeFilter">This is an AnnotationTypeEnum as a optional filter. (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (Annotations)</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Annotations>> AnnotationsSnapshotWithHttpInfoAsync(string annotationTypeFilter = default(string), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            if (annotationTypeFilter != null)
            {
                localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "annotation_type_filter", annotationTypeFilter));
            }

            localVarRequestOptions.Operation = "AnnotationsApi.AnnotationsSnapshot";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.GetAsync<Annotations>("/annotations", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("AnnotationsSnapshot", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /annotations/stream/identifiers [WS] Provides a WebSocket connection that emits changes to your annotation identifiers (UUIDs).
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>StreamedIdentifiers</returns>
        public StreamedIdentifiers AnnotationsStreamIdentifiers(int operationIndex = 0)
        {
            Pieces.Os.Core.Client.ApiResponse<StreamedIdentifiers> localVarResponse = AnnotationsStreamIdentifiersWithHttpInfo();
            return localVarResponse.Data;
        }

        /// <summary>
        /// /annotations/stream/identifiers [WS] Provides a WebSocket connection that emits changes to your annotation identifiers (UUIDs).
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of StreamedIdentifiers</returns>
        public Pieces.Os.Core.Client.ApiResponse<StreamedIdentifiers> AnnotationsStreamIdentifiersWithHttpInfo(int operationIndex = 0)
        {
            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }


            localVarRequestOptions.Operation = "AnnotationsApi.AnnotationsStreamIdentifiers";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Get<StreamedIdentifiers>("/annotations/stream/identifiers", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("AnnotationsStreamIdentifiers", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /annotations/stream/identifiers [WS] Provides a WebSocket connection that emits changes to your annotation identifiers (UUIDs).
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of StreamedIdentifiers</returns>
        public async System.Threading.Tasks.Task<StreamedIdentifiers> AnnotationsStreamIdentifiersAsync(int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            Pieces.Os.Core.Client.ApiResponse<StreamedIdentifiers> localVarResponse = await AnnotationsStreamIdentifiersWithHttpInfoAsync(operationIndex, cancellationToken).ConfigureAwait(false);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /annotations/stream/identifiers [WS] Provides a WebSocket connection that emits changes to your annotation identifiers (UUIDs).
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (StreamedIdentifiers)</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<StreamedIdentifiers>> AnnotationsStreamIdentifiersWithHttpInfoAsync(int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }


            localVarRequestOptions.Operation = "AnnotationsApi.AnnotationsStreamIdentifiers";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.GetAsync<StreamedIdentifiers>("/annotations/stream/identifiers", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("AnnotationsStreamIdentifiers", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /annotations/search [POST] This will search your annotations for a specific annotation  note: we will just search the annotation value
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="searchInput"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>SearchedAnnotations</returns>
        public SearchedAnnotations SearchAnnotations(bool? transferables = default(bool?), SearchInput searchInput = default(SearchInput), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.ApiResponse<SearchedAnnotations> localVarResponse = SearchAnnotationsWithHttpInfo(transferables, searchInput);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /annotations/search [POST] This will search your annotations for a specific annotation  note: we will just search the annotation value
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="searchInput"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of SearchedAnnotations</returns>
        public Pieces.Os.Core.Client.ApiResponse<SearchedAnnotations> SearchAnnotationsWithHttpInfo(bool? transferables = default(bool?), SearchInput searchInput = default(SearchInput), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            if (transferables != null)
            {
                localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "transferables", transferables));
            }
            localVarRequestOptions.Data = searchInput;

            localVarRequestOptions.Operation = "AnnotationsApi.SearchAnnotations";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<SearchedAnnotations>("/annotations/search", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("SearchAnnotations", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /annotations/search [POST] This will search your annotations for a specific annotation  note: we will just search the annotation value
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="searchInput"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of SearchedAnnotations</returns>
        public async System.Threading.Tasks.Task<SearchedAnnotations> SearchAnnotationsAsync(bool? transferables = default(bool?), SearchInput searchInput = default(SearchInput), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            Pieces.Os.Core.Client.ApiResponse<SearchedAnnotations> localVarResponse = await SearchAnnotationsWithHttpInfoAsync(transferables, searchInput, operationIndex, cancellationToken).ConfigureAwait(false);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /annotations/search [POST] This will search your annotations for a specific annotation  note: we will just search the annotation value
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="searchInput"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (SearchedAnnotations)</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<SearchedAnnotations>> SearchAnnotationsWithHttpInfoAsync(bool? transferables = default(bool?), SearchInput searchInput = default(SearchInput), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            if (transferables != null)
            {
                localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "transferables", transferables));
            }
            localVarRequestOptions.Data = searchInput;

            localVarRequestOptions.Operation = "AnnotationsApi.SearchAnnotations";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<SearchedAnnotations>("/annotations/search", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("SearchAnnotations", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

    }
}
