/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Net;
using System.Net.Mime;
using Pieces.Os.Core.Client;
using Pieces.Os.Core.Client.Auth;
using Pieces.Os.Core.SdkModel;

namespace Pieces.Os.Core.Api
{

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public interface IAnchorApiSync : IApiAccessor
    {
        #region Synchronous Operations
        /// <summary>
        /// /anchor/{anchor}/assets/associate/{asset} [POST]
        /// </summary>
        /// <remarks>
        /// associates an anchor and an asset. It performs the same action as the asset equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        void AnchorAssociateAsset(string anchor, Guid asset, int operationIndex = 0);

        /// <summary>
        /// /anchor/{anchor}/assets/associate/{asset} [POST]
        /// </summary>
        /// <remarks>
        /// associates an anchor and an asset. It performs the same action as the asset equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> AnchorAssociateAssetWithHttpInfo(string anchor, Guid asset, int operationIndex = 0);
        /// <summary>
        /// /anchor/{anchor}/conversations/associate/{conversation} [POST]
        /// </summary>
        /// <remarks>
        /// associates an anchor and a conversation. It performs the same action as the conversation equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        void AnchorAssociateConversation(string anchor, string conversation, int operationIndex = 0);

        /// <summary>
        /// /anchor/{anchor}/conversations/associate/{conversation} [POST]
        /// </summary>
        /// <remarks>
        /// associates an anchor and a conversation. It performs the same action as the conversation equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> AnchorAssociateConversationWithHttpInfo(string anchor, string conversation, int operationIndex = 0);
        /// <summary>
        /// /anchor/{anchor}/messages/associate/{message} [POST]
        /// </summary>
        /// <remarks>
        /// This will associate a anchor with a message.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        void AnchorAssociateMessage(string anchor, string message, int operationIndex = 0);

        /// <summary>
        /// /anchor/{anchor}/messages/associate/{message} [POST]
        /// </summary>
        /// <remarks>
        /// This will associate a anchor with a message.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> AnchorAssociateMessageWithHttpInfo(string anchor, string message, int operationIndex = 0);
        /// <summary>
        /// /anchor/{anchor}/persons/associate/{person} [POST]
        /// </summary>
        /// <remarks>
        /// associates an anchor and a person. It performs the same action as the person equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="person">This is a uuid that represents a person.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        void AnchorAssociatePerson(string anchor, string person, int operationIndex = 0);

        /// <summary>
        /// /anchor/{anchor}/persons/associate/{person} [POST]
        /// </summary>
        /// <remarks>
        /// associates an anchor and a person. It performs the same action as the person equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="person">This is a uuid that represents a person.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> AnchorAssociatePersonWithHttpInfo(string anchor, string person, int operationIndex = 0);
        /// <summary>
        /// /anchor/{anchor}/workstream_summaries/associate/{workstream_summary} [POST]
        /// </summary>
        /// <remarks>
        /// This will associate a anchor with a workstream summary. This will do the same thing as the workstreamSummary equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="workstreamSummary">This is a identifier that is used to identify a specific workstream_summary.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        void AnchorAssociateWorkstreamSummary(string anchor, string workstreamSummary, int operationIndex = 0);

        /// <summary>
        /// /anchor/{anchor}/workstream_summaries/associate/{workstream_summary} [POST]
        /// </summary>
        /// <remarks>
        /// This will associate a anchor with a workstream summary. This will do the same thing as the workstreamSummary equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="workstreamSummary">This is a identifier that is used to identify a specific workstream_summary.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> AnchorAssociateWorkstreamSummaryWithHttpInfo(string anchor, string workstreamSummary, int operationIndex = 0);
        /// <summary>
        /// /anchor/{anchor}/assets/disassociate/{asset} [POST]
        /// </summary>
        /// <remarks>
        /// Disassociates an anchor from an asset. It performs the same action as the asset equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        void AnchorDisassociateAsset(string anchor, Guid asset, int operationIndex = 0);

        /// <summary>
        /// /anchor/{anchor}/assets/disassociate/{asset} [POST]
        /// </summary>
        /// <remarks>
        /// Disassociates an anchor from an asset. It performs the same action as the asset equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> AnchorDisassociateAssetWithHttpInfo(string anchor, Guid asset, int operationIndex = 0);
        /// <summary>
        /// /anchor/{anchor}/conversations/disassociate/{conversation} [POST]
        /// </summary>
        /// <remarks>
        /// Disassociates an anchor from a conversation. It performs the same action as the conversation equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        void AnchorDisassociateConversation(string anchor, string conversation, int operationIndex = 0);

        /// <summary>
        /// /anchor/{anchor}/conversations/disassociate/{conversation} [POST]
        /// </summary>
        /// <remarks>
        /// Disassociates an anchor from a conversation. It performs the same action as the conversation equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> AnchorDisassociateConversationWithHttpInfo(string anchor, string conversation, int operationIndex = 0);
        /// <summary>
        /// /anchor/{anchor}/messages/disassociate/{message} [POST]
        /// </summary>
        /// <remarks>
        /// This will enable us to disassociate a anchor from a message.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        void AnchorDisassociateMessage(string anchor, string message, int operationIndex = 0);

        /// <summary>
        /// /anchor/{anchor}/messages/disassociate/{message} [POST]
        /// </summary>
        /// <remarks>
        /// This will enable us to disassociate a anchor from a message.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> AnchorDisassociateMessageWithHttpInfo(string anchor, string message, int operationIndex = 0);
        /// <summary>
        /// /anchor/{anchor}/persons/disassociate/{person} [POST]
        /// </summary>
        /// <remarks>
        /// Disassociates an anchor from a person. It performs the same action as the person equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="person">This is a uuid that represents a person.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        void AnchorDisassociatePerson(string anchor, string person, int operationIndex = 0);

        /// <summary>
        /// /anchor/{anchor}/persons/disassociate/{person} [POST]
        /// </summary>
        /// <remarks>
        /// Disassociates an anchor from a person. It performs the same action as the person equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="person">This is a uuid that represents a person.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> AnchorDisassociatePersonWithHttpInfo(string anchor, string person, int operationIndex = 0);
        /// <summary>
        /// /anchor/{anchor}/workstream_summaries/disassociate/{workstream_summary} [POST]
        /// </summary>
        /// <remarks>
        /// This will enable us to disassociate a anchor from a workstream summary. This will do the same thing as the workstreamSummary equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="workstreamSummary">This is a identifier that is used to identify a specific workstream_summary.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        void AnchorDisassociateWorkstreamSummary(string anchor, string workstreamSummary, int operationIndex = 0);

        /// <summary>
        /// /anchor/{anchor}/workstream_summaries/disassociate/{workstream_summary} [POST]
        /// </summary>
        /// <remarks>
        /// This will enable us to disassociate a anchor from a workstream summary. This will do the same thing as the workstreamSummary equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="workstreamSummary">This is a identifier that is used to identify a specific workstream_summary.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> AnchorDisassociateWorkstreamSummaryWithHttpInfo(string anchor, string workstreamSummary, int operationIndex = 0);
        /// <summary>
        /// /anchor/{anchor}/rename [POST]
        /// </summary>
        /// <remarks>
        /// This will rename a specific anchor.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>Anchor</returns>
        Anchor AnchorRename(string anchor, bool? transferables = default(bool?), int operationIndex = 0);

        /// <summary>
        /// /anchor/{anchor}/rename [POST]
        /// </summary>
        /// <remarks>
        /// This will rename a specific anchor.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Anchor</returns>
        ApiResponse<Anchor> AnchorRenameWithHttpInfo(string anchor, bool? transferables = default(bool?), int operationIndex = 0);
        /// <summary>
        /// &#39;/anchor/{anchor}/scores/increment&#39; [POST]
        /// </summary>
        /// <remarks>
        /// This will take in a SeededScoreIncrement and will increment the material relative to the incoming body.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="seededScoreIncrement"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        void AnchorScoresIncrement(string anchor, SeededScoreIncrement seededScoreIncrement = default(SeededScoreIncrement), int operationIndex = 0);

        /// <summary>
        /// &#39;/anchor/{anchor}/scores/increment&#39; [POST]
        /// </summary>
        /// <remarks>
        /// This will take in a SeededScoreIncrement and will increment the material relative to the incoming body.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="seededScoreIncrement"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        ApiResponse<Object> AnchorScoresIncrementWithHttpInfo(string anchor, SeededScoreIncrement seededScoreIncrement = default(SeededScoreIncrement), int operationIndex = 0);
        /// <summary>
        /// /anchor/{anchor} [GET]
        /// </summary>
        /// <remarks>
        /// This will get a snapshot of a single anchor.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>Anchor</returns>
        Anchor AnchorSpecificAnchorSnapshot(string anchor, bool? transferables = default(bool?), int operationIndex = 0);

        /// <summary>
        /// /anchor/{anchor} [GET]
        /// </summary>
        /// <remarks>
        /// This will get a snapshot of a single anchor.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Anchor</returns>
        ApiResponse<Anchor> AnchorSpecificAnchorSnapshotWithHttpInfo(string anchor, bool? transferables = default(bool?), int operationIndex = 0);
        /// <summary>
        /// /anchor/update [POST]
        /// </summary>
        /// <remarks>
        /// This will update a specific anchor.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="anchor"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>Anchor</returns>
        Anchor AnchorUpdate(bool? transferables = default(bool?), Anchor anchor = default(Anchor), int operationIndex = 0);

        /// <summary>
        /// /anchor/update [POST]
        /// </summary>
        /// <remarks>
        /// This will update a specific anchor.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="anchor"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Anchor</returns>
        ApiResponse<Anchor> AnchorUpdateWithHttpInfo(bool? transferables = default(bool?), Anchor anchor = default(Anchor), int operationIndex = 0);
        #endregion Synchronous Operations
    }

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public interface IAnchorApiAsync : IApiAccessor
    {
        #region Asynchronous Operations
        /// <summary>
        /// /anchor/{anchor}/assets/associate/{asset} [POST]
        /// </summary>
        /// <remarks>
        /// associates an anchor and an asset. It performs the same action as the asset equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task AnchorAssociateAssetAsync(string anchor, Guid asset, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /anchor/{anchor}/assets/associate/{asset} [POST]
        /// </summary>
        /// <remarks>
        /// associates an anchor and an asset. It performs the same action as the asset equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> AnchorAssociateAssetWithHttpInfoAsync(string anchor, Guid asset, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /anchor/{anchor}/conversations/associate/{conversation} [POST]
        /// </summary>
        /// <remarks>
        /// associates an anchor and a conversation. It performs the same action as the conversation equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task AnchorAssociateConversationAsync(string anchor, string conversation, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /anchor/{anchor}/conversations/associate/{conversation} [POST]
        /// </summary>
        /// <remarks>
        /// associates an anchor and a conversation. It performs the same action as the conversation equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> AnchorAssociateConversationWithHttpInfoAsync(string anchor, string conversation, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /anchor/{anchor}/messages/associate/{message} [POST]
        /// </summary>
        /// <remarks>
        /// This will associate a anchor with a message.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task AnchorAssociateMessageAsync(string anchor, string message, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /anchor/{anchor}/messages/associate/{message} [POST]
        /// </summary>
        /// <remarks>
        /// This will associate a anchor with a message.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> AnchorAssociateMessageWithHttpInfoAsync(string anchor, string message, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /anchor/{anchor}/persons/associate/{person} [POST]
        /// </summary>
        /// <remarks>
        /// associates an anchor and a person. It performs the same action as the person equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="person">This is a uuid that represents a person.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task AnchorAssociatePersonAsync(string anchor, string person, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /anchor/{anchor}/persons/associate/{person} [POST]
        /// </summary>
        /// <remarks>
        /// associates an anchor and a person. It performs the same action as the person equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="person">This is a uuid that represents a person.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> AnchorAssociatePersonWithHttpInfoAsync(string anchor, string person, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /anchor/{anchor}/workstream_summaries/associate/{workstream_summary} [POST]
        /// </summary>
        /// <remarks>
        /// This will associate a anchor with a workstream summary. This will do the same thing as the workstreamSummary equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="workstreamSummary">This is a identifier that is used to identify a specific workstream_summary.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task AnchorAssociateWorkstreamSummaryAsync(string anchor, string workstreamSummary, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /anchor/{anchor}/workstream_summaries/associate/{workstream_summary} [POST]
        /// </summary>
        /// <remarks>
        /// This will associate a anchor with a workstream summary. This will do the same thing as the workstreamSummary equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="workstreamSummary">This is a identifier that is used to identify a specific workstream_summary.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> AnchorAssociateWorkstreamSummaryWithHttpInfoAsync(string anchor, string workstreamSummary, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /anchor/{anchor}/assets/disassociate/{asset} [POST]
        /// </summary>
        /// <remarks>
        /// Disassociates an anchor from an asset. It performs the same action as the asset equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task AnchorDisassociateAssetAsync(string anchor, Guid asset, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /anchor/{anchor}/assets/disassociate/{asset} [POST]
        /// </summary>
        /// <remarks>
        /// Disassociates an anchor from an asset. It performs the same action as the asset equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> AnchorDisassociateAssetWithHttpInfoAsync(string anchor, Guid asset, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /anchor/{anchor}/conversations/disassociate/{conversation} [POST]
        /// </summary>
        /// <remarks>
        /// Disassociates an anchor from a conversation. It performs the same action as the conversation equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task AnchorDisassociateConversationAsync(string anchor, string conversation, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /anchor/{anchor}/conversations/disassociate/{conversation} [POST]
        /// </summary>
        /// <remarks>
        /// Disassociates an anchor from a conversation. It performs the same action as the conversation equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> AnchorDisassociateConversationWithHttpInfoAsync(string anchor, string conversation, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /anchor/{anchor}/messages/disassociate/{message} [POST]
        /// </summary>
        /// <remarks>
        /// This will enable us to disassociate a anchor from a message.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task AnchorDisassociateMessageAsync(string anchor, string message, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /anchor/{anchor}/messages/disassociate/{message} [POST]
        /// </summary>
        /// <remarks>
        /// This will enable us to disassociate a anchor from a message.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> AnchorDisassociateMessageWithHttpInfoAsync(string anchor, string message, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /anchor/{anchor}/persons/disassociate/{person} [POST]
        /// </summary>
        /// <remarks>
        /// Disassociates an anchor from a person. It performs the same action as the person equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="person">This is a uuid that represents a person.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task AnchorDisassociatePersonAsync(string anchor, string person, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /anchor/{anchor}/persons/disassociate/{person} [POST]
        /// </summary>
        /// <remarks>
        /// Disassociates an anchor from a person. It performs the same action as the person equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="person">This is a uuid that represents a person.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> AnchorDisassociatePersonWithHttpInfoAsync(string anchor, string person, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /anchor/{anchor}/workstream_summaries/disassociate/{workstream_summary} [POST]
        /// </summary>
        /// <remarks>
        /// This will enable us to disassociate a anchor from a workstream summary. This will do the same thing as the workstreamSummary equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="workstreamSummary">This is a identifier that is used to identify a specific workstream_summary.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task AnchorDisassociateWorkstreamSummaryAsync(string anchor, string workstreamSummary, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /anchor/{anchor}/workstream_summaries/disassociate/{workstream_summary} [POST]
        /// </summary>
        /// <remarks>
        /// This will enable us to disassociate a anchor from a workstream summary. This will do the same thing as the workstreamSummary equivalent.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="workstreamSummary">This is a identifier that is used to identify a specific workstream_summary.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> AnchorDisassociateWorkstreamSummaryWithHttpInfoAsync(string anchor, string workstreamSummary, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /anchor/{anchor}/rename [POST]
        /// </summary>
        /// <remarks>
        /// This will rename a specific anchor.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of Anchor</returns>
        System.Threading.Tasks.Task<Anchor> AnchorRenameAsync(string anchor, bool? transferables = default(bool?), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /anchor/{anchor}/rename [POST]
        /// </summary>
        /// <remarks>
        /// This will rename a specific anchor.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (Anchor)</returns>
        System.Threading.Tasks.Task<ApiResponse<Anchor>> AnchorRenameWithHttpInfoAsync(string anchor, bool? transferables = default(bool?), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// &#39;/anchor/{anchor}/scores/increment&#39; [POST]
        /// </summary>
        /// <remarks>
        /// This will take in a SeededScoreIncrement and will increment the material relative to the incoming body.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="seededScoreIncrement"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        System.Threading.Tasks.Task AnchorScoresIncrementAsync(string anchor, SeededScoreIncrement seededScoreIncrement = default(SeededScoreIncrement), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// &#39;/anchor/{anchor}/scores/increment&#39; [POST]
        /// </summary>
        /// <remarks>
        /// This will take in a SeededScoreIncrement and will increment the material relative to the incoming body.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="seededScoreIncrement"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        System.Threading.Tasks.Task<ApiResponse<Object>> AnchorScoresIncrementWithHttpInfoAsync(string anchor, SeededScoreIncrement seededScoreIncrement = default(SeededScoreIncrement), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /anchor/{anchor} [GET]
        /// </summary>
        /// <remarks>
        /// This will get a snapshot of a single anchor.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of Anchor</returns>
        System.Threading.Tasks.Task<Anchor> AnchorSpecificAnchorSnapshotAsync(string anchor, bool? transferables = default(bool?), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /anchor/{anchor} [GET]
        /// </summary>
        /// <remarks>
        /// This will get a snapshot of a single anchor.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (Anchor)</returns>
        System.Threading.Tasks.Task<ApiResponse<Anchor>> AnchorSpecificAnchorSnapshotWithHttpInfoAsync(string anchor, bool? transferables = default(bool?), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        /// <summary>
        /// /anchor/update [POST]
        /// </summary>
        /// <remarks>
        /// This will update a specific anchor.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="anchor"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of Anchor</returns>
        System.Threading.Tasks.Task<Anchor> AnchorUpdateAsync(bool? transferables = default(bool?), Anchor anchor = default(Anchor), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));

        /// <summary>
        /// /anchor/update [POST]
        /// </summary>
        /// <remarks>
        /// This will update a specific anchor.
        /// </remarks>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="anchor"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (Anchor)</returns>
        System.Threading.Tasks.Task<ApiResponse<Anchor>> AnchorUpdateWithHttpInfoAsync(bool? transferables = default(bool?), Anchor anchor = default(Anchor), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken));
        #endregion Asynchronous Operations
    }

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public interface IAnchorApi : IAnchorApiSync, IAnchorApiAsync
    {

    }

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public partial class AnchorApi : IAnchorApi
    {
        private Pieces.Os.Core.Client.ExceptionFactory _exceptionFactory = (name, response) => null;

        /// <summary>
        /// Initializes a new instance of the <see cref="AnchorApi"/> class.
        /// </summary>
        /// <returns></returns>
        public AnchorApi() : this((string)null)
        {
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="AnchorApi"/> class.
        /// </summary>
        /// <returns></returns>
        public AnchorApi(string basePath)
        {
            this.Configuration = Pieces.Os.Core.Client.Configuration.MergeConfigurations(
                Pieces.Os.Core.Client.GlobalConfiguration.Instance,
                new Pieces.Os.Core.Client.Configuration { BasePath = basePath }
            );
            this.Client = new Pieces.Os.Core.Client.ApiClient(this.Configuration.BasePath);
            this.AsynchronousClient = new Pieces.Os.Core.Client.ApiClient(this.Configuration.BasePath);
            this.ExceptionFactory = Pieces.Os.Core.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="AnchorApi"/> class
        /// using Configuration object
        /// </summary>
        /// <param name="configuration">An instance of Configuration</param>
        /// <returns></returns>
        public AnchorApi(Pieces.Os.Core.Client.Configuration configuration)
        {
            if (configuration == null) throw new ArgumentNullException("configuration");

            this.Configuration = Pieces.Os.Core.Client.Configuration.MergeConfigurations(
                Pieces.Os.Core.Client.GlobalConfiguration.Instance,
                configuration
            );
            this.Client = new Pieces.Os.Core.Client.ApiClient(this.Configuration.BasePath);
            this.AsynchronousClient = new Pieces.Os.Core.Client.ApiClient(this.Configuration.BasePath);
            ExceptionFactory = Pieces.Os.Core.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="AnchorApi"/> class
        /// using a Configuration object and client instance.
        /// </summary>
        /// <param name="client">The client interface for synchronous API access.</param>
        /// <param name="asyncClient">The client interface for asynchronous API access.</param>
        /// <param name="configuration">The configuration object.</param>
        public AnchorApi(Pieces.Os.Core.Client.ISynchronousClient client, Pieces.Os.Core.Client.IAsynchronousClient asyncClient, Pieces.Os.Core.Client.IReadableConfiguration configuration)
        {
            if (client == null) throw new ArgumentNullException("client");
            if (asyncClient == null) throw new ArgumentNullException("asyncClient");
            if (configuration == null) throw new ArgumentNullException("configuration");

            this.Client = client;
            this.AsynchronousClient = asyncClient;
            this.Configuration = configuration;
            this.ExceptionFactory = Pieces.Os.Core.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// The client for accessing this underlying API asynchronously.
        /// </summary>
        public Pieces.Os.Core.Client.IAsynchronousClient AsynchronousClient { get; set; }

        /// <summary>
        /// The client for accessing this underlying API synchronously.
        /// </summary>
        public Pieces.Os.Core.Client.ISynchronousClient Client { get; set; }

        /// <summary>
        /// Gets the base path of the API client.
        /// </summary>
        /// <value>The base path</value>
        public string GetBasePath()
        {
            return this.Configuration.BasePath;
        }

        /// <summary>
        /// Gets or sets the configuration object
        /// </summary>
        /// <value>An instance of the Configuration</value>
        public Pieces.Os.Core.Client.IReadableConfiguration Configuration { get; set; }

        /// <summary>
        /// Provides a factory method hook for the creation of exceptions.
        /// </summary>
        public Pieces.Os.Core.Client.ExceptionFactory ExceptionFactory
        {
            get
            {
                if (_exceptionFactory != null && _exceptionFactory.GetInvocationList().Length > 1)
                {
                    throw new InvalidOperationException("Multicast delegate for ExceptionFactory is unsupported.");
                }
                return _exceptionFactory;
            }
            set { _exceptionFactory = value; }
        }

        /// <summary>
        /// /anchor/{anchor}/assets/associate/{asset} [POST] associates an anchor and an asset. It performs the same action as the asset equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        public void AnchorAssociateAsset(string anchor, Guid asset, int operationIndex = 0)
        {
            AnchorAssociateAssetWithHttpInfo(anchor, asset);
        }

        /// <summary>
        /// /anchor/{anchor}/assets/associate/{asset} [POST] associates an anchor and an asset. It performs the same action as the asset equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public Pieces.Os.Core.Client.ApiResponse<Object> AnchorAssociateAssetWithHttpInfo(string anchor, Guid asset, int operationIndex = 0)
        {
            // verify the required parameter 'anchor' is set
            if (anchor == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'anchor' when calling AnchorApi->AnchorAssociateAsset");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("anchor", Pieces.Os.Core.Client.ClientUtils.ParameterToString(anchor)); // path parameter
            localVarRequestOptions.PathParameters.Add("asset", Pieces.Os.Core.Client.ClientUtils.ParameterToString(asset)); // path parameter

            localVarRequestOptions.Operation = "AnchorApi.AnchorAssociateAsset";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Object>("/anchor/{anchor}/assets/associate/{asset}", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("AnchorAssociateAsset", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /anchor/{anchor}/assets/associate/{asset} [POST] associates an anchor and an asset. It performs the same action as the asset equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task AnchorAssociateAssetAsync(string anchor, Guid asset, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            await AnchorAssociateAssetWithHttpInfoAsync(anchor, asset, operationIndex, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// /anchor/{anchor}/assets/associate/{asset} [POST] associates an anchor and an asset. It performs the same action as the asset equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Object>> AnchorAssociateAssetWithHttpInfoAsync(string anchor, Guid asset, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'anchor' is set
            if (anchor == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'anchor' when calling AnchorApi->AnchorAssociateAsset");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("anchor", Pieces.Os.Core.Client.ClientUtils.ParameterToString(anchor)); // path parameter
            localVarRequestOptions.PathParameters.Add("asset", Pieces.Os.Core.Client.ClientUtils.ParameterToString(asset)); // path parameter

            localVarRequestOptions.Operation = "AnchorApi.AnchorAssociateAsset";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Object>("/anchor/{anchor}/assets/associate/{asset}", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("AnchorAssociateAsset", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /anchor/{anchor}/conversations/associate/{conversation} [POST] associates an anchor and a conversation. It performs the same action as the conversation equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        public void AnchorAssociateConversation(string anchor, string conversation, int operationIndex = 0)
        {
            AnchorAssociateConversationWithHttpInfo(anchor, conversation);
        }

        /// <summary>
        /// /anchor/{anchor}/conversations/associate/{conversation} [POST] associates an anchor and a conversation. It performs the same action as the conversation equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public Pieces.Os.Core.Client.ApiResponse<Object> AnchorAssociateConversationWithHttpInfo(string anchor, string conversation, int operationIndex = 0)
        {
            // verify the required parameter 'anchor' is set
            if (anchor == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'anchor' when calling AnchorApi->AnchorAssociateConversation");
            }

            // verify the required parameter 'conversation' is set
            if (conversation == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'conversation' when calling AnchorApi->AnchorAssociateConversation");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("anchor", Pieces.Os.Core.Client.ClientUtils.ParameterToString(anchor)); // path parameter
            localVarRequestOptions.PathParameters.Add("conversation", Pieces.Os.Core.Client.ClientUtils.ParameterToString(conversation)); // path parameter

            localVarRequestOptions.Operation = "AnchorApi.AnchorAssociateConversation";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Object>("/anchor/{anchor}/conversations/associate/{conversation}", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("AnchorAssociateConversation", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /anchor/{anchor}/conversations/associate/{conversation} [POST] associates an anchor and a conversation. It performs the same action as the conversation equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task AnchorAssociateConversationAsync(string anchor, string conversation, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            await AnchorAssociateConversationWithHttpInfoAsync(anchor, conversation, operationIndex, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// /anchor/{anchor}/conversations/associate/{conversation} [POST] associates an anchor and a conversation. It performs the same action as the conversation equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Object>> AnchorAssociateConversationWithHttpInfoAsync(string anchor, string conversation, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'anchor' is set
            if (anchor == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'anchor' when calling AnchorApi->AnchorAssociateConversation");
            }

            // verify the required parameter 'conversation' is set
            if (conversation == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'conversation' when calling AnchorApi->AnchorAssociateConversation");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("anchor", Pieces.Os.Core.Client.ClientUtils.ParameterToString(anchor)); // path parameter
            localVarRequestOptions.PathParameters.Add("conversation", Pieces.Os.Core.Client.ClientUtils.ParameterToString(conversation)); // path parameter

            localVarRequestOptions.Operation = "AnchorApi.AnchorAssociateConversation";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Object>("/anchor/{anchor}/conversations/associate/{conversation}", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("AnchorAssociateConversation", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /anchor/{anchor}/messages/associate/{message} [POST] This will associate a anchor with a message.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        public void AnchorAssociateMessage(string anchor, string message, int operationIndex = 0)
        {
            AnchorAssociateMessageWithHttpInfo(anchor, message);
        }

        /// <summary>
        /// /anchor/{anchor}/messages/associate/{message} [POST] This will associate a anchor with a message.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public Pieces.Os.Core.Client.ApiResponse<Object> AnchorAssociateMessageWithHttpInfo(string anchor, string message, int operationIndex = 0)
        {
            // verify the required parameter 'anchor' is set
            if (anchor == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'anchor' when calling AnchorApi->AnchorAssociateMessage");
            }

            // verify the required parameter 'message' is set
            if (message == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'message' when calling AnchorApi->AnchorAssociateMessage");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("anchor", Pieces.Os.Core.Client.ClientUtils.ParameterToString(anchor)); // path parameter
            localVarRequestOptions.PathParameters.Add("message", Pieces.Os.Core.Client.ClientUtils.ParameterToString(message)); // path parameter

            localVarRequestOptions.Operation = "AnchorApi.AnchorAssociateMessage";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Object>("/anchor/{anchor}/messages/associate/{message}", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("AnchorAssociateMessage", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /anchor/{anchor}/messages/associate/{message} [POST] This will associate a anchor with a message.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task AnchorAssociateMessageAsync(string anchor, string message, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            await AnchorAssociateMessageWithHttpInfoAsync(anchor, message, operationIndex, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// /anchor/{anchor}/messages/associate/{message} [POST] This will associate a anchor with a message.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Object>> AnchorAssociateMessageWithHttpInfoAsync(string anchor, string message, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'anchor' is set
            if (anchor == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'anchor' when calling AnchorApi->AnchorAssociateMessage");
            }

            // verify the required parameter 'message' is set
            if (message == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'message' when calling AnchorApi->AnchorAssociateMessage");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("anchor", Pieces.Os.Core.Client.ClientUtils.ParameterToString(anchor)); // path parameter
            localVarRequestOptions.PathParameters.Add("message", Pieces.Os.Core.Client.ClientUtils.ParameterToString(message)); // path parameter

            localVarRequestOptions.Operation = "AnchorApi.AnchorAssociateMessage";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Object>("/anchor/{anchor}/messages/associate/{message}", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("AnchorAssociateMessage", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /anchor/{anchor}/persons/associate/{person} [POST] associates an anchor and a person. It performs the same action as the person equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="person">This is a uuid that represents a person.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        public void AnchorAssociatePerson(string anchor, string person, int operationIndex = 0)
        {
            AnchorAssociatePersonWithHttpInfo(anchor, person);
        }

        /// <summary>
        /// /anchor/{anchor}/persons/associate/{person} [POST] associates an anchor and a person. It performs the same action as the person equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="person">This is a uuid that represents a person.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public Pieces.Os.Core.Client.ApiResponse<Object> AnchorAssociatePersonWithHttpInfo(string anchor, string person, int operationIndex = 0)
        {
            // verify the required parameter 'anchor' is set
            if (anchor == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'anchor' when calling AnchorApi->AnchorAssociatePerson");
            }

            // verify the required parameter 'person' is set
            if (person == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'person' when calling AnchorApi->AnchorAssociatePerson");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("anchor", Pieces.Os.Core.Client.ClientUtils.ParameterToString(anchor)); // path parameter
            localVarRequestOptions.PathParameters.Add("person", Pieces.Os.Core.Client.ClientUtils.ParameterToString(person)); // path parameter

            localVarRequestOptions.Operation = "AnchorApi.AnchorAssociatePerson";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Object>("/anchor/{anchor}/persons/associate/{person}", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("AnchorAssociatePerson", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /anchor/{anchor}/persons/associate/{person} [POST] associates an anchor and a person. It performs the same action as the person equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="person">This is a uuid that represents a person.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task AnchorAssociatePersonAsync(string anchor, string person, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            await AnchorAssociatePersonWithHttpInfoAsync(anchor, person, operationIndex, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// /anchor/{anchor}/persons/associate/{person} [POST] associates an anchor and a person. It performs the same action as the person equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="person">This is a uuid that represents a person.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Object>> AnchorAssociatePersonWithHttpInfoAsync(string anchor, string person, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'anchor' is set
            if (anchor == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'anchor' when calling AnchorApi->AnchorAssociatePerson");
            }

            // verify the required parameter 'person' is set
            if (person == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'person' when calling AnchorApi->AnchorAssociatePerson");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("anchor", Pieces.Os.Core.Client.ClientUtils.ParameterToString(anchor)); // path parameter
            localVarRequestOptions.PathParameters.Add("person", Pieces.Os.Core.Client.ClientUtils.ParameterToString(person)); // path parameter

            localVarRequestOptions.Operation = "AnchorApi.AnchorAssociatePerson";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Object>("/anchor/{anchor}/persons/associate/{person}", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("AnchorAssociatePerson", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /anchor/{anchor}/workstream_summaries/associate/{workstream_summary} [POST] This will associate a anchor with a workstream summary. This will do the same thing as the workstreamSummary equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="workstreamSummary">This is a identifier that is used to identify a specific workstream_summary.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        public void AnchorAssociateWorkstreamSummary(string anchor, string workstreamSummary, int operationIndex = 0)
        {
            AnchorAssociateWorkstreamSummaryWithHttpInfo(anchor, workstreamSummary);
        }

        /// <summary>
        /// /anchor/{anchor}/workstream_summaries/associate/{workstream_summary} [POST] This will associate a anchor with a workstream summary. This will do the same thing as the workstreamSummary equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="workstreamSummary">This is a identifier that is used to identify a specific workstream_summary.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public Pieces.Os.Core.Client.ApiResponse<Object> AnchorAssociateWorkstreamSummaryWithHttpInfo(string anchor, string workstreamSummary, int operationIndex = 0)
        {
            // verify the required parameter 'anchor' is set
            if (anchor == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'anchor' when calling AnchorApi->AnchorAssociateWorkstreamSummary");
            }

            // verify the required parameter 'workstreamSummary' is set
            if (workstreamSummary == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'workstreamSummary' when calling AnchorApi->AnchorAssociateWorkstreamSummary");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("anchor", Pieces.Os.Core.Client.ClientUtils.ParameterToString(anchor)); // path parameter
            localVarRequestOptions.PathParameters.Add("workstream_summary", Pieces.Os.Core.Client.ClientUtils.ParameterToString(workstreamSummary)); // path parameter

            localVarRequestOptions.Operation = "AnchorApi.AnchorAssociateWorkstreamSummary";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Object>("/anchor/{anchor}/workstream_summaries/associate/{workstream_summary}", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("AnchorAssociateWorkstreamSummary", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /anchor/{anchor}/workstream_summaries/associate/{workstream_summary} [POST] This will associate a anchor with a workstream summary. This will do the same thing as the workstreamSummary equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="workstreamSummary">This is a identifier that is used to identify a specific workstream_summary.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task AnchorAssociateWorkstreamSummaryAsync(string anchor, string workstreamSummary, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            await AnchorAssociateWorkstreamSummaryWithHttpInfoAsync(anchor, workstreamSummary, operationIndex, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// /anchor/{anchor}/workstream_summaries/associate/{workstream_summary} [POST] This will associate a anchor with a workstream summary. This will do the same thing as the workstreamSummary equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="workstreamSummary">This is a identifier that is used to identify a specific workstream_summary.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Object>> AnchorAssociateWorkstreamSummaryWithHttpInfoAsync(string anchor, string workstreamSummary, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'anchor' is set
            if (anchor == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'anchor' when calling AnchorApi->AnchorAssociateWorkstreamSummary");
            }

            // verify the required parameter 'workstreamSummary' is set
            if (workstreamSummary == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'workstreamSummary' when calling AnchorApi->AnchorAssociateWorkstreamSummary");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("anchor", Pieces.Os.Core.Client.ClientUtils.ParameterToString(anchor)); // path parameter
            localVarRequestOptions.PathParameters.Add("workstream_summary", Pieces.Os.Core.Client.ClientUtils.ParameterToString(workstreamSummary)); // path parameter

            localVarRequestOptions.Operation = "AnchorApi.AnchorAssociateWorkstreamSummary";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Object>("/anchor/{anchor}/workstream_summaries/associate/{workstream_summary}", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("AnchorAssociateWorkstreamSummary", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /anchor/{anchor}/assets/disassociate/{asset} [POST] Disassociates an anchor from an asset. It performs the same action as the asset equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        public void AnchorDisassociateAsset(string anchor, Guid asset, int operationIndex = 0)
        {
            AnchorDisassociateAssetWithHttpInfo(anchor, asset);
        }

        /// <summary>
        /// /anchor/{anchor}/assets/disassociate/{asset} [POST] Disassociates an anchor from an asset. It performs the same action as the asset equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public Pieces.Os.Core.Client.ApiResponse<Object> AnchorDisassociateAssetWithHttpInfo(string anchor, Guid asset, int operationIndex = 0)
        {
            // verify the required parameter 'anchor' is set
            if (anchor == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'anchor' when calling AnchorApi->AnchorDisassociateAsset");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("anchor", Pieces.Os.Core.Client.ClientUtils.ParameterToString(anchor)); // path parameter
            localVarRequestOptions.PathParameters.Add("asset", Pieces.Os.Core.Client.ClientUtils.ParameterToString(asset)); // path parameter

            localVarRequestOptions.Operation = "AnchorApi.AnchorDisassociateAsset";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Object>("/anchor/{anchor}/assets/disassociate/{asset}", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("AnchorDisassociateAsset", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /anchor/{anchor}/assets/disassociate/{asset} [POST] Disassociates an anchor from an asset. It performs the same action as the asset equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task AnchorDisassociateAssetAsync(string anchor, Guid asset, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            await AnchorDisassociateAssetWithHttpInfoAsync(anchor, asset, operationIndex, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// /anchor/{anchor}/assets/disassociate/{asset} [POST] Disassociates an anchor from an asset. It performs the same action as the asset equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="asset">The id (uuid) of the asset that you are trying to access.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Object>> AnchorDisassociateAssetWithHttpInfoAsync(string anchor, Guid asset, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'anchor' is set
            if (anchor == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'anchor' when calling AnchorApi->AnchorDisassociateAsset");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("anchor", Pieces.Os.Core.Client.ClientUtils.ParameterToString(anchor)); // path parameter
            localVarRequestOptions.PathParameters.Add("asset", Pieces.Os.Core.Client.ClientUtils.ParameterToString(asset)); // path parameter

            localVarRequestOptions.Operation = "AnchorApi.AnchorDisassociateAsset";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Object>("/anchor/{anchor}/assets/disassociate/{asset}", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("AnchorDisassociateAsset", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /anchor/{anchor}/conversations/disassociate/{conversation} [POST] Disassociates an anchor from a conversation. It performs the same action as the conversation equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        public void AnchorDisassociateConversation(string anchor, string conversation, int operationIndex = 0)
        {
            AnchorDisassociateConversationWithHttpInfo(anchor, conversation);
        }

        /// <summary>
        /// /anchor/{anchor}/conversations/disassociate/{conversation} [POST] Disassociates an anchor from a conversation. It performs the same action as the conversation equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public Pieces.Os.Core.Client.ApiResponse<Object> AnchorDisassociateConversationWithHttpInfo(string anchor, string conversation, int operationIndex = 0)
        {
            // verify the required parameter 'anchor' is set
            if (anchor == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'anchor' when calling AnchorApi->AnchorDisassociateConversation");
            }

            // verify the required parameter 'conversation' is set
            if (conversation == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'conversation' when calling AnchorApi->AnchorDisassociateConversation");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("anchor", Pieces.Os.Core.Client.ClientUtils.ParameterToString(anchor)); // path parameter
            localVarRequestOptions.PathParameters.Add("conversation", Pieces.Os.Core.Client.ClientUtils.ParameterToString(conversation)); // path parameter

            localVarRequestOptions.Operation = "AnchorApi.AnchorDisassociateConversation";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Object>("/anchor/{anchor}/conversations/disassociate/{conversation}", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("AnchorDisassociateConversation", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /anchor/{anchor}/conversations/disassociate/{conversation} [POST] Disassociates an anchor from a conversation. It performs the same action as the conversation equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task AnchorDisassociateConversationAsync(string anchor, string conversation, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            await AnchorDisassociateConversationWithHttpInfoAsync(anchor, conversation, operationIndex, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// /anchor/{anchor}/conversations/disassociate/{conversation} [POST] Disassociates an anchor from a conversation. It performs the same action as the conversation equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="conversation">This is the uuid of a conversation.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Object>> AnchorDisassociateConversationWithHttpInfoAsync(string anchor, string conversation, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'anchor' is set
            if (anchor == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'anchor' when calling AnchorApi->AnchorDisassociateConversation");
            }

            // verify the required parameter 'conversation' is set
            if (conversation == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'conversation' when calling AnchorApi->AnchorDisassociateConversation");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("anchor", Pieces.Os.Core.Client.ClientUtils.ParameterToString(anchor)); // path parameter
            localVarRequestOptions.PathParameters.Add("conversation", Pieces.Os.Core.Client.ClientUtils.ParameterToString(conversation)); // path parameter

            localVarRequestOptions.Operation = "AnchorApi.AnchorDisassociateConversation";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Object>("/anchor/{anchor}/conversations/disassociate/{conversation}", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("AnchorDisassociateConversation", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /anchor/{anchor}/messages/disassociate/{message} [POST] This will enable us to disassociate a anchor from a message.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        public void AnchorDisassociateMessage(string anchor, string message, int operationIndex = 0)
        {
            AnchorDisassociateMessageWithHttpInfo(anchor, message);
        }

        /// <summary>
        /// /anchor/{anchor}/messages/disassociate/{message} [POST] This will enable us to disassociate a anchor from a message.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public Pieces.Os.Core.Client.ApiResponse<Object> AnchorDisassociateMessageWithHttpInfo(string anchor, string message, int operationIndex = 0)
        {
            // verify the required parameter 'anchor' is set
            if (anchor == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'anchor' when calling AnchorApi->AnchorDisassociateMessage");
            }

            // verify the required parameter 'message' is set
            if (message == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'message' when calling AnchorApi->AnchorDisassociateMessage");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("anchor", Pieces.Os.Core.Client.ClientUtils.ParameterToString(anchor)); // path parameter
            localVarRequestOptions.PathParameters.Add("message", Pieces.Os.Core.Client.ClientUtils.ParameterToString(message)); // path parameter

            localVarRequestOptions.Operation = "AnchorApi.AnchorDisassociateMessage";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Object>("/anchor/{anchor}/messages/disassociate/{message}", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("AnchorDisassociateMessage", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /anchor/{anchor}/messages/disassociate/{message} [POST] This will enable us to disassociate a anchor from a message.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task AnchorDisassociateMessageAsync(string anchor, string message, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            await AnchorDisassociateMessageWithHttpInfoAsync(anchor, message, operationIndex, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// /anchor/{anchor}/messages/disassociate/{message} [POST] This will enable us to disassociate a anchor from a message.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="message">This is the uuid of a message.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Object>> AnchorDisassociateMessageWithHttpInfoAsync(string anchor, string message, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'anchor' is set
            if (anchor == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'anchor' when calling AnchorApi->AnchorDisassociateMessage");
            }

            // verify the required parameter 'message' is set
            if (message == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'message' when calling AnchorApi->AnchorDisassociateMessage");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("anchor", Pieces.Os.Core.Client.ClientUtils.ParameterToString(anchor)); // path parameter
            localVarRequestOptions.PathParameters.Add("message", Pieces.Os.Core.Client.ClientUtils.ParameterToString(message)); // path parameter

            localVarRequestOptions.Operation = "AnchorApi.AnchorDisassociateMessage";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Object>("/anchor/{anchor}/messages/disassociate/{message}", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("AnchorDisassociateMessage", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /anchor/{anchor}/persons/disassociate/{person} [POST] Disassociates an anchor from a person. It performs the same action as the person equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="person">This is a uuid that represents a person.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        public void AnchorDisassociatePerson(string anchor, string person, int operationIndex = 0)
        {
            AnchorDisassociatePersonWithHttpInfo(anchor, person);
        }

        /// <summary>
        /// /anchor/{anchor}/persons/disassociate/{person} [POST] Disassociates an anchor from a person. It performs the same action as the person equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="person">This is a uuid that represents a person.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public Pieces.Os.Core.Client.ApiResponse<Object> AnchorDisassociatePersonWithHttpInfo(string anchor, string person, int operationIndex = 0)
        {
            // verify the required parameter 'anchor' is set
            if (anchor == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'anchor' when calling AnchorApi->AnchorDisassociatePerson");
            }

            // verify the required parameter 'person' is set
            if (person == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'person' when calling AnchorApi->AnchorDisassociatePerson");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("anchor", Pieces.Os.Core.Client.ClientUtils.ParameterToString(anchor)); // path parameter
            localVarRequestOptions.PathParameters.Add("person", Pieces.Os.Core.Client.ClientUtils.ParameterToString(person)); // path parameter

            localVarRequestOptions.Operation = "AnchorApi.AnchorDisassociatePerson";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Object>("/anchor/{anchor}/persons/disassociate/{person}", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("AnchorDisassociatePerson", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /anchor/{anchor}/persons/disassociate/{person} [POST] Disassociates an anchor from a person. It performs the same action as the person equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="person">This is a uuid that represents a person.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task AnchorDisassociatePersonAsync(string anchor, string person, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            await AnchorDisassociatePersonWithHttpInfoAsync(anchor, person, operationIndex, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// /anchor/{anchor}/persons/disassociate/{person} [POST] Disassociates an anchor from a person. It performs the same action as the person equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="person">This is a uuid that represents a person.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Object>> AnchorDisassociatePersonWithHttpInfoAsync(string anchor, string person, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'anchor' is set
            if (anchor == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'anchor' when calling AnchorApi->AnchorDisassociatePerson");
            }

            // verify the required parameter 'person' is set
            if (person == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'person' when calling AnchorApi->AnchorDisassociatePerson");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("anchor", Pieces.Os.Core.Client.ClientUtils.ParameterToString(anchor)); // path parameter
            localVarRequestOptions.PathParameters.Add("person", Pieces.Os.Core.Client.ClientUtils.ParameterToString(person)); // path parameter

            localVarRequestOptions.Operation = "AnchorApi.AnchorDisassociatePerson";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Object>("/anchor/{anchor}/persons/disassociate/{person}", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("AnchorDisassociatePerson", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /anchor/{anchor}/workstream_summaries/disassociate/{workstream_summary} [POST] This will enable us to disassociate a anchor from a workstream summary. This will do the same thing as the workstreamSummary equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="workstreamSummary">This is a identifier that is used to identify a specific workstream_summary.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        public void AnchorDisassociateWorkstreamSummary(string anchor, string workstreamSummary, int operationIndex = 0)
        {
            AnchorDisassociateWorkstreamSummaryWithHttpInfo(anchor, workstreamSummary);
        }

        /// <summary>
        /// /anchor/{anchor}/workstream_summaries/disassociate/{workstream_summary} [POST] This will enable us to disassociate a anchor from a workstream summary. This will do the same thing as the workstreamSummary equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="workstreamSummary">This is a identifier that is used to identify a specific workstream_summary.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public Pieces.Os.Core.Client.ApiResponse<Object> AnchorDisassociateWorkstreamSummaryWithHttpInfo(string anchor, string workstreamSummary, int operationIndex = 0)
        {
            // verify the required parameter 'anchor' is set
            if (anchor == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'anchor' when calling AnchorApi->AnchorDisassociateWorkstreamSummary");
            }

            // verify the required parameter 'workstreamSummary' is set
            if (workstreamSummary == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'workstreamSummary' when calling AnchorApi->AnchorDisassociateWorkstreamSummary");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("anchor", Pieces.Os.Core.Client.ClientUtils.ParameterToString(anchor)); // path parameter
            localVarRequestOptions.PathParameters.Add("workstream_summary", Pieces.Os.Core.Client.ClientUtils.ParameterToString(workstreamSummary)); // path parameter

            localVarRequestOptions.Operation = "AnchorApi.AnchorDisassociateWorkstreamSummary";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Object>("/anchor/{anchor}/workstream_summaries/disassociate/{workstream_summary}", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("AnchorDisassociateWorkstreamSummary", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /anchor/{anchor}/workstream_summaries/disassociate/{workstream_summary} [POST] This will enable us to disassociate a anchor from a workstream summary. This will do the same thing as the workstreamSummary equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="workstreamSummary">This is a identifier that is used to identify a specific workstream_summary.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task AnchorDisassociateWorkstreamSummaryAsync(string anchor, string workstreamSummary, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            await AnchorDisassociateWorkstreamSummaryWithHttpInfoAsync(anchor, workstreamSummary, operationIndex, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// /anchor/{anchor}/workstream_summaries/disassociate/{workstream_summary} [POST] This will enable us to disassociate a anchor from a workstream summary. This will do the same thing as the workstreamSummary equivalent.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="workstreamSummary">This is a identifier that is used to identify a specific workstream_summary.</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Object>> AnchorDisassociateWorkstreamSummaryWithHttpInfoAsync(string anchor, string workstreamSummary, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'anchor' is set
            if (anchor == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'anchor' when calling AnchorApi->AnchorDisassociateWorkstreamSummary");
            }

            // verify the required parameter 'workstreamSummary' is set
            if (workstreamSummary == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'workstreamSummary' when calling AnchorApi->AnchorDisassociateWorkstreamSummary");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("anchor", Pieces.Os.Core.Client.ClientUtils.ParameterToString(anchor)); // path parameter
            localVarRequestOptions.PathParameters.Add("workstream_summary", Pieces.Os.Core.Client.ClientUtils.ParameterToString(workstreamSummary)); // path parameter

            localVarRequestOptions.Operation = "AnchorApi.AnchorDisassociateWorkstreamSummary";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Object>("/anchor/{anchor}/workstream_summaries/disassociate/{workstream_summary}", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("AnchorDisassociateWorkstreamSummary", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /anchor/{anchor}/rename [POST] This will rename a specific anchor.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>Anchor</returns>
        public Anchor AnchorRename(string anchor, bool? transferables = default(bool?), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.ApiResponse<Anchor> localVarResponse = AnchorRenameWithHttpInfo(anchor, transferables);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /anchor/{anchor}/rename [POST] This will rename a specific anchor.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Anchor</returns>
        public Pieces.Os.Core.Client.ApiResponse<Anchor> AnchorRenameWithHttpInfo(string anchor, bool? transferables = default(bool?), int operationIndex = 0)
        {
            // verify the required parameter 'anchor' is set
            if (anchor == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'anchor' when calling AnchorApi->AnchorRename");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("anchor", Pieces.Os.Core.Client.ClientUtils.ParameterToString(anchor)); // path parameter
            if (transferables != null)
            {
                localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "transferables", transferables));
            }

            localVarRequestOptions.Operation = "AnchorApi.AnchorRename";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Anchor>("/anchor/{anchor}/rename", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("AnchorRename", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /anchor/{anchor}/rename [POST] This will rename a specific anchor.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of Anchor</returns>
        public async System.Threading.Tasks.Task<Anchor> AnchorRenameAsync(string anchor, bool? transferables = default(bool?), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            Pieces.Os.Core.Client.ApiResponse<Anchor> localVarResponse = await AnchorRenameWithHttpInfoAsync(anchor, transferables, operationIndex, cancellationToken).ConfigureAwait(false);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /anchor/{anchor}/rename [POST] This will rename a specific anchor.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (Anchor)</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Anchor>> AnchorRenameWithHttpInfoAsync(string anchor, bool? transferables = default(bool?), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'anchor' is set
            if (anchor == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'anchor' when calling AnchorApi->AnchorRename");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("anchor", Pieces.Os.Core.Client.ClientUtils.ParameterToString(anchor)); // path parameter
            if (transferables != null)
            {
                localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "transferables", transferables));
            }

            localVarRequestOptions.Operation = "AnchorApi.AnchorRename";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Anchor>("/anchor/{anchor}/rename", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("AnchorRename", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// &#39;/anchor/{anchor}/scores/increment&#39; [POST] This will take in a SeededScoreIncrement and will increment the material relative to the incoming body.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="seededScoreIncrement"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns></returns>
        public void AnchorScoresIncrement(string anchor, SeededScoreIncrement seededScoreIncrement = default(SeededScoreIncrement), int operationIndex = 0)
        {
            AnchorScoresIncrementWithHttpInfo(anchor, seededScoreIncrement);
        }

        /// <summary>
        /// &#39;/anchor/{anchor}/scores/increment&#39; [POST] This will take in a SeededScoreIncrement and will increment the material relative to the incoming body.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="seededScoreIncrement"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Object(void)</returns>
        public Pieces.Os.Core.Client.ApiResponse<Object> AnchorScoresIncrementWithHttpInfo(string anchor, SeededScoreIncrement seededScoreIncrement = default(SeededScoreIncrement), int operationIndex = 0)
        {
            // verify the required parameter 'anchor' is set
            if (anchor == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'anchor' when calling AnchorApi->AnchorScoresIncrement");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("anchor", Pieces.Os.Core.Client.ClientUtils.ParameterToString(anchor)); // path parameter
            localVarRequestOptions.Data = seededScoreIncrement;

            localVarRequestOptions.Operation = "AnchorApi.AnchorScoresIncrement";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Object>("/anchor/{anchor}/scores/increment", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("AnchorScoresIncrement", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// &#39;/anchor/{anchor}/scores/increment&#39; [POST] This will take in a SeededScoreIncrement and will increment the material relative to the incoming body.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="seededScoreIncrement"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of void</returns>
        public async System.Threading.Tasks.Task AnchorScoresIncrementAsync(string anchor, SeededScoreIncrement seededScoreIncrement = default(SeededScoreIncrement), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            await AnchorScoresIncrementWithHttpInfoAsync(anchor, seededScoreIncrement, operationIndex, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// &#39;/anchor/{anchor}/scores/increment&#39; [POST] This will take in a SeededScoreIncrement and will increment the material relative to the incoming body.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="seededScoreIncrement"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Object>> AnchorScoresIncrementWithHttpInfoAsync(string anchor, SeededScoreIncrement seededScoreIncrement = default(SeededScoreIncrement), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'anchor' is set
            if (anchor == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'anchor' when calling AnchorApi->AnchorScoresIncrement");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("anchor", Pieces.Os.Core.Client.ClientUtils.ParameterToString(anchor)); // path parameter
            localVarRequestOptions.Data = seededScoreIncrement;

            localVarRequestOptions.Operation = "AnchorApi.AnchorScoresIncrement";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Object>("/anchor/{anchor}/scores/increment", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("AnchorScoresIncrement", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /anchor/{anchor} [GET] This will get a snapshot of a single anchor.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>Anchor</returns>
        public Anchor AnchorSpecificAnchorSnapshot(string anchor, bool? transferables = default(bool?), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.ApiResponse<Anchor> localVarResponse = AnchorSpecificAnchorSnapshotWithHttpInfo(anchor, transferables);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /anchor/{anchor} [GET] This will get a snapshot of a single anchor.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Anchor</returns>
        public Pieces.Os.Core.Client.ApiResponse<Anchor> AnchorSpecificAnchorSnapshotWithHttpInfo(string anchor, bool? transferables = default(bool?), int operationIndex = 0)
        {
            // verify the required parameter 'anchor' is set
            if (anchor == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'anchor' when calling AnchorApi->AnchorSpecificAnchorSnapshot");
            }

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("anchor", Pieces.Os.Core.Client.ClientUtils.ParameterToString(anchor)); // path parameter
            if (transferables != null)
            {
                localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "transferables", transferables));
            }

            localVarRequestOptions.Operation = "AnchorApi.AnchorSpecificAnchorSnapshot";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Get<Anchor>("/anchor/{anchor}", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("AnchorSpecificAnchorSnapshot", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /anchor/{anchor} [GET] This will get a snapshot of a single anchor.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of Anchor</returns>
        public async System.Threading.Tasks.Task<Anchor> AnchorSpecificAnchorSnapshotAsync(string anchor, bool? transferables = default(bool?), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            Pieces.Os.Core.Client.ApiResponse<Anchor> localVarResponse = await AnchorSpecificAnchorSnapshotWithHttpInfoAsync(anchor, transferables, operationIndex, cancellationToken).ConfigureAwait(false);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /anchor/{anchor} [GET] This will get a snapshot of a single anchor.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="anchor">This is the specific uuid of an anchor.</param>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (Anchor)</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Anchor>> AnchorSpecificAnchorSnapshotWithHttpInfoAsync(string anchor, bool? transferables = default(bool?), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            // verify the required parameter 'anchor' is set
            if (anchor == null)
            {
                throw new Pieces.Os.Core.Client.ApiException(400, "Missing required parameter 'anchor' when calling AnchorApi->AnchorSpecificAnchorSnapshot");
            }


            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.PathParameters.Add("anchor", Pieces.Os.Core.Client.ClientUtils.ParameterToString(anchor)); // path parameter
            if (transferables != null)
            {
                localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "transferables", transferables));
            }

            localVarRequestOptions.Operation = "AnchorApi.AnchorSpecificAnchorSnapshot";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.GetAsync<Anchor>("/anchor/{anchor}", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("AnchorSpecificAnchorSnapshot", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /anchor/update [POST] This will update a specific anchor.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="anchor"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>Anchor</returns>
        public Anchor AnchorUpdate(bool? transferables = default(bool?), Anchor anchor = default(Anchor), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.ApiResponse<Anchor> localVarResponse = AnchorUpdateWithHttpInfo(transferables, anchor);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /anchor/update [POST] This will update a specific anchor.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="anchor"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of Anchor</returns>
        public Pieces.Os.Core.Client.ApiResponse<Anchor> AnchorUpdateWithHttpInfo(bool? transferables = default(bool?), Anchor anchor = default(Anchor), int operationIndex = 0)
        {
            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            if (transferables != null)
            {
                localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "transferables", transferables));
            }
            localVarRequestOptions.Data = anchor;

            localVarRequestOptions.Operation = "AnchorApi.AnchorUpdate";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = this.Client.Post<Anchor>("/anchor/update", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("AnchorUpdate", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// /anchor/update [POST] This will update a specific anchor.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="anchor"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of Anchor</returns>
        public async System.Threading.Tasks.Task<Anchor> AnchorUpdateAsync(bool? transferables = default(bool?), Anchor anchor = default(Anchor), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {
            Pieces.Os.Core.Client.ApiResponse<Anchor> localVarResponse = await AnchorUpdateWithHttpInfoAsync(transferables, anchor, operationIndex, cancellationToken).ConfigureAwait(false);
            return localVarResponse.Data;
        }

        /// <summary>
        /// /anchor/update [POST] This will update a specific anchor.
        /// </summary>
        /// <exception cref="Pieces.Os.Core.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="transferables">This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional)</param>
        /// <param name="anchor"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (Anchor)</returns>
        public async System.Threading.Tasks.Task<Pieces.Os.Core.Client.ApiResponse<Anchor>> AnchorUpdateWithHttpInfoAsync(bool? transferables = default(bool?), Anchor anchor = default(Anchor), int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default(global::System.Threading.CancellationToken))
        {

            Pieces.Os.Core.Client.RequestOptions localVarRequestOptions = new Pieces.Os.Core.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/json"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "application/json",
                "text/plain"
            };

            var localVarContentType = Pieces.Os.Core.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Pieces.Os.Core.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            if (transferables != null)
            {
                localVarRequestOptions.QueryParameters.Add(Pieces.Os.Core.Client.ClientUtils.ParameterToMultiMap("", "transferables", transferables));
            }
            localVarRequestOptions.Data = anchor;

            localVarRequestOptions.Operation = "AnchorApi.AnchorUpdate";
            localVarRequestOptions.OperationIndex = operationIndex;

            // authentication (application) required
            if (!string.IsNullOrEmpty(this.Configuration.GetApiKeyWithPrefix("X-Application-ID")))
            {
                localVarRequestOptions.HeaderParameters.Add("X-Application-ID", this.Configuration.GetApiKeyWithPrefix("X-Application-ID"));
            }

            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<Anchor>("/anchor/update", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("AnchorUpdate", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

    }
}
