# Pieces.Os.Core - the C# library for the Pieces Isomorphic OpenAPI

Endpoints for Assets, Formats, Users, Asset, Format, User.

This C# SDK is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0
- SDK version: 1.0.0
- Generator version: 7.9.0
- Build package: org.openapitools.codegen.languages.CSharpClientCodegen
    For more information, please visit [https://pieces.app](https://pieces.app)

<a id="frameworks-supported"></a>
## Frameworks supported
- .NET Core >=1.0
- .NET Framework >=4.6
- Mono/Xamarin >=vNext

<a id="dependencies"></a>
## Dependencies

- [RestSharp](https://www.nuget.org/packages/RestSharp) - 112.0.0 or later
- [Json.NET](https://www.nuget.org/packages/Newtonsoft.Json/) - 13.0.2 or later
- [JsonSubTypes](https://www.nuget.org/packages/JsonSubTypes/) - 1.8.0 or later
- [System.ComponentModel.Annotations](https://www.nuget.org/packages/System.ComponentModel.Annotations) - 5.0.0 or later

The DLLs included in the package may not be the latest version. We recommend using [NuGet](https://docs.nuget.org/consume/installing-nuget) to obtain the latest version of the packages:
```
Install-Package RestSharp
Install-Package Newtonsoft.Json
Install-Package JsonSubTypes
Install-Package System.ComponentModel.Annotations
```

NOTE: RestSharp versions greater than 105.1.0 have a bug which causes file uploads to fail. See [RestSharp#742](https://github.com/restsharp/RestSharp/issues/742).
NOTE: RestSharp for .Net Core creates a new socket for each api call, which can lead to a socket exhaustion problem. See [RestSharp#1406](https://github.com/restsharp/RestSharp/issues/1406).

<a id="installation"></a>
## Installation
Generate the DLL using your preferred tool (e.g. `dotnet build`)

Then include the DLL (under the `bin` folder) in the C# project, and use the namespaces:
```csharp
using Pieces.Os.Core.Api;
using Pieces.Os.Core.Client;
using Pieces.Os.Core.SdkModel;
```
<a id="usage"></a>
## Usage

To use the API client with a HTTP proxy, setup a `System.Net.WebProxy`
```csharp
Configuration c = new Configuration();
System.Net.WebProxy webProxy = new System.Net.WebProxy("http://myProxyUrl:80/");
webProxy.Credentials = System.Net.CredentialCache.DefaultCredentials;
c.Proxy = webProxy;
```

<a id="getting-started"></a>
## Getting Started

```csharp
using System.Collections.Generic;
using System.Diagnostics;
using Pieces.Os.Core.Api;
using Pieces.Os.Core.Client;
using Pieces.Os.Core.SdkModel;

namespace Example
{
    public class Example
    {
        public static void Main()
        {

            Configuration config = new Configuration();
            config.BasePath = "http://localhost:1000";
            // Configure API key authorization: application
            config.ApiKey.Add("X-Application-ID", "YOUR_API_KEY");
            // Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
            // config.ApiKeyPrefix.Add("X-Application-ID", "Bearer");

            var apiInstance = new ActivitiesApi(config);
            var transferables = true;  // bool? | This is a boolean that will decided if we are want to return the transferable data (default) or not(performance enhancement) (optional) 
            var seededActivity = new SeededActivity(); // SeededActivity |  (optional) 

            try
            {
                // /activities/create [POST]
                Activity result = apiInstance.ActivitiesCreateNewActivity(transferables, seededActivity);
                Debug.WriteLine(result);
            }
            catch (ApiException e)
            {
                Debug.Print("Exception when calling ActivitiesApi.ActivitiesCreateNewActivity: " + e.Message );
                Debug.Print("Status Code: "+ e.ErrorCode);
                Debug.Print(e.StackTrace);
            }

        }
    }
}
```

<a id="documentation-for-api-endpoints"></a>
## Documentation for API Endpoints

All URIs are relative to *http://localhost:1000*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ActivitiesApi* | [**ActivitiesCreateNewActivity**](docs/ActivitiesApi.md#activitiescreatenewactivity) | **POST** /activities/create | /activities/create [POST]
*ActivitiesApi* | [**ActivitiesDeleteSpecificActivity**](docs/ActivitiesApi.md#activitiesdeletespecificactivity) | **POST** /activities/{activity}/delete | /activities/{activity}/delete [POST]
*ActivitiesApi* | [**ActivitiesSnapshot**](docs/ActivitiesApi.md#activitiessnapshot) | **GET** /activities | /activities [GET]
*ActivitiesApi* | [**ActivitiesStreamIdentifiers**](docs/ActivitiesApi.md#activitiesstreamidentifiers) | **GET** /activities/stream/identifiers | /activities/stream/identifiers [WS]
*ActivityApi* | [**ActivitiesSpecificActivitySnapshot**](docs/ActivityApi.md#activitiesspecificactivitysnapshot) | **GET** /activity/{activity} | /activity/{activity} [GET]
*ActivityApi* | [**ActivityIdentifiersSnapshot**](docs/ActivityApi.md#activityidentifierssnapshot) | **GET** /activity/identifiers | /activity/identifiers [GET]
*ActivityApi* | [**ActivityUpdate**](docs/ActivityApi.md#activityupdate) | **POST** /activity/update | /activity/update [POST]
*AllocationApi* | [**AllocationSnapshot**](docs/AllocationApi.md#allocationsnapshot) | **GET** /allocation/{allocation} | /allocation/{allocation} [GET]
*AllocationApi* | [**AllocationUpdate**](docs/AllocationApi.md#allocationupdate) | **POST** /allocation/update | /allocation/update [POST]
*AllocationsApi* | [**AllocationsConnectNewCloud**](docs/AllocationsApi.md#allocationsconnectnewcloud) | **POST** /allocations/connect | /allocations/connect [POST]
*AllocationsApi* | [**AllocationsCreateNewAllocation**](docs/AllocationsApi.md#allocationscreatenewallocation) | **POST** /allocations/create | /allocations/create [POST]
*AllocationsApi* | [**AllocationsDeleteAllocation**](docs/AllocationsApi.md#allocationsdeleteallocation) | **POST** /allocations/delete | /allocations/delete [POST]
*AllocationsApi* | [**AllocationsDisconnectCloud**](docs/AllocationsApi.md#allocationsdisconnectcloud) | **POST** /allocations/disconnect | /allocations/disconnect [POST]
*AllocationsApi* | [**AllocationsReconnectCloud**](docs/AllocationsApi.md#allocationsreconnectcloud) | **POST** /allocations/reconnect | /allocations/reconnect [POST]
*AllocationsApi* | [**AllocationsSnapshot**](docs/AllocationsApi.md#allocationssnapshot) | **GET** /allocations | /allocations [GET]
*AnalysesApi* | [**AnalysesSnapshot**](docs/AnalysesApi.md#analysessnapshot) | **GET** /analyses | Your GET endpoint
*AnchorApi* | [**AnchorAssociateAsset**](docs/AnchorApi.md#anchorassociateasset) | **POST** /anchor/{anchor}/assets/associate/{asset} | /anchor/{anchor}/assets/associate/{asset} [POST]
*AnchorApi* | [**AnchorAssociateConversation**](docs/AnchorApi.md#anchorassociateconversation) | **POST** /anchor/{anchor}/conversations/associate/{conversation} | /anchor/{anchor}/conversations/associate/{conversation} [POST]
*AnchorApi* | [**AnchorAssociateMessage**](docs/AnchorApi.md#anchorassociatemessage) | **POST** /anchor/{anchor}/messages/associate/{message} | /anchor/{anchor}/messages/associate/{message} [POST]
*AnchorApi* | [**AnchorAssociatePerson**](docs/AnchorApi.md#anchorassociateperson) | **POST** /anchor/{anchor}/persons/associate/{person} | /anchor/{anchor}/persons/associate/{person} [POST]
*AnchorApi* | [**AnchorAssociateWorkstreamSummary**](docs/AnchorApi.md#anchorassociateworkstreamsummary) | **POST** /anchor/{anchor}/workstream_summaries/associate/{workstream_summary} | /anchor/{anchor}/workstream_summaries/associate/{workstream_summary} [POST]
*AnchorApi* | [**AnchorDisassociateAsset**](docs/AnchorApi.md#anchordisassociateasset) | **POST** /anchor/{anchor}/assets/disassociate/{asset} | /anchor/{anchor}/assets/disassociate/{asset} [POST]
*AnchorApi* | [**AnchorDisassociateConversation**](docs/AnchorApi.md#anchordisassociateconversation) | **POST** /anchor/{anchor}/conversations/disassociate/{conversation} | /anchor/{anchor}/conversations/disassociate/{conversation} [POST]
*AnchorApi* | [**AnchorDisassociateMessage**](docs/AnchorApi.md#anchordisassociatemessage) | **POST** /anchor/{anchor}/messages/disassociate/{message} | /anchor/{anchor}/messages/disassociate/{message} [POST]
*AnchorApi* | [**AnchorDisassociatePerson**](docs/AnchorApi.md#anchordisassociateperson) | **POST** /anchor/{anchor}/persons/disassociate/{person} | /anchor/{anchor}/persons/disassociate/{person} [POST]
*AnchorApi* | [**AnchorDisassociateWorkstreamSummary**](docs/AnchorApi.md#anchordisassociateworkstreamsummary) | **POST** /anchor/{anchor}/workstream_summaries/disassociate/{workstream_summary} | /anchor/{anchor}/workstream_summaries/disassociate/{workstream_summary} [POST]
*AnchorApi* | [**AnchorRename**](docs/AnchorApi.md#anchorrename) | **POST** /anchor/{anchor}/rename | /anchor/{anchor}/rename [POST]
*AnchorApi* | [**AnchorScoresIncrement**](docs/AnchorApi.md#anchorscoresincrement) | **POST** /anchor/{anchor}/scores/increment | '/anchor/{anchor}/scores/increment' [POST]
*AnchorApi* | [**AnchorSpecificAnchorSnapshot**](docs/AnchorApi.md#anchorspecificanchorsnapshot) | **GET** /anchor/{anchor} | /anchor/{anchor} [GET]
*AnchorApi* | [**AnchorUpdate**](docs/AnchorApi.md#anchorupdate) | **POST** /anchor/update | /anchor/update [POST]
*AnchorPointApi* | [**AnchorPointScoresIncrement**](docs/AnchorPointApi.md#anchorpointscoresincrement) | **POST** /anchor_point/{anchor_point}/scores/increment | '/anchor_point/{anchor_point}/scores/increment' [POST]
*AnchorPointApi* | [**AnchorPointSpecificAnchorPointSnapshot**](docs/AnchorPointApi.md#anchorpointspecificanchorpointsnapshot) | **GET** /anchor_point/{anchor_point} | /anchor_point/{anchor_point} [GET]
*AnchorPointApi* | [**AnchorPointUpdate**](docs/AnchorPointApi.md#anchorpointupdate) | **POST** /anchor_point/update | /anchor_point/update [POST]
*AnchorPointsApi* | [**AnchorPointsCreateNewAnchorPoint**](docs/AnchorPointsApi.md#anchorpointscreatenewanchorpoint) | **POST** /anchor_points/create | /anchor_points/create [POST]
*AnchorPointsApi* | [**AnchorPointsDeleteSpecificAnchorPoint**](docs/AnchorPointsApi.md#anchorpointsdeletespecificanchorpoint) | **POST** /anchor_points/{anchor_point}/delete | /anchor_points/{anchor_point}/delete [POST]
*AnchorPointsApi* | [**AnchorPointsSnapshot**](docs/AnchorPointsApi.md#anchorpointssnapshot) | **GET** /anchor_points | /anchor_points [GET]
*AnchorPointsApi* | [**AnchorPointsStreamIdentifiers**](docs/AnchorPointsApi.md#anchorpointsstreamidentifiers) | **GET** /anchor_points/stream/identifiers | /anchor_points/stream/identifiers [WS]
*AnchorsApi* | [**AnchorsCreateNewAnchor**](docs/AnchorsApi.md#anchorscreatenewanchor) | **POST** /anchors/create | /anchors/create [POST]
*AnchorsApi* | [**AnchorsDeleteSpecificAnchor**](docs/AnchorsApi.md#anchorsdeletespecificanchor) | **POST** /anchors/{anchor}/delete | /anchors/{anchor}/delete [POST]
*AnchorsApi* | [**AnchorsSnapshot**](docs/AnchorsApi.md#anchorssnapshot) | **GET** /anchors | /anchors [GET]
*AnchorsApi* | [**AnchorsStreamIdentifiers**](docs/AnchorsApi.md#anchorsstreamidentifiers) | **GET** /anchors/stream/identifiers | /anchors/stream/identifiers [WS]
*AnchorsApi* | [**SearchAnchors**](docs/AnchorsApi.md#searchanchors) | **POST** /anchors/search | /anchors/search [POST]
*AnnotationApi* | [**AnnotationScoresIncrement**](docs/AnnotationApi.md#annotationscoresincrement) | **POST** /annotation/{annotation}/scores/increment | '/annotation/{annotation}/scores/increment' [POST]
*AnnotationApi* | [**AnnotationSpecificAnnotationSnapshot**](docs/AnnotationApi.md#annotationspecificannotationsnapshot) | **GET** /annotation/{annotation} | /annotation/{annotation} [GET]
*AnnotationApi* | [**AnnotationUpdate**](docs/AnnotationApi.md#annotationupdate) | **POST** /annotation/update | /annotation/update [POST]
*AnnotationsApi* | [**AnnotationsCreateNewAnnotation**](docs/AnnotationsApi.md#annotationscreatenewannotation) | **POST** /annotations/create | /annotations/create [POST]
*AnnotationsApi* | [**AnnotationsDeleteSpecificAnnotation**](docs/AnnotationsApi.md#annotationsdeletespecificannotation) | **POST** /annotations/{annotation}/delete | /annotations/{annotation}/delete [POST]
*AnnotationsApi* | [**AnnotationsSnapshot**](docs/AnnotationsApi.md#annotationssnapshot) | **GET** /annotations | /annotations [GET]
*AnnotationsApi* | [**AnnotationsStreamIdentifiers**](docs/AnnotationsApi.md#annotationsstreamidentifiers) | **GET** /annotations/stream/identifiers | /annotations/stream/identifiers [WS]
*AnnotationsApi* | [**SearchAnnotations**](docs/AnnotationsApi.md#searchannotations) | **POST** /annotations/search | /annotations/search [POST]
*ApplicationApi* | [**ApplicationUpdate**](docs/ApplicationApi.md#applicationupdate) | **POST** /application/update | /application/update [GET]
*ApplicationsApi* | [**ApplicationsExternalRelated**](docs/ApplicationsApi.md#applicationsexternalrelated) | **GET** /applications/external/related | /applications/external/related [GET]
*ApplicationsApi* | [**ApplicationsExternalSnapshot**](docs/ApplicationsApi.md#applicationsexternalsnapshot) | **GET** /applications/external | /applications/external [GET]
*ApplicationsApi* | [**ApplicationsRegister**](docs/ApplicationsApi.md#applicationsregister) | **POST** /applications/register | /applications/register [POST]
*ApplicationsApi* | [**ApplicationsSessionClose**](docs/ApplicationsApi.md#applicationssessionclose) | **POST** /applications/session/close | /applications/session/close [POST]
*ApplicationsApi* | [**ApplicationsSessionOpen**](docs/ApplicationsApi.md#applicationssessionopen) | **POST** /applications/session/open | /applications/session/open [POST]
*ApplicationsApi* | [**ApplicationsSnapshot**](docs/ApplicationsApi.md#applicationssnapshot) | **GET** /applications | /applications [GET]
*ApplicationsApi* | [**ApplicationsSpecificApplicationSnapshot**](docs/ApplicationsApi.md#applicationsspecificapplicationsnapshot) | **GET** /applications/{application} | /applications/{application} [GET]
*ApplicationsApi* | [**ApplicationsStreamIdentifiers**](docs/ApplicationsApi.md#applicationsstreamidentifiers) | **GET** /applications/stream/identifiers | /applications/stream/identifiers [WS]
*AssetApi* | [**AssetAssociateAnchor**](docs/AssetApi.md#assetassociateanchor) | **POST** /asset/{asset}/anchors/associate/{anchor} | /asset/{asset}/persons/associate/{anchor} [POST]
*AssetApi* | [**AssetAssociateConversation**](docs/AssetApi.md#assetassociateconversation) | **POST** /asset/{asset}/conversations/associate/{conversation} | /asset/{asset}/conversations/associate/{conversation} [POST]
*AssetApi* | [**AssetAssociateHint**](docs/AssetApi.md#assetassociatehint) | **POST** /asset/{asset}/hints/associate/{hint} | /asset/{asset}/hints/associate/{hint} [POST]
*AssetApi* | [**AssetAssociatePerson**](docs/AssetApi.md#assetassociateperson) | **POST** /asset/{asset}/persons/associate/{person} | /asset/{asset}/persons/associate/{person} [POST]
*AssetApi* | [**AssetAssociateTag**](docs/AssetApi.md#assetassociatetag) | **POST** /asset/{asset}/tags/associate/{tag} | /asset/{asset}/tags/associate/{tag} [POST]
*AssetApi* | [**AssetAssociateWebsite**](docs/AssetApi.md#assetassociatewebsite) | **POST** /asset/{asset}/websites/associate/{website} | /asset/{asset}/websites/associate/{website} [POST]
*AssetApi* | [**AssetAssociateWorkstreamSummary**](docs/AssetApi.md#assetassociateworkstreamsummary) | **POST** /asset/{asset}/workstream_summaries/associate/{workstream_summary} | /asset/{asset}/workstream_summaries/associate/{workstream_summary} [POST]
*AssetApi* | [**AssetDisassociateAnchor**](docs/AssetApi.md#assetdisassociateanchor) | **POST** /asset/{asset}/anchors/disassociate/{anchor} | /asset/{asset}/anchors/disassociate/{anchor} [POST]
*AssetApi* | [**AssetDisassociateConversation**](docs/AssetApi.md#assetdisassociateconversation) | **POST** /asset/{asset}/conversations/disassociate/{conversation} | /asset/{asset}/conversations/disassociate/{conversation} [POST]
*AssetApi* | [**AssetDisassociateHint**](docs/AssetApi.md#assetdisassociatehint) | **POST** /asset/{asset}/hints/disassociate/{hint} | /asset/{asset}/hints/disassociate/{hint} [POST]
*AssetApi* | [**AssetDisassociatePerson**](docs/AssetApi.md#assetdisassociateperson) | **POST** /asset/{asset}/persons/disassociate/{person} | /asset/{asset}/persons/disassociate/{person} [POST]
*AssetApi* | [**AssetDisassociateTag**](docs/AssetApi.md#assetdisassociatetag) | **POST** /asset/{asset}/tags/disassociate/{tag} | /asset/{asset}/tags/disassociate/{tag} [POST]
*AssetApi* | [**AssetDisassociateWebsite**](docs/AssetApi.md#assetdisassociatewebsite) | **POST** /asset/{asset}/websites/disassociate/{website} | /asset/{asset}/websites/disassociate/{website} [POST]
*AssetApi* | [**AssetDisassociateWorkstreamSummary**](docs/AssetApi.md#assetdisassociateworkstreamsummary) | **POST** /asset/{asset}/workstream_summaries/disassociate/{workstream_summary} | /asset/{asset}/workstream_summaries/disassociate/{workstream_summary} [POST]
*AssetApi* | [**AssetFormats**](docs/AssetApi.md#assetformats) | **GET** /asset/{asset}/formats | /asset/{asset}/formats [GET] Scoped To Asset
*AssetApi* | [**AssetReclassify**](docs/AssetApi.md#assetreclassify) | **POST** /asset/reclassify | /asset/reclassify [POST]
*AssetApi* | [**AssetScoresIncrement**](docs/AssetApi.md#assetscoresincrement) | **POST** /asset/{asset}/scores/increment | /asset/{asset}/scores/increment [POST]
*AssetApi* | [**AssetSnapshot**](docs/AssetApi.md#assetsnapshot) | **GET** /asset/{asset} | /asset/{asset} [GET] Scoped To Asset
*AssetApi* | [**AssetSnapshotPost**](docs/AssetApi.md#assetsnapshotpost) | **POST** /asset/{asset} | /asset/{asset} [POST] Scoped to an Asset
*AssetApi* | [**AssetSpecificAssetActivities**](docs/AssetApi.md#assetspecificassetactivities) | **GET** /asset/{asset}/activities | /asset/{asset}/activities [GET]
*AssetApi* | [**AssetSpecificAssetConversations**](docs/AssetApi.md#assetspecificassetconversations) | **GET** /asset/{asset}/conversations | /asset/{asset}/conversations [GET]
*AssetApi* | [**AssetSpecificAssetExport**](docs/AssetApi.md#assetspecificassetexport) | **GET** /asset/{asset}/export | /asset/{asset}/export [GET]
*AssetApi* | [**AssetUpdate**](docs/AssetApi.md#assetupdate) | **POST** /asset/update | /asset/update [POST] Scoped to Asset
*AssetsApi* | [**AssetsCreateNewAsset**](docs/AssetsApi.md#assetscreatenewasset) | **POST** /assets/create | /assets/create [POST] Scoped to Asset
*AssetsApi* | [**AssetsDeleteAsset**](docs/AssetsApi.md#assetsdeleteasset) | **POST** /assets/{asset}/delete | /assets/{asset}/delete [POST] Scoped to Asset
*AssetsApi* | [**AssetsDraft**](docs/AssetsApi.md#assetsdraft) | **POST** /assets/draft | /assets/draft [POST]
*AssetsApi* | [**AssetsGetRecommendedAssets**](docs/AssetsApi.md#assetsgetrecommendedassets) | **GET** /assets/recommended | Your GET endpoint
*AssetsApi* | [**AssetsGetRelatedAssets**](docs/AssetsApi.md#assetsgetrelatedassets) | **GET** /assets/related | /assets/related [GET]
*AssetsApi* | [**AssetsIdentifiersSnapshot**](docs/AssetsApi.md#assetsidentifierssnapshot) | **GET** /assets/identifiers | /assets/identifiers [GET]
*AssetsApi* | [**AssetsPseudoSnapshot**](docs/AssetsApi.md#assetspseudosnapshot) | **GET** /assets/pseudo | /assets/pseudo [GET]
*AssetsApi* | [**AssetsSearchWithFilters**](docs/AssetsApi.md#assetssearchwithfilters) | **POST** /assets/search | /assets/search [POST]
*AssetsApi* | [**AssetsSnapshot**](docs/AssetsApi.md#assetssnapshot) | **GET** /assets | /assets [GET] Scoped to Assets
*AssetsApi* | [**AssetsSpecificAssetFormatsSnapshot**](docs/AssetsApi.md#assetsspecificassetformatssnapshot) | **GET** /assets/{asset}/formats | /assets/{asset}/formats [GET] Scoped To Assets
*AssetsApi* | [**AssetsSpecificAssetSnapshot**](docs/AssetsApi.md#assetsspecificassetsnapshot) | **GET** /assets/{asset} | /assets/{asset} [GET] Scoped to Assets
*AssetsApi* | [**AssetsStreamIdentifiers**](docs/AssetsApi.md#assetsstreamidentifiers) | **GET** /assets/stream/identifiers | /assets/stream/identifiers [WS]
*AssetsApi* | [**GetAssetsStreamTransferables**](docs/AssetsApi.md#getassetsstreamtransferables) | **GET** /assets/stream/transferables | /assets/stream/transferables [WS]
*AssetsApi* | [**SearchAssets**](docs/AssetsApi.md#searchassets) | **GET** /assets/search | /assets/search?query=string [GET]
*AssetsApi* | [**StreamAssets**](docs/AssetsApi.md#streamassets) | **GET** /assets/stream | /assets/stream [WS]
*Auth0Api* | [**Auth0Logout**](docs/Auth0Api.md#auth0logout) | **GET** /v2/logout | https://auth.pieces.services/v2/logout [GET]
*Auth0Api* | [**AuthorizeAuth0**](docs/Auth0Api.md#authorizeauth0) | **GET** /authorize | https://auth.pieces.services/authorize [GET]
*Auth0Api* | [**ExchangeForAuth0Token**](docs/Auth0Api.md#exchangeforauth0token) | **POST** /oauth/token | https://auth.pieces.services/oauth/token [POST]
*Auth0Api* | [**GetAuth0UserInfo**](docs/Auth0Api.md#getauth0userinfo) | **GET** /userinfo | https://auth.pieces.services/userinfo [GET]
*BackupApi* | [**Backup**](docs/BackupApi.md#backup) | **POST** /backup | /backup [POST]
*BackupApi* | [**BackupAsset**](docs/BackupApi.md#backupasset) | **POST** /backup/asset | /backup/asset [POST]
*BackupApi* | [**BackupRestoreSpecificBackup**](docs/BackupApi.md#backuprestorespecificbackup) | **POST** /backup/{backup}/restore | /backup/{backup}/restore [POST]
*BackupApi* | [**BackupRestoreSpecificBackupStreamed**](docs/BackupApi.md#backuprestorespecificbackupstreamed) | **POST** /backup/{backup}/restore/streamed | /backup/{backup}/restore/streamed [POST]
*BackupApi* | [**BackupRestoreSpecificBackupStreamedWebsocket**](docs/BackupApi.md#backuprestorespecificbackupstreamedwebsocket) | **GET** /backup/{backup}/restore/streamed/websocket | /backup/{backup}/restore/streamed/websocket [WS]
*BackupApi* | [**BackupSpecificBackupSnapshot**](docs/BackupApi.md#backupspecificbackupsnapshot) | **GET** /backup/{backup} | /backup/{backup} [GET]
*BackupApi* | [**BackupSpecificCreationCancel**](docs/BackupApi.md#backupspecificcreationcancel) | **POST** /backup/{backup}/creation/cancel | /backup/{backup}/creation/cancel [POST]
*BackupApi* | [**BackupSpecificCreationStatus**](docs/BackupApi.md#backupspecificcreationstatus) | **GET** /backup/{backup}/creation/status | /backup/{backup}/creation/status [GET]
*BackupApi* | [**BackupSpecificRestorationCancel**](docs/BackupApi.md#backupspecificrestorationcancel) | **POST** /backup/{backup}/restoration/cancel | /backup/{backup}/restoration/cancel [POST]
*BackupApi* | [**BackupSpecificRestorationStatus**](docs/BackupApi.md#backupspecificrestorationstatus) | **GET** /backup/{backup}/restoration/status | /backup/{backup}/restoration/status [GET]
*BackupsApi* | [**BackupsCreateNewBackup**](docs/BackupsApi.md#backupscreatenewbackup) | **POST** /backups/create | /backups/create [POST]
*BackupsApi* | [**BackupsCreateNewBackupStreamed**](docs/BackupsApi.md#backupscreatenewbackupstreamed) | **POST** /backups/create/streamed | /backups/create/streamed [POST]
*BackupsApi* | [**BackupsCreateNewBackupStreamedWebsocket**](docs/BackupsApi.md#backupscreatenewbackupstreamedwebsocket) | **GET** /backups/create/streamed/websocket | /backups/create/streamed/websocket [WS]
*BackupsApi* | [**BackupsDeleteSpecificBackup**](docs/BackupsApi.md#backupsdeletespecificbackup) | **POST** /backups/{backup}/delete | /backups/{backup}/delete [POST]
*BackupsApi* | [**BackupsSnapshot**](docs/BackupsApi.md#backupssnapshot) | **GET** /backups | /backups [GET]
*BackupsApi* | [**BackupsStreamedProgress**](docs/BackupsApi.md#backupsstreamedprogress) | **GET** /backups/streamed/progress | /backups/streamed/progress [WS]
*ClassificationApi* | [**ConvertGenericClassification**](docs/ClassificationApi.md#convertgenericclassification) | **POST** /classification/generic/convert | Convert Generic Classification
*CodeAnalysesApi* | [**CodeAnalysesSnapshot**](docs/CodeAnalysesApi.md#codeanalysessnapshot) | **GET** /code_analyses | Your GET endpoint
*ConnectorApi* | [**Connect**](docs/ConnectorApi.md#connect) | **POST** /connect | /connect [POST]
*ConnectorApi* | [**Intention**](docs/ConnectorApi.md#intention) | **POST** /{application}/intention | /{application}/intention [POST]
*ConnectorApi* | [**Onboarded**](docs/ConnectorApi.md#onboarded) | **POST** /{application}/onboarded | /onboarded [POST]
*ConnectorApi* | [**React**](docs/ConnectorApi.md#react) | **POST** /{application}/reaction | /{application}/reaction [POST]
*ConnectorApi* | [**Suggest**](docs/ConnectorApi.md#suggest) | **POST** /{application}/suggestion | /{application}/suggestion [POST]
*ConnectorApi* | [**Track**](docs/ConnectorApi.md#track) | **POST** /{application}/track | /{application}/track [POST]
*ConversationApi* | [**ConversationAssociateAnchor**](docs/ConversationApi.md#conversationassociateanchor) | **POST** /conversation/{conversation}/anchors/associate/{anchor} | /conversation/{conversation}/anchors/associate/{anchor} [POST]
*ConversationApi* | [**ConversationAssociateAsset**](docs/ConversationApi.md#conversationassociateasset) | **POST** /conversation/{conversation}/assets/associate/{asset} | /conversation/{conversation}/assets/associate/{asset} [POST]
*ConversationApi* | [**ConversationAssociateGroundingTemporalRangeWorkstream**](docs/ConversationApi.md#conversationassociategroundingtemporalrangeworkstream) | **POST** /conversation/{conversation}/grounding/temporal_range/workstreams/associate/{range} | /conversation/{conversation}/grounding/temporal/ranges/associate/{range} [POST]
*ConversationApi* | [**ConversationAssociateWebsite**](docs/ConversationApi.md#conversationassociatewebsite) | **POST** /conversation/{conversation}/websites/associate/{website} | /conversation/{conversation}/websites/associate/{website} [POST]
*ConversationApi* | [**ConversationAssociateWorkstreamSummary**](docs/ConversationApi.md#conversationassociateworkstreamsummary) | **POST** /conversation/{conversation}/workstream_summaries/associate/{workstream_summary} | /conversation/{conversation}/workstream_summaries/associate/{workstream_summary} [POST]
*ConversationApi* | [**ConversationDisassociateAnchor**](docs/ConversationApi.md#conversationdisassociateanchor) | **POST** /conversation/{conversation}/anchors/disassociate/{anchor} | /conversation/{conversation}/anchors/disassociate/{anchor} [POST]
*ConversationApi* | [**ConversationDisassociateAsset**](docs/ConversationApi.md#conversationdisassociateasset) | **POST** /conversation/{conversation}/assets/disassociate/{asset} | /conversation/{conversation}/assets/disassociate/{asset} [POST]
*ConversationApi* | [**ConversationDisassociateGroundingTemporalRangeWorkstream**](docs/ConversationApi.md#conversationdisassociategroundingtemporalrangeworkstream) | **POST** /conversation/{conversation}/grounding/temporal_range/workstreams/disassociate/{range} | /conversation/{conversation}/grounding/temporal_range/workstreams/disassociate/{range} [POST]
*ConversationApi* | [**ConversationDisassociateWebsite**](docs/ConversationApi.md#conversationdisassociatewebsite) | **POST** /conversation/{conversation}/websites/disassociate/{website} | /website/{website}/websites/disassociate/{website} [POST]
*ConversationApi* | [**ConversationDisassociateWorkstreamSummary**](docs/ConversationApi.md#conversationdisassociateworkstreamsummary) | **POST** /conversation/{conversation}/workstream_summaries/disassociate/{workstream_summary} | /conversation/{conversation}/workstream_summaries/disassociate/{workstream_summary} [POST]
*ConversationApi* | [**ConversationGetSpecificConversation**](docs/ConversationApi.md#conversationgetspecificconversation) | **GET** /conversation/{conversation} | /conversation/{conversation} [GET]
*ConversationApi* | [**ConversationGroundingMessagesAssociateMessage**](docs/ConversationApi.md#conversationgroundingmessagesassociatemessage) | **POST** /conversation/{conversation}/grounding/messages/associate/{message} | /conversation/{conversation}/grounding/messages/associate/{message} [POST]
*ConversationApi* | [**ConversationGroundingMessagesDisassociateMessage**](docs/ConversationApi.md#conversationgroundingmessagesdisassociatemessage) | **POST** /conversation/{conversation}/grounding/messages/disassociate/{message} | /conversation/{conversation}/grounding/messages/disassociate/{message} [POST]
*ConversationApi* | [**ConversationScoresIncrement**](docs/ConversationApi.md#conversationscoresincrement) | **POST** /conversation/{conversation}/scores/increment | /conversation/{conversation}/scores/increment [POST]
*ConversationApi* | [**ConversationSpecificConversationMessages**](docs/ConversationApi.md#conversationspecificconversationmessages) | **GET** /conversation/{conversation}/messages | /conversation/{conversation}/messages [GET]
*ConversationApi* | [**ConversationSpecificConversationRename**](docs/ConversationApi.md#conversationspecificconversationrename) | **POST** /conversation/{conversation}/rename | /conversation/{conversation}/rename [POST]
*ConversationApi* | [**ConversationSummarize**](docs/ConversationApi.md#conversationsummarize) | **POST** /conversation/{conversation}/summarize | /conversation/{conversation}/summarize [POST]
*ConversationApi* | [**ConversationUpdate**](docs/ConversationApi.md#conversationupdate) | **POST** /conversation/update | /conversation/update [POST]
*ConversationApi* | [**SearchConversationSpecificMessages**](docs/ConversationApi.md#searchconversationspecificmessages) | **POST** /conversation/{conversation}/search | /conversation/{conversation}/search [POST]
*ConversationMessageApi* | [**MessageAssociateAnchor**](docs/ConversationMessageApi.md#messageassociateanchor) | **POST** /message/{message}/anchors/associate/{anchor} | /message/{message}/anchors/associate/{anchor} [POST]
*ConversationMessageApi* | [**MessageAssociateAnnotation**](docs/ConversationMessageApi.md#messageassociateannotation) | **POST** /message/{message}/annotations/associate/{annotation} | /message/{message}/annotations/associate/{annotation} [POST]
*ConversationMessageApi* | [**MessageAssociatePerson**](docs/ConversationMessageApi.md#messageassociateperson) | **POST** /message/{message}/persons/associate/{person} | /message/{message}/persons/associate/{person} [POST]
*ConversationMessageApi* | [**MessageAssociateWebsite**](docs/ConversationMessageApi.md#messageassociatewebsite) | **POST** /message/{message}/websites/associate/{website} | Associate a message with a website
*ConversationMessageApi* | [**MessageDisassociateAnchor**](docs/ConversationMessageApi.md#messagedisassociateanchor) | **POST** /message/{message}/anchors/disassociate/{anchor} | /message/{message}/anchors/disassociate/{anchor} [POST]
*ConversationMessageApi* | [**MessageDisassociateAnnotation**](docs/ConversationMessageApi.md#messagedisassociateannotation) | **POST** /message/{message}/annotations/disassociate/{annotation} | /message/{message}/annotations/disassociate/{annotation} [POST]
*ConversationMessageApi* | [**MessageDisassociatePerson**](docs/ConversationMessageApi.md#messagedisassociateperson) | **POST** /message/{message}/persons/disassociate/{person} | /message/{message}/persons/disassociate/{person} [POST]
*ConversationMessageApi* | [**MessageDisassociateWebsite**](docs/ConversationMessageApi.md#messagedisassociatewebsite) | **POST** /message/{message}/websites/disassociate/{website} | /message/{message}/websites/disassociate/{website} [POST]
*ConversationMessageApi* | [**MessageScoresIncrement**](docs/ConversationMessageApi.md#messagescoresincrement) | **POST** /message/{message}/scores/increment | '/message/{message}/scores/increment' [POST]
*ConversationMessageApi* | [**MessageSpecificMessageSnapshot**](docs/ConversationMessageApi.md#messagespecificmessagesnapshot) | **GET** /message/{message} | /message/{message} [GET]
*ConversationMessageApi* | [**MessageSpecificMessageUpdate**](docs/ConversationMessageApi.md#messagespecificmessageupdate) | **POST** /message/update | /message/update [GET]
*ConversationMessageApi* | [**MessageUpdateValue**](docs/ConversationMessageApi.md#messageupdatevalue) | **POST** /message/update/value | /message/update/value [POST]
*ConversationMessagesApi* | [**ConversationMessagesStreamIdentifiers**](docs/ConversationMessagesApi.md#conversationmessagesstreamidentifiers) | **GET** /messages/stream/identifiers | /messages/stream/identifiers [WS]
*ConversationMessagesApi* | [**MessagesCreateSpecificMessage**](docs/ConversationMessagesApi.md#messagescreatespecificmessage) | **POST** /messages/create | /messages/create [POST]
*ConversationMessagesApi* | [**MessagesDeleteSpecificMessage**](docs/ConversationMessagesApi.md#messagesdeletespecificmessage) | **POST** /messages/{message}/delete | /messages/{message}/delete [POST]
*ConversationMessagesApi* | [**MessagesSnapshot**](docs/ConversationMessagesApi.md#messagessnapshot) | **GET** /messages | /messages [GET]
*ConversationMessagesApi* | [**SearchMessages**](docs/ConversationMessagesApi.md#searchmessages) | **POST** /messages/search | /messages/search [POST]
*ConversationsApi* | [**ConversationsCreateFromAsset**](docs/ConversationsApi.md#conversationscreatefromasset) | **POST** /conversations/create/from_asset/{asset} | /conversations/create/from_asset/{asset} [POST]
*ConversationsApi* | [**ConversationsCreateSpecificConversation**](docs/ConversationsApi.md#conversationscreatespecificconversation) | **POST** /conversations/create | /conversations/create [POST]
*ConversationsApi* | [**ConversationsDeleteSpecificConversation**](docs/ConversationsApi.md#conversationsdeletespecificconversation) | **POST** /conversations/{conversation}/delete | /conversations/{conversation}/delete [POST]
*ConversationsApi* | [**ConversationsIdentifiersSnapshot**](docs/ConversationsApi.md#conversationsidentifierssnapshot) | **GET** /conversations/identifiers | /conversations/identifiers [GET]
*ConversationsApi* | [**ConversationsSnapshot**](docs/ConversationsApi.md#conversationssnapshot) | **GET** /conversations | /conversations [GET]
*ConversationsApi* | [**ConversationsStreamIdentifiers**](docs/ConversationsApi.md#conversationsstreamidentifiers) | **GET** /conversations/stream/identifiers | /conversations/stream/identifiers [WS]
*ConversationsApi* | [**SearchConversations**](docs/ConversationsApi.md#searchconversations) | **POST** /conversations/search | /conversations/search [POST]
*DatabaseApi* | [**DatabaseExport**](docs/DatabaseApi.md#databaseexport) | **GET** /database/export | Your GET endpoint
*DatabaseApi* | [**DatabaseImport**](docs/DatabaseApi.md#databaseimport) | **POST** /database/import | /database/import [POST]
*DiscoveryApi* | [**DiscoveryDiscoverAssets**](docs/DiscoveryApi.md#discoverydiscoverassets) | **POST** /discovery/discover/assets | /discovery/discover/assets [POST]
*DiscoveryApi* | [**DiscoveryDiscoverAssetsHtml**](docs/DiscoveryApi.md#discoverydiscoverassetshtml) | **POST** /discovery/discover/assets/html | /discovery/discover/assets/html[POST]
*DiscoveryApi* | [**DiscoveryDiscoverSensitives**](docs/DiscoveryApi.md#discoverydiscoversensitives) | **POST** /discovery/discover/sensitives | /discovery/discover/sensitives [POST]
*DiscoveryApi* | [**DiscoveryDiscoverTagsRelated**](docs/DiscoveryApi.md#discoverydiscovertagsrelated) | **POST** /discovery/discover/tags/related | /discovery/discover/tags/related [POST]
*DistributionApi* | [**DistributionUpdate**](docs/DistributionApi.md#distributionupdate) | **POST** /distribution/update | /distribution/update [POST]
*DistributionApi* | [**DistributionsSpecificDistributionSnapshot**](docs/DistributionApi.md#distributionsspecificdistributionsnapshot) | **GET** /distribution/{distribution} | /distribution/{distribution} [GET]
*DistributionsApi* | [**DistributionsCreateNewDistribution**](docs/DistributionsApi.md#distributionscreatenewdistribution) | **POST** /distributions/create | /distributions/create [POST]
*DistributionsApi* | [**DistributionsDeleteSpecificDistribution**](docs/DistributionsApi.md#distributionsdeletespecificdistribution) | **POST** /distributions/{distribution}/delete | /distributions/{distribution}/delete [POST]
*DistributionsApi* | [**DistributionsSnapshot**](docs/DistributionsApi.md#distributionssnapshot) | **GET** /distributions | /distributions [GET]
*ExternalProviderApi* | [**ExternalProviderApiKeyCreate**](docs/ExternalProviderApi.md#externalproviderapikeycreate) | **POST** /external_provider/api_key/create | /external_provider/api_key/create [POST]
*ExternalProviderApi* | [**ExternalProviderApiKeyDelete**](docs/ExternalProviderApi.md#externalproviderapikeydelete) | **POST** /external_provider/api_key/delete | /external_provider/api_key/delete [POST]
*ExternalProviderApi* | [**ExternalProviderApiKeyUpdate**](docs/ExternalProviderApi.md#externalproviderapikeyupdate) | **POST** /external_provider/api_key/update | /external_provider/api_key/update [POST]
*FormatApi* | [**FormatAnalysis**](docs/FormatApi.md#formatanalysis) | **GET** /format/{format}/analysis | /format/{format}/analysis [GET]
*FormatApi* | [**FormatReclassify**](docs/FormatApi.md#formatreclassify) | **POST** /format/reclassify | /format/reclassify [POST]
*FormatApi* | [**FormatSnapshot**](docs/FormatApi.md#formatsnapshot) | **GET** /format/{format} | /format/{format} [GET] Scoped to Format
*FormatApi* | [**FormatUpdateValue**](docs/FormatApi.md#formatupdatevalue) | **POST** /format/update/value | [POST] /format/update/value
*FormatsApi* | [**FormatsSnapshot**](docs/FormatsApi.md#formatssnapshot) | **GET** /formats | /formats [GET] Scoped to Formats
*FormatsApi* | [**FormatsSpecificFormatSnapshot**](docs/FormatsApi.md#formatsspecificformatsnapshot) | **GET** /formats/{format} | /formats/{format} [GET] Scoped to Formats
*FormatsApi* | [**FormatsStreamIdentifiers**](docs/FormatsApi.md#formatsstreamidentifiers) | **GET** /formats/stream/identifiers | /formats/stream/identifiers [WS]
*GithubApi* | [**ImportGithubGists**](docs/GithubApi.md#importgithubgists) | **POST** /github/gists/import | /github/gists/import [POST]
*HintApi* | [**HintAssociateAsset**](docs/HintApi.md#hintassociateasset) | **POST** /hint/{hint}/assets/associate/{asset} | /hint/{hint}/assets/associate/{asset} [POST]
*HintApi* | [**HintDisassociateAsset**](docs/HintApi.md#hintdisassociateasset) | **POST** /hint/{hint}/assets/disassociate/{asset} | /hint/{hint}/assets/disassociate/{asset} [POST]
*HintApi* | [**HintScoresIncrement**](docs/HintApi.md#hintscoresincrement) | **POST** /hint/{hint}/scores/increment | '/hint/{hint}/scores/increment' [POST]
*HintApi* | [**HintSpecificHintSnapshot**](docs/HintApi.md#hintspecifichintsnapshot) | **GET** /hint/{hint} | /hint/{hint} [POST]
*HintApi* | [**HintUpdate**](docs/HintApi.md#hintupdate) | **POST** /hint/update | /hint/update [POST]
*HintsApi* | [**HintsCreateNewHint**](docs/HintsApi.md#hintscreatenewhint) | **POST** /hints/create | /hints/create [POST]
*HintsApi* | [**HintsDeleteSpecificHint**](docs/HintsApi.md#hintsdeletespecifichint) | **POST** /hints/{hint}/delete | /hints/{hint}/delete [POST]
*HintsApi* | [**HintsSnapshot**](docs/HintsApi.md#hintssnapshot) | **GET** /hints | /hints [GET]
*HintsApi* | [**HintsStreamIdentifiers**](docs/HintsApi.md#hintsstreamidentifiers) | **GET** /hints/stream/identifiers | /hints/stream/identifiers [WS]
*HintsApi* | [**SearchHints**](docs/HintsApi.md#searchhints) | **POST** /hints/search | /hints/search [POST]
*ImageAnalysesApi* | [**ImageAnalysesSnapshot**](docs/ImageAnalysesApi.md#imageanalysessnapshot) | **GET** /image_analyses | Your GET endpoint
*LinkifyApi* | [**Linkify**](docs/LinkifyApi.md#linkify) | **POST** /linkify | /linkify [POST]
*LinkifyApi* | [**LinkifyMultiple**](docs/LinkifyApi.md#linkifymultiple) | **POST** /linkify/multiple | /linkify/multiple [POST]
*LinkifyApi* | [**LinkifyShareRevoke**](docs/LinkifyApi.md#linkifysharerevoke) | **POST** /linkify/{share}/revoke | [POST} /linkify/{share}/revoke
*MacOSApi* | [**AssetsCreateNewAssetFromMacos**](docs/MacOSApi.md#assetscreatenewassetfrommacos) | **POST** /macos/assets/create | /macos/assets/create [Post]
*MachineLearningApi* | [**PersonificationTechnicalLanguageGeneration**](docs/MachineLearningApi.md#personificationtechnicallanguagegeneration) | **POST** /machine_learning/text/technical_language/generators/personification | /machine_learning/text/technical_language/generators/personification [GET]
*MachineLearningApi* | [**SegmentTechnicalLanguage**](docs/MachineLearningApi.md#segmenttechnicallanguage) | **POST** /machine_learning/text/technical_language/parsers/segmentation | /machine_learning/text/technical_language/parsers/segmentation [POST]
*MetricsApi* | [**GetMetricsFormats**](docs/MetricsApi.md#getmetricsformats) | **GET** /metrics/formats | /metrics/formats [GET]
*MetricsApi* | [**MetricsFormatsOrdered**](docs/MetricsApi.md#metricsformatsordered) | **GET** /metrics/formats/ordered | /metrics/formats/ordered [GET]
*ModelApi* | [**ModelSpecificModelDownload**](docs/ModelApi.md#modelspecificmodeldownload) | **POST** /model/{model}/download | /model/{model}/download [POST]
*ModelApi* | [**ModelSpecificModelDownloadCancel**](docs/ModelApi.md#modelspecificmodeldownloadcancel) | **POST** /model/{model}/download/cancel | /model/{model}/download/cancel [POST]
*ModelApi* | [**ModelSpecificModelDownloadProgress**](docs/ModelApi.md#modelspecificmodeldownloadprogress) | **GET** /model/{model}/download/progress | /model/{model}/download/progress [WS]
*ModelApi* | [**ModelSpecificModelLoad**](docs/ModelApi.md#modelspecificmodelload) | **POST** /model/{model}/load | /model/{model}/load [POST]
*ModelApi* | [**ModelSpecificModelUnload**](docs/ModelApi.md#modelspecificmodelunload) | **POST** /model/{model}/unload | /model/{model}/unload [POST]
*ModelApi* | [**ModelUpdate**](docs/ModelApi.md#modelupdate) | **POST** /model/update | /model/update [POST]
*ModelApi* | [**ModelsSpecificModelSnapshot**](docs/ModelApi.md#modelsspecificmodelsnapshot) | **GET** /model/{model} | /model/{model} [GET]
*ModelsApi* | [**ModelsCreateNewModel**](docs/ModelsApi.md#modelscreatenewmodel) | **POST** /models/create | /models/create [POST]
*ModelsApi* | [**ModelsDeleteSpecificModel**](docs/ModelsApi.md#modelsdeletespecificmodel) | **POST** /models/{model}/delete | /models/{model}/delete [POST]
*ModelsApi* | [**ModelsDeleteSpecificModelCache**](docs/ModelsApi.md#modelsdeletespecificmodelcache) | **POST** /models/{model}/delete/cache | /models/{model}/delete/cache [POST]
*ModelsApi* | [**ModelsSnapshot**](docs/ModelsApi.md#modelssnapshot) | **GET** /models | /models [GET]
*ModelsApi* | [**ModelsStreamIdentifiers**](docs/ModelsApi.md#modelsstreamidentifiers) | **GET** /models/stream/identifiers | /models/stream/identifiers [WS]
*ModelsApi* | [**UnloadModels**](docs/ModelsApi.md#unloadmodels) | **POST** /models/unload | /models/unload [POST]
*NotificationsApi* | [**SendLocalNotification**](docs/NotificationsApi.md#sendlocalnotification) | **POST** /notifications/local/send | Send notification
*OCRAnalysesApi* | [**OcrAnalysesSnapshot**](docs/OCRAnalysesApi.md#ocranalysessnapshot) | **GET** /ocr_analyses | Your GET endpoint
*OSApi* | [**LinkProvider**](docs/OSApi.md#linkprovider) | **POST** /os/link_provider | /os/link_provider [POST]
*OSApi* | [**OsAppletLaunch**](docs/OSApi.md#osappletlaunch) | **POST** /os/applet/launch | /os/applet/launch [POST]
*OSApi* | [**OsAppletRestart**](docs/OSApi.md#osappletrestart) | **POST** /os/applet/restart | /os/applet/restart [POST]
*OSApi* | [**OsAppletTerminate**](docs/OSApi.md#osappletterminate) | **POST** /os/applet/terminate | /os/applet/terminate [POST]
*OSApi* | [**OsBrowserUrlOpen**](docs/OSApi.md#osbrowserurlopen) | **POST** /os/browser/url/open | /os/browser/url/open [POST]
*OSApi* | [**OsDeviceInformation**](docs/OSApi.md#osdeviceinformation) | **GET** /os/device/information | /os/device/information [GET]
*OSApi* | [**OsFilesystemFileOpen**](docs/OSApi.md#osfilesystemfileopen) | **POST** /os/filesystem/file/open | /os/filesystem/file/open [POST]
*OSApi* | [**OsFilesystemFileReadStreamed**](docs/OSApi.md#osfilesystemfilereadstreamed) | **GET** /os/filesystem/file/read/streamed | /os/filesystem/file/read/streamed [WS]
*OSApi* | [**OsFilesystemPathVerify**](docs/OSApi.md#osfilesystempathverify) | **POST** /os/filesystem/path/verify | /os/filesystem/path/verify [POST]
*OSApi* | [**OsFilesystemPickFiles**](docs/OSApi.md#osfilesystempickfiles) | **POST** /os/filesystem/files/pick | /os/filesystem/files/pick [POST]
*OSApi* | [**OsFilesystemPickFolders**](docs/OSApi.md#osfilesystempickfolders) | **POST** /os/filesystem/folders/pick | /os/filesystem/folders/pick [POST]
*OSApi* | [**OsMemoryOptimize**](docs/OSApi.md#osmemoryoptimize) | **POST** /os/memory/optimize | /os/memory/optimize [POST]
*OSApi* | [**OsMetadata**](docs/OSApi.md#osmetadata) | **GET** /os/metadata | /os/metadata [GET]
*OSApi* | [**OsPermissions**](docs/OSApi.md#ospermissions) | **GET** /os/permissions | /os/permissions [GET]
*OSApi* | [**OsPermissionsRequest**](docs/OSApi.md#ospermissionsrequest) | **POST** /os/permissions/request | /os/permissions/request [POST]
*OSApi* | [**OsRestart**](docs/OSApi.md#osrestart) | **GET** /os/restart | Your GET endpoint
*OSApi* | [**OsSettingsSnapshot**](docs/OSApi.md#ossettingssnapshot) | **GET** /os/settings | /os/settings [GET]
*OSApi* | [**OsSettingsStream**](docs/OSApi.md#ossettingsstream) | **GET** /os/settings/stream | /os/settings/stream [WS]
*OSApi* | [**OsSettingsUpdate**](docs/OSApi.md#ossettingsupdate) | **POST** /os/settings/update | /os/settings/update [POST]
*OSApi* | [**OsTerminate**](docs/OSApi.md#osterminate) | **POST** /os/terminate | /os/terminate [POST]
*OSApi* | [**OsUpdateCheck**](docs/OSApi.md#osupdatecheck) | **POST** /os/update/check | /os/update/check [POST]
*OSApi* | [**OsUpdateCheckStream**](docs/OSApi.md#osupdatecheckstream) | **GET** /os/update/check/stream | /os/update/check/stream [WS]
*OSApi* | [**SignIntoOS**](docs/OSApi.md#signintoos) | **POST** /os/sign_in | 
*OSApi* | [**SignOutOfOS**](docs/OSApi.md#signoutofos) | **POST** /os/sign_out | /os/sign_out [POST]
*OpenAIApi* | [**OpenAiModelsList**](docs/OpenAIApi.md#openaimodelslist) | **POST** /open_ai/models/list | /open_ai/models/list [POST]
*PKCEApi* | [**ClearPKCE**](docs/PKCEApi.md#clearpkce) | **POST** /pkce/clear | /pkce/clear [POST]
*PKCEApi* | [**GenerateCode**](docs/PKCEApi.md#generatecode) | **POST** /pkce/code | /pkce/code [POST]
*PKCEApi* | [**GenerateToken**](docs/PKCEApi.md#generatetoken) | **POST** /pkce/token | /pkce/token [POST]
*PKCEApi* | [**GetChallenge**](docs/PKCEApi.md#getchallenge) | **GET** /pkce/challenge | Your GET endpoint
*PKCEApi* | [**RespondWithCode**](docs/PKCEApi.md#respondwithcode) | **POST** /pkce/response/code | /pkce/response/code [POST]
*PersonApi* | [**PersonAssociateAnchor**](docs/PersonApi.md#personassociateanchor) | **POST** /person/{person}/anchors/associate/{anchor} | /person/{person}/anchors/associate/{anchor} [POST]
*PersonApi* | [**PersonAssociateAsset**](docs/PersonApi.md#personassociateasset) | **POST** /person/{person}/assets/associate/{asset} | /person/{person}/assets/associate/{asset} [POST]
*PersonApi* | [**PersonAssociateMessage**](docs/PersonApi.md#personassociatemessage) | **POST** /person/{person}/messages/associate/{message} | /person/{person}/messages/associate/{message} [POST]
*PersonApi* | [**PersonAssociateTag**](docs/PersonApi.md#personassociatetag) | **POST** /person/{person}/tags/associate/{tag} | /person/{person}/tags/associate/{tag} [POST]
*PersonApi* | [**PersonAssociateWebsite**](docs/PersonApi.md#personassociatewebsite) | **POST** /person/{person}/websites/associate/{website} | /person/{person}/websites/associate/{website} [POST]
*PersonApi* | [**PersonAssociateWorkstreamSummary**](docs/PersonApi.md#personassociateworkstreamsummary) | **POST** /person/{person}/workstream_summaries/associate/{workstream_summary} | /person/{person}/workstream_summaries/associate/{workstream_summary} [POST]
*PersonApi* | [**PersonDisassociateAnchor**](docs/PersonApi.md#persondisassociateanchor) | **POST** /person/{person}/anchors/disassociate/{anchor} | /person/{person}/anchors/disassociate/{anchor} [POST]
*PersonApi* | [**PersonDisassociateAsset**](docs/PersonApi.md#persondisassociateasset) | **POST** /person/{person}/assets/disassociate/{asset} | /person/{person}/assets/disassociate/{asset} [POST]
*PersonApi* | [**PersonDisassociateMessage**](docs/PersonApi.md#persondisassociatemessage) | **POST** /person/{person}/messages/disassociate/{message} | /person/{person}/messages/disassociate/{message} [POST]
*PersonApi* | [**PersonDisassociateTag**](docs/PersonApi.md#persondisassociatetag) | **POST** /person/{person}/tags/disassociate/{tag} | /person/{person}/tags/disassociate/{tag} [POST]
*PersonApi* | [**PersonDisassociateWebsite**](docs/PersonApi.md#persondisassociatewebsite) | **POST** /person/{person}/websites/disassociate/{website} | /person/{person}/websites/disassociate/{website} [POST]
*PersonApi* | [**PersonDisassociateWorkstreamSummary**](docs/PersonApi.md#persondisassociateworkstreamsummary) | **POST** /person/{person}/workstream_summaries/disassociate/{workstream_summary} | /person/{person}/workstream_summaries/disassociate/{workstream_summary} [POST]
*PersonApi* | [**PersonScoresIncrement**](docs/PersonApi.md#personscoresincrement) | **POST** /person/{person}/scores/increment | '/person/{person}/scores/increment' [POST]
*PersonApi* | [**PersonSnapshot**](docs/PersonApi.md#personsnapshot) | **GET** /person/{person} | /person/{person} [GET]
*PersonApi* | [**UpdatePerson**](docs/PersonApi.md#updateperson) | **POST** /person/update | /person/update [POST]
*PersonsApi* | [**PersonsCreateNewPerson**](docs/PersonsApi.md#personscreatenewperson) | **POST** /persons/create | /persons/create [POST]
*PersonsApi* | [**PersonsDeletePerson**](docs/PersonsApi.md#personsdeleteperson) | **POST** /persons/{person}/delete | /persons/{person}/delete [POST]
*PersonsApi* | [**PersonsSnapshot**](docs/PersonsApi.md#personssnapshot) | **GET** /persons | /persons [GET]
*PersonsApi* | [**PersonsStreamIdentifiers**](docs/PersonsApi.md#personsstreamidentifiers) | **GET** /persons/stream/identifiers | /persons/stream/identifiers [WS]
*PersonsApi* | [**SearchPersons**](docs/PersonsApi.md#searchpersons) | **POST** /persons/search | /persons/search [POST]
*PieceApi* | [**HtmlShare**](docs/PieceApi.md#htmlshare) | **GET** / | / [GET]
*QGPTApi* | [**Hints**](docs/QGPTApi.md#hints) | **POST** /qgpt/hints | /qgpt/hints [POST]
*QGPTApi* | [**PersonsRelated**](docs/QGPTApi.md#personsrelated) | **POST** /qgpt/persons/related | /qgpt/persons/related [POST]
*QGPTApi* | [**QgptStream**](docs/QGPTApi.md#qgptstream) | **GET** /qgpt/stream | /qgpt/stream [WS]
*QGPTApi* | [**Question**](docs/QGPTApi.md#question) | **POST** /qgpt/question | /qgpt/question [POST]
*QGPTApi* | [**Relevance**](docs/QGPTApi.md#relevance) | **POST** /qgpt/relevance | /qgpt/relevance [POST]
*QGPTApi* | [**Reprompt**](docs/QGPTApi.md#reprompt) | **POST** /qgpt/reprompt | /qgpt/reprompt [POST]
*RangeApi* | [**RangeAssociateConversationGroundingTemporalRangeWorkstreams**](docs/RangeApi.md#rangeassociateconversationgroundingtemporalrangeworkstreams) | **POST** /range/{range}/conversations/grounding/temporal_range/workstreams/associate/{conversation} | /range/{range}/conversations/grounding/temporal_range/workstreams/associate/{conversation} [POST]
*RangeApi* | [**RangeAssociateWorkstreamSummary**](docs/RangeApi.md#rangeassociateworkstreamsummary) | **POST** /range/{range}/workstream_summaries/associate/{workstream_summary} | /range/{range}/workstream_summaries/associate/{workstream_summary} [POST]
*RangeApi* | [**RangeDisassociateConversationGroundingTemporalRangeWorkstreams**](docs/RangeApi.md#rangedisassociateconversationgroundingtemporalrangeworkstreams) | **POST** /range/{range}/conversations/grounding/temporal_range/workstreams/disassociate/{conversation} | /range/{range}/conversations/grounding/temporal_range/workstreams/disassociate/{conversation} [POST]
*RangeApi* | [**RangeDisassociateWorkstreamSummary**](docs/RangeApi.md#rangedisassociateworkstreamsummary) | **POST** /range/{range}/workstream_summaries/disassociate/{workstream_summary} | /range/{range}/workstream_summaries/disassociate/{workstream_summary} [POST]
*RangeApi* | [**RangeScoresIncrement**](docs/RangeApi.md#rangescoresincrement) | **POST** /range/{range}/scores/increment | '/range/{range}/scores/increment' [POST]
*RangeApi* | [**RangeUpdate**](docs/RangeApi.md#rangeupdate) | **POST** /range/update | /range/update [POST]
*RangeApi* | [**RangesSpecificRangeSnapshot**](docs/RangeApi.md#rangesspecificrangesnapshot) | **GET** /range/{range} | /range/{range} [GET]
*RangesApi* | [**RangesCreateNewRange**](docs/RangesApi.md#rangescreatenewrange) | **POST** /ranges/create | /ranges/create [POST]
*RangesApi* | [**RangesDeleteSpecificRange**](docs/RangesApi.md#rangesdeletespecificrange) | **POST** /ranges/{range}/delete | /ranges/{range}/delete [POST]
*RangesApi* | [**RangesSnapshot**](docs/RangesApi.md#rangessnapshot) | **GET** /ranges | /ranges [GET]
*RangesApi* | [**RangesStreamIdentifiers**](docs/RangesApi.md#rangesstreamidentifiers) | **GET** /ranges/stream/identifiers | /ranges/stream/identifiers [WS]
*RelationshipApi* | [**RelationshipsSpecificRelationshipSnapshot**](docs/RelationshipApi.md#relationshipsspecificrelationshipsnapshot) | **GET** /relationship/{relationship} | /relationship/{relationship} [GET]
*RelationshipsApi* | [**RelationshipsSnapshot**](docs/RelationshipsApi.md#relationshipssnapshot) | **GET** /relationships | /relationships [GET]
*SearchApi* | [**FullTextSearch**](docs/SearchApi.md#fulltextsearch) | **GET** /search/full_text | /search/full_text [GET]
*SearchApi* | [**NeuralCodeSearch**](docs/SearchApi.md#neuralcodesearch) | **GET** /search/neural_code | /search/neural_code [GET]
*SearchApi* | [**TagBasedSearch**](docs/SearchApi.md#tagbasedsearch) | **POST** /search/tag_based | /search/tag_based [POST]
*SensitiveApi* | [**SensitiveScoresIncrement**](docs/SensitiveApi.md#sensitivescoresincrement) | **POST** /sensitive/{sensitive}/scores/increment | '/sensitive/{sensitive}/scores/increment' [POST]
*SensitiveApi* | [**SensitiveSnapshot**](docs/SensitiveApi.md#sensitivesnapshot) | **GET** /sensitive/{sensitive} | /sensitive/{sensitive} [GET]
*SensitiveApi* | [**UpdateSensitive**](docs/SensitiveApi.md#updatesensitive) | **POST** /sensitive/update | /sensitive/update [POST]
*SensitivesApi* | [**SearchSensitives**](docs/SensitivesApi.md#searchsensitives) | **POST** /sensitives/search | /sensitives/search [POST]
*SensitivesApi* | [**SensitivesCreateNewSensitive**](docs/SensitivesApi.md#sensitivescreatenewsensitive) | **POST** /sensitives/create | /sensitives/create [POST]
*SensitivesApi* | [**SensitivesDeleteSensitive**](docs/SensitivesApi.md#sensitivesdeletesensitive) | **POST** /sensitives/{sensitive}/delete | /sensitives/{sensitive}/delete [POST]
*SensitivesApi* | [**SensitivesSnapshot**](docs/SensitivesApi.md#sensitivessnapshot) | **GET** /sensitives | /sensitives [GET]
*SensitivesApi* | [**SensitivesStreamIdentifiers**](docs/SensitivesApi.md#sensitivesstreamidentifiers) | **GET** /sensitives/stream/identifiers | /sensitives/stream/identifiers [WS]
*ShareApi* | [**ShareScoresIncrement**](docs/ShareApi.md#sharescoresincrement) | **POST** /share/{share}/scores/increment | '/share/{share}/scores/increment' [POST]
*ShareApi* | [**ShareSnapshot**](docs/ShareApi.md#sharesnapshot) | **GET** /share/{share} | /share/{share}
*ShareApi* | [**ShareUpdate**](docs/ShareApi.md#shareupdate) | **POST** /share/update | /share/update [POST]
*SharesApi* | [**SharesCreateNewShare**](docs/SharesApi.md#sharescreatenewshare) | **POST** /shares/create | /shares/create [POST]
*SharesApi* | [**SharesDeleteShare**](docs/SharesApi.md#sharesdeleteshare) | **POST** /shares/{share}/delete | /shares/{share}/delete [POST]
*SharesApi* | [**SharesSnapshot**](docs/SharesApi.md#sharessnapshot) | **GET** /shares | /shares [GET]
*SharesApi* | [**SharesSpecificShareSnapshot**](docs/SharesApi.md#sharesspecificsharesnapshot) | **GET** /shares/{share} | /shares/{share} [GET]
*TagApi* | [**TagAssociateAsset**](docs/TagApi.md#tagassociateasset) | **POST** /tag/{tag}/assets/associate/{asset} | /tag/{tag}/assets/associate/{asset} [POST]
*TagApi* | [**TagAssociatePerson**](docs/TagApi.md#tagassociateperson) | **POST** /tag/{tag}/persons/associate/{person} | /tag/{tag}/persons/associate/{person} [POST]
*TagApi* | [**TagDisassociateAsset**](docs/TagApi.md#tagdisassociateasset) | **POST** /tag/{tag}/assets/disassociate/{asset} | /tag/{tag}/assets/disassociate/{asset} [POST]
*TagApi* | [**TagDisassociatePerson**](docs/TagApi.md#tagdisassociateperson) | **POST** /tag/{tag}/persons/disassociate/{person} | /tag/{tag}/persons/disassociate/{person} [POST]
*TagApi* | [**TagScoresIncrement**](docs/TagApi.md#tagscoresincrement) | **POST** /tag/{tag}/scores/increment | '/tag/{tag}/scores/increment' [POST]
*TagApi* | [**TagUpdate**](docs/TagApi.md#tagupdate) | **POST** /tag/update | /tag/update [POST]
*TagApi* | [**TagsSpecificTagSnapshot**](docs/TagApi.md#tagsspecifictagsnapshot) | **GET** /tag/{tag} | /tag/{tag} [GET]
*TagsApi* | [**SearchTags**](docs/TagsApi.md#searchtags) | **POST** /tags/search | /tags/search [POST]
*TagsApi* | [**TagsCreateNewTag**](docs/TagsApi.md#tagscreatenewtag) | **POST** /tags/create | /tags/create [POST]
*TagsApi* | [**TagsDeleteSpecificTag**](docs/TagsApi.md#tagsdeletespecifictag) | **POST** /tags/{tag}/delete | /tags/{tag}/delete [POST]
*TagsApi* | [**TagsExists**](docs/TagsApi.md#tagsexists) | **POST** /tags/exists | /tags/exists [POST]
*TagsApi* | [**TagsSnapshot**](docs/TagsApi.md#tagssnapshot) | **GET** /tags | /tags [GET]
*TagsApi* | [**TagsStreamIdentifiers**](docs/TagsApi.md#tagsstreamidentifiers) | **GET** /tags/stream/identifiers | /tags/stream/identifiers [WS]
*UltraSuiteApi* | [**AssetsCreateUltraSuiteAsset**](docs/UltraSuiteApi.md#assetscreateultrasuiteasset) | **POST** /ultra_suite/assets/create | /ultra_suite/assets/create [POST]
*UserApi* | [**ClearUser**](docs/UserApi.md#clearuser) | **POST** /user/clear | /user/clear
*UserApi* | [**RefreshUser**](docs/UserApi.md#refreshuser) | **GET** /user/refresh | /user/refresh [GET]
*UserApi* | [**SelectUser**](docs/UserApi.md#selectuser) | **POST** /user/select | /user/select [POST]
*UserApi* | [**StreamUser**](docs/UserApi.md#streamuser) | **GET** /user/stream | /user/stream [WS]
*UserApi* | [**UpdateUser**](docs/UserApi.md#updateuser) | **POST** /user/update | /user/update [POST]
*UserApi* | [**UserBetaStatus**](docs/UserApi.md#userbetastatus) | **POST** /user/beta/status | /user/beta/status [POST]
*UserApi* | [**UserProviders**](docs/UserApi.md#userproviders) | **GET** /user/providers | Your GET endpoint
*UserApi* | [**UserSnapshot**](docs/UserApi.md#usersnapshot) | **GET** /user | /user [GET]
*UserApi* | [**UserUpdateVanity**](docs/UserApi.md#userupdatevanity) | **POST** /user/update/vanity | /user/update/vanity [POST]
*UsersApi* | [**AuthenticateFromOauthToken**](docs/UsersApi.md#authenticatefromoauthtoken) | **POST** /users/authenticate/from_token | /users/authenticate/from_token [POST]
*UsersApi* | [**UsersDisconnectUser**](docs/UsersApi.md#usersdisconnectuser) | **POST** /users/{user}/disconnect | /users/{user}/disconnect [POST]
*UsersApi* | [**UsersSnapshot**](docs/UsersApi.md#userssnapshot) | **GET** /users | /users [GET]
*UsersApi* | [**UsersSpecificUserSnapshot**](docs/UsersApi.md#usersspecificusersnapshot) | **GET** /users/{user} | /users/{user} [GET] Scoped to Users
*WebsiteApi* | [**WebsiteAssociateAsset**](docs/WebsiteApi.md#websiteassociateasset) | **POST** /website/{website}/assets/associate/{asset} | /website/{website}/assets/associate/{asset} [POST]
*WebsiteApi* | [**WebsiteAssociateConversation**](docs/WebsiteApi.md#websiteassociateconversation) | **POST** /website/{website}/conversations/associate/{conversation} | /website/{website}/conversations/associate/{conversation} [POST]
*WebsiteApi* | [**WebsiteAssociateMessage**](docs/WebsiteApi.md#websiteassociatemessage) | **POST** /website/{website}/messages/associate/{message} | /website/{website}/messages/associate/{message} [POST]
*WebsiteApi* | [**WebsiteAssociatePerson**](docs/WebsiteApi.md#websiteassociateperson) | **POST** /website/{website}/persons/associate/{person} | /website/{website}/persons/associate/{person} [POST]
*WebsiteApi* | [**WebsiteAssociateWorkstreamSummary**](docs/WebsiteApi.md#websiteassociateworkstreamsummary) | **POST** /website/{website}/workstream_summaries/associate/{workstream_summary} | /website/{website}/workstream_summaries/associate/{workstream_summary} [POST]
*WebsiteApi* | [**WebsiteDisassociateAsset**](docs/WebsiteApi.md#websitedisassociateasset) | **POST** /website/{website}/assets/disassociate/{asset} | /website/{website}/assets/disassociate/{asset} [POST]
*WebsiteApi* | [**WebsiteDisassociateConversation**](docs/WebsiteApi.md#websitedisassociateconversation) | **POST** /website/{website}/conversations/disassociate/{conversation} | /website/{website}/conversations/disassociate/{conversation} [POST]
*WebsiteApi* | [**WebsiteDisassociateMessage**](docs/WebsiteApi.md#websitedisassociatemessage) | **POST** /website/{website}/messages/disassociate/{message} | /website/{website}/messages/disassociate/{message} [POST]
*WebsiteApi* | [**WebsiteDisassociatePerson**](docs/WebsiteApi.md#websitedisassociateperson) | **POST** /website/{website}/persons/disassociate/{person} | /website/{website}/persons/disassociate/{person} [POST]
*WebsiteApi* | [**WebsiteDisassociateWorkstreamSummary**](docs/WebsiteApi.md#websitedisassociateworkstreamsummary) | **POST** /website/{website}/workstream_summaries/disassociate/{workstream_summary} | /website/{website}/workstream_summaries/disassociate/{workstream_summary} [POST]
*WebsiteApi* | [**WebsiteScoresIncrement**](docs/WebsiteApi.md#websitescoresincrement) | **POST** /website/{website}/scores/increment | '/website/{website}/scores/increment' [POST]
*WebsiteApi* | [**WebsiteUpdate**](docs/WebsiteApi.md#websiteupdate) | **POST** /website/update | /website/update [POST]
*WebsiteApi* | [**WebsitesSpecificWebsiteSnapshot**](docs/WebsiteApi.md#websitesspecificwebsitesnapshot) | **GET** /website/{website} | /website/{website} [GET]
*WebsitesApi* | [**SearchWebsites**](docs/WebsitesApi.md#searchwebsites) | **POST** /websites/search | /websites/search [POST]
*WebsitesApi* | [**WebsitesCreateNewWebsite**](docs/WebsitesApi.md#websitescreatenewwebsite) | **POST** /websites/create | /websites/create [POST]
*WebsitesApi* | [**WebsitesDeleteSpecificWebsite**](docs/WebsitesApi.md#websitesdeletespecificwebsite) | **POST** /websites/{website}/delete | /websites/{website}/delete [POST]
*WebsitesApi* | [**WebsitesExists**](docs/WebsitesApi.md#websitesexists) | **POST** /websites/exists | /websites/exists [POST]
*WebsitesApi* | [**WebsitesSnapshot**](docs/WebsitesApi.md#websitessnapshot) | **GET** /websites | /websites [GET]
*WebsitesApi* | [**WebsitesStreamIdentifiers**](docs/WebsitesApi.md#websitesstreamidentifiers) | **GET** /websites/stream/identifiers | /websites/stream/identifiers [WS]
*WellKnownApi* | [**GetWellKnownHealth**](docs/WellKnownApi.md#getwellknownhealth) | **GET** /.well-known/health | /.well-known/health [GET]
*WellKnownApi* | [**GetWellKnownStreamHealth**](docs/WellKnownApi.md#getwellknownstreamhealth) | **GET** /.well-known/stream/health | /.well-known/stream/health [WS]
*WellKnownApi* | [**GetWellKnownVersion**](docs/WellKnownApi.md#getwellknownversion) | **GET** /.well-known/version | /.well-known/version [Get]
*WorkstreamApi* | [**WorkstreamSuggestionsRefresh**](docs/WorkstreamApi.md#workstreamsuggestionsrefresh) | **POST** /workstream/suggestions/refresh | /workstream/suggestions/refresh [POST]
*WorkstreamApi* | [**WorkstreamSuggestionsStream**](docs/WorkstreamApi.md#workstreamsuggestionsstream) | **GET** /workstream/suggestions/stream | /workstream/suggestions/stream [WS]
*WorkstreamEventApi* | [**WorkstreamEventAssociateWorkstreamSummary**](docs/WorkstreamEventApi.md#workstreameventassociateworkstreamsummary) | **POST** /workstream_event/{workstream_event}/workstream_summaries/associate/{workstream_summary} | /workstream_event/{workstream_event}/workstream_summaries/associate/{workstream_summary} [POST]
*WorkstreamEventApi* | [**WorkstreamEventDisassociateWorkstreamSummary**](docs/WorkstreamEventApi.md#workstreameventdisassociateworkstreamsummary) | **POST** /workstream_event/{workstream_event}/workstream_summaries/disassociate/{workstream_summary} | /workstream_event/{workstream_event}/workstream_summaries/disassociate/{workstream_summary} [POST]
*WorkstreamEventApi* | [**WorkstreamEventScoresIncrement**](docs/WorkstreamEventApi.md#workstreameventscoresincrement) | **POST** /workstream_event/{workstream_event}/scores/increment | '/workstream_event/{workstream_event}/scores/increment' [POST]
*WorkstreamEventApi* | [**WorkstreamEventUpdate**](docs/WorkstreamEventApi.md#workstreameventupdate) | **POST** /workstream_event/update | /workstream_event/update [POST]
*WorkstreamEventApi* | [**WorkstreamEventsSpecificWorkstreamEventSnapshot**](docs/WorkstreamEventApi.md#workstreameventsspecificworkstreameventsnapshot) | **GET** /workstream_event/{workstream_event} | /workstream_event/{workstream_event} [GET]
*WorkstreamEventsApi* | [**WorkstreamEventsCreateNewWorkstreamEvent**](docs/WorkstreamEventsApi.md#workstreameventscreatenewworkstreamevent) | **POST** /workstream_events/create | /workstream_events/create [POST]
*WorkstreamEventsApi* | [**WorkstreamEventsDeleteSpecificWorkstreamEvent**](docs/WorkstreamEventsApi.md#workstreameventsdeletespecificworkstreamevent) | **POST** /workstream_events/{workstream_event}/delete | /workstream_events/{workstream_event}/delete [POST]
*WorkstreamEventsApi* | [**WorkstreamEventsSnapshot**](docs/WorkstreamEventsApi.md#workstreameventssnapshot) | **GET** /workstream_events | /workstream_events [GET]
*WorkstreamPatternEngineApi* | [**WorkstreamPatternEngineCreateIngestion**](docs/WorkstreamPatternEngineApi.md#workstreampatternenginecreateingestion) | **POST** /workstream_pattern_engine/ingestions/create | /workstream_pattern_engine/ingestions/create [POST]
*WorkstreamPatternEngineApi* | [**WorkstreamPatternEngineProcessorsSources**](docs/WorkstreamPatternEngineApi.md#workstreampatternengineprocessorssources) | **GET** /workstream_pattern_engine/processors/sources | /workstream_pattern_engine/processors/sources [GET]
*WorkstreamPatternEngineApi* | [**WorkstreamPatternEngineProcessorsVisionActivate**](docs/WorkstreamPatternEngineApi.md#workstreampatternengineprocessorsvisionactivate) | **POST** /workstream_pattern_engine/processors/vision/activate | /workstream_pattern_engine/processors/vision/activate [POST]
*WorkstreamPatternEngineApi* | [**WorkstreamPatternEngineProcessorsVisionCalibrationCapture**](docs/WorkstreamPatternEngineApi.md#workstreampatternengineprocessorsvisioncalibrationcapture) | **POST** /workstream_pattern_engine/processors/vision/calibration/capture | /workstream_pattern_engine/processors/vision/calibration/capture [POST]
*WorkstreamPatternEngineApi* | [**WorkstreamPatternEngineProcessorsVisionCalibrationsFocused**](docs/WorkstreamPatternEngineApi.md#workstreampatternengineprocessorsvisioncalibrationsfocused) | **GET** /workstream_pattern_engine/processors/vision/calibrations/focused | /workstream_pattern_engine/processors/vision/calibrations/focused [GET]
*WorkstreamPatternEngineApi* | [**WorkstreamPatternEngineProcessorsVisionCalibrationsSnapshot**](docs/WorkstreamPatternEngineApi.md#workstreampatternengineprocessorsvisioncalibrationssnapshot) | **GET** /workstream_pattern_engine/processors/vision/calibrations | /workstream_pattern_engine/processors/vision/calibrations [GET]
*WorkstreamPatternEngineApi* | [**WorkstreamPatternEngineProcessorsVisionDataClear**](docs/WorkstreamPatternEngineApi.md#workstreampatternengineprocessorsvisiondataclear) | **POST** /workstream_pattern_engine/processors/vision/data/clear | /workstream_pattern_engine/processors/vision/data/clear [POST]
*WorkstreamPatternEngineApi* | [**WorkstreamPatternEngineProcessorsVisionDeactivate**](docs/WorkstreamPatternEngineApi.md#workstreampatternengineprocessorsvisiondeactivate) | **POST** /workstream_pattern_engine/processors/vision/deactivate | /workstream_pattern_engine/processors/vision/deactivate [POST]
*WorkstreamPatternEngineApi* | [**WorkstreamPatternEngineProcessorsVisionEventDeleteSpecificVisionEvent**](docs/WorkstreamPatternEngineApi.md#workstreampatternengineprocessorsvisioneventdeletespecificvisionevent) | **POST** /workstream_pattern_engine/processors/vision/data/events/{vision_event}/delete | /workstream_pattern_engine/processors/vision/events/{vision_event}/delete [POST]
*WorkstreamPatternEngineApi* | [**WorkstreamPatternEngineProcessorsVisionEventsScopedDelete**](docs/WorkstreamPatternEngineApi.md#workstreampatternengineprocessorsvisioneventsscopeddelete) | **POST** /workstream_pattern_engine/processors/vision/data/events/scoped_delete | /workstream_pattern_engine/processors/vision/events/scoped_delete [POST]
*WorkstreamPatternEngineApi* | [**WorkstreamPatternEngineProcessorsVisionEventsSearch**](docs/WorkstreamPatternEngineApi.md#workstreampatternengineprocessorsvisioneventssearch) | **POST** /workstream_pattern_engine/processors/vision/data/events/search | /workstream_pattern_engine/processors/vision/data/events/search [POST]
*WorkstreamPatternEngineApi* | [**WorkstreamPatternEngineProcessorsVisionEventsSnapshot**](docs/WorkstreamPatternEngineApi.md#workstreampatternengineprocessorsvisioneventssnapshot) | **GET** /workstream_pattern_engine/processors/vision/data/events | /workstream_pattern_engine/processors/vision/data/events [GET]
*WorkstreamPatternEngineApi* | [**WorkstreamPatternEngineProcessorsVisionEventsSpecificSnapshot**](docs/WorkstreamPatternEngineApi.md#workstreampatternengineprocessorsvisioneventsspecificsnapshot) | **GET** /workstream_pattern_engine/processors/vision/data/events/{vision_event} | /workstream_pattern_engine/processors/vision/data/events/{vision_event} [GET]
*WorkstreamPatternEngineApi* | [**WorkstreamPatternEngineProcessorsVisionMetadata**](docs/WorkstreamPatternEngineApi.md#workstreampatternengineprocessorsvisionmetadata) | **GET** /workstream_pattern_engine/processors/vision/metadata | /workstream_pattern_engine/processors/vision/metadata [GET]
*WorkstreamPatternEngineApi* | [**WorkstreamPatternEngineProcessorsVisionStatus**](docs/WorkstreamPatternEngineApi.md#workstreampatternengineprocessorsvisionstatus) | **GET** /workstream_pattern_engine/processors/vision/status | /workstream_pattern_engine/processors/vision/status [GET]
*WorkstreamPatternEngineApi* | [**WorkstreamPatternEngineProcessorsVisionStatusStream**](docs/WorkstreamPatternEngineApi.md#workstreampatternengineprocessorsvisionstatusstream) | **GET** /workstream_pattern_engine/processors/vision/status/stream | /workstream_pattern_engine/processors/vision/status/steam [WS]
*WorkstreamSummariesApi* | [**SearchWorkstreamSummaries**](docs/WorkstreamSummariesApi.md#searchworkstreamsummaries) | **POST** /workstream_summaries/search | /workstream_summaries/search [POST]
*WorkstreamSummariesApi* | [**WorkstreamSummariesCreateNewWorkstreamSummary**](docs/WorkstreamSummariesApi.md#workstreamsummariescreatenewworkstreamsummary) | **POST** /workstream_summaries/create | /workstream_summaries/create [POST]
*WorkstreamSummariesApi* | [**WorkstreamSummariesDeleteSpecificWorkstreamSummary**](docs/WorkstreamSummariesApi.md#workstreamsummariesdeletespecificworkstreamsummary) | **POST** /workstream_summaries/{workstream_summary}/delete | /workstream_summaries/{workstream_summary}/delete [POST]
*WorkstreamSummariesApi* | [**WorkstreamSummariesSnapshot**](docs/WorkstreamSummariesApi.md#workstreamsummariessnapshot) | **GET** /workstream_summaries | /workstream_summaries [GET]
*WorkstreamSummaryApi* | [**WorkstreamSummariesSpecificWorkstreamSummarySnapshot**](docs/WorkstreamSummaryApi.md#workstreamsummariesspecificworkstreamsummarysnapshot) | **GET** /workstream_summary/{workstream_summary} | /workstream_summary/{workstream_summary} [GET]
*WorkstreamSummaryApi* | [**WorkstreamSummaryAssociateAnchor**](docs/WorkstreamSummaryApi.md#workstreamsummaryassociateanchor) | **POST** /workstream_summary/{workstream_summary}/anchors/associate/{anchor} | /workstream_summary/{workstream_summary}/anchors/associate/{anchor} [POST]
*WorkstreamSummaryApi* | [**WorkstreamSummaryAssociateAsset**](docs/WorkstreamSummaryApi.md#workstreamsummaryassociateasset) | **POST** /workstream_summary/{workstream_summary}/assets/associate/{asset} | /workstream_summary/{workstream_summary}/assets/associate/{asset} [POST]
*WorkstreamSummaryApi* | [**WorkstreamSummaryAssociateConversation**](docs/WorkstreamSummaryApi.md#workstreamsummaryassociateconversation) | **POST** /workstream_summary/{workstream_summary}/conversations/associate/{conversation} | /workstream_summary/{workstream_summary}/conversations/associate/{conversation} [POST]
*WorkstreamSummaryApi* | [**WorkstreamSummaryAssociatePerson**](docs/WorkstreamSummaryApi.md#workstreamsummaryassociateperson) | **POST** /workstream_summary/{workstream_summary}/persons/associate/{person} | /workstream_summary/{workstream_summary}/persons/associate/{person} [POST]
*WorkstreamSummaryApi* | [**WorkstreamSummaryAssociateRange**](docs/WorkstreamSummaryApi.md#workstreamsummaryassociaterange) | **POST** /workstream_summary/{workstream_summary}/ranges/associate/{range} | /workstream_summary/{workstream_summary}/ranges/associate/{range} [POST]
*WorkstreamSummaryApi* | [**WorkstreamSummaryAssociateWebsite**](docs/WorkstreamSummaryApi.md#workstreamsummaryassociatewebsite) | **POST** /workstream_summary/{workstream_summary}/websites/associate/{website} | /workstream_summary/{workstream_summary}/websites/associate/{website} [POST]
*WorkstreamSummaryApi* | [**WorkstreamSummaryAssociateWorkstreamEvent**](docs/WorkstreamSummaryApi.md#workstreamsummaryassociateworkstreamevent) | **POST** /workstream_summary/{workstream_summary}/workstream_events/associate/{workstream_event} | /workstream_summary/{workstream_summary}/workstream_events/associate/{workstream_event} [POST]
*WorkstreamSummaryApi* | [**WorkstreamSummaryDisassociateAnchor**](docs/WorkstreamSummaryApi.md#workstreamsummarydisassociateanchor) | **POST** /workstream_summary/{workstream_summary}/anchors/disassociate/{anchor} | /workstream_summary/{workstream_summary}/anchors/disassociate/{anchor} [POST]
*WorkstreamSummaryApi* | [**WorkstreamSummaryDisassociateAsset**](docs/WorkstreamSummaryApi.md#workstreamsummarydisassociateasset) | **POST** /workstream_summary/{workstream_summary}/assets/disassociate/{asset} | /workstream_summary/{workstream_summary}/assets/disassociate/{asset} [POST]
*WorkstreamSummaryApi* | [**WorkstreamSummaryDisassociateConversation**](docs/WorkstreamSummaryApi.md#workstreamsummarydisassociateconversation) | **POST** /workstream_summary/{workstream_summary}/conversations/disassociate/{conversation} | /workstream_summary/{workstream_summary}/conversations/disassociate/{conversation} [POST]
*WorkstreamSummaryApi* | [**WorkstreamSummaryDisassociatePerson**](docs/WorkstreamSummaryApi.md#workstreamsummarydisassociateperson) | **POST** /workstream_summary/{workstream_summary}/persons/disassociate/{person} | /workstream_summary/{workstream_summary}/persons/disassociate/{person} [POST]
*WorkstreamSummaryApi* | [**WorkstreamSummaryDisassociateRange**](docs/WorkstreamSummaryApi.md#workstreamsummarydisassociaterange) | **POST** /workstream_summary/{workstream_summary}/ranges/disassociate/{range} | /workstream_summary/{workstream_summary}/ranges/disassociate/{range} [POST]
*WorkstreamSummaryApi* | [**WorkstreamSummaryDisassociateWebsite**](docs/WorkstreamSummaryApi.md#workstreamsummarydisassociatewebsite) | **POST** /workstream_summary/{workstream_summary}/websites/disassociate/{website} | /workstream_summary/{workstream_summary}/websites/disassociate/{website} [POST]
*WorkstreamSummaryApi* | [**WorkstreamSummaryDisassociateWorkstreamEvent**](docs/WorkstreamSummaryApi.md#workstreamsummarydisassociateworkstreamevent) | **POST** /workstream_summary/{workstream_summary}/workstream_events/disassociate/{workstream_event} | /workstream_summary/{workstream_summary}/workstream_events/disassociate/{workstream_event} [POST]
*WorkstreamSummaryApi* | [**WorkstreamSummaryScoresIncrement**](docs/WorkstreamSummaryApi.md#workstreamsummaryscoresincrement) | **POST** /workstream_summary/{workstream_summary}/scores/increment | '/workstream_summary/{workstream_summary}/scores/increment' [POST]
*WorkstreamSummaryApi* | [**WorkstreamSummaryUpdate**](docs/WorkstreamSummaryApi.md#workstreamsummaryupdate) | **POST** /workstream_summary/update | /workstream_summary/update [POST]


<a id="documentation-for-models"></a>
## Documentation for Models

 - [SdkModel.AccessEnum](docs/AccessEnum.md)
 - [SdkModel.Accessor](docs/Accessor.md)
 - [SdkModel.Accessors](docs/Accessors.md)
 - [SdkModel.ActiveOSServerApplet](docs/ActiveOSServerApplet.md)
 - [SdkModel.Activities](docs/Activities.md)
 - [SdkModel.Activity](docs/Activity.md)
 - [SdkModel.Aesthetics](docs/Aesthetics.md)
 - [SdkModel.AllocationCloud](docs/AllocationCloud.md)
 - [SdkModel.AllocationCloudStatus](docs/AllocationCloudStatus.md)
 - [SdkModel.AllocationCloudUrl](docs/AllocationCloudUrl.md)
 - [SdkModel.AllocationCloudUrls](docs/AllocationCloudUrls.md)
 - [SdkModel.AllocationStatusEnum](docs/AllocationStatusEnum.md)
 - [SdkModel.Allocations](docs/Allocations.md)
 - [SdkModel.Analyses](docs/Analyses.md)
 - [SdkModel.Analysis](docs/Analysis.md)
 - [SdkModel.AnalyticsTrackedAdoptionEventIdentifierDescriptionPairs](docs/AnalyticsTrackedAdoptionEventIdentifierDescriptionPairs.md)
 - [SdkModel.Anchor](docs/Anchor.md)
 - [SdkModel.AnchorPoint](docs/AnchorPoint.md)
 - [SdkModel.AnchorPoints](docs/AnchorPoints.md)
 - [SdkModel.AnchorTypeEnum](docs/AnchorTypeEnum.md)
 - [SdkModel.Anchors](docs/Anchors.md)
 - [SdkModel.Annotation](docs/Annotation.md)
 - [SdkModel.AnnotationTypeEnum](docs/AnnotationTypeEnum.md)
 - [SdkModel.Annotations](docs/Annotations.md)
 - [SdkModel.AnonymousTemporalRange](docs/AnonymousTemporalRange.md)
 - [SdkModel.Application](docs/Application.md)
 - [SdkModel.ApplicationNameEnum](docs/ApplicationNameEnum.md)
 - [SdkModel.Applications](docs/Applications.md)
 - [SdkModel.Asset](docs/Asset.md)
 - [SdkModel.AssetFilter](docs/AssetFilter.md)
 - [SdkModel.AssetFilterPhrase](docs/AssetFilterPhrase.md)
 - [SdkModel.AssetFilterPhraseOptions](docs/AssetFilterPhraseOptions.md)
 - [SdkModel.AssetFilterTimestamp](docs/AssetFilterTimestamp.md)
 - [SdkModel.AssetFilters](docs/AssetFilters.md)
 - [SdkModel.AssetReclassification](docs/AssetReclassification.md)
 - [SdkModel.AssetSearchSpace](docs/AssetSearchSpace.md)
 - [SdkModel.Assets](docs/Assets.md)
 - [SdkModel.AssetsSearchWithFiltersInput](docs/AssetsSearchWithFiltersInput.md)
 - [SdkModel.AssetsSearchWithFiltersOutput](docs/AssetsSearchWithFiltersOutput.md)
 - [SdkModel.Auth0](docs/Auth0.md)
 - [SdkModel.Auth0Identity](docs/Auth0Identity.md)
 - [SdkModel.Auth0OpenAIUserMetadata](docs/Auth0OpenAIUserMetadata.md)
 - [SdkModel.Auth0Redirects](docs/Auth0Redirects.md)
 - [SdkModel.Auth0User](docs/Auth0User.md)
 - [SdkModel.Auth0UserAllocationMetadata](docs/Auth0UserAllocationMetadata.md)
 - [SdkModel.Auth0UserBetaStatus](docs/Auth0UserBetaStatus.md)
 - [SdkModel.Auth0UserMetadata](docs/Auth0UserMetadata.md)
 - [SdkModel.AvailableFormats](docs/AvailableFormats.md)
 - [SdkModel.Backup](docs/Backup.md)
 - [SdkModel.BackupStatus](docs/BackupStatus.md)
 - [SdkModel.BackupStatusEnum](docs/BackupStatusEnum.md)
 - [SdkModel.BackupStreamedProgress](docs/BackupStreamedProgress.md)
 - [SdkModel.Backups](docs/Backups.md)
 - [SdkModel.BackupsStreamedProgress](docs/BackupsStreamedProgress.md)
 - [SdkModel.BrowserSelection](docs/BrowserSelection.md)
 - [SdkModel.BrowserTab](docs/BrowserTab.md)
 - [SdkModel.BrowserTabValue](docs/BrowserTabValue.md)
 - [SdkModel.BrowserTabValues](docs/BrowserTabValues.md)
 - [SdkModel.BrowserTabs](docs/BrowserTabs.md)
 - [SdkModel.ByteDescriptor](docs/ByteDescriptor.md)
 - [SdkModel.CapabilitiesEnum](docs/CapabilitiesEnum.md)
 - [SdkModel.ChallengedPKCE](docs/ChallengedPKCE.md)
 - [SdkModel.Classification](docs/Classification.md)
 - [SdkModel.ClassificationGenericEnum](docs/ClassificationGenericEnum.md)
 - [SdkModel.ClassificationRenderingEnum](docs/ClassificationRenderingEnum.md)
 - [SdkModel.ClassificationSpecificEnum](docs/ClassificationSpecificEnum.md)
 - [SdkModel.Classifications](docs/Classifications.md)
 - [SdkModel.CodeAnalyses](docs/CodeAnalyses.md)
 - [SdkModel.CodeAnalysis](docs/CodeAnalysis.md)
 - [SdkModel.Context](docs/Context.md)
 - [SdkModel.Conversation](docs/Conversation.md)
 - [SdkModel.ConversationGrounding](docs/ConversationGrounding.md)
 - [SdkModel.ConversationMessage](docs/ConversationMessage.md)
 - [SdkModel.ConversationMessageSentimentEnum](docs/ConversationMessageSentimentEnum.md)
 - [SdkModel.ConversationMessages](docs/ConversationMessages.md)
 - [SdkModel.ConversationSummarizeInput](docs/ConversationSummarizeInput.md)
 - [SdkModel.ConversationSummarizeOutput](docs/ConversationSummarizeOutput.md)
 - [SdkModel.ConversationTypeEnum](docs/ConversationTypeEnum.md)
 - [SdkModel.Conversations](docs/Conversations.md)
 - [SdkModel.ConversationsCreateFromAssetOutput](docs/ConversationsCreateFromAssetOutput.md)
 - [SdkModel.CreatedExternalProviderApiKey](docs/CreatedExternalProviderApiKey.md)
 - [SdkModel.DeletedExternalProviderApiKey](docs/DeletedExternalProviderApiKey.md)
 - [SdkModel.DetectedExternalApplication](docs/DetectedExternalApplication.md)
 - [SdkModel.DetectedExternalApplications](docs/DetectedExternalApplications.md)
 - [SdkModel.DiscoveredAsset](docs/DiscoveredAsset.md)
 - [SdkModel.DiscoveredAssets](docs/DiscoveredAssets.md)
 - [SdkModel.DiscoveredHtmlWebpage](docs/DiscoveredHtmlWebpage.md)
 - [SdkModel.DiscoveredHtmlWebpages](docs/DiscoveredHtmlWebpages.md)
 - [SdkModel.DiscoveredRelatedTag](docs/DiscoveredRelatedTag.md)
 - [SdkModel.DiscoveredRelatedTags](docs/DiscoveredRelatedTags.md)
 - [SdkModel.DiscoveredSensitive](docs/DiscoveredSensitive.md)
 - [SdkModel.DiscoveredSensitives](docs/DiscoveredSensitives.md)
 - [SdkModel.Distribution](docs/Distribution.md)
 - [SdkModel.Distributions](docs/Distributions.md)
 - [SdkModel.DocumentContributor](docs/DocumentContributor.md)
 - [SdkModel.DocumentContributors](docs/DocumentContributors.md)
 - [SdkModel.Edges](docs/Edges.md)
 - [SdkModel.EmbeddedModelSchema](docs/EmbeddedModelSchema.md)
 - [SdkModel.EmbeddedModelSchemaSemanticVersionEnum](docs/EmbeddedModelSchemaSemanticVersionEnum.md)
 - [SdkModel.Embedding](docs/Embedding.md)
 - [SdkModel.Embeddings](docs/Embeddings.md)
 - [SdkModel.EmbeddingsSearchOptions](docs/EmbeddingsSearchOptions.md)
 - [SdkModel.EmbeddingsSearchOptionsEmbeddingTypeEnum](docs/EmbeddingsSearchOptionsEmbeddingTypeEnum.md)
 - [SdkModel.ExistentMetadata](docs/ExistentMetadata.md)
 - [SdkModel.ExistingMetadata](docs/ExistingMetadata.md)
 - [SdkModel.ExportedAsset](docs/ExportedAsset.md)
 - [SdkModel.ExportedDatabase](docs/ExportedDatabase.md)
 - [SdkModel.ExportedDatabaseFormat](docs/ExportedDatabaseFormat.md)
 - [SdkModel.ExportedDatabaseFormats](docs/ExportedDatabaseFormats.md)
 - [SdkModel.ExternalMLProviderEnum](docs/ExternalMLProviderEnum.md)
 - [SdkModel.ExternalProvider](docs/ExternalProvider.md)
 - [SdkModel.ExternalProviderProfileData](docs/ExternalProviderProfileData.md)
 - [SdkModel.ExternalProviderTypeEnum](docs/ExternalProviderTypeEnum.md)
 - [SdkModel.ExternalProviders](docs/ExternalProviders.md)
 - [SdkModel.ExternallySourcedEnum](docs/ExternallySourcedEnum.md)
 - [SdkModel.FileFormat](docs/FileFormat.md)
 - [SdkModel.FileMetadata](docs/FileMetadata.md)
 - [SdkModel.FilePickerInput](docs/FilePickerInput.md)
 - [SdkModel.FilterOperationTypeEnum](docs/FilterOperationTypeEnum.md)
 - [SdkModel.FlattenedActivities](docs/FlattenedActivities.md)
 - [SdkModel.FlattenedActivity](docs/FlattenedActivity.md)
 - [SdkModel.FlattenedAnalysis](docs/FlattenedAnalysis.md)
 - [SdkModel.FlattenedAnchor](docs/FlattenedAnchor.md)
 - [SdkModel.FlattenedAnchorPoint](docs/FlattenedAnchorPoint.md)
 - [SdkModel.FlattenedAnchorPoints](docs/FlattenedAnchorPoints.md)
 - [SdkModel.FlattenedAnchors](docs/FlattenedAnchors.md)
 - [SdkModel.FlattenedAnnotation](docs/FlattenedAnnotation.md)
 - [SdkModel.FlattenedAnnotations](docs/FlattenedAnnotations.md)
 - [SdkModel.FlattenedApplication](docs/FlattenedApplication.md)
 - [SdkModel.FlattenedAsset](docs/FlattenedAsset.md)
 - [SdkModel.FlattenedAssets](docs/FlattenedAssets.md)
 - [SdkModel.FlattenedConversation](docs/FlattenedConversation.md)
 - [SdkModel.FlattenedConversationMessage](docs/FlattenedConversationMessage.md)
 - [SdkModel.FlattenedConversationMessages](docs/FlattenedConversationMessages.md)
 - [SdkModel.FlattenedConversations](docs/FlattenedConversations.md)
 - [SdkModel.FlattenedDistribution](docs/FlattenedDistribution.md)
 - [SdkModel.FlattenedDistributions](docs/FlattenedDistributions.md)
 - [SdkModel.FlattenedFormat](docs/FlattenedFormat.md)
 - [SdkModel.FlattenedFormats](docs/FlattenedFormats.md)
 - [SdkModel.FlattenedHint](docs/FlattenedHint.md)
 - [SdkModel.FlattenedHints](docs/FlattenedHints.md)
 - [SdkModel.FlattenedImageAnalysis](docs/FlattenedImageAnalysis.md)
 - [SdkModel.FlattenedOCRAnalysis](docs/FlattenedOCRAnalysis.md)
 - [SdkModel.FlattenedPerson](docs/FlattenedPerson.md)
 - [SdkModel.FlattenedPersons](docs/FlattenedPersons.md)
 - [SdkModel.FlattenedPreview](docs/FlattenedPreview.md)
 - [SdkModel.FlattenedRange](docs/FlattenedRange.md)
 - [SdkModel.FlattenedRanges](docs/FlattenedRanges.md)
 - [SdkModel.FlattenedSensitive](docs/FlattenedSensitive.md)
 - [SdkModel.FlattenedSensitives](docs/FlattenedSensitives.md)
 - [SdkModel.FlattenedShare](docs/FlattenedShare.md)
 - [SdkModel.FlattenedShares](docs/FlattenedShares.md)
 - [SdkModel.FlattenedTag](docs/FlattenedTag.md)
 - [SdkModel.FlattenedTags](docs/FlattenedTags.md)
 - [SdkModel.FlattenedUserProfile](docs/FlattenedUserProfile.md)
 - [SdkModel.FlattenedWebsite](docs/FlattenedWebsite.md)
 - [SdkModel.FlattenedWebsites](docs/FlattenedWebsites.md)
 - [SdkModel.FlattenedWorkstreamEvent](docs/FlattenedWorkstreamEvent.md)
 - [SdkModel.FlattenedWorkstreamEvents](docs/FlattenedWorkstreamEvents.md)
 - [SdkModel.FlattenedWorkstreamPatternEngineVisionEvent](docs/FlattenedWorkstreamPatternEngineVisionEvent.md)
 - [SdkModel.FlattenedWorkstreamPatternEngineVisionEvents](docs/FlattenedWorkstreamPatternEngineVisionEvents.md)
 - [SdkModel.FlattenedWorkstreamSummaries](docs/FlattenedWorkstreamSummaries.md)
 - [SdkModel.FlattenedWorkstreamSummary](docs/FlattenedWorkstreamSummary.md)
 - [SdkModel.Font](docs/Font.md)
 - [SdkModel.Format](docs/Format.md)
 - [SdkModel.FormatMetric](docs/FormatMetric.md)
 - [SdkModel.FormatReclassification](docs/FormatReclassification.md)
 - [SdkModel.Formats](docs/Formats.md)
 - [SdkModel.FormatsMetrics](docs/FormatsMetrics.md)
 - [SdkModel.FragmentFormat](docs/FragmentFormat.md)
 - [SdkModel.FragmentMetadata](docs/FragmentMetadata.md)
 - [SdkModel.FullTextSearchOptions](docs/FullTextSearchOptions.md)
 - [SdkModel.GitHubDistribution](docs/GitHubDistribution.md)
 - [SdkModel.GitHubGistDistribution](docs/GitHubGistDistribution.md)
 - [SdkModel.GraphicalImageDescriptiveStatistics](docs/GraphicalImageDescriptiveStatistics.md)
 - [SdkModel.GraphicalImageProcessing](docs/GraphicalImageProcessing.md)
 - [SdkModel.GraphicalImageStatistics](docs/GraphicalImageStatistics.md)
 - [SdkModel.GraphicalMachineLearningProcessingEvent](docs/GraphicalMachineLearningProcessingEvent.md)
 - [SdkModel.GraphicalOCRDescriptiveStatistics](docs/GraphicalOCRDescriptiveStatistics.md)
 - [SdkModel.GraphicalOCRDescriptiveStatisticsConfidence](docs/GraphicalOCRDescriptiveStatisticsConfidence.md)
 - [SdkModel.GraphicalOCRProcessing](docs/GraphicalOCRProcessing.md)
 - [SdkModel.GraphicalOCRStatistics](docs/GraphicalOCRStatistics.md)
 - [SdkModel.GraphicalSVGStatistics](docs/GraphicalSVGStatistics.md)
 - [SdkModel.GroupedTimestamp](docs/GroupedTimestamp.md)
 - [SdkModel.Health](docs/Health.md)
 - [SdkModel.Hint](docs/Hint.md)
 - [SdkModel.HintTypeEnum](docs/HintTypeEnum.md)
 - [SdkModel.Hints](docs/Hints.md)
 - [SdkModel.IDESelection](docs/IDESelection.md)
 - [SdkModel.IDESelections](docs/IDESelections.md)
 - [SdkModel.IDETab](docs/IDETab.md)
 - [SdkModel.IDETabs](docs/IDETabs.md)
 - [SdkModel.ImageAnalyses](docs/ImageAnalyses.md)
 - [SdkModel.ImageAnalysis](docs/ImageAnalysis.md)
 - [SdkModel.InactiveOSServerApplet](docs/InactiveOSServerApplet.md)
 - [SdkModel.InteractedAsset](docs/InteractedAsset.md)
 - [SdkModel.InteractedAssetInteractions](docs/InteractedAssetInteractions.md)
 - [SdkModel.InteractedAssets](docs/InteractedAssets.md)
 - [SdkModel.LanguageServerProtocol](docs/LanguageServerProtocol.md)
 - [SdkModel.LanguageServerProtocolCode](docs/LanguageServerProtocolCode.md)
 - [SdkModel.LanguageServerProtocolCodeDescription](docs/LanguageServerProtocolCodeDescription.md)
 - [SdkModel.LanguageServerProtocolDiagnostic](docs/LanguageServerProtocolDiagnostic.md)
 - [SdkModel.LanguageServerProtocolDiagnostics](docs/LanguageServerProtocolDiagnostics.md)
 - [SdkModel.LanguageServerProtocolLocation](docs/LanguageServerProtocolLocation.md)
 - [SdkModel.LanguageServerProtocolLocationRange](docs/LanguageServerProtocolLocationRange.md)
 - [SdkModel.LanguageServerProtocolLocationRangePosition](docs/LanguageServerProtocolLocationRangePosition.md)
 - [SdkModel.LanguageServerProtocolSeverityEnum](docs/LanguageServerProtocolSeverityEnum.md)
 - [SdkModel.Linkify](docs/Linkify.md)
 - [SdkModel.LinkifyMultiple](docs/LinkifyMultiple.md)
 - [SdkModel.MailgunDistribution](docs/MailgunDistribution.md)
 - [SdkModel.MailgunMetadata](docs/MailgunMetadata.md)
 - [SdkModel.MechanismEnum](docs/MechanismEnum.md)
 - [SdkModel.Model](docs/Model.md)
 - [SdkModel.ModelCapabilities](docs/ModelCapabilities.md)
 - [SdkModel.ModelDeleteCacheInput](docs/ModelDeleteCacheInput.md)
 - [SdkModel.ModelDeleteCacheOutput](docs/ModelDeleteCacheOutput.md)
 - [SdkModel.ModelDownloadProgress](docs/ModelDownloadProgress.md)
 - [SdkModel.ModelDownloadProgressStatusEnum](docs/ModelDownloadProgressStatusEnum.md)
 - [SdkModel.ModelFoundationEnum](docs/ModelFoundationEnum.md)
 - [SdkModel.ModelMaxTokens](docs/ModelMaxTokens.md)
 - [SdkModel.ModelTypeEnum](docs/ModelTypeEnum.md)
 - [SdkModel.ModelUsageEnum](docs/ModelUsageEnum.md)
 - [SdkModel.Models](docs/Models.md)
 - [SdkModel.Node](docs/Node.md)
 - [SdkModel.NodeTypeEnum](docs/NodeTypeEnum.md)
 - [SdkModel.Notification](docs/Notification.md)
 - [SdkModel.OAuthAccount](docs/OAuthAccount.md)
 - [SdkModel.OAuthGroup](docs/OAuthGroup.md)
 - [SdkModel.OAuthToken](docs/OAuthToken.md)
 - [SdkModel.OCRAnalyses](docs/OCRAnalyses.md)
 - [SdkModel.OCRAnalysis](docs/OCRAnalysis.md)
 - [SdkModel.OSAppletEnum](docs/OSAppletEnum.md)
 - [SdkModel.OSDeviceCPUHardwareInformation](docs/OSDeviceCPUHardwareInformation.md)
 - [SdkModel.OSDeviceDependenciesInformation](docs/OSDeviceDependenciesInformation.md)
 - [SdkModel.OSDeviceGPUHardwareCapabilitiesInformation](docs/OSDeviceGPUHardwareCapabilitiesInformation.md)
 - [SdkModel.OSDeviceGPUHardwareInformation](docs/OSDeviceGPUHardwareInformation.md)
 - [SdkModel.OSDeviceHardwareInformation](docs/OSDeviceHardwareInformation.md)
 - [SdkModel.OSDeviceInformationReturnable](docs/OSDeviceInformationReturnable.md)
 - [SdkModel.OSFileStreamingRead](docs/OSFileStreamingRead.md)
 - [SdkModel.OSFileStreamingReadAttempt](docs/OSFileStreamingReadAttempt.md)
 - [SdkModel.OSFileStreamingReadProgress](docs/OSFileStreamingReadProgress.md)
 - [SdkModel.OSHealth](docs/OSHealth.md)
 - [SdkModel.OSPermissions](docs/OSPermissions.md)
 - [SdkModel.OSProcessingPermissions](docs/OSProcessingPermissions.md)
 - [SdkModel.OSServerMetadata](docs/OSServerMetadata.md)
 - [SdkModel.OSServerSettings](docs/OSServerSettings.md)
 - [SdkModel.OSServerUpdateStatus](docs/OSServerUpdateStatus.md)
 - [SdkModel.OnboardedPersonaDetails](docs/OnboardedPersonaDetails.md)
 - [SdkModel.OpenAIModelsListInput](docs/OpenAIModelsListInput.md)
 - [SdkModel.OpenAIModelsListOutput](docs/OpenAIModelsListOutput.md)
 - [SdkModel.OrderedMetrics](docs/OrderedMetrics.md)
 - [SdkModel.PKCE](docs/PKCE.md)
 - [SdkModel.Person](docs/Person.md)
 - [SdkModel.PersonAccess](docs/PersonAccess.md)
 - [SdkModel.PersonAccessScopedEnum](docs/PersonAccessScopedEnum.md)
 - [SdkModel.PersonBasicType](docs/PersonBasicType.md)
 - [SdkModel.PersonModel](docs/PersonModel.md)
 - [SdkModel.PersonType](docs/PersonType.md)
 - [SdkModel.Persons](docs/Persons.md)
 - [SdkModel.PlatformEnum](docs/PlatformEnum.md)
 - [SdkModel.PrecreatedExternalProviderApiKey](docs/PrecreatedExternalProviderApiKey.md)
 - [SdkModel.PredeletedExternalProviderApiKey](docs/PredeletedExternalProviderApiKey.md)
 - [SdkModel.PreonboardedPersonaDetails](docs/PreonboardedPersonaDetails.md)
 - [SdkModel.PreupdatedExternalProviderApiKey](docs/PreupdatedExternalProviderApiKey.md)
 - [SdkModel.Preview](docs/Preview.md)
 - [SdkModel.PrivacyEnum](docs/PrivacyEnum.md)
 - [SdkModel.ProjectModule](docs/ProjectModule.md)
 - [SdkModel.ProjectModules](docs/ProjectModules.md)
 - [SdkModel.PseudoAssets](docs/PseudoAssets.md)
 - [SdkModel.QGPTAgentRelatedRoutes](docs/QGPTAgentRelatedRoutes.md)
 - [SdkModel.QGPTAgentRoutes](docs/QGPTAgentRoutes.md)
 - [SdkModel.QGPTConversation](docs/QGPTConversation.md)
 - [SdkModel.QGPTConversationMessage](docs/QGPTConversationMessage.md)
 - [SdkModel.QGPTConversationMessageRoleEnum](docs/QGPTConversationMessageRoleEnum.md)
 - [SdkModel.QGPTConversationPipeline](docs/QGPTConversationPipeline.md)
 - [SdkModel.QGPTConversationPipelineForContextualizedCodeDialog](docs/QGPTConversationPipelineForContextualizedCodeDialog.md)
 - [SdkModel.QGPTConversationPipelineForContextualizedCodeGeneration](docs/QGPTConversationPipelineForContextualizedCodeGeneration.md)
 - [SdkModel.QGPTConversationPipelineForContextualizedCodeWorkstreamDialog](docs/QGPTConversationPipelineForContextualizedCodeWorkstreamDialog.md)
 - [SdkModel.QGPTConversationPipelineForGeneralizedCodeDialog](docs/QGPTConversationPipelineForGeneralizedCodeDialog.md)
 - [SdkModel.QGPTHintsInput](docs/QGPTHintsInput.md)
 - [SdkModel.QGPTPersonsRelatedInput](docs/QGPTPersonsRelatedInput.md)
 - [SdkModel.QGPTPersonsRelatedOutput](docs/QGPTPersonsRelatedOutput.md)
 - [SdkModel.QGPTPromptPipeline](docs/QGPTPromptPipeline.md)
 - [SdkModel.QGPTQuestionAnswer](docs/QGPTQuestionAnswer.md)
 - [SdkModel.QGPTQuestionAnswers](docs/QGPTQuestionAnswers.md)
 - [SdkModel.QGPTQuestionInput](docs/QGPTQuestionInput.md)
 - [SdkModel.QGPTQuestionOutput](docs/QGPTQuestionOutput.md)
 - [SdkModel.QGPTRelevanceInput](docs/QGPTRelevanceInput.md)
 - [SdkModel.QGPTRelevanceInputOptions](docs/QGPTRelevanceInputOptions.md)
 - [SdkModel.QGPTRelevanceOutput](docs/QGPTRelevanceOutput.md)
 - [SdkModel.QGPTRepromptInput](docs/QGPTRepromptInput.md)
 - [SdkModel.QGPTRepromptOutput](docs/QGPTRepromptOutput.md)
 - [SdkModel.QGPTStreamEnum](docs/QGPTStreamEnum.md)
 - [SdkModel.QGPTStreamInput](docs/QGPTStreamInput.md)
 - [SdkModel.QGPTStreamOutput](docs/QGPTStreamOutput.md)
 - [SdkModel.QGPTStreamedOutputExtractedMaterials](docs/QGPTStreamedOutputExtractedMaterials.md)
 - [SdkModel.QGPTStreamedOutputExtractedTextualMaterials](docs/QGPTStreamedOutputExtractedTextualMaterials.md)
 - [SdkModel.QGPTTaskPipeline](docs/QGPTTaskPipeline.md)
 - [SdkModel.QGPTTaskPipelineForCodeCommentation](docs/QGPTTaskPipelineForCodeCommentation.md)
 - [SdkModel.QGPTTaskPipelineForCodeCompletion](docs/QGPTTaskPipelineForCodeCompletion.md)
 - [SdkModel.QGPTTaskPipelineForCodeExplanation](docs/QGPTTaskPipelineForCodeExplanation.md)
 - [SdkModel.QGPTTaskPipelineForCodeFix](docs/QGPTTaskPipelineForCodeFix.md)
 - [SdkModel.QGPTTaskPipelineForCodeModification](docs/QGPTTaskPipelineForCodeModification.md)
 - [SdkModel.Range](docs/Range.md)
 - [SdkModel.Ranges](docs/Ranges.md)
 - [SdkModel.Reaction](docs/Reaction.md)
 - [SdkModel.Recipients](docs/Recipients.md)
 - [SdkModel.ReferencedActivity](docs/ReferencedActivity.md)
 - [SdkModel.ReferencedAnchor](docs/ReferencedAnchor.md)
 - [SdkModel.ReferencedAnchorPoint](docs/ReferencedAnchorPoint.md)
 - [SdkModel.ReferencedAnnotation](docs/ReferencedAnnotation.md)
 - [SdkModel.ReferencedApplication](docs/ReferencedApplication.md)
 - [SdkModel.ReferencedAsset](docs/ReferencedAsset.md)
 - [SdkModel.ReferencedConversation](docs/ReferencedConversation.md)
 - [SdkModel.ReferencedConversationMessage](docs/ReferencedConversationMessage.md)
 - [SdkModel.ReferencedDistribution](docs/ReferencedDistribution.md)
 - [SdkModel.ReferencedFormat](docs/ReferencedFormat.md)
 - [SdkModel.ReferencedHint](docs/ReferencedHint.md)
 - [SdkModel.ReferencedModel](docs/ReferencedModel.md)
 - [SdkModel.ReferencedPerson](docs/ReferencedPerson.md)
 - [SdkModel.ReferencedRange](docs/ReferencedRange.md)
 - [SdkModel.ReferencedSensitive](docs/ReferencedSensitive.md)
 - [SdkModel.ReferencedShare](docs/ReferencedShare.md)
 - [SdkModel.ReferencedTag](docs/ReferencedTag.md)
 - [SdkModel.ReferencedUser](docs/ReferencedUser.md)
 - [SdkModel.ReferencedWebsite](docs/ReferencedWebsite.md)
 - [SdkModel.ReferencedWorkstreamEvent](docs/ReferencedWorkstreamEvent.md)
 - [SdkModel.ReferencedWorkstreamPatternEngineVisionEvent](docs/ReferencedWorkstreamPatternEngineVisionEvent.md)
 - [SdkModel.ReferencedWorkstreamSummary](docs/ReferencedWorkstreamSummary.md)
 - [SdkModel.Relationship](docs/Relationship.md)
 - [SdkModel.Relationships](docs/Relationships.md)
 - [SdkModel.RelevantQGPTSeed](docs/RelevantQGPTSeed.md)
 - [SdkModel.RelevantQGPTSeeds](docs/RelevantQGPTSeeds.md)
 - [SdkModel.ResultedPKCE](docs/ResultedPKCE.md)
 - [SdkModel.ReturnedUserProfile](docs/ReturnedUserProfile.md)
 - [SdkModel.ReuseReaction](docs/ReuseReaction.md)
 - [SdkModel.ReuseSuggestion](docs/ReuseSuggestion.md)
 - [SdkModel.RevokedPKCE](docs/RevokedPKCE.md)
 - [SdkModel.Role](docs/Role.md)
 - [SdkModel.SaveSuggestion](docs/SaveSuggestion.md)
 - [SdkModel.Score](docs/Score.md)
 - [SdkModel.SearchEngine](docs/SearchEngine.md)
 - [SdkModel.SearchEngines](docs/SearchEngines.md)
 - [SdkModel.SearchInput](docs/SearchInput.md)
 - [SdkModel.SearchedAnchor](docs/SearchedAnchor.md)
 - [SdkModel.SearchedAnchorPoint](docs/SearchedAnchorPoint.md)
 - [SdkModel.SearchedAnchorPoints](docs/SearchedAnchorPoints.md)
 - [SdkModel.SearchedAnchors](docs/SearchedAnchors.md)
 - [SdkModel.SearchedAnnotation](docs/SearchedAnnotation.md)
 - [SdkModel.SearchedAnnotations](docs/SearchedAnnotations.md)
 - [SdkModel.SearchedAsset](docs/SearchedAsset.md)
 - [SdkModel.SearchedAssets](docs/SearchedAssets.md)
 - [SdkModel.SearchedConversation](docs/SearchedConversation.md)
 - [SdkModel.SearchedConversationMessage](docs/SearchedConversationMessage.md)
 - [SdkModel.SearchedConversationMessages](docs/SearchedConversationMessages.md)
 - [SdkModel.SearchedConversations](docs/SearchedConversations.md)
 - [SdkModel.SearchedHint](docs/SearchedHint.md)
 - [SdkModel.SearchedHints](docs/SearchedHints.md)
 - [SdkModel.SearchedMatchEnum](docs/SearchedMatchEnum.md)
 - [SdkModel.SearchedPerson](docs/SearchedPerson.md)
 - [SdkModel.SearchedPersons](docs/SearchedPersons.md)
 - [SdkModel.SearchedSensitive](docs/SearchedSensitive.md)
 - [SdkModel.SearchedSensitives](docs/SearchedSensitives.md)
 - [SdkModel.SearchedTag](docs/SearchedTag.md)
 - [SdkModel.SearchedTags](docs/SearchedTags.md)
 - [SdkModel.SearchedWebsite](docs/SearchedWebsite.md)
 - [SdkModel.SearchedWebsites](docs/SearchedWebsites.md)
 - [SdkModel.SearchedWorkstreamPatternEngineVisionEvent](docs/SearchedWorkstreamPatternEngineVisionEvent.md)
 - [SdkModel.SearchedWorkstreamPatternEngineVisionEvents](docs/SearchedWorkstreamPatternEngineVisionEvents.md)
 - [SdkModel.SearchedWorkstreamSummaries](docs/SearchedWorkstreamSummaries.md)
 - [SdkModel.SearchedWorkstreamSummary](docs/SearchedWorkstreamSummary.md)
 - [SdkModel.Seed](docs/Seed.md)
 - [SdkModel.SeededAccessor](docs/SeededAccessor.md)
 - [SdkModel.SeededActivity](docs/SeededActivity.md)
 - [SdkModel.SeededAnchor](docs/SeededAnchor.md)
 - [SdkModel.SeededAnchorPoint](docs/SeededAnchorPoint.md)
 - [SdkModel.SeededAnnotation](docs/SeededAnnotation.md)
 - [SdkModel.SeededAsset](docs/SeededAsset.md)
 - [SdkModel.SeededAssetEnrichment](docs/SeededAssetEnrichment.md)
 - [SdkModel.SeededAssetMetadata](docs/SeededAssetMetadata.md)
 - [SdkModel.SeededAssetSensitive](docs/SeededAssetSensitive.md)
 - [SdkModel.SeededAssetTag](docs/SeededAssetTag.md)
 - [SdkModel.SeededAssetTags](docs/SeededAssetTags.md)
 - [SdkModel.SeededAssetWebsite](docs/SeededAssetWebsite.md)
 - [SdkModel.SeededAssetsRecommendation](docs/SeededAssetsRecommendation.md)
 - [SdkModel.SeededBackup](docs/SeededBackup.md)
 - [SdkModel.SeededClassification](docs/SeededClassification.md)
 - [SdkModel.SeededConnectorAsset](docs/SeededConnectorAsset.md)
 - [SdkModel.SeededConnectorConnection](docs/SeededConnectorConnection.md)
 - [SdkModel.SeededConnectorCreation](docs/SeededConnectorCreation.md)
 - [SdkModel.SeededConnectorTracking](docs/SeededConnectorTracking.md)
 - [SdkModel.SeededConversation](docs/SeededConversation.md)
 - [SdkModel.SeededConversationMessage](docs/SeededConversationMessage.md)
 - [SdkModel.SeededDiscoverableAsset](docs/SeededDiscoverableAsset.md)
 - [SdkModel.SeededDiscoverableAssets](docs/SeededDiscoverableAssets.md)
 - [SdkModel.SeededDiscoverableHtmlWebpage](docs/SeededDiscoverableHtmlWebpage.md)
 - [SdkModel.SeededDiscoverableHtmlWebpages](docs/SeededDiscoverableHtmlWebpages.md)
 - [SdkModel.SeededDiscoverableRelatedTag](docs/SeededDiscoverableRelatedTag.md)
 - [SdkModel.SeededDiscoverableRelatedTags](docs/SeededDiscoverableRelatedTags.md)
 - [SdkModel.SeededDiscoverableSensitive](docs/SeededDiscoverableSensitive.md)
 - [SdkModel.SeededDiscoverableSensitives](docs/SeededDiscoverableSensitives.md)
 - [SdkModel.SeededDistribution](docs/SeededDistribution.md)
 - [SdkModel.SeededDistributions](docs/SeededDistributions.md)
 - [SdkModel.SeededExternalProvider](docs/SeededExternalProvider.md)
 - [SdkModel.SeededFile](docs/SeededFile.md)
 - [SdkModel.SeededFormat](docs/SeededFormat.md)
 - [SdkModel.SeededFragment](docs/SeededFragment.md)
 - [SdkModel.SeededGitHubDistribution](docs/SeededGitHubDistribution.md)
 - [SdkModel.SeededGitHubGistDistribution](docs/SeededGitHubGistDistribution.md)
 - [SdkModel.SeededGithubGistsImport](docs/SeededGithubGistsImport.md)
 - [SdkModel.SeededHint](docs/SeededHint.md)
 - [SdkModel.SeededMacOSAsset](docs/SeededMacOSAsset.md)
 - [SdkModel.SeededModel](docs/SeededModel.md)
 - [SdkModel.SeededModels](docs/SeededModels.md)
 - [SdkModel.SeededPKCE](docs/SeededPKCE.md)
 - [SdkModel.SeededPKCEADDITIONALPARAMETERS](docs/SeededPKCEADDITIONALPARAMETERS.md)
 - [SdkModel.SeededPerson](docs/SeededPerson.md)
 - [SdkModel.SeededRange](docs/SeededRange.md)
 - [SdkModel.SeededRangeConversationAssociation](docs/SeededRangeConversationAssociation.md)
 - [SdkModel.SeededRangeConversationGroundingAssociation](docs/SeededRangeConversationGroundingAssociation.md)
 - [SdkModel.SeededRangeConversationGroundingTemporalAssociation](docs/SeededRangeConversationGroundingTemporalAssociation.md)
 - [SdkModel.SeededScore](docs/SeededScore.md)
 - [SdkModel.SeededScoreIncrement](docs/SeededScoreIncrement.md)
 - [SdkModel.SeededSensitive](docs/SeededSensitive.md)
 - [SdkModel.SeededShare](docs/SeededShare.md)
 - [SdkModel.SeededTag](docs/SeededTag.md)
 - [SdkModel.SeededTrackedAdoptionEvent](docs/SeededTrackedAdoptionEvent.md)
 - [SdkModel.SeededTrackedApplication](docs/SeededTrackedApplication.md)
 - [SdkModel.SeededTrackedAssetEvent](docs/SeededTrackedAssetEvent.md)
 - [SdkModel.SeededTrackedAssetsEvent](docs/SeededTrackedAssetsEvent.md)
 - [SdkModel.SeededTrackedAssetsEventMetadata](docs/SeededTrackedAssetsEventMetadata.md)
 - [SdkModel.SeededTrackedConversationEvent](docs/SeededTrackedConversationEvent.md)
 - [SdkModel.SeededTrackedFormatEvent](docs/SeededTrackedFormatEvent.md)
 - [SdkModel.SeededTrackedInteractionEvent](docs/SeededTrackedInteractionEvent.md)
 - [SdkModel.SeededTrackedInteractionEventIdentifierDescriptionPairs](docs/SeededTrackedInteractionEventIdentifierDescriptionPairs.md)
 - [SdkModel.SeededTrackedKeyboardEvent](docs/SeededTrackedKeyboardEvent.md)
 - [SdkModel.SeededTrackedKeyboardEventIdentifierDescriptionPairs](docs/SeededTrackedKeyboardEventIdentifierDescriptionPairs.md)
 - [SdkModel.SeededTrackedMachineLearningEvent](docs/SeededTrackedMachineLearningEvent.md)
 - [SdkModel.SeededTrackedSessionEvent](docs/SeededTrackedSessionEvent.md)
 - [SdkModel.SeededUltraSuiteAsset](docs/SeededUltraSuiteAsset.md)
 - [SdkModel.SeededUser](docs/SeededUser.md)
 - [SdkModel.SeededWebsite](docs/SeededWebsite.md)
 - [SdkModel.SeededWorkstreamEvent](docs/SeededWorkstreamEvent.md)
 - [SdkModel.SeededWorkstreamIngestion](docs/SeededWorkstreamIngestion.md)
 - [SdkModel.SeededWorkstreamSuggestionsRefresh](docs/SeededWorkstreamSuggestionsRefresh.md)
 - [SdkModel.SeededWorkstreamSummary](docs/SeededWorkstreamSummary.md)
 - [SdkModel.Seeds](docs/Seeds.md)
 - [SdkModel.SegmentedTechnicalLanguage](docs/SegmentedTechnicalLanguage.md)
 - [SdkModel.SegmentedTechnicalLanguageFragment](docs/SegmentedTechnicalLanguageFragment.md)
 - [SdkModel.Sensitive](docs/Sensitive.md)
 - [SdkModel.SensitiveCategoryEnum](docs/SensitiveCategoryEnum.md)
 - [SdkModel.SensitiveMetadata](docs/SensitiveMetadata.md)
 - [SdkModel.SensitiveSeverityEnum](docs/SensitiveSeverityEnum.md)
 - [SdkModel.Sensitives](docs/Sensitives.md)
 - [SdkModel.Session](docs/Session.md)
 - [SdkModel.Share](docs/Share.md)
 - [SdkModel.Shares](docs/Shares.md)
 - [SdkModel.Space](docs/Space.md)
 - [SdkModel.StreamedIdentifier](docs/StreamedIdentifier.md)
 - [SdkModel.StreamedIdentifiers](docs/StreamedIdentifiers.md)
 - [SdkModel.Suggestion](docs/Suggestion.md)
 - [SdkModel.SuggestionTarget](docs/SuggestionTarget.md)
 - [SdkModel.SystemExecutionCpuInformation](docs/SystemExecutionCpuInformation.md)
 - [SdkModel.SystemExecutionInformation](docs/SystemExecutionInformation.md)
 - [SdkModel.TLPCodeDirectoryAnalytics](docs/TLPCodeDirectoryAnalytics.md)
 - [SdkModel.TLPCodeFileAnalytics](docs/TLPCodeFileAnalytics.md)
 - [SdkModel.TLPCodeFragmentClassification](docs/TLPCodeFragmentClassification.md)
 - [SdkModel.TLPCodeFragmentClassificationMetadata](docs/TLPCodeFragmentClassificationMetadata.md)
 - [SdkModel.TLPCodeFragmentDescription](docs/TLPCodeFragmentDescription.md)
 - [SdkModel.TLPCodeFragmentDescriptiveStatistics](docs/TLPCodeFragmentDescriptiveStatistics.md)
 - [SdkModel.TLPCodeFragmentReclassification](docs/TLPCodeFragmentReclassification.md)
 - [SdkModel.TLPCodeFragmentReclassificationUpdates](docs/TLPCodeFragmentReclassificationUpdates.md)
 - [SdkModel.TLPCodeFragmentStatistics](docs/TLPCodeFragmentStatistics.md)
 - [SdkModel.TLPCodeFragmentSuggestedReuse](docs/TLPCodeFragmentSuggestedReuse.md)
 - [SdkModel.TLPCodeFragmentSuggestedSave](docs/TLPCodeFragmentSuggestedSave.md)
 - [SdkModel.TLPCodeFragmentTagify](docs/TLPCodeFragmentTagify.md)
 - [SdkModel.TLPCodeProcessing](docs/TLPCodeProcessing.md)
 - [SdkModel.TLPCodeRepositoryAnalytics](docs/TLPCodeRepositoryAnalytics.md)
 - [SdkModel.TLPCodeSnippetAnalytics](docs/TLPCodeSnippetAnalytics.md)
 - [SdkModel.TLPCodeSnippetSuggestedInteractions](docs/TLPCodeSnippetSuggestedInteractions.md)
 - [SdkModel.TLPCodeSnippetTagifyCode](docs/TLPCodeSnippetTagifyCode.md)
 - [SdkModel.TLPDirectedDiscoveryFilter](docs/TLPDirectedDiscoveryFilter.md)
 - [SdkModel.TLPDirectedDiscoveryFilterEnum](docs/TLPDirectedDiscoveryFilterEnum.md)
 - [SdkModel.TLPDirectedDiscoveryFilters](docs/TLPDirectedDiscoveryFilters.md)
 - [SdkModel.TLPMachineLearningProcessingEvent](docs/TLPMachineLearningProcessingEvent.md)
 - [SdkModel.Tag](docs/Tag.md)
 - [SdkModel.TagCategoryEnum](docs/TagCategoryEnum.md)
 - [SdkModel.Tags](docs/Tags.md)
 - [SdkModel.TemporalRangeGrounding](docs/TemporalRangeGrounding.md)
 - [SdkModel.TemporalSearchOptions](docs/TemporalSearchOptions.md)
 - [SdkModel.TerminatingOSServerApplet](docs/TerminatingOSServerApplet.md)
 - [SdkModel.TextLocation](docs/TextLocation.md)
 - [SdkModel.TextMatch](docs/TextMatch.md)
 - [SdkModel.TextuallyExtractedMaterial](docs/TextuallyExtractedMaterial.md)
 - [SdkModel.TextuallyExtractedMaterials](docs/TextuallyExtractedMaterials.md)
 - [SdkModel.Theme](docs/Theme.md)
 - [SdkModel.TokenizedPKCE](docs/TokenizedPKCE.md)
 - [SdkModel.TrackedAssetEventCreationMetadata](docs/TrackedAssetEventCreationMetadata.md)
 - [SdkModel.TrackedAssetEventCreationMetadataClipboard](docs/TrackedAssetEventCreationMetadataClipboard.md)
 - [SdkModel.TrackedAssetEventCreationMetadataFile](docs/TrackedAssetEventCreationMetadataFile.md)
 - [SdkModel.TrackedAssetEventFormatReclassificationMetadata](docs/TrackedAssetEventFormatReclassificationMetadata.md)
 - [SdkModel.TrackedAssetEventIdentifierDescriptionPairs](docs/TrackedAssetEventIdentifierDescriptionPairs.md)
 - [SdkModel.TrackedAssetEventMetadata](docs/TrackedAssetEventMetadata.md)
 - [SdkModel.TrackedAssetEventRenameMetadata](docs/TrackedAssetEventRenameMetadata.md)
 - [SdkModel.TrackedAssetsEventIdentifierDescriptionPairs](docs/TrackedAssetsEventIdentifierDescriptionPairs.md)
 - [SdkModel.TrackedAssetsEventSearchMetadata](docs/TrackedAssetsEventSearchMetadata.md)
 - [SdkModel.TrackedAssetsEventSearchMetadataResults](docs/TrackedAssetsEventSearchMetadataResults.md)
 - [SdkModel.TrackedConversationEventIdentifierDescriptionPairs](docs/TrackedConversationEventIdentifierDescriptionPairs.md)
 - [SdkModel.TrackedConversationEventMetadata](docs/TrackedConversationEventMetadata.md)
 - [SdkModel.TrackedConversationEventRenameMetadata](docs/TrackedConversationEventRenameMetadata.md)
 - [SdkModel.TrackedFormatEventIdentifierDescriptionPairs](docs/TrackedFormatEventIdentifierDescriptionPairs.md)
 - [SdkModel.TrackedFormatEventMetadata](docs/TrackedFormatEventMetadata.md)
 - [SdkModel.TrackedSessionEventIdentifierDescriptionPairs](docs/TrackedSessionEventIdentifierDescriptionPairs.md)
 - [SdkModel.TrackedSummaryTotals](docs/TrackedSummaryTotals.md)
 - [SdkModel.TransferableBytes](docs/TransferableBytes.md)
 - [SdkModel.TransferableString](docs/TransferableString.md)
 - [SdkModel.UncheckedOSServerUpdate](docs/UncheckedOSServerUpdate.md)
 - [SdkModel.UnsegmentedTechnicalLanguage](docs/UnsegmentedTechnicalLanguage.md)
 - [SdkModel.UpdatedExternalProviderApiKey](docs/UpdatedExternalProviderApiKey.md)
 - [SdkModel.UpdatingStatusEnum](docs/UpdatingStatusEnum.md)
 - [SdkModel.UserBetaStatus](docs/UserBetaStatus.md)
 - [SdkModel.UserProfile](docs/UserProfile.md)
 - [SdkModel.Users](docs/Users.md)
 - [SdkModel.VerifiedOSFilesystemPath](docs/VerifiedOSFilesystemPath.md)
 - [SdkModel.Website](docs/Website.md)
 - [SdkModel.Websites](docs/Websites.md)
 - [SdkModel.WindowDimensions](docs/WindowDimensions.md)
 - [SdkModel.WorkstreamEvent](docs/WorkstreamEvent.md)
 - [SdkModel.WorkstreamEventContext](docs/WorkstreamEventContext.md)
 - [SdkModel.WorkstreamEventTrigger](docs/WorkstreamEventTrigger.md)
 - [SdkModel.WorkstreamEventTriggerContextBrowser](docs/WorkstreamEventTriggerContextBrowser.md)
 - [SdkModel.WorkstreamEventTriggerContextIDE](docs/WorkstreamEventTriggerContextIDE.md)
 - [SdkModel.WorkstreamEvents](docs/WorkstreamEvents.md)
 - [SdkModel.WorkstreamIngestion](docs/WorkstreamIngestion.md)
 - [SdkModel.WorkstreamPatternEngineDataCleanupRequest](docs/WorkstreamPatternEngineDataCleanupRequest.md)
 - [SdkModel.WorkstreamPatternEngineSource](docs/WorkstreamPatternEngineSource.md)
 - [SdkModel.WorkstreamPatternEngineSources](docs/WorkstreamPatternEngineSources.md)
 - [SdkModel.WorkstreamPatternEngineStatus](docs/WorkstreamPatternEngineStatus.md)
 - [SdkModel.WorkstreamPatternEngineVisionCalibration](docs/WorkstreamPatternEngineVisionCalibration.md)
 - [SdkModel.WorkstreamPatternEngineVisionCalibrations](docs/WorkstreamPatternEngineVisionCalibrations.md)
 - [SdkModel.WorkstreamPatternEngineVisionEvent](docs/WorkstreamPatternEngineVisionEvent.md)
 - [SdkModel.WorkstreamPatternEngineVisionEventDeletions](docs/WorkstreamPatternEngineVisionEventDeletions.md)
 - [SdkModel.WorkstreamPatternEngineVisionEventTextualValue](docs/WorkstreamPatternEngineVisionEventTextualValue.md)
 - [SdkModel.WorkstreamPatternEngineVisionEvents](docs/WorkstreamPatternEngineVisionEvents.md)
 - [SdkModel.WorkstreamPatternEngineVisionEventsMetadata](docs/WorkstreamPatternEngineVisionEventsMetadata.md)
 - [SdkModel.WorkstreamPatternEngineVisionMetadata](docs/WorkstreamPatternEngineVisionMetadata.md)
 - [SdkModel.WorkstreamPatternEngineVisionStatus](docs/WorkstreamPatternEngineVisionStatus.md)
 - [SdkModel.WorkstreamSearchOptions](docs/WorkstreamSearchOptions.md)
 - [SdkModel.WorkstreamSuggestion](docs/WorkstreamSuggestion.md)
 - [SdkModel.WorkstreamSuggestionType](docs/WorkstreamSuggestionType.md)
 - [SdkModel.WorkstreamSuggestions](docs/WorkstreamSuggestions.md)
 - [SdkModel.WorkstreamSuggestionsRefresh](docs/WorkstreamSuggestionsRefresh.md)
 - [SdkModel.WorkstreamSummaries](docs/WorkstreamSummaries.md)
 - [SdkModel.WorkstreamSummary](docs/WorkstreamSummary.md)


<a id="documentation-for-authorization"></a>
## Documentation for Authorization


Authentication schemes defined for the API:
<a id="auth0"></a>
### auth0

- **Type**: OAuth
- **Flow**: implicit
- **Authorization URL**: 
- **Scopes**: N/A

<a id="auth0"></a>
### auth0

- **Type**: OAuth
- **Flow**: application
- **Authorization URL**: 
- **Scopes**: N/A

<a id="auth0"></a>
### auth0

- **Type**: OAuth
- **Flow**: accessCode
- **Authorization URL**: 
- **Scopes**: N/A

<a id="authorization"></a>
### authorization

- **Type**: OAuth
- **Flow**: implicit
- **Authorization URL**: 
- **Scopes**: N/A

<a id="authorization"></a>
### authorization

- **Type**: OAuth
- **Flow**: application
- **Authorization URL**: 
- **Scopes**: N/A

<a id="authorization"></a>
### authorization

- **Type**: OAuth
- **Flow**: accessCode
- **Authorization URL**: 
- **Scopes**: N/A

<a id="application"></a>
### application

- **Type**: API key
- **API key parameter name**: X-Application-ID
- **Location**: HTTP header

