namespace Eto.Forms;

/// <summary>
/// Enumeration to define the dock position of a control, such as tabs in the <see cref="TabControl"/>
/// </summary>
public enum DockPosition
{
	/// <summary>
	/// Element is docked to the top of the content.
	/// </summary>
	Top,
	/// <summary>
	/// Element is docked to the left of the content.
	/// </summary>
	Left,
	/// <summary>
	/// Element is docked to the right of the content.
	/// </summary>
	Right,
	/// <summary>
	/// Element is docked to the bottom of the content.
	/// </summary>
	Bottom
}