/// \file waString.h
/// webapp::Stringͷļ
/// ̳stringַ
/// <a href=std_string.html>stringʹ˵ĵ</a>

#ifndef _WEBAPPLIB_STRING_H_
#define _WEBAPPLIB_STRING_H_ 

#include <sys/stat.h>
#include <cstdarg>
#include <iostream>
#include <string>
#include <vector>
#include <algorithm>
#include <map>

using namespace std;

/// Web Application Library namaspace
namespace webapp {
	
////////////////////////////////////////////////////////////////////////////////	
// հַб
const char BLANK_CHARS[] = " \t\n\r\v\f";

////////////////////////////////////////////////////////////////////////////////
/// long intתΪstring
string itos( const long i, const ios::fmtflags base = ios::dec );
/// stringתΪint
long stoi( const string &s, const ios::fmtflags base = ios::dec );

/// doubleתΪstring
string ftos( const double f, const int ndigit = 2 );
/// stringתΪdouble
double stof( const string &s );

/// жһ˫ַֽǷGBK뺺
bool isgbk( const unsigned char c1, const unsigned char c2 );

/// ɱַʽva_start()va_end()ʹ
string va_sprintf( va_list ap, const string &format );
/// ʽַ
string va_str( const char *format, ... );

////////////////////////////////////////////////////////////////////////////////
/// ̳stringַ
/// <a href="std_string.html">stringʹ˵ĵ</a>
class String : public string {
	public:
	
	////////////////////////////////////////////////////////////////////////////
	/// ĬϹ캯
	String(){}
	
	/// Ϊchar*Ĺ캯
	String( const char *s ) {
		if( s ) this->assign( s );
		else this->erase();
	}
	
	/// ΪstringĹ캯
	String( const string &s ) {
		this->assign( s );
	}
	
	/// 
	virtual ~String(){}
	
	////////////////////////////////////////////////////////////////////////////
	/// \enum String::split()ָطʽ
	enum split_mode {
		/// ָؽֶ
		SPLIT_IGNORE_BLANK,
		/// ָؽֶ
		SPLIT_KEEP_BLANK
	};	

	////////////////////////////////////////////////////////////////////////////
	///  char* ͽ߱ delete[] ͷڴ
	char* c_char() const;
	
	/// ַ֧ȫַ
	string::size_type w_length() const;
	/// ȡַ֧ȫַ
	String w_substr( const string::size_type pos = 0, 
		const string::size_type n = npos ) const;

	/// հַ
	void trim_left( const string &blank = BLANK_CHARS );
	/// Ҳհַ
	void trim_right( const string &blank = BLANK_CHARS );
	/// հַ
	void trim( const string &blank = BLANK_CHARS );

	/// ߽ȡָӴ
	String left( const string::size_type n ) const;
	/// мȡָӴ
	String mid( const string::size_type pos, 
		const string::size_type n = npos ) const;
	/// ұ߽ȡָӴ
	String right( const string::size_type n ) const;
	
	/// ַ
	void resize( const string::size_type n );

	/// ͳָӴֵĴ
	int count( const string &str ) const;
	
	/// ݷַָָ
	vector<String> split( const string &tag, const int limit = 0, 
		const split_mode mode = SPLIT_IGNORE_BLANK ) const;
	
	/// תַΪMAPṹ(map<string,string>)
	map<string,string> tomap( const string &itemtag = "&", 
		const string &exptag = "=" ) const;

	/// ַ
	void join( const vector<string> &strings, const string &tag );
	void join( const vector<String> &strings, const string &tag );

	/// ʽֵ
	bool sprintf( const char *format, ... );
	
	/// 滻
	int replace( const string &oldstr, const string &newstr );
	/// ȫ滻
	int replace_all( const string &oldstr, const string &newstr );
	
	/// תΪдĸ
	void upper();
	/// תΪСдĸ
	void lower();
	
	/// ַǷȫ
	bool isnum() const;
	
	/// ȡļַ
	bool load_file( const string &filename );
	/// ַļ
	bool save_file( const string &filename, const ios::openmode mode = ios::trunc|ios::out,
		const mode_t permission = S_IRUSR|S_IWUSR|S_IRGRP|S_IWGRP|S_IROTH|S_IWOTH ) const;
};

} // namespace

#endif //_WEBAPPLIB_STRING_H_

