/// \file waMysqlClient.h
/// webapp::ysqlClient,webapp::MysqlDataͷļ
/// MySQLݿC++ӿ

// :
// (CC) -I /usr/local/include/mysql/ -L /usr/local/lib/mysql -lmysqlclient -lm

#ifndef _WEBAPPLIB_MYSQLCLIENT_H_
#define _WEBAPPLIB_MYSQLCLIENT_H_ 

#include <string>
#include <vector>
#include <map>
#include <mysql.h>

using namespace std;

/// Web Application Library namaspace
namespace webapp {

/// \defgroup waMysqlClient waMysqlClientȫֺ

/// \ingroup waMysqlClient
/// \typedef MysqlDataRow 
/// MysqlData  (map<string,string>)
typedef map<string,string> MysqlDataRow;

/// SQLַת
string escape_sql( const string &str );

/// MySQLݼ
class MysqlData {
	friend class MysqlClient;
	
	protected:
	
	/// MysqlData
	bool fill_data( MYSQL *mysql );
	
	size_t _rows, _cols, _curpos;
	size_t _fetched;

	MYSQL_RES *_mysqlres;
	MYSQL_ROW _mysqlrow;
	MYSQL_FIELD *_mysqlfields;
	map<string,int> _field_pos;

	////////////////////////////////////////////////////////////////////////////
	public:

	/// MysqlData캯
	MysqlData():
	_rows(0), _cols(0), _curpos(0), _fetched(0),
	_mysqlres(0), _mysqlfields(0)
	{};
	
	/// MysqlData
	virtual ~MysqlData();
	
	/// ָλõMysqlData
	/// \param row λ
	/// \param col λ
	/// \return ַ
	inline string operator() ( const size_t row, const size_t col ) {
		return this->get_data( row, col );
	}
	/// ָλõMysqlData
	string get_data( const size_t row, const size_t col );

	/// ֶָεMysqlData
	/// \param row λ
	/// \param field ֶ
	/// \return ַ
	inline string operator() ( const size_t row, const string &field ) {
		return this->get_data( row, field );
	}
	/// ֶָεMysqlData
	string get_data( const size_t row, const string &field );

	/// ָλõMysqlData
	MysqlDataRow get_row( const size_t row = 0 );

	/// MysqlData
	inline size_t rows() const {
		return _rows;
	}
	/// MysqlData
	inline size_t cols() const {
		return _cols;
	}
	
	/// ֶλ
	int field_pos( const string &field );
	/// ֶ
	string field_name( const size_t col ) const;

	////////////////////////////////////////////////////////////////////////////
	private:
	
	/// ֹÿ캯
	MysqlData( MysqlData &copy );
	/// ֹÿֵ
	MysqlData& operator = ( const MysqlData& copy );
};

/// MySQLݿ
class MysqlClient {
	public:
	
	/// MysqlĬϹ캯
	MysqlClient():
	_connected(false)
	{};
	
	/// Mysql캯
	/// \param host MySQLIP
	/// \param user MySQLû
	/// \param pwd û
	/// \param database Ҫ򿪵ݿ
	/// \param port ݿ˿ڣĬΪ0
	/// \param socket UNIX_SOCKETĬΪNULL
	MysqlClient( const string &host, const string &user, const string &pwd, 
		const string &database, const int port = 0, const char* socket = NULL ):
	_connected(false) 
	{
		this->connect( host, user, pwd, database, port, socket );
	}
	
	/// Mysql
	virtual ~MysqlClient() {
		this->disconnect();
	}
	
	/// ݿ
	bool connect( const string &host, const string &user, const string &pwd, 
		const string &database, const int port = 0, const char* socket = NULL );
	/// Ͽݿ
	void disconnect();
	/// жǷݿ
	bool is_connected();
	
	/// ѡݿ
	bool select_db( const string &database );

	/// ִSQL,ȡòѯ
	bool query( const string &sqlstr, MysqlData &records );
	/// ִSQL
	bool query( const string &sqlstr );
	
	/// زѯָλõֵַ
	string query_val( const string &sqlstr, 
		const size_t row = 0, const size_t col = 0 );
	
	/// زѯָ
	MysqlDataRow query_row( const string &sqlstr, const size_t row = 0 );

	/// ϴβѯӰļ¼
	size_t affected();
	/// ȡϴβѯһAUTO_INCREMENTɵID
	size_t last_id();
	
	/// ȡMysqlϢ
	/// \return شϢַ
	inline string error() {
		return string( mysql_error(&_mysql) );
	}
	/// ȡMysql
	/// \return شϢ
	inline size_t errnum() {
		return mysql_errno( &_mysql );
	}

	/// ȡøϢ
	string info();

	////////////////////////////////////////////////////////////////////////////
	private:
	
	/// ֹÿ캯
	MysqlClient( MysqlClient &copy );
	/// ֹÿֵ
	MysqlClient& operator = ( const MysqlClient& copy );

	MYSQL _mysql;
	bool _connected;
};

} // namespace

#endif //_WEBAPPLIB_MYSQLCLIENT_H_

