/// \file waHttpClient.h
/// HTTPͻͷļ
///  webapp::String, webapp::Encode
/// <a href="wa_httpclient.html">ʹ˵ĵ򵥷</a>

#ifndef _WEBAPPLIB_HTTPCLIENT_H_
#define _WEBAPPLIB_HTTPCLIENT_H_ 

#include <string>
#include <vector>
#include <map>
#include "waString.h"

using namespace std;

/// Web Application Library namaspace
namespace webapp {
	
const string HTTP_CRLF = "\r\n";
const string DOUBLE_CRLF = "\r\n\r\n";
	
/// TCPȡûӦ
int tcp_request( const string &server, const int port, const string &request, 
	string &response, const int timeout );
/// ݷȡIP
string gethost_byname( const string &domain );
/// жַǷΪЧIP
bool isip( const string &ipstr );

/// HTTPͻ
/// <a href="wa_httpclient.html">ʹ˵ĵ򵥷</a>
class HttpClient {
	public:
	
	/// \enum Ϣ
	enum error_msg {
		/// ޴
		ERROR_NULL					= 0,
		/// socketʧ
		ERROR_CREATE_SOCKET			= 1,
		/// ޷ӷ
		ERROR_CONNECT_SERVER		= 2,
		/// ʧ
		ERROR_SEND_REQUEST			= 3,
		/// öʱʧܻӳʱ
		ERROR_RESPONSE_TIMEDOUT		= 4,
		/// ڵַϢ
		ERROR_SERVERINFO_NULL		= 5,
		/// HTTPʽ
		ERROR_REQUEST_NULL			= 6,
		/// ӦΪ
		ERROR_RESPONSE_NULL			= 7,
		/// Ӧʽ
		ERROR_RESPONSE_INVALID		= 8,
		/// ӦHTTP״̬
		ERROR_HTTPSTATUS			= 9,
		/// δ֪
		ERROR_UNKNOWN				= 10
	};

	/// ĬϹ캯
	HttpClient(){};
	
	/// 첢ִHTTP
	/// \param url HTTPURL
	/// \param server IP,Ϊַݲ1,ĬΪַ
	/// \param port ˿,ĬΪ80
	/// \param method HTTPMethod,ĬΪ"GET"
	/// \param timeout HTTPʱʱ,λΪ,ĬΪ5,Ϊ0жϳʱ
	HttpClient( const string &url, const string &server = "", const int port = 80, 
		const string &method = "GET", const int timeout = 5 ) 
	{
		this->request( url, server, port, method, timeout );
	}
		  
	/// 
	virtual ~HttpClient(){};

	/// ָHTTPHeader
	void set_header( const string &name, const string &value );
	/// HTTPReferer Header
	void set_referer( const string &referer );
	/// HTTPAuthorization Header
	void set_auth( const string &username, const string &password );
	/// HTTPCookie Header
	void set_cookie( const string &name, const string &value );
	/// HTTPCGI
	void set_param( const string &name, const string &value );

	/// ִHTTP
	bool request( const string &url, const string &server = "", const int port = 80, 
		const string &method = "GET", const int timeout = 5 );
	/// URL ǷЧ
	bool exist( const string &url, const string &server = "", const int port = 80 );

	/// ȡָHTTPHeader
	string get_header( const string &name );
	/// ȡHTTPSet-Cookie Header
	vector<String> get_cookie();
	/// ȡHTTPHeader
	string dump_header();
	
	/// ִHTTPǷɹ
	bool done() const;
	/// ü״ֵ̬
	void clear();
	
	/// ȡHTTPStatus
	/// \return HTTPStatusַ
	inline string status() const {
		return _status;
	}
	/// ȡHTTPContent
	/// \return HTTPContent
	inline string content() const {
		return _content;
	}
	/// ȡHTTPContentĳ(Content-Length)
	/// \return HTTPContentĳ
	inline size_t content_length() const {
		return _content.length();
	}
	
	/// شϢ
	/// Ϣμ Http::error_msg
	inline error_msg errnum() const {
		return _errno;
	}
	/// شϢ
	string error() const;

	/// ɵHTTPȫ
	/// \return ɵHTTPȫ
	inline string dump_request() const {
		return _request;
	}
	/// õķȫ
	/// \return ػõķȫ
	inline string dump_response() const {
		return _response;
	}
	
	////////////////////////////////////////////////////////////////////////////
	private:

	/// HTTP URLַ
	void parse_url( const string &url, string &parsed_host, string &parsed_addr,
		string &parsed_url, string &parsed_param, int &parsed_port );
	/// HTTPַ
	string gen_httpreq( const string &url, const string &params,
		const string &host, const string &method );
	/// HTTP
	void parse_response( const string &response );
	/// HTTPchunkedcontent
	string parse_chunked( const string &chunkedstr );
	
	// set		
	String _request;			// generated request
	String _params;				// http request params
	map<string,string> _sets;	// push http headers

	// get
	String _response;			// server response
	String _status;				// http response status
	String _content;			// http response content
	map<string,string> _gets;	// recv http headers
	
	error_msg _errno;			// current error code
};

} // namespace

#endif //_WEBAPPLIB_HTTPCLIENT_H_ 

