/// \file waFileSystem.h
/// ļͷļ
/// ļ

#ifndef _WEBAPPLIB_FILE_H_
#define _WEBAPPLIB_FILE_H_ 

#include <cstdio>
#include <string>
#include <vector>
#include <fcntl.h>
#include <sys/stat.h>

using namespace std;

/// Web Application Library namaspace
namespace webapp {

/// ļĿ¼Ƿ
bool file_exist( const string &file );

/// ļǷΪ
bool is_link( const string &file );
/// ǷΪĿ¼
bool is_dir( const string &file );

/// 
bool make_link( const string &srcfile, const string &destfile );

/// ȡļС
size_t file_size( const string &file );
/// ȡļʱ
time_t file_time( const string &file );
/// ȡļ·
string file_path( const string &file );
/// ȡļ
string file_name( const string &file );

/// ļĿ¼
bool rename_file( const string &oldname, const string &newname );
/// ļ	
bool copy_file( const string &srcfile, const string &destfile );
/// ɾļ
bool delete_file( const string &file );
/// ƶļ
bool move_file( const string &srcfile, const string &destfile );

/// Ŀ¼ļб
vector<string> dir_files( const string &dir );
/// Ŀ¼
bool make_dir( const string &dir, 
	const mode_t mode = S_IRWXU|S_IRGRP|S_IXGRP|S_IROTH|S_IXOTH );
/// Ŀ¼
bool copy_dir( const string &srcdir, const string &destdir );
/// ɾĿ¼
bool delete_dir( const string &dir );
/// ƶĿ¼
bool move_dir( const string &srcdir, const string &destdir );
			  
/// ļ
void lock_file( int fd, const int type );
/// ļ
inline void lock_file( FILE *fp, const int type ) {
	lock_file( fileno(fp), type );
}

/// жļ
bool is_locked( int fd );
/// жļ
inline bool is_locked( FILE *fp ) {
	return is_locked( fileno(fp) );
}

/// ļ
FILE* lock_open( const string &file, const char* mode, const int type );

} // namespace

#endif //_WEBAPPLIB_FILE_H_

