/// \file waDateTime.h
/// webapp::DateTimeͷļ
/// ʱ

#ifndef _WEBAPPLIB_DATETIME_H_
#define _WEBAPPLIB_DATETIME_H_ 

#include <string>
#include <ctime>

using namespace std;

/// Web Application Library namaspace
namespace webapp {

/// \defgroup waDateTime waDateTimeȫֺ

/// \ingroup waDateTime
/// \def TIME_ONE_SEC 
/// ʱһ
#define	TIME_ONE_SEC	1

/// \ingroup waDateTime
/// \def TIME_ONE_MIN 
/// ʱһ
#define	TIME_ONE_MIN	60

/// \ingroup waDateTime
/// \def TIME_ONE_HOUR 
/// ʱһСʱ
#define	TIME_ONE_HOUR	3600

/// \ingroup waDateTime
/// \def TIME_ONE_DAY 
/// ʱһ
#define	TIME_ONE_DAY	86400

/// \ingroup waDateTime
/// \def TIME_ONE_WEEK 
/// ʱһ
#define	TIME_ONE_WEEK	604800

/// DateTimeʱ
class DateTime {
	public:
	
	/// ĬϹ캯,Եǰʱ乹
	DateTime() {
		this->set();
	}
	
	/// Ϊ time_t Ĺ캯
	DateTime( const time_t &tt ) {
		this->set( tt );
	}
	
	/// ΪָʱĹ캯
	DateTime( const int year, const int mon, const int mday, 
		const int hour=0, const int min=0, const int sec=0 ) 
	{
		this->set( year, mon, mday, hour, min, sec );
	}
	
	/// Ϊ tm ṹĹ캯
	DateTime( const tm &st ) {
		this->set( st );
	}
	
	/// Ϊ"YYYY-MM-DD HH:MM:SS"ʽַĹ캯
	DateTime( const string &datetime, const string &datemark = "-", 
		const string &dtmark = " ", const string &timemark = ":" ) 
	{
		this->set( datetime, datemark, dtmark, timemark );
	}

	/// 캯
	DateTime ( const DateTime &date ) {
		this->set( date );
	}
		  
	/// 
	virtual ~DateTime() {}
	
	/// ֵ
	DateTime& operator=( const DateTime &date );
	/// ֵ
	DateTime& operator=( const time_t &tt );

	/// 
	DateTime& operator+=( const DateTime &date );
	/// 
	DateTime& operator+=( const time_t &tt );
	
	/// ݼ
	DateTime& operator-=( const DateTime &date );
	/// ݼ
	DateTime& operator-=( const time_t &tt );

	/// λ
	inline int year() const {return _tm.tm_year+1900;}
	/// ·ݣΧ1~12
	inline int month() const {return _tm.tm_mon+1;}
	/// صµڼ죬Χ1~31
	inline int m_day() const {return _tm.tm_mday;}
	/// صΧ1~31
	int m_days() const;
	/// صܵڼ죬һ1~6շ0
	inline int w_day() const {return _tm.tm_wday;}
	/// صڼ죬Χ0~365
	inline int y_day() const {return _tm.tm_yday;}
	/// СʱΧ0~23
	inline int hour() const {return _tm.tm_hour;}
	/// طӣΧ0~59
	inline int min() const {return _tm.tm_min;}
	/// Χ0~59
	inline int sec() const {return _tm.tm_sec;}
	
	///  1970-1-1 0:0:0 
	inline time_t secs() const {return _time;}
	///  1970-1-1 0:0:0 ķ
	inline time_t mins() const {return ( _time/TIME_ONE_MIN );}
	///  1970-1-1 0:0:0 Сʱ
	inline time_t hours() const {return ( _time/TIME_ONE_HOUR );}
	///  1970-1-1 0:0:0 
	inline time_t days() const {return ( _time/TIME_ONE_DAY );}
	///  1970-1-1 0:0:0 
	inline time_t weeks() const {return ( _time/TIME_ONE_WEEK );}
	
	/// Եǰʱö
	void set();
	///  time_t ö
	void set( const time_t &tt );
	///  tm ṹö
	void set( const tm &st );
	/// ָʱö
	void set( const int year, const int mon, const int mday, 
		const int hour=0, const int min=0, const int sec=0 );
	///  DateTime ö
	void set( const DateTime &date );
	/// "YYYY-MM-DD HH:MM:SS"ʽַö
	void set( const string &datetime, const string &datemark = "-", 
		const string &dtmark = " ", const string &timemark = ":" );
	
	///  time_t ͵Ķֵ
	inline time_t value() const {return this->secs();}
	///  struct tm ͵Ķֵ
	inline tm struct_tm() const {return _tm;}
	
	/// ַ
	string date( const string &datemark = "-", 
		const bool leadingzero = true ) const;
				 
	/// ʱַ
	string time( const string &timemark = ":", 
		const bool leadingzero = true ) const;
				 
	/// ʱַ
	string datetime( const string &datemark = "-", const string &dtmark = " ",
		const string &timemark = ":", const bool leadingzero = true ) const;
					 
	///  GMT ʽʱַ
	string gmt_datetime() const;
	
	////////////////////////////////////////////////////////////////////////////
	private:
	time_t _time;
	struct tm _tm;	
};

// operators

/// \ingroup waDateTime
/// \fn DateTime operator+( const DateTime &date1, const DateTime &date2 )
/// ʱ
DateTime operator+( const DateTime &date1, const DateTime &date2 );

/// \ingroup waDateTime
/// \fn DateTime operator+( const DateTime &date, const time_t &tt )
/// ʱ
DateTime operator+( const DateTime &date, const time_t &tt );

/// \ingroup waDateTime
/// \fn DateTime operator-( const DateTime &date1, const DateTime &date2 )
/// ʱ
DateTime operator-( const DateTime &date1, const DateTime &date2 );

/// \ingroup waDateTime
/// \fn DateTime operator-( const DateTime &date, const time_t &tt )
/// ʱ
DateTime operator-( const DateTime &date, const time_t &tt );

/// \ingroup waDateTime
/// \fn bool operator==( const DateTime &left, const DateTime &right )
/// ʱȱȽ
inline bool operator==( const DateTime &left, const DateTime &right ) {
	return ( left.value() == right.value() );
}

/// \ingroup waDateTime
/// \fn bool operator==( const DateTime &left, const time_t &right )
/// ʱȱȽ
inline bool operator==( const DateTime &left, const time_t &right ) {
	return ( left.value() == right );
}

/// \ingroup waDateTime
/// \fn bool operator!=( const DateTime &left, const DateTime &right )
/// ʱ䲻ȱȽ
inline bool operator!=( const DateTime &left, const DateTime &right ) {
	return ( left.value() != right.value() );
}

/// \ingroup waDateTime
/// \fn bool operator!=( const DateTime &left, const time_t &right )
/// ʱ䲻ȱȽ
inline bool operator!=( const DateTime &left, const time_t &right ) {
	return ( left.value() != right );
}

/// \ingroup waDateTime
/// \fn bool operator>( const DateTime &left, const DateTime &right )
/// ʱڱȽ
inline bool operator>( const DateTime &left, const DateTime &right ) {
	return ( left.value() > right.value() );
}

/// \ingroup waDateTime
/// \fn bool operator>( const DateTime &left, const time_t &right )
/// ʱڱȽ
inline bool operator>( const DateTime &left, const time_t &right ) {
	return ( left.value() > right );
}

/// \ingroup waDateTime
/// \fn bool operator<( const DateTime &left, const DateTime &right )
/// ʱСڱȽ
inline bool operator<( const DateTime &left, const DateTime &right ) {
	return ( left.value() < right.value() );
}

/// \ingroup waDateTime
/// \fn bool operator<( const DateTime &left, const time_t &right )
/// ʱСڱȽ
inline bool operator<( const DateTime &left, const time_t &right ) {
	return ( left.value() < right );
}

/// \ingroup waDateTime
/// \fn bool operator>=( const DateTime &left, const DateTime &right )
/// ʱ䲻СڱȽ
inline bool operator>=( const DateTime &left, const DateTime &right ) {
	return ( left.value() >= right.value() );
}

/// \ingroup waDateTime
/// \fn bool operator>=( const DateTime &left, const time_t &right )
/// ʱ䲻СڱȽ
inline bool operator>=( const DateTime &left, const time_t &right ) {
	return ( left.value() >= right );
}

/// \ingroup waDateTime
/// \fn bool operator<=( const DateTime &left, const DateTime &right )
/// ʱ䲻ڱȽ
inline bool operator<=( const DateTime &left, const DateTime &right ) {
	return ( left.value() <= right.value() );
}

/// \ingroup waDateTime
/// \fn bool operator<=( const DateTime &left, const time_t &right ) 
/// ʱ䲻ڱȽ
inline bool operator<=( const DateTime &left, const time_t &right ) {
	return ( left.value() <= right );
}

} // namespace

#endif //_WEBAPPLIB_DATETIME_H_

