/// \file waCgi.h
/// webapp::Cgi,webapp::Cookieͷļ
///  webapp::String, webapp::Encode

#ifndef _WEBAPPLIB_CGI_H_
#define _WEBAPPLIB_CGI_H_ 

#include <string>
#include <map>

using namespace std;

/// Web Application Library namaspace
namespace webapp {

////////////////////////////////////////////////////////////////////////////////	
/// HTML Content-Type header
void http_head();
/// ȡû
string get_env( const string &envname );

////////////////////////////////////////////////////////////////////////////////

/// \defgroup waCgi waCgiȫֺ

/// \ingroup waCgi
/// \typedef CgiList 
/// Cgi ֵб (map<string,string>)
typedef map<string,string> CgiList;

/// CGIȡ
class Cgi {
	public:

	/// 캯
	Cgi( const size_t formdata_maxsize = 0 );
	
	/// 
	virtual ~Cgi(){};
	
	/// ȡCGI
	string get_cgi( const string &name );
	
	/// ȡCGI
	inline string operator[] ( const string &name ) {
		return this->get_cgi( name );
	}
	
	/// FORMݴСǷ񳬳
	inline bool is_trunc() const {
		return _trunc;
	}
	
	/// زֵб
	/// \return ֵΪCgiList,map<string,string>.	
	inline CgiList dump() const {
		return _cgi;
	}
	
	////////////////////////////////////////////////////////////////////////////
	private:
	
	/// CGI
	void add_cgi( const string &name, const string &value );
	
	/// urlencoded
	void parse_urlencoded( const string &buf );
	
	/// multipart
	void parse_multipart( const string &content_type, const string &buf );

	map<string,string> _cgi;
	String _method;
	bool _trunc;
};

////////////////////////////////////////////////////////////////////////////
/// \ingroup waCgi
/// \typedef CookieList 
/// Cookie ֵб (map<string,string>)
typedef map<string,string> CookieList;

/// Cookieȡ,
class Cookie {
	public:
	
	/// 캯
	Cookie();
	
	/// 
	virtual ~Cookie(){};
	
	/// ȡcookie
	string get_cookie( const string &name );
	
	/// ȡcookie
	inline string operator[] ( const string &name ) {
		return this->get_cookie( name );
	}
	
	/// cookie
	void set_cookie( const string &name, const string &value, 
		const string &expires = "", const string &path = "/", 
		const string &domain = "" ) const;

	/// ָcookie
	/// \param name cookie
	inline void del_cookie( const string &name ) const {
		this->set_cookie( name, "", "Thursday,01-January-1970 08:00:01 GMT" );
	}
	
	/// زֵб
	/// \return ֵΪCookieList,map<string,string>.	
	inline CookieList dump() const {
		return _cookies;
	}

	////////////////////////////////////////////////////////////////////////////
	private:
	
	/// cookie
	void parse_cookie( const string &buf );

	map<string,string> _cookies;		
};

} // namespace

#endif //_WEBAPPLIB_CGI_H_

