/// \file example.cpp
/// ʾļʾһCGI

#include <iostream>
#include "webapplib.h"

using namespace webapp;

int main() {
	/***************************************************************************
	ʾCGIӦó,ģWEBѯ	
	1ȡCGICookieݣStringCgiCookie
	2ʹöȡĲȨ޼ӿڣConfigFileHttpClient
	3ʹöȡĲѯݿ⣨MysqlClient
	4ʹ־ļ¼ûFileSystemUtilityEncode
	5ûCookieCookieDateTime
	6ʾHTMLҳ棨Template
	***************************************************************************/	

	////////////////////////////////////////////////////////////////////////////
	// 1ȡCGICookieݣCgiCookie
	
	Cgi cgi;
	Cookie cookie;
	String username = cgi["username"];
	String usercookie = cookie["usercookie"];
	
	/*ʾ webapp::CgiڶCGIʱڵģʽʾCGIֵ*/
	
	////////////////////////////////////////////////////////////////////////////
	// 2ʹöȡĲȨ޼ӿڣConfigFileHttpClient
	
	ConfigFile conf( "example.conf" );
	String check_interface = conf["check_interface"];
	
	cout << "---------------------------------------------------------" << endl;
	cout << "check user privilege from:" << check_interface << endl;
	
	HttpClient www;
	www.request( check_interface + "?username=" + username );
	if ( www.done() && www.content()=="CHECK_PASS" ) {
		cout << "check pass" << endl;
	} else {
		cout << "check fail" << endl;
	}
	
	////////////////////////////////////////////////////////////////////////////
	// 3ʹöȡĲѯݿ⣨MysqlClient
	String value;
	#ifndef _WEBAPPLIB_NOMYSQL

	String sql;
	sql.sprintf( "SELECT value FROM table WHERE user='%s'", escape_sql(username).c_str() );
	
	MysqlClient mysqlclient;
	MysqlData mysqldata;

	mysqlclient.connect( "example.mysql.com", "user", "pwd", "database" );
	if ( mysqlclient.is_connected() ) {
		if ( mysqlclient.query(sql,mysqldata) ) {
			value = mysqldata( 0, "value" );
		} else {
			cout << mysqlclient.error() << endl;
		}
	}

	#endif //_WEBAPPLIB_NOMYSQL

	////////////////////////////////////////////////////////////////////////////
	// 4ʹ־ļ¼ûFileSystemUtilityEncode
	
	String log_path = "/tmp/";
	String log_file = log_path + "/logfile.txt";
	if ( !file_exist(log_path) || !is_dir(log_path) ) {
		make_dir( log_path );
	}

	file_logger( log_file, "username:%s", username.c_str() );
	file_logger( log_file, "usermd5:%s", md5_encode(username).c_str() );
	
	cout << "---------------------------------------------------------" << endl;
	String file_content;
	file_content.load_file( log_file );
	cout << file_content << endl;

	////////////////////////////////////////////////////////////////////////////
	// 5ûCookieCookieDateTime
	
	DateTime now;
	DateTime expires = now + ( TIME_ONE_DAY*3 ); // CookieЧΪ
	cookie.set_cookie( "username", username, expires.gmt_datetime() );
	
	////////////////////////////////////////////////////////////////////////////
	// 6ʾHTMLҳ棨Template
	
	Template page("example.tmpl");
	page.set( "username", username );
	page.set( "value", value );
	
	// ʾѯ
	cout << "---------------------------------------------------------" << endl;
	http_head();
	page.print();
}

