<a href="https://996.icu"><img src="https://img.shields.io/badge/link-996.icu-red.svg"></a>

- WebAppLib是一系列主要用于类Unix操作系统环境下WEB开发的C++类库。 设计目的是通过提供使用简单方便、相对独立的C++类和函数来简化CGI程序开发过程中的常见操作，提高开发效率，降低系统维护与改进的难度，适用于中等以上规模WEB系统开发
 
- WebAppLib所有的类、函数、变量都声明于webapp命名空间内，由以下部分组成：
  - String : 继承并兼容与std::string的字符串类，增加了开发中常用的字符串处理函数；
  - Cgi : 支持文件上传的CGI参数读取类；
  - Cookie : HTTP Cookie设置与读取类；
  - MysqlClient : MySQL数据库连接类，MySQL连接处理C函数接口的C++封装；
  - MysqlData : MySQL查询结果数据集类，MySQL查询结果数据提取C函数接口的C++封装；
  - Template : 支持在模板中嵌入条件跳转、循环输出脚本的 HTML 模板类；
  - HttpClient : HTTP/1.1通信协议客户端类；
  - DateTime : 日期时间运算、格式化输出类；
  - TextFile : 固定分隔符文本文件读取解析类；
  - ConfigFile : INI格式配置文件解析类；
  - FileSystem : 文件系统操作函数库；
  - Encode : 字符串编码解码函数库；
  - Utility : 系统调用与工具函数库

- 类库详细使用说明可参见类库参考手册 help.chm
- 编译本类库要求使用g++编译器，版本不低于v3.4.0，目前支持的操作系统有Linux(CentOS v4.0以上版本)，Solaris(v10以上版本)，还可以通过Cygwin环境运行于Windows操作系统

- 背景介绍：
  - 这个类库已经非常老旧了，是我03年到05年间开发维护的，05年之前曾应用于多个新浪项目，包括当时的论坛、聊天、用户库、CMS等，05年后随着新浪前端应用开发全面转向PHP，逐渐没人用了，现在大概只剩下少数历史比较悠久的项目还在继续使用吧。一开始是作为本人学习C++的练手项目开始的，后来用的人逐渐增多，其间陆陆续续升级了七八个版本，应该说大部分代码的稳定性已经经历过了考验，考虑到一点点个人感情因素，现在简单整理一下发布出来，没有任何使用上的限制，大概也不会有后续更新。这次发布之前做了一下整理，重构了一些类库和函数的命名，删除了很多已经证明并不需要的冗余接口。

- 建议：
  - 现在Web开发的主流显然不是C++，不过如果你想学习或者了解一下CGI开发的细节，可以作为参考，或者如果你已经有一个以C++为主体代码的项目，需要一点简单的Web包装，又不想学习或者引入一门新的脚本语言，可以试试看这个WebAppLib

- 其他：
  - webapp::String 的实现，受当时知识水平的限制，为了能沿用 std::string 的全部接口，是 public 继承自std::string的，现在看来显然不是一个说得过去的方案，只是在那几年的使用场景中，似乎也没有发现有不稳定的情况，所以现在懒得去修改了，各位自行决定是否使用吧。
  - 附说明，摘自《Effective C++》
  - 条款14: 确定基类有虚析构函数：当通过基类的指针去删除派生类的对象，而基类又没有虚析构函数时，结果将是不可确定的。
