Phpactor
========

![phpactor2sm](https://user-images.githubusercontent.com/530801/27995098-82e72c4c-64c0-11e7-96d2-f549c711ca8b.png)

![CI](https://github.com/phpactor/phpactor/workflows/CI/badge.svg?branch=master)

This project aims to provide heavy-lifting *refactoring* and *introspection*
tools which can be used standalone or as the backend for a text editor to
provide intelligent code completion.

- Accurate code [completion](https://phpactor.readthedocs.io/en/master/reference/completion.html) including class name auto-import.
- [Various](https://phpactor.readthedocs.io/en/master/reference/refactorings.html) refactoring,fixes and code generation options.
- Provides a [Language Server](https://phpactor.readthedocs.io/en/master/usage/language-server.html)
- Native [VIM plugin](https://phpactor.readthedocs.io/en/master/usage/vim-plugin.html) ([emacs](https://github.com/emacs-php/phpactor.el) plugin is in development).
- [Navigation](https://phpactor.readthedocs.io/en/master/reference/navigation.html) (jump to
  definition, related classes, references etc).
- [More](https://phpactor.readthedocs.io/en/master).

Installation
------------

Phpactor is a general tool, it is not intended that it be installed as a project dependency.

See
[Installation](https://phpactor.readthedocs.io/en/master/usage/standalone.html)
for installation instructions.

Requirements
------------

- PHP 8.1+
- [Composer](https://getcomposer.org/)

Project Recommendations
-----------------------

Phpactor will perform better with [Composer](https://getcomposer.org) and, to
a lesser extent, with [GiT](https://git-scm.org).

Documentation
-------------

Full documentation can be found on [Read the Docs](https://phpactor.readthedocs.io/en/master)

Community
---------

- Follow [@phpactor](https://phpc.social/@phpactor) on 🦣 Mastodon for latest news.
- Join the `#phpactor` channel on the Slack [Symfony Devs](https://symfony.com/slack-invite) channel.

Contributing
------------

This package is open source and welcomes contributions! Feel free to open a
pull request on this repository.

Support
-------

- Create an issue on the main [Phpactor](https://github.com/phpactor/phpactor) repository.
- Join the `#phpactor` channel on the Slack [Symfony Devs](https://symfony.com/slack-invite) channel.

Sponsors
--------

The following organisations are providing either financial support or free
services. If you would like to support Phpactor development financially you
can [sponsor me](https://github.com/sponsors/dantleech).

### Tinkerwell

[![Tinkerwell](https://user-images.githubusercontent.com/530801/172365695-f60dcd49-315f-48df-b146-7316697a30bd.png)](https://tinkerwell.app/)

### Blackfire

[![Blackfire](https://user-images.githubusercontent.com/530801/172365601-b8263c0a-387f-4ed4-b98f-3ac018eb56d0.png)](https://www.blackfire.io/)

