/*!
  * Tab v2.0.0-alpha.1 (https://phonon-framework.github.io)
  * Copyright 2015-2019 qathom
  * Licensed under MIT (https://github.com/phonon-framework/phonon/blob/master/LICENSE.md)
  */
'use strict';

function _interopDefault (ex) { return (ex && (typeof ex === 'object') && 'default' in ex) ? ex['default'] : ex; }

var Util = _interopDefault(require('../util.js'));

/*! *****************************************************************************
Copyright (c) Microsoft Corporation. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License"); you may not use
this file except in compliance with the License. You may obtain a copy of the
License at http://www.apache.org/licenses/LICENSE-2.0

THIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED
WARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,
MERCHANTABLITY OR NON-INFRINGEMENT.

See the Apache Version 2.0 License for specific language governing permissions
and limitations under the License.
***************************************************************************** */
/* global Reflect, Promise */

var extendStatics = function(d, b) {
    extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return extendStatics(d, b);
};

function __extends(d, b) {
    extendStatics(d, b);
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
}

function __awaiter(thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
}

function __generator(thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
}

var Component = function () {
  function Component(name, defaultProps, props) {
    var _this = this;

    this.template = '';
    this.id = null;
    this.eventHandlers = [];
    this.registeredElements = [];
    this.name = name;
    var element = typeof props.element === 'string' ? document.querySelector(props.element) : props.element;
    var config = {};

    if (element) {
      var dataConfig = Util.Selector.attrConfig(element);

      if (dataConfig) {
        config = dataConfig;
      }
    }

    this.defaultProps = defaultProps;
    this.props = Object.assign(defaultProps, config, props, {
      element: element
    });
    this.id = this.uid();

    this.elementListener = function (event) {
      return _this.onBeforeElementEvent(event);
    };

    this.setEventsHandler();
  }

  Component.prototype.setTemplate = function (template) {
    this.template = template;
  };

  Component.prototype.getTemplate = function () {
    return this.template;
  };

  Component.prototype.getElement = function () {
    return this.getProp('element') || null;
  };

  Component.prototype.setElement = function (element) {
    this.props.element = element;
  };

  Component.prototype.getId = function () {
    return this.id;
  };

  Component.prototype.uid = function () {
    return Math.random().toString(36).substr(2, 10);
  };

  Component.prototype.getName = function () {
    return this.name;
  };

  Component.prototype.getProps = function () {
    return this.props;
  };

  Component.prototype.getProp = function (name) {
    var defaultValue = this.defaultProps[name];
    return typeof this.props[name] !== 'undefined' ? this.props[name] : defaultValue;
  };

  Component.prototype.setProps = function (props) {
    var componentProps = Object.assign({}, props);
    this.props = Object.assign(this.props, componentProps);
  };

  Component.prototype.setProp = function (name, value) {
    if (typeof this.props[name] === 'undefined') {
      throw new Error('Cannot set an invalid prop');
    }

    this.props[name] = value;
  };

  Component.prototype.registerElements = function (elements) {
    var _this = this;

    elements.forEach(function (element) {
      return _this.registerElement(element);
    });
  };

  Component.prototype.registerElement = function (element) {
    element.target.addEventListener(element.event, this.elementListener);
    this.registeredElements.push(element);
  };

  Component.prototype.unregisterElements = function () {
    var _this = this;

    this.registeredElements.forEach(function (element) {
      _this.unregisterElement(element);
    });
  };

  Component.prototype.unregisterElement = function (element) {
    var registeredElementIndex = this.registeredElements.findIndex(function (el) {
      return el.target === element.target && el.event === element.event;
    });

    if (registeredElementIndex > -1) {
      element.target.removeEventListener(element.event, this.elementListener);
      this.registeredElements.splice(registeredElementIndex, 1);
    } else {
      console.error('Warning! Could not remove element:' + ' ' + (element.target + " with event: " + element.event + "."));
    }
  };

  Component.prototype.triggerEvent = function (eventName, detail, objectEventOnly) {
    var _this = this;

    if (detail === void 0) {
      detail = {};
    }

    if (objectEventOnly === void 0) {
      objectEventOnly = false;
    }

    var eventNameObject = eventName.split('.').reduce(function (acc, current, index) {
      if (index === 0) {
        return current;
      }

      return acc + current.charAt(0).toUpperCase() + current.slice(1);
    });
    var eventNameAlias = "on" + eventNameObject.charAt(0).toUpperCase() + eventNameObject.slice(1);
    var props = this.getProps();
    this.eventHandlers.forEach(function (scope) {
      if (typeof scope[eventNameObject] === 'function') {
        scope[eventNameObject].apply(_this, [detail]);
      }

      if (typeof scope[eventNameAlias] === 'function') {
        props[eventNameAlias].apply(_this, [detail]);
      }
    });

    if (objectEventOnly) {
      return;
    }

    var element = this.getElement();

    if (element) {
      Util.Dispatch.elementEvent(element, eventName, this.name, detail);
    } else {
      Util.Dispatch.winDocEvent(eventName, this.name, detail);
    }
  };

  Component.prototype.preventClosable = function () {
    return false;
  };

  Component.prototype.destroy = function () {
    this.unregisterElements();
  };

  Component.prototype.onElementEvent = function (event) {};

  Component.prototype.setEventsHandler = function () {
    var props = this.getProps();
    var scope = Object.keys(props).reduce(function (cur, key) {
      if (typeof props[key] === 'function') {
        cur[key] = props[key];
      }

      return cur;
    }, {});

    if (Object.keys(scope).length > 0) {
      this.eventHandlers.push(scope);
    }
  };

  Component.prototype.onBeforeElementEvent = function (event) {
    if (this.preventClosable()) {
      return;
    }

    this.onElementEvent(event);
  };

  return Component;
}();

var Tab = function (_super) {
  __extends(Tab, _super);

  function Tab(props) {
    var _this = _super.call(this, 'tab', {}, props) || this;

    _this.tabSelector = 'tab';
    _this.tabItemSelector = 'tab-item';
    _this.tabContentSelector = 'tab-pane';
    _this.onAnimation = false;

    _this.registerElement({
      target: _this.getElement(),
      event: Util.Event.CLICK
    });

    return _this;
  }

  Tab.attachDOM = function () {
    Util.Observer.subscribe({
      componentClass: 'tabs',
      onAdded: function onAdded(element, create) {
        create(new Tab({
          element: element
        }));
      },
      onRemoved: function onRemoved(element, remove) {
        remove('Tab', element);
      }
    });
  };

  Tab.prototype.onElementEvent = function (event) {
    var target = event.target;

    if (!target) {
      return;
    }

    var dataToggleAttr = target.getAttribute('data-toggle');

    if (dataToggleAttr) {
      var id = target.getAttribute('href') || target.getAttribute('data-target');

      if (!id) {
        return;
      }

      event.preventDefault();
      this.show(target);
    }
  };

  Tab.prototype.show = function (tabLink) {
    var _this = this;

    if (this.onAnimation) {
      return false;
    }

    var tabItem = Util.Selector.closest(tabLink, "." + this.tabItemSelector);

    if (!tabItem || tabItem.classList.contains('active')) {
      return false;
    }

    var id = tabLink.getAttribute('href') || tabLink.getAttribute('data-target');

    if (!id) {
      return false;
    }

    var tabContainer = this.getElement();
    var tabItems = Array.from(tabContainer.querySelectorAll('.tab-item') || []);
    tabItems.forEach(function (tab) {
      if (tab.classList.contains('active')) {
        tab.classList.remove('active');
      }

      var link = tab.querySelector('.tab-link');

      if (link) {
        link.setAttribute('aria-selected', 'false');
      }
    });
    this.onAnimation = true;
    tabItem.classList.add('active');
    tabLink.setAttribute('aria-selected', 'true');
    var tabContent = document.querySelector(id);

    if (!tabContent) {
      return false;
    }

    var tabContentParent = tabContent.parentNode;

    if (!tabContentParent) {
      return false;
    }

    var tabContents = Array.from(tabContentParent.querySelectorAll("." + this.tabContentSelector) || []);
    var prevTabItem = tabContainer.querySelector('.tab-item.active');
    tabContents.forEach(function (tab) {
      if (tab.classList.contains('active')) {
        tab.classList.remove('active');
      }
    });
    tabContent.classList.add('showing');
    this.triggerEvent(Util.Event.SHOW, this.getTabEvent(tabLink));

    if (prevTabItem) {
      this.triggerEvent(Util.Event.HIDE, this.getTabEvent(prevTabItem));
    }

    var onShowed = function onShowed() {
      tabContent.classList.remove('animate');
      tabContent.classList.add('active');
      tabContent.classList.remove('showing');

      _this.triggerEvent(Util.Event.SHOWN, _this.getTabEvent(tabLink));

      if (prevTabItem) {
        _this.triggerEvent(Util.Event.HIDDEN, _this.getTabEvent(prevTabItem));
      }

      _this.onAnimation = false;
      tabContent.removeEventListener(Util.Event.TRANSITION_END, onShowed);
    };

    (function () {
      return __awaiter(_this, void 0, void 0, function () {
        return __generator(this, function (_a) {
          switch (_a.label) {
            case 0:
              return [4, Util.sleep(20)];

            case 1:
              _a.sent();

              tabContent.addEventListener(Util.Event.TRANSITION_END, onShowed);
              tabContent.classList.add('animate');
              return [2];
          }
        });
      });
    })();

    return true;
  };

  Tab.prototype.getTabEvent = function (tabLink) {
    return {
      id: tabLink.getAttribute('href') || tabLink.getAttribute('data-target'),
      target: tabLink
    };
  };

  Tab.prototype.destroy = function () {
    this.registerElement({
      target: this.getElement(),
      event: Util.Event.CLICK
    });
  };

  return Tab;
}(Component);
Tab.attachDOM();

module.exports = Tab;
//# sourceMappingURL=tab.js.map
