# [Phonon](https://phonon-framework.github.io)

> Phonon is a responsive front-end framework with a focus on simplicity and flexibility

[![TypeScript](https://badges.frapsoft.com/typescript/code/typescript.svg?v=101)](https://github.com/ellerbrock/typescript-badges/)
[![Dependency Status](https://david-dm.org/phonon-framework/phonon.svg)](https://david-dm.org/phonon-framework/phonon)
[![devDependencies Status](https://david-dm.org/phonon-framework/phonon/dev-status.svg)](https://david-dm.org/phonon-framework/phonon)
[![Build Status](https://img.shields.io/travis/phonon-framework/phonon.svg?style=flat-square)](https://travis-ci.org/phonon-framework/phonon.svg?branch=master)
[![Codecov](https://codecov.io/gh/phonon-framework/phonon/branch/master/graph/badge.svg)](https://codecov.io/gh/phonon-framework/phonon)
[![npm](https://img.shields.io/npm/v/phonon.svg?style=flat-square)]()
[![license](https://img.shields.io/github/license/quark-dev/phonon.svg?style=flat-square)]()

Starting with v2, Phonon is written in [Sass](https://sass-lang.com) and [TypeScript](https://www.typescriptlang.org).


## Installation

You have the following options to install Phonon v2:

- Install with [npm](https://www.npmjs.com/package/phonon) `npm install phonon@2.0.0-alpha.1`
- Install with [Yarn](https://yarnpkg.com/en/package/phonon) `yarn add phonon@2.0.0-alpha.1`
- Install with [Composer](https://packagist.org/packages/phonon-framework/phonon) `composer require phonon-framework/phonon`

- Deliver CDN cached version of Phonon compiled [CSS](https://unpkg.com/phonon@2.0.0-alpha.1/dist/css/) and [JavaScript](https://unpkg.com/phonon@2.0.0-alpha.1/dist/js/) to your project by using [UNPKG](https://unpkg.com/phonon@2.0.0-alpha.1/)
- Clone the repository to get all source files and compile Phonon by using the scripts: `git clone https://github.com/phonon-framework/phonon.git`
- Download the [latest release](https://github.com/phonon-framework/phonon/releases) and use compiled CSS and JavaScript files available in the dist folder


## Framework compatibility

Phonon uses a DOM [MutationObserver](https://developer.mozilla.org/en-US/docs/Web/API/MutationObserver) which enables to react to DOM changes.
This explains the ease of use of Phonon with Angular, React and Vue, etc.
Please see [Examples](https://github.com/phonon-framework/phonon/tree/master#examples) for more information.


## Examples

We have several examples to share with you to show you how easy it is to integrate Phonon for your project.
All examples are available in `examples/`.

- [Phonon and React](https://github.com/phonon-framework/phonon/tree/master/examples/react-example)
- [Phonon and Vue](https://github.com/phonon-framework/phonon/tree/master/examples/vue-example)
- [Phonon and Webpack](https://github.com/phonon-framework/phonon/tree/master/examples/webpack-example)


## Versioning

Phonon Framework is maintained under the [Semantic Versioning guidelines](http://semver.org/).


## Contributing

**Don't hesitate** to contribute to this project! The Phonon team is completely open to any suggestions or improvements. Please, go to the [issues page](https://github.com/phonon-framework/phonon/issues) to open an issue.
Moreover, if your pull request contains JavaScript patches or features, you must include relevant unit tests.
Editor preferences are available in the [editor config](https://github.com/phonon-framework/phonon/blob/master/.editorconfig) for easy use in common text editors.


## Copyright and license

Code released under the [MIT License](https://github.com/phonon-framework/phonon/blob/master/LICENSE).
