﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Linq;

namespace EntityFrameworkCore.SqlServer.SimpleBulks.Extensions;

public static class IListExtensions
{
    public static DataTable ToDataTable<T>(this IEnumerable<T> data, IEnumerable<string> propertyNames, bool addIndexNumberColumn = false)
    {
        var properties = TypeDescriptor.GetProperties(typeof(T));

        var updatablePros = new List<PropertyDescriptor>();
        foreach (PropertyDescriptor prop in properties)
        {
            if (propertyNames.Contains(prop.Name))
            {
                updatablePros.Add(prop);
            }
        }

        var table = new DataTable() { MinimumCapacity = data.Count() };
        foreach (PropertyDescriptor prop in updatablePros)
        {
            table.Columns.Add(prop.Name, Nullable.GetUnderlyingType(prop.PropertyType) ?? prop.PropertyType);
        }

        if (addIndexNumberColumn)
        {
            table.Columns.Add(Constants.AutoGeneratedIndexNumberColumn, typeof(long));
        }

        long idx = 0;

        foreach (T item in data)
        {
            var row = table.NewRow();
            foreach (PropertyDescriptor prop in updatablePros)
            {
                var value = prop.GetValue(item) ?? DBNull.Value;
                row[prop.Name] = value;
            }

            if (addIndexNumberColumn)
            {
                row[Constants.AutoGeneratedIndexNumberColumn] = idx;
            }

            table.Rows.Add(row);

            idx++;
        }
        return table;
    }
}
