export function buildMenu(app: any, funcs: any) {
  const template: any[] = [
    {
      label: "File",
      submenu: [
        {
          label: "Open...",
          accelerator: "CmdOrCtrl+O",
          click() {
            funcs.open();
          },
        },
        {
          label: "New...",
          accelerator: "CmdOrCtrl+N",
          click() {
            funcs.newFile();
          },
        },
        {
          label: "Save...",
          accelerator: "CmdOrCtrl+S",
          click() {
            funcs.saveFileSignal();
          },
        },
        {
          label: "Debug...",
          accelerator: "CmdOrCtrl+Alt+I",
          click() {
            funcs.debug();
          },
        },
        {
          label: "Reload...",
          accelerator: "CmdOrCtrl+R",
          click() {
            funcs.reload();
          },
        },
      ],
    },
    {
      label: "Edit",
      submenu: [
        {role: "undo"},
        {role: "redo"},
        {type: "separator"},
        {role: "cut"},
        {role: "copy"},
        {role: "paste"},
        {role: "pasteandmatchstyle"},
        {role: "delete"},
        {role: "selectall"},
      ],
    },
    {
      label: "View",
      submenu: [
        {role: "reload"},
        {role: "forcereload"},
        {role: "toggledevtools"},
        {type: "separator"},
        {role: "resetzoom"},
        {role: "zoomin"},
        {role: "zoomout"},
        {type: "separator"},
        {role: "togglefullscreen"},
      ],
    },
    {
      role: "window",
      submenu: [
        {role: "minimize"},
        {role: "close"},
      ],
    },
    {
      role: "help",
      submenu: [
        {
          label: "More",
          click() {
            funcs.openAboutPage();
          },
        },
      ],
    },
  ];

  if (process.platform === "darwin") {
    template.unshift({
      label: app.getName(),
      submenu: [
        {role: "about"},
        {type: "separator"},
        {role: "hide"},
        {role: "hideothers"},
        {role: "unhide"},
        {type: "separator"},
        {role: "quit"},
      ],
    });

    // Edit menu
    (template[1].submenu as any[]).push(
      {type: "separator"},
      {
        label: "Speech",
        submenu: [
          {role: "startspeaking"},
          {role: "stopspeaking"},
        ],
      },
    );

    // Window menu
    template[3].submenu = [
      {role: "close"},
      {role: "minimize"},
      {role: "zoom"},
      {type: "separator"},
      {role: "front"},
    ];
  }

  return template;
}
