# Contributing, Developer Guide, and Codegen Overview

This crate is generated by the Rust binary in `./codegen`. The script
`codegen_n_build.sh` takes care of the code-generation process. Generally
speaking, most changes to the crate should be done in the template files there
instead in the main crate.

## Repository Structure

- `codegen/` : Rust helper project to generate the actual crate.
- `examples/`: Examples for the generated code following the Cargo convention
               for examples
- `external/`: Independent consumers of the generated code to perform various
               checks.
- `src/`     : Generated source. The actual crate / library.

- `check_crate_size.sh`:  Helper to check the size of the packaged crate (raw
                          source size)
- `./codegen_n_build.sh`: Helper to execute the tool from `codegen/`.

## Build Prerequisites

Because the examples use `minifb` as dependency, on Linux the package `libxkbcommon-dev` is
required.

## Contributing Tips

For every pull request, please add a before/after screenshot of the effective
font rendering changes. For example, you can screenshot the output from
`$ cargo run --example show_chars_in_window --features all`
