#ifndef VIRTUAL_KEYS_H
#define VIRTUAL_KEYS_H

#include <stdint.h>

typedef enum virtual_keycode
{
	VK_NONE,
	VK_BACKSPACE,
	VK_TAB,
	VK_ENTER,
	VK_LSHIFT,
	VK_RSHIFT,
	VK_LCTRL,
	VK_RCTRL,
	VK_LALT,
	VK_RALT,
	VK_SPACE,
	VK_CAPS_LOCK,

	VK_LEFT,
	VK_UP,
	VK_RIGHT,
	VK_DOWN,

	VK_A,
	VK_B,
	VK_C,
	VK_D,
	VK_E,
	VK_F,
	VK_G,
	VK_H,
	VK_I,
	VK_J,
	VK_K,
	VK_L,
	VK_M,
	VK_N,
	VK_O,
	VK_P,
	VK_Q,
	VK_R,
	VK_S,
	VK_T,
	VK_U,
	VK_V,
	VK_W,
	VK_X,
	VK_Y,
	VK_Z,

	VK_NUMLOCK,
	VK_NUMPAD_0,
	VK_NUMPAD_1,
	VK_NUMPAD_2,
	VK_NUMPAD_3,
	VK_NUMPAD_4,
	VK_NUMPAD_5,
	VK_NUMPAD_6,
	VK_NUMPAD_7,
	VK_NUMPAD_8,
	VK_NUMPAD_9,
	VK_NUMPAD_DIVIDE,
	VK_NUMPAD_MULIPLY,
	VK_NUMPAD_MINUS,
	VK_NUMPAD_PLUS,
	VK_NUMPAD_ENTER,
	VK_NUMPAD_PERIOD,

	VK_BACKTICK,
	VK_0,
	VK_1,
	VK_2,
	VK_3,
	VK_4,
	VK_5,
	VK_6,
	VK_7,
	VK_8,
	VK_9,
	VK_MINUS,
	VK_EQUALS,

	VK_COMMA,
	VK_PERIOD,
	VK_SLASH,
	VK_SEMICOLON,
	VK_APOSTROPHE,
	VK_LSQR_BRACKET,
	VK_RSQR_BRACKET,
	VK_BACKSLASH,
	VK_LMETA, //win key mostly
	VK_RMETA, //win key mostly
	VK_MENU, //the least useful key on the keyboard

	VK_PRINT_SCREEN,
	VK_SCROLL_LOCK,
	VK_PAUSE,

	VK_INSERT,
	VK_HOME,
	VK_PAGE_UP,
	VK_DELETE,
	VK_END,
	VK_PAGE_DOWN,

	VK_ESCAPE,
	VK_F1,
	VK_F2,
	VK_F3,
	VK_F4,
	VK_F5,
	VK_F6,
	VK_F7,
	VK_F8,
	VK_F9,
	VK_F10,
	VK_F11,
	VK_F12,

	VK_MEDIA_PREVIOUS,
	VK_MEDIA_NEXT,
	VK_MEDIA_PLAY,
	VK_MEDIA_STOP,
	VK_VOLUME_UP,
	VK_VOLUME_DOWN,
	VK_MUTE,

	VK_CALC,

	VK_WWW,
	VK_WWW_SEARCH,
	VK_WWW_FWD,
	VK_WWW_BACK,
	VK_WWW_FAV,
	VK_WWW_REF,
	VK_WWW_STOP,

	VK_POWER,
	VK_SLEEP,
	VK_WAKE,
	VK_MYCOMP,
	VK_MAIL,
	VK_APPS,
	VK_MEDIA_SELECT,
	NUM_VIRTUAL_KEYS
} virtual_keycode;

typedef uint32_t key_type;

#endif