#include <sys/syscalls.h>

char vk_to_ascii[NUM_VIRTUAL_KEYS * 2] = { 
	'\0','\b','\t','\n','\0','\0','\0','\0','\0','\0',' ',
	'\0','\0','\0','\0','\0','a','b','c','d','e','f','g',
	'h','i','j','k','l','m','n','o','p','q','r','s','t',
	'u','v','w','x','y','z','\0','0','1','2','3','4','5',
	'6','7','8','9','/','*','-','+','\n','.','`','0','1',
	'2','3','4','5','6','7','8','9','-','=',',','.','/',
	';','\'','[',']','\\','\0','\0','\0','\0','\0','\0',
	'\0','\0','\0','\0','\0','\0','\x1b','\0','\0','\0',
	'\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0',
	'\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0',
	'\0','\0','\0','\0','\0','\0','\0','\0','\0',
	//shifted symbols
	'\0','\b','\t','\n','\0','\0','\0','\0','\0','\0',' ',
	'\0','\0','\0','\0','\0','A','B','C','D','E','F','G',
	'H','I','J','K','L','M','N','O','P','Q','R','S','T',
	'U','V','W','X','Y','Z','\0','0','1','2','3','4','5',
	'6','7','8','9','/','*','-','+','\n','.','~',')','!',
	'@','#','$','%','^','&','*','(','_','+','<','>','?',
	':','\"','{','}','|','\0','\0','\0','\0','\0','\0',
	'\0','\0','\0','\0','\0','\0','\x1b','\0','\0','\0',
	'\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0',
	'\0','\0','\0','\0','\0','\0','\0','\0','\0','\0','\0',
	'\0','\0','\0','\0','\0','\0','\0','\0','\0' };


char get_ascii_from_vk(key_type k)
{
	if (k < NUM_VIRTUAL_KEYS && get_keystate(k))
	{
		if (get_keystate(VK_LSHIFT) || get_keystate(VK_RSHIFT))
		{
			k += NUM_VIRTUAL_KEYS;
		}
		return vk_to_ascii[k];
	}

	return '\0';
}