# Contributing to JSD/OS

Contributions are welcome and encouraged! If you would like to add something to JSD/OS please feel free to submit a PR. 

### Contributions that would be especially appreciated:
- New hardware drivers (Display & Storage particularily, no hardware is too old)
- New filesystem drivers (ext2, ext3, etc.)
- Porting user mode libraries
- New user mode programs & utilities

### Some guidelines:
- All contributions should conform to the license of the main JSD/OS project unless otherwise specified
- New code is preferably written in C++, as of right now JSD/OS conforms to the C++17 standard
- Plain C is used and permitted but the kernel API is geared towards C++
- Please try to implement any hardware specific functionality as a module in the /drivers directory
- Please avoid Racist/Homophobic/offensive language in comments (general swearing and FBombs are permitted)
- Please use English language names and comments and avoid non-ASCII characters
- Please use tabs not spaces and try to use Allman formatting if possible

