# Retreat planning & ideas · Yves

## Some ideas

### Tooling & Technologies

- A small and light CLI to start building websites/apps
    - Think about the structure, predefined structure initialized using `git submodules`
      (or `git subtree`)
    - Starter Kit:
      - UI
      - DataLayer (Firebase)
      - Backend init script (Firebase)
    - Authentication, users & groups
    - Separated core and app source using GIT
    - Admin panel (start with an expressive firebase data model)
- Static page generator using a schema to build webcomponents.
  *(eg: HugoJS, Jekyll, Hexo, Brunch.io)*
  - CLI
  - Challenging aspects:
    - Template and theming
    - Architecture:
      - Deep links and routing
      - Publishing pipeline
      - Data pipeline & editing


- Data plane visualization & debugging

### Components & Applications

- Components:
  - An UI Toolbox with basic elements (PWA starter kit, litElement)
  - Themes and layout (flex?)
  - Navigation (route and contextual parameters)
  - A "basic" high performance grid
    - Feature enriched
    - CRUD grid
    - Virtual scroller
    - and more...

- Applications:
  - [AnnaCompta] A visual accounting application
  - [MemoMe] An application to save personal information (lists?): notes, todos, wishes, places and dates
  - A blog for posts and events (reusable)
  - A selling platform (reusable)

> The blog should have different faces and shapes.
> All applications should be multi users.
> Everything should be linked to Firebase/Firestore.

## Some objectives
- [x] Update the terminal, VIM and fonts (IBM plex)
- [ ] Change install script to use `git clone` and symbolic links when installing
- [ ] Synopsis of the Webcomponents conference (before Friday 04.02.2019)
- [ ] Update PAGL website
- [ ] Update LinkedIn
- [ ] Create the starter kit
- [ ] Create the UI Toolbox
- [ ] Link to authentication
- [ ] Link the UI Toolbox to firestore
- [ ] Move my blog to my own tech stack
- [ ] Create something foonky in 3D (processing, threeJS, webgl)
- [ ] Let's play (the game challenge)
- [ ] Present to some (15-30min)

## Research & read
- TypeScript, CoffeeScript, ClojureScript with litElement
- Immutability with litElement
- Haskell, Lisp, Clojure
- Processing, ThreeJS
- Holograms

## Keep in mind
- Poliscope data-pipeline
- StackBlitz, Github Pages, GitBook, ObservableHQ
- Tablet compatible

## Planning (WIP)
- Sync with Olivier
- Take one thing
- Do it
- Rince and repeat
