# Future retreat, where to resume · Olivier

On our way to _Theater Decision Making_, [Data glyphs](https://github.com/olange/noia) and [webcomponents.store](https://webcomponents.store)…

* [Learning Service Workers](https://github.com/olange/learning-service-workers/) research track
  * [Experiment 06 · Re-route fetch of data to worker](../issues/8) streaming data in & out a worker
  * [Learning Service Workers › Service Workers: an Introduction](https://developers.google.com/web/fundamentals/primers/service-workers/) GWF, Matt Gaunt
  * [Learning Service Workers › The Year of the Streams](https://jakearchibald.com/2016/streams-ftw/) Jake Archibald
  * [Declarative Router](https://jakearchibald.com/2019/service-worker-declarative-router/) Jake Archibald, 07.01.2019
  * [Learning Service Workers › Service Workies](https://serviceworkies.com/) mastery game
* [Learning Streams and Observables](https://github.com/olange/learning-streams/) research track
  * [Web streams that work across web workers and ‹iframe›s](https://github.com/MattiasBuelens/remote-web-streams/) Mattias Buelens
  * [Transferable Streams Explained](https://github.com/whatwg/streams/blob/master/transferable-streams-explainer.md) WhatWG, Adam Rice
  * [WebCodecs Explainer](https://github.com/WICG/web-codecs/blob/master/explainer.md) WICG, Peter Thatcher et al.
  * [thi.ng/rstream](https://github.com/thi-ng/umbrella/tree/master/packages/rstream) _Lightweight reactive multi-tap streams and transducer based transformation pipeline constructs, written in TypeScript_
  * [Reactive.howi](https://reactive.how/) online resource
* Databases & in-browser query engine
  * [MDN › IndexedDB API](https://developer.mozilla.org/en-US/docs/Web/API/IndexedDB_API)
  * [LevelUp](https://github.com/Level/levelup) _A wrapper for abstract-leveldown compliant stores, for Node.js and browsers_
  * [thi.ng/rstream-query](https://github.com/thi-ng/umbrella/tree/master/packages/rstream-query) _Triple store & reactive query engine with declarative query specs; push-based, auto-updating query results, which are changing each time upstream transformations & filters have been triggered._
  * [DataScript](https://github.com/tonsky/datascript) _Immutable database and Datalog query engine for Clojure, ClojureScript and JS_
  * [Google Cloud Firestore](https://firebase.google.com/docs/firestore/) _Flexible, scalable NoSQL cloud database to store and sync data for client- and server-side development_
  * [Apollo Client](https://www.apollographql.com/) and [Lit-Apollo](https://github.com/apollo-elements/apollo-elements)
* Layout
  * [Graph Layouts with Neo4j Graph Algorithms and Machine Learning](https://ptat.ch/2RqwSpj)
  * [Dagre.js](https://github.com/dagrejs) and [Graphlib](https://github.com/dagrejs/graphlib)
  * [Cytoscape](https://cytoscape.org/)
  * [Cola.js](https://ialab.it.monash.edu/webcola/)
  * [Viz.js](https://github.com/mdaines/viz.js/)
  * [Hamiltonian Graph Builder](http://bl.ocks.org/christophermanning/1703449?lcfCode=[10]100&animationSpeed=1&lockVertices=0) Christopher Manning
  * [Spherical Force-Directed Layout](http://bl.ocks.org/christophermanning/4208494) Christopher Manning
  * [Mitsuba Instant Meshes](https://www.foundry.com/%20insights/vr-ar-mr/mitsuba-renderer-instant-meshes) Wenzel Jakob
* Envisioning information
  * [Apache ECharts](https://echarts.apache.org/en/index.html)
  * [D3.js › Examples](https://github.com/d3/d3/wiki/Gallery)
  * [Visual Group Theory](http://web.bentley.edu/empl/c/ncarter/vgt/) Nathan Carter
  * [Hamiltonian Graphs](https://www.google.com/search?q=hamiltonian+graphs)
* Databases
  * [Dgraph](https://dgraph.io/)
    * [Blog › Why Google needed a graph serving system?](https://blog.dgraph.io/post/why-google-needed-graph-serving-system/)
    * [Blog › Badger over RocksDB in Dgraph](https://blog.dgraph.io/post/badger-over-rocksdb-in-dgraph/)
* Knowledge documentation
  * [Kumu](https://kumu.io/)
  * [ObservableHQ](https://beta.observablehq.com/)

## Company

* [Google Cloud Certifications › QwikLabs](https://cloud.google.com/certification/)
* [Google re:rework](https://rework.withgoogle.com)
* Google Cloud Newsletters
* [Better User Stories](https://www.betteruserstories.com/courses/better-user-stories/videos) de Mike Cohn
* L3C

## Research Projects

* [Dglyphs](https://github.com/olange/noia)
* Poliscope Data pipes › EDN ⟷ Web Components (publishing pipeline & engine pour Yves!?)
* Neo4j 3.5 & Sync with Firestore
* Scan, classify & organize

## Alternative tracks

* Datasets to work with every type of database
* Have some fun
  * [Vuo](https://vuo.org)
  * [Observable](https://beta.observablehq.com/)
* Visualization worlds of their own
  * [thi.ng](http://thi.ng/) Karsten Schmidt
  * [D3.js](https://d3js.org)
* Languages
  * Deepening ES6
    * [Exploring JS](http://exploringjs.com/impatient-js/index.html) Axel Rauschmeyer
  * TypeScript
    * [The TypeScript Tax](https://medium.com/javascript-scene/the-typescript-tax-132ff4cb175b) Eric Elliott, 23.01.2019
    * [Mocking is a Code Smell](https://medium.com/javascript-scene/mocking-is-a-code-smell-944a70c90a6a) Eric Elliott, 20.10.2017
  * Ramda
    * [Ramda.js](https://ramdajs.com) _Official website; lookout for flow description and composition_
  * ClojureScript
    * [ClojureScript.org](https://clojurescript.org/)
