import { NextResponse } from "next/server";
import type { NextRequest } from "next/server";
import { cookies } from "next/headers";

export async function middleware(request: NextRequest) {
    const cookieStore = await cookies();
    const username = cookieStore.has("username");

    if (!username) {
        return NextResponse.redirect(new URL("/", request.url));
    }
    return null;
}

export const config = {
    matcher: ["/home", "/settings"],
};
