## 🌍Language Versions / 语言版本

🇺🇸[English](README.md) 🇨🇳[中文](README_CN.md)

## 🚀 **astroVerse-i18n**: An astro Theme for Global Visual Storytelling

astroVerse-i18n is an enhanced version of the original astroVerse theme, now with multilingual support, tailored for captivating photo-text storytelling on a global scale.

This theme seamlessly integrates visuals and written content, empowering creators to deliver compelling narratives with high-impact imagery in multiple languages. Whether you're reaching audiences in English, Chinese, or other languages, astroVerse-i18n provides the tools to create immersive and influential digital experiences that resonate worldwide.

Ideal for bloggers and content creators who wish to make their stories stand out through the fusion of striking visuals and engaging prose, astroVerse-i18n helps you connect with a diverse audience across the globe.

<img src="public/screenshot.webp" alt="astroVerse-i18n" />

## 💯 Lighthouse 得分

<p align="center">
  <a href="https://pagespeed.web.dev/analysis?url=https%3A%2F%2Fverse-i18n.vercel.app%2F">
    <img width="510" alt="astroVerse-i18n Lighthouse 得分" src="public/astroverse-i18n-lighthouse-score.svg">
  <a>
</p>

## 🎉 Features

- ✅ Powered by astro
- ✅ Multilingual Support
- ✅ Development with first CSS and Preline UI
- ✅ Fully Responsive Design
- ✅ Perfect 100/100 Lighthouse Performance Score
- ✅ SEO Optimized
- ✅ Inbuilt Site Search
- ✅ Sitemap and RSS Feed Support
- ✅  & MDX Ready
- ✅ Tag Statistics and Last Modified Time Display
- ✅ Optimized Image Handling
- ✅ Automatic Dark Mode Switching
- ✅ Pagination for Easy Navigation
- ✅ Code formatted with Prettier in one click

## 🎡 Live demo

Experience [**astroVerse-i18n**](https://verse-i18n.vercel.app) in action.

## 🌆 Showcase

Share your project built with astroVerse-i18n! Open an issue titled "Showcase Submission" with your project's details to be featured in our Showcase.

- [**iPenBox**](https://ipenbox.com/en/)

## 💻 Running Locally

**Recommended extensions for VSCode:**

- [TailwindCSS IntelliSense](https://marketplace.visualstudio.com/items?itemName=bradlc.vscode-tailwindcss).
- [Preline UI](https://preline.co/).
- [astro](https://marketplace.visualstudio.com/items?itemName=astro-build.astro-vscode).

1. Fork or use this [template](https://github.com/inotelab/astroverse-i18n)

2. Install dependencies:

```bash
pnpm install
```

3. Run the development server:

```bash
pnpm run dev
```

## 📄 Adding a post

Adding a post is as simple as adding a .md or .mdx file to the blog folder at the path **src/content/posts**.

## 🧞 Commands

All commands are run from the root of the project, from a terminal:

| Command                | Action                                       |
| :--------------------- | :------------------------------------------- |
| `pnpm install`         | Installs dependencies                        |
| `pnpm run dev`         | Starts local dev server at `localhost:4321`  |
| `pnpm run build`       | Build your production site to `./dist/`      |
| `pnpm run preview`     | Preview your build locally, before deploying |
| `pnpm run format`      | Code formatter using prettier                |
| `npx @astrojs/upgrade` | To upgrade                                   |

## Deployment

Click the button below to start deploying your project on Vercel:

[![Deploy to Vercel](https://vercel.com/button)](https://vercel.com/import/project?template=https://github.com/inotelab/astroverse-i18n)

## ✨ Join and Contribute

Your contributions make astroVerse-i18n better! Whether it's through code, design, bug reports, or feature ideas, we value your input. Check our Issues or submit a Pull Request to get started. Together, let's enhance astroVerse-i18n!
