"""
Django settings for med_kg project.

Generated by 'django-admin startproject' using Django 2.0.3.

For more information on this file, see
https://docs.djangoproject.com/en/2.0/topics/settings/

For the full list of settings and their values, see
https://docs.djangoproject.com/en/2.0/ref/settings/
"""


# 注: 此模块可以通过 from django.conf import settings 导入和使用
import os

# Build paths inside the project like this: os.path.join(BASE_DIR, ...)
# 用于绑定当前项目的绝对路径(动态计算出来的), 所有文件都可以依懒此路径
BASE_DIR = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))


# Quick-start development settings - unsuitable for production
# See https://docs.djangoproject.com/en/2.0/howto/deployment/checklist/

# SECURITY WARNING: keep the secret key used in production secret!
# 安全码，Django生成项目的时候自动生成
SECRET_KEY = '$k-!nba#s7q#1b!q7xyzc&3sb*)_e^n4-zbwwomc%-vu6cj^!7'

# SECURITY WARNING: don't run with debug turned on in production!
'''
DEBUG:
用于配置Django项目的启用模式, 取值:
True 开发环境中使用。 调试模式(用于开发中)
False 当前项目运行在生产环境中(不启用调试)
'''
DEBUG = True

'''
ALLOWED_HOSTS:
1.设置允许访问到本项目的网络地址列表,取值:
    [] 空列表,表示只有请求头中host为127.0.0.1, localhost能访问本项目
    [’*’]，表示任何请求头的host都能访问到当前项目
    [‘192.168.1.3’, ‘127.0.0.1’] 表示只有当前两个host头的值能访问当前项目

2.如果要在局域网其它主机也能访问此主机,启动方式应使用如下模式:
    python3 manage.py runserver 0.0.0.0:5000 # 指定网络设备所有主机都可以通过5000端口访问(需加ALLOWED_HOSTS = ['*'])
'''
ALLOWED_HOSTS = []


# Application definition
# 自己创建的应用，需要在这里添加注册
INSTALLED_APPS = [
    'django.contrib.admin',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.messages',
    'django.contrib.staticfiles',
]

# 用于注册中间件
MIDDLEWARE = [
    'django.middleware.security.SecurityMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django.middleware.clickjacking.XFrameOptionsMiddleware',
]

'''
用于配置根级 url 配置 ‘mysite1.urls’
如:
    ROOT_URLCONF = 'mysite1.urls'
'''
ROOT_URLCONF = 'med_kg.urls'

# 用于指定模板的配置信息
TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'DIRS': [BASE_DIR+"/templates",],  # html路径
        'APP_DIRS': True,
        'OPTIONS': {
            'context_processors': [
                'django.template.context_processors.debug',
                'django.template.context_processors.request',
                'django.contrib.auth.context_processors.auth',
                'django.contrib.messages.context_processors.messages',
            ],
        },
    },
]

WSGI_APPLICATION = 'med_kg.wsgi.application'


# Database
# https://docs.djangoproject.com/en/2.0/ref/settings/#databases
# 用于指定数据库的配置信息
DATABASES = {
    'default': {
        'ENGINE': 'django.db.backends.sqlite3',
        'NAME': os.path.join(BASE_DIR, 'db.sqlite3'),
    }
}


# Password validation
# https://docs.djangoproject.com/en/2.0/ref/settings/#auth-password-validators

AUTH_PASSWORD_VALIDATORS = [
    {
        'NAME': 'django.contrib.auth.password_validation.UserAttributeSimilarityValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.MinimumLengthValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.CommonPasswordValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.NumericPasswordValidator',
    },
]


# Internationalization
# https://docs.djangoproject.com/en/2.0/topics/i18n/

'''
用于指定语言配置
取值:
    英文 : "en-us"
    中文 : "zh-Hans"
'''
LANGUAGE_CODE = 'en-us'

'''
用于指定当前服务器端的时区
取值:
    世界标准时间: "UTC"
    中国时区 : "Asia/Shanghai"
'''
TIME_ZONE = 'UTC'

USE_I18N = True

USE_L10N = True

USE_TZ = True


# Static files (CSS, JavaScript, Images)
# https://docs.djangoproject.com/en/2.0/howto/static-files/

# 静态文件地址
STATIC_URL = '/static/'
#设置样式目录
STATICFILES_DIRS = [
    os.path.join(BASE_DIR, "static"),
]