Fido: A PowerShell script to download Windows and UEFI Shell ISOs
=================================================================

[![Licence](https://img.shields.io/badge/license-GPLv3-blue.svg?style=flat-square)](https://www.gnu.org/licenses/gpl-3.0.en.html)
[![Github stats](https://img.shields.io/github/downloads/pbatard/Fido/total.svg?style=flat-square)](https://github.com/pbatard/Fido/releases)

Description
-----------

Fido is a PowerShell script that is primarily designed to be used in [Rufus](https://github.com/pbatard/rufus), but that
can also be used in standalone fashion, and whose purpose is to automate access to the official Microsoft Windows retail
ISO download links as well as provide convenient access to [bootable UEFI Shell images](https://github.com/pbatard/UEFI-Shell).

This script exists because, while Microsoft does make retail ISO download links freely and publicly available (at least
for Windows 8 through Windows 11), up until recent releases, most of these links were only available after forcing users
to jump through a lot of unwarranted hoops that created an exceedingly counterproductive, if not downright unfriendly,
consumer experience, that greatly detracted from what people really want (direct access to ISO downloads).

As to the reason one might want to download Windows __retail__ ISOs, as opposed to the ISOs that are generated by
Microsoft's own Media Creation Tool (MCT), this is because using official retail ISOs is currently the only way to
assert with absolute certainty that the OS content has not been altered. Indeed, because there only exists a single
master for each of them, Microsoft retail ISOs are the only ones you can obtain an official SHA-1 for (from MSDN, if you
have access to it, or from sites [such as this one](https://msdn.rg-adguard.net/public.php)) allowing you to be 100%
sure that the image you are using has not been corrupted and is safe to use.

This, in turn, offers assurance that the content __YOU__ are using to install your OS, which it is indeed critical to
validate beforehand if you have the slightest concern about security, does match, bit for bit, the one that Microsoft
released.

On the other hand, regardless of the manner in which Microsoft's Media Creation Tool produces its content, because no
two MCT ISOs are ever the same (due to MCT always regenerating the ISO content on the fly) it is currently impossible to
validate with absolute certainty whether any ISO that was generated by the MCT is safe to use. Especially, unlike what
is the case for retail ISOs, it is impossible to tell whether an MCT ISO may have been corrupted after generation.

Hence the need to provide users with a much easier and less restrictive way to access official retail ISOs...

License
-------

[GNU General Public License version 3.0](https://www.gnu.org/licenses/gpl-3.0) or later.

How it works
------------

The script basically performs the same operation as one might perform when visiting the following URL (that is, in the
case of Windows 10, provided that you have also changed your `User-Agent` browser string, since, the Microsoft web
servers detect that you are using a version of Windows that is the same as the one you are trying to download, they
may redirect you __away__ from the page that allows you to obtain a direct ISO download link):

https://www.microsoft.com/en-us/software-download

After checking basic access to the Microsoft software downloads website the script first queries the web API from the
Microsoft servers, to request the language selection available for the version of Windows selected, and then requests
the actual download links, for all the architectures available for that language + version.

Requirements
------------

Windows 8 or later with PowerShell. Windows 7 is __not__ supported.

Commandline mode
----------------

Fido supports commandline mode whereas, whenever one of the following options is provided, a GUI is not instantiated
and you can instead generate the ISO download from within a PowerShell console or script.

Note however that, as of 2023.05, Microsoft has removed access to older releases of Windows ISOs and as a result, the
list of releases that can be downloaded from Fido has had to be reduced to only the latest for each version.

The options are:
- `Win`: Specify Windows version (e.g. _"Windows 10"_). Abbreviated version should work as well (e.g `-Win 10`) as long
   as it is unique enough. If this option isn't specified, the most recent version of Windows is automatically selected.
   You can obtain a list of supported versions by specifying `-Win List`.
- `Rel`: Specify Windows release (e.g. _"21H1"_). If this option isn't specified, the most recent release for the chosen
   version of Windows is automatically selected. You can also use `-Rel Latest` to force the most recent to be used.
   You can obtain a list of supported versions by specifying `-Rel List`.
- `Ed`: Specify Windows edition (e.g. _"Pro/Home"_). Abbreviated editions should work as well (e.g `-Ed Pro`) as long
   as it is unique enough. If this option isn't specified, the most recent version of Windows is automatically selected.
   You can obtain a list of supported versions by specifying `-Ed List`.
- `Lang`: Specify Windows language (e.g. _"Arabic"_). Abbreviated or part of a language (e.g. `-Lang Int` for
   `English International`) should work as long as it's unique enough. If this option isn't specified, the script attempts
   to select the same language as the system locale.
   You can obtain a list of supported languages by specifying `-Lang List`.
- `Arch`: Specify Windows architecture (e.g. _"x64"_). If this option isn't specified, the script attempts to use the same
   architecture as the one from the current system.
- `GetUrl`: By default, the script attempts to automatically launch the download. But when using the `-GetUrl` switch,
   the script only displays the download URL, which can then be piped into another command or into a file.

Examples of a commandline download:

```
PS C:\Projects\Fido> .\Fido.ps1 -Win 10
No release specified (-Rel). Defaulting to '21H1 (Build 19043.985 - 2021.05)'.
No edition specified (-Ed). Defaulting to 'Windows 10 Home/Pro'.
No language specified (-Lang). Defaulting to 'English International'.
No architecture specified (-Arch). Defaulting to 'x64'.
Selected: Windows 10 21H1 (Build 19043.985 - 2021.05), Home/Pro, English International, x64
Downloading 'Win10_21H1_EnglishInternational_x64.iso' (5.0 GB)...
PS C:\Projects\Fido> .\Fido.ps1 -Win 10 -Rel List
Please select a Windows Release (-Rel) for Windows 10 (or use 'Latest' for most recent):
 - 21H1 (Build 19043.985 - 2021.05)
 - 20H2 (Build 19042.631 - 2020.12)
 - 20H2 (Build 19042.508 - 2020.10)
 - 20H1 (Build 19041.264 - 2020.05)
 - 19H2 (Build 18363.418 - 2019.11)
 - 19H1 (Build 18362.356 - 2019.09)
 - 19H1 (Build 18362.30 - 2019.05)
 - 1809 R2 (Build 17763.107 - 2018.10)
 - 1809 R1 (Build 17763.1 - 2018.09)
 - 1803 (Build 17134.1 - 2018.04)
 - 1709 (Build 16299.15 - 2017.09)
 - 1703 [Redstone 2] (Build 15063.0 - 2017.03)
 - 1607 [Redstone 1] (Build 14393.0 - 2016.07)
 - 1511 R3 [Threshold 2] (Build 10586.164 - 2016.04)
 - 1511 R2 [Threshold 2] (Build 10586.104 - 2016.02)
 - 1511 R1 [Threshold 2] (Build 10586.0 - 2015.11)
 - 1507 [Threshold 1] (Build 10240.16384 - 2015.07)
PS C:\Projects\Fido> .\Fido.ps1 -Win 10 -Rel 20H2 -Ed Edu -Lang Fre -Arch x86 -GetUrl
https://software-download.microsoft.com/db/Win10_Edu_20H2_v2_French_x32.iso?t=c48b32d3-4cf3-46f3-a8ad-6dd9568ff4eb&e=1629113408&h=659cdd60399584c5dc1d267957924fbd
```

Additional Notes
----------------

Because of its intended usage with Rufus, this script is not designed to cover every possible retail ISO downloads.
Instead we mostly chose the ones that the general public is likely to request. For instance, we currently have no plan
to add support for LTSB/LTSC Windows ISOs downloads.

If you are interested in such downloads, then you are kindly invited to visit the relevant download pages from Microsoft
such as [this one](https://www.microsoft.com/evalcenter/evaluate-windows-10-enterprise) for LTSC versions.
