(function e(t,n,r){function s(o,u){if(!n[o]){if(!t[o]){var a=typeof require=="function"&&require;if(!u&&a)return a(o,!0);if(i)return i(o,!0);throw new Error("Cannot find module '"+o+"'")}var f=n[o]={exports:{}};t[o][0].call(f.exports,function(e){var n=t[o][1][e];return s(n?n:e)},f,f.exports,e,t,n,r)}return n[o].exports}var i=typeof require=="function"&&require;for(var o=0;o<r.length;o++)s(r[o]);return s})({1:[function(require,module,exports){
/*global Promise, require, setImmediate, setTimeout, describe, it */
"use strict";


function unexpectedResolve(done) {
    return function () {
        done("Error: promise was expected to not resolve, but did.");
    };
}


// behavior from:
// https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Promise#Static_methods
// https://people.mozilla.org/~jorendorff/es6-draft.html
// http://wiki.ecmascript.org/doku.php?id=harmony:specification_drafts
// Draft rev 25, May 22 2014
// retrieved Jun 07 2014




describe("25.4.4.1 Promise.all( iterable )", function () {
    it("is a function", function () {
        assert.equal("function", typeof Promise.all);
    });
    it("has a length property whose value is 1", function () {
        assert.equal(1, Promise.all.length);
    });
    it("throws if 'this' is not a Promise constructor", function () {
        // requires the 'this' value to be a constructor function that suppports the
        // parameter conventions of the Promise constructor
        var empty = {};

        assert.throws(function () {
            Promise.all.call(empty, []);
        }, TypeError);
        // spec says to throw TypeError, per 25.4.1.6 NewPromiseCapability
    });

    it("should immediately reject for non-iterable argument", function (done) {
        var nonIterable = 3;

        // non-Object fails CheckIterable per 7.4.1
        // GetIterator throws TypeError per 7.4.2

        Promise.all(nonIterable)
            .then(unexpectedResolve(done))
            .catch(function (err) {
                assert.ok(err instanceof TypeError);
            }).then(done).catch(done);
    });
});

// 0 elements
describe("25.4.4.1 Promise.all with 0-element array", function () {

    it("should accept an empty array", function () {
        var p = Promise.all([]);
        assert.ok(p instanceof Promise);
    });

    it("should return a resolved promise whose result is empty array", function (done) {
        var p = Promise.all([]);

        assert.ok(p instanceof Promise);

        p.then(function (result) {
            assert.deepEqual([], result);
        }).then(done).catch(done);
    });
});

// 1 element
describe("25.4.4.1 Promise.all with 1-element array", function () {

    it("should accept an array of one promise", function (done) {
        var p1 = Promise.resolve(1);

        Promise.all([p1]).then(function (result) {
            assert.deepEqual([1], result);
        }).then(done).catch(done);
    });
    it("should resolve immediately", function (done) {
        var obj = {};

        var p1 = new Promise(function (resolve, reject) {
            resolve(obj);
        });

        Promise.all([p1]).then(function (resolved) {
            assert.deepEqual([obj], resolved);
        }).then(done).catch(done);
    });
    it("should reject immediately", function (done) {
        var obj = {};

        var p1 = new Promise(function (resolve, reject) {
            reject(obj);
        });

        Promise.all([p1])
            .then(unexpectedResolve(done), function (rejected) {
                assert.equal(obj, rejected);
            }).then(done).catch(done);

    });
});

// 2 elements
describe("25.4.4.1 with 2-element array", function () {
    it("should accept an array of two promises", function (done) {
        var p1 = Promise.resolve(1),
            p2 = Promise.resolve(2);

        Promise.all([p1, p2]).then(function (resolved) {
            assert.deepEqual([1, 2], resolved);
        }).then(done).catch(done);

    });

    it("should not resolve immediately when one of a two-promise array resolves", function (done) {
        var p1 = new Promise(function (resolve) {
                resolve(1);
            }),
            p2 = new Promise(function (resolve) {
                resolve(2);
            });

        var sequencer = [1];

        p1.then(function (resolved) {
            assert.deepEqual([1], sequencer);
            sequencer.push(2);
        }).catch(done);

        Promise.all([p1, p2]).then(function (resolved) {
            assert.deepEqual([1, 2, 3], sequencer);
            sequencer.push(4);
        }).then(done).catch(done);

        p2.then(function (resolved) {
            assert.deepEqual([1, 2], sequencer);
            sequencer.push(3);
        }).catch(done);

    });

    it("should should execute 'then' methods in sequence", function (done) {
        var p1 = Promise.resolve(100),
            p2 = Promise.resolve(200);

        var sequencer = [1];

        p1.then(function afterOne(resolved) {
            assert.deepEqual([1], sequencer);
            sequencer.push(2);
        }).catch(done);

        Promise.all([p1, p2]).then(function afterAll(resolved) {
            assert.deepEqual([1, 2, 3], sequencer);
            sequencer.push(4);
        }).then(done).catch(done);

        p2.then(function afterTwo(resolved) {
            assert.deepEqual([1, 2], sequencer);
            sequencer.push(3);
        }).catch(done);

    });
    // covered by case above
    //	it("should resolve after both promises of a two-promise array resolve");

    it("should reject immediately when the first member of a two-promise array rejects", function (done) {
        var rejectP1,
            p1 = new Promise(function (resolve, reject) {
                rejectP1 = reject;
            }),
            p2 = Promise.resolve(2);

        Promise.all([p1, p2])
            .then(unexpectedResolve(done))
            .catch(function (rejected) {
                assert.equal(rejected, 1);
            }).then(done).catch(done);

        rejectP1(1);
    });

    it("should reject immediately when the second member of a two-promise array rejects", function (done) {
        var rejectP2,
            p1 = Promise.resolve(1),
            p2 = new Promise(function (resolve, reject) {
                rejectP2 = reject;
            });

        Promise.all([p1, p2])
            .then(unexpectedResolve(done))
            .catch(function (rejected) {
                assert.equal(2, rejected);
            }).then(done).catch(done);

        rejectP2(2);
    });
});

// not explicitly addressed: 25.4.4.1.1 Promise.all Resolve Element Functions
// these are not visible from userland js

},{}],2:[function(require,module,exports){
(function (global){
"use strict";
// browser compatibility: old browsers don't have strict mode, so skip
// a few tests which rely on strict mode behavior for `this`.
var hasStrictMode = (function() { return this===null; }).call(null);

describe("25.4.3 The Promise Constructor", function () {
    it("is the initial value of the Promise property of the global object", function () {
        assert.strictEqual(Promise, global.Promise);
    });

    it("can be called as a function");
    // requires a functioning ES6 Symbol.create
    //, function () {
    //	var p = Promise[Symbol.create]();
    // assert.doesNotThrow(function () {
    // Promise.call(p, function () {});
    // });
    //});

    it("can be used as the value in an extends clause");

    // "Subclass constructors that intend to inherit the specified
    // Promise behaviour must include a 'super' call to Promise"

    // subclass constructors MAY include a 'super' call to Promise

    // subclass constructors *that intend to inherit specified Promise
    // behavior* MUST include such a call
});

describe("25.4.3.1 Promise ( executor )", function () {

    it("throws TypeError when 'this' is not of type Object", function () {
        assert.throws(function () {
            Promise.call(3, function () {});
        }, TypeError);
    });

    it("throws TypeError if 'this' is a constructed, but unresolved Promise", function (done) {
        var resolveP,
            p = new Promise(function (resolve, reject) {
                resolveP = resolve;
            });

        // promise's [[PromiseState]] internal slot should be 'pending'
        // should throw
        assert.throws(function () {
            Promise.call(p, function (resolve, reject) {
                resolve(2);
            });
        }, TypeError);

        // receive first resolution
        p.then(function (resolved) {
            assert.equal(1, resolved);
        }).then(done).catch(done);

        resolveP(1);
    });

    it("throws TypeError if 'this' is a resolved Promise", function (done) {
        var p = new Promise(function (resolve, reject) {
            resolve(1);
        });

        function afterFirstResolution() {
            // if promise's [[PromiseState]] internal slot is not 'undefined'
            // should throw
            assert.throws(function () {
                Promise.call(p, function (resolve, reject) {
                    resolve(2);
                });
            }, TypeError);

            // affirm that previous resolution is still settled
            p.then(function (resolved) {
                assert.equal(1, resolved);
            }).then(done).catch(done);
        }

        // receive first resolution
        p.then(function (resolved) {
            assert.equal(resolved, 1);

            Promise.resolve().then(afterFirstResolution).catch(done);
        }).catch(done);
    });

    it("throws TypeError if 'executor' is not Callable", function () {
        assert.throws(function () {
            new Promise("not callable");
        }, TypeError);
    });
});

describe("25.4.3.1.1 InitializePromise ( promise, executor )", function () {
    it("returns a promise");
    it("invokes the executor with 'this' = 'undefined'", function () {
        var savedThis;
        var p = new Promise(function () {
            savedThis = this;
        });

        if (hasStrictMode) {
            assert.equal(undefined, savedThis);
        }
    });
    it("catches exceptions thrown from executor and turns them into reject", function (done) {
        // if completion is an abrupt completion
        var errorObject = {};

        var p = new Promise(function () {
            throw errorObject;
        });

        p.then(undefined, function (err) {
            if (hasStrictMode) {
                assert.equal(undefined, this);
            }
            assert.equal(errorObject, err);
        }).then(done).catch(done);

    });

    it("returns a promise either in the 'pending' or 'rejected' state");
});

describe("25.4.3.2 new Promise ( ... argumentsList )", function () {
    it("is a constructor call");
});

describe("25.4.4 Properties of the Promise Constructor", function () {
    it("has a [[Protoype]] internal slot whose value is the Function prototype object");
    it("has a length property whose value is 1", function () {
        assert.equal(1, Promise.length);
    });
});

describe("Promise constructor", function () {
    it("is provided", function () {
        assert.equal(typeof Promise, "function");
    });

    it("returns a new Promise", function () {
        var p = new Promise(function () {});

        assert.ok(p instanceof Promise);
    });
});

}).call(this,typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
},{}],3:[function(require,module,exports){
"use strict";


describe("incorrect subclassing:", function () {
    describe("25.4.1.6.1 step 8 invalid 'resolve':", function () {

        function BadResolverPromise(executor) {
            var p = new Promise(executor);
            executor(3, function () {});

            this.then = p.then;
            this.constructor = BadResolverPromise;
        }
        BadResolverPromise.prototype = Promise.prototype;
        BadResolverPromise.all = Promise.all;
        BadResolverPromise.race = Promise.race;
        BadResolverPromise.reject = Promise.reject;
        BadResolverPromise.resolve = Promise.resolve;

        it("throws TypeError with Promise.reject", function (done) {
            assert.throws(function () {
                BadResolverPromise.reject(2);
            }, TypeError);

            done();
        });

        it("provides a resolve which is not a function", function (done) {
            var brp = new BadResolverPromise(function executor(resolve, reject) {
                assert(typeof resolve != "function");
            });

            assert(brp.constructor === BadResolverPromise);
            done();
        });

        it("throws TypeError with Promise.all", function (done) {
            assert.throws(function () {
                BadResolverPromise.all([1, 2]);
            }, TypeError);

            done();
        });

        it("throws TypeError with Promise.race", function (done) {
            assert.throws(function () {
                BadResolverPromise.race([1, 2]);
            }, TypeError);

            done();
        });

        it("throws TypeError with Promise.resolve", function (done) {
            assert.throws(function () {
                BadResolverPromise.resolve(1);
            }, TypeError);

            done();
        });

        it("throws TypeError with Promise.then", function (done) {
            assert.throws(function () {
                new BadResolverPromise(function () {}).then(function () {});
            }, TypeError);

            done();
        });
    });

    describe("25.4.1.6.1 step 9 invalid 'reject'", function () {

        function BadRejectorPromise(executor) {
            var p = new Promise(executor);
            executor(function () {}, 4);

            this.then = p.then;
            this.constructor = BadRejectorPromise;
        }
        BadRejectorPromise.prototype = Promise.prototype;
        BadRejectorPromise.all = Promise.all;
        BadRejectorPromise.race = Promise.race;
        BadRejectorPromise.reject = Promise.reject;
        BadRejectorPromise.resolve = Promise.resolve;

        it("provides a reject which is not a function", function (done) {
            new BadRejectorPromise(function executor(resolve, reject) {
                assert(typeof reject != "function");
                done();
            });
        });

        it("throws TypeError with Promise.all", function (done) {
            assert.throws(function () {
                BadRejectorPromise.all([1, 2]);
            }, TypeError);

            done();
        });

        it("throws TypeError with Promise.race", function (done) {
            assert.throws(function () {
                BadRejectorPromise.race([1, 2]);
            }, TypeError);

            done();
        });

        it("throws TypeError with Promise.resolve", function (done) {
            assert.throws(function () {
                BadRejectorPromise.resolve(1);
            }, TypeError);

            done();
        });

        it("throws TypeError with Promise.reject", function (done) {
            assert.throws(function () {
                BadRejectorPromise.reject(2);
            }, TypeError);

            done();
        });

        it("throws TypeError with Promise.then", function (done) {
            assert.throws(function () {
                new BadRejectorPromise(function () {}).then(function () {});
            }, TypeError);

            done();
        });
    });
});

},{}],4:[function(require,module,exports){
/*global Promise, require, setImmediate, setTimeout, describe, it */
"use strict";


describe("25.4.4.2 Promise.prototype", function () {
    it("is the Promise prototype object", function () {
        var p = new Promise(function () {});

        assert.ok(p instanceof Promise);
        // TODO(Sam): is there any way to ensure that there are no
        // other objects in the prototype chain?
        assert.ok(Promise.prototype instanceof Object);
    });
    it("has attribute [[Writable]]: false");
    it("has attribute [[Enumerable]]: false");
    it("has attribute [[Configurable]]: false");
});

describe("25.4.5 Properties of the Promise Prototype Object", function () {
    it("is an ordinary object");
    it("is not a Promise"); // implied
});

describe("25.4.5.1 Promise.prototype.catch( onRejected )", function () {
    it("is a function");
    it("expects 'this' to be a Promise");
    it("takes one argument, a function");
    it("is equivalent to 'promise.then(undefined, fn)'");
});

describe("25.4.5.2 Promise.prototype.constructor", function () {
    it("is an object");
    it("is a function");
    it("is the Promise constructor");
});

describe("25.4.5.3 Promise.prototype.then", function () {
    it("is a function");
    it("expects 'this' to be a Promise");
    it("throws TypeError if 'this' is not a Promise");
    it("takes two arguments, both optional, both functions");
    it("has default on resolve: identity");
    it("has default on reject: thrower", function (done) {
        var errorObject = {};
        var p = new Promise(function (resolve, reject) {
            reject(errorObject);
        });

        p.then().catch(function (rejected) {
            assert.equal(errorObject, rejected);
        }).then(done).catch(done);
    });

    it("does not call either function immediately if promise status is 'pending'");

    it("does call onFulfilled immediately if promise status is 'fulfilled'");
    it("never calls onRejected if promise status is 'fulfilled'");

    it("never calls onFullfilled if promise status is 'rejected'");
    it("does call onRejected immediately if promise status is 'rejected'");

    it("returns its 'this' argument if it is of type 'Promise'");
    it("returns a Promise-wrapped version of 'this' if 'this' is not of type 'Promise'");
});

},{}],5:[function(require,module,exports){
/*jslint indent: 8*/
/*global Promise, require, setImmediate, setTimeout, describe, it */
"use strict";


describe("25.4.4.3 Promise.race( iterable )", function () {
    it("is a function", function () {
        assert.equal("function", typeof Promise.race);
    });
    it("expects one argument", function () {
        assert.equal(1, Promise.race.length);
    });
    it("should immediately reject for non-iterable argument", function (done) {
        var nonIterable = 3;

        // non-Object fails CheckIterable per 7.4.1
        // GetIterator throws TypeError per 7.4.2

        Promise.race(nonIterable)
            .catch(function (rejected) {
                assert.ok(rejected instanceof TypeError);
            }).then(done).catch(done);
    });
    it("requires 'this' to be a constructor function that supports the " +
        "parameter conventions of the Promise constructor", function (done) {
            var empty = {};
            assert.throws(function () {
                Promise.race.call(empty, []);
            }, TypeError);
            done();
        });

    it("requires 'this' to provide a 'resolve' method");

    // eventually: test of subclassing:
    // var Extended = {};
    //
    // Extended.resolve = 3;
    // assert.equal('number', typeof Extended.resolve);
    // 
    // assert.throws(function () {
    // Promise.race.call(Extended, []);
    // }, TypeError);
    // done();
});

describe("25.4.4.3 Promise.race with 0-element array", function () {
    it("should accept an empty array", function () {
        var p = Promise.race([]);
        assert.ok(p instanceof Promise);
    });
    it("should return a pending promise", function (done) {
        var p1 = Promise.race([]);

        p1.then(function () {
            throw new Error("expected Promise.race([]) to remain unsettled");
        })
            .catch(done);

        var p2 = Promise.resolve().then(done).catch(done);
    });
});

describe("25.4.4.3 Promise.race with 1-element array", function () {
    it("should accept an array of one promise", function (done) {
        var p1 = Promise.resolve(1);

        Promise.race([p1]).then(function (resolved) {
            assert.equal(1, resolved);
        }).then(done).catch(done);
    });
    it("should reject immediately", function (done) {
        var p1 = new Promise(function (resolve, reject) {
            reject(1);
        });

        Promise.race([p1]).then(function (resolved) {
            throw new Error("unexpected resolve");
        }, function (rejected) {
            assert.equal(1, rejected);
        }).then(done).catch(done);
    });
});

describe("25.4.4.3 Promise.race with 2-element array", function () {
    it("should accept an array of two promises", function (done) {
        var p1 = Promise.resolve(1),
            p2 = Promise.resolve(2);

        Promise.race([p1, p2]).then(function (resolved) {
            assert.equal(1, resolved);
        }).then(done).catch(done);

    });
    it("should resolve immediately when first resolves", function (done) {
        var p1 = Promise.resolve(1),
            p2 = new Promise(function () {});

        Promise.race([p1, p2]).then(function (resolved) {
            assert.equal(1, resolved);
        }).then(done).catch(done);
    });
    it("should resolve immediately when second resolves", function (done) {
        var p1 = new Promise(function () {}),
            p2 = Promise.resolve(2);

        Promise.race([p1, p2]).then(function (resolved) {
            assert.equal(2, resolved);
        }).then(done).catch(done);
    });
    it("should reject immediately when first rejects", function (done) {
        var p1 = Promise.reject(1),
            p2 = Promise.resolve(2);

        Promise.race([p1, p2]).then(function (resolved) {
            throw new Error("Unexpected resolve");
        }, function (rejected) {
            assert.equal(rejected, 1);
        }).then(done).catch(done);

    });

    it("should fulfill immediately with first fulfilled promise in array", function (done) {
        var resolveP1, rejectP2,
            p1 = new Promise(function (resolve, reject) {
                resolveP1 = resolve;
            }),
            p2 = new Promise(function (resolve, reject) {
                rejectP2 = reject;
            });

        rejectP2(2);
        resolveP1(1);

        Promise.race([p1, p2]).then(function (resolved) {
            assert.equal(resolved, 1);
        }).then(done).catch(done);
    });

    it("should reject immediately when second rejects", function (done) {
        var resolveP1, rejectP2,
            p1 = new Promise(function (resolve, reject) {
                resolveP1 = resolve;
            }),
            p2 = new Promise(function (resolve, reject) {
                rejectP2 = reject;
            });

        Promise.race([p1, p2]).then(function (resolved) {
            throw new Error("Unexpected resolve " + resolved);
        }, function (rejected) {
            assert.equal(rejected, 2);
        }).then(done).catch(done);

        rejectP2(2);
        resolveP1(1);
    });
});

},{}],6:[function(require,module,exports){
"use strict";


describe("25.4.4.4 Promise.reject( x )", function () {
    it("is a function", function () {
        assert.equal("function", typeof Promise.reject);
    });
    it("expects one argument", function () {
        assert.equal(1, Promise.reject.length);
    });
    it("always creates a new promise using 'this' as constructor", function () {
        var p = Promise.reject(3);

        assert.ok(p instanceof Promise);
    });
    it("throws if 'this' is not a constructor", function () {
        var notAConstructor = 3;

        assert.throws(function () {
            Promise.reject.call(notAConstructor, 4);
        }, TypeError);
    });
    it("always returns a rejected promise", function (done) {
        var p = Promise.reject(3);
        p.then(function () {
            throw new Error("unexpected resolve");
        }, function (rejected) {
            assert.equal(3, rejected);
        }).then(done).catch(done);
    });
});

},{}],7:[function(require,module,exports){
"use strict";


describe("25.4.4.5 Promise.resolve( x )", function () {
    it("is a function", function () {
        assert.equal("function", typeof Promise.resolve);
    });
    it("expects one argument", function () {
        assert.equal(1, Promise.resolve.length);
    });

    it("passes through a resolved promise created with the same constructor as 'this'", function (done) {
        var p1 = new Promise(function (resolve) {
                resolve(1);
            }),
            p2;

        p1.then(function (r1) {
            assert.equal(1, r1);
            p2 = Promise.resolve(p1);
            p2.then(function (r2) {
                assert.equal(1, r2);
                assert.equal(p1, p2);
            }).then(done).catch(done);
        }).catch(done);
    });

    it("passes through an unsettled promise created with the same constructor as 'this'", function (done) {
        var resolveP1,
            p1 = new Promise(function (resolve) {
                resolveP1 = resolve;
            }),
            p2 = Promise.resolve(p1);

        p1.then(function (r1) {
            assert.equal(1, r1);
        }).catch(done);

        p2.then(function (r2) {
            assert.equal(1, r2);
            assert.equal(p1, p2);
        }).then(done).catch(done);

        resolveP1(1);
    });


    // otherwise (called on value not created by 'this' constructor)
    it("creates a new promise using the supplied constructor", function () {
        var p1 = Promise.resolve(3);

        assert.ok(p1 instanceof Promise);
    });
    it("throws if 'this' is not a constructor", function () {
        var notAConstructor = 3;

        assert.throws(function () {
            Promise.resolve.call(notAConstructor, 4);
        }, TypeError);
    });

    it("can return a resolved promise", function (done) {
        var p1 = Promise.resolve(3);

        p1.then(function (resolved) {
            assert.equal(3, resolved);
        }).then(done).catch(done);
    });

    it("can return a pending promise", function (done) {
        var p1 = new Promise(function (resolve) {
            resolve("resolve");
        });

        var sequencer = [1];

        var p2 = Promise.resolve(p1).then(function (resolved) {
            assert.equal("resolve", resolved);

            sequencer.push(3);
            assert.deepEqual([1, 2, 3], sequencer);

        }).then(done).catch(done);

        sequencer.push(2);
    });

    it("can return a rejected promise", function (done) {
        var p1 = Promise.reject(3);
        var p2 = Promise.resolve(p1);

        p2.then(function (resolve) {
            throw new Error("unexpected resolve " + resolve);
        }, function (rejected) {
            assert.equal(3, rejected);
        }).then(done).catch(done);
    });

    // 25.4.4.5 steps 2 a & b:
    // 2. if IsPromise(x) is true
    //   a. Let constructor be the value of x's PromiseConstructor
    //   b. if SameValue(Constructor, C) is true, return x
    it("can pass through a subclassed promise if passed a subclassed promise");
});

},{}],8:[function(require,module,exports){
"use strict";


describe("Sequencing tests from promises-aplus/issue #61", function () {
    it("T1", function (done) {

        var resolveP1, rejectP2, sequencer = [];

        (new Promise(function (resolve, reject) {
            resolveP1 = resolve;
        })).then(function (msg) {
            sequencer.push(msg);
        }).then(function () {
            assert.deepEqual(["A", "B"], sequencer);
        }).then(done).catch(done);

        (new Promise(function (resolve, reject) {
            rejectP2 = reject;
        })).catch(function (msg) {
            sequencer.push(msg);
        });

        rejectP2("A");
        resolveP1("B");

    });

    it("T2a", function (done) {
        var resolveP1, rejectP2, p1, p2,
            sequencer = [];

        p1 = new Promise(function (resolve, reject) {
            resolveP1 = resolve;
        });
        p2 = new Promise(function (resolve, reject) {
            rejectP2 = reject;
        });

        rejectP2("B");
        resolveP1("A");

        p1.then(function (msg) {
            sequencer.push(msg);
        });

        p2.catch(function (msg) {
            sequencer.push(msg);
        }).then(function () {
            assert.deepEqual(["A", "B"], sequencer);
        }).then(done).catch(done);
    });

    it("T2b", function (done) {

        var resolveP1, rejectP2, p1, p2,
            sequencer = [];

        p1 = new Promise(function (resolve, reject) {
            resolveP1 = resolve;
        });
        p2 = new Promise(function (resolve, reject) {
            rejectP2 = reject;
        });

        rejectP2("B");
        resolveP1("A");

        setTimeout(function () {
            p1.then(function (msg) {
                sequencer.push(msg);
            });

            p2.catch(function (msg) {
                sequencer.push(msg);
            }).then(function () {
                assert.deepEqual(["A", "B"], sequencer);
            }).then(done).catch(done);
        }, 0);

    });
});

},{}]},{},[2,4,7,3,5,8,1,6])