# 기술 면접 시작하기

## 목차
- [1. 면접을 위한 자기소개서 작성법](#1-면접을-위한-자기소개서-작성법)
- [2. 기술 면접에서 평가하는 것](#2-기술-면접에서-평가하는-것)
- [3. 말하기](#3-말하기)
- [4. 문제 해결하기(코딩, 설계 등)](#4-문제-해결하기코딩-설계-등)

## 1. 면접을 위한 자기소개서 작성법
자기소개서에서 중요한 것은 3가지라고 한다.
1. **이 회사에 지원한 이유(지원동기)**
2. **내가 이 회사에 어떤 것을 기여할 수 있는지(직무경험)**
3. **왜 나를 뽑아야 하는지(강점/약점, 장점/단점)**

지금까지 해당 직무를 위해 어떤 경험과 노력을 했는지 정리한다. 이러한 경험동안 자신의 강점 및 약점이 어떻게 드러났는지, 문제에 직면했을 때 해결한 과정 등을 자기소개서에 적어야한다.

### 1.1 지원 동기
지원 동기는 직무에 대한 지원동기가 아닌 지원한 **회사(또는 팀)에 대한 지원동기**를 적어야 한다. 직무에 대한 지원동기는 어느 회사나 팀에 공통적으로 적을 수 있다. 이는 보는 입장에서 특히 면접에서 매력이 떨어질 확률이 크다.

만약 어떤 이커머스 회사의 백엔드 서버 개발 직무에 지원한다고 하면, 백엔드를 선택한 이유보다 이커머스라는 분야를 선택한 이유가 더 좋을 것이고, 더 나아가 해당 이커머스 회사를 지원한 이유를 말하는 것이 가장 좋을 것이다.

잘 못 작성된 지원동기를 알 수 있는 방법은 아래를 생각해보는 것이다.
- 다른 회사 이름으로 변경해도 무리가 없는 경우
- 기업 홈페이지 내용을 그대로 옮겨 놓은 경우
- 특별한 이유 없이 직무 지원동기로 적은 경우

잘 못 작성된 지원동기는 서류는 통과할 수 있지만 **면접 때는 어려움을 겪을 수 있다.** 자기소개서는 면접을 대비하는 것이다. 따라서 자기소개서 준비와 면접 준비는 같이 하는 것이지, 따로 하는 것이 아니다.

### 1.2 직무 경험
직무 경험은 기업이 원하는 능력을 바탕으로 적어야 한다. 아래는 일반적인 기업이 원하는 능력이다.(개발자도 예외는 아니라고 생각함)
1. **목표 달성 능력**: 명확한 목표가 있는지
2. **문제 해결 능력**: 목표를 향하는 과정에서 만난 문제를 해결할 수 있는 능력
3. **실행력**: 문제를 해결하는 과정 속에서 추진력과 리더쉽을 발휘하여 실행했는지
4. **분석력, 의사소통력**: 충분한 분석을 통해 실행했는지, 실행 과정에서 의사소통을 충분히 했는지

신입 및 주니어 개발자는 **성장** 가능성이 중요하다고 생각한다. 기술에 대해 얼마나 관심이 있는지, 기술을 빠르게 배울 수 있는지, 핵심이 되는 기술(운영체제, 데이터베이스, 자료구조 등)을 학습했는지 등을 어필하는 것도 중요하다고 생각한다.

#### 경험의 재해석
직무와 관련된 경험을 정리한 후, 기업이 원하는 모습으로 재해석해야 한다.(수치화, 객관적 요소, 두괄식)
- 과거부터 검증된 방식을 사용하는 것이 좋다.(3C/4P)
- **수치화**가 중요하다.
- 경제 신문을 읽으면 좋다.(경제 신문 기사의 대부분은 3C/4P를 기반으로 한다.)

경험을 작성할 때는 **WHAT, WHY, HOW** 순으로 한다.

#### 1) 3C 분석을 통해 "배경" 정리 - WHY

| 3C | 직관 질문 | 주요 동인 |
|--------------------|----------------------------------------------------------------------------------------------------|------------------------------------------------------------|
| Customer(고객) | 누구를 만족시키기 위한 경험이었나?<br>그들의 니즈는 무엇인가? | 상사, 교수님, 프로젝트 고객 |
| Company(자사) | 무엇을 해결해야 조직에 유익한가?<br>나의 기여와 공헌은 무엇인가? | 큰그림, 최종 목표 |
| Competitor(경쟁사) | 이미 잘하고 있는 대상을 조사했는가?<br>무엇부터 따라할지 참고했는가?<br>시장조사는 어디를 어떻게 했는가? | 업계/세계 1등,<br> Best Practice/<br>Reverse Engineering,<br> 시장조사 |

- 경험을 떠올릴 때, 배경부터 생각하는 것이 편하다.
- 고객, 자사, 경쟁사의 대상을 적절히 선정해야한다.
- 생각이 아닌 행동이 있어야 한다.

#### 2) 4P 분석을 통해 "결과물"과 "방법" 정리 - WHAT, HOW

| 4P | 직관질문 | 주요지표 |
|-------------------|-----------------------------------------------------------------------------|-------------------------------------|
| Product(상품) | 나의 목표는 무엇이었고, 무엇을 이루었는가?<br> 어떤면에서 의미있는 결과물인가? | 매출/수익, 단축된 시간, 제거된 오류 |
| Price(가격) | 고객이 지불할만한 가치가 있었는가?<br> 고객의 만족도는 어떠했는가? | 만족도, 재구매율, 학점 |
| Place(위치) | 어디서 했는가?(온라인 포함)<br> 그곳을 선정한 이유가 있는가? | 비용 절감률, 만족도 |
| Promotion(마케팅) | 어떻게 알렸는가?<br> 사람들의 반응은 어땠고, 이전과 달라진 숫자는 무엇인가? | 조회수, 참석자수 |

- 위치는 도저히 생각이 안나면 빼도 괜찮은 구성이라고 함.

위 각각의 경험을 **1~3줄**로 정리하고, 자기소개서 및 면접에 따라 알맞게 사용한다.

#### 3) 작성 순서
1. **WHAT**: Product, 결과물
2. **WHY**: 3C
3. **HOW**: Price, Promotion, Place

### 1.3 강점/약점 VS 장점/단점
- 강점/약점: 능력적인 부분
- 장점/단점: 성격적인 부분(성격유형검사)

기업은 강점을 집중해서 말해야 한다. 물론 장점과 연결해서 말하는 것이 가장 좋다. 예를 들어 "저는 꼼꼼한 성격을 가지고 있어, 문서화를 중요시하고 항상 수행하고 있습니다." 와 같이 말할 수 있다. 덧붙여 이에 대한 사례를 추가해서 말할 수도 있다.

약점이나 단점에 대한 질문은 반드시 보완할 점을 같이 말해야 한다. 물론 치명적인 것은 말하는 것을 자제해야 한다. 예를 들어 "어떠한 약점 또는 단점이 있는데, 팀원들과 대화를 통해 고쳐나가거나 좋아지고 있다" 등으로 말하는 것이 좋다고 한다.


## 2. 기술 면접에서 평가하는 것
### 분석 능력
- 문제를 푸는데 얼마나 걸렸는가?
- 도움은 얼마나 받았는가?
- 최적화를 얼마나 했는가?
- 다양한 방법을 생각할 수 있고, 그에 대한 장단점을 알고 있는가?

### 코딩 능력
- 알고리즘을 적절한 코드로 표현할 수 있는가?
- 코드가 깔끔하고 구성이 좋은가?
- 가능한 에러, 예외에 대해 처리했는가?
- 코드 스타일이 일관적인가?(좋은 방향으로 일관적인가?)

### 기술적 지식 및 컴퓨터 과학 기본
- 기술에 대해 기본기가 출중한가?
- 배운 기술에 대해 설명을 논리적으로 할 수 있는가?

### 경험
- 기술적 결정을 해본 경험이 있는가?
- 흥미롭고 도전적인 프로젝트를 해본 경험이 있는가?
- 팀원들과 의사소통을 해보고, 갈등을 해결한 경험이 있는가?
- 어떠한 문제를 인식하고, 이를 해결해본 경험이 있는가?

### 문화와 얼마나 잘 맞는지/의사소통
- 지원자의 성격과 가치가 회사와 부합하는가?
- 면접관과 의사소통이 잘 되었는가?

기본적으로 기술 면접에서는 위에 대한 능력을 평가할 것이다. 비중은 회사마다 다르기 때문에 해당 회사의 문화와 추구하는 가치, 인재상을 살펴보고 준비하는 것이 좋을 듯 하다.


## 3. 말하기
- 말하기의 가장 핵심은 **생각 정리**와 **발음**이다.
    - 발음을 정확히 하는 것만으로도 기본적인 호흡과 발성이 따라온다고 한다.
- 상대방 말을 귀 기울여 듣는다.
    - 특히 면접관의 질문을 놓치거나, 잘못 해석해서 대답하는 일이 없어야 한다.
    - 면접관의 질문을 짧게 요약한 후 시작해도 좋을 듯하다.
    > - 면접관: "~ 장점은 뭔가요?"
    > - 면접자: "~ 장점은 ...이다."

### 3.1 논리적으로 말하기
- PREP 기법 ([참고 링크](https://brunch.co.kr/@pkm297xo/9))
    - **Point**: 결론, 요점, 핵심
    - **Reason**: 이유, "왜?"
    - **Example**: 사례, 사실, 데이터
    - **Point**: 결론 반복

### 3.2 면접 말하기
- 자신만의 **필살기**(**직무 역량 + 그에 대한 경험**)에 집중
    - 자바 스프링 백엔드 직무에 지원한다면, 자바, 스프링에 대한 경험과 그에 대한 지식, 깊이 고민한 것을 위주로 준비한다.
- 두괄식으로 말하기
    - 두괄식은 **결론(핵심)** 부터 말하는 것이다.
    - 결론: 예/아니오, 숫자와 같은 객관적인 증거, 결과
    - 두괄식이 아닌 것: 배경, 의도, 프로세스 등
    - `결론 -> 두괄식이 아닌 것 -> 결론`으로 말하는 것을 기본으로 한다.
- 면접관은 입사 후 같이 일해야 할 사람이다. **대화**를 하려고 노력하자.
- 질문의 정답에만 집중하지 말자.
    - 특히, 경험에 대한 질문에서는 중요한 몇 가지를 준비한 것에서 질문에 맞게 변환하여 답변한다.

#### 모르는 질문이 나왔을 때
- 가장 중요한 것은 모른다고 해서 소극적이고, 대화를 포기해서는 안된다.
    - 물론 거짓말이나 횡설수설하라는 얘기는 아니다.
    - `아는 것을 말할 때 힘을 빼고, 모르는 것을 말할 때 힘을 준다`와 같이 상황을 잘 대처하고 적극적인 모습을 어필하는게 중요하다.
- 전공 개념과 같은 답이 있는 질문을 몰랐을 때
    - 준비하지 못했다, 기억이 나지 않는다  + 다음에 꼭 알아보겠다. 등과 같은 문구를 준비한다.
    - 모른다고 인정하고, 유추하거나 최대한 아는 선까지 말해본다.
- 경험과 같은 답이 없는 경우
    - 준비한 필살기를 바탕으로 해당 질문에 변환하여 말한다.
    - 방향이 다르다면, 준비하지 못했다고 솔직히 말하고 이러한 경험이 있는데 얘기해도 되는지 물어보고 답변한다.(최대한 비슷한 방향으로 화제를 전환한다.)


## 3. 자기소개

```
[Sample]
~에 지원한 ~입니다.
그리고 저는 ~ 직무를 잘하기 위해서 이런 유사한 경험이 있습니다. 이 때 ~한 성과를 냈고 이걸 통해 ~한 통찰을 얻었습니다(배움과 깨달음을 얻었습니다.) 
이러한 저의 경험들이 지원하는 직무/기업에서 계속해서 재생산 될것이라 확신하여 지원하게 되었습니다. 감사합니다.
```


## 4. 문제 해결하기(코딩, 설계 등)
- 면접에서는 자주 코딩 테스트, 설계 문제가 등장한다.
    - 손코딩뿐 아니라, 노트북으로 면접관과 화면을 공유하여 코딩하기도 한다.
- 면접에서 제시한 문제는 **문제를 해결하는 능력**을 테스트하는 것이다. 외워서 답변하는 것은 도움이 되질 않는다.

### 4.1 준비하기
평소 기술 면접을 준비하면서 문제를 풀 때 아래와 같은 과정으로 연습해야 합니다.

#### 직접 풀도록 노력하라.
포기하지말고, 최대한 힌트를 보지말고 답을 찾는다. 그리고 항상 풀이의 공간과 시간 효율에 대해서 생각한다.

#### 코드를 종이에 적자.
실제 면접에서는 손코딩이 자주 나온다. 실제와 비슷한 환경에서 연습해야 한다.

#### 코드를 테스트하자.
물론 이 역시 종이 위에서 한다. 일반적인 경우뿐 아니라 여러 예외 상황을 생각해야 한다.

#### 종이에 적은 코드를 그대로 컴퓨터로 옮기고 실행해보자.
종이로 적었을 때 실수를 많이 했을 것이다. 컴퓨터로 옮기면서 실수 목록을 적고, 그 다음부터 저지르지 않도록 유의한다.

### 4.2 문제 해결 과정
연습할 때와 실제 면접에서 아래의 과정으로 문제를 해결해보자.

#### 끊임없이 소통하라!
아래 과정을 수행하면서 궁금한 점이 있다면 질문하고, 설명이 필요하다고 생각되는 부분은 말로 직접 설명을 하자. 

#### 듣기
문제를 정확하게 이해하기 위해서는 집중해서 들어야 한다.

#### 예제
주어진 예제뿐 아니라 특별한 상황, 예외 상황에 대한 예제를 생각하고, 이를 활용하여 디버깅할 수 있어야 한다.
- 이 단계에서는 특별한 경우가 아닌 명확하고 적당한 크기의 예제를 사용하자.

#### 무식하게 풀기
우선은 무식한 방법(brute force, 완전 탐색)으로 풀어본다. 그 후에 최적화를 시도한다.

#### 최적화
무식하게 푼 방법을 아래의 방법으로 개선해본다.
- BUD 최적화
    - **B**ottlenecks (병목현상)
    - **U**nnecessary Work (불필요한 작업)
    - **D**uplicated Work (중복되는 작업)
- 그 외
    - 간과한 부분이 있는지 생각해본다.
    - 예제를 손으로 풀어 본 뒤 사고 과정을 되짚어본다.
    - 잘못된 방법으로 문제를 풀어 본 뒤 알고리즘이 틀렸는지 생각해본다.
    - 시간과 공간의 비용-이익 관계를 고려한다.(해시테이블이 유용한 경우가 많다.)

#### 검토하기
최적의 해법을 찾았다면, 다시 한번 자세하게 검토해본다.

#### 구현하기
코드를 깔끔하게 구현하자.
- 의미있는 이름 사용(변수, 메서드)
- 모듈화
- 적절한 라이브러리 사용

#### 테스트
마지막으로 다음의 순서로 테스트해본다.
- 개념적 테스트: 코드 리뷰하듯이 코드 한줄한줄을 분석한다.
- 특이하거나 표준적이지 않은 코드
    - 배열 인덱스의 범위 설정
- 산술연산 혹은 널(null) 노드와 같이 실수가 날 만한 부분
- 작은 크기의 테스트들.(큰 크기보다 효율적으로 검증 가능)
- 특이하거나 극단적인 입력
    - 배열 입력인 경우 배열이 비어있을 때
    - 참조형 입력인 경우 null이 입력 일 때
    - 입력의 최소값, 최대값
    - ...