# 면접 질문 리스트
> 제가 받았던 질문과 다른 사람들의 질문들을 모았습니다. 질문과 이에 해당하는 답변은 계속해서 추가할 예정입니다.


## 객체지향 프로그래밍(OOP)
- 객체지향 프로그래밍이 무엇인지
- 객체지향 프로그래밍을 하는 이유
- 객체지향 프로그래밍과 절차지향 프로그래밍의 차이
- SOLID 원칙이란?
    - SOLID 원칙을 수행한 경험(프로젝트 관련)
- 객체지향의 대표적인 특징 4가지 설명
    - 추상화
    - 캡슐화
    - 상속
    - 다형성
- 객체지향 생활체조란?
- 디자인 패턴 관련

## 테스트 코드
- 테스트 코드의 장단점
- TDD
- ATDD
- BDD
- 테스트 코드에 대한 경험

## Java
- `final` 사용하는 이유
- Error와 Exception의 차이
- Checked Exception과 Unchecked Exception 차이
- try-with-resources에 대한 설명
- `String`과 `StringBuilder` 차이
- `StringBuilder`와 `StringBuffer` 차이
- `new String()`과 ""의 차이
- Java8에서 추가된 기능
    - Lambda
    - 메서드 래퍼런스
    - Stream API
    - Optional
    - Date Type
- Collection
    - HashMap vs HashTable vs ConcurrentHashMap의 차이
    - Vector와 List 차이
- 롬복(Lombok)이 생성하는 메서드가 어느 시점에서 생성되는 지
- 추상 클래스(abstract class) VS 인터페이스(interface)
- JVM
- GC
- JUnit의 생명주기에 대해 아는지?
- Generic을 쓰는 이유는?
- 접근제어자
- 자바 동기화
- static은 메모리 구조 중 어디에 올라가는지
- 오버로딩과 오버라이딩의 차이

## Spring Framework
- Spring Framework 사용 이유
- Spring에서 DI나 IOC 개념
- Spring에서 Service, Controller, Repository annotation의 차이점
- Controller, RestController 차이점
- Spring에서 서비스와 컴포넌트의 차이
- IoC Container 직접 만든다면 어떻게 구현하실 생각인가요?
- 스프링에서 빈 등록 방법
- Spring MVC 설명
    - Spring MVC 에서 요청이 들어왔을 때부터 응답이 나갈 때까지의 흐름을 설명해주세요.
- ControllerAdvice가 무엇인가요?
- Interceptor와 Filter 차이
- Field 주입과 생성자 주입, Setter 주입
- AOP에 대해 설명해주세요
- Spring VS SpringBoot
- `@Transactional` 동작과정

## JPA
- ORM 설명
- JPA 설명
- `OneToMay` 문제점
- `FetchType` 설명
- N + 1 문제 설명

## 운영체제
- 프로세스와 쓰레드 차이
- 데드락
    - 데드락이 생기는 이유
    - 데드락을 막는 방법
- CPU 스케줄링
- 가상 메모리
- 페이징

## 데이터베이스
- MySQL 엔진
- 인덱스란?
    - 인덱스의 장단점
    - 인덱스의 종류
- 트랜잭션
    - 특징(ACID)
    - 격리수준
- NoSQL
- SQL 인젝션

## 네트워크
- OSI 7 계층

## 자료구조
- 자료구조란?
- Array와 Linked List 차이
- 큐와 스택
- 트리
    - 이진 트리
- 해시
- 그래프

## 알고리즘
- 정렬 알고리즘
    - 각 정렬 알고리즘에 대한 특징, 장단점 비교

## Web
- HTTP
- REST API
- 인증 방식
- 쿠키와 세션 차이
- 브라우저 동작 방식

## 프로젝트
- 프로젝트하면서 어려웠던 점과 이를 극복한 경험
- 프로젝트를 하면서 초기에 설정한 목표와 완전히 다른 방향으로 변경해본 경험
- 팀원과 반대되는 의견이 있을 때 설득해본 경험
- 초기에 설정한 기능을 다 하지 못하고 몇 가지만 집중해본 경험
- 팀원 중에 매우 소극적이고, 하지 않으려는 팀원이 있을 때 설득해본 경험
- 팀원이 꺼려한 일을 해본 경험
- 프로젝트를 하면서 아쉬웠던 점
- 성능을 개선해본 경험


## 웹 백엔드
- 분산된 환경에서 테스트하는 방법
- 분산된 황경에서 로깅하는 방법
- 서버 모니터링 구성
- 서버 부하 테스트
- 아파치
- 엔진엑스
- 로드밸런싱
- 마이크로 서비스와 모놀리틱
- 메시지 큐
- 소켓
- Docker


## 기술 키워드
- 트랜잭션
- OSI 7계층
- 자바 컴파일 과정
- 프로세스, 스레드
- JVM 메모리 구조
- JVM GC
- stop-the-world
- JVM
- Domain
- Call by value, Call by reference
- Statement, PreparedStatement
- Deep copy, Shallow Copy
- Filter, Interceptor
- Enum
- JDBC
- CI, CD
- AOP
- 동기, 비동기
- HTTP 캐싱
- HTTP 쿠키
- 쿠키, 세션
- @ExceptionHandler, @ControllerAdvice
- @Transactional
- 제네릭
- Overriding, Overloading
- ThreadLocal
- 전략 패턴
- 파사드 패턴
- 템플릿 메서드 패턴
- 싱글턴 패턴
- String, StringBuilder, StringBuffer
- 라이브러리, 프레임워크
- HTTP Methods(GET, POST, PUT, DELETE, PATCH, HEAD, OPTIONS)
- equals, hashcode
- 어노테이션
- JPA
- 직렬화
- 암호화(대칭키, 비대칭키)
- Redis
- Argument Resolver
- 인증, 인가
- Spring Data JPA
- 단위 테스트
- @Component, @Bean
- 운영체제
- PSA
- 의존성
- 객체지향
- Daemon Thread
- synchronized
- API
- stream
- lambda
- optional
- 리플렉션
- Bean, BeanFactory
- 추상 클래스, 인터페이스
- 라우터
- SSL
- DNS
- 프로토콜
- SOLID
- bit, byte
- Spring Boot
- Checked Exception, Unchecked Exception
- 동등성, 동일성
- VO, DTO
- Servlet
- Comparable, Comparator
- REST
- DB 인덱싱
- DB 정규화
- OAuth
- CORS
- HTTP, HTTPS
- TCP, UDP
- Reverse Proxy
- JWT
- 해시
- IoC, DI
- N + 1 문제
- 영속성 컨텍스트
- JPA OSIV