# 웹 개발 백과사전
> 웹 개발을 학습하면서 관련 개념에 대해 설명할 수 있을 정도로 정리하는 공간입니다.


## 개요
> 이 공간은 학습 방법 중 하나인 누군가에게 설명하듯이 공부하는 것을 연습하는 곳입니다. 배운 것을 그대로 말하기보다 정리하여 이해하기 쉽고 논리적으로 말하기 위해 노력할 것입니다.

- **말로 표현하지 못하면 아는 것이 아니다.**
- [파인만과 아인슈타인의 일화 - 완벽하게 이해한 후 쉽게 가르쳐라](http://m.blog.daum.net/kdh5029/8289311?tp_nil_a=1)


## 목표
- **학습한 지식을 간단, 명료하게 정리하여 설명할 수 있는 능력**
- **아는 것과 모르는 것 구분하기**
- **기술 인터뷰 준비**
- **복습**


## 용어 사전
- [웹 개발 관련 용어 사전](https://github.com/CODEMCD/web-development-encyclopedia/blob/master/Dictionary/README.md)


## 기술 면접
- [기술 면접 시작하기](https://github.com/CODEMCD/tech-speaking-for-web-developer/blob/master/Tech-Interview/Tech-Interview-start.md)
    - 면접을 위한 자기소개서 작성법
    - 기술 면접에서 평가하는 것
    - 말하기
    - 문제 해결하기(코딩, 설계 등)
- [면접 질문 리스트](https://github.com/CODEMCD/tech-speaking-for-web-developer/blob/master/Tech-Interview/Interview-Question-List.md)


## QnA
- [WEB](https://github.com/CODEMCD/technical-interview-speaking/blob/master/WEB/README.md)
    - Q. Web Server
        - 정적 페이지(Static Page) VS 동적 페이지(Dynamic Page)
        - Web Server VS WAS(Web Application Server)
    - Q. HTTP
    - Q. REST API(Restful API)
    - Q. 쿠키와 세션
    - Q. 인증 방식    
    - Q. CORS(Cross-Origin Resource Sharing)
    - Q. 서버 사이드 렌더링 VS 클라이언트 사이드 렌더링
    - Q. Proxy
- [Backend](https://github.com/CODEMCD/tech-speaking-for-web-developer/blob/master/Backend/README.md)

### Computer Science
- [운영체제](https://github.com/CODEMCD/technical-interview-speaking/blob/master/OS/README.md)
    - Q. 프로세스(Process)와 쓰레드(Thread)
        - Context Switching(문맥 교환)
        - Multi Process VS Multi Thread
    - Q. 프로세스 동기화
        - 임계 영역(Critical Section)
    - Q. 교착상태(DeadLock, 데드락)
    - Q. CPU 스케줄링
    - Q. 페이징
    - Q. 가상 메모리
    - Q. 캐시 메모리(Cache Memory)
- [데이터베이스](https://github.com/CODEMCD/technical-interview-speaking/blob/master/Database/README.md)
    - Q. 스토리지 엔진
    - Q. 인덱스(Index)
    - Q. 트랜잭션(Transaction)
    - Q. SQL Injection
    - Q. NoSQL
- [네트워크](https://github.com/CODEMCD/tech-speaking-for-web-developer/blob/master/Network/README.md)
- [자료구조](https://github.com/CODEMCD/technical-interview-speaking/blob/master/DataStructure/README.md)
    - Q. 자료구조란?
    - Q. Array VS Linked List
    - Q. 큐(Queue)와 스택(Stack)
    - Q. 트리(Tree)
    - Q. Hash Table
    - Q. 그래프(Graph)
- [알고리즘](https://github.com/CODEMCD/technical-interview-speaking/blob/master/Algorithm/README.md)
    - Q. 정렬 알고리즘

### Language
- [공통 질문](https://github.com/CODEMCD/technical-interview-speaking/blob/master/LanguageCommon/README.md)
    - Q. Call By Value VS Call By Reference
    - Q. 얕은 복사(Shallow Copy) VS 깊은 복사(Deep Copy)
    - Q. 기본 자료형(primitive data type)과 참조 자료형(reference data type)
    - Q. 동일성과 동등성
- [JAVA](https://github.com/CODEMCD/technical-interview-speaking/blob/master/JAVA/README.md)
    - Q. Java
        - 자바 실행 과정
        - GC(Garbage Collector, 가비지 컬렉터)
    - Q. `final` 키워드
    - Q. Error와 Exception
        - Checked Exception과 Unchecked Exception 차이
    - Q. 문자열 클래스
        - String 클래스
        - StringBuilder VS StringBuffer
    - Q. Java8
        - Lambda Expressions
        - Stream API
        - Optional
    - Q. Collection
    - Q. 추상 클래스(abstract class)와 인터페이스(interface)
    - Q. Generic(제네릭)
    - Q. 롬복(Lombok)이 생성하는 메서드가 만들어지는 시점
    - Q. Enum
    - Q. Thread
        - DaemonThread
        - `synchronized`
        - ThreadLocal
    - Q. `equals`, `hashCode`
    - Q. Annotation
    - Q. 직렬화
    - Q. Reflection
    - Q. `Comparable`과 `Comparator`
    - Q. Gradle
- [C++](https://github.com/CODEMCD/tech-speaking-for-web-developer/blob/master/CPP/README.md)
    - Q. C++ VS Java
- [Javascript](https://github.com/CODEMCD/technical-interview-speaking/blob/master/Javascript/README.md)
    - Q. 기본 문법
    - Q. ES6(ECMAScript 6)

### Software Engineering
- [객체지향 프로그래밍](https://github.com/CODEMCD/technical-interview-speaking/blob/master/OOP/README.md)
    - Q. 객체지향 프로그래밍(OOP)이란?
    - Q. 책임(Responsibility)
    - Q. 클래스(Class) VS 인스턴스(Instance)
    - Q. 추상화(Abstraction)
    - Q. 캡슐화(Encapsulation)
    - Q. 상속(Inheritance)
    - Q. 다형성(Polymorphism)
    - Q. SOLID 원칙
    - Q. 객체지향 생활체조
- [테스트 코드](https://github.com/CODEMCD/tech-speaking-for-web-developer/blob/master/TestCode/README.md)
    - Q. 테스트 코드의 장단점
    - Q. 좋은 테스트 코드
    - Q. TDD(Test-Driven Development)
         - ATDD(Acceptance Test Driven Development)
    - Q. Spring Boot를 활용한 API 서버 테스트 코드
- [Git](https://github.com/CODEMCD/web-development-encyclopedia/blob/master/Git/README.md)

### Framework
- [Spring Framework](https://github.com/CODEMCD/technical-interview-speaking/blob/master/SpringFramework/README.md)
    - Q. Spring Framework란?
    - Q. Spring IoC 컨테이너
    - Q. Spring Bean
    - Q. Bean Factory VS Application Context
    - Q. Spring MVC
    - Q. AOP
    - Q. Spring Framework VS Spring Boot
- [JPA](https://github.com/CODEMCD/tech-speaking-for-web-developer/blob/master/JPA/README.md)
    - Q. JPA(Java Persistence API)란?
        - ORM(Object-Relation Mapping)
    - Q. 영속성 컨텍스트
- [Vue.js]()


## Reference
- [코딩 인터뷰 완전 분석[책]](http://www.kyobobook.co.kr/product/detailViewKor.laf?ejkGb=KOR&mallGb=KOR&barcode=9788966263080&orderClick=LAG&Kc=)
- [면접왕 이형[유튜브]](https://www.youtube.com/channel/UCp-C7mtkuOw6q8E1Uc2NVpQ)
- [Technical Interview Guidelines for Beginners[Github]](https://github.com/JaeYeopHan/Interview_Question_for_Beginner)
- [신입 개발자 전공 지식 & 기술 면접 백과사전[Github]](https://github.com/gyoogle/tech-interview-for-developer)
- [tech-refrigerator[Github]](https://github.com/GimunLee/tech-refrigerator)
- [Ready-For-Tech-Interview[Github]](https://github.com/WooVictory/Ready-For-Tech-Interview)
- [tech-interview-for-developer[Github]](https://github.com/Conatuseus/tech-interview-for-developer)
- [Heee's Development Blog](https://gmlwjd9405.github.io/)