# 언어 관련 공통 질문

## 목차
- [Q. Call By Value VS Call By Reference](#q-call-by-value-vs-call-by-reference)
- [Q. 얕은 복사(Shallow Copy) VS 깊은 복사(Deep Copy)](#q-얕은-복사shallow-copy-vs-깊은-복사deep-copy)
- [Q. 기본 자료형(primitive data type)과 참조 자료형(reference data type)](#q-기본-자료형primitive-data-type과-참조-자료형reference-data-type)
- [Q. 동일성과 동등성](#q-동일성과-동등성)

## Q. Call By Value VS Call By Reference
함수를 호출할 때 매개변수로 전달되는 값의 종류에 따라 call by value, call by reference로 나뉩니다. value는 원본 값을 그대로 복사하므로, caller 함수에서의 변화가 원본에 영향을 미칠 수 없습니다. 반면에 reference는 원본의 주소값을 복사하여 전달하므로, caller 함수에서 원본에 영향을 줄 수 있습니다.

### 원본의 값과 주소가 각각 미치는 영향
매개변수는 함수를 호출하면 새로운 스택 메모리에 할당됩니다. 따라서 원본과는 전혀 다른 메모리 공간에 할당되는 다른 지역변수로 동작합니다. 만약 매개변수에 원본의 value를 가지고 있다면, 원본과는 전혀 관계가 없는 단순히 원본 값을 가지고 있는 변수일 뿐입니다. 하지만 매개변수에 원본의 주소값을 가지고 있다면, 이는 원본에 접근을 할 수 있게 됩니다.

### Java는 call by value? call by reference?
Java는 call by value만 가능하다고 생각합니다. 이는 원본에 대한 제 생각때문입니다. 원본은 선언된 자료형에 따라 할당된 값입니다. 특히 변수에 객체를 선언하면 그 변수는 객체의 시작 주소값을 갖고 있습니다. 원본이 변경된다는 것은 이 할당된 객체의 주소값이 변경되는 것이지, 객체 내부의 다른 데이터가 변경되는 것은 아니라고 생각합니다. 이를 바탕으로 보면 Java는 call by reference를 할 수 없습니다. 왜냐하면 원본의 주소를 추출하고 저장할 자료형을 제공하지 않기 때문입니다. 반면에 C/C++는 포인터를 통해 주소를 추출하고 저장할 수 있기 때문에 call by reference가 가능합니다.

### Reference
- [Call By Value VS Call By Reference](https://velog.io/@codemcd/Call-By-Value-VS-Call-By-Reference)


## Q. 얕은 복사(Shallow Copy) VS 깊은 복사(Deep Copy)
얕은 복사는 단순히 지정된 값만 복사하는 것이고, 깊은 복사는 지정된 값이 주소값인 경우, 이를 참조하고 있는 모든 값을 복사하는 것입니다.

얕은 복사의 문제점은 주소값(참조형)을 얕은 복사하는 경우 단순히 주소값이 복사되므로 실제로 가리키고 있는 원본 데이터는 공유합니다. 이는 한 쪽의 변경이 다른 쪽에서도 변경되어 의도하지 않는 예외 사항이 발생할 수 있습니다. 이를 해결하기 위해 깊은 복사를 통해 참조된 데이터까지 모두 복사하여, 원본 데이터와 완전히 분리하는 것입니다.

### 얕은 복사의 문제점 실제 사례
C++에서는 복사 생성자로 객체를 얕은 복사를 하는 경우, 삭제 시 문제가 발생합니다. 왜냐하면 원본과 복사본이 같은 데이터를 가리키고 있는데, 둘 중 하나가 먼저 해제되면, 그 다음에 해제될 데이터가 사라지기 때문입니다.

Java에서는 객체 내부의 멤버 변수로 `LinkedList`와 같은 컬렉션이 있을 때 외부에서 단순히 `=`으로 복사하는 경우, 외부에서 이 컬렉션의 데이터를 변경하면, 객체 내부 멤버 변수도 같이 변경되는 문제가 발생합니다.


## Q. 기본 자료형(primitive data type)과 참조 자료형(reference data type)
기본 자료형은 대부분의 언어에서 기본적으로 제공하는 자료형을 말합니다. Java로 예를 들면 `int, long, double, float, boolean, char, byte` 등이 있습니다.

참조 자료형은 주소를 갖고 있는 자료형입니다. 대부분 객체를 생성하여 해당 객체의 주소값을 가지고 있는 변수를 말합니다. 


## Q. 동일성과 동등성
기본 자료형의 비교에서는 동일성과 동등성을 나누지는 않습니다. 대부분의 언어에서 `==`와 같은 연산자를 사용합니다.

참조 자료형의 비교는 동일성과 동등성을 나눕니다. 왜냐하면 자료형이 실제 가지고 있는 주소값과 그 내용으로 나뉘기 때문입니다.
- 동일성: 두 객체의 **주소값이 같으면** 동일하다고 합니다.
- 동등성: 두 객체의 **내용이 같으면** 동등하다고 합니다.