# 용어사전
> 개발을 하다보면 수 많은 용어에 휩싸이게 된다. 용어를 통일하는 것은 의사소통하는데 매우 중요하다는 생각을 한다. 따라서 웹 개발을 하며 마주하게 된 용어들을 정리해보려고 한다.

- 영어 알파벳 순서

## Index
- [A](#a)
    - [Architecture(아키텍처)](#architecture아키텍처)
- [B](#b)
- [C](#c)
    - [Capacity(용량)](#capacity용량)
- [D](#d)
    - [Degradation(성능 저하)](#degradation성능-저하)
- [E](#e)
    - [Enterprise Application(엔터프라이즈 애플리케이션)](#enterprise-application엔터프라이즈-애플리케이션)
    - [Efficiency(효율)](#efficiency효율)
- [F](#f)
- [G](#g)
- [H](#h)
- [I](#i)
- [J](#j)
- [K](#k)
- [L](#l)
    - [Latency(대기 시간)](#latency대기-시간)
    - [Load(부하)](#load부하)
    - [Load Sensitivity(부하 민감도)](#load-sensitivity부하-민감도)
- [M](#m)
- [N](#n)
- [O](#o)
- [P](#p)
    - [Performance(성능)](#performance성능)
- [Q](#q)
- [R](#r)
    - [Response Time(응답 시간)](#response-time응답-시간)
    - [Responsiveness(응답성)](#responsiveness응답성)
- [S](#s)
    - [Scalability(확장성)](#scalability확장성)
- [T](#t)
    - [Throughput(처리량)](#throughput처리량)
- [U](#u)
- [V](#v)
- [W](#w)
- [X](#x)
- [Y](#y)
- [Z](#z)
- [Reference](#reference)


## A
#### Architecture(아키텍처)


## B
## C
#### Capacity(용량)
시스템의 용량은 최대 유효 처리량 또는 부하를 의미한다.


## D
#### Degradation(성능 저하)


## E
#### Enterprise Application(엔터프라이즈 애플리케이션)
일반적으로 지속적 데이터(persistent data)를 처리하는 애플리케이션을 엔터프라이즈 애플리케이션이라 부른다.(같은 의미로 정보 시스템 또는 데이터 프로세싱이라고도 함) 데이터가 지속적이라는 의미는 프로그램이 여러 번 실행하더라도 데이터를 유지해야 하며, 이 기간은 최소 몇 년일 수도 있다. 이 기간동안 데이터는 변경될 수 있고, 데이터 구조 자체가 변경될 수도 있다. 그리고 일반적으로 많은 양의 데이터를 처리한다.

엔터프라이즈 애플라케이션은 비즈니스 로직에 따른 데이터를 처리한다. 따라서 사업의 크기가 클수록 많은 사람이 동시에 접속하여 데이터에 접근하고, 많은 사용자 인터페이스 화면을 갖는다. 엔터프라이즈 애플리케이션의 종류는 급여 관리, 환자 기록, 배송 추적, 비용 분석, 신용 점수, 보험, 공급망, 회계, 고객 서비스, 외환 거래 등 매우 다양하다.

#### Efficiency(효율)
성능을 자원으로 나눈 것이다. 예를 들어 자원은 CPU, 성능은 tps로 계산할 수 있다.


## F
#### Factory(팩토리)
Factory(팩토리)는 객체의 생성 방법을 결정하고 그렇게 만들어진 오브젝트를 돌려주는 역할을 하는 클래스이다.

디자인 패턴에서 말하는 특별한 문제를 해결하기 위해 사용되는 추상 팩토리 패턴이나 팩토리 메소드 패턴과는 다르니 혼동하지 말자.

#### Framework(프레임워크)


## G
## H
#### High coherence and low coupling(높은 응집력와 낮은 결합도)
높은 응집력와 낮은 결합도는 소프트웨어 개발의 고전적인 원리 중 하나다. 응집도가 높다는 건 하나의 모듈, 클래스가 하나의 책임 또는 관심사에만 집중되어 있다는 뜻이다. 불필요하거나 직접 관련이 없는 외부의 관심과 책임이 얽혀 있지 않으며, 하나의 공통 관심사는 한 클래스에 모여 있다. 높은 응집도는 클래스 레벨뿐 아니라, 패키지, 컴포넌트, 모듈에 이르기까지 그 대상의 크기가 달라도 동일한 원리로 적용될 수 있다.


## I
#### Inversion Of Control(제어의 역전)
Inversion Of Control이란 간단히 말하면 프로그램의 제어 흐름 구조가 뒤바뀌는 것이다. 프로그램의 제어 흐름은 일반적으로 `main()` 메소드에서 시작한다. 그리고 모든 오브젝트는 능동적으로 자신이 사용할 오브젝트를 결정하고, 만든다. 하지만 제어의 역전에서는 이런 제어 흐름을 뒤집는 것이다. 오브젝트가 자신이 사용할 오브젝트를 스스로 선택하지 않고, 생성하지도 않는다.

이러한 제어의 역전 개념은 소프트웨어에서 많이 사용된다. 대표적으로 프레임워크는 제어의 역전이 적용된 기술이다. 그 중 자바에서는 서블릿, 스프링 프레임워크가 있다. 또한 디자인 패턴 중에서 템플릿 메서드 패턴은 제어의 역전을 활용한 패턴이다.


## J
## K
## L
#### Latency(대기 시간)
수행할 작업의 종류 및 개수와 상관없이 모든 유형의 응답을 받는 데 걸리는 시간이다. 대기 시간은 일반적으로 네트워크를 통하는 원격 시스템과 연관이 깊다. 애플리케이션 개발자가 대기 시간을 줄이기 위해서는 원격 호출을 최소화하는 것 말고는 할 수 있는 일은 없다.

#### Load(부하)
시스템이 현재 처리하고 있는 작업량을 의미하고 현재 연결된 사용자 수로 측정할 수 있다. 일반적으로 부하는 응답 시간 등의 다른 측정치의 맥락에서 사용된다. 예를 들어, 어떤 요청의 응답 시간이 사용자가 10명일 때, 0.5초이고 20명일 때 2초라고 말할 수 있다.

#### Load Sensitivity(부하 민감도)
부하에 따른 응답 시간의 변화를 나타내는 말이다. 예를 들어, 시스템 A는 사용자가 10~20명 범위에서 응답 시간이 0.5초로 변함이 없는 반면, 시스템 B는 사용자가 10명일 때 응답 시간이 0.2초지만 사용자가 20명일 때는 응답 시간이 2초로 증가한다. 이 경우 시스템 A는 시스템 B보다 부하 민감도가 낮다.(시스템 B가 시스템 A보다 성능 저하가 심하다.)


## M
## N
## O
## P
#### Performance(성능)
처리량이나 응답 시간 중 시스템에 따라 더 중요하게 생각되는 항목을 의미한다. 성능은 개발자 관점과 사용자 관점이 다를 수도 있다.


## Q
## R
#### Response Time(응답 시간)
시스템이 외부에서 받은 요청을 처리하는 데 걸리는 전체 시간이다. 여기서 요청은 버튼 누르기와 같은 UI 동작이나 서버 API 호출 등이다.

#### Responsiveness(응답성)
시스템이 요청을 얼마나 신속하게 인식하느냐이다. 요청을 처리하는 시간이 짧더라도 요청을 인식하는 데 오래 걸리면 사용자가 답답하게 느낄 수 있다. 만약 요청을 처리하는 동안 시스템이 대기한다면 응답성과 응답 시간은 같다. 반면에 요청이 완료되기 전에 요청을 인식했음을 사용자에게 알리면 응답성이 개선되는 것이다. 예를 들어 파일을 복사하는 동안 사용자에게 상태표시줄을 보여주면 응답 시간은 그대로이지만 사용자 인터페이스의 응답성이 개선된다.


## S
#### Scalability(확장성)
리소스(주로 하드웨어)를 추가했을 때 성능에 미치는 양향을 의미한다. 확장형 시스템은 서버를 두 배늘렸을 때 처리량이 두 배가 될 수 있는 시스템을 말한다. Vertical Scalability(수직 확장성)는 단일 서버에 메모리와 같은 사양을 증가시키는 것이고, Horizontal Scalability(수평 확장성)는 서버를 더 추가하는 것을 말한다.

#### SOLID(객체지향 설계 원칙)

#### Strategy Pattern(전략 패턴)
전략 패턴은 자신의 기능 맥락(context)에서, 필요에 따라 변경이 필요한 알고리즘을 인터페이스를 통해 통째로 외부로 분리시키고, 이를 구현한 구체적인 알고리즘 클래스를 필요에 따라 바꿔서 사용할 수 있게 하는 디자인 패턴이다. 여기서 말하는 알고리즘이란 거창한 수학적 알고리즘을 말하는 게 아니고, 독립적인 책임으로 분리가 가능한 기능을 뜻한다. 이를 대체 가능한 전략이라고 보기 때문에 패턴의 이름이 전략 패턴이다.


## T
#### Throughput(처리량)
일정한 시간 동안 얼마나 많은 일을 할 수 있는지 측정한 것이다. 엔터프라이즈 애플리케이션에서 일반적인 측정치는 초당 트랜잭션(tps)이지만 이 값은 트랜잭션의 복잡도에 따라 다른 의미를 가진다.


## U
## V
## W
## X
## Y
## Z


## Reference
- [엔터프라이즈 애플리케이션 아키텍처 패턴 - 마틴 파울러 지음](http://www.kyobobook.co.kr/product/detailViewKor.laf?ejkGb=KOR&mallGb=KOR&barcode=9791158390174&orderClick=LEA&Kc=)
- [토비의 스프링 3.1](http://www.kyobobook.co.kr/product/detailViewKor.laf?ejkGb=KOR&mallGb=KOR&barcode=9788960773431&orderClick=LAG&Kc=)