# Github Issue or Trello Card
This PR addresses this issue: 

# What type of change is this?
Please delete options that are not relevant.

- [ ] Bug fix (non-breaking change which fixes an issue)
- [ ] New feature (non-breaking change which adds functionality)
- [ ] Breaking change (fix or feature that would cause existing functionality to not work as expected)
- [ ] Updating documentation.
- [ ] Updating deployment/build pipeline.
- [ ] Updating Project Dependencies
- [ ] Improving or adding to Test Coverage

# Completeness Checklist

- [ ] TESTS: My changes maintain the baseline required test coverage, as specified by code climate analysis.
- [ ] DOCS: All new component work is covered in that component's `Overview` docs.
- [ ] DOCS: All new component work is covered in a component `Playground`.
- [ ] DOCS: All new visual changes or options are covered under relevant components' `VisualTests`.
- [ ] My code has no linting or typescript compile warnings.
- [ ] My work is tied to a Github issue and satisfies the acceptance criteria (if applicable) of the corresponding issue.

# Quality Checklist:

- [ ] My code follows the style guidelines of this project
- [ ] I have performed a self-review of my own code
- [ ] I have commented my code, particularly in hard-to-understand areas
- [ ] I have made corresponding changes to the documentation
- [ ] My changes generate no new warnings
- [ ] I have added tests that prove my fix is effective or that my feature works
- [ ] New and existing unit tests pass locally with my changes

# UI Checklist
- [ ] I have conducted visual UAT on my changes/features.
- [ ] My solution works well on desktop, tablet, and mobile browsers.