# Status report

Since it launched on March 22, 2022, this site has archived 11,516,637 assets from 1,172 news homepages.

<script src="https://cdn.jsdelivr.net/npm/d3@7"></script>
<script src="https://cdn.jsdelivr.net/npm/@observablehq/plot@0.6"></script>

<div id="sites-by-date"></div>

## Cropped screenshots

1,762,752 cropped screenshots have been saved.

<div id="cropped-screenshots-by-date"></div>

## Full screenshots

1,294,322 full-page screenshots have been saved.

<div id="full-screenshots-by-date"></div>

## Accessibility trees

1,730,302 accessibility trees have been saved.

<div id="accessibility-by-date"></div>

## Hyperlink lists

1,752,273 hyperlink lists have been saved.

<div id="hyperlinks-by-date"></div>

## Lighthouse audits

1,681,788 Lighthouse audits have been saved.

<div id="lighthouse-by-date"></div>

## Wayback Machine archive requests

1,672,879 save requests have been made with the Internet Archive's Wayback Machine.

<div id="wayback-by-date"></div>

## robots.txt

792,666 robots.txt files have been saved.

<div id="robotstxt-by-date"></div>

<script type="module">
function prepData(data) {
    return data.map(d => {
        d['date'] = new Date(d.date);
        return d;
    })
}
function drawChart(attr, id, label) {
    const plot = Plot.plot({
        x: { label: null },
        y: { label: label },
        marks: [
            Plot.ruleY([0]),
            Plot.areaY(
                data,
                Plot.windowY(
                    7,
                    {
                        x: "date",
                        y: attr,
                        fill: "gray",
                        fillOpacity: 0.2
                    }
                )
            ),
            Plot.lineY(data,
                Plot.windowY(
                    7,
                    {
                        x: "date",
                        y: attr,
                        fillOpacity: 1,
                        strokeWidth: 2,
                        stroke: "gray"
                    }
                )
            )
        ]
    })
    const div = document.querySelector(id);
    div.append(plot);
}
const data = prepData([{"date": "2022-03-22", "sites": 1, "cropped_screenshots": 2, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 0.0, "hyperlinks": 0.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-03-23", "sites": 46, "cropped_screenshots": 112, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 0.0, "hyperlinks": 0.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-03-24", "sites": 49, "cropped_screenshots": 106, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 0.0, "hyperlinks": 0.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-03-25", "sites": 72, "cropped_screenshots": 151, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 0.0, "hyperlinks": 0.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-03-26", "sites": 70, "cropped_screenshots": 125, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 0.0, "hyperlinks": 0.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-03-27", "sites": 74, "cropped_screenshots": 121, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 0.0, "hyperlinks": 0.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-03-28", "sites": 79, "cropped_screenshots": 126, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 0.0, "hyperlinks": 0.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-03-29", "sites": 72, "cropped_screenshots": 137, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 0.0, "hyperlinks": 0.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-03-30", "sites": 49, "cropped_screenshots": 93, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 81.0, "hyperlinks": 6.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-03-31", "sites": 61, "cropped_screenshots": 107, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 106.0, "hyperlinks": 105.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-04-01", "sites": 79, "cropped_screenshots": 123, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 123.0, "hyperlinks": 123.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-04-02", "sites": 61, "cropped_screenshots": 118, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 118.0, "hyperlinks": 118.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-04-03", "sites": 27, "cropped_screenshots": 58, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 58.0, "hyperlinks": 58.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-04-04", "sites": 82, "cropped_screenshots": 144, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 142.0, "hyperlinks": 142.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-04-05", "sites": 76, "cropped_screenshots": 133, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 133.0, "hyperlinks": 133.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-04-06", "sites": 87, "cropped_screenshots": 146, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 146.0, "hyperlinks": 146.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-04-07", "sites": 86, "cropped_screenshots": 144, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 145.0, "hyperlinks": 146.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-04-08", "sites": 87, "cropped_screenshots": 131, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 132.0, "hyperlinks": 132.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-04-09", "sites": 96, "cropped_screenshots": 155, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 154.0, "hyperlinks": 156.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-04-10", "sites": 95, "cropped_screenshots": 153, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 156.0, "hyperlinks": 156.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-04-11", "sites": 96, "cropped_screenshots": 155, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 155.0, "hyperlinks": 156.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-04-12", "sites": 97, "cropped_screenshots": 156, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 156.0, "hyperlinks": 156.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-04-13", "sites": 96, "cropped_screenshots": 154, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 156.0, "hyperlinks": 156.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-04-14", "sites": 97, "cropped_screenshots": 141, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 141.0, "hyperlinks": 141.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-04-15", "sites": 99, "cropped_screenshots": 152, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 151.0, "hyperlinks": 152.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-04-16", "sites": 99, "cropped_screenshots": 167, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 167.0, "hyperlinks": 168.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-04-17", "sites": 87, "cropped_screenshots": 156, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 157.0, "hyperlinks": 157.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-04-18", "sites": 97, "cropped_screenshots": 164, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 167.0, "hyperlinks": 168.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-04-19", "sites": 88, "cropped_screenshots": 142, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 141.0, "hyperlinks": 142.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-04-20", "sites": 99, "cropped_screenshots": 153, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 152.0, "hyperlinks": 153.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-04-21", "sites": 98, "cropped_screenshots": 148, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 149.0, "hyperlinks": 149.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-04-22", "sites": 99, "cropped_screenshots": 153, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 153.0, "hyperlinks": 153.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-04-23", "sites": 99, "cropped_screenshots": 166, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 165.0, "hyperlinks": 166.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-04-24", "sites": 98, "cropped_screenshots": 166, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 168.0, "hyperlinks": 168.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-04-25", "sites": 96, "cropped_screenshots": 148, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 148.0, "hyperlinks": 148.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-04-26", "sites": 95, "cropped_screenshots": 161, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 161.0, "hyperlinks": 162.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-04-27", "sites": 98, "cropped_screenshots": 164, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 165.0, "hyperlinks": 166.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-04-28", "sites": 87, "cropped_screenshots": 157, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 158.0, "hyperlinks": 158.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-04-29", "sites": 99, "cropped_screenshots": 159, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 162.0, "hyperlinks": 162.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-04-30", "sites": 95, "cropped_screenshots": 161, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 161.0, "hyperlinks": 161.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-05-01", "sites": 96, "cropped_screenshots": 162, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 163.0, "hyperlinks": 163.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-05-02", "sites": 99, "cropped_screenshots": 165, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 166.0, "hyperlinks": 166.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-05-03", "sites": 99, "cropped_screenshots": 160, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 161.0, "hyperlinks": 161.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-05-04", "sites": 97, "cropped_screenshots": 161, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 164.0, "hyperlinks": 164.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-05-05", "sites": 97, "cropped_screenshots": 163, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 165.0, "hyperlinks": 166.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-05-06", "sites": 99, "cropped_screenshots": 161, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 161.0, "hyperlinks": 162.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-05-07", "sites": 94, "cropped_screenshots": 153, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 158.0, "hyperlinks": 159.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-05-08", "sites": 96, "cropped_screenshots": 157, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 157.0, "hyperlinks": 162.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-05-09", "sites": 98, "cropped_screenshots": 138, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 139.0, "hyperlinks": 140.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-05-10", "sites": 94, "cropped_screenshots": 154, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 154.0, "hyperlinks": 158.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-05-11", "sites": 75, "cropped_screenshots": 107, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 108.0, "hyperlinks": 109.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-05-12", "sites": 98, "cropped_screenshots": 135, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 137.0, "hyperlinks": 138.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-05-13", "sites": 96, "cropped_screenshots": 134, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 133.0, "hyperlinks": 138.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-05-14", "sites": 94, "cropped_screenshots": 153, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 151.0, "hyperlinks": 157.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-05-15", "sites": 96, "cropped_screenshots": 135, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 140.0, "hyperlinks": 140.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-05-16", "sites": 83, "cropped_screenshots": 131, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 129.0, "hyperlinks": 131.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-05-17", "sites": 82, "cropped_screenshots": 132, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 135.0, "hyperlinks": 137.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-05-18", "sites": 77, "cropped_screenshots": 118, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 120.0, "hyperlinks": 122.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-05-19", "sites": 77, "cropped_screenshots": 116, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 116.0, "hyperlinks": 117.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-05-20", "sites": 85, "cropped_screenshots": 122, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 123.0, "hyperlinks": 126.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-05-21", "sites": 99, "cropped_screenshots": 166, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 167.0, "hyperlinks": 168.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-05-22", "sites": 97, "cropped_screenshots": 150, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 152.0, "hyperlinks": 153.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-05-23", "sites": 89, "cropped_screenshots": 149, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 152.0, "hyperlinks": 152.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-05-24", "sites": 93, "cropped_screenshots": 148, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 148.0, "hyperlinks": 152.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-05-25", "sites": 89, "cropped_screenshots": 143, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 142.0, "hyperlinks": 145.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-05-26", "sites": 88, "cropped_screenshots": 145, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 140.0, "hyperlinks": 146.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-05-27", "sites": 90, "cropped_screenshots": 133, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 128.0, "hyperlinks": 130.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-05-28", "sites": 74, "cropped_screenshots": 107, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 106.0, "hyperlinks": 105.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-05-29", "sites": 91, "cropped_screenshots": 145, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 145.0, "hyperlinks": 145.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-05-30", "sites": 99, "cropped_screenshots": 160, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 161.0, "hyperlinks": 161.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-05-31", "sites": 99, "cropped_screenshots": 160, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 161.0, "hyperlinks": 162.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-06-01", "sites": 85, "cropped_screenshots": 124, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 122.0, "hyperlinks": 126.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-06-02", "sites": 99, "cropped_screenshots": 121, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 119.0, "hyperlinks": 121.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-06-03", "sites": 89, "cropped_screenshots": 151, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 147.0, "hyperlinks": 151.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-06-04", "sites": 99, "cropped_screenshots": 159, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 160.0, "hyperlinks": 161.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-06-05", "sites": 80, "cropped_screenshots": 130, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 128.0, "hyperlinks": 130.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-06-06", "sites": 76, "cropped_screenshots": 124, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 126.0, "hyperlinks": 126.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-06-07", "sites": 97, "cropped_screenshots": 153, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 150.0, "hyperlinks": 154.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-06-08", "sites": 71, "cropped_screenshots": 118, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 123.0, "hyperlinks": 123.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-06-09", "sites": 99, "cropped_screenshots": 161, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 160.0, "hyperlinks": 163.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-06-10", "sites": 75, "cropped_screenshots": 120, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 120.0, "hyperlinks": 122.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-06-11", "sites": 100, "cropped_screenshots": 147, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 145.0, "hyperlinks": 148.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-06-12", "sites": 97, "cropped_screenshots": 149, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 151.0, "hyperlinks": 152.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-06-13", "sites": 94, "cropped_screenshots": 148, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 154.0, "hyperlinks": 157.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-06-14", "sites": 81, "cropped_screenshots": 137, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 136.0, "hyperlinks": 137.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-06-15", "sites": 70, "cropped_screenshots": 135, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 138.0, "hyperlinks": 140.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-06-16", "sites": 80, "cropped_screenshots": 124, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 125.0, "hyperlinks": 125.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-06-17", "sites": 104, "cropped_screenshots": 409, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 399.0, "hyperlinks": 403.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-06-18", "sites": 112, "cropped_screenshots": 645, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 627.0, "hyperlinks": 629.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-06-19", "sites": 147, "cropped_screenshots": 818, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 799.0, "hyperlinks": 793.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-06-20", "sites": 148, "cropped_screenshots": 881, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 866.0, "hyperlinks": 869.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-06-21", "sites": 148, "cropped_screenshots": 740, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 729.0, "hyperlinks": 726.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-06-22", "sites": 148, "cropped_screenshots": 434, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 438.0, "hyperlinks": 433.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-06-23", "sites": 148, "cropped_screenshots": 443, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 440.0, "hyperlinks": 440.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-06-24", "sites": 199, "cropped_screenshots": 627, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 620.0, "hyperlinks": 626.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-06-25", "sites": 199, "cropped_screenshots": 723, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 786.0, "hyperlinks": 789.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-06-26", "sites": 199, "cropped_screenshots": 596, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 582.0, "hyperlinks": 584.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-06-27", "sites": 201, "cropped_screenshots": 575, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 571.0, "hyperlinks": 572.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-06-28", "sites": 199, "cropped_screenshots": 798, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 824.0, "hyperlinks": 824.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-06-29", "sites": 200, "cropped_screenshots": 1045, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 1044.0, "hyperlinks": 1041.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-06-30", "sites": 221, "cropped_screenshots": 1484, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 1482.0, "hyperlinks": 1476.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-07-01", "sites": 221, "cropped_screenshots": 569, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 566.0, "hyperlinks": 565.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-07-02", "sites": 221, "cropped_screenshots": 565, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 561.0, "hyperlinks": 562.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-07-03", "sites": 230, "cropped_screenshots": 578, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 572.0, "hyperlinks": 574.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-07-04", "sites": 303, "cropped_screenshots": 992, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 983.0, "hyperlinks": 986.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-07-05", "sites": 303, "cropped_screenshots": 747, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 742.0, "hyperlinks": 739.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-07-06", "sites": 306, "cropped_screenshots": 725, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 721.0, "hyperlinks": 720.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-07-07", "sites": 309, "cropped_screenshots": 747, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 721.0, "hyperlinks": 729.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-07-08", "sites": 311, "cropped_screenshots": 814, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 782.0, "hyperlinks": 790.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-07-09", "sites": 410, "cropped_screenshots": 1000, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 975.0, "hyperlinks": 970.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-07-10", "sites": 418, "cropped_screenshots": 983, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 950.0, "hyperlinks": 934.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-07-11", "sites": 418, "cropped_screenshots": 1013, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 980.0, "hyperlinks": 939.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-07-12", "sites": 421, "cropped_screenshots": 998, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 968.0, "hyperlinks": 941.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-07-13", "sites": 428, "cropped_screenshots": 1058, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 1045.0, "hyperlinks": 1043.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-07-14", "sites": 428, "cropped_screenshots": 1016, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 1001.0, "hyperlinks": 988.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-07-15", "sites": 428, "cropped_screenshots": 1048, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 1035.0, "hyperlinks": 1027.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-07-16", "sites": 435, "cropped_screenshots": 1047, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 1037.0, "hyperlinks": 1027.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-07-17", "sites": 457, "cropped_screenshots": 1066, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 1050.0, "hyperlinks": 1050.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-07-18", "sites": 507, "cropped_screenshots": 1121, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 1104.0, "hyperlinks": 1095.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-07-19", "sites": 510, "cropped_screenshots": 1170, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 1165.0, "hyperlinks": 1153.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-07-20", "sites": 552, "cropped_screenshots": 1252, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 1247.0, "hyperlinks": 1233.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-07-21", "sites": 558, "cropped_screenshots": 1279, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 1268.0, "hyperlinks": 1248.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-07-22", "sites": 560, "cropped_screenshots": 1293, "full_screenshots": 0.0, "lighthouse": 0.0, "accessibility": 1289.0, "hyperlinks": 1278.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-07-23", "sites": 566, "cropped_screenshots": 1385, "full_screenshots": 0.0, "lighthouse": 180.0, "accessibility": 1374.0, "hyperlinks": 1366.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-07-24", "sites": 599, "cropped_screenshots": 1226, "full_screenshots": 0.0, "lighthouse": 1228.0, "accessibility": 1188.0, "hyperlinks": 1153.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-07-25", "sites": 615, "cropped_screenshots": 1581, "full_screenshots": 0.0, "lighthouse": 1590.0, "accessibility": 1560.0, "hyperlinks": 1538.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-07-26", "sites": 650, "cropped_screenshots": 1592, "full_screenshots": 0.0, "lighthouse": 1588.0, "accessibility": 1567.0, "hyperlinks": 1565.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-07-27", "sites": 660, "cropped_screenshots": 1424, "full_screenshots": 0.0, "lighthouse": 1422.0, "accessibility": 1400.0, "hyperlinks": 1396.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-07-28", "sites": 675, "cropped_screenshots": 1530, "full_screenshots": 0.0, "lighthouse": 1530.0, "accessibility": 1518.0, "hyperlinks": 1508.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-07-29", "sites": 676, "cropped_screenshots": 1430, "full_screenshots": 0.0, "lighthouse": 1428.0, "accessibility": 1409.0, "hyperlinks": 1394.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-07-30", "sites": 684, "cropped_screenshots": 1660, "full_screenshots": 0.0, "lighthouse": 1657.0, "accessibility": 1631.0, "hyperlinks": 1626.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-07-31", "sites": 679, "cropped_screenshots": 1403, "full_screenshots": 0.0, "lighthouse": 1406.0, "accessibility": 1374.0, "hyperlinks": 1382.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-08-01", "sites": 692, "cropped_screenshots": 1714, "full_screenshots": 0.0, "lighthouse": 1717.0, "accessibility": 1681.0, "hyperlinks": 1662.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-08-02", "sites": 704, "cropped_screenshots": 1566, "full_screenshots": 0.0, "lighthouse": 1584.0, "accessibility": 1535.0, "hyperlinks": 1519.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-08-03", "sites": 717, "cropped_screenshots": 1617, "full_screenshots": 0.0, "lighthouse": 1628.0, "accessibility": 1590.0, "hyperlinks": 1573.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-08-04", "sites": 735, "cropped_screenshots": 1679, "full_screenshots": 0.0, "lighthouse": 1687.0, "accessibility": 1651.0, "hyperlinks": 1624.0, "robotstxt": 0.0, "wayback": 0.0}, {"date": "2022-08-05", "sites": 746, "cropped_screenshots": 1830, "full_screenshots": 0.0, "lighthouse": 1826.0, "accessibility": 1792.0, "hyperlinks": 1772.0, "robotstxt": 0.0, "wayback": 1225.0}, {"date": "2022-08-06", "sites": 746, "cropped_screenshots": 1521, "full_screenshots": 0.0, "lighthouse": 1520.0, "accessibility": 1484.0, "hyperlinks": 1472.0, "robotstxt": 0.0, "wayback": 1519.0}, {"date": "2022-08-07", "sites": 755, "cropped_screenshots": 1709, "full_screenshots": 0.0, "lighthouse": 1704.0, "accessibility": 1675.0, "hyperlinks": 1654.0, "robotstxt": 0.0, "wayback": 1696.0}, {"date": "2022-08-08", "sites": 756, "cropped_screenshots": 1708, "full_screenshots": 0.0, "lighthouse": 1704.0, "accessibility": 1666.0, "hyperlinks": 1642.0, "robotstxt": 0.0, "wayback": 1692.0}, {"date": "2022-08-09", "sites": 762, "cropped_screenshots": 1839, "full_screenshots": 0.0, "lighthouse": 1851.0, "accessibility": 1806.0, "hyperlinks": 1783.0, "robotstxt": 0.0, "wayback": 1828.0}, {"date": "2022-08-10", "sites": 767, "cropped_screenshots": 1558, "full_screenshots": 0.0, "lighthouse": 1608.0, "accessibility": 1575.0, "hyperlinks": 1521.0, "robotstxt": 0.0, "wayback": 1574.0}, {"date": "2022-08-11", "sites": 772, "cropped_screenshots": 1901, "full_screenshots": 0.0, "lighthouse": 1918.0, "accessibility": 1884.0, "hyperlinks": 1847.0, "robotstxt": 0.0, "wayback": 1854.0}, {"date": "2022-08-12", "sites": 772, "cropped_screenshots": 1608, "full_screenshots": 0.0, "lighthouse": 1760.0, "accessibility": 1723.0, "hyperlinks": 1691.0, "robotstxt": 0.0, "wayback": 1769.0}, {"date": "2022-08-13", "sites": 781, "cropped_screenshots": 1823, "full_screenshots": 0.0, "lighthouse": 1816.0, "accessibility": 1776.0, "hyperlinks": 1759.0, "robotstxt": 0.0, "wayback": 1822.0}, {"date": "2022-08-14", "sites": 794, "cropped_screenshots": 1628, "full_screenshots": 0.0, "lighthouse": 1625.0, "accessibility": 1601.0, "hyperlinks": 1592.0, "robotstxt": 0.0, "wayback": 1609.0}, {"date": "2022-08-15", "sites": 800, "cropped_screenshots": 1774, "full_screenshots": 0.0, "lighthouse": 1770.0, "accessibility": 1722.0, "hyperlinks": 1761.0, "robotstxt": 0.0, "wayback": 1750.0}, {"date": "2022-08-16", "sites": 808, "cropped_screenshots": 1813, "full_screenshots": 0.0, "lighthouse": 1815.0, "accessibility": 1764.0, "hyperlinks": 1799.0, "robotstxt": 0.0, "wayback": 1812.0}, {"date": "2022-08-17", "sites": 808, "cropped_screenshots": 1936, "full_screenshots": 0.0, "lighthouse": 1926.0, "accessibility": 1885.0, "hyperlinks": 1910.0, "robotstxt": 0.0, "wayback": 1931.0}, {"date": "2022-08-18", "sites": 812, "cropped_screenshots": 1852, "full_screenshots": 0.0, "lighthouse": 1849.0, "accessibility": 1802.0, "hyperlinks": 1831.0, "robotstxt": 0.0, "wayback": 1851.0}, {"date": "2022-08-19", "sites": 815, "cropped_screenshots": 2163, "full_screenshots": 0.0, "lighthouse": 2154.0, "accessibility": 2086.0, "hyperlinks": 2126.0, "robotstxt": 0.0, "wayback": 2159.0}, {"date": "2022-08-20", "sites": 821, "cropped_screenshots": 1872, "full_screenshots": 0.0, "lighthouse": 1863.0, "accessibility": 1821.0, "hyperlinks": 1847.0, "robotstxt": 0.0, "wayback": 1875.0}, {"date": "2022-08-21", "sites": 824, "cropped_screenshots": 1897, "full_screenshots": 0.0, "lighthouse": 1894.0, "accessibility": 1852.0, "hyperlinks": 1881.0, "robotstxt": 0.0, "wayback": 1888.0}, {"date": "2022-08-22", "sites": 842, "cropped_screenshots": 1829, "full_screenshots": 0.0, "lighthouse": 1828.0, "accessibility": 1791.0, "hyperlinks": 1803.0, "robotstxt": 0.0, "wayback": 1810.0}, {"date": "2022-08-23", "sites": 856, "cropped_screenshots": 2014, "full_screenshots": 0.0, "lighthouse": 2007.0, "accessibility": 1962.0, "hyperlinks": 1988.0, "robotstxt": 0.0, "wayback": 2028.0}, {"date": "2022-08-24", "sites": 856, "cropped_screenshots": 1964, "full_screenshots": 0.0, "lighthouse": 1958.0, "accessibility": 1917.0, "hyperlinks": 1934.0, "robotstxt": 0.0, "wayback": 1972.0}, {"date": "2022-08-25", "sites": 856, "cropped_screenshots": 1185, "full_screenshots": 0.0, "lighthouse": 1188.0, "accessibility": 1179.0, "hyperlinks": 1191.0, "robotstxt": 0.0, "wayback": 1188.0}, {"date": "2022-08-26", "sites": 868, "cropped_screenshots": 2126, "full_screenshots": 0.0, "lighthouse": 2130.0, "accessibility": 2115.0, "hyperlinks": 2137.0, "robotstxt": 0.0, "wayback": 2140.0}, {"date": "2022-08-27", "sites": 869, "cropped_screenshots": 1983, "full_screenshots": 0.0, "lighthouse": 1981.0, "accessibility": 1973.0, "hyperlinks": 1991.0, "robotstxt": 0.0, "wayback": 1997.0}, {"date": "2022-08-28", "sites": 869, "cropped_screenshots": 1983, "full_screenshots": 0.0, "lighthouse": 1984.0, "accessibility": 1974.0, "hyperlinks": 1993.0, "robotstxt": 0.0, "wayback": 1988.0}, {"date": "2022-08-29", "sites": 869, "cropped_screenshots": 2000, "full_screenshots": 0.0, "lighthouse": 1998.0, "accessibility": 1991.0, "hyperlinks": 2009.0, "robotstxt": 0.0, "wayback": 1992.0}, {"date": "2022-08-30", "sites": 869, "cropped_screenshots": 1909, "full_screenshots": 0.0, "lighthouse": 1902.0, "accessibility": 1893.0, "hyperlinks": 1912.0, "robotstxt": 0.0, "wayback": 1911.0}, {"date": "2022-08-31", "sites": 870, "cropped_screenshots": 2110, "full_screenshots": 0.0, "lighthouse": 2109.0, "accessibility": 2100.0, "hyperlinks": 2118.0, "robotstxt": 0.0, "wayback": 2118.0}, {"date": "2022-09-01", "sites": 870, "cropped_screenshots": 1913, "full_screenshots": 0.0, "lighthouse": 1912.0, "accessibility": 1906.0, "hyperlinks": 1923.0, "robotstxt": 0.0, "wayback": 1923.0}, {"date": "2022-09-02", "sites": 870, "cropped_screenshots": 1998, "full_screenshots": 0.0, "lighthouse": 1998.0, "accessibility": 1994.0, "hyperlinks": 2013.0, "robotstxt": 0.0, "wayback": 1908.0}, {"date": "2022-09-03", "sites": 871, "cropped_screenshots": 2212, "full_screenshots": 0.0, "lighthouse": 2215.0, "accessibility": 2208.0, "hyperlinks": 2219.0, "robotstxt": 0.0, "wayback": 2141.0}, {"date": "2022-09-04", "sites": 873, "cropped_screenshots": 1915, "full_screenshots": 0.0, "lighthouse": 1914.0, "accessibility": 1906.0, "hyperlinks": 1927.0, "robotstxt": 0.0, "wayback": 1928.0}, {"date": "2022-09-05", "sites": 851, "cropped_screenshots": 1870, "full_screenshots": 0.0, "lighthouse": 1976.0, "accessibility": 1943.0, "hyperlinks": 1912.0, "robotstxt": 0.0, "wayback": 1986.0}, {"date": "2022-09-06", "sites": 851, "cropped_screenshots": 1111, "full_screenshots": 0.0, "lighthouse": 1053.0, "accessibility": 1089.0, "hyperlinks": 1074.0, "robotstxt": 0.0, "wayback": 942.0}, {"date": "2022-09-07", "sites": 873, "cropped_screenshots": 2003, "full_screenshots": 0.0, "lighthouse": 2147.0, "accessibility": 2033.0, "hyperlinks": 2060.0, "robotstxt": 0.0, "wayback": 2157.0}, {"date": "2022-09-08", "sites": 873, "cropped_screenshots": 1805, "full_screenshots": 0.0, "lighthouse": 1804.0, "accessibility": 1800.0, "hyperlinks": 1813.0, "robotstxt": 0.0, "wayback": 1815.0}, {"date": "2022-09-09", "sites": 873, "cropped_screenshots": 2050, "full_screenshots": 0.0, "lighthouse": 2053.0, "accessibility": 2044.0, "hyperlinks": 2063.0, "robotstxt": 0.0, "wayback": 2063.0}, {"date": "2022-09-10", "sites": 873, "cropped_screenshots": 1995, "full_screenshots": 0.0, "lighthouse": 1991.0, "accessibility": 1984.0, "hyperlinks": 2004.0, "robotstxt": 0.0, "wayback": 1417.0}, {"date": "2022-09-11", "sites": 872, "cropped_screenshots": 1989, "full_screenshots": 0.0, "lighthouse": 1992.0, "accessibility": 1987.0, "hyperlinks": 2005.0, "robotstxt": 0.0, "wayback": 1244.0}, {"date": "2022-09-12", "sites": 892, "cropped_screenshots": 2173, "full_screenshots": 0.0, "lighthouse": 2170.0, "accessibility": 2169.0, "hyperlinks": 2184.0, "robotstxt": 0.0, "wayback": 1917.0}, {"date": "2022-09-13", "sites": 897, "cropped_screenshots": 2086, "full_screenshots": 0.0, "lighthouse": 2084.0, "accessibility": 1995.0, "hyperlinks": 2100.0, "robotstxt": 0.0, "wayback": 2096.0}, {"date": "2022-09-14", "sites": 910, "cropped_screenshots": 2020, "full_screenshots": 0.0, "lighthouse": 2018.0, "accessibility": 2008.0, "hyperlinks": 2022.0, "robotstxt": 0.0, "wayback": 2019.0}, {"date": "2022-09-15", "sites": 910, "cropped_screenshots": 2118, "full_screenshots": 0.0, "lighthouse": 2118.0, "accessibility": 2115.0, "hyperlinks": 2129.0, "robotstxt": 0.0, "wayback": 2104.0}, {"date": "2022-09-16", "sites": 910, "cropped_screenshots": 2086, "full_screenshots": 0.0, "lighthouse": 2056.0, "accessibility": 2069.0, "hyperlinks": 2075.0, "robotstxt": 0.0, "wayback": 2065.0}, {"date": "2022-09-17", "sites": 910, "cropped_screenshots": 2067, "full_screenshots": 0.0, "lighthouse": 2070.0, "accessibility": 2060.0, "hyperlinks": 2080.0, "robotstxt": 0.0, "wayback": 2081.0}, {"date": "2022-09-18", "sites": 909, "cropped_screenshots": 1978, "full_screenshots": 0.0, "lighthouse": 1974.0, "accessibility": 1973.0, "hyperlinks": 1989.0, "robotstxt": 0.0, "wayback": 1938.0}, {"date": "2022-09-19", "sites": 910, "cropped_screenshots": 2080, "full_screenshots": 0.0, "lighthouse": 2078.0, "accessibility": 2073.0, "hyperlinks": 2091.0, "robotstxt": 0.0, "wayback": 2086.0}, {"date": "2022-09-20", "sites": 1044, "cropped_screenshots": 2528, "full_screenshots": 0.0, "lighthouse": 2528.0, "accessibility": 2499.0, "hyperlinks": 2540.0, "robotstxt": 0.0, "wayback": 2538.0}, {"date": "2022-09-21", "sites": 1103, "cropped_screenshots": 2441, "full_screenshots": 0.0, "lighthouse": 2470.0, "accessibility": 2464.0, "hyperlinks": 2446.0, "robotstxt": 0.0, "wayback": 2479.0}, {"date": "2022-09-22", "sites": 1102, "cropped_screenshots": 2438, "full_screenshots": 0.0, "lighthouse": 2439.0, "accessibility": 2432.0, "hyperlinks": 2449.0, "robotstxt": 0.0, "wayback": 2439.0}, {"date": "2022-09-23", "sites": 1103, "cropped_screenshots": 2465, "full_screenshots": 0.0, "lighthouse": 2464.0, "accessibility": 2456.0, "hyperlinks": 2483.0, "robotstxt": 0.0, "wayback": 2477.0}, {"date": "2022-09-24", "sites": 1103, "cropped_screenshots": 2455, "full_screenshots": 0.0, "lighthouse": 2450.0, "accessibility": 2448.0, "hyperlinks": 2467.0, "robotstxt": 0.0, "wayback": 2452.0}, {"date": "2022-09-25", "sites": 1103, "cropped_screenshots": 2448, "full_screenshots": 0.0, "lighthouse": 2448.0, "accessibility": 2446.0, "hyperlinks": 2461.0, "robotstxt": 0.0, "wayback": 2454.0}, {"date": "2022-09-26", "sites": 1103, "cropped_screenshots": 2467, "full_screenshots": 0.0, "lighthouse": 2468.0, "accessibility": 2461.0, "hyperlinks": 2480.0, "robotstxt": 0.0, "wayback": 2474.0}, {"date": "2022-09-27", "sites": 1102, "cropped_screenshots": 2429, "full_screenshots": 0.0, "lighthouse": 2447.0, "accessibility": 2423.0, "hyperlinks": 2446.0, "robotstxt": 0.0, "wayback": 2455.0}, {"date": "2022-09-28", "sites": 1102, "cropped_screenshots": 2473, "full_screenshots": 0.0, "lighthouse": 2467.0, "accessibility": 2434.0, "hyperlinks": 2475.0, "robotstxt": 0.0, "wayback": 2481.0}, {"date": "2022-09-29", "sites": 1101, "cropped_screenshots": 2399, "full_screenshots": 0.0, "lighthouse": 2406.0, "accessibility": 2405.0, "hyperlinks": 2420.0, "robotstxt": 0.0, "wayback": 2410.0}, {"date": "2022-09-30", "sites": 1102, "cropped_screenshots": 2509, "full_screenshots": 0.0, "lighthouse": 2505.0, "accessibility": 2500.0, "hyperlinks": 2519.0, "robotstxt": 0.0, "wayback": 2517.0}, {"date": "2022-10-01", "sites": 1102, "cropped_screenshots": 2453, "full_screenshots": 0.0, "lighthouse": 2451.0, "accessibility": 2447.0, "hyperlinks": 2464.0, "robotstxt": 0.0, "wayback": 2454.0}, {"date": "2022-10-02", "sites": 1102, "cropped_screenshots": 2389, "full_screenshots": 0.0, "lighthouse": 2379.0, "accessibility": 2379.0, "hyperlinks": 2396.0, "robotstxt": 0.0, "wayback": 2363.0}, {"date": "2022-10-03", "sites": 1103, "cropped_screenshots": 2527, "full_screenshots": 0.0, "lighthouse": 2536.0, "accessibility": 2528.0, "hyperlinks": 2549.0, "robotstxt": 0.0, "wayback": 2549.0}, {"date": "2022-10-04", "sites": 1102, "cropped_screenshots": 2451, "full_screenshots": 0.0, "lighthouse": 2450.0, "accessibility": 2444.0, "hyperlinks": 2465.0, "robotstxt": 0.0, "wayback": 2456.0}, {"date": "2022-10-05", "sites": 1103, "cropped_screenshots": 2470, "full_screenshots": 0.0, "lighthouse": 2473.0, "accessibility": 2463.0, "hyperlinks": 2486.0, "robotstxt": 0.0, "wayback": 2483.0}, {"date": "2022-10-06", "sites": 1103, "cropped_screenshots": 2283, "full_screenshots": 0.0, "lighthouse": 2283.0, "accessibility": 2280.0, "hyperlinks": 2291.0, "robotstxt": 0.0, "wayback": 2306.0}, {"date": "2022-10-07", "sites": 1103, "cropped_screenshots": 2438, "full_screenshots": 0.0, "lighthouse": 2440.0, "accessibility": 2428.0, "hyperlinks": 2449.0, "robotstxt": 0.0, "wayback": 2440.0}, {"date": "2022-10-08", "sites": 1103, "cropped_screenshots": 2453, "full_screenshots": 0.0, "lighthouse": 2450.0, "accessibility": 2443.0, "hyperlinks": 2466.0, "robotstxt": 0.0, "wayback": 2452.0}, {"date": "2022-10-09", "sites": 1102, "cropped_screenshots": 2561, "full_screenshots": 0.0, "lighthouse": 2563.0, "accessibility": 2551.0, "hyperlinks": 2569.0, "robotstxt": 0.0, "wayback": 2578.0}, {"date": "2022-10-10", "sites": 1103, "cropped_screenshots": 2362, "full_screenshots": 0.0, "lighthouse": 2362.0, "accessibility": 2355.0, "hyperlinks": 2371.0, "robotstxt": 0.0, "wayback": 2369.0}, {"date": "2022-10-11", "sites": 1103, "cropped_screenshots": 2518, "full_screenshots": 0.0, "lighthouse": 2519.0, "accessibility": 2514.0, "hyperlinks": 2530.0, "robotstxt": 0.0, "wayback": 2522.0}, {"date": "2022-10-12", "sites": 1102, "cropped_screenshots": 2492, "full_screenshots": 0.0, "lighthouse": 2493.0, "accessibility": 2483.0, "hyperlinks": 2509.0, "robotstxt": 0.0, "wayback": 2499.0}, {"date": "2022-10-13", "sites": 1101, "cropped_screenshots": 2397, "full_screenshots": 0.0, "lighthouse": 2395.0, "accessibility": 2391.0, "hyperlinks": 2403.0, "robotstxt": 0.0, "wayback": 2402.0}, {"date": "2022-10-14", "sites": 1102, "cropped_screenshots": 2392, "full_screenshots": 0.0, "lighthouse": 2392.0, "accessibility": 2383.0, "hyperlinks": 2405.0, "robotstxt": 0.0, "wayback": 2408.0}, {"date": "2022-10-15", "sites": 1101, "cropped_screenshots": 2449, "full_screenshots": 0.0, "lighthouse": 2456.0, "accessibility": 2446.0, "hyperlinks": 2466.0, "robotstxt": 0.0, "wayback": 2466.0}, {"date": "2022-10-16", "sites": 1102, "cropped_screenshots": 2528, "full_screenshots": 0.0, "lighthouse": 2529.0, "accessibility": 2519.0, "hyperlinks": 2543.0, "robotstxt": 0.0, "wayback": 2537.0}, {"date": "2022-10-17", "sites": 1102, "cropped_screenshots": 2492, "full_screenshots": 0.0, "lighthouse": 2488.0, "accessibility": 2483.0, "hyperlinks": 2507.0, "robotstxt": 0.0, "wayback": 2500.0}, {"date": "2022-10-18", "sites": 1101, "cropped_screenshots": 2328, "full_screenshots": 0.0, "lighthouse": 2328.0, "accessibility": 2319.0, "hyperlinks": 2341.0, "robotstxt": 0.0, "wayback": 2337.0}, {"date": "2022-10-19", "sites": 1101, "cropped_screenshots": 2428, "full_screenshots": 0.0, "lighthouse": 2441.0, "accessibility": 2432.0, "hyperlinks": 2442.0, "robotstxt": 0.0, "wayback": 2445.0}, {"date": "2022-10-20", "sites": 1102, "cropped_screenshots": 2564, "full_screenshots": 0.0, "lighthouse": 2577.0, "accessibility": 2571.0, "hyperlinks": 2584.0, "robotstxt": 0.0, "wayback": 2586.0}, {"date": "2022-10-21", "sites": 1102, "cropped_screenshots": 2445, "full_screenshots": 0.0, "lighthouse": 2453.0, "accessibility": 2442.0, "hyperlinks": 2464.0, "robotstxt": 0.0, "wayback": 2460.0}, {"date": "2022-10-22", "sites": 1102, "cropped_screenshots": 2432, "full_screenshots": 0.0, "lighthouse": 2436.0, "accessibility": 2426.0, "hyperlinks": 2444.0, "robotstxt": 0.0, "wayback": 2437.0}, {"date": "2022-10-23", "sites": 1102, "cropped_screenshots": 2429, "full_screenshots": 0.0, "lighthouse": 2432.0, "accessibility": 2425.0, "hyperlinks": 2445.0, "robotstxt": 0.0, "wayback": 2440.0}, {"date": "2022-10-24", "sites": 1102, "cropped_screenshots": 2370, "full_screenshots": 0.0, "lighthouse": 2380.0, "accessibility": 2367.0, "hyperlinks": 2386.0, "robotstxt": 0.0, "wayback": 2379.0}, {"date": "2022-10-25", "sites": 1096, "cropped_screenshots": 2414, "full_screenshots": 0.0, "lighthouse": 2427.0, "accessibility": 2422.0, "hyperlinks": 2443.0, "robotstxt": 0.0, "wayback": 2352.0}, {"date": "2022-10-26", "sites": 1096, "cropped_screenshots": 2493, "full_screenshots": 0.0, "lighthouse": 2489.0, "accessibility": 2492.0, "hyperlinks": 2507.0, "robotstxt": 0.0, "wayback": 2468.0}, {"date": "2022-10-27", "sites": 1095, "cropped_screenshots": 2406, "full_screenshots": 0.0, "lighthouse": 2425.0, "accessibility": 2418.0, "hyperlinks": 2437.0, "robotstxt": 0.0, "wayback": 2427.0}, {"date": "2022-10-28", "sites": 1096, "cropped_screenshots": 2322, "full_screenshots": 0.0, "lighthouse": 2337.0, "accessibility": 2325.0, "hyperlinks": 2348.0, "robotstxt": 0.0, "wayback": 2351.0}, {"date": "2022-10-29", "sites": 1096, "cropped_screenshots": 2525, "full_screenshots": 0.0, "lighthouse": 2541.0, "accessibility": 2534.0, "hyperlinks": 2553.0, "robotstxt": 0.0, "wayback": 2555.0}, {"date": "2022-10-30", "sites": 1095, "cropped_screenshots": 2449, "full_screenshots": 0.0, "lighthouse": 2461.0, "accessibility": 2457.0, "hyperlinks": 2472.0, "robotstxt": 0.0, "wayback": 2481.0}, {"date": "2022-10-31", "sites": 1095, "cropped_screenshots": 2466, "full_screenshots": 0.0, "lighthouse": 2476.0, "accessibility": 2473.0, "hyperlinks": 2496.0, "robotstxt": 0.0, "wayback": 2485.0}, {"date": "2022-11-01", "sites": 1095, "cropped_screenshots": 2415, "full_screenshots": 0.0, "lighthouse": 2426.0, "accessibility": 2426.0, "hyperlinks": 2444.0, "robotstxt": 0.0, "wayback": 2442.0}, {"date": "2022-11-02", "sites": 1097, "cropped_screenshots": 2434, "full_screenshots": 0.0, "lighthouse": 2459.0, "accessibility": 2452.0, "hyperlinks": 2473.0, "robotstxt": 0.0, "wayback": 2459.0}, {"date": "2022-11-03", "sites": 1096, "cropped_screenshots": 2230, "full_screenshots": 0.0, "lighthouse": 2132.0, "accessibility": 2196.0, "hyperlinks": 2169.0, "robotstxt": 0.0, "wayback": 2069.0}, {"date": "2022-11-04", "sites": 1097, "cropped_screenshots": 2409, "full_screenshots": 0.0, "lighthouse": 2427.0, "accessibility": 2420.0, "hyperlinks": 2443.0, "robotstxt": 0.0, "wayback": 2397.0}, {"date": "2022-11-05", "sites": 1097, "cropped_screenshots": 2633, "full_screenshots": 0.0, "lighthouse": 2650.0, "accessibility": 2645.0, "hyperlinks": 2665.0, "robotstxt": 0.0, "wayback": 2653.0}, {"date": "2022-11-06", "sites": 1097, "cropped_screenshots": 2257, "full_screenshots": 0.0, "lighthouse": 2272.0, "accessibility": 2267.0, "hyperlinks": 2289.0, "robotstxt": 0.0, "wayback": 2289.0}, {"date": "2022-11-07", "sites": 1096, "cropped_screenshots": 2303, "full_screenshots": 0.0, "lighthouse": 2322.0, "accessibility": 2313.0, "hyperlinks": 2333.0, "robotstxt": 0.0, "wayback": 2287.0}, {"date": "2022-11-08", "sites": 1098, "cropped_screenshots": 2445, "full_screenshots": 0.0, "lighthouse": 2147.0, "accessibility": 2140.0, "hyperlinks": 2715.0, "robotstxt": 0.0, "wayback": 2074.0}, {"date": "2022-11-09", "sites": 1106, "cropped_screenshots": 2860, "full_screenshots": 0.0, "lighthouse": 2404.0, "accessibility": 2402.0, "hyperlinks": 3630.0, "robotstxt": 0.0, "wayback": 2319.0}, {"date": "2022-11-10", "sites": 1106, "cropped_screenshots": 2406, "full_screenshots": 0.0, "lighthouse": 2407.0, "accessibility": 2399.0, "hyperlinks": 3123.0, "robotstxt": 0.0, "wayback": 2249.0}, {"date": "2022-11-11", "sites": 1106, "cropped_screenshots": 2166, "full_screenshots": 0.0, "lighthouse": 2159.0, "accessibility": 2128.0, "hyperlinks": 2591.0, "robotstxt": 0.0, "wayback": 2028.0}, {"date": "2022-11-12", "sites": 1106, "cropped_screenshots": 2589, "full_screenshots": 0.0, "lighthouse": 2580.0, "accessibility": 2584.0, "hyperlinks": 2931.0, "robotstxt": 0.0, "wayback": 2400.0}, {"date": "2022-11-13", "sites": 1106, "cropped_screenshots": 2941, "full_screenshots": 0.0, "lighthouse": 2947.0, "accessibility": 2939.0, "hyperlinks": 2961.0, "robotstxt": 0.0, "wayback": 2765.0}, {"date": "2022-11-14", "sites": 1105, "cropped_screenshots": 2838, "full_screenshots": 0.0, "lighthouse": 2832.0, "accessibility": 2838.0, "hyperlinks": 2853.0, "robotstxt": 0.0, "wayback": 2639.0}, {"date": "2022-11-15", "sites": 1106, "cropped_screenshots": 2620, "full_screenshots": 0.0, "lighthouse": 2624.0, "accessibility": 2628.0, "hyperlinks": 2637.0, "robotstxt": 0.0, "wayback": 2496.0}, {"date": "2022-11-16", "sites": 1073, "cropped_screenshots": 2319, "full_screenshots": 0.0, "lighthouse": 2345.0, "accessibility": 2353.0, "hyperlinks": 2330.0, "robotstxt": 0.0, "wayback": 2334.0}, {"date": "2022-11-17", "sites": 1105, "cropped_screenshots": 2315, "full_screenshots": 0.0, "lighthouse": 2319.0, "accessibility": 2320.0, "hyperlinks": 2317.0, "robotstxt": 0.0, "wayback": 2251.0}, {"date": "2022-11-18", "sites": 1106, "cropped_screenshots": 2709, "full_screenshots": 0.0, "lighthouse": 2726.0, "accessibility": 2739.0, "hyperlinks": 2755.0, "robotstxt": 0.0, "wayback": 2672.0}, {"date": "2022-11-19", "sites": 1100, "cropped_screenshots": 2209, "full_screenshots": 0.0, "lighthouse": 2181.0, "accessibility": 2201.0, "hyperlinks": 2213.0, "robotstxt": 0.0, "wayback": 2186.0}, {"date": "2022-11-20", "sites": 1095, "cropped_screenshots": 2154, "full_screenshots": 0.0, "lighthouse": 2151.0, "accessibility": 2149.0, "hyperlinks": 2163.0, "robotstxt": 0.0, "wayback": 1481.0}, {"date": "2022-11-21", "sites": 1101, "cropped_screenshots": 2188, "full_screenshots": 0.0, "lighthouse": 2180.0, "accessibility": 2177.0, "hyperlinks": 2196.0, "robotstxt": 0.0, "wayback": 2194.0}, {"date": "2022-11-22", "sites": 1108, "cropped_screenshots": 2324, "full_screenshots": 0.0, "lighthouse": 2316.0, "accessibility": 2312.0, "hyperlinks": 2331.0, "robotstxt": 0.0, "wayback": 2335.0}, {"date": "2022-11-23", "sites": 1107, "cropped_screenshots": 2306, "full_screenshots": 0.0, "lighthouse": 2298.0, "accessibility": 2294.0, "hyperlinks": 2313.0, "robotstxt": 0.0, "wayback": 2317.0}, {"date": "2022-11-24", "sites": 1108, "cropped_screenshots": 2308, "full_screenshots": 0.0, "lighthouse": 2302.0, "accessibility": 2298.0, "hyperlinks": 2314.0, "robotstxt": 0.0, "wayback": 2278.0}, {"date": "2022-11-25", "sites": 1107, "cropped_screenshots": 2305, "full_screenshots": 0.0, "lighthouse": 2300.0, "accessibility": 2290.0, "hyperlinks": 2311.0, "robotstxt": 0.0, "wayback": 2138.0}, {"date": "2022-11-26", "sites": 1107, "cropped_screenshots": 2306, "full_screenshots": 0.0, "lighthouse": 2295.0, "accessibility": 2297.0, "hyperlinks": 2313.0, "robotstxt": 0.0, "wayback": 1942.0}, {"date": "2022-11-27", "sites": 1129, "cropped_screenshots": 2363, "full_screenshots": 0.0, "lighthouse": 2350.0, "accessibility": 2322.0, "hyperlinks": 2368.0, "robotstxt": 0.0, "wayback": 1519.0}, {"date": "2022-11-28", "sites": 1129, "cropped_screenshots": 2351, "full_screenshots": 0.0, "lighthouse": 2343.0, "accessibility": 2291.0, "hyperlinks": 2357.0, "robotstxt": 0.0, "wayback": 2361.0}, {"date": "2022-11-29", "sites": 1130, "cropped_screenshots": 2351, "full_screenshots": 0.0, "lighthouse": 2340.0, "accessibility": 2292.0, "hyperlinks": 2358.0, "robotstxt": 0.0, "wayback": 2362.0}, {"date": "2022-11-30", "sites": 1129, "cropped_screenshots": 2236, "full_screenshots": 0.0, "lighthouse": 2232.0, "accessibility": 2187.0, "hyperlinks": 2244.0, "robotstxt": 0.0, "wayback": 2248.0}, {"date": "2022-12-01", "sites": 1129, "cropped_screenshots": 2325, "full_screenshots": 0.0, "lighthouse": 2347.0, "accessibility": 2289.0, "hyperlinks": 2357.0, "robotstxt": 0.0, "wayback": 2361.0}, {"date": "2022-12-02", "sites": 1130, "cropped_screenshots": 2371, "full_screenshots": 0.0, "lighthouse": 2369.0, "accessibility": 2316.0, "hyperlinks": 2379.0, "robotstxt": 0.0, "wayback": 2379.0}, {"date": "2022-12-03", "sites": 1131, "cropped_screenshots": 2352, "full_screenshots": 0.0, "lighthouse": 2348.0, "accessibility": 2302.0, "hyperlinks": 2358.0, "robotstxt": 0.0, "wayback": 2354.0}, {"date": "2022-12-04", "sites": 1130, "cropped_screenshots": 2350, "full_screenshots": 0.0, "lighthouse": 2348.0, "accessibility": 2300.0, "hyperlinks": 2358.0, "robotstxt": 0.0, "wayback": 2364.0}, {"date": "2022-12-05", "sites": 1131, "cropped_screenshots": 2352, "full_screenshots": 0.0, "lighthouse": 2348.0, "accessibility": 2302.0, "hyperlinks": 2359.0, "robotstxt": 0.0, "wayback": 2363.0}, {"date": "2022-12-06", "sites": 1137, "cropped_screenshots": 2361, "full_screenshots": 0.0, "lighthouse": 2361.0, "accessibility": 2304.0, "hyperlinks": 2370.0, "robotstxt": 0.0, "wayback": 2341.0}, {"date": "2022-12-07", "sites": 1145, "cropped_screenshots": 2383, "full_screenshots": 0.0, "lighthouse": 2376.0, "accessibility": 2333.0, "hyperlinks": 2389.0, "robotstxt": 0.0, "wayback": 2393.0}, {"date": "2022-12-08", "sites": 1145, "cropped_screenshots": 2492, "full_screenshots": 0.0, "lighthouse": 2489.0, "accessibility": 2442.0, "hyperlinks": 2502.0, "robotstxt": 0.0, "wayback": 2510.0}, {"date": "2022-12-09", "sites": 1143, "cropped_screenshots": 2370, "full_screenshots": 0.0, "lighthouse": 2370.0, "accessibility": 2323.0, "hyperlinks": 2383.0, "robotstxt": 0.0, "wayback": 2393.0}, {"date": "2022-12-10", "sites": 1143, "cropped_screenshots": 2377, "full_screenshots": 0.0, "lighthouse": 2368.0, "accessibility": 2325.0, "hyperlinks": 2385.0, "robotstxt": 0.0, "wayback": 2393.0}, {"date": "2022-12-11", "sites": 1140, "cropped_screenshots": 2369, "full_screenshots": 0.0, "lighthouse": 2368.0, "accessibility": 2323.0, "hyperlinks": 2382.0, "robotstxt": 0.0, "wayback": 2393.0}, {"date": "2022-12-12", "sites": 1143, "cropped_screenshots": 2378, "full_screenshots": 0.0, "lighthouse": 2371.0, "accessibility": 2327.0, "hyperlinks": 2385.0, "robotstxt": 0.0, "wayback": 2394.0}, {"date": "2022-12-13", "sites": 1144, "cropped_screenshots": 2379, "full_screenshots": 0.0, "lighthouse": 2367.0, "accessibility": 2325.0, "hyperlinks": 2386.0, "robotstxt": 0.0, "wayback": 2394.0}, {"date": "2022-12-14", "sites": 1144, "cropped_screenshots": 2378, "full_screenshots": 0.0, "lighthouse": 2368.0, "accessibility": 2327.0, "hyperlinks": 2386.0, "robotstxt": 0.0, "wayback": 2393.0}, {"date": "2022-12-15", "sites": 1146, "cropped_screenshots": 2383, "full_screenshots": 0.0, "lighthouse": 2371.0, "accessibility": 2330.0, "hyperlinks": 2388.0, "robotstxt": 0.0, "wayback": 2388.0}, {"date": "2022-12-16", "sites": 1145, "cropped_screenshots": 2411, "full_screenshots": 0.0, "lighthouse": 2401.0, "accessibility": 2359.0, "hyperlinks": 2421.0, "robotstxt": 0.0, "wayback": 2426.0}, {"date": "2022-12-17", "sites": 1146, "cropped_screenshots": 2382, "full_screenshots": 0.0, "lighthouse": 2372.0, "accessibility": 2327.0, "hyperlinks": 2390.0, "robotstxt": 0.0, "wayback": 2393.0}, {"date": "2022-12-18", "sites": 1145, "cropped_screenshots": 2381, "full_screenshots": 0.0, "lighthouse": 2372.0, "accessibility": 2333.0, "hyperlinks": 2387.0, "robotstxt": 0.0, "wayback": 2394.0}, {"date": "2022-12-19", "sites": 1145, "cropped_screenshots": 2377, "full_screenshots": 0.0, "lighthouse": 2365.0, "accessibility": 2322.0, "hyperlinks": 2386.0, "robotstxt": 0.0, "wayback": 2383.0}, {"date": "2022-12-20", "sites": 1144, "cropped_screenshots": 2378, "full_screenshots": 0.0, "lighthouse": 2369.0, "accessibility": 2329.0, "hyperlinks": 2389.0, "robotstxt": 0.0, "wayback": 2378.0}, {"date": "2022-12-21", "sites": 1144, "cropped_screenshots": 2380, "full_screenshots": 0.0, "lighthouse": 2375.0, "accessibility": 2327.0, "hyperlinks": 2390.0, "robotstxt": 0.0, "wayback": 2391.0}, {"date": "2022-12-22", "sites": 1145, "cropped_screenshots": 2194, "full_screenshots": 0.0, "lighthouse": 2186.0, "accessibility": 2147.0, "hyperlinks": 2201.0, "robotstxt": 0.0, "wayback": 2088.0}, {"date": "2022-12-23", "sites": 1145, "cropped_screenshots": 2495, "full_screenshots": 0.0, "lighthouse": 2487.0, "accessibility": 2443.0, "hyperlinks": 2504.0, "robotstxt": 0.0, "wayback": 2477.0}, {"date": "2022-12-24", "sites": 1145, "cropped_screenshots": 2379, "full_screenshots": 0.0, "lighthouse": 2368.0, "accessibility": 2330.0, "hyperlinks": 2385.0, "robotstxt": 0.0, "wayback": 2392.0}, {"date": "2022-12-25", "sites": 1145, "cropped_screenshots": 2378, "full_screenshots": 0.0, "lighthouse": 2365.0, "accessibility": 2330.0, "hyperlinks": 2386.0, "robotstxt": 0.0, "wayback": 2390.0}, {"date": "2022-12-26", "sites": 1145, "cropped_screenshots": 2382, "full_screenshots": 0.0, "lighthouse": 2371.0, "accessibility": 2332.0, "hyperlinks": 2389.0, "robotstxt": 0.0, "wayback": 2393.0}, {"date": "2022-12-27", "sites": 1144, "cropped_screenshots": 2378, "full_screenshots": 0.0, "lighthouse": 2377.0, "accessibility": 2330.0, "hyperlinks": 2388.0, "robotstxt": 0.0, "wayback": 2392.0}, {"date": "2022-12-28", "sites": 1146, "cropped_screenshots": 2381, "full_screenshots": 0.0, "lighthouse": 2374.0, "accessibility": 2334.0, "hyperlinks": 2389.0, "robotstxt": 0.0, "wayback": 2393.0}, {"date": "2022-12-29", "sites": 1145, "cropped_screenshots": 2372, "full_screenshots": 0.0, "lighthouse": 2366.0, "accessibility": 2324.0, "hyperlinks": 2377.0, "robotstxt": 0.0, "wayback": 2384.0}, {"date": "2022-12-30", "sites": 1145, "cropped_screenshots": 2400, "full_screenshots": 0.0, "lighthouse": 2393.0, "accessibility": 2351.0, "hyperlinks": 2409.0, "robotstxt": 0.0, "wayback": 2367.0}, {"date": "2022-12-31", "sites": 1128, "cropped_screenshots": 1272, "full_screenshots": 0.0, "lighthouse": 1273.0, "accessibility": 1250.0, "hyperlinks": 1278.0, "robotstxt": 0.0, "wayback": 1236.0}, {"date": "2023-01-01", "sites": 1144, "cropped_screenshots": 1800, "full_screenshots": 0.0, "lighthouse": 1802.0, "accessibility": 1771.0, "hyperlinks": 1812.0, "robotstxt": 0.0, "wayback": 1813.0}, {"date": "2023-01-02", "sites": 1144, "cropped_screenshots": 2376, "full_screenshots": 0.0, "lighthouse": 2373.0, "accessibility": 2332.0, "hyperlinks": 2390.0, "robotstxt": 0.0, "wayback": 2394.0}, {"date": "2023-01-03", "sites": 1144, "cropped_screenshots": 2374, "full_screenshots": 0.0, "lighthouse": 2371.0, "accessibility": 2333.0, "hyperlinks": 2388.0, "robotstxt": 0.0, "wayback": 2392.0}, {"date": "2023-01-04", "sites": 1145, "cropped_screenshots": 2382, "full_screenshots": 0.0, "lighthouse": 2376.0, "accessibility": 2331.0, "hyperlinks": 2391.0, "robotstxt": 0.0, "wayback": 2392.0}, {"date": "2023-01-05", "sites": 1145, "cropped_screenshots": 2288, "full_screenshots": 0.0, "lighthouse": 2000.0, "accessibility": 2153.0, "hyperlinks": 2106.0, "robotstxt": 0.0, "wayback": 1939.0}, {"date": "2023-01-06", "sites": 1145, "cropped_screenshots": 2329, "full_screenshots": 0.0, "lighthouse": 2375.0, "accessibility": 2301.0, "hyperlinks": 2390.0, "robotstxt": 0.0, "wayback": 2392.0}, {"date": "2023-01-07", "sites": 1145, "cropped_screenshots": 2376, "full_screenshots": 0.0, "lighthouse": 2374.0, "accessibility": 2329.0, "hyperlinks": 2388.0, "robotstxt": 0.0, "wayback": 2302.0}, {"date": "2023-01-08", "sites": 1144, "cropped_screenshots": 2369, "full_screenshots": 0.0, "lighthouse": 2366.0, "accessibility": 2323.0, "hyperlinks": 2389.0, "robotstxt": 0.0, "wayback": 2343.0}, {"date": "2023-01-09", "sites": 1143, "cropped_screenshots": 2360, "full_screenshots": 0.0, "lighthouse": 2367.0, "accessibility": 2311.0, "hyperlinks": 2388.0, "robotstxt": 0.0, "wayback": 2393.0}, {"date": "2023-01-10", "sites": 1138, "cropped_screenshots": 2187, "full_screenshots": 0.0, "lighthouse": 2067.0, "accessibility": 2131.0, "hyperlinks": 2140.0, "robotstxt": 0.0, "wayback": 1929.0}, {"date": "2023-01-11", "sites": 1144, "cropped_screenshots": 2365, "full_screenshots": 0.0, "lighthouse": 2371.0, "accessibility": 2325.0, "hyperlinks": 2388.0, "robotstxt": 0.0, "wayback": 2393.0}, {"date": "2023-01-12", "sites": 1146, "cropped_screenshots": 2310, "full_screenshots": 0.0, "lighthouse": 2247.0, "accessibility": 2247.0, "hyperlinks": 2284.0, "robotstxt": 0.0, "wayback": 2035.0}, {"date": "2023-01-13", "sites": 1134, "cropped_screenshots": 1612, "full_screenshots": 0.0, "lighthouse": 1915.0, "accessibility": 1653.0, "hyperlinks": 1927.0, "robotstxt": 0.0, "wayback": 1809.0}, {"date": "2023-01-14", "sites": 1146, "cropped_screenshots": 2380, "full_screenshots": 0.0, "lighthouse": 2371.0, "accessibility": 2329.0, "hyperlinks": 2389.0, "robotstxt": 0.0, "wayback": 2392.0}, {"date": "2023-01-15", "sites": 1146, "cropped_screenshots": 2375, "full_screenshots": 0.0, "lighthouse": 2368.0, "accessibility": 2327.0, "hyperlinks": 2385.0, "robotstxt": 0.0, "wayback": 2332.0}, {"date": "2023-01-16", "sites": 1144, "cropped_screenshots": 2265, "full_screenshots": 0.0, "lighthouse": 2262.0, "accessibility": 2224.0, "hyperlinks": 2281.0, "robotstxt": 0.0, "wayback": 2108.0}, {"date": "2023-01-17", "sites": 1146, "cropped_screenshots": 2375, "full_screenshots": 0.0, "lighthouse": 2362.0, "accessibility": 2325.0, "hyperlinks": 2384.0, "robotstxt": 0.0, "wayback": 2373.0}, {"date": "2023-01-18", "sites": 1146, "cropped_screenshots": 2377, "full_screenshots": 0.0, "lighthouse": 2366.0, "accessibility": 2325.0, "hyperlinks": 2382.0, "robotstxt": 0.0, "wayback": 2003.0}, {"date": "2023-01-19", "sites": 1146, "cropped_screenshots": 2064, "full_screenshots": 0.0, "lighthouse": 2053.0, "accessibility": 2023.0, "hyperlinks": 2071.0, "robotstxt": 0.0, "wayback": 1798.0}, {"date": "2023-01-20", "sites": 1146, "cropped_screenshots": 2364, "full_screenshots": 0.0, "lighthouse": 2320.0, "accessibility": 2301.0, "hyperlinks": 2353.0, "robotstxt": 0.0, "wayback": 2286.0}, {"date": "2023-01-21", "sites": 1146, "cropped_screenshots": 2382, "full_screenshots": 0.0, "lighthouse": 2375.0, "accessibility": 2322.0, "hyperlinks": 2390.0, "robotstxt": 0.0, "wayback": 2371.0}, {"date": "2023-01-22", "sites": 1146, "cropped_screenshots": 2383, "full_screenshots": 0.0, "lighthouse": 2369.0, "accessibility": 2322.0, "hyperlinks": 2388.0, "robotstxt": 0.0, "wayback": 2335.0}, {"date": "2023-01-23", "sites": 1146, "cropped_screenshots": 2381, "full_screenshots": 0.0, "lighthouse": 2367.0, "accessibility": 2319.0, "hyperlinks": 2388.0, "robotstxt": 0.0, "wayback": 2380.0}, {"date": "2023-01-24", "sites": 1145, "cropped_screenshots": 1908, "full_screenshots": 0.0, "lighthouse": 1899.0, "accessibility": 1854.0, "hyperlinks": 1915.0, "robotstxt": 0.0, "wayback": 1882.0}, {"date": "2023-01-25", "sites": 480, "cropped_screenshots": 526, "full_screenshots": 517.0, "lighthouse": 519.0, "accessibility": 513.0, "hyperlinks": 525.0, "robotstxt": 0.0, "wayback": 245.0}, {"date": "2023-01-26", "sites": 1147, "cropped_screenshots": 2376, "full_screenshots": 2318.0, "lighthouse": 2347.0, "accessibility": 2288.0, "hyperlinks": 2362.0, "robotstxt": 0.0, "wayback": 1490.0}, {"date": "2023-01-27", "sites": 1147, "cropped_screenshots": 2391, "full_screenshots": 2331.0, "lighthouse": 2364.0, "accessibility": 2300.0, "hyperlinks": 2377.0, "robotstxt": 0.0, "wayback": 1492.0}, {"date": "2023-01-28", "sites": 1147, "cropped_screenshots": 2347, "full_screenshots": 2280.0, "lighthouse": 2301.0, "accessibility": 2244.0, "hyperlinks": 2312.0, "robotstxt": 0.0, "wayback": 1374.0}, {"date": "2023-01-29", "sites": 1147, "cropped_screenshots": 2413, "full_screenshots": 2343.0, "lighthouse": 2363.0, "accessibility": 2306.0, "hyperlinks": 2378.0, "robotstxt": 0.0, "wayback": 1266.0}, {"date": "2023-01-30", "sites": 1147, "cropped_screenshots": 2415, "full_screenshots": 2356.0, "lighthouse": 2390.0, "accessibility": 2325.0, "hyperlinks": 2403.0, "robotstxt": 0.0, "wayback": 2371.0}, {"date": "2023-01-31", "sites": 1146, "cropped_screenshots": 2368, "full_screenshots": 2312.0, "lighthouse": 2343.0, "accessibility": 2283.0, "hyperlinks": 2359.0, "robotstxt": 0.0, "wayback": 2203.0}, {"date": "2023-02-01", "sites": 1147, "cropped_screenshots": 2395, "full_screenshots": 2336.0, "lighthouse": 2367.0, "accessibility": 2305.0, "hyperlinks": 2383.0, "robotstxt": 0.0, "wayback": 2271.0}, {"date": "2023-02-02", "sites": 1146, "cropped_screenshots": 2353, "full_screenshots": 2318.0, "lighthouse": 2337.0, "accessibility": 2263.0, "hyperlinks": 2366.0, "robotstxt": 0.0, "wayback": 2050.0}, {"date": "2023-02-03", "sites": 1146, "cropped_screenshots": 2353, "full_screenshots": 2324.0, "lighthouse": 2345.0, "accessibility": 2265.0, "hyperlinks": 2370.0, "robotstxt": 0.0, "wayback": 2114.0}, {"date": "2023-02-04", "sites": 1146, "cropped_screenshots": 2377, "full_screenshots": 2316.0, "lighthouse": 2338.0, "accessibility": 2294.0, "hyperlinks": 2365.0, "robotstxt": 0.0, "wayback": 2111.0}, {"date": "2023-02-05", "sites": 1146, "cropped_screenshots": 2387, "full_screenshots": 2329.0, "lighthouse": 2353.0, "accessibility": 2303.0, "hyperlinks": 2377.0, "robotstxt": 0.0, "wayback": 2248.0}, {"date": "2023-02-06", "sites": 1145, "cropped_screenshots": 1600, "full_screenshots": 2102.0, "lighthouse": 2129.0, "accessibility": 1659.0, "hyperlinks": 2145.0, "robotstxt": 0.0, "wayback": 2166.0}, {"date": "2023-02-07", "sites": 1146, "cropped_screenshots": 2381, "full_screenshots": 2323.0, "lighthouse": 2346.0, "accessibility": 2299.0, "hyperlinks": 2373.0, "robotstxt": 0.0, "wayback": 2396.0}, {"date": "2023-02-08", "sites": 1146, "cropped_screenshots": 2371, "full_screenshots": 2315.0, "lighthouse": 2338.0, "accessibility": 2247.0, "hyperlinks": 2358.0, "robotstxt": 0.0, "wayback": 2386.0}, {"date": "2023-02-09", "sites": 1146, "cropped_screenshots": 2368, "full_screenshots": 2325.0, "lighthouse": 2349.0, "accessibility": 2034.0, "hyperlinks": 2356.0, "robotstxt": 0.0, "wayback": 2397.0}, {"date": "2023-02-10", "sites": 1145, "cropped_screenshots": 2382, "full_screenshots": 2323.0, "lighthouse": 2354.0, "accessibility": 2058.0, "hyperlinks": 2363.0, "robotstxt": 0.0, "wayback": 2398.0}, {"date": "2023-02-11", "sites": 1146, "cropped_screenshots": 2338, "full_screenshots": 2276.0, "lighthouse": 2285.0, "accessibility": 2004.0, "hyperlinks": 2297.0, "robotstxt": 0.0, "wayback": 2339.0}, {"date": "2023-02-12", "sites": 1146, "cropped_screenshots": 2341, "full_screenshots": 2281.0, "lighthouse": 2307.0, "accessibility": 2029.0, "hyperlinks": 2309.0, "robotstxt": 0.0, "wayback": 2354.0}, {"date": "2023-02-13", "sites": 1146, "cropped_screenshots": 2421, "full_screenshots": 2362.0, "lighthouse": 2380.0, "accessibility": 2086.0, "hyperlinks": 2392.0, "robotstxt": 0.0, "wayback": 2433.0}, {"date": "2023-02-14", "sites": 1146, "cropped_screenshots": 2381, "full_screenshots": 2324.0, "lighthouse": 2344.0, "accessibility": 2039.0, "hyperlinks": 2351.0, "robotstxt": 0.0, "wayback": 2391.0}, {"date": "2023-02-15", "sites": 1146, "cropped_screenshots": 2144, "full_screenshots": 2057.0, "lighthouse": 2048.0, "accessibility": 1809.0, "hyperlinks": 2064.0, "robotstxt": 0.0, "wayback": 2096.0}, {"date": "2023-02-16", "sites": 1146, "cropped_screenshots": 2532, "full_screenshots": 2470.0, "lighthouse": 2481.0, "accessibility": 2212.0, "hyperlinks": 2505.0, "robotstxt": 0.0, "wayback": 2542.0}, {"date": "2023-02-17", "sites": 1146, "cropped_screenshots": 2325, "full_screenshots": 2264.0, "lighthouse": 2244.0, "accessibility": 2168.0, "hyperlinks": 2284.0, "robotstxt": 0.0, "wayback": 2264.0}, {"date": "2023-02-18", "sites": 1146, "cropped_screenshots": 2386, "full_screenshots": 2323.0, "lighthouse": 2344.0, "accessibility": 2245.0, "hyperlinks": 2364.0, "robotstxt": 0.0, "wayback": 2399.0}, {"date": "2023-02-19", "sites": 1146, "cropped_screenshots": 2376, "full_screenshots": 2323.0, "lighthouse": 2341.0, "accessibility": 2237.0, "hyperlinks": 2364.0, "robotstxt": 0.0, "wayback": 2396.0}, {"date": "2023-02-20", "sites": 1146, "cropped_screenshots": 2381, "full_screenshots": 2321.0, "lighthouse": 2341.0, "accessibility": 2248.0, "hyperlinks": 2365.0, "robotstxt": 0.0, "wayback": 2394.0}, {"date": "2023-02-21", "sites": 1146, "cropped_screenshots": 2377, "full_screenshots": 2317.0, "lighthouse": 2339.0, "accessibility": 2243.0, "hyperlinks": 2362.0, "robotstxt": 0.0, "wayback": 2390.0}, {"date": "2023-02-22", "sites": 1146, "cropped_screenshots": 2303, "full_screenshots": 2226.0, "lighthouse": 2169.0, "accessibility": 2137.0, "hyperlinks": 2224.0, "robotstxt": 0.0, "wayback": 2171.0}, {"date": "2023-02-23", "sites": 1146, "cropped_screenshots": 2357, "full_screenshots": 2302.0, "lighthouse": 2324.0, "accessibility": 2233.0, "hyperlinks": 2343.0, "robotstxt": 0.0, "wayback": 2372.0}, {"date": "2023-02-24", "sites": 1146, "cropped_screenshots": 2381, "full_screenshots": 2322.0, "lighthouse": 2342.0, "accessibility": 2264.0, "hyperlinks": 2364.0, "robotstxt": 0.0, "wayback": 2392.0}, {"date": "2023-02-25", "sites": 1148, "cropped_screenshots": 2384, "full_screenshots": 2347.0, "lighthouse": 2344.0, "accessibility": 2247.0, "hyperlinks": 2362.0, "robotstxt": 0.0, "wayback": 2394.0}, {"date": "2023-02-26", "sites": 1147, "cropped_screenshots": 2286, "full_screenshots": 1924.0, "lighthouse": 1126.0, "accessibility": 1426.0, "hyperlinks": 1269.0, "robotstxt": 0.0, "wayback": 1074.0}, {"date": "2023-02-27", "sites": 1148, "cropped_screenshots": 2367, "full_screenshots": 2358.0, "lighthouse": 2283.0, "accessibility": 2194.0, "hyperlinks": 2316.0, "robotstxt": 0.0, "wayback": 2336.0}, {"date": "2023-02-28", "sites": 1148, "cropped_screenshots": 2376, "full_screenshots": 2380.0, "lighthouse": 2336.0, "accessibility": 2239.0, "hyperlinks": 2358.0, "robotstxt": 0.0, "wayback": 2395.0}, {"date": "2023-03-01", "sites": 1148, "cropped_screenshots": 2386, "full_screenshots": 2387.0, "lighthouse": 2344.0, "accessibility": 2244.0, "hyperlinks": 2360.0, "robotstxt": 0.0, "wayback": 2398.0}, {"date": "2023-03-02", "sites": 1148, "cropped_screenshots": 2242, "full_screenshots": 2234.0, "lighthouse": 2180.0, "accessibility": 2095.0, "hyperlinks": 2207.0, "robotstxt": 0.0, "wayback": 2234.0}, {"date": "2023-03-03", "sites": 1148, "cropped_screenshots": 2384, "full_screenshots": 2378.0, "lighthouse": 2332.0, "accessibility": 2233.0, "hyperlinks": 2351.0, "robotstxt": 0.0, "wayback": 2390.0}, {"date": "2023-03-04", "sites": 1148, "cropped_screenshots": 2383, "full_screenshots": 2379.0, "lighthouse": 2335.0, "accessibility": 2240.0, "hyperlinks": 2351.0, "robotstxt": 0.0, "wayback": 2397.0}, {"date": "2023-03-05", "sites": 1148, "cropped_screenshots": 2386, "full_screenshots": 2382.0, "lighthouse": 2337.0, "accessibility": 2238.0, "hyperlinks": 2351.0, "robotstxt": 0.0, "wayback": 2397.0}, {"date": "2023-03-06", "sites": 1148, "cropped_screenshots": 2364, "full_screenshots": 2351.0, "lighthouse": 2324.0, "accessibility": 2216.0, "hyperlinks": 2327.0, "robotstxt": 0.0, "wayback": 2381.0}, {"date": "2023-03-07", "sites": 1148, "cropped_screenshots": 2359, "full_screenshots": 2355.0, "lighthouse": 2310.0, "accessibility": 2213.0, "hyperlinks": 2325.0, "robotstxt": 0.0, "wayback": 2369.0}, {"date": "2023-03-08", "sites": 1148, "cropped_screenshots": 2388, "full_screenshots": 2384.0, "lighthouse": 2330.0, "accessibility": 2248.0, "hyperlinks": 2349.0, "robotstxt": 0.0, "wayback": 2398.0}, {"date": "2023-03-09", "sites": 1148, "cropped_screenshots": 2385, "full_screenshots": 2381.0, "lighthouse": 2332.0, "accessibility": 2239.0, "hyperlinks": 2346.0, "robotstxt": 0.0, "wayback": 2397.0}, {"date": "2023-03-10", "sites": 1148, "cropped_screenshots": 2387, "full_screenshots": 2383.0, "lighthouse": 2327.0, "accessibility": 2240.0, "hyperlinks": 2348.0, "robotstxt": 0.0, "wayback": 2395.0}, {"date": "2023-03-11", "sites": 1148, "cropped_screenshots": 2386, "full_screenshots": 2386.0, "lighthouse": 2335.0, "accessibility": 2235.0, "hyperlinks": 2353.0, "robotstxt": 0.0, "wayback": 2401.0}, {"date": "2023-03-12", "sites": 1148, "cropped_screenshots": 2386, "full_screenshots": 2382.0, "lighthouse": 2330.0, "accessibility": 2241.0, "hyperlinks": 2349.0, "robotstxt": 0.0, "wayback": 2399.0}, {"date": "2023-03-13", "sites": 1148, "cropped_screenshots": 2383, "full_screenshots": 2380.0, "lighthouse": 2332.0, "accessibility": 2238.0, "hyperlinks": 2348.0, "robotstxt": 0.0, "wayback": 2392.0}, {"date": "2023-03-14", "sites": 1147, "cropped_screenshots": 2385, "full_screenshots": 2381.0, "lighthouse": 2328.0, "accessibility": 2233.0, "hyperlinks": 2347.0, "robotstxt": 0.0, "wayback": 2397.0}, {"date": "2023-03-15", "sites": 1148, "cropped_screenshots": 2382, "full_screenshots": 2380.0, "lighthouse": 2329.0, "accessibility": 2230.0, "hyperlinks": 2348.0, "robotstxt": 0.0, "wayback": 2390.0}, {"date": "2023-03-16", "sites": 1148, "cropped_screenshots": 2387, "full_screenshots": 2386.0, "lighthouse": 2325.0, "accessibility": 2234.0, "hyperlinks": 2351.0, "robotstxt": 0.0, "wayback": 2396.0}, {"date": "2023-03-17", "sites": 1148, "cropped_screenshots": 2388, "full_screenshots": 2386.0, "lighthouse": 2332.0, "accessibility": 2232.0, "hyperlinks": 2348.0, "robotstxt": 0.0, "wayback": 2402.0}, {"date": "2023-03-18", "sites": 1148, "cropped_screenshots": 2383, "full_screenshots": 2379.0, "lighthouse": 2318.0, "accessibility": 2223.0, "hyperlinks": 2342.0, "robotstxt": 0.0, "wayback": 2394.0}, {"date": "2023-03-19", "sites": 1148, "cropped_screenshots": 2388, "full_screenshots": 2384.0, "lighthouse": 2335.0, "accessibility": 2242.0, "hyperlinks": 2360.0, "robotstxt": 0.0, "wayback": 2399.0}, {"date": "2023-03-20", "sites": 1148, "cropped_screenshots": 2388, "full_screenshots": 2384.0, "lighthouse": 2327.0, "accessibility": 2225.0, "hyperlinks": 2350.0, "robotstxt": 0.0, "wayback": 2362.0}, {"date": "2023-03-21", "sites": 1148, "cropped_screenshots": 2161, "full_screenshots": 2156.0, "lighthouse": 2118.0, "accessibility": 2024.0, "hyperlinks": 2126.0, "robotstxt": 0.0, "wayback": 2168.0}, {"date": "2023-03-22", "sites": 1148, "cropped_screenshots": 2162, "full_screenshots": 2158.0, "lighthouse": 2104.0, "accessibility": 2014.0, "hyperlinks": 2116.0, "robotstxt": 0.0, "wayback": 2124.0}, {"date": "2023-03-23", "sites": 1148, "cropped_screenshots": 2388, "full_screenshots": 2383.0, "lighthouse": 2332.0, "accessibility": 2227.0, "hyperlinks": 2344.0, "robotstxt": 0.0, "wayback": 2398.0}, {"date": "2023-03-24", "sites": 1148, "cropped_screenshots": 2386, "full_screenshots": 2383.0, "lighthouse": 2331.0, "accessibility": 2226.0, "hyperlinks": 2348.0, "robotstxt": 0.0, "wayback": 2395.0}, {"date": "2023-03-25", "sites": 1148, "cropped_screenshots": 2388, "full_screenshots": 2384.0, "lighthouse": 2330.0, "accessibility": 2233.0, "hyperlinks": 2344.0, "robotstxt": 0.0, "wayback": 2398.0}, {"date": "2023-03-26", "sites": 1148, "cropped_screenshots": 2388, "full_screenshots": 2383.0, "lighthouse": 2327.0, "accessibility": 2225.0, "hyperlinks": 2343.0, "robotstxt": 0.0, "wayback": 2397.0}, {"date": "2023-03-27", "sites": 1148, "cropped_screenshots": 2272, "full_screenshots": 2267.0, "lighthouse": 2212.0, "accessibility": 2120.0, "hyperlinks": 2227.0, "robotstxt": 0.0, "wayback": 2279.0}, {"date": "2023-03-28", "sites": 1149, "cropped_screenshots": 2389, "full_screenshots": 2385.0, "lighthouse": 2333.0, "accessibility": 2231.0, "hyperlinks": 2350.0, "robotstxt": 0.0, "wayback": 2400.0}, {"date": "2023-03-29", "sites": 1149, "cropped_screenshots": 2507, "full_screenshots": 2501.0, "lighthouse": 2444.0, "accessibility": 2329.0, "hyperlinks": 2459.0, "robotstxt": 0.0, "wayback": 2466.0}, {"date": "2023-03-30", "sites": 1149, "cropped_screenshots": 2389, "full_screenshots": 2384.0, "lighthouse": 2329.0, "accessibility": 2229.0, "hyperlinks": 2345.0, "robotstxt": 0.0, "wayback": 2398.0}, {"date": "2023-03-31", "sites": 1149, "cropped_screenshots": 2390, "full_screenshots": 2385.0, "lighthouse": 2327.0, "accessibility": 2229.0, "hyperlinks": 2349.0, "robotstxt": 0.0, "wayback": 2398.0}, {"date": "2023-04-01", "sites": 1149, "cropped_screenshots": 2388, "full_screenshots": 2383.0, "lighthouse": 2324.0, "accessibility": 2221.0, "hyperlinks": 2348.0, "robotstxt": 0.0, "wayback": 2397.0}, {"date": "2023-04-02", "sites": 1148, "cropped_screenshots": 2390, "full_screenshots": 2384.0, "lighthouse": 2330.0, "accessibility": 2260.0, "hyperlinks": 2347.0, "robotstxt": 0.0, "wayback": 2394.0}, {"date": "2023-04-03", "sites": 1148, "cropped_screenshots": 2385, "full_screenshots": 2383.0, "lighthouse": 2322.0, "accessibility": 2273.0, "hyperlinks": 2347.0, "robotstxt": 0.0, "wayback": 2398.0}, {"date": "2023-04-04", "sites": 1149, "cropped_screenshots": 2384, "full_screenshots": 2382.0, "lighthouse": 2323.0, "accessibility": 2265.0, "hyperlinks": 2341.0, "robotstxt": 0.0, "wayback": 2393.0}, {"date": "2023-04-05", "sites": 1148, "cropped_screenshots": 2389, "full_screenshots": 2382.0, "lighthouse": 2325.0, "accessibility": 2274.0, "hyperlinks": 2344.0, "robotstxt": 0.0, "wayback": 2397.0}, {"date": "2023-04-06", "sites": 1149, "cropped_screenshots": 2386, "full_screenshots": 2383.0, "lighthouse": 2326.0, "accessibility": 2269.0, "hyperlinks": 2351.0, "robotstxt": 0.0, "wayback": 2380.0}, {"date": "2023-04-07", "sites": 1149, "cropped_screenshots": 2388, "full_screenshots": 2384.0, "lighthouse": 2329.0, "accessibility": 2275.0, "hyperlinks": 2349.0, "robotstxt": 0.0, "wayback": 2372.0}, {"date": "2023-04-08", "sites": 1149, "cropped_screenshots": 2383, "full_screenshots": 2380.0, "lighthouse": 2316.0, "accessibility": 2252.0, "hyperlinks": 2345.0, "robotstxt": 0.0, "wayback": 2393.0}, {"date": "2023-04-09", "sites": 1149, "cropped_screenshots": 2378, "full_screenshots": 2375.0, "lighthouse": 2314.0, "accessibility": 2269.0, "hyperlinks": 2334.0, "robotstxt": 0.0, "wayback": 2386.0}, {"date": "2023-04-10", "sites": 1149, "cropped_screenshots": 2392, "full_screenshots": 2389.0, "lighthouse": 2334.0, "accessibility": 2270.0, "hyperlinks": 2352.0, "robotstxt": 0.0, "wayback": 2401.0}, {"date": "2023-04-11", "sites": 1149, "cropped_screenshots": 2390, "full_screenshots": 2387.0, "lighthouse": 2329.0, "accessibility": 2274.0, "hyperlinks": 2353.0, "robotstxt": 0.0, "wayback": 2397.0}, {"date": "2023-04-12", "sites": 1149, "cropped_screenshots": 2382, "full_screenshots": 2379.0, "lighthouse": 2328.0, "accessibility": 2277.0, "hyperlinks": 2349.0, "robotstxt": 0.0, "wayback": 2396.0}, {"date": "2023-04-13", "sites": 1149, "cropped_screenshots": 2389, "full_screenshots": 2387.0, "lighthouse": 2323.0, "accessibility": 2271.0, "hyperlinks": 2353.0, "robotstxt": 0.0, "wayback": 2282.0}, {"date": "2023-04-14", "sites": 1148, "cropped_screenshots": 2384, "full_screenshots": 2382.0, "lighthouse": 2324.0, "accessibility": 2273.0, "hyperlinks": 2348.0, "robotstxt": 0.0, "wayback": 2394.0}, {"date": "2023-04-15", "sites": 1148, "cropped_screenshots": 2380, "full_screenshots": 2377.0, "lighthouse": 2313.0, "accessibility": 2264.0, "hyperlinks": 2346.0, "robotstxt": 0.0, "wayback": 2392.0}, {"date": "2023-04-16", "sites": 1148, "cropped_screenshots": 2388, "full_screenshots": 2384.0, "lighthouse": 2329.0, "accessibility": 2270.0, "hyperlinks": 2348.0, "robotstxt": 0.0, "wayback": 2398.0}, {"date": "2023-04-17", "sites": 1149, "cropped_screenshots": 2379, "full_screenshots": 2378.0, "lighthouse": 2324.0, "accessibility": 2270.0, "hyperlinks": 2347.0, "robotstxt": 0.0, "wayback": 2395.0}, {"date": "2023-04-18", "sites": 1148, "cropped_screenshots": 2360, "full_screenshots": 2364.0, "lighthouse": 2311.0, "accessibility": 2263.0, "hyperlinks": 2343.0, "robotstxt": 0.0, "wayback": 2385.0}, {"date": "2023-04-19", "sites": 1145, "cropped_screenshots": 2193, "full_screenshots": 2260.0, "lighthouse": 2219.0, "accessibility": 2137.0, "hyperlinks": 2237.0, "robotstxt": 0.0, "wayback": 2287.0}, {"date": "2023-04-20", "sites": 1149, "cropped_screenshots": 2379, "full_screenshots": 2380.0, "lighthouse": 2325.0, "accessibility": 2257.0, "hyperlinks": 2345.0, "robotstxt": 0.0, "wayback": 2391.0}, {"date": "2023-04-21", "sites": 1149, "cropped_screenshots": 2382, "full_screenshots": 2381.0, "lighthouse": 2332.0, "accessibility": 2268.0, "hyperlinks": 2348.0, "robotstxt": 0.0, "wayback": 2398.0}, {"date": "2023-04-22", "sites": 1148, "cropped_screenshots": 2386, "full_screenshots": 2384.0, "lighthouse": 2328.0, "accessibility": 2277.0, "hyperlinks": 2351.0, "robotstxt": 0.0, "wayback": 2398.0}, {"date": "2023-04-23", "sites": 1149, "cropped_screenshots": 2389, "full_screenshots": 2384.0, "lighthouse": 2335.0, "accessibility": 2271.0, "hyperlinks": 2349.0, "robotstxt": 0.0, "wayback": 2373.0}, {"date": "2023-04-24", "sites": 1148, "cropped_screenshots": 2357, "full_screenshots": 2356.0, "lighthouse": 2302.0, "accessibility": 2246.0, "hyperlinks": 2323.0, "robotstxt": 0.0, "wayback": 2371.0}, {"date": "2023-04-25", "sites": 1149, "cropped_screenshots": 2377, "full_screenshots": 2377.0, "lighthouse": 2321.0, "accessibility": 2257.0, "hyperlinks": 2340.0, "robotstxt": 0.0, "wayback": 2390.0}, {"date": "2023-04-26", "sites": 1149, "cropped_screenshots": 2385, "full_screenshots": 2382.0, "lighthouse": 2323.0, "accessibility": 2264.0, "hyperlinks": 2343.0, "robotstxt": 0.0, "wayback": 2394.0}, {"date": "2023-04-27", "sites": 1149, "cropped_screenshots": 2389, "full_screenshots": 2385.0, "lighthouse": 2330.0, "accessibility": 2276.0, "hyperlinks": 2350.0, "robotstxt": 0.0, "wayback": 2400.0}, {"date": "2023-04-28", "sites": 1148, "cropped_screenshots": 2386, "full_screenshots": 2382.0, "lighthouse": 2321.0, "accessibility": 2267.0, "hyperlinks": 2343.0, "robotstxt": 0.0, "wayback": 2396.0}, {"date": "2023-04-29", "sites": 1149, "cropped_screenshots": 2390, "full_screenshots": 2388.0, "lighthouse": 2325.0, "accessibility": 2276.0, "hyperlinks": 2350.0, "robotstxt": 0.0, "wayback": 2401.0}, {"date": "2023-04-30", "sites": 1149, "cropped_screenshots": 2388, "full_screenshots": 2384.0, "lighthouse": 2321.0, "accessibility": 2272.0, "hyperlinks": 2343.0, "robotstxt": 0.0, "wayback": 2396.0}, {"date": "2023-05-01", "sites": 1148, "cropped_screenshots": 2193, "full_screenshots": 2192.0, "lighthouse": 2145.0, "accessibility": 2096.0, "hyperlinks": 2163.0, "robotstxt": 0.0, "wayback": 2207.0}, {"date": "2023-05-02", "sites": 1147, "cropped_screenshots": 1918, "full_screenshots": 1879.0, "lighthouse": 1726.0, "accessibility": 1750.0, "hyperlinks": 1764.0, "robotstxt": 0.0, "wayback": 1761.0}, {"date": "2023-05-03", "sites": 1149, "cropped_screenshots": 2579, "full_screenshots": 2577.0, "lighthouse": 2507.0, "accessibility": 2451.0, "hyperlinks": 2535.0, "robotstxt": 0.0, "wayback": 2592.0}, {"date": "2023-05-04", "sites": 1149, "cropped_screenshots": 2380, "full_screenshots": 2379.0, "lighthouse": 2325.0, "accessibility": 2252.0, "hyperlinks": 2348.0, "robotstxt": 0.0, "wayback": 2395.0}, {"date": "2023-05-05", "sites": 1149, "cropped_screenshots": 2394, "full_screenshots": 2391.0, "lighthouse": 2334.0, "accessibility": 2245.0, "hyperlinks": 2362.0, "robotstxt": 0.0, "wayback": 2403.0}, {"date": "2023-05-06", "sites": 1149, "cropped_screenshots": 2355, "full_screenshots": 2349.0, "lighthouse": 2288.0, "accessibility": 2231.0, "hyperlinks": 2320.0, "robotstxt": 0.0, "wayback": 2342.0}, {"date": "2023-05-07", "sites": 1148, "cropped_screenshots": 2401, "full_screenshots": 2400.0, "lighthouse": 2353.0, "accessibility": 2288.0, "hyperlinks": 2383.0, "robotstxt": 0.0, "wayback": 2415.0}, {"date": "2023-05-08", "sites": 1149, "cropped_screenshots": 2388, "full_screenshots": 2384.0, "lighthouse": 2355.0, "accessibility": 2317.0, "hyperlinks": 2388.0, "robotstxt": 0.0, "wayback": 2394.0}, {"date": "2023-05-09", "sites": 1044, "cropped_screenshots": 2086, "full_screenshots": 2082.0, "lighthouse": 2067.0, "accessibility": 2041.0, "hyperlinks": 2090.0, "robotstxt": 0.0, "wayback": 2092.0}, {"date": "2023-05-10", "sites": 1148, "cropped_screenshots": 2016, "full_screenshots": 2013.0, "lighthouse": 1994.0, "accessibility": 1972.0, "hyperlinks": 2020.0, "robotstxt": 0.0, "wayback": 2025.0}, {"date": "2023-05-11", "sites": 1148, "cropped_screenshots": 2240, "full_screenshots": 2238.0, "lighthouse": 2216.0, "accessibility": 2192.0, "hyperlinks": 2244.0, "robotstxt": 0.0, "wayback": 2250.0}, {"date": "2023-05-12", "sites": 1147, "cropped_screenshots": 2416, "full_screenshots": 2412.0, "lighthouse": 2391.0, "accessibility": 2345.0, "hyperlinks": 2421.0, "robotstxt": 0.0, "wayback": 2428.0}, {"date": "2023-05-13", "sites": 1146, "cropped_screenshots": 2383, "full_screenshots": 2379.0, "lighthouse": 2358.0, "accessibility": 2330.0, "hyperlinks": 2385.0, "robotstxt": 0.0, "wayback": 2394.0}, {"date": "2023-05-14", "sites": 1146, "cropped_screenshots": 2269, "full_screenshots": 2266.0, "lighthouse": 2249.0, "accessibility": 2222.0, "hyperlinks": 2274.0, "robotstxt": 0.0, "wayback": 2281.0}, {"date": "2023-05-15", "sites": 1147, "cropped_screenshots": 2327, "full_screenshots": 2363.0, "lighthouse": 2339.0, "accessibility": 2288.0, "hyperlinks": 2371.0, "robotstxt": 0.0, "wayback": 2380.0}, {"date": "2023-05-16", "sites": 1146, "cropped_screenshots": 2345, "full_screenshots": 2391.0, "lighthouse": 2372.0, "accessibility": 2299.0, "hyperlinks": 2403.0, "robotstxt": 0.0, "wayback": 2411.0}, {"date": "2023-05-17", "sites": 1147, "cropped_screenshots": 2313, "full_screenshots": 2311.0, "lighthouse": 2289.0, "accessibility": 2265.0, "hyperlinks": 2318.0, "robotstxt": 0.0, "wayback": 2327.0}, {"date": "2023-05-18", "sites": 1147, "cropped_screenshots": 2454, "full_screenshots": 2453.0, "lighthouse": 2432.0, "accessibility": 2402.0, "hyperlinks": 2458.0, "robotstxt": 0.0, "wayback": 2471.0}, {"date": "2023-05-19", "sites": 1147, "cropped_screenshots": 2357, "full_screenshots": 2356.0, "lighthouse": 2334.0, "accessibility": 2307.0, "hyperlinks": 2365.0, "robotstxt": 0.0, "wayback": 2373.0}, {"date": "2023-05-20", "sites": 1147, "cropped_screenshots": 2406, "full_screenshots": 2403.0, "lighthouse": 2379.0, "accessibility": 2352.0, "hyperlinks": 2411.0, "robotstxt": 0.0, "wayback": 2421.0}, {"date": "2023-05-21", "sites": 1148, "cropped_screenshots": 2386, "full_screenshots": 2384.0, "lighthouse": 2365.0, "accessibility": 2336.0, "hyperlinks": 2394.0, "robotstxt": 0.0, "wayback": 2400.0}, {"date": "2023-05-22", "sites": 1148, "cropped_screenshots": 2387, "full_screenshots": 2384.0, "lighthouse": 2362.0, "accessibility": 2336.0, "hyperlinks": 2392.0, "robotstxt": 0.0, "wayback": 2399.0}, {"date": "2023-05-23", "sites": 1148, "cropped_screenshots": 2300, "full_screenshots": 2307.0, "lighthouse": 2285.0, "accessibility": 2253.0, "hyperlinks": 2317.0, "robotstxt": 0.0, "wayback": 2323.0}, {"date": "2023-05-24", "sites": 1148, "cropped_screenshots": 2459, "full_screenshots": 2456.0, "lighthouse": 2425.0, "accessibility": 2405.0, "hyperlinks": 2465.0, "robotstxt": 0.0, "wayback": 2473.0}, {"date": "2023-05-25", "sites": 1148, "cropped_screenshots": 2383, "full_screenshots": 2380.0, "lighthouse": 2349.0, "accessibility": 2331.0, "hyperlinks": 2389.0, "robotstxt": 0.0, "wayback": 2395.0}, {"date": "2023-05-26", "sites": 1148, "cropped_screenshots": 2312, "full_screenshots": 2310.0, "lighthouse": 2275.0, "accessibility": 2260.0, "hyperlinks": 2319.0, "robotstxt": 0.0, "wayback": 2324.0}, {"date": "2023-05-27", "sites": 1148, "cropped_screenshots": 2450, "full_screenshots": 2452.0, "lighthouse": 2414.0, "accessibility": 2403.0, "hyperlinks": 2459.0, "robotstxt": 0.0, "wayback": 2468.0}, {"date": "2023-05-28", "sites": 1148, "cropped_screenshots": 2384, "full_screenshots": 2383.0, "lighthouse": 2344.0, "accessibility": 2337.0, "hyperlinks": 2391.0, "robotstxt": 0.0, "wayback": 2396.0}, {"date": "2023-05-29", "sites": 1147, "cropped_screenshots": 2321, "full_screenshots": 2319.0, "lighthouse": 2286.0, "accessibility": 2273.0, "hyperlinks": 2329.0, "robotstxt": 0.0, "wayback": 2336.0}, {"date": "2023-05-30", "sites": 1148, "cropped_screenshots": 2385, "full_screenshots": 2385.0, "lighthouse": 2346.0, "accessibility": 2336.0, "hyperlinks": 2394.0, "robotstxt": 0.0, "wayback": 2401.0}, {"date": "2023-05-31", "sites": 1147, "cropped_screenshots": 2375, "full_screenshots": 2377.0, "lighthouse": 2343.0, "accessibility": 2325.0, "hyperlinks": 2386.0, "robotstxt": 0.0, "wayback": 2367.0}, {"date": "2023-06-01", "sites": 1148, "cropped_screenshots": 2328, "full_screenshots": 2292.0, "lighthouse": 2166.0, "accessibility": 2216.0, "hyperlinks": 2234.0, "robotstxt": 0.0, "wayback": 2189.0}, {"date": "2023-06-02", "sites": 1148, "cropped_screenshots": 2388, "full_screenshots": 2385.0, "lighthouse": 2351.0, "accessibility": 2335.0, "hyperlinks": 2394.0, "robotstxt": 0.0, "wayback": 2403.0}, {"date": "2023-06-03", "sites": 1147, "cropped_screenshots": 2379, "full_screenshots": 2380.0, "lighthouse": 2344.0, "accessibility": 2334.0, "hyperlinks": 2389.0, "robotstxt": 0.0, "wayback": 2397.0}, {"date": "2023-06-04", "sites": 1148, "cropped_screenshots": 2382, "full_screenshots": 2381.0, "lighthouse": 2346.0, "accessibility": 2330.0, "hyperlinks": 2389.0, "robotstxt": 0.0, "wayback": 2396.0}, {"date": "2023-06-05", "sites": 1148, "cropped_screenshots": 2385, "full_screenshots": 2383.0, "lighthouse": 2348.0, "accessibility": 2335.0, "hyperlinks": 2391.0, "robotstxt": 0.0, "wayback": 2397.0}, {"date": "2023-06-06", "sites": 1146, "cropped_screenshots": 2275, "full_screenshots": 2247.0, "lighthouse": 2107.0, "accessibility": 2170.0, "hyperlinks": 2181.0, "robotstxt": 0.0, "wayback": 2122.0}, {"date": "2023-06-07", "sites": 1148, "cropped_screenshots": 2349, "full_screenshots": 2347.0, "lighthouse": 2309.0, "accessibility": 2302.0, "hyperlinks": 2353.0, "robotstxt": 0.0, "wayback": 2358.0}, {"date": "2023-06-08", "sites": 1148, "cropped_screenshots": 2398, "full_screenshots": 2394.0, "lighthouse": 2358.0, "accessibility": 2347.0, "hyperlinks": 2399.0, "robotstxt": 0.0, "wayback": 2408.0}, {"date": "2023-06-09", "sites": 1147, "cropped_screenshots": 2271, "full_screenshots": 2248.0, "lighthouse": 2054.0, "accessibility": 2171.0, "hyperlinks": 2170.0, "robotstxt": 0.0, "wayback": 2033.0}, {"date": "2023-06-10", "sites": 1139, "cropped_screenshots": 2268, "full_screenshots": 2152.0, "lighthouse": 1577.0, "accessibility": 1948.0, "hyperlinks": 1823.0, "robotstxt": 0.0, "wayback": 1437.0}, {"date": "2023-06-11", "sites": 1148, "cropped_screenshots": 2432, "full_screenshots": 2394.0, "lighthouse": 2203.0, "accessibility": 2295.0, "hyperlinks": 2291.0, "robotstxt": 0.0, "wayback": 2196.0}, {"date": "2023-06-12", "sites": 1148, "cropped_screenshots": 2327, "full_screenshots": 2323.0, "lighthouse": 2285.0, "accessibility": 2275.0, "hyperlinks": 2332.0, "robotstxt": 0.0, "wayback": 2337.0}, {"date": "2023-06-13", "sites": 1149, "cropped_screenshots": 2290, "full_screenshots": 2261.0, "lighthouse": 2160.0, "accessibility": 2202.0, "hyperlinks": 2225.0, "robotstxt": 0.0, "wayback": 2180.0}, {"date": "2023-06-14", "sites": 1149, "cropped_screenshots": 2188, "full_screenshots": 2126.0, "lighthouse": 1898.0, "accessibility": 2007.0, "hyperlinks": 1991.0, "robotstxt": 0.0, "wayback": 1895.0}, {"date": "2023-06-15", "sites": 1150, "cropped_screenshots": 2417, "full_screenshots": 2412.0, "lighthouse": 2369.0, "accessibility": 2362.0, "hyperlinks": 2417.0, "robotstxt": 0.0, "wayback": 2417.0}, {"date": "2023-06-16", "sites": 1150, "cropped_screenshots": 2185, "full_screenshots": 2149.0, "lighthouse": 1940.0, "accessibility": 2046.0, "hyperlinks": 2030.0, "robotstxt": 0.0, "wayback": 1920.0}, {"date": "2023-06-17", "sites": 1149, "cropped_screenshots": 2346, "full_screenshots": 2278.0, "lighthouse": 1990.0, "accessibility": 2143.0, "hyperlinks": 2103.0, "robotstxt": 0.0, "wayback": 1973.0}, {"date": "2023-06-18", "sites": 1149, "cropped_screenshots": 2385, "full_screenshots": 2379.0, "lighthouse": 2343.0, "accessibility": 2336.0, "hyperlinks": 2388.0, "robotstxt": 0.0, "wayback": 2290.0}, {"date": "2023-06-19", "sites": 1150, "cropped_screenshots": 2389, "full_screenshots": 2390.0, "lighthouse": 2357.0, "accessibility": 2344.0, "hyperlinks": 2399.0, "robotstxt": 0.0, "wayback": 2384.0}, {"date": "2023-06-20", "sites": 1150, "cropped_screenshots": 2359, "full_screenshots": 2374.0, "lighthouse": 2336.0, "accessibility": 2301.0, "hyperlinks": 2379.0, "robotstxt": 0.0, "wayback": 2343.0}, {"date": "2023-06-21", "sites": 1150, "cropped_screenshots": 2382, "full_screenshots": 2383.0, "lighthouse": 2345.0, "accessibility": 2335.0, "hyperlinks": 2391.0, "robotstxt": 0.0, "wayback": 2260.0}, {"date": "2023-06-22", "sites": 1150, "cropped_screenshots": 2391, "full_screenshots": 2387.0, "lighthouse": 2339.0, "accessibility": 2321.0, "hyperlinks": 2393.0, "robotstxt": 0.0, "wayback": 2399.0}, {"date": "2023-06-23", "sites": 1150, "cropped_screenshots": 2382, "full_screenshots": 2379.0, "lighthouse": 2341.0, "accessibility": 2329.0, "hyperlinks": 2387.0, "robotstxt": 0.0, "wayback": 2393.0}, {"date": "2023-06-24", "sites": 1150, "cropped_screenshots": 2385, "full_screenshots": 2384.0, "lighthouse": 2342.0, "accessibility": 2329.0, "hyperlinks": 2389.0, "robotstxt": 0.0, "wayback": 2395.0}, {"date": "2023-06-25", "sites": 1150, "cropped_screenshots": 2393, "full_screenshots": 2389.0, "lighthouse": 2343.0, "accessibility": 2337.0, "hyperlinks": 2393.0, "robotstxt": 0.0, "wayback": 2397.0}, {"date": "2023-06-26", "sites": 1150, "cropped_screenshots": 2389, "full_screenshots": 2382.0, "lighthouse": 2344.0, "accessibility": 2335.0, "hyperlinks": 2390.0, "robotstxt": 0.0, "wayback": 2394.0}, {"date": "2023-06-27", "sites": 1150, "cropped_screenshots": 2390, "full_screenshots": 2387.0, "lighthouse": 2348.0, "accessibility": 2336.0, "hyperlinks": 2392.0, "robotstxt": 0.0, "wayback": 2397.0}, {"date": "2023-06-28", "sites": 1150, "cropped_screenshots": 2378, "full_screenshots": 2383.0, "lighthouse": 2344.0, "accessibility": 2331.0, "hyperlinks": 2387.0, "robotstxt": 0.0, "wayback": 2392.0}, {"date": "2023-06-29", "sites": 1147, "cropped_screenshots": 2017, "full_screenshots": 2268.0, "lighthouse": 2233.0, "accessibility": 2086.0, "hyperlinks": 2275.0, "robotstxt": 0.0, "wayback": 2281.0}, {"date": "2023-06-30", "sites": 1150, "cropped_screenshots": 2382, "full_screenshots": 2378.0, "lighthouse": 2340.0, "accessibility": 2331.0, "hyperlinks": 2386.0, "robotstxt": 0.0, "wayback": 2391.0}, {"date": "2023-07-01", "sites": 1149, "cropped_screenshots": 2384, "full_screenshots": 2382.0, "lighthouse": 2345.0, "accessibility": 2329.0, "hyperlinks": 2388.0, "robotstxt": 0.0, "wayback": 2391.0}, {"date": "2023-07-02", "sites": 1150, "cropped_screenshots": 2382, "full_screenshots": 2382.0, "lighthouse": 2338.0, "accessibility": 2335.0, "hyperlinks": 2391.0, "robotstxt": 0.0, "wayback": 2397.0}, {"date": "2023-07-03", "sites": 1150, "cropped_screenshots": 2334, "full_screenshots": 2331.0, "lighthouse": 2299.0, "accessibility": 2287.0, "hyperlinks": 2340.0, "robotstxt": 0.0, "wayback": 2343.0}, {"date": "2023-07-04", "sites": 1150, "cropped_screenshots": 2359, "full_screenshots": 2326.0, "lighthouse": 2236.0, "accessibility": 2257.0, "hyperlinks": 2295.0, "robotstxt": 0.0, "wayback": 2281.0}, {"date": "2023-07-05", "sites": 1150, "cropped_screenshots": 2357, "full_screenshots": 2355.0, "lighthouse": 2319.0, "accessibility": 2311.0, "hyperlinks": 2365.0, "robotstxt": 0.0, "wayback": 2368.0}, {"date": "2023-07-06", "sites": 1150, "cropped_screenshots": 2397, "full_screenshots": 2394.0, "lighthouse": 2375.0, "accessibility": 2362.0, "hyperlinks": 2420.0, "robotstxt": 0.0, "wayback": 2425.0}, {"date": "2023-07-07", "sites": 1150, "cropped_screenshots": 2279, "full_screenshots": 2272.0, "lighthouse": 2237.0, "accessibility": 2226.0, "hyperlinks": 2282.0, "robotstxt": 0.0, "wayback": 2285.0}, {"date": "2023-07-08", "sites": 1150, "cropped_screenshots": 2502, "full_screenshots": 2496.0, "lighthouse": 2458.0, "accessibility": 2446.0, "hyperlinks": 2503.0, "robotstxt": 0.0, "wayback": 2507.0}, {"date": "2023-07-09", "sites": 1150, "cropped_screenshots": 2387, "full_screenshots": 2383.0, "lighthouse": 2340.0, "accessibility": 2336.0, "hyperlinks": 2389.0, "robotstxt": 0.0, "wayback": 2396.0}, {"date": "2023-07-10", "sites": 1150, "cropped_screenshots": 2377, "full_screenshots": 2377.0, "lighthouse": 2335.0, "accessibility": 2312.0, "hyperlinks": 2383.0, "robotstxt": 0.0, "wayback": 2389.0}, {"date": "2023-07-11", "sites": 1149, "cropped_screenshots": 2366, "full_screenshots": 2362.0, "lighthouse": 2319.0, "accessibility": 2170.0, "hyperlinks": 2367.0, "robotstxt": 0.0, "wayback": 2371.0}, {"date": "2023-07-12", "sites": 1149, "cropped_screenshots": 2397, "full_screenshots": 2393.0, "lighthouse": 2352.0, "accessibility": 2202.0, "hyperlinks": 2396.0, "robotstxt": 0.0, "wayback": 2405.0}, {"date": "2023-07-13", "sites": 1149, "cropped_screenshots": 2407, "full_screenshots": 2405.0, "lighthouse": 2368.0, "accessibility": 2352.0, "hyperlinks": 2411.0, "robotstxt": 0.0, "wayback": 2420.0}, {"date": "2023-07-14", "sites": 1148, "cropped_screenshots": 2387, "full_screenshots": 2384.0, "lighthouse": 2343.0, "accessibility": 2330.0, "hyperlinks": 2394.0, "robotstxt": 0.0, "wayback": 2401.0}, {"date": "2023-07-15", "sites": 1149, "cropped_screenshots": 2360, "full_screenshots": 2360.0, "lighthouse": 2318.0, "accessibility": 2218.0, "hyperlinks": 2365.0, "robotstxt": 0.0, "wayback": 2372.0}, {"date": "2023-07-16", "sites": 1149, "cropped_screenshots": 2406, "full_screenshots": 2403.0, "lighthouse": 2361.0, "accessibility": 2310.0, "hyperlinks": 2408.0, "robotstxt": 0.0, "wayback": 2416.0}, {"date": "2023-07-17", "sites": 1147, "cropped_screenshots": 2046, "full_screenshots": 2042.0, "lighthouse": 2011.0, "accessibility": 1997.0, "hyperlinks": 2048.0, "robotstxt": 0.0, "wayback": 2055.0}, {"date": "2023-07-18", "sites": 1149, "cropped_screenshots": 2398, "full_screenshots": 2397.0, "lighthouse": 2361.0, "accessibility": 2348.0, "hyperlinks": 2406.0, "robotstxt": 0.0, "wayback": 2413.0}, {"date": "2023-07-19", "sites": 1148, "cropped_screenshots": 2380, "full_screenshots": 2379.0, "lighthouse": 2335.0, "accessibility": 2328.0, "hyperlinks": 2386.0, "robotstxt": 0.0, "wayback": 2358.0}, {"date": "2023-07-20", "sites": 1149, "cropped_screenshots": 2326, "full_screenshots": 2322.0, "lighthouse": 2288.0, "accessibility": 2278.0, "hyperlinks": 2331.0, "robotstxt": 0.0, "wayback": 2293.0}, {"date": "2023-07-21", "sites": 1149, "cropped_screenshots": 2438, "full_screenshots": 2438.0, "lighthouse": 2391.0, "accessibility": 2388.0, "hyperlinks": 2443.0, "robotstxt": 0.0, "wayback": 2455.0}, {"date": "2023-07-22", "sites": 1149, "cropped_screenshots": 2390, "full_screenshots": 2388.0, "lighthouse": 2346.0, "accessibility": 2338.0, "hyperlinks": 2394.0, "robotstxt": 0.0, "wayback": 2401.0}, {"date": "2023-07-23", "sites": 1149, "cropped_screenshots": 2388, "full_screenshots": 2384.0, "lighthouse": 2346.0, "accessibility": 2336.0, "hyperlinks": 2392.0, "robotstxt": 0.0, "wayback": 2398.0}, {"date": "2023-07-24", "sites": 1149, "cropped_screenshots": 2371, "full_screenshots": 2372.0, "lighthouse": 2334.0, "accessibility": 2320.0, "hyperlinks": 2378.0, "robotstxt": 0.0, "wayback": 2360.0}, {"date": "2023-07-25", "sites": 1149, "cropped_screenshots": 2401, "full_screenshots": 2401.0, "lighthouse": 2363.0, "accessibility": 2341.0, "hyperlinks": 2408.0, "robotstxt": 0.0, "wayback": 2415.0}, {"date": "2023-07-26", "sites": 1149, "cropped_screenshots": 2380, "full_screenshots": 2379.0, "lighthouse": 2336.0, "accessibility": 2336.0, "hyperlinks": 2389.0, "robotstxt": 0.0, "wayback": 2397.0}, {"date": "2023-07-27", "sites": 1149, "cropped_screenshots": 2387, "full_screenshots": 2386.0, "lighthouse": 2348.0, "accessibility": 2339.0, "hyperlinks": 2392.0, "robotstxt": 0.0, "wayback": 2398.0}, {"date": "2023-07-28", "sites": 1149, "cropped_screenshots": 2386, "full_screenshots": 2383.0, "lighthouse": 2343.0, "accessibility": 2334.0, "hyperlinks": 2390.0, "robotstxt": 0.0, "wayback": 2388.0}, {"date": "2023-07-29", "sites": 1148, "cropped_screenshots": 2387, "full_screenshots": 2383.0, "lighthouse": 2345.0, "accessibility": 2335.0, "hyperlinks": 2393.0, "robotstxt": 0.0, "wayback": 2400.0}, {"date": "2023-07-30", "sites": 1148, "cropped_screenshots": 2387, "full_screenshots": 2386.0, "lighthouse": 2347.0, "accessibility": 2336.0, "hyperlinks": 2391.0, "robotstxt": 0.0, "wayback": 2399.0}, {"date": "2023-07-31", "sites": 1149, "cropped_screenshots": 2278, "full_screenshots": 2263.0, "lighthouse": 2181.0, "accessibility": 2197.0, "hyperlinks": 2237.0, "robotstxt": 0.0, "wayback": 2094.0}, {"date": "2023-08-01", "sites": 1149, "cropped_screenshots": 2358, "full_screenshots": 2387.0, "lighthouse": 2350.0, "accessibility": 2329.0, "hyperlinks": 2393.0, "robotstxt": 0.0, "wayback": 2373.0}, {"date": "2023-08-02", "sites": 1149, "cropped_screenshots": 2381, "full_screenshots": 2381.0, "lighthouse": 2343.0, "accessibility": 2330.0, "hyperlinks": 2388.0, "robotstxt": 0.0, "wayback": 2394.0}, {"date": "2023-08-03", "sites": 1148, "cropped_screenshots": 2391, "full_screenshots": 2388.0, "lighthouse": 2351.0, "accessibility": 2336.0, "hyperlinks": 2396.0, "robotstxt": 0.0, "wayback": 2404.0}, {"date": "2023-08-04", "sites": 1149, "cropped_screenshots": 2387, "full_screenshots": 2384.0, "lighthouse": 2342.0, "accessibility": 2332.0, "hyperlinks": 2391.0, "robotstxt": 0.0, "wayback": 2397.0}, {"date": "2023-08-05", "sites": 1149, "cropped_screenshots": 2386, "full_screenshots": 2386.0, "lighthouse": 2347.0, "accessibility": 2337.0, "hyperlinks": 2393.0, "robotstxt": 0.0, "wayback": 2399.0}, {"date": "2023-08-06", "sites": 1149, "cropped_screenshots": 2387, "full_screenshots": 2385.0, "lighthouse": 2342.0, "accessibility": 2334.0, "hyperlinks": 2391.0, "robotstxt": 0.0, "wayback": 2397.0}, {"date": "2023-08-07", "sites": 1149, "cropped_screenshots": 2372, "full_screenshots": 2373.0, "lighthouse": 2330.0, "accessibility": 2324.0, "hyperlinks": 2380.0, "robotstxt": 0.0, "wayback": 2385.0}, {"date": "2023-08-08", "sites": 1149, "cropped_screenshots": 2396, "full_screenshots": 2390.0, "lighthouse": 2345.0, "accessibility": 2339.0, "hyperlinks": 2392.0, "robotstxt": 0.0, "wayback": 2354.0}, {"date": "2023-08-09", "sites": 1149, "cropped_screenshots": 2379, "full_screenshots": 2377.0, "lighthouse": 2336.0, "accessibility": 2327.0, "hyperlinks": 2384.0, "robotstxt": 0.0, "wayback": 2349.0}, {"date": "2023-08-10", "sites": 1149, "cropped_screenshots": 2386, "full_screenshots": 2379.0, "lighthouse": 2332.0, "accessibility": 2322.0, "hyperlinks": 2382.0, "robotstxt": 0.0, "wayback": 2348.0}, {"date": "2023-08-11", "sites": 1149, "cropped_screenshots": 2381, "full_screenshots": 2378.0, "lighthouse": 2338.0, "accessibility": 2326.0, "hyperlinks": 2386.0, "robotstxt": 0.0, "wayback": 2287.0}, {"date": "2023-08-12", "sites": 1149, "cropped_screenshots": 2396, "full_screenshots": 2390.0, "lighthouse": 2352.0, "accessibility": 2338.0, "hyperlinks": 2398.0, "robotstxt": 0.0, "wayback": 2343.0}, {"date": "2023-08-13", "sites": 1149, "cropped_screenshots": 2369, "full_screenshots": 2367.0, "lighthouse": 2326.0, "accessibility": 2307.0, "hyperlinks": 2373.0, "robotstxt": 0.0, "wayback": 2358.0}, {"date": "2023-08-14", "sites": 1149, "cropped_screenshots": 2403, "full_screenshots": 2399.0, "lighthouse": 2361.0, "accessibility": 2336.0, "hyperlinks": 2406.0, "robotstxt": 0.0, "wayback": 2397.0}, {"date": "2023-08-15", "sites": 1148, "cropped_screenshots": 2330, "full_screenshots": 2326.0, "lighthouse": 2292.0, "accessibility": 2277.0, "hyperlinks": 2333.0, "robotstxt": 0.0, "wayback": 2343.0}, {"date": "2023-08-16", "sites": 1149, "cropped_screenshots": 2446, "full_screenshots": 2445.0, "lighthouse": 2399.0, "accessibility": 2381.0, "hyperlinks": 2447.0, "robotstxt": 0.0, "wayback": 2451.0}, {"date": "2023-08-17", "sites": 1125, "cropped_screenshots": 1989, "full_screenshots": 1833.0, "lighthouse": 1398.0, "accessibility": 1621.0, "hyperlinks": 1545.0, "robotstxt": 0.0, "wayback": 1333.0}, {"date": "2023-08-18", "sites": 1148, "cropped_screenshots": 2007, "full_screenshots": 1990.0, "lighthouse": 1951.0, "accessibility": 1936.0, "hyperlinks": 1986.0, "robotstxt": 0.0, "wayback": 1992.0}, {"date": "2023-08-19", "sites": 1149, "cropped_screenshots": 2393, "full_screenshots": 2386.0, "lighthouse": 2348.0, "accessibility": 2334.0, "hyperlinks": 2395.0, "robotstxt": 0.0, "wayback": 2400.0}, {"date": "2023-08-20", "sites": 1149, "cropped_screenshots": 2342, "full_screenshots": 2341.0, "lighthouse": 2301.0, "accessibility": 2277.0, "hyperlinks": 2344.0, "robotstxt": 0.0, "wayback": 2349.0}, {"date": "2023-08-21", "sites": 1149, "cropped_screenshots": 2410, "full_screenshots": 2408.0, "lighthouse": 2368.0, "accessibility": 2337.0, "hyperlinks": 2413.0, "robotstxt": 0.0, "wayback": 2423.0}, {"date": "2023-08-22", "sites": 1149, "cropped_screenshots": 2365, "full_screenshots": 2359.0, "lighthouse": 2319.0, "accessibility": 2302.0, "hyperlinks": 2365.0, "robotstxt": 0.0, "wayback": 1956.0}, {"date": "2023-08-23", "sites": 1149, "cropped_screenshots": 2380, "full_screenshots": 2377.0, "lighthouse": 2339.0, "accessibility": 2319.0, "hyperlinks": 2382.0, "robotstxt": 0.0, "wayback": 1818.0}, {"date": "2023-08-24", "sites": 1149, "cropped_screenshots": 2413, "full_screenshots": 2407.0, "lighthouse": 2367.0, "accessibility": 2348.0, "hyperlinks": 2412.0, "robotstxt": 0.0, "wayback": 2293.0}, {"date": "2023-08-25", "sites": 1149, "cropped_screenshots": 2291, "full_screenshots": 2283.0, "lighthouse": 2239.0, "accessibility": 2228.0, "hyperlinks": 2283.0, "robotstxt": 0.0, "wayback": 2273.0}, {"date": "2023-08-26", "sites": 1148, "cropped_screenshots": 1758, "full_screenshots": 1737.0, "lighthouse": 1659.0, "accessibility": 1663.0, "hyperlinks": 1707.0, "robotstxt": 1.0, "wayback": 1689.0}, {"date": "2023-08-27", "sites": 1120, "cropped_screenshots": 1961, "full_screenshots": 1861.0, "lighthouse": 1645.0, "accessibility": 1710.0, "hyperlinks": 1715.0, "robotstxt": 930.0, "wayback": 1650.0}, {"date": "2023-08-28", "sites": 1148, "cropped_screenshots": 1910, "full_screenshots": 1855.0, "lighthouse": 1731.0, "accessibility": 1753.0, "hyperlinks": 1793.0, "robotstxt": 1678.0, "wayback": 1733.0}, {"date": "2023-08-29", "sites": 1149, "cropped_screenshots": 2453, "full_screenshots": 2452.0, "lighthouse": 2409.0, "accessibility": 2398.0, "hyperlinks": 2460.0, "robotstxt": 2392.0, "wayback": 2412.0}, {"date": "2023-08-30", "sites": 1149, "cropped_screenshots": 2047, "full_screenshots": 2004.0, "lighthouse": 1887.0, "accessibility": 1923.0, "hyperlinks": 1945.0, "robotstxt": 1842.0, "wayback": 1807.0}, {"date": "2023-08-31", "sites": 1149, "cropped_screenshots": 2478, "full_screenshots": 2438.0, "lighthouse": 2342.0, "accessibility": 2363.0, "hyperlinks": 2398.0, "robotstxt": 2312.0, "wayback": 2279.0}, {"date": "2023-09-01", "sites": 1149, "cropped_screenshots": 2359, "full_screenshots": 2356.0, "lighthouse": 2315.0, "accessibility": 2308.0, "hyperlinks": 2363.0, "robotstxt": 2293.0, "wayback": 2350.0}, {"date": "2023-09-02", "sites": 1149, "cropped_screenshots": 2412, "full_screenshots": 2407.0, "lighthouse": 2363.0, "accessibility": 2343.0, "hyperlinks": 2410.0, "robotstxt": 2337.0, "wayback": 2369.0}, {"date": "2023-09-03", "sites": 1149, "cropped_screenshots": 2387, "full_screenshots": 2384.0, "lighthouse": 2343.0, "accessibility": 2310.0, "hyperlinks": 2389.0, "robotstxt": 2324.0, "wayback": 2337.0}, {"date": "2023-09-04", "sites": 1148, "cropped_screenshots": 2157, "full_screenshots": 2150.0, "lighthouse": 2105.0, "accessibility": 2075.0, "hyperlinks": 2151.0, "robotstxt": 2075.0, "wayback": 2031.0}, {"date": "2023-09-05", "sites": 1148, "cropped_screenshots": 2306, "full_screenshots": 2249.0, "lighthouse": 2047.0, "accessibility": 2121.0, "hyperlinks": 2143.0, "robotstxt": 1955.0, "wayback": 1813.0}, {"date": "2023-09-06", "sites": 1149, "cropped_screenshots": 2207, "full_screenshots": 2200.0, "lighthouse": 2153.0, "accessibility": 2150.0, "hyperlinks": 2199.0, "robotstxt": 2130.0, "wayback": 2197.0}, {"date": "2023-09-07", "sites": 1149, "cropped_screenshots": 2192, "full_screenshots": 2163.0, "lighthouse": 2069.0, "accessibility": 2084.0, "hyperlinks": 2132.0, "robotstxt": 2029.0, "wayback": 2103.0}, {"date": "2023-09-08", "sites": 1149, "cropped_screenshots": 2270, "full_screenshots": 2239.0, "lighthouse": 2158.0, "accessibility": 2142.0, "hyperlinks": 2204.0, "robotstxt": 2120.0, "wayback": 2197.0}, {"date": "2023-09-09", "sites": 1149, "cropped_screenshots": 2386, "full_screenshots": 2381.0, "lighthouse": 2342.0, "accessibility": 2327.0, "hyperlinks": 2388.0, "robotstxt": 2323.0, "wayback": 2394.0}, {"date": "2023-09-10", "sites": 1149, "cropped_screenshots": 2384, "full_screenshots": 2377.0, "lighthouse": 2334.0, "accessibility": 2327.0, "hyperlinks": 2380.0, "robotstxt": 2309.0, "wayback": 2384.0}, {"date": "2023-09-11", "sites": 1149, "cropped_screenshots": 2375, "full_screenshots": 2365.0, "lighthouse": 2311.0, "accessibility": 2300.0, "hyperlinks": 2362.0, "robotstxt": 2281.0, "wayback": 2358.0}, {"date": "2023-09-12", "sites": 1148, "cropped_screenshots": 2254, "full_screenshots": 2231.0, "lighthouse": 2132.0, "accessibility": 2157.0, "hyperlinks": 2198.0, "robotstxt": 2082.0, "wayback": 2166.0}, {"date": "2023-09-13", "sites": 1149, "cropped_screenshots": 2407, "full_screenshots": 2373.0, "lighthouse": 2259.0, "accessibility": 2269.0, "hyperlinks": 2331.0, "robotstxt": 2195.0, "wayback": 2285.0}, {"date": "2023-09-14", "sites": 1150, "cropped_screenshots": 2389, "full_screenshots": 2384.0, "lighthouse": 2343.0, "accessibility": 2298.0, "hyperlinks": 2389.0, "robotstxt": 2321.0, "wayback": 2392.0}, {"date": "2023-09-15", "sites": 1150, "cropped_screenshots": 2389, "full_screenshots": 2384.0, "lighthouse": 2347.0, "accessibility": 2304.0, "hyperlinks": 2389.0, "robotstxt": 2323.0, "wayback": 1885.0}, {"date": "2023-09-16", "sites": 1150, "cropped_screenshots": 2353, "full_screenshots": 2329.0, "lighthouse": 2231.0, "accessibility": 2229.0, "hyperlinks": 2291.0, "robotstxt": 2183.0, "wayback": 2268.0}, {"date": "2023-09-17", "sites": 1150, "cropped_screenshots": 2384, "full_screenshots": 2377.0, "lighthouse": 2334.0, "accessibility": 2290.0, "hyperlinks": 2382.0, "robotstxt": 2300.0, "wayback": 2365.0}, {"date": "2023-09-18", "sites": 1150, "cropped_screenshots": 2311, "full_screenshots": 2266.0, "lighthouse": 2160.0, "accessibility": 2161.0, "hyperlinks": 2219.0, "robotstxt": 2104.0, "wayback": 2160.0}, {"date": "2023-09-19", "sites": 1149, "cropped_screenshots": 2388, "full_screenshots": 2383.0, "lighthouse": 2350.0, "accessibility": 2300.0, "hyperlinks": 2391.0, "robotstxt": 2325.0, "wayback": 2303.0}, {"date": "2023-09-20", "sites": 1150, "cropped_screenshots": 2391, "full_screenshots": 2386.0, "lighthouse": 2348.0, "accessibility": 2261.0, "hyperlinks": 2392.0, "robotstxt": 2323.0, "wayback": 2394.0}, {"date": "2023-09-21", "sites": 1151, "cropped_screenshots": 2395, "full_screenshots": 2390.0, "lighthouse": 2349.0, "accessibility": 2312.0, "hyperlinks": 2397.0, "robotstxt": 2329.0, "wayback": 2401.0}, {"date": "2023-09-22", "sites": 1151, "cropped_screenshots": 2393, "full_screenshots": 2387.0, "lighthouse": 2327.0, "accessibility": 2299.0, "hyperlinks": 2391.0, "robotstxt": 2324.0, "wayback": 2397.0}, {"date": "2023-09-23", "sites": 1151, "cropped_screenshots": 2394, "full_screenshots": 2391.0, "lighthouse": 2339.0, "accessibility": 2306.0, "hyperlinks": 2397.0, "robotstxt": 2327.0, "wayback": 2397.0}, {"date": "2023-09-24", "sites": 1150, "cropped_screenshots": 2393, "full_screenshots": 2388.0, "lighthouse": 2333.0, "accessibility": 2307.0, "hyperlinks": 2394.0, "robotstxt": 2327.0, "wayback": 2401.0}, {"date": "2023-09-25", "sites": 1149, "cropped_screenshots": 2386, "full_screenshots": 2381.0, "lighthouse": 2332.0, "accessibility": 2298.0, "hyperlinks": 2388.0, "robotstxt": 2320.0, "wayback": 2397.0}, {"date": "2023-09-26", "sites": 1149, "cropped_screenshots": 2387, "full_screenshots": 2380.0, "lighthouse": 2323.0, "accessibility": 2289.0, "hyperlinks": 2389.0, "robotstxt": 2322.0, "wayback": 2396.0}, {"date": "2023-09-27", "sites": 1150, "cropped_screenshots": 2390, "full_screenshots": 2385.0, "lighthouse": 2332.0, "accessibility": 2291.0, "hyperlinks": 2395.0, "robotstxt": 2327.0, "wayback": 2396.0}, {"date": "2023-09-28", "sites": 1150, "cropped_screenshots": 2389, "full_screenshots": 2383.0, "lighthouse": 2328.0, "accessibility": 2293.0, "hyperlinks": 2391.0, "robotstxt": 2327.0, "wayback": 2392.0}, {"date": "2023-09-29", "sites": 1150, "cropped_screenshots": 2392, "full_screenshots": 2386.0, "lighthouse": 2340.0, "accessibility": 2300.0, "hyperlinks": 2395.0, "robotstxt": 2331.0, "wayback": 2402.0}, {"date": "2023-09-30", "sites": 1149, "cropped_screenshots": 2383, "full_screenshots": 2377.0, "lighthouse": 2331.0, "accessibility": 2288.0, "hyperlinks": 2388.0, "robotstxt": 2322.0, "wayback": 2394.0}, {"date": "2023-10-01", "sites": 1149, "cropped_screenshots": 2389, "full_screenshots": 2383.0, "lighthouse": 2333.0, "accessibility": 2291.0, "hyperlinks": 2393.0, "robotstxt": 2327.0, "wayback": 2400.0}, {"date": "2023-10-02", "sites": 1149, "cropped_screenshots": 2384, "full_screenshots": 2378.0, "lighthouse": 2335.0, "accessibility": 2284.0, "hyperlinks": 2385.0, "robotstxt": 2320.0, "wayback": 2393.0}, {"date": "2023-10-03", "sites": 1150, "cropped_screenshots": 2387, "full_screenshots": 2381.0, "lighthouse": 2327.0, "accessibility": 2278.0, "hyperlinks": 2388.0, "robotstxt": 2350.0, "wayback": 2393.0}, {"date": "2023-10-04", "sites": 1149, "cropped_screenshots": 2386, "full_screenshots": 2382.0, "lighthouse": 2330.0, "accessibility": 2264.0, "hyperlinks": 2385.0, "robotstxt": 2377.0, "wayback": 2396.0}, {"date": "2023-10-05", "sites": 1149, "cropped_screenshots": 2384, "full_screenshots": 2380.0, "lighthouse": 2328.0, "accessibility": 2263.0, "hyperlinks": 2386.0, "robotstxt": 2374.0, "wayback": 2395.0}, {"date": "2023-10-06", "sites": 1149, "cropped_screenshots": 2393, "full_screenshots": 2388.0, "lighthouse": 2337.0, "accessibility": 2244.0, "hyperlinks": 2392.0, "robotstxt": 2385.0, "wayback": 2292.0}, {"date": "2023-10-07", "sites": 1150, "cropped_screenshots": 2388, "full_screenshots": 2383.0, "lighthouse": 2332.0, "accessibility": 2250.0, "hyperlinks": 2387.0, "robotstxt": 2379.0, "wayback": 2396.0}, {"date": "2023-10-08", "sites": 1150, "cropped_screenshots": 2391, "full_screenshots": 2386.0, "lighthouse": 2323.0, "accessibility": 2256.0, "hyperlinks": 2389.0, "robotstxt": 2381.0, "wayback": 2399.0}, {"date": "2023-10-09", "sites": 1151, "cropped_screenshots": 2395, "full_screenshots": 2390.0, "lighthouse": 2328.0, "accessibility": 2276.0, "hyperlinks": 2394.0, "robotstxt": 2383.0, "wayback": 2403.0}, {"date": "2023-10-10", "sites": 1150, "cropped_screenshots": 2390, "full_screenshots": 2385.0, "lighthouse": 2341.0, "accessibility": 2403.0, "hyperlinks": 2395.0, "robotstxt": 2384.0, "wayback": 2259.0}, {"date": "2023-10-11", "sites": 1151, "cropped_screenshots": 2393, "full_screenshots": 2388.0, "lighthouse": 2339.0, "accessibility": 2402.0, "hyperlinks": 2393.0, "robotstxt": 2383.0, "wayback": 2381.0}, {"date": "2023-10-12", "sites": 1151, "cropped_screenshots": 2387, "full_screenshots": 2381.0, "lighthouse": 2337.0, "accessibility": 2396.0, "hyperlinks": 2391.0, "robotstxt": 2377.0, "wayback": 2393.0}, {"date": "2023-10-13", "sites": 1151, "cropped_screenshots": 2393, "full_screenshots": 2387.0, "lighthouse": 2340.0, "accessibility": 2401.0, "hyperlinks": 2397.0, "robotstxt": 2381.0, "wayback": 2398.0}, {"date": "2023-10-14", "sites": 1150, "cropped_screenshots": 2388, "full_screenshots": 2383.0, "lighthouse": 2332.0, "accessibility": 2398.0, "hyperlinks": 2392.0, "robotstxt": 2378.0, "wayback": 2396.0}, {"date": "2023-10-15", "sites": 1151, "cropped_screenshots": 2392, "full_screenshots": 2387.0, "lighthouse": 2335.0, "accessibility": 2401.0, "hyperlinks": 2397.0, "robotstxt": 2383.0, "wayback": 2392.0}, {"date": "2023-10-16", "sites": 1152, "cropped_screenshots": 2392, "full_screenshots": 2382.0, "lighthouse": 2318.0, "accessibility": 2389.0, "hyperlinks": 2379.0, "robotstxt": 2355.0, "wayback": 2365.0}, {"date": "2023-10-17", "sites": 1152, "cropped_screenshots": 2395, "full_screenshots": 2391.0, "lighthouse": 2337.0, "accessibility": 2403.0, "hyperlinks": 2401.0, "robotstxt": 2384.0, "wayback": 2404.0}, {"date": "2023-10-18", "sites": 1152, "cropped_screenshots": 2367, "full_screenshots": 2358.0, "lighthouse": 2298.0, "accessibility": 2369.0, "hyperlinks": 2365.0, "robotstxt": 2342.0, "wayback": 2365.0}, {"date": "2023-10-19", "sites": 1152, "cropped_screenshots": 2395, "full_screenshots": 2389.0, "lighthouse": 2312.0, "accessibility": 2399.0, "hyperlinks": 2396.0, "robotstxt": 2379.0, "wayback": 2397.0}, {"date": "2023-10-20", "sites": 1152, "cropped_screenshots": 2411, "full_screenshots": 2405.0, "lighthouse": 2333.0, "accessibility": 2418.0, "hyperlinks": 2414.0, "robotstxt": 2401.0, "wayback": 2419.0}, {"date": "2023-10-21", "sites": 1151, "cropped_screenshots": 2398, "full_screenshots": 2393.0, "lighthouse": 2323.0, "accessibility": 2403.0, "hyperlinks": 2400.0, "robotstxt": 2384.0, "wayback": 2402.0}, {"date": "2023-10-22", "sites": 1151, "cropped_screenshots": 2390, "full_screenshots": 2386.0, "lighthouse": 2315.0, "accessibility": 2401.0, "hyperlinks": 2398.0, "robotstxt": 2388.0, "wayback": 2363.0}, {"date": "2023-10-23", "sites": 1151, "cropped_screenshots": 2387, "full_screenshots": 2381.0, "lighthouse": 2310.0, "accessibility": 2394.0, "hyperlinks": 2385.0, "robotstxt": 2377.0, "wayback": 2393.0}, {"date": "2023-10-24", "sites": 1151, "cropped_screenshots": 2398, "full_screenshots": 2393.0, "lighthouse": 2307.0, "accessibility": 2402.0, "hyperlinks": 2400.0, "robotstxt": 2387.0, "wayback": 2403.0}, {"date": "2023-10-25", "sites": 1150, "cropped_screenshots": 2379, "full_screenshots": 2373.0, "lighthouse": 2300.0, "accessibility": 2388.0, "hyperlinks": 2380.0, "robotstxt": 2369.0, "wayback": 2387.0}, {"date": "2023-10-26", "sites": 1150, "cropped_screenshots": 2393, "full_screenshots": 2390.0, "lighthouse": 2326.0, "accessibility": 2402.0, "hyperlinks": 2392.0, "robotstxt": 2389.0, "wayback": 2400.0}, {"date": "2023-10-27", "sites": 1150, "cropped_screenshots": 2402, "full_screenshots": 2394.0, "lighthouse": 2321.0, "accessibility": 2407.0, "hyperlinks": 2398.0, "robotstxt": 2399.0, "wayback": 2407.0}, {"date": "2023-10-28", "sites": 1153, "cropped_screenshots": 2385, "full_screenshots": 2375.0, "lighthouse": 2298.0, "accessibility": 2385.0, "hyperlinks": 2381.0, "robotstxt": 2368.0, "wayback": 2383.0}, {"date": "2023-10-29", "sites": 1154, "cropped_screenshots": 2402, "full_screenshots": 2399.0, "lighthouse": 2317.0, "accessibility": 2405.0, "hyperlinks": 2402.0, "robotstxt": 2393.0, "wayback": 2404.0}, {"date": "2023-10-30", "sites": 1154, "cropped_screenshots": 2387, "full_screenshots": 2381.0, "lighthouse": 2314.0, "accessibility": 2386.0, "hyperlinks": 2379.0, "robotstxt": 2373.0, "wayback": 2361.0}, {"date": "2023-10-31", "sites": 1156, "cropped_screenshots": 2419, "full_screenshots": 2414.0, "lighthouse": 2342.0, "accessibility": 2418.0, "hyperlinks": 2412.0, "robotstxt": 2405.0, "wayback": 2419.0}, {"date": "2023-11-01", "sites": 1156, "cropped_screenshots": 2408, "full_screenshots": 2402.0, "lighthouse": 2309.0, "accessibility": 2404.0, "hyperlinks": 2402.0, "robotstxt": 2389.0, "wayback": 2404.0}, {"date": "2023-11-02", "sites": 1155, "cropped_screenshots": 2403, "full_screenshots": 2396.0, "lighthouse": 2306.0, "accessibility": 2401.0, "hyperlinks": 2392.0, "robotstxt": 2388.0, "wayback": 2382.0}, {"date": "2023-11-03", "sites": 1156, "cropped_screenshots": 2402, "full_screenshots": 2395.0, "lighthouse": 2314.0, "accessibility": 2399.0, "hyperlinks": 2393.0, "robotstxt": 2387.0, "wayback": 2399.0}, {"date": "2023-11-04", "sites": 1155, "cropped_screenshots": 2395, "full_screenshots": 2390.0, "lighthouse": 2339.0, "accessibility": 2401.0, "hyperlinks": 2393.0, "robotstxt": 2388.0, "wayback": 2400.0}, {"date": "2023-11-05", "sites": 1154, "cropped_screenshots": 2396, "full_screenshots": 2389.0, "lighthouse": 2328.0, "accessibility": 2402.0, "hyperlinks": 2392.0, "robotstxt": 2390.0, "wayback": 2403.0}, {"date": "2023-11-06", "sites": 1154, "cropped_screenshots": 2397, "full_screenshots": 2392.0, "lighthouse": 2337.0, "accessibility": 2401.0, "hyperlinks": 2395.0, "robotstxt": 2387.0, "wayback": 2400.0}, {"date": "2023-11-07", "sites": 1155, "cropped_screenshots": 2389, "full_screenshots": 2383.0, "lighthouse": 2319.0, "accessibility": 2392.0, "hyperlinks": 2386.0, "robotstxt": 2376.0, "wayback": 2389.0}, {"date": "2023-11-08", "sites": 1155, "cropped_screenshots": 2387, "full_screenshots": 2382.0, "lighthouse": 2322.0, "accessibility": 2393.0, "hyperlinks": 2362.0, "robotstxt": 2371.0, "wayback": 2374.0}, {"date": "2023-11-09", "sites": 1155, "cropped_screenshots": 2409, "full_screenshots": 2405.0, "lighthouse": 2346.0, "accessibility": 2413.0, "hyperlinks": 2355.0, "robotstxt": 2361.0, "wayback": 2402.0}, {"date": "2023-11-10", "sites": 1156, "cropped_screenshots": 2395, "full_screenshots": 2388.0, "lighthouse": 2333.0, "accessibility": 2397.0, "hyperlinks": 2334.0, "robotstxt": 2324.0, "wayback": 2398.0}, {"date": "2023-11-11", "sites": 1156, "cropped_screenshots": 2396, "full_screenshots": 2392.0, "lighthouse": 2333.0, "accessibility": 2398.0, "hyperlinks": 2333.0, "robotstxt": 2322.0, "wayback": 2395.0}, {"date": "2023-11-12", "sites": 1156, "cropped_screenshots": 2402, "full_screenshots": 2401.0, "lighthouse": 2343.0, "accessibility": 2409.0, "hyperlinks": 2349.0, "robotstxt": 2335.0, "wayback": 2404.0}, {"date": "2023-11-13", "sites": 1156, "cropped_screenshots": 2399, "full_screenshots": 2394.0, "lighthouse": 2338.0, "accessibility": 2401.0, "hyperlinks": 2344.0, "robotstxt": 2336.0, "wayback": 2393.0}, {"date": "2023-11-14", "sites": 1156, "cropped_screenshots": 2311, "full_screenshots": 2304.0, "lighthouse": 2254.0, "accessibility": 2313.0, "hyperlinks": 2284.0, "robotstxt": 2300.0, "wayback": 2304.0}, {"date": "2023-11-15", "sites": 1156, "cropped_screenshots": 2449, "full_screenshots": 2439.0, "lighthouse": 2369.0, "accessibility": 2435.0, "hyperlinks": 2411.0, "robotstxt": 2396.0, "wayback": 2412.0}, {"date": "2023-11-16", "sites": 1156, "cropped_screenshots": 2395, "full_screenshots": 2390.0, "lighthouse": 2348.0, "accessibility": 2398.0, "hyperlinks": 2378.0, "robotstxt": 2383.0, "wayback": 2394.0}, {"date": "2023-11-17", "sites": 1156, "cropped_screenshots": 2394, "full_screenshots": 2387.0, "lighthouse": 2342.0, "accessibility": 2394.0, "hyperlinks": 2374.0, "robotstxt": 2375.0, "wayback": 2380.0}, {"date": "2023-11-18", "sites": 1155, "cropped_screenshots": 2398, "full_screenshots": 2394.0, "lighthouse": 2350.0, "accessibility": 2403.0, "hyperlinks": 2373.0, "robotstxt": 2389.0, "wayback": 2392.0}, {"date": "2023-11-19", "sites": 1156, "cropped_screenshots": 2406, "full_screenshots": 2401.0, "lighthouse": 2359.0, "accessibility": 2407.0, "hyperlinks": 2369.0, "robotstxt": 2395.0, "wayback": 2403.0}, {"date": "2023-11-20", "sites": 1156, "cropped_screenshots": 2267, "full_screenshots": 2280.0, "lighthouse": 2238.0, "accessibility": 2286.0, "hyperlinks": 2256.0, "robotstxt": 2274.0, "wayback": 2280.0}, {"date": "2023-11-21", "sites": 1155, "cropped_screenshots": 2390, "full_screenshots": 2385.0, "lighthouse": 2344.0, "accessibility": 2394.0, "hyperlinks": 2371.0, "robotstxt": 2382.0, "wayback": 2392.0}, {"date": "2023-11-22", "sites": 1155, "cropped_screenshots": 2356, "full_screenshots": 2349.0, "lighthouse": 2308.0, "accessibility": 2357.0, "hyperlinks": 2317.0, "robotstxt": 2344.0, "wayback": 2339.0}, {"date": "2023-11-23", "sites": 1151, "cropped_screenshots": 2196, "full_screenshots": 2166.0, "lighthouse": 2064.0, "accessibility": 2153.0, "hyperlinks": 2108.0, "robotstxt": 2055.0, "wayback": 2093.0}, {"date": "2023-11-24", "sites": 1155, "cropped_screenshots": 2443, "full_screenshots": 2410.0, "lighthouse": 2315.0, "accessibility": 2400.0, "hyperlinks": 2350.0, "robotstxt": 2309.0, "wayback": 2350.0}, {"date": "2023-11-25", "sites": 1155, "cropped_screenshots": 2400, "full_screenshots": 2395.0, "lighthouse": 2354.0, "accessibility": 2405.0, "hyperlinks": 2383.0, "robotstxt": 2389.0, "wayback": 2395.0}, {"date": "2023-11-26", "sites": 1155, "cropped_screenshots": 2399, "full_screenshots": 2395.0, "lighthouse": 2353.0, "accessibility": 2403.0, "hyperlinks": 2380.0, "robotstxt": 2390.0, "wayback": 2398.0}, {"date": "2023-11-27", "sites": 1155, "cropped_screenshots": 2398, "full_screenshots": 2393.0, "lighthouse": 2348.0, "accessibility": 2401.0, "hyperlinks": 2374.0, "robotstxt": 2386.0, "wayback": 2390.0}, {"date": "2023-11-28", "sites": 1155, "cropped_screenshots": 2362, "full_screenshots": 2344.0, "lighthouse": 2280.0, "accessibility": 2351.0, "hyperlinks": 2312.0, "robotstxt": 2298.0, "wayback": 2319.0}, {"date": "2023-11-29", "sites": 1156, "cropped_screenshots": 2399, "full_screenshots": 2395.0, "lighthouse": 2351.0, "accessibility": 2404.0, "hyperlinks": 2380.0, "robotstxt": 2393.0, "wayback": 2379.0}, {"date": "2023-11-30", "sites": 1154, "cropped_screenshots": 2378, "full_screenshots": 2374.0, "lighthouse": 2343.0, "accessibility": 2397.0, "hyperlinks": 2365.0, "robotstxt": 2377.0, "wayback": 2387.0}, {"date": "2023-12-01", "sites": 1156, "cropped_screenshots": 2390, "full_screenshots": 2386.0, "lighthouse": 2349.0, "accessibility": 2399.0, "hyperlinks": 2370.0, "robotstxt": 2383.0, "wayback": 1499.0}, {"date": "2023-12-02", "sites": 1087, "cropped_screenshots": 1931, "full_screenshots": 1853.0, "lighthouse": 1657.0, "accessibility": 1798.0, "hyperlinks": 1729.0, "robotstxt": 1575.0, "wayback": 1343.0}, {"date": "2023-12-03", "sites": 1145, "cropped_screenshots": 1915, "full_screenshots": 1863.0, "lighthouse": 1746.0, "accessibility": 1840.0, "hyperlinks": 1785.0, "robotstxt": 1703.0, "wayback": 1763.0}, {"date": "2023-12-04", "sites": 955, "cropped_screenshots": 1291, "full_screenshots": 1089.0, "lighthouse": 671.0, "accessibility": 912.0, "hyperlinks": 779.0, "robotstxt": 504.0, "wayback": 611.0}, {"date": "2023-12-05", "sites": 537, "cropped_screenshots": 550, "full_screenshots": 468.0, "lighthouse": 356.0, "accessibility": 421.0, "hyperlinks": 382.0, "robotstxt": 323.0, "wayback": 353.0}, {"date": "2023-12-06", "sites": 1156, "cropped_screenshots": 2182, "full_screenshots": 2141.0, "lighthouse": 2085.0, "accessibility": 2136.0, "hyperlinks": 2107.0, "robotstxt": 2113.0, "wayback": 1407.0}, {"date": "2023-12-07", "sites": 1157, "cropped_screenshots": 1971, "full_screenshots": 1832.0, "lighthouse": 1608.0, "accessibility": 1754.0, "hyperlinks": 1667.0, "robotstxt": 1527.0, "wayback": 1597.0}, {"date": "2023-12-08", "sites": 1157, "cropped_screenshots": 2438, "full_screenshots": 2398.0, "lighthouse": 2351.0, "accessibility": 2405.0, "hyperlinks": 2370.0, "robotstxt": 2393.0, "wayback": 2399.0}, {"date": "2023-12-09", "sites": 1156, "cropped_screenshots": 2433, "full_screenshots": 2390.0, "lighthouse": 2342.0, "accessibility": 2400.0, "hyperlinks": 2368.0, "robotstxt": 2380.0, "wayback": 2396.0}, {"date": "2023-12-10", "sites": 1156, "cropped_screenshots": 2443, "full_screenshots": 2403.0, "lighthouse": 2350.0, "accessibility": 2407.0, "hyperlinks": 2378.0, "robotstxt": 2388.0, "wayback": 2400.0}, {"date": "2023-12-11", "sites": 1156, "cropped_screenshots": 2436, "full_screenshots": 2395.0, "lighthouse": 2349.0, "accessibility": 2403.0, "hyperlinks": 2369.0, "robotstxt": 2386.0, "wayback": 2397.0}, {"date": "2023-12-12", "sites": 1156, "cropped_screenshots": 2439, "full_screenshots": 2398.0, "lighthouse": 2350.0, "accessibility": 2405.0, "hyperlinks": 2380.0, "robotstxt": 2389.0, "wayback": 2339.0}, {"date": "2023-12-13", "sites": 1156, "cropped_screenshots": 2436, "full_screenshots": 2395.0, "lighthouse": 2349.0, "accessibility": 2401.0, "hyperlinks": 2371.0, "robotstxt": 2387.0, "wayback": 2400.0}, {"date": "2023-12-14", "sites": 1154, "cropped_screenshots": 2294, "full_screenshots": 2237.0, "lighthouse": 2153.0, "accessibility": 2225.0, "hyperlinks": 2183.0, "robotstxt": 2159.0, "wayback": 2190.0}, {"date": "2023-12-15", "sites": 1156, "cropped_screenshots": 2439, "full_screenshots": 2400.0, "lighthouse": 2348.0, "accessibility": 2406.0, "hyperlinks": 2376.0, "robotstxt": 2392.0, "wayback": 2404.0}, {"date": "2023-12-16", "sites": 1156, "cropped_screenshots": 2441, "full_screenshots": 2400.0, "lighthouse": 2356.0, "accessibility": 2406.0, "hyperlinks": 2380.0, "robotstxt": 2391.0, "wayback": 2401.0}, {"date": "2023-12-17", "sites": 1157, "cropped_screenshots": 2438, "full_screenshots": 2399.0, "lighthouse": 2354.0, "accessibility": 2405.0, "hyperlinks": 2363.0, "robotstxt": 2389.0, "wayback": 2396.0}, {"date": "2023-12-18", "sites": 1158, "cropped_screenshots": 2441, "full_screenshots": 2400.0, "lighthouse": 2350.0, "accessibility": 2404.0, "hyperlinks": 2366.0, "robotstxt": 2386.0, "wayback": 2390.0}, {"date": "2023-12-19", "sites": 1158, "cropped_screenshots": 2445, "full_screenshots": 2403.0, "lighthouse": 2350.0, "accessibility": 2405.0, "hyperlinks": 2370.0, "robotstxt": 2389.0, "wayback": 2402.0}, {"date": "2023-12-20", "sites": 1158, "cropped_screenshots": 2442, "full_screenshots": 2401.0, "lighthouse": 2353.0, "accessibility": 2407.0, "hyperlinks": 2404.0, "robotstxt": 2391.0, "wayback": 2402.0}, {"date": "2023-12-21", "sites": 1158, "cropped_screenshots": 2446, "full_screenshots": 2405.0, "lighthouse": 2356.0, "accessibility": 2410.0, "hyperlinks": 2406.0, "robotstxt": 2396.0, "wayback": 2380.0}, {"date": "2023-12-22", "sites": 1158, "cropped_screenshots": 2445, "full_screenshots": 2404.0, "lighthouse": 2356.0, "accessibility": 2408.0, "hyperlinks": 2404.0, "robotstxt": 2393.0, "wayback": 2402.0}, {"date": "2023-12-23", "sites": 1158, "cropped_screenshots": 2444, "full_screenshots": 2403.0, "lighthouse": 2355.0, "accessibility": 2408.0, "hyperlinks": 2402.0, "robotstxt": 2390.0, "wayback": 2405.0}, {"date": "2023-12-24", "sites": 1158, "cropped_screenshots": 2442, "full_screenshots": 2400.0, "lighthouse": 2353.0, "accessibility": 2406.0, "hyperlinks": 2403.0, "robotstxt": 2390.0, "wayback": 2399.0}, {"date": "2023-12-25", "sites": 1157, "cropped_screenshots": 2442, "full_screenshots": 2402.0, "lighthouse": 2353.0, "accessibility": 2409.0, "hyperlinks": 2407.0, "robotstxt": 2390.0, "wayback": 2404.0}, {"date": "2023-12-26", "sites": 1156, "cropped_screenshots": 2069, "full_screenshots": 2008.0, "lighthouse": 1933.0, "accessibility": 2002.0, "hyperlinks": 1988.0, "robotstxt": 1953.0, "wayback": 1959.0}, {"date": "2023-12-27", "sites": 1158, "cropped_screenshots": 2444, "full_screenshots": 2403.0, "lighthouse": 2356.0, "accessibility": 2408.0, "hyperlinks": 2405.0, "robotstxt": 2394.0, "wayback": 2397.0}, {"date": "2023-12-28", "sites": 1158, "cropped_screenshots": 2444, "full_screenshots": 2403.0, "lighthouse": 2353.0, "accessibility": 2407.0, "hyperlinks": 2403.0, "robotstxt": 2391.0, "wayback": 2373.0}, {"date": "2023-12-29", "sites": 1158, "cropped_screenshots": 2444, "full_screenshots": 2402.0, "lighthouse": 2352.0, "accessibility": 2407.0, "hyperlinks": 2404.0, "robotstxt": 2392.0, "wayback": 2398.0}, {"date": "2023-12-30", "sites": 1159, "cropped_screenshots": 2444, "full_screenshots": 2403.0, "lighthouse": 2353.0, "accessibility": 2409.0, "hyperlinks": 2406.0, "robotstxt": 2393.0, "wayback": 2401.0}, {"date": "2023-12-31", "sites": 1160, "cropped_screenshots": 1337, "full_screenshots": 1299.0, "lighthouse": 1273.0, "accessibility": 1301.0, "hyperlinks": 1300.0, "robotstxt": 1294.0, "wayback": 1297.0}, {"date": "2024-01-01", "sites": 1160, "cropped_screenshots": 1870, "full_screenshots": 1833.0, "lighthouse": 1794.0, "accessibility": 1836.0, "hyperlinks": 1835.0, "robotstxt": 1824.0, "wayback": 1831.0}, {"date": "2024-01-02", "sites": 1160, "cropped_screenshots": 2448, "full_screenshots": 2406.0, "lighthouse": 2356.0, "accessibility": 2411.0, "hyperlinks": 2408.0, "robotstxt": 2396.0, "wayback": 2402.0}, {"date": "2024-01-03", "sites": 1160, "cropped_screenshots": 2439, "full_screenshots": 2407.0, "lighthouse": 2354.0, "accessibility": 2412.0, "hyperlinks": 2410.0, "robotstxt": 2396.0, "wayback": 2408.0}, {"date": "2024-01-04", "sites": 1160, "cropped_screenshots": 2448, "full_screenshots": 2407.0, "lighthouse": 2356.0, "accessibility": 2411.0, "hyperlinks": 2409.0, "robotstxt": 2396.0, "wayback": 2404.0}, {"date": "2024-01-05", "sites": 1160, "cropped_screenshots": 2447, "full_screenshots": 2404.0, "lighthouse": 2354.0, "accessibility": 2411.0, "hyperlinks": 2409.0, "robotstxt": 2395.0, "wayback": 2409.0}, {"date": "2024-01-06", "sites": 1160, "cropped_screenshots": 2445, "full_screenshots": 2404.0, "lighthouse": 2353.0, "accessibility": 2411.0, "hyperlinks": 2405.0, "robotstxt": 2394.0, "wayback": 2403.0}, {"date": "2024-01-07", "sites": 1160, "cropped_screenshots": 2448, "full_screenshots": 2407.0, "lighthouse": 2353.0, "accessibility": 2411.0, "hyperlinks": 2409.0, "robotstxt": 2397.0, "wayback": 2407.0}, {"date": "2024-01-08", "sites": 1160, "cropped_screenshots": 2448, "full_screenshots": 2407.0, "lighthouse": 2354.0, "accessibility": 2411.0, "hyperlinks": 2409.0, "robotstxt": 2396.0, "wayback": 2407.0}, {"date": "2024-01-09", "sites": 1160, "cropped_screenshots": 2303, "full_screenshots": 2268.0, "lighthouse": 2221.0, "accessibility": 2273.0, "hyperlinks": 2274.0, "robotstxt": 2258.0, "wayback": 2270.0}, {"date": "2024-01-10", "sites": 1160, "cropped_screenshots": 2445, "full_screenshots": 2405.0, "lighthouse": 2357.0, "accessibility": 2411.0, "hyperlinks": 2408.0, "robotstxt": 2397.0, "wayback": 2406.0}, {"date": "2024-01-11", "sites": 1160, "cropped_screenshots": 2447, "full_screenshots": 2406.0, "lighthouse": 2355.0, "accessibility": 2411.0, "hyperlinks": 2409.0, "robotstxt": 2397.0, "wayback": 2402.0}, {"date": "2024-01-12", "sites": 1160, "cropped_screenshots": 2447, "full_screenshots": 2404.0, "lighthouse": 2355.0, "accessibility": 2411.0, "hyperlinks": 2408.0, "robotstxt": 2396.0, "wayback": 2406.0}, {"date": "2024-01-13", "sites": 1160, "cropped_screenshots": 2448, "full_screenshots": 2406.0, "lighthouse": 2355.0, "accessibility": 2412.0, "hyperlinks": 2410.0, "robotstxt": 2398.0, "wayback": 2407.0}, {"date": "2024-01-14", "sites": 1160, "cropped_screenshots": 2447, "full_screenshots": 2407.0, "lighthouse": 2359.0, "accessibility": 2412.0, "hyperlinks": 2407.0, "robotstxt": 2398.0, "wayback": 2395.0}, {"date": "2024-01-15", "sites": 1160, "cropped_screenshots": 2449, "full_screenshots": 2408.0, "lighthouse": 2360.0, "accessibility": 2413.0, "hyperlinks": 2411.0, "robotstxt": 2397.0, "wayback": 2409.0}, {"date": "2024-01-16", "sites": 1160, "cropped_screenshots": 2447, "full_screenshots": 2407.0, "lighthouse": 2351.0, "accessibility": 2412.0, "hyperlinks": 2410.0, "robotstxt": 2393.0, "wayback": 2404.0}, {"date": "2024-01-17", "sites": 1160, "cropped_screenshots": 2448, "full_screenshots": 2409.0, "lighthouse": 2349.0, "accessibility": 2413.0, "hyperlinks": 2411.0, "robotstxt": 2391.0, "wayback": 2405.0}, {"date": "2024-01-18", "sites": 1160, "cropped_screenshots": 2442, "full_screenshots": 2403.0, "lighthouse": 2339.0, "accessibility": 2407.0, "hyperlinks": 2405.0, "robotstxt": 2383.0, "wayback": 2401.0}, {"date": "2024-01-19", "sites": 1160, "cropped_screenshots": 2417, "full_screenshots": 2380.0, "lighthouse": 2319.0, "accessibility": 2385.0, "hyperlinks": 2382.0, "robotstxt": 2365.0, "wayback": 2376.0}, {"date": "2024-01-20", "sites": 1160, "cropped_screenshots": 2448, "full_screenshots": 2410.0, "lighthouse": 2351.0, "accessibility": 2414.0, "hyperlinks": 2412.0, "robotstxt": 2394.0, "wayback": 2404.0}, {"date": "2024-01-21", "sites": 1160, "cropped_screenshots": 2449, "full_screenshots": 2409.0, "lighthouse": 2348.0, "accessibility": 2414.0, "hyperlinks": 2412.0, "robotstxt": 2393.0, "wayback": 2411.0}, {"date": "2024-01-22", "sites": 1160, "cropped_screenshots": 2447, "full_screenshots": 2407.0, "lighthouse": 2348.0, "accessibility": 2411.0, "hyperlinks": 2409.0, "robotstxt": 2391.0, "wayback": 2407.0}, {"date": "2024-01-23", "sites": 1160, "cropped_screenshots": 2448, "full_screenshots": 2408.0, "lighthouse": 2350.0, "accessibility": 2413.0, "hyperlinks": 2410.0, "robotstxt": 2394.0, "wayback": 2410.0}, {"date": "2024-01-24", "sites": 1160, "cropped_screenshots": 2448, "full_screenshots": 2409.0, "lighthouse": 2348.0, "accessibility": 2413.0, "hyperlinks": 2411.0, "robotstxt": 2394.0, "wayback": 2405.0}, {"date": "2024-01-25", "sites": 1160, "cropped_screenshots": 2447, "full_screenshots": 2407.0, "lighthouse": 2347.0, "accessibility": 2412.0, "hyperlinks": 2410.0, "robotstxt": 2395.0, "wayback": 2401.0}, {"date": "2024-01-26", "sites": 1160, "cropped_screenshots": 2448, "full_screenshots": 2407.0, "lighthouse": 2346.0, "accessibility": 2412.0, "hyperlinks": 2410.0, "robotstxt": 2394.0, "wayback": 2406.0}, {"date": "2024-01-27", "sites": 1160, "cropped_screenshots": 2447, "full_screenshots": 2408.0, "lighthouse": 2348.0, "accessibility": 2413.0, "hyperlinks": 2411.0, "robotstxt": 2396.0, "wayback": 2403.0}, {"date": "2024-01-28", "sites": 1160, "cropped_screenshots": 2448, "full_screenshots": 2406.0, "lighthouse": 2347.0, "accessibility": 2413.0, "hyperlinks": 2410.0, "robotstxt": 2394.0, "wayback": 2385.0}, {"date": "2024-01-29", "sites": 1160, "cropped_screenshots": 2447, "full_screenshots": 2406.0, "lighthouse": 2347.0, "accessibility": 2412.0, "hyperlinks": 2410.0, "robotstxt": 2393.0, "wayback": 2403.0}, {"date": "2024-01-30", "sites": 1160, "cropped_screenshots": 2448, "full_screenshots": 2406.0, "lighthouse": 2342.0, "accessibility": 2413.0, "hyperlinks": 2411.0, "robotstxt": 2394.0, "wayback": 2403.0}, {"date": "2024-01-31", "sites": 1160, "cropped_screenshots": 2448, "full_screenshots": 2408.0, "lighthouse": 2343.0, "accessibility": 2414.0, "hyperlinks": 2411.0, "robotstxt": 2395.0, "wayback": 2408.0}, {"date": "2024-02-01", "sites": 1160, "cropped_screenshots": 2447, "full_screenshots": 2407.0, "lighthouse": 2341.0, "accessibility": 2412.0, "hyperlinks": 2410.0, "robotstxt": 2391.0, "wayback": 2403.0}, {"date": "2024-02-02", "sites": 1160, "cropped_screenshots": 2448, "full_screenshots": 2409.0, "lighthouse": 2342.0, "accessibility": 2413.0, "hyperlinks": 2410.0, "robotstxt": 2393.0, "wayback": 2394.0}, {"date": "2024-02-03", "sites": 1160, "cropped_screenshots": 2449, "full_screenshots": 2409.0, "lighthouse": 2342.0, "accessibility": 2413.0, "hyperlinks": 2411.0, "robotstxt": 2393.0, "wayback": 2407.0}, {"date": "2024-02-04", "sites": 1160, "cropped_screenshots": 2445, "full_screenshots": 2405.0, "lighthouse": 2343.0, "accessibility": 2413.0, "hyperlinks": 2411.0, "robotstxt": 2395.0, "wayback": 2401.0}, {"date": "2024-02-05", "sites": 1160, "cropped_screenshots": 2429, "full_screenshots": 2389.0, "lighthouse": 2297.0, "accessibility": 2395.0, "hyperlinks": 2367.0, "robotstxt": 2375.0, "wayback": 2386.0}, {"date": "2024-02-06", "sites": 1159, "cropped_screenshots": 2458, "full_screenshots": 2422.0, "lighthouse": 2220.0, "accessibility": 2429.0, "hyperlinks": 2286.0, "robotstxt": 2413.0, "wayback": 2423.0}, {"date": "2024-02-07", "sites": 1159, "cropped_screenshots": 2445, "full_screenshots": 2405.0, "lighthouse": 2342.0, "accessibility": 2412.0, "hyperlinks": 2410.0, "robotstxt": 2391.0, "wayback": 2405.0}, {"date": "2024-02-08", "sites": 1160, "cropped_screenshots": 2447, "full_screenshots": 2407.0, "lighthouse": 2344.0, "accessibility": 2412.0, "hyperlinks": 2410.0, "robotstxt": 2393.0, "wayback": 2405.0}, {"date": "2024-02-09", "sites": 1160, "cropped_screenshots": 2446, "full_screenshots": 2406.0, "lighthouse": 2342.0, "accessibility": 2412.0, "hyperlinks": 2408.0, "robotstxt": 2391.0, "wayback": 2394.0}, {"date": "2024-02-10", "sites": 1160, "cropped_screenshots": 2447, "full_screenshots": 2408.0, "lighthouse": 2346.0, "accessibility": 2413.0, "hyperlinks": 2411.0, "robotstxt": 2392.0, "wayback": 2404.0}, {"date": "2024-02-11", "sites": 1160, "cropped_screenshots": 2448, "full_screenshots": 2408.0, "lighthouse": 2347.0, "accessibility": 2413.0, "hyperlinks": 2411.0, "robotstxt": 2390.0, "wayback": 2394.0}, {"date": "2024-02-12", "sites": 1160, "cropped_screenshots": 2447, "full_screenshots": 2407.0, "lighthouse": 2343.0, "accessibility": 2412.0, "hyperlinks": 2410.0, "robotstxt": 2391.0, "wayback": 2379.0}, {"date": "2024-02-13", "sites": 1160, "cropped_screenshots": 2449, "full_screenshots": 2409.0, "lighthouse": 2346.0, "accessibility": 2413.0, "hyperlinks": 2411.0, "robotstxt": 2392.0, "wayback": 2399.0}, {"date": "2024-02-14", "sites": 1160, "cropped_screenshots": 2446, "full_screenshots": 2407.0, "lighthouse": 2346.0, "accessibility": 2413.0, "hyperlinks": 2410.0, "robotstxt": 2389.0, "wayback": 2396.0}, {"date": "2024-02-15", "sites": 1159, "cropped_screenshots": 2445, "full_screenshots": 2408.0, "lighthouse": 2345.0, "accessibility": 2410.0, "hyperlinks": 2408.0, "robotstxt": 2390.0, "wayback": 2376.0}, {"date": "2024-02-16", "sites": 1160, "cropped_screenshots": 2444, "full_screenshots": 2406.0, "lighthouse": 2333.0, "accessibility": 2410.0, "hyperlinks": 2408.0, "robotstxt": 2388.0, "wayback": 2408.0}, {"date": "2024-02-17", "sites": 1160, "cropped_screenshots": 2448, "full_screenshots": 2408.0, "lighthouse": 2349.0, "accessibility": 2413.0, "hyperlinks": 2411.0, "robotstxt": 2389.0, "wayback": 2407.0}, {"date": "2024-02-18", "sites": 1160, "cropped_screenshots": 2447, "full_screenshots": 2407.0, "lighthouse": 2348.0, "accessibility": 2412.0, "hyperlinks": 2409.0, "robotstxt": 2389.0, "wayback": 2405.0}, {"date": "2024-02-19", "sites": 1160, "cropped_screenshots": 2448, "full_screenshots": 2408.0, "lighthouse": 2348.0, "accessibility": 2413.0, "hyperlinks": 2411.0, "robotstxt": 2390.0, "wayback": 2406.0}, {"date": "2024-02-20", "sites": 1160, "cropped_screenshots": 2445, "full_screenshots": 2406.0, "lighthouse": 2344.0, "accessibility": 2412.0, "hyperlinks": 2409.0, "robotstxt": 2389.0, "wayback": 2409.0}, {"date": "2024-02-21", "sites": 1160, "cropped_screenshots": 2446, "full_screenshots": 2407.0, "lighthouse": 2349.0, "accessibility": 2412.0, "hyperlinks": 2409.0, "robotstxt": 2389.0, "wayback": 2407.0}, {"date": "2024-02-22", "sites": 1160, "cropped_screenshots": 2448, "full_screenshots": 2408.0, "lighthouse": 2344.0, "accessibility": 2411.0, "hyperlinks": 2408.0, "robotstxt": 2387.0, "wayback": 2409.0}, {"date": "2024-02-23", "sites": 1160, "cropped_screenshots": 2446, "full_screenshots": 2404.0, "lighthouse": 2344.0, "accessibility": 2411.0, "hyperlinks": 2406.0, "robotstxt": 2388.0, "wayback": 2397.0}, {"date": "2024-02-24", "sites": 1160, "cropped_screenshots": 2447, "full_screenshots": 2405.0, "lighthouse": 2348.0, "accessibility": 2412.0, "hyperlinks": 2410.0, "robotstxt": 2388.0, "wayback": 2399.0}, {"date": "2024-02-25", "sites": 1160, "cropped_screenshots": 2445, "full_screenshots": 2403.0, "lighthouse": 2347.0, "accessibility": 2411.0, "hyperlinks": 2407.0, "robotstxt": 2388.0, "wayback": 2408.0}, {"date": "2024-02-26", "sites": 1160, "cropped_screenshots": 2449, "full_screenshots": 2406.0, "lighthouse": 2350.0, "accessibility": 2412.0, "hyperlinks": 2408.0, "robotstxt": 2391.0, "wayback": 2408.0}, {"date": "2024-02-27", "sites": 1159, "cropped_screenshots": 2443, "full_screenshots": 2404.0, "lighthouse": 2339.0, "accessibility": 2412.0, "hyperlinks": 2391.0, "robotstxt": 2350.0, "wayback": 2412.0}, {"date": "2024-02-28", "sites": 1159, "cropped_screenshots": 2433, "full_screenshots": 2392.0, "lighthouse": 2343.0, "accessibility": 2410.0, "hyperlinks": 2384.0, "robotstxt": 2335.0, "wayback": 2408.0}, {"date": "2024-02-29", "sites": 1152, "cropped_screenshots": 2423, "full_screenshots": 2381.0, "lighthouse": 2349.0, "accessibility": 2412.0, "hyperlinks": 2396.0, "robotstxt": 2353.0, "wayback": 2406.0}, {"date": "2024-03-01", "sites": 1151, "cropped_screenshots": 2419, "full_screenshots": 2379.0, "lighthouse": 2339.0, "accessibility": 2410.0, "hyperlinks": 2397.0, "robotstxt": 2348.0, "wayback": 2408.0}, {"date": "2024-03-02", "sites": 1155, "cropped_screenshots": 2426, "full_screenshots": 2383.0, "lighthouse": 2344.0, "accessibility": 2407.0, "hyperlinks": 2396.0, "robotstxt": 2355.0, "wayback": 2404.0}, {"date": "2024-03-03", "sites": 1149, "cropped_screenshots": 2415, "full_screenshots": 2377.0, "lighthouse": 2344.0, "accessibility": 2405.0, "hyperlinks": 2391.0, "robotstxt": 2351.0, "wayback": 2388.0}, {"date": "2024-03-04", "sites": 1152, "cropped_screenshots": 2419, "full_screenshots": 2381.0, "lighthouse": 2345.0, "accessibility": 2410.0, "hyperlinks": 2403.0, "robotstxt": 2359.0, "wayback": 2403.0}, {"date": "2024-03-05", "sites": 1150, "cropped_screenshots": 2415, "full_screenshots": 2377.0, "lighthouse": 2347.0, "accessibility": 2407.0, "hyperlinks": 2399.0, "robotstxt": 2375.0, "wayback": 2403.0}, {"date": "2024-03-06", "sites": 1155, "cropped_screenshots": 2415, "full_screenshots": 2381.0, "lighthouse": 2345.0, "accessibility": 2407.0, "hyperlinks": 2402.0, "robotstxt": 2364.0, "wayback": 2406.0}, {"date": "2024-03-07", "sites": 1150, "cropped_screenshots": 2410, "full_screenshots": 2371.0, "lighthouse": 2339.0, "accessibility": 2402.0, "hyperlinks": 2401.0, "robotstxt": 2376.0, "wayback": 2395.0}, {"date": "2024-03-08", "sites": 1154, "cropped_screenshots": 2422, "full_screenshots": 2383.0, "lighthouse": 2346.0, "accessibility": 2410.0, "hyperlinks": 2408.0, "robotstxt": 2383.0, "wayback": 2398.0}, {"date": "2024-03-09", "sites": 1155, "cropped_screenshots": 2420, "full_screenshots": 2386.0, "lighthouse": 2346.0, "accessibility": 2412.0, "hyperlinks": 2409.0, "robotstxt": 2386.0, "wayback": 2399.0}, {"date": "2024-03-10", "sites": 1154, "cropped_screenshots": 2417, "full_screenshots": 2381.0, "lighthouse": 2339.0, "accessibility": 2410.0, "hyperlinks": 2407.0, "robotstxt": 2382.0, "wayback": 2396.0}, {"date": "2024-03-11", "sites": 1155, "cropped_screenshots": 2424, "full_screenshots": 2383.0, "lighthouse": 2347.0, "accessibility": 2414.0, "hyperlinks": 2412.0, "robotstxt": 2388.0, "wayback": 2387.0}, {"date": "2024-03-12", "sites": 1159, "cropped_screenshots": 2432, "full_screenshots": 2395.0, "lighthouse": 2356.0, "accessibility": 2417.0, "hyperlinks": 2415.0, "robotstxt": 2392.0, "wayback": 2406.0}, {"date": "2024-03-13", "sites": 1159, "cropped_screenshots": 2430, "full_screenshots": 2392.0, "lighthouse": 2356.0, "accessibility": 2417.0, "hyperlinks": 2415.0, "robotstxt": 2390.0, "wayback": 2405.0}, {"date": "2024-03-14", "sites": 1152, "cropped_screenshots": 2419, "full_screenshots": 2387.0, "lighthouse": 2348.0, "accessibility": 2416.0, "hyperlinks": 2413.0, "robotstxt": 2387.0, "wayback": 2404.0}, {"date": "2024-03-15", "sites": 1155, "cropped_screenshots": 2425, "full_screenshots": 2387.0, "lighthouse": 2348.0, "accessibility": 2418.0, "hyperlinks": 2414.0, "robotstxt": 2389.0, "wayback": 2406.0}, {"date": "2024-03-16", "sites": 1156, "cropped_screenshots": 2430, "full_screenshots": 2393.0, "lighthouse": 2352.0, "accessibility": 2419.0, "hyperlinks": 2415.0, "robotstxt": 2391.0, "wayback": 2402.0}, {"date": "2024-03-17", "sites": 1151, "cropped_screenshots": 2421, "full_screenshots": 2389.0, "lighthouse": 2352.0, "accessibility": 2417.0, "hyperlinks": 2415.0, "robotstxt": 2386.0, "wayback": 2401.0}, {"date": "2024-03-18", "sites": 1152, "cropped_screenshots": 2424, "full_screenshots": 2388.0, "lighthouse": 2353.0, "accessibility": 2417.0, "hyperlinks": 2414.0, "robotstxt": 2385.0, "wayback": 2411.0}, {"date": "2024-03-19", "sites": 1153, "cropped_screenshots": 2419, "full_screenshots": 2385.0, "lighthouse": 2347.0, "accessibility": 2416.0, "hyperlinks": 2413.0, "robotstxt": 2381.0, "wayback": 2402.0}, {"date": "2024-03-20", "sites": 1155, "cropped_screenshots": 2424, "full_screenshots": 2386.0, "lighthouse": 2354.0, "accessibility": 2420.0, "hyperlinks": 2417.0, "robotstxt": 2388.0, "wayback": 2405.0}, {"date": "2024-03-21", "sites": 1154, "cropped_screenshots": 2363, "full_screenshots": 2318.0, "lighthouse": 2287.0, "accessibility": 2352.0, "hyperlinks": 2349.0, "robotstxt": 2317.0, "wayback": 2327.0}, {"date": "2024-03-22", "sites": 1152, "cropped_screenshots": 2479, "full_screenshots": 2446.0, "lighthouse": 2415.0, "accessibility": 2481.0, "hyperlinks": 2476.0, "robotstxt": 2456.0, "wayback": 2471.0}, {"date": "2024-03-23", "sites": 1151, "cropped_screenshots": 2418, "full_screenshots": 2382.0, "lighthouse": 2360.0, "accessibility": 2418.0, "hyperlinks": 2415.0, "robotstxt": 2390.0, "wayback": 2416.0}, {"date": "2024-03-24", "sites": 1149, "cropped_screenshots": 2418, "full_screenshots": 2382.0, "lighthouse": 2361.0, "accessibility": 2419.0, "hyperlinks": 2417.0, "robotstxt": 2392.0, "wayback": 2408.0}, {"date": "2024-03-25", "sites": 1151, "cropped_screenshots": 2422, "full_screenshots": 2386.0, "lighthouse": 2352.0, "accessibility": 2420.0, "hyperlinks": 2416.0, "robotstxt": 2389.0, "wayback": 2418.0}, {"date": "2024-03-26", "sites": 1149, "cropped_screenshots": 2414, "full_screenshots": 2374.0, "lighthouse": 2356.0, "accessibility": 2419.0, "hyperlinks": 2414.0, "robotstxt": 2389.0, "wayback": 2415.0}, {"date": "2024-03-27", "sites": 1155, "cropped_screenshots": 2424, "full_screenshots": 2385.0, "lighthouse": 2354.0, "accessibility": 2418.0, "hyperlinks": 2414.0, "robotstxt": 2388.0, "wayback": 2409.0}, {"date": "2024-03-28", "sites": 1147, "cropped_screenshots": 2410, "full_screenshots": 2376.0, "lighthouse": 2347.0, "accessibility": 2415.0, "hyperlinks": 2411.0, "robotstxt": 2385.0, "wayback": 2411.0}, {"date": "2024-03-29", "sites": 1152, "cropped_screenshots": 2417, "full_screenshots": 2385.0, "lighthouse": 2352.0, "accessibility": 2419.0, "hyperlinks": 2414.0, "robotstxt": 2386.0, "wayback": 2391.0}, {"date": "2024-03-30", "sites": 1146, "cropped_screenshots": 2407, "full_screenshots": 2379.0, "lighthouse": 2350.0, "accessibility": 2418.0, "hyperlinks": 2412.0, "robotstxt": 2382.0, "wayback": 2417.0}, {"date": "2024-03-31", "sites": 1156, "cropped_screenshots": 2427, "full_screenshots": 2389.0, "lighthouse": 2353.0, "accessibility": 2419.0, "hyperlinks": 2413.0, "robotstxt": 2382.0, "wayback": 2418.0}, {"date": "2024-04-01", "sites": 1152, "cropped_screenshots": 2422, "full_screenshots": 2386.0, "lighthouse": 2354.0, "accessibility": 2420.0, "hyperlinks": 2414.0, "robotstxt": 2387.0, "wayback": 2419.0}, {"date": "2024-04-02", "sites": 1153, "cropped_screenshots": 2426, "full_screenshots": 2385.0, "lighthouse": 2360.0, "accessibility": 2419.0, "hyperlinks": 2417.0, "robotstxt": 2391.0, "wayback": 2415.0}, {"date": "2024-04-03", "sites": 1152, "cropped_screenshots": 2394, "full_screenshots": 2361.0, "lighthouse": 2332.0, "accessibility": 2391.0, "hyperlinks": 2389.0, "robotstxt": 2362.0, "wayback": 2374.0}, {"date": "2024-04-04", "sites": 1156, "cropped_screenshots": 2429, "full_screenshots": 2392.0, "lighthouse": 2360.0, "accessibility": 2424.0, "hyperlinks": 2421.0, "robotstxt": 2394.0, "wayback": 2406.0}, {"date": "2024-04-05", "sites": 1149, "cropped_screenshots": 2413, "full_screenshots": 2377.0, "lighthouse": 2348.0, "accessibility": 2414.0, "hyperlinks": 2411.0, "robotstxt": 2382.0, "wayback": 2397.0}, {"date": "2024-04-06", "sites": 1148, "cropped_screenshots": 2418, "full_screenshots": 2382.0, "lighthouse": 2356.0, "accessibility": 2418.0, "hyperlinks": 2415.0, "robotstxt": 2390.0, "wayback": 2399.0}, {"date": "2024-04-07", "sites": 1151, "cropped_screenshots": 2419, "full_screenshots": 2384.0, "lighthouse": 2356.0, "accessibility": 2419.0, "hyperlinks": 2416.0, "robotstxt": 2390.0, "wayback": 2407.0}, {"date": "2024-04-08", "sites": 1148, "cropped_screenshots": 2413, "full_screenshots": 2373.0, "lighthouse": 2349.0, "accessibility": 2415.0, "hyperlinks": 2413.0, "robotstxt": 2383.0, "wayback": 2400.0}, {"date": "2024-04-09", "sites": 1151, "cropped_screenshots": 2418, "full_screenshots": 2388.0, "lighthouse": 2354.0, "accessibility": 2419.0, "hyperlinks": 2417.0, "robotstxt": 2389.0, "wayback": 2371.0}, {"date": "2024-04-10", "sites": 1152, "cropped_screenshots": 2424, "full_screenshots": 2386.0, "lighthouse": 2357.0, "accessibility": 2421.0, "hyperlinks": 2419.0, "robotstxt": 2390.0, "wayback": 1993.0}, {"date": "2024-04-11", "sites": 1153, "cropped_screenshots": 2422, "full_screenshots": 2382.0, "lighthouse": 2354.0, "accessibility": 2419.0, "hyperlinks": 2416.0, "robotstxt": 2388.0, "wayback": 2404.0}, {"date": "2024-04-12", "sites": 1151, "cropped_screenshots": 2417, "full_screenshots": 2383.0, "lighthouse": 2351.0, "accessibility": 2420.0, "hyperlinks": 2415.0, "robotstxt": 2388.0, "wayback": 2372.0}, {"date": "2024-04-13", "sites": 1155, "cropped_screenshots": 2424, "full_screenshots": 2392.0, "lighthouse": 2351.0, "accessibility": 2422.0, "hyperlinks": 2416.0, "robotstxt": 2385.0, "wayback": 2385.0}, {"date": "2024-04-14", "sites": 1147, "cropped_screenshots": 2170, "full_screenshots": 2132.0, "lighthouse": 2109.0, "accessibility": 2168.0, "hyperlinks": 2164.0, "robotstxt": 2135.0, "wayback": 2135.0}, {"date": "2024-04-15", "sites": 1146, "cropped_screenshots": 2661, "full_screenshots": 2626.0, "lighthouse": 2600.0, "accessibility": 2674.0, "hyperlinks": 2670.0, "robotstxt": 2638.0, "wayback": 2578.0}, {"date": "2024-04-16", "sites": 1151, "cropped_screenshots": 2416, "full_screenshots": 2388.0, "lighthouse": 2354.0, "accessibility": 2421.0, "hyperlinks": 2417.0, "robotstxt": 2381.0, "wayback": 2310.0}, {"date": "2024-04-17", "sites": 1152, "cropped_screenshots": 2420, "full_screenshots": 2387.0, "lighthouse": 2351.0, "accessibility": 2421.0, "hyperlinks": 2416.0, "robotstxt": 2380.0, "wayback": 2413.0}, {"date": "2024-04-18", "sites": 1149, "cropped_screenshots": 2415, "full_screenshots": 2377.0, "lighthouse": 2351.0, "accessibility": 2421.0, "hyperlinks": 2415.0, "robotstxt": 2378.0, "wayback": 2391.0}, {"date": "2024-04-19", "sites": 1145, "cropped_screenshots": 2408, "full_screenshots": 2373.0, "lighthouse": 2350.0, "accessibility": 2420.0, "hyperlinks": 2413.0, "robotstxt": 2369.0, "wayback": 2418.0}, {"date": "2024-04-20", "sites": 1146, "cropped_screenshots": 2411, "full_screenshots": 2375.0, "lighthouse": 2346.0, "accessibility": 2421.0, "hyperlinks": 2414.0, "robotstxt": 2362.0, "wayback": 2413.0}, {"date": "2024-04-21", "sites": 1146, "cropped_screenshots": 2409, "full_screenshots": 2375.0, "lighthouse": 2345.0, "accessibility": 2421.0, "hyperlinks": 2413.0, "robotstxt": 2370.0, "wayback": 2418.0}, {"date": "2024-04-22", "sites": 1145, "cropped_screenshots": 2408, "full_screenshots": 2375.0, "lighthouse": 2346.0, "accessibility": 2421.0, "hyperlinks": 2414.0, "robotstxt": 2370.0, "wayback": 2414.0}, {"date": "2024-04-23", "sites": 1147, "cropped_screenshots": 2408, "full_screenshots": 2365.0, "lighthouse": 2345.0, "accessibility": 2418.0, "hyperlinks": 2411.0, "robotstxt": 2352.0, "wayback": 2405.0}, {"date": "2024-04-24", "sites": 1122, "cropped_screenshots": 1654, "full_screenshots": 1609.0, "lighthouse": 1654.0, "accessibility": 1704.0, "hyperlinks": 1697.0, "robotstxt": 1658.0, "wayback": 1673.0}, {"date": "2024-04-25", "sites": 1116, "cropped_screenshots": 2334, "full_screenshots": 2257.0, "lighthouse": 2351.0, "accessibility": 2421.0, "hyperlinks": 2412.0, "robotstxt": 2361.0, "wayback": 2420.0}, {"date": "2024-04-26", "sites": 1116, "cropped_screenshots": 2331, "full_screenshots": 2255.0, "lighthouse": 2345.0, "accessibility": 2420.0, "hyperlinks": 2416.0, "robotstxt": 2364.0, "wayback": 2418.0}, {"date": "2024-04-27", "sites": 1118, "cropped_screenshots": 2338, "full_screenshots": 2254.0, "lighthouse": 2349.0, "accessibility": 2422.0, "hyperlinks": 2416.0, "robotstxt": 2362.0, "wayback": 2419.0}, {"date": "2024-04-28", "sites": 1116, "cropped_screenshots": 2336, "full_screenshots": 2258.0, "lighthouse": 2351.0, "accessibility": 2421.0, "hyperlinks": 2417.0, "robotstxt": 2356.0, "wayback": 2414.0}, {"date": "2024-04-29", "sites": 1119, "cropped_screenshots": 2340, "full_screenshots": 2260.0, "lighthouse": 2350.0, "accessibility": 2420.0, "hyperlinks": 2417.0, "robotstxt": 2363.0, "wayback": 2418.0}, {"date": "2024-04-30", "sites": 1116, "cropped_screenshots": 2241, "full_screenshots": 2156.0, "lighthouse": 2231.0, "accessibility": 2298.0, "hyperlinks": 2293.0, "robotstxt": 2231.0, "wayback": 2267.0}, {"date": "2024-05-01", "sites": 1113, "cropped_screenshots": 2334, "full_screenshots": 2257.0, "lighthouse": 2351.0, "accessibility": 2421.0, "hyperlinks": 2418.0, "robotstxt": 2360.0, "wayback": 2418.0}, {"date": "2024-05-02", "sites": 1120, "cropped_screenshots": 2345, "full_screenshots": 2263.0, "lighthouse": 2358.0, "accessibility": 2422.0, "hyperlinks": 2419.0, "robotstxt": 2363.0, "wayback": 2419.0}, {"date": "2024-05-03", "sites": 1122, "cropped_screenshots": 2342, "full_screenshots": 2258.0, "lighthouse": 2354.0, "accessibility": 2421.0, "hyperlinks": 2418.0, "robotstxt": 2357.0, "wayback": 2415.0}, {"date": "2024-05-04", "sites": 1068, "cropped_screenshots": 1938, "full_screenshots": 1870.0, "lighthouse": 1938.0, "accessibility": 2004.0, "hyperlinks": 1997.0, "robotstxt": 1942.0, "wayback": 1664.0}, {"date": "2024-05-05", "sites": 1114, "cropped_screenshots": 2331, "full_screenshots": 2255.0, "lighthouse": 2349.0, "accessibility": 2421.0, "hyperlinks": 2417.0, "robotstxt": 2361.0, "wayback": 2415.0}, {"date": "2024-05-06", "sites": 1113, "cropped_screenshots": 2335, "full_screenshots": 2257.0, "lighthouse": 2350.0, "accessibility": 2421.0, "hyperlinks": 2416.0, "robotstxt": 2366.0, "wayback": 2418.0}, {"date": "2024-05-07", "sites": 1108, "cropped_screenshots": 2328, "full_screenshots": 2245.0, "lighthouse": 2349.0, "accessibility": 2418.0, "hyperlinks": 2412.0, "robotstxt": 2369.0, "wayback": 2416.0}, {"date": "2024-05-08", "sites": 1113, "cropped_screenshots": 2330, "full_screenshots": 2257.0, "lighthouse": 2350.0, "accessibility": 2420.0, "hyperlinks": 2416.0, "robotstxt": 2367.0, "wayback": 2412.0}, {"date": "2024-05-09", "sites": 1121, "cropped_screenshots": 2343, "full_screenshots": 2264.0, "lighthouse": 2349.0, "accessibility": 2422.0, "hyperlinks": 2417.0, "robotstxt": 2364.0, "wayback": 2403.0}, {"date": "2024-05-10", "sites": 1118, "cropped_screenshots": 2339, "full_screenshots": 2258.0, "lighthouse": 2345.0, "accessibility": 2421.0, "hyperlinks": 2416.0, "robotstxt": 2365.0, "wayback": 2413.0}, {"date": "2024-05-11", "sites": 1116, "cropped_screenshots": 2329, "full_screenshots": 2251.0, "lighthouse": 2345.0, "accessibility": 2418.0, "hyperlinks": 2413.0, "robotstxt": 2359.0, "wayback": 2417.0}, {"date": "2024-05-12", "sites": 1115, "cropped_screenshots": 2333, "full_screenshots": 2252.0, "lighthouse": 2347.0, "accessibility": 2420.0, "hyperlinks": 2416.0, "robotstxt": 2353.0, "wayback": 2420.0}, {"date": "2024-05-13", "sites": 1118, "cropped_screenshots": 2340, "full_screenshots": 2259.0, "lighthouse": 2333.0, "accessibility": 2422.0, "hyperlinks": 2417.0, "robotstxt": 2358.0, "wayback": 2416.0}, {"date": "2024-05-14", "sites": 1118, "cropped_screenshots": 2340, "full_screenshots": 2255.0, "lighthouse": 2317.0, "accessibility": 2422.0, "hyperlinks": 2417.0, "robotstxt": 2355.0, "wayback": 2422.0}, {"date": "2024-05-15", "sites": 1118, "cropped_screenshots": 2346, "full_screenshots": 2266.0, "lighthouse": 2353.0, "accessibility": 2423.0, "hyperlinks": 2419.0, "robotstxt": 2361.0, "wayback": 2421.0}, {"date": "2024-05-16", "sites": 1120, "cropped_screenshots": 2345, "full_screenshots": 2266.0, "lighthouse": 2371.0, "accessibility": 2423.0, "hyperlinks": 2418.0, "robotstxt": 2368.0, "wayback": 2422.0}, {"date": "2024-05-17", "sites": 1120, "cropped_screenshots": 2345, "full_screenshots": 2265.0, "lighthouse": 2358.0, "accessibility": 2423.0, "hyperlinks": 2418.0, "robotstxt": 2362.0, "wayback": 2422.0}, {"date": "2024-05-18", "sites": 1122, "cropped_screenshots": 2342, "full_screenshots": 2261.0, "lighthouse": 2361.0, "accessibility": 2424.0, "hyperlinks": 2419.0, "robotstxt": 2366.0, "wayback": 2423.0}, {"date": "2024-05-19", "sites": 1120, "cropped_screenshots": 2345, "full_screenshots": 2264.0, "lighthouse": 2337.0, "accessibility": 2422.0, "hyperlinks": 2418.0, "robotstxt": 2369.0, "wayback": 2422.0}, {"date": "2024-05-20", "sites": 1116, "cropped_screenshots": 2340, "full_screenshots": 2256.0, "lighthouse": 2360.0, "accessibility": 2423.0, "hyperlinks": 2418.0, "robotstxt": 2360.0, "wayback": 2420.0}, {"date": "2024-05-21", "sites": 1117, "cropped_screenshots": 2343, "full_screenshots": 2262.0, "lighthouse": 2364.0, "accessibility": 2422.0, "hyperlinks": 2415.0, "robotstxt": 2359.0, "wayback": 2417.0}, {"date": "2024-05-22", "sites": 1117, "cropped_screenshots": 2338, "full_screenshots": 2263.0, "lighthouse": 2365.0, "accessibility": 2424.0, "hyperlinks": 2417.0, "robotstxt": 2357.0, "wayback": 2424.0}, {"date": "2024-05-23", "sites": 1126, "cropped_screenshots": 2348, "full_screenshots": 2272.0, "lighthouse": 2362.0, "accessibility": 2423.0, "hyperlinks": 2418.0, "robotstxt": 2360.0, "wayback": 2417.0}, {"date": "2024-05-24", "sites": 1114, "cropped_screenshots": 2332, "full_screenshots": 2255.0, "lighthouse": 2361.0, "accessibility": 2422.0, "hyperlinks": 2414.0, "robotstxt": 2360.0, "wayback": 2409.0}, {"date": "2024-05-25", "sites": 1113, "cropped_screenshots": 2334, "full_screenshots": 2254.0, "lighthouse": 2362.0, "accessibility": 2424.0, "hyperlinks": 2417.0, "robotstxt": 2364.0, "wayback": 2421.0}, {"date": "2024-05-26", "sites": 1110, "cropped_screenshots": 2309, "full_screenshots": 2235.0, "lighthouse": 2344.0, "accessibility": 2405.0, "hyperlinks": 2396.0, "robotstxt": 2340.0, "wayback": 2333.0}, {"date": "2024-05-27", "sites": 1118, "cropped_screenshots": 1977, "full_screenshots": 1864.0, "lighthouse": 1841.0, "accessibility": 1969.0, "hyperlinks": 1922.0, "robotstxt": 1770.0, "wayback": 1695.0}, {"date": "2024-05-28", "sites": 1117, "cropped_screenshots": 2262, "full_screenshots": 2175.0, "lighthouse": 2229.0, "accessibility": 2323.0, "hyperlinks": 2314.0, "robotstxt": 2255.0, "wayback": 2237.0}, {"date": "2024-05-29", "sites": 1117, "cropped_screenshots": 2318, "full_screenshots": 2242.0, "lighthouse": 2232.0, "accessibility": 2400.0, "hyperlinks": 2393.0, "robotstxt": 2338.0, "wayback": 2386.0}, {"date": "2024-05-30", "sites": 1113, "cropped_screenshots": 2379, "full_screenshots": 2290.0, "lighthouse": 2313.0, "accessibility": 2463.0, "hyperlinks": 2445.0, "robotstxt": 2403.0, "wayback": 2450.0}, {"date": "2024-05-31", "sites": 1117, "cropped_screenshots": 2336, "full_screenshots": 2257.0, "lighthouse": 2361.0, "accessibility": 2421.0, "hyperlinks": 2347.0, "robotstxt": 2365.0, "wayback": 2421.0}, {"date": "2024-06-01", "sites": 1116, "cropped_screenshots": 2345, "full_screenshots": 2264.0, "lighthouse": 2365.0, "accessibility": 2422.0, "hyperlinks": 2350.0, "robotstxt": 2355.0, "wayback": 2419.0}, {"date": "2024-06-02", "sites": 1115, "cropped_screenshots": 2340, "full_screenshots": 2264.0, "lighthouse": 2363.0, "accessibility": 2424.0, "hyperlinks": 2350.0, "robotstxt": 2358.0, "wayback": 2344.0}, {"date": "2024-06-03", "sites": 1113, "cropped_screenshots": 2337, "full_screenshots": 2261.0, "lighthouse": 2364.0, "accessibility": 2426.0, "hyperlinks": 2354.0, "robotstxt": 2363.0, "wayback": 2426.0}, {"date": "2024-06-04", "sites": 1115, "cropped_screenshots": 2339, "full_screenshots": 2261.0, "lighthouse": 2362.0, "accessibility": 2424.0, "hyperlinks": 2351.0, "robotstxt": 2363.0, "wayback": 2424.0}, {"date": "2024-06-05", "sites": 1121, "cropped_screenshots": 2336, "full_screenshots": 2259.0, "lighthouse": 2354.0, "accessibility": 2416.0, "hyperlinks": 2340.0, "robotstxt": 2345.0, "wayback": 2354.0}, {"date": "2024-06-06", "sites": 1118, "cropped_screenshots": 2339, "full_screenshots": 2259.0, "lighthouse": 2360.0, "accessibility": 2424.0, "hyperlinks": 2347.0, "robotstxt": 2351.0, "wayback": 2186.0}, {"date": "2024-06-07", "sites": 1115, "cropped_screenshots": 2337, "full_screenshots": 2259.0, "lighthouse": 2371.0, "accessibility": 2425.0, "hyperlinks": 2351.0, "robotstxt": 2366.0, "wayback": 2422.0}, {"date": "2024-06-08", "sites": 1112, "cropped_screenshots": 2335, "full_screenshots": 2258.0, "lighthouse": 2366.0, "accessibility": 2425.0, "hyperlinks": 2351.0, "robotstxt": 2359.0, "wayback": 2424.0}, {"date": "2024-06-09", "sites": 1109, "cropped_screenshots": 2329, "full_screenshots": 2254.0, "lighthouse": 2370.0, "accessibility": 2427.0, "hyperlinks": 2351.0, "robotstxt": 2350.0, "wayback": 2415.0}, {"date": "2024-06-10", "sites": 1117, "cropped_screenshots": 2340, "full_screenshots": 2261.0, "lighthouse": 2366.0, "accessibility": 2425.0, "hyperlinks": 2351.0, "robotstxt": 2360.0, "wayback": 2423.0}, {"date": "2024-06-11", "sites": 1114, "cropped_screenshots": 2334, "full_screenshots": 2252.0, "lighthouse": 2363.0, "accessibility": 2424.0, "hyperlinks": 2348.0, "robotstxt": 2357.0, "wayback": 2421.0}, {"date": "2024-06-12", "sites": 1122, "cropped_screenshots": 2338, "full_screenshots": 2263.0, "lighthouse": 2360.0, "accessibility": 2426.0, "hyperlinks": 2350.0, "robotstxt": 2361.0, "wayback": 2420.0}, {"date": "2024-06-13", "sites": 1118, "cropped_screenshots": 2346, "full_screenshots": 2261.0, "lighthouse": 2359.0, "accessibility": 2426.0, "hyperlinks": 2349.0, "robotstxt": 2361.0, "wayback": 2415.0}, {"date": "2024-06-14", "sites": 1121, "cropped_screenshots": 2346, "full_screenshots": 2264.0, "lighthouse": 2362.0, "accessibility": 2423.0, "hyperlinks": 2341.0, "robotstxt": 2355.0, "wayback": 2417.0}, {"date": "2024-06-15", "sites": 1118, "cropped_screenshots": 2343, "full_screenshots": 2261.0, "lighthouse": 2365.0, "accessibility": 2427.0, "hyperlinks": 2353.0, "robotstxt": 2363.0, "wayback": 2418.0}, {"date": "2024-06-16", "sites": 1111, "cropped_screenshots": 2333, "full_screenshots": 2252.0, "lighthouse": 2361.0, "accessibility": 2424.0, "hyperlinks": 2347.0, "robotstxt": 2366.0, "wayback": 2415.0}, {"date": "2024-06-17", "sites": 1116, "cropped_screenshots": 2338, "full_screenshots": 2256.0, "lighthouse": 2366.0, "accessibility": 2426.0, "hyperlinks": 2352.0, "robotstxt": 2360.0, "wayback": 2406.0}, {"date": "2024-06-18", "sites": 1120, "cropped_screenshots": 2336, "full_screenshots": 2259.0, "lighthouse": 2355.0, "accessibility": 2418.0, "hyperlinks": 2343.0, "robotstxt": 2347.0, "wayback": 2389.0}, {"date": "2024-06-19", "sites": 1116, "cropped_screenshots": 2337, "full_screenshots": 2258.0, "lighthouse": 2364.0, "accessibility": 2424.0, "hyperlinks": 2349.0, "robotstxt": 2356.0, "wayback": 2415.0}, {"date": "2024-06-20", "sites": 1111, "cropped_screenshots": 2332, "full_screenshots": 2253.0, "lighthouse": 2364.0, "accessibility": 2426.0, "hyperlinks": 2352.0, "robotstxt": 2361.0, "wayback": 2421.0}, {"date": "2024-06-21", "sites": 1110, "cropped_screenshots": 2332, "full_screenshots": 2254.0, "lighthouse": 2361.0, "accessibility": 2424.0, "hyperlinks": 2349.0, "robotstxt": 2354.0, "wayback": 2402.0}, {"date": "2024-06-22", "sites": 1111, "cropped_screenshots": 2352, "full_screenshots": 2268.0, "lighthouse": 2385.0, "accessibility": 2445.0, "hyperlinks": 2371.0, "robotstxt": 2375.0, "wayback": 2414.0}, {"date": "2024-06-23", "sites": 1109, "cropped_screenshots": 2329, "full_screenshots": 2250.0, "lighthouse": 2368.0, "accessibility": 2425.0, "hyperlinks": 2352.0, "robotstxt": 2363.0, "wayback": 2410.0}, {"date": "2024-06-24", "sites": 1115, "cropped_screenshots": 2333, "full_screenshots": 2256.0, "lighthouse": 2368.0, "accessibility": 2426.0, "hyperlinks": 2352.0, "robotstxt": 2357.0, "wayback": 2418.0}, {"date": "2024-06-25", "sites": 1110, "cropped_screenshots": 2329, "full_screenshots": 2252.0, "lighthouse": 2365.0, "accessibility": 2425.0, "hyperlinks": 2352.0, "robotstxt": 2355.0, "wayback": 2418.0}, {"date": "2024-06-26", "sites": 1120, "cropped_screenshots": 2343, "full_screenshots": 2265.0, "lighthouse": 2366.0, "accessibility": 2425.0, "hyperlinks": 2354.0, "robotstxt": 2355.0, "wayback": 2419.0}, {"date": "2024-06-27", "sites": 1118, "cropped_screenshots": 2327, "full_screenshots": 2245.0, "lighthouse": 2338.0, "accessibility": 2406.0, "hyperlinks": 2333.0, "robotstxt": 2340.0, "wayback": 2369.0}, {"date": "2024-06-28", "sites": 1115, "cropped_screenshots": 2339, "full_screenshots": 2259.0, "lighthouse": 2367.0, "accessibility": 2426.0, "hyperlinks": 2353.0, "robotstxt": 2360.0, "wayback": 2423.0}, {"date": "2024-06-29", "sites": 1117, "cropped_screenshots": 2345, "full_screenshots": 2261.0, "lighthouse": 2365.0, "accessibility": 2424.0, "hyperlinks": 2352.0, "robotstxt": 2358.0, "wayback": 2422.0}, {"date": "2024-06-30", "sites": 1120, "cropped_screenshots": 2348, "full_screenshots": 2269.0, "lighthouse": 2366.0, "accessibility": 2425.0, "hyperlinks": 2354.0, "robotstxt": 2365.0, "wayback": 2424.0}, {"date": "2024-07-01", "sites": 1120, "cropped_screenshots": 2344, "full_screenshots": 2262.0, "lighthouse": 2368.0, "accessibility": 2426.0, "hyperlinks": 2356.0, "robotstxt": 2370.0, "wayback": 2426.0}, {"date": "2024-07-02", "sites": 1123, "cropped_screenshots": 2349, "full_screenshots": 2262.0, "lighthouse": 2348.0, "accessibility": 2425.0, "hyperlinks": 2354.0, "robotstxt": 2363.0, "wayback": 2423.0}, {"date": "2024-07-03", "sites": 1116, "cropped_screenshots": 2340, "full_screenshots": 2258.0, "lighthouse": 2346.0, "accessibility": 2424.0, "hyperlinks": 2354.0, "robotstxt": 2369.0, "wayback": 2412.0}, {"date": "2024-07-04", "sites": 1116, "cropped_screenshots": 2343, "full_screenshots": 2259.0, "lighthouse": 2350.0, "accessibility": 2425.0, "hyperlinks": 2355.0, "robotstxt": 2362.0, "wayback": 2419.0}, {"date": "2024-07-05", "sites": 1142, "cropped_screenshots": 2369, "full_screenshots": 2297.0, "lighthouse": 2351.0, "accessibility": 2427.0, "hyperlinks": 2354.0, "robotstxt": 2365.0, "wayback": 2425.0}, {"date": "2024-07-06", "sites": 1163, "cropped_screenshots": 2455, "full_screenshots": 2419.0, "lighthouse": 2351.0, "accessibility": 2426.0, "hyperlinks": 2356.0, "robotstxt": 2366.0, "wayback": 2426.0}, {"date": "2024-07-07", "sites": 1163, "cropped_screenshots": 2187, "full_screenshots": 2158.0, "lighthouse": 2099.0, "accessibility": 2165.0, "hyperlinks": 2098.0, "robotstxt": 2096.0, "wayback": 2047.0}, {"date": "2024-07-08", "sites": 1163, "cropped_screenshots": 2505, "full_screenshots": 2448.0, "lighthouse": 2334.0, "accessibility": 2435.0, "hyperlinks": 2348.0, "robotstxt": 2315.0, "wayback": 2396.0}, {"date": "2024-07-09", "sites": 1163, "cropped_screenshots": 2442, "full_screenshots": 2396.0, "lighthouse": 2305.0, "accessibility": 2394.0, "hyperlinks": 2315.0, "robotstxt": 2290.0, "wayback": 2317.0}, {"date": "2024-07-10", "sites": 1163, "cropped_screenshots": 2454, "full_screenshots": 2416.0, "lighthouse": 2350.0, "accessibility": 2424.0, "hyperlinks": 2353.0, "robotstxt": 2365.0, "wayback": 2420.0}, {"date": "2024-07-11", "sites": 1162, "cropped_screenshots": 2453, "full_screenshots": 2414.0, "lighthouse": 2351.0, "accessibility": 2425.0, "hyperlinks": 2355.0, "robotstxt": 2362.0, "wayback": 2421.0}, {"date": "2024-07-12", "sites": 1160, "cropped_screenshots": 2308, "full_screenshots": 2264.0, "lighthouse": 2181.0, "accessibility": 2260.0, "hyperlinks": 2194.0, "robotstxt": 2197.0, "wayback": 2251.0}, {"date": "2024-07-13", "sites": 1162, "cropped_screenshots": 2438, "full_screenshots": 2402.0, "lighthouse": 2332.0, "accessibility": 2409.0, "hyperlinks": 2337.0, "robotstxt": 2350.0, "wayback": 2406.0}, {"date": "2024-07-14", "sites": 1162, "cropped_screenshots": 2453, "full_screenshots": 2417.0, "lighthouse": 2350.0, "accessibility": 2426.0, "hyperlinks": 2355.0, "robotstxt": 2363.0, "wayback": 2424.0}, {"date": "2024-07-15", "sites": 1162, "cropped_screenshots": 2453, "full_screenshots": 2418.0, "lighthouse": 2353.0, "accessibility": 2426.0, "hyperlinks": 2356.0, "robotstxt": 2366.0, "wayback": 2425.0}, {"date": "2024-07-16", "sites": 1162, "cropped_screenshots": 2452, "full_screenshots": 2418.0, "lighthouse": 2351.0, "accessibility": 2426.0, "hyperlinks": 2356.0, "robotstxt": 2362.0, "wayback": 2423.0}, {"date": "2024-07-17", "sites": 1162, "cropped_screenshots": 2450, "full_screenshots": 2414.0, "lighthouse": 2349.0, "accessibility": 2424.0, "hyperlinks": 2353.0, "robotstxt": 2366.0, "wayback": 2422.0}, {"date": "2024-07-18", "sites": 1161, "cropped_screenshots": 2451, "full_screenshots": 2414.0, "lighthouse": 2351.0, "accessibility": 2426.0, "hyperlinks": 2355.0, "robotstxt": 2366.0, "wayback": 2422.0}, {"date": "2024-07-19", "sites": 1161, "cropped_screenshots": 2378, "full_screenshots": 2328.0, "lighthouse": 2217.0, "accessibility": 2315.0, "hyperlinks": 2230.0, "robotstxt": 2213.0, "wayback": 2276.0}, {"date": "2024-07-20", "sites": 1161, "cropped_screenshots": 2450, "full_screenshots": 2414.0, "lighthouse": 2349.0, "accessibility": 2426.0, "hyperlinks": 2354.0, "robotstxt": 2371.0, "wayback": 2424.0}, {"date": "2024-07-21", "sites": 1162, "cropped_screenshots": 2452, "full_screenshots": 2415.0, "lighthouse": 2348.0, "accessibility": 2427.0, "hyperlinks": 2357.0, "robotstxt": 2363.0, "wayback": 2423.0}, {"date": "2024-07-22", "sites": 1161, "cropped_screenshots": 2449, "full_screenshots": 2414.0, "lighthouse": 2344.0, "accessibility": 2424.0, "hyperlinks": 2355.0, "robotstxt": 2355.0, "wayback": 2394.0}, {"date": "2024-07-23", "sites": 1161, "cropped_screenshots": 2450, "full_screenshots": 2413.0, "lighthouse": 2347.0, "accessibility": 2423.0, "hyperlinks": 2353.0, "robotstxt": 2365.0, "wayback": 2380.0}, {"date": "2024-07-24", "sites": 1161, "cropped_screenshots": 2449, "full_screenshots": 2414.0, "lighthouse": 2352.0, "accessibility": 2428.0, "hyperlinks": 2358.0, "robotstxt": 2358.0, "wayback": 2365.0}, {"date": "2024-07-25", "sites": 1161, "cropped_screenshots": 2448, "full_screenshots": 2413.0, "lighthouse": 2351.0, "accessibility": 2424.0, "hyperlinks": 2354.0, "robotstxt": 2359.0, "wayback": 2388.0}, {"date": "2024-07-26", "sites": 1161, "cropped_screenshots": 2450, "full_screenshots": 2414.0, "lighthouse": 2349.0, "accessibility": 2426.0, "hyperlinks": 2356.0, "robotstxt": 2366.0, "wayback": 2425.0}, {"date": "2024-07-27", "sites": 1161, "cropped_screenshots": 2450, "full_screenshots": 2414.0, "lighthouse": 2346.0, "accessibility": 2425.0, "hyperlinks": 2355.0, "robotstxt": 2360.0, "wayback": 2420.0}, {"date": "2024-07-28", "sites": 1160, "cropped_screenshots": 1789, "full_screenshots": 1772.0, "lighthouse": 1723.0, "accessibility": 1779.0, "hyperlinks": 1722.0, "robotstxt": 1726.0, "wayback": 1774.0}, {"date": "2024-07-29", "sites": 1161, "cropped_screenshots": 2451, "full_screenshots": 2415.0, "lighthouse": 2349.0, "accessibility": 2426.0, "hyperlinks": 2356.0, "robotstxt": 2367.0, "wayback": 2425.0}, {"date": "2024-07-30", "sites": 1160, "cropped_screenshots": 2419, "full_screenshots": 2389.0, "lighthouse": 2328.0, "accessibility": 2401.0, "hyperlinks": 2330.0, "robotstxt": 2345.0, "wayback": 2391.0}, {"date": "2024-07-31", "sites": 1161, "cropped_screenshots": 2447, "full_screenshots": 2413.0, "lighthouse": 2351.0, "accessibility": 2426.0, "hyperlinks": 2354.0, "robotstxt": 2366.0, "wayback": 2424.0}, {"date": "2024-08-01", "sites": 1161, "cropped_screenshots": 2445, "full_screenshots": 2405.0, "lighthouse": 2340.0, "accessibility": 2423.0, "hyperlinks": 2349.0, "robotstxt": 2359.0, "wayback": 2418.0}]);
const config = {
    sites: {
        attr: 'sites',
        id: "#sites-by-date",
        label: "Sites by day"
    },
    cropped_screenshots: {
        attr: 'cropped_screenshots',
        id: "#cropped-screenshots-by-date",
        label: "Cropped screenshots by day"
    },
    full_screenshots: {
        attr: 'full_screenshots',
        id: "#full-screenshots-by-date",
        label: "Full screenshots by day"
    },
    lighthouse: {
        attr: 'lighthouse',
        id: "#lighthouse-by-date",
        label: "Lighthouse audits by day"
    },
    accessibility: {
        attr: 'accessibility',
        id: "#accessibility-by-date",
        label: "Accessibility trees by day"
    },
    hyperlinks: {
        attr: 'hyperlinks',
        id: "#hyperlinks-by-date",
        label: "Hyperlink lists by day"
    },
    wayback: {
        attr: 'wayback',
        id: "#wayback-by-date",
        label: "Wayback Machine archive requests by day"
    },
    robotstxt: {
        attr: 'robotstxt',
        id: "#robotstxt-by-date",
        label: "robots.txt by day"
    }
};
Object.keys(config).forEach(key => {
    drawChart(config[key].attr, config[key].id, config[key].label);
})
</script>
