# homepages.news

An open-source archive that gathers, saves, shares and analyzes news homepages

## Features

```{toctree}
:maxdepth: 1
:name: mastertoc

latest
accessibility
performance
drudge
openai-gptbot-robotstxt
extracts
status-report
```

## Directory

```{toctree}
:maxdepth: 1
:name: directory

sources
countries
languages
bundles
```

## About

The archive at [homepages.news](https://homepages.news) is an [open-source software project](https://github.com/palewire/news-homepages) managed by [Ben Welsh](https://palewi.re/who-is-ben-welsh/). Each day it gathers screenshots, accessibility trees, hyperlink lists, robots.txt and Lighthouse audits from hundreds of news homepages around the world. It also ensures that all sites are routinely saved by the [Wayback Machine at archive.org](https://web.archive.org/).

The assets are archived in a permanent collection [at the Internet Archive](https://archive.org/details/news-homepages). The latest screenshots, analysis and data are published here, as well as on [Mastodon](https://mastodon.palewi.re/@newshomepages).

The system supports the creation of bots to post a newsroom’s latest screenshots into a private Slack channel. [The tool](https://palewi.re/docs/news-homepages/slack.html) is used by organizations in the U.S. and abroad to save and share images each day.

## Contributing

```{toctree}
:maxdepth: 1
:name: contributing

gettingstarted
adding
slack
reference
```

## Links

- Internet Archive: [archive.org/details/news-homepages](https://archive.org/details/news-homepages)
- Mastodon: [@newshomepages](https://mastodon.palewi.re/@newshomepages)
- Code: [github.com/palewire/news-homepages](https://github.com/palewire/news-homepages)
- Task runner: [github.com/palewire/news-homepages/actions](https://github.com/palewire/news-homepages/actions)
- Packaging: [pypi.org/project/newshomepages](https://pypi.org/project/newshomepages/)
- Issues: [github.com/palewire/news-homepages/issues](https://github.com/palewire/news-homepages/issues)
