# Management commands

Custom [Django management commands](https://docs.djangoproject.com/en/dev/ref/django-admin/) for
this library that help make things happen.

(build)=

## build

Bake out a site as flat files in the build directory, defined in settings.py by `BUILD_DIR`.

By default, this wipes the build directory if it exists, then builds
any static files in the `STATIC_ROOT` to the `STATIC_URL`,
any media files in the `MEDIA_ROOT` to the `MEDIA_URL` and
all pages generated by the buildable views listed in `BAKERY_VIEWS`.

As a small bonus, files named `robots.txt` and `favicon.ico` will be placed
at the build directory's root if discovered at the `STATIC_ROOT`.

Defaults can be modified with the following command options.

```{eval-rst}
.. cmdoption:: --build-dir <path>

   Specify the path of the build directory. Will use ``settings.BUILD_DIR`` by default.
```

```{eval-rst}
.. cmdoption:: --keep-build-dir

    Skip deleting and recreating the build directory before building files. By
    default the entire directory is wiped out.
```

```{eval-rst}
.. cmdoption:: --skip-static

    Skip collecting the static files when building.
```

```{eval-rst}
.. cmdoption:: --skip-media

    Skip collecting the media files when building.
```

```bash
$ python manage.py build
```

View names passed as arguments will override the `BAKERY_VIEWS` list.

```bash
$ python manage.py build yourapp.views.DummyL­istView
```

## buildserver

Starts a variation of Django's [runserver](https://docs.djangoproject.com/en/dev/ref/django-admin/#runserver-port-or-address-port) designed to serve the static files you've built
in the build directory.

```bash
$ python manage.py buildserver
```

## publish

Syncs your Amazon S3 bucket to be identical to the local build directory. New files are uploaded,
changed files are updated and absent files are deleted.

```{eval-rst}
.. cmdoption:: --aws-bucket-name <name>

    Specify the AWS bucket to sync with. Will use settings.AWS_BUCKET_NAME by default.
```

```{eval-rst}
.. cmdoption:: --build-dir <path>

    Specify the path of the build directory. Will use settings.BUILD_DIR by default.
```

```{eval-rst}
.. cmdoption:: --force

    Force a re-upload of all files in the build directory to the AWS bucket.
```

```{eval-rst}
.. cmdoption:: --dry-run

    Provide output of what the command would perform, but without changing anything.
```

```{eval-rst}
.. cmdoption:: --no-delete

    Keep files in S3, even if they do not exist in the build directory. The
    default behavior is to delete files in the bucket that are not in the
    build directory.
```

```bash
$ python manage.py publish
```

## unbuild

Empties the build directory.

```bash
$ python manage.py unbuild
```

## unpublish

Empties the Amazon S3 bucket defined in `settings.py`.

```bash
$ python manage.py unpublish
```
