type Polarity = "r" | "-" | "d" | "=" | "w";
type Rarity = "n" | "c" | "r" | "g" | "l" | "x";

const Primary = "Primary";
const Rifle = "Rifle";
const Sniper = "Sniper";
const Shotgun = "Shotgun";
const Secondary = "Secondary";
const Melee = "Melee";
const Aura = "Aura";
const Warframe = "Warframe";
const Exilus = "Exilus";
const Archwing = "Archwing";
const Archgun = "Arch-Gun";
const Archmelee = "Arch-Melee";
const Companion = "Companion";
const Animal = "Animal";
const Robotic = "Robotic";
const Sentinel = "Sentinel";
const MOA = "MOA";
const Beast = "Beast";
const Kubrow = "Kubrow";
const Kavat = "Kavat";

const data = [
  // 00 为空槽 01 为紫卡
  // 主要武器 00 ~ 0z
  ["02", "Hunter Munitions", [["ac", 5]], Primary, "r", "c", 4],
  ["03", "Vigilante Armaments", [["S", 10], ["!ce", 5]], Primary, "-", "n", 4],
  ["04", "Vigilante Fervor", [["R", 7.5], ["!ce", 5]], Primary, "r", "c", 4],
  ["05", "Vigilante Offense", [["P", 0.3], ["!ce", 5]], Primary, "-", "r", 4],
  ["06", "Hunter Track", [["3", 5]], Primary, "r", "r", 4],
  ["07", "Vigilante Supplies", [["am", 30]], Primary, "-", "r", 4],
  ["08", "Proton Jet", [["onWalllatch"], ["0", 30], ["2", 30]], Primary, "-", "c", 4, 3],
  ["09", "Motus Setup", [["onLand"], ["0", 25], ["2", 25]], Primary, "r", "r", 6, 3],
  ["0A", "Aero Periphery", ["onAimGliding"], [["H", 12.5]], Primary, "-", "n", 2, 3],
  ["0B", "Aero Agility", [["onAimGliding"], ["F", 25]], Primary, "-", "r", 4, 3],

  // 步枪 10 ~ 4z
  ["10", "Serration", [["D", 15]], Rifle, "r", "c", 4, 10],
  ["11", "Split Chamber", [["S", 15]], Rifle, "r", "r", 10],
  ["12", "Heavy Caliber", [["D", 15], ["acc", -5]], Rifle, "r", "r", 6, 10],
  ["13", "Point Strike", [["0", 25]], Rifle, "r", "n", 4],
  ["14", "Vital Sense", [["1", 20]], Rifle, "r", "r", 4],
  ["15", "Argon Scope", [["onHeadshot"], ["0", 22.5]], Rifle, "r", "r", 2],
  ["16", "Bladed Rounds", [["onKill"], ["1", 20]], Rifle, "r", "c", 4],
  ["17", "Hammer Shot", [["1", 15], ["2", 20]], Rifle, "d", "r", 6, 3],
  ["18", "Cryo Rounds", [["5", 15]], Rifle, "d", "c", 6],
  ["19", "Primed Cryo Rounds", [["5", 15]], Rifle, "d", "l", 6, 10],
  ["1A", "Infected Clip", [["6", 15]], Rifle, "-", "c", 6],
  ["1B", "Stormbringer", [["7", 15]], Rifle, "-", "c", 6],
  ["1C", "Hellfire", [["4", 15]], Rifle, "-", "c", 6],
  ["1D", "Malignant Force", [["6", 15], ["2", 15]], Rifle, "r", "r", 4, 3],
  ["1E", "High Voltage", [["7", 15], ["2", 15]], Rifle, "r", "r", 4, 3],
  ["1F", "Rime Rounds", [["5", 15], ["2", 15]], Rifle, "r", "r", 4, 3],
  ["1G", "Thermite Rounds", [["4", 15], ["2", 15]], Rifle, "r", "r", 4, 3],
  ["1H", "Piercing Hit", [["9", 5]], Rifle, "-", "n", 4],
  ["1I", "Piercing Caliber", [["9", 20]], Rifle, "-", "r", 6],
  ["1J", "Sawtooth Clip", [["A", 5]], Rifle, "-", "n", 4],
  ["1K", "Fanged Fusillade", [["A", 20]], Rifle, "-", "r", 6],
  ["1L", "Rupture", [["8", 5]], Rifle, "-", "n", 4],
  ["1M", "Crash Course", [["8", 20]], Rifle, "-", "r", 6],
  ["1N", "Critical Delay", [["0", 200 / 6], ["R", -20 / 6]], Rifle, "-", "r", 4],
  ["1O", "Adhesive Blast", [["stick", 100 / 6]], "Launcher", "r", "r", 4],
  ["1P", "Sinister Reach", [["ar", 3]], "Continuous", "-", "c", 2, 3],
  ["1Q", "Vile Acceleration", [["R", 15], ["D", -2.5]], Rifle, "-", "r", 4],
  ["1R", "Metal Auger", [["P", 0.4]], Rifle, "-", "r", 10],
  ["1S", "Magazine Warp", [["L", 5]], Rifle, "-", "n", 4],
  ["1T", "Ammo Drum", [["M", 5]], Rifle, "-", "n", 2],
  ["1U", "Shred", [["R", 5], ["P", 0.2]], Rifle, "r", "r", 6],
  ["1V", "Continuous Misery", [["3", 25]], Rifle, "r", "n", 4, 3],
  ["1W", "Agile Aim", [["m", 5]], Rifle, "r", "c", 2, 3],
  ["1X", "Vile Precision", [["Z", -10], ["R", -6]], Rifle, "-", "r", 6],
  ["1Y", "Terminal Velocity", [["V", 15]], Rifle, "r", "c", 4, 3],
  ["1Z", "Rifle Aptitude", [["2", 15]], Rifle, "d", "c", 4],
  ["1a", "Hush", [["slc", 25]], Rifle, "-", "n", 2, 3],
  ["1b", "Bane of Corpus", [["C", 5]], Rifle, "r", "c", 4],
  ["1c", "Primed Bane of Corpus", [["C", 5]], Rifle, "r", "l", 4, 10],
  ["1d", "Bane of Grineer", [["G", 5]], Rifle, "r", "c", 4],
  ["1e", "Primed Bane of Grineer", [["G", 5]], Rifle, "r", "l", 4, 10],
  ["1f", "Bane of Infested", [["I", 5]], Rifle, "r", "c", 4],
  ["1g", "Primed Bane of Infested", [["I", 5]], Rifle, "r", "l", 4, 10],
  ["1h", "Bane of Corrupted", [["od", 5]], Rifle, "r", "c", 4],
  ["1i", "Primed Bane of Corrupted", [["od", 5]], Rifle, "r", "l", 4, 10],
  ["1j", "Speed Trigger", [["R", 10]], Rifle, "r", "c", 4],
  ["1k", "Combustion Beam", [["kb", 100]], "Continuous", "r", "r", 4],
  ["1l", "Firestorm", [["brad", 6]], "Launcher", "r", "r", 6, 3],
  ["1m", "Fast Hands", [["F", 5]], Rifle, "-", "n", 2],
  ["1n", "Primed Fast Hands", [["F", 5]], Rifle, "-", "l", 2, 10],
  ["1o", "Stabilizer", [["Z", -15]], Rifle, "-", "r", 6, 3],
  ["1p", "Guided Ordnance", [["onHit"], ["acc", 5]], "Assault Rifle", "r", "c", 2],
  ["1q", "Spring-Loaded Chamber", [["onReload"], ["R", 12.5]], "Assault Rifle", "r", "c", 2],
  ["1r", "Kinetic Ricochet", [["but", 1], ["V", 5]], "Tetra", "-", "r", 2],
  ["1s", "Tether Grenades", [["el", 2]], "Penta", "-", "r", 2],
  ["1t", "Catalyzer Link", [["onAbilityCast"], ["2", 10]], Rifle, "r", "n", 4],
  ["1u", "Twitch", [["hr", 50]], Rifle, "-", "c", 4, 3],
  ["1v", "Wildfire", [["L", 5], ["4", 15]], Rifle, "r", "r", 6, 3],
  ["1w", "Eagle Eye", [["H", 10]], Rifle, "-", "c", 4, 3],
  ["1x", "Charged Chamber", [["fsb", 10]], Sniper, "r", "c", 6, 3],
  ["1y", "Primed Charged Chamber", [["fsb", 10]], Sniper, "r", "l", 6, 10],
  ["1z", "Primed Chamber", [["fsb", 25]], Sniper, "r", "r", 4, 3],
  ["20", "Rifle Ammo Mutation", [["am", 37.5]], "Assault Rifle", "-", "r", 4],
  ["21", "Arrow Mutation", [["am", 37.5]], "Bow", "-", "r", 4],
  ["22", "Sniper Ammo Mutation", [["am", 37.5]], Sniper, "-", "r", 4],
  ["23", "Target Acquired", [["hm", 10]], Sniper, "r", "r", 6],
  ["24", "Entropy Burst", [["i2", 5], ["ve", 0.3]], "Supra", "r", "r", 4, 3],
  ["25", "Lasting Purity", [["da", 15], ["vp", 0.3]], "Vulkar", "-", "r", 4, 3],
  ["26", "Nightwatch Napalm", [["Rockets disperse napalm, inflicting 5% damage over 1s across 15% of the explosion area."]], "Ogris", "r", "c", 4],
  ["27", "Flux Overdrive", [["Status Chance fluctuates between +25% and +41% over 5s while the beam is fired."]], "Flux Rifle", "r", "r", 2],
  ["28", "Neutralizing Justice", [["Each Miter blade has a +22.5% chance to immediately destroy a Nullifier field."], ["vj", 0.3]], "Miter", "d", "r", 4, 3],
  ["29", "Voltage Sequence", [["Killing a flying enemy creates a lightning trap from their remains, lasting 2s"], ["vs", 0.3]], "Lanka", "-", "r", 4, 3],
  ["2A", "Disarming Purity", [["Secondary Fire mode has a 10% chance to disarm enemies."], ["vp", 0.3]], "Panthera", "-", "r", 4, 3],
  ["2B", "Deadly Sequence", [["0", 50], ["vs", 0.3]], "Grinlok", "r", "r", 4, 3],
  ["2C", "Gilded Truth", [["R", 20], ["vt", 0.3]], "Burston Prime", "r", "r", 4, 3],
  ["2D", "Spring-Loaded Broadhead", [["!oad", 40], ["!ify", 45], ["ify", -5]], "Daikyu", "r", "r", 10],
  ["2K", "Depleted Reload", [["L", -10], ["F", 8]], Sniper, "-", "r", 2],
  ["2L", "Primed Shred", [["R", 5], ["P", 0.2]], Rifle, "r", "l", 6, 10],
  ["2M", "Primed Rifle Ammo Mutation", [["am", 68.75]], "Assault Rifle", "-", "l", 4, 10],
  // ["2N", "primedSniperAmmoMutation", [["am", 0.6875]], Sniper, "-", "l", 14, 10],
  ["2O", "Sharpshooter", [["onHeadshotKill"], ["!her", 4], ["her", 1]], Sniper, "-", "r", 2, 10],
  ["2P", "Thunderbolt", [["exp", 7.5]], "Bow", "r", "r", 6, 3],
  ["2Q", "Cautious Shot", [["sb", -10], ["oad", -5]], "Launcher", "r", "r", 6, 3],
  ["2R", "Harkonar Scope", [["N", 2]], Sniper, "-", "c", 4],
  ["2S", "Tainted Mag", [["L", 6], ["F", -3]], Rifle, "-", "r", 4, 10],
  ["2T", "Wild Frenzy", [["!R", 160], ["R", 40]], "Grakata", "-", "r", 4],
  ["2U", "Bursting Mass", [["---"]], "Mutalist Quanta", "-", "r", 4],
  ["2V", "Napalm Grenades", [["i2", 5], ["!eid", -100], ["!e4", 700]], "Penta", "-", "r", 4],
  ["2W", "Amalgam Serration", [["D", 14], ["!D", 1], ["f", 2.2], ["!f", 0.8]], Rifle, "r", "g", 6, 10],
  ["2X", "Amalgam Javlok Magazine Warp", [["L", 7.5], ["rd", 1000], ["U", 15]], "Javlok", "-", "r", 6],
  ["2Y", "Amalgam Daikyu Target Acquired", [["hm", 12.5], ["+0.5% Life Steal on Nikanas"], ["10% chance to pickup used arrows."]], "Daikyu", "r", "r", 10],
  ["2Z", "Amalgam Argonak Metal Auger", [["P", 0.5], ["si", 1]], "Argonak", "-", "r", 6],
  ["2a", "Primed Magazine Warp", [["L", 5]], Rifle, "-", "l", 4, 10],
  ["30", "Galvanized Chamber", [["S", 80 / 11], ["onKill"], ["S", 150 / 11]], Rifle, "r", "r", 6, 10],
  ["31", "Galvanized Scope", [["onHeadshot"], ["0", 120 / 11], ["onHeadshotKill"], ["0", 200 / 11]], Rifle, "r", "r", 2, 10],
  ["32", "Galvanized Aptitude", [["2", 80 / 11], ["onKill"], ["ga", 80 / 11]], Rifle, "d", "r", 2, 10],
  ["3A", "Exposing Harpoon", [["0", 50]], "Harpak", "-", "r", 4],
  ["3B", "Meticulous Aim", [["hm", 17.5], ["oad", -7.5]], "Vulkar", "-", "r", 4, 3],
  ["3C", "Precision Strike", [["e0", 37.5]], "Tonkor", "-", "r", 4, 3],

  // 霰弹枪 50 ~ 8z
  ["50", "Point Blank", [["D", 15]], Shotgun, "r", "c", 4],
  ["51", "Primed Point Blank", [["D", 15]], Shotgun, "r", "l", 4, 10],
  ["52", "Hell's Chamber", [["S", 20]], Shotgun, "r", "r", 10],
  ["53", "Vicious Spread", [["D", 15], ["spr", 10]], Shotgun, "r", "r", 4],
  ["54", "Blaze", [["D", 15], ["4", 15]], Shotgun, "r", "r", 6, 3],
  ["55", "Toxic Barrage", [["6", 15], ["2", 15]], Shotgun, "r", "r", 4, 3],
  ["56", "Scattering Inferno", [["4", 15], ["2", 15]], Shotgun, "r", "r", 4, 3],
  ["57", "Frigid Blast", [["5", 15], ["2", 15]], Shotgun, "r", "r", 4, 3],
  ["58", "Shell Shock", [["7", 15], ["2", 15]], Shotgun, "r", "r", 4, 3],
  ["59", "Incendiary Coat", [["4", 15]], Shotgun, "-", "c", 6],
  ["5A", "Chilling Grasp", [["5", 15]], Shotgun, "d", "c", 6],
  ["5B", "Contagious Spread", [["6", 15]], Shotgun, "-", "c", 6],
  ["5C", "Charged Shell", [["7", 15]], Shotgun, "-", "c", 6],
  ["5D", "Shredder", [["A", 5]], Shotgun, "-", "n", 4],
  ["5E", "Sweeping Serration", [["A", 20]], Shotgun, "-", "r", 6],
  ["5F", "Flechette", [["9", 5]], Shotgun, "-", "n", 4],
  ["5G", "Breach Loader", [["9", 20]], Shotgun, "-", "r", 6],
  ["5H", "Disruptor", [["8", 5]], Shotgun, "-", "n", 4],
  ["5I", "Full Contact", [["8", 20]], Shotgun, "-", "r", 6],
  ["5J", "Accelerated Blast", [["R", 15], ["9", 15]], Shotgun, "r", "r", 6, 3],
  ["5K", "Cleanse Corpus", [["C", 5]], Shotgun, "r", "c", 4],
  ["5L", "Cleanse Grineer", [["G", 5]], Shotgun, "r", "c", 4],
  ["5M", "Cleanse Infested", [["I", 5]], Shotgun, "r", "c", 4],
  ["5N", "Cleanse Corrupted", [["od", 5]], Shotgun, "r", "c", 4],
  ["5O", "Shell Compression", [["M", 5]], Shotgun, "-", "c", 2],
  ["5P", "Lock and Load", [["lal", 5]], Shotgun, "-", "r", 10, 3],
  ["5Q", "Silent Battery", [["slc", 25]], Shotgun, "-", "c", 2, 3],
  ["5R", "Tactical Pump", [["F", 5]], Shotgun, "-", "c", 2],
  ["5S", "Lingering Torment", [["3", 5]], Shotgun, "r", "n", 6],
  ["5T", "Scattered Justice", [["S", 50], ["vj", 0.3]], "Hek", "r", "r", 4, 3],
  ["5U", "Tainted Shell", [["spr", -7], ["R", -5]], Shotgun, "d", "r", 4, 10],
  ["5V", "Chilling Reload", [["5", 15], ["F", 10]], Shotgun, "r", "r", 2, 3],
  ["5W", "Seeking Fury", [["F", 2.5], ["P", 0.2]], Shotgun, "r", "r", 6],
  ["5X", "Ravage", [["1", 10]], Shotgun, "r", "r", 4],
  ["5Y", "Primed Ravage", [["1", 10]], Shotgun, "r", "l", 4, 10],
  ["5Z", "Shrapnel Shot", [["onKill"], ["1", 16.5]], Shotgun, "r", "n", 4],
  ["5a", "Narrow Barrel", [["onHit"], ["acc", 5]], Shotgun, "r", "r", 2],
  ["5b", "Shattering Justice", [["2", 22.5], ["vj", 0.3]], "Sobek", "-", "r", 4, 3],
  ["5c", "Seeking Force", [["P", 0.4]], Shotgun, "-", "r", 10],
  ["5d", "Nano-Applicator", [["onAbilityCast"], ["2", 15]], Shotgun, "r", "r", 4],
  ["5e", "Fatal Acceleration", [["V", 10]], Shotgun, "r", "c", 4, 3],
  ["5f", "Frail Momentum", [["R", 15], ["D", -2.5]], Shotgun, "r", "r", 4],
  ["5g", "Shotgun Spazz", [["R", 15]], Shotgun, "r", "c", 4],
  ["5h", "Repeater Clip", [["onReload"], ["R", 17.5]], Shotgun, "r", "c", 4],
  ["5i", "Burdened Magazine", [["L", 10], ["F", -3]], Shotgun, "-", "r", 6],
  ["5j", "Shotgun Savvy", [["2", 15]], Shotgun, "d", "c", 4],
  ["5k", "Critical Deceleration", [["0", 200 / 6], ["R", -20 / 6]], Shotgun, "r", "r", 4],
  ["5l", "Laser Sight", [["onHeadshot"], ["0", 20]], Shotgun, "r", "c", 4],
  ["5m", "Blunderbuss", [["0", 15]], Shotgun, "r", "n", 4],
  // ["5n","Primed Blunderbuss", [["0", 1.65]], Shotgun, "r", "l", 4, 10],
  ["5o", "Ammo Stock", [["L", 10]], Shotgun, "-", "c", 2],
  ["5p", "Shotgun Ammo Mutation", [["am", 37.5]], Shotgun, "-", "r", 4],
  ["5q", "Primed Shotgun Ammo Mutation", [["am", 68.75]], Shotgun, "-", "l", 4, 10],
  ["5r", "Soft Hands", [["hr", 50]], Shotgun, "-", "c", 4, 3],
  ["5s", "Acid Shells", [["Enemies explode on death, dealing 75 Corrosive Damage (+8% Enemy Max Health) in a 2.5m radius."]], "Sobek", "r", "c", 4],
  ["5t", "Fomorian Accelerant", [["Flak now bounces up to 1x and travels 15% faster."]], "Drakgoon", "r", "c", 4, 3],
  ["5u", "Primed Charged Shell", [["7", 15]], Shotgun, "-", "l", 6, 10],
  ["5v", "Amalgam Shotgun Spazz", [["R", 14], ["!R", 1], ["rvs", 7.5]], Shotgun, "r", "g", 6],
  ["5w", "Primed Chilling Grasp", [["5", 15]], Shotgun, "d", "l", 6, 10],
  ["5x", "Galvanized Hell", [["S", 110 / 11], ["onKill"], ["S", 120 / 11]], Shotgun, "r", "r", 4, 10],
  ["5y", "Galvanized Acceleration", [["V", 30 / 11], ["onKill"], ["V", 60 / 11]], Shotgun, "r", "r", 2, 10],
  ["5z", "Galvanized Savvy", [["2", 80 / 11], ["onKill"], ["ga", 80 / 11]], Shotgun, "d", "r", 2, 10],
  ["60", "Primed Tactical Pump", [["F", 5]], Shotgun, "-", "l", 2, 10],
  ["6A", "Efficient Beams", [["2", 25]], "Convectrix", "-", "r", 4],
  ["6B", "Primed Cleanse Corpus", [["C", 5]], Shotgun, "r", "r", 4, 10],
  ["6C", "Primed Cleanse Grineer", [["G", 5]], Shotgun, "r", "r", 4, 10],
  ["6D", "Primed Cleanse Infested", [["I", 5]], Shotgun, "r", "r", 4, 10],

  // 手枪 90 ~ Bz
  ["90", "Hornet Strike", [["D", 20]], Secondary, "r", "c", 4, 10],
  ["91", "Barrel Diffusion", [["S", 20]], Secondary, "r", "r", 6],
  ["92", "Lethal Torrent", [["R", 10], ["S", 10]], Secondary, "r", "r", 6],
  ["93", "Pistol Gambit", [["0", 20]], Secondary, "r", "n", 4],
  ["94", "Primed Pistol Gambit", [["0", 17]], Secondary, "r", "l", 2, 10],
  ["95", "Target Cracker", [["1", 10]], Secondary, "r", "c", 4],
  ["96", "Primed Target Cracker", [["1", 10]], Secondary, "r", "l", 4, 10],
  ["97", "Hydraulic Crosshairs", [["onHeadshot"], ["0", 22.5]], Secondary, "r", "n", 2],
  ["98", "Embedded Catalyzer", [["onAbilityCast"], ["2", 15]], Secondary, "r", "c", 4],
  ["99", "Pressurized Magazine", [["onReload"], ["R", 15]], Secondary, "r", "r", 4],
  ["9A", "Targeting Subsystem", [["onHit"], ["acc", 5]], Secondary, "r", "c", 2],
  ["9B", "Sharpened Bullets", [["onKill"], ["1", 12.5]], Secondary, "r", "c", 2],
  ["9C", "No Return", [["9", 10]], Secondary, "-", "c", 2],
  ["9D", "Bore", [["9", 20]], Secondary, "-", "r", 6],
  ["9E", "Razor Shot", [["A", 10]], Secondary, "-", "c", 2],
  ["9F", "Maim", [["A", 20]], Secondary, "-", "r", 6],
  ["9G", "Concussion Rounds", [["8", 10]], Secondary, "-", "c", 2],
  ["9H", "Pummel", [["8", 20]], Secondary, "-", "r", 6],
  ["9I", "Heated Charge", [["4", 15]], Secondary, "-", "c", 6],
  ["9J", "Primed Heated Charge", [["4", 15]], Secondary, "-", "l", 6, 10],
  ["9K", "Convulsion", [["7", 15]], Secondary, "-", "c", 6],
  ["9L", "Deep Freeze", [["5", 15]], Secondary, "d", "c", 6],
  ["9M", "Pathogen Rounds", [["6", 15]], Secondary, "-", "c", 6],
  ["9N", "Pistol Pestilence", [["6", 15], ["2", 15]], Secondary, "r", "r", 4, 3],
  ["9O", "Jolt", [["7", 15], ["2", 15]], Secondary, "r", "r", 4, 3],
  ["9P", "Scorch", [["4", 15], ["2", 15]], Secondary, "r", "r", 4, 3],
  ["9Q", "Frostbite", [["5", 15], ["2", 15]], Secondary, "r", "r", 4, 3],
  ["9R", "Ice Storm", [["L", 10], ["5", 10]], Secondary, "r", "r", 6, 3],
  ["9S", "Creeping Bullseye", [["0", 200 / 6], ["R", -20 / 6]], Secondary, "-", "r", 4],
  ["9T", "Expel Corpus", [["C", 5]], Secondary, "r", "c", 4],
  ["9U", "Expel Grineer", [["G", 5]], Secondary, "r", "c", 4],
  ["9V", "Expel Infested", [["I", 5]], Secondary, "r", "c", 4],
  ["9W", "Expel Corrupted", [["od", 5]], Secondary, "r", "c", 4],
  ["9X", "Anemic Agility", [["R", 15], ["D", -2.5]], Secondary, "-", "r", 4],
  ["9Y", "Gunslinger", [["R", 12]], Secondary, "r", "c", 4],
  ["9Z", "Hawk Eye", [["H", 20]], Secondary, "-", "c", 4, 3],
  ["9a", "Hollow Point", [["1", 10], ["D", -2.5]], Secondary, "-", "r", 4],
  ["9b", "Magnum Force", [["D", 15], ["acc", -5]], Secondary, "r", "r", 4, 10],
  ["9c", "Quickdraw", [["F", 8]], Secondary, "-", "n", 2],
  ["9d", "Primed Quickdraw", [["F", 8]], Secondary, "-", "l", 2, 10],
  ["9e", "Seeker", [["P", 0.4]], Secondary, "-", "r", 10],
  ["9f", "Slip Magazine", [["L", 5]], Secondary, "-", "n", 4],
  ["9g", "Primed Slip Magazine", [["L", 5]], Secondary, "-", "l", 4, 10],
  ["9h", "Steady Hands", [["Z", -15]], Secondary, "-", "r", 6, 3],
  ["9i", "Stunning Speed", [["F", 10], ["2", 7.5]], Secondary, "-", "r", 6, 3],
  ["9j", "Suppress", [["slc", 25]], Secondary, "-", "n", 2, 3],
  ["9k", "Sure Shot", [["2", 15]], Secondary, "d", "c", 2],
  ["9l", "Tainted Clip", [["L", 10], ["F", -5]], Secondary, "-", "r", 6],
  ["9m", "Trick Mag", [["M", 15]], Secondary, "-", "n", 2],
  ["9n", "Pistol Ammo Mutation", [["am", 37.5]], Secondary, "-", "r", 4],
  ["9o", "Primed Pistol Ammo Mutation", [["am", 68.75]], Secondary, "-", "l", 4, 10],
  ["9p", "Ruinous Extension", [["ar", 2]], Secondary, "-", "c", 2, 3],
  ["9q", "Eroding Blight", [["L", 50], ["vb", 0.3]], "Embolist", "d", "r", 4, 3],
  ["9r", "Stockpiled Blight", [["L", 50], ["vb", 0.3]], "Kunai", "d", "r", 4, 3],
  ["9s", "Entropy Spike", [["exp", 5], ["ve", 0.3]], "Bolto", "-", "r", 4, 3],
  ["9t", "Sequence Burn", [["ar", 5], ["vs", 0.3]], "Spectra", "-", "r", 4, 3],
  ["9u", "Toxic Sequence", [["3", 50], ["vs", 0.3]], "Acrid", "d", "r", 4, 3],
  ["9v", "Winds of Purity", [["ls", 5], ["vp", 0.3]], "Furis", "d", "r", 4, 3],
  ["9w", "Stinging Truth", [["bL", 10], ["vt", 0.3]], "Viper", "d", "r", 4, 3],
  ["9x", "Augur Pact", [["D", 15]], Secondary, "-", "n", 2],
  ["9y", "Primed Expel Corpus", [["C", 5]], Secondary, "r", "l", 4, 10],
  ["9z", "Primed Expel Grineer", [["G", 5]], Secondary, "r", "l", 4, 10],
  ["A0", "Primed Expel Infested", [["I", 5]], Secondary, "r", "l", 4, 10],
  ["A1", "Primed Expel Corrupted", [["od", 5]], Secondary, "r", "l", 4, 10],
  ["A2", "Concealed Explosives", [["exp", 20]], "Thrown", "r", "r", 6, 3],
  ["A3", "Lethal Momentum", [["V", 10]], Secondary, "r", "c", 4, 3],
  ["A4", "Augur Seeker", [["3", 5]], Secondary, "r", "r", 2, 5],
  ["A5", "Perpetual Agony", [["3", 5]], Secondary, "r", "n", 6],
  ["A6", "Thermagnetic Shells", [["-"]], "Detron", "-", "r", 2, 3],
  ["A7", "Fulmination", [["brad", 6]], Secondary, "r", "r", 6, 3],
  ["A8", "Synth Charge", [["lsb", 50]], Secondary, "r", "r", 6, 3],
  ["A9", "Amalgam Barrel Diffusion", [["S", 18], ["!S", 2], ["dgs", 10]], Secondary, "r", "g", 10],
  ["Aa", "Galvanized Diffusion", [["S", 110 / 11], ["onKill"], ["S", 120 / 11]], Secondary, "r", "r", 4, 10],
  ["Ab", "Galvanized Crosshairs", [["onHeadshot"], ["0", 120 / 11], ["onHeadshotKill"], ["0", 200 / 11]], Secondary, "r", "r", 2, 10],
  ["Ac", "Galvanized Shot", [["2", 80 / 11], ["onKill"], ["ga", 120 / 11]], Secondary, "d", "r", 2, 10],
  ["Ad", "Deadly Maneuvers", [["e0", 100]], "Magnus", "-", "r", 4, 3],
  ["Ae", "Dizzying Rounds", [["2", 50]], "Bronco", "-", "r", 4, 3],

  // 近战 C0 ~ Fz
  ["C0", "Pressure Point", [["K", 20]], Melee, "r", "n", 4],
  ["C1", "Primed Pressure Point", [["K", 15]], Melee, "r", "l", 4, 10],
  ["C2", "Spoiled Strike", [["K", 25], ["J", -5]], Melee, "r", "r", 4, 3],
  ["C3", "Reach", [["T", 1.1 / 4]], Melee, "r", "n", 4, 3],
  ["C4", "Primed Reach", [["T", 3 / 11]], Melee, "r", "l", 4, 10],
  ["C5", "Maiming Strike", [["E", 25]], Melee, "r", "r", 2],
  ["C6", "Blood Rush", [["bldr", 40 / 11]], Melee, "r", "c", 4, 10],
  ["C7", "Body Count", [["N", 2]], Melee, "-", "n", 4],
  ["C8", "Weeping Wounds", [["sccm", 40 / 6]], Melee, "r", "c", 4],
  ["C9", "Relentless Combination", [["ccws", 25]], Melee, "-", "c", 6, 3],
  ["CA", "Berserker Fury", [["!bsk", 70]], Melee, "r", "r", 4],
  ["CB", "Fury", [["J", 5]], Melee, "r", "c", 4],
  ["CC", "True Steel", [["0", 20]], Melee, "r", "n", 4],
  ["CD", "Sacrificial Steel", [["0", 20], ["smd", 3]], Melee, "w", "l", 6, 10],
  ["CE", "Organ Shatter", [["1", 15]], Melee, "r", "n", 4],
  ["CF", "Heavy Trauma", [["8", 15]], Melee, "-", "r", 2],
  ["CG", "Collision Force", [["8", 20]], Melee, "-", "r", 6],
  ["CH", "Primed Heavy Trauma", [["8", 15]], Melee, "-", "l", 2, 10],
  ["CI", "Sundering Strike", [["9", 15]], Melee, "-", "r", 2],
  ["CJ", "Auger Strike", [["9", 20]], Melee, "-", "r", 6],
  ["CK", "Jagged Edge", [["A", 15]], Melee, "-", "r", 2],
  ["CL", "Buzz Kill", [["A", 20]], Melee, "-", "r", 6],
  ["CM", "Fever Strike", [["6", 15]], Melee, "-", "c", 6],
  ["CN", "Primed Fever Strike", [["6", 15]], Melee, "-", "l", 6, 10],
  ["CO", "Molten Impact", [["4", 15]], Melee, "-", "c", 6],
  ["CP", "North Wind", [["5", 15]], Melee, "d", "c", 6],
  ["CQ", "Shocking Touch", [["7", 15]], Melee, "-", "c", 6],
  ["CR", "Vicious Frost", [["5", 15], ["2", 15]], Melee, "r", "r", 4, 3],
  ["CS", "Virulent Scourge", [["6", 15], ["2", 15]], Melee, "r", "r", 4, 3],
  ["CT", "Volcanic Edge", [["4", 15], ["2", 15]], Melee, "r", "r", 4, 3],
  ["CU", "Voltaic Strike", [["7", 15], ["2", 15]], Melee, "r", "r", 4, 3],
  ["CV", "Finishing Touch", [["X", 15]], Melee, "r", "c", 2, 3],
  ["CW", "Corrupt Charge", [["B", 7.5], ["rN", -12.5]], Melee, "r", "r", 4, 3],
  ["CX", "Dispatch Overdrive", [["onHeavyAttackHit"], ["ckm", 10]], Melee, "-", "c", 4],
  ["CY", "Drifting Contact", [["N", 2.5], ["2", 10]], Melee, "d", "r", 2, 3],
  ["CZ", "Condition Overload", [["co", 80 / 6]], Melee, "r", "r", 10],
  ["Ca", "Guardian Derision", [["!gdr", 15]], Melee, "d", "r", 6],
  ["Cb", "Healing Return", [["hlr", 1]], Melee, "d", "r", 6, 10],
  ["Cc", "Energy Channel", [["exd", 50]], Melee, "r", "r", 4, 3],
  ["Cd", "Enduring Affliction", [["3", 25]], Melee, "d", "c", 4],
  ["Ce", "Enduring Strike", [["onMeleeLift"], ["O", 5]], Melee, "=", "n", 4, 3],
  ["Cf", "Focus Energy", [["U", 10], ["7", 15]], Melee, "r", "r", 6, 3],
  ["Cg", "Focused Defense", [["apc", 5]], Melee, "d", "n", 4, 3],
  ["Ch", "Life Strike", [["ls", 5]], Melee, "d", "r", 4, 3],
  ["Ci", "Primed Fury", [["J", 5]], Melee, "r", "l", 4, 10],
  ["Cj", "Killing Blow", [["hd", 20], ["wu", 10]], Melee, "r", "c", 6],
  ["Ck", "Lasting Sting", [["3", 10]], Melee, "r", "n", 6, 10],
  ["Cl", "Melee Prowess", [["2", 15]], Melee, "d", "n", 2],
  ["Cm", "Parry", [["cc", 16]], Melee, "d", "n", 2],
  ["Cn", "Quickening", [["J", 10], ["U", 5]], Melee, "r", "r", 6, 3],
  ["Co", "Reflex Coil", [["U", 10]], Melee, "-", "c", 2],
  ["Cp", "Rending Strike", [["A", 15], ["9", 20]], Melee, "-", "r", 6, 3],
  ["Cq", "Smite Corpus", [["C", 5]], Melee, "r", "c", 4],
  ["Cr", "Smite Grineer", [["G", 5]], Melee, "r", "c", 4],
  ["Cs", "Smite Infested", [["I", 5]], Melee, "r", "c", 4],
  ["Ct", "Smite Corrupted", [["od", 5]], Melee, "r", "c", 4],
  ["Cu", "Seismic Wave", [["msd", 50]], Melee, "r", "c", 6, 3],
  ["Cv", "True Punishment", [["O", 25], ["N", -0.5]], Melee, "=", "n", 4, 3],
  ["Cw", "Power Throw", [["P", 0.1]], "Glaive", "r", "r", 4],
  ["Cx", "Quick Return", [["bnc", -1]], "Glaive", "-", "n", 4, 3],
  ["Cy", "Rebound", [["bnc", 1]], "Glaive", "-", "n", 4, 3],
  ["Cz", "Whirlwind", [["V", 30]], "Glaive", "r", "r", 4],
  ["D0", "Gladiator Rush", [["N", 1]], Melee, "-", "n", 4],
  ["D1", "Gladiator Vice", [["J", 5]], Melee, "r", "r", 4],
  ["D2", "Gladiator Might", [["1", 10]], Melee, "r", "c", 4],
  ["D3", "Justice Blades", [["K", 25], ["vj", 0.3]], "Dual Cleavers", "-", "r", 4, 3],
  ["D4", "Blade of Truth", [["K", 25], ["vt", 0.3]], "Jaw Sword", "r", "r", 4, 3],
  ["D5", "Gleaming Blight", [["2", 25], ["vb", 0.3]], "Dark Dagger", "-", "r", 4, 3],
  ["D6", "Toxic Blight", [["6", 25], ["vb", 0.3]], "Mire", "r", "r", 4, 3],
  ["D7", "Entropy Flight", [["V", 35], ["ve", 0.3]], "Kestrel", "-", "r", 4, 3],
  ["D8", "Entropy Detonation", [["kbr", 5], ["ve", 0.3]], "Obex", "-", "r", 4, 3],
  ["D9", "Bright Purity", [["K", 25], ["vp", 0.3]], "Skana", "r", "r", 4, 3],
  ["DA", "Avenging Truth", [["-"], ["vt", 0.3]], "Silva & Aegis", "r", "r", 4, 3,],
  ["DB", "Electromagnetic Shielding", [["While blocking, redirect 25% of damage taken by allies within 2m to yourself."]], "Ack & Brunt", "d", "c", 4],
  ["DC", "Rift Strike", [["Charge attacks now step through the rift to attack enemies up to 5m away"]], "Twin Basolk", "-", "c", 2],
  ["DD", "Sacrificial Pressure", [["K", 10], ["smd", 3]], Melee, "w", "l", 6, 10],
  ["DE", "Covert Lethality", [["ld", 25]], "Dagger", "r", "r", 10, 3],
  ["DF", "Shattering Impact", [["si", 1]], Melee, "d", "n", 4],
  ["DG", "Hunter's Bonesaw", [["-"]], "Ripkas", "r", "c", 2],
  ["DH", "Vulcan Blitz", [["-"]], "Jat Kittag", "r", "c", 4],
  ["DI", "Static Discharge", [["-"]], "Prova", "-", "r", 2],
  ["DJ", "Spring-Loaded Blade", [["rse", 2]], Melee, "d", "r", 4],
  ["DK", "Tek Gravity", [["-"]], Melee, "r", "r", 6, 3],
  ["DL", "Strain Infection", [["-"]], Melee, "r", "r", 6, 3],
  ["DM", "Amalgam Organ Shatter", [["1", 14], ["!1", 1], ["fca", 10]], Melee, "r", "g", 6],
  ["DN", "Proton Snap", [["-"]], Melee, "r", "r", 6, 3],
  ["DO", "Motus Impact", [["-"]], Melee, "r", "c", 4, 3],
  ["DP", "Amalgam Ripkas True Steel", [["0", 26], ["..."]], "Ripkas", "r", "r", 6],
  ["DQ", "Amalgam Furax Body Count", [["N", 2.5], ["brad", 3]], "Furax", "-", "r", 6],
  ["DR", "Primed Smite Corpus", [["C", 5]], Melee, "r", "l", 4, 10],
  ["DS", "Primed Smite Grineer", [["G", 5]], Melee, "r", "l", 4, 10],
  ["DT", "Primed Smite Infested", [["I", 5]], Melee, "r", "l", 4, 10],
  ["DU", "Primed Smite Corrupted", [["od", 5]], Melee, "r", "l", 4, 10],
  // 战甲 G0 ~ Nz
  // 光环
  ["G0", "Growing Power", [["t", 25.5 / 6]], Aura, "r", "r", -2],
  ["G1", "Pistol Amp", [["D", 4.5]], Aura, "r", "c", -2],
  ["G2", "Rifle Amp", [["D", 4.5]], Aura, "r", "c", -2],
  ["G3", "Dead Eye", [["D", 8.8]], Aura, "r", "c", -2],
  ["G4", "Power Donation", [["t", -5], ["tt", 5]], Aura, "r", "r", -4],
  ["G5", "Steel Charge", [["K", 10]], Aura, "r", "c", -4],
  ["G6", "Shotgun Amp", [["D", 3]], Aura, "r", "c", -2],
  ["G7", "Physique", [["h", 15]], Aura, "d", "c", -2],
  ["G8", "Stand United", [["a", 4.3]], Aura, "d", "c", -2],
  ["G9", "Infested Impedance", [["esp", -3]], Aura, "d", "c", -2],
  ["GA", "Toxin Resistance", [["pr", 2.5]], Aura, "d", "c", -2],
  ["GB", "EMP Aura", [["eac", -2.5]], Aura, "d", "c", -2],
  ["GC", "Rejuvenation", [["hps", 0.5]], Aura, "d", "c", -2],
  ["GD", "Enemy Radar", [["er", 5]], Aura, "-", "c", -2],
  ["GE", "Sprint Boost", [["f", 2.5]], Aura, "-", "c", -2],
  ["GF", "Empowered Blades", [["-"]], Aura, "-", "r", -2],
  ["GG", "Speed Holster", [["hr", 20]], Aura, "-", "c", -2],
  ["GH", "Loot Detector", [["lr", 5]], Aura, "-", "c", -2],
  ["GI", "Pistol Scavenger", [["ap", 25]], Aura, "-", "c", -2],
  ["GJ", "Shield Disruption", [["ens", -3]], Aura, "-", "c", -2],
  ["GK", "Mecha Empowered", [["edm", 25]], Aura, "-", "r", -2],
  ["GL", "Rifle Scavenger", [["ap", 25]], Aura, "-", "c", -2],
  ["GM", "Sniper Scavenger", [["ap", 25]], Aura, "-", "c", -2],
  ["GN", "Energy Siphon", [["es", 0.1]], Aura, "-", "c", -2],
  ["GO", "Corrosive Projection", [["ena", -3]], Aura, "-", "c", -2],
  ["GP", "Shotgun Scavenger", [["ap", 25]], Aura, "-", "c", -2],
  ["GQ", "Brief Respite", [["onAbilityCast"], ["Converts 25% of Energy spent to Shields while Overshields are inactive."]], Aura, "=", "c", -2],
  ["GR", "Shepherd", [["-eh", 50], ["-ea", 30]], Aura, "-", "r", -2],
  ["GS", "Combat Discipline", [], Aura, "-", "r", -2],
  ["GT", "Melee Guidance", [["N", -1], ["+N", 2]], Aura, "-", "r", -2],
  ["GU", "Swift Momentum", [["ca", 5], ["N", 6]], Aura, "-", "r", -2],
  ["GV", "Aerodynamic", [["adr", 4]], Aura, "-", "r", -2],

  // 战甲
  ["Gl", "Intensify", [["t", 5]], Warframe, "r", "r", 6],
  ["Gm", "Stretch", [["g", 7.5]], Warframe, "-", "c", 4],
  ["Gn", "Streamline", [["x", 5]], Warframe, "-", "r", 4],
  ["Go", "Continuity", [["u", 5]], Warframe, "r", "r", 4],
  ["Gp", "Primed Continuity", [["u", 5]], Warframe, "r", "l", 4, 10],
  ["Gq", "Flow", [["e", 25]], Warframe, "-", "r", 4],
  ["Gr", "Primed Flow", [["e", 25]], Warframe, "-", "l", 4, 10],
  ["Gs", "Blind Rage", [["t", 9], ["x", -5]], Warframe, "r", "r", 6, 10],
  ["Gt", "Fleeting Expertise", [["x", 10], ["u", -10]], Warframe, "-", "r", 6],
  ["Gu", "Narrow Minded", [["u", 9], ["g", -6]], Warframe, "d", "r", 6, 10],
  ["Gv", "Overextended", [["g", 15], ["t", -10]], Warframe, "d", "r", 6],
  ["Gw", "Transient Fortitude", [["t", 5], ["u", -2.5]], Warframe, "r", "r", 6, 10],
  ["Gx", "Vitality", [["h", 40]], Warframe, "d", "n", 2, 10],
  ["Gy", "Redirection", [["s", 40]], Warframe, "d", "n", 4, 10],
  ["Gz", "Steel Fiber", [["a", 10]], Warframe, "d", "n", 4, 10],
  ["H0", "Fortitude", [["k", 5], ["r", 20]], Warframe, "-", "r", 6, 3],
  ["H1", "Vigor", [["s", 20], ["h", 20]], Warframe, "d", "r", 6],
  ["H2", "Primed Vigor", [["s", 20], ["h", 20]], Warframe, "d", "l", 6, 10],
  ["H3", "Armored Agility", [["f", 2.5], ["a", 7.5]], Warframe, "d", "r", 6],
  ["H4", "Constitution", [["y", 10], ["u", 7]], Warframe, "-", "r", 10, 3],
  ["H5", "Quick Thinking", [["z", 40]], Warframe, "d", "r", 10],
  ["H6", "Rage", [["rg", 10]], Warframe, "r", "r", 6, 3],
  ["H8", "Insulation", [["cr", 10]], Warframe, "d", "n", 4],
  ["H9", "Flame Repellent", [["fr", 10]], Warframe, "d", "n", 4],
  ["HA", "Lightning Rod", [["ir", 10]], Warframe, "d", "n", 4],
  ["HB", "Antitoxin", [["pr", 7.5]], Warframe, "d", "c", 4],
  ["HC", "Diamond Skin", [["rr", 7.5]], Warframe, "d", "c", 4],
  ["HD", "Rapid Resilience", [["sds", -12.5]], Warframe, "d", "r", 6],
  ["HE", "Health Conversion", [["hc", 75]], Warframe, "d", "r", 10],
  ["HF", "Energy Conversion", [["ec", 50 / 6]], Warframe, "r", "r", 10],
  ["HG", "Equilibrium", [["eq", 10]], Warframe, "-", "c", 4, 10],
  ["HH", "Fast Deflection", [["r", 15]], Warframe, "d", "c", 4],
  ["HI", "Provoked", [["ddb", 10]], Warframe, "r", "c", 4, 10],
  ["HJ", "Undying Will", [["br", 7]], Warframe, "d", "r", 2],
  ["HK", "Reflex Guard", [["ccb", 100 / 11]], Warframe, "d", "r", 4, 10],
  ["HL", "Vigorous Swap", [["onEquip"], ["dmg", 15], ["hr", 9], ["!hr", 1]], Warframe, "-", "r", 2, 10],
  ["HM", "Rolling Guard", [["onDodge"], ["ivc", 2], ["cold", 12]], Warframe, "d", "r", 2, 10],
  ["HN", "Adaptation", [["!res", 90]], Warframe, "d", "r", 2, 10],
  ["HO", "Natural Talent", [["c", 12.5]], Warframe, "-", "r", 6, 3],
  ["HP", "Reflection", [["ref", 16]], Warframe, "d", "n", 2],
  ["HQ", "Gale Kick", [["+25% of Melee Damage converted to Impact Damage on Jump Kick, knocking down nearby enemies on kill."]], Warframe, "r", "r", 4, 3],
  ["HR", "Kavat's Grace", [["Resist Hard Landings from falling at speeds of up to 25m/s."]], Warframe, "-", "r", 4, 3],
  ["HS", "Proton Pulse", [["Wall Dashing grants +25% Bullet Jump Speed."]], Warframe, "-", "n", 4, 3],
  ["HT", "Motus Signal", [["Increase Double Jump strength by +50%."]], Warframe, "-", "n", 4, 3],
  ["HU", "Aero Vantage", [["+25% Reduced Gravity during Aim Glide"]], Warframe, "-", "c", 4, 3],

  // 组合
  ["Ha", "Umbral Vitality", [["h", 40], ["tr", 1]], Warframe, "w", "l", 6, 10],
  ["Hb", "Umbral Fiber", [["a", 10], ["tr", 1]], Warframe, "w", "l", 6, 10],
  ["Hc", "Umbral Intensify", [["t", 4], ["tr", 1]], Warframe, "w", "l", 6, 10],
  ["Hd", "Augur Accord", [["s", 30]], Warframe, "d", "c", 2],
  ["He", "Augur Message", [["u", 4]], Warframe, "-", "n", 2],
  ["Hf", "Augur Reach", [["g", 5]], Warframe, "-", "c", 2],
  ["Hg", "Augur Secrets", [["t", 4]], Warframe, "-", "r", 2],
  ["Hh", "Gladiator Aegis", [["a", 7.5]], Warframe, "d", "n", 4],
  ["Hi", "Gladiator Finesse", [["z", 10]], Warframe, "d", "r", 4],
  ["Hj", "Gladiator Resolve", [["h", 30]], Warframe, "d", "c", 4],
  ["Hk", "Hunter Adrenaline", [["rg", 7.5]], Warframe, "r", "n", 6],
  ["Hl", "Vigilante Pursuit", [["er", 5]], Exilus, "-", "c", 4],
  ["Hm", "Vigilante Vigor", [["r", 10]], Warframe, "d", "n", 4],
  ["Hn", "Tek Collateral", [["+25% Critical Damage when inside the Marked Zone."]], Warframe, "-", "r", 2, 3],
  ["Ho", "Mecha Pulse", [["Killing a Marked Enemy grants +15% Armor for 5s for each enemy within 7.5m."]], Warframe, "r", "r", 6, 3],
  ["Hp", "Synth Reflex", [["hr", 25]], Exilus, "r", "r", 4, 3],
  ["Hq", "Strain Consume", [["Dead maggots within 5m are consumed, restoring 1% Missing Health."]], Warframe, "-", "r", 2, 3],
  ["Hr", "Carnis Carapace", [["a", 10], ["h", 15]], Warframe, "d", "c", 4],
  ["Hs", "Carnis Mandible", [["A", 15], ["2", 10]], Melee, "-", "n", 4],
  ["Ht", "Carnis Stinger", [["A", 15], ["2", 10]], Secondary, "-", "r", 4],
  ["Hu", "Jugulus Carapace", [["a", 10], ["h", 15]], Warframe, "d", "c", 4],
  ["Hv", "Jugulus Barbs", [["9", 15], ["2", 10]], Melee, "-", "n", 4],
  ["Hw", "Jugulus Spines", [["9", 15], ["2", 10]], Secondary, "-", "r", 4],
  ["Hx", "Saxum Carapace", [["a", 10], ["h", 15]], Warframe, "d", "c", 4],
  ["Hy", "Saxum Thorax", [["8", 15], ["2", 10]], Melee, "-", "n", 4],
  ["Hz", "Saxum Spittle", [["8", 15], ["2", 10]], Secondary, "-", "r", 4],

  // 特殊功能
  ["I7", "Agility Drift", [["adr", 2], ["ev", 1]], Exilus, "d", "r", 4],
  ["I8", "Coaction Drift", [["as", 2.5], ["ae", 2.5]], Exilus, "-", "r", 4],
  ["I9", "Cunning Drift", [["l", 2], ["i", -5], ["g", 2.5]], Exilus, "r", "r", 4],
  ["IA", "Endurance Drift", [["e", 2.5], ["at", 2]], Exilus, "=", "r", 4],
  ["IB", "Power Drift", [["t", 2.5], ["k", 5]], Exilus, "=", "r", 4],
  ["IC", "Speed Drift", [["f", 2], ["c", 2.5]], Exilus, "r", "r", 4],
  ["ID", "Stealth Drift", [["er", 3], ["at", 2]], Exilus, "-", "r", 4],
  ["IE", "Battering Maneuver", [["v", 3], ["at", 3], ["+10% Impact on Bullet Jump"]], Exilus, "d", "c", 4],
  ["IF", "Piercing Step", [["v", 3], ["at", 3], ["+10% Puncture on Bullet Jump"]], Exilus, "-", "c", 4],
  ["IG", "Rending Turn", [["v", 3], ["at", 3], ["+10% Slash on Bullet Jump"]], Exilus, "r", "c", 4],
  ["IH", "Firewalker", [["v", 2.2], ["at", 2.2], ["+25% Heat on Bullet Jump"]], Exilus, "r", "r", 2, 10],
  ["II", "Ice Spring", [["v", 2.2], ["at", 2.2], ["+25% Cold on Bullet Jump"]], Exilus, "d", "r", 2, 10],
  ["IJ", "Lightning Dash", [["v", 2.2], ["at", 2.2], ["+25% Electricity on Bullet Jump"]], Exilus, "r", "r", 2, 10],
  ["IK", "Toxic Flight", [["v", 2.2], ["at", 2.2], ["+25% Toxin on Bullet Jump"]], Exilus, "-", "r", 2, 10],
  ["IL", "Maglev", [["l", 5], ["i", -5]], Exilus, "-", "c", 6],
  ["IM", "Mobilize", [["v", 5], ["at", 5]], Exilus, "-", "c", 2, 3],
  ["IN", "Patagium", [["at", 15]], Exilus, "-", "c", 2],
  ["IO", "Rush", [["f", 5]], Exilus, "-", "c", 6],
  ["IP", "Streamlined Form", [["hr", 10], ["l", 2.5], ["i", -2.5]], Exilus, "-", "r", 2],
  ["IQ", "Aviator", [["adr", 10]], Exilus, "d", "n", 4, 3],
  ["IR", "Shock Absorbers", [["drk", 5]], Exilus, "d", "r", 4, 3],
  ["IS", "Sure Footed", [["k", 15]], Exilus, "d", "r", 6, 3],
  ["IT", "Primed Sure Footed", [["k", 9]], Exilus, "d", "l", 6, 10],
  ["IU", "Warm Coat", [["wc", 3]], Exilus, "d", "n", 6, 3],
  ["IV", "Enemy Sense", [["er", 5]], Exilus, "-", "r", 4],
  ["IW", "Handspring", [["y", 40]], Exilus, "-", "r", 6, 3],
  ["IX", "Heavy Impact", [["Create 1m seismic shockwaves from heavy landings, dealing 50 Damage and knocking foes off their feet."]], Exilus, "-", "c", 4],
  ["IY", "Intruder", [["+1s to Hacking"]], Exilus, "-", "n", 2],
  ["IZ", "Master Thief", [["ll", 10]], Exilus, "-", "r", 10, 3],
  ["Ia", "Pain Threshold", [["sr", 40]], Exilus, "-", "r", 6, 3],
  ["Ib", "Peculiar Bloom", [["Critical hits cause flowers to grow from the wounds."]], Exilus, "-", "c", 2],
  ["Ic", "Peculiar Growth", [["Damaging an enemy will inflate the body part hit for 1s."]], Exilus, "-", "c", 2],
  ["Id", "Retribution", [["+15% Chance to deal Electrical Damage when shield struck by melee enemies."], ["7", 20]], Exilus, "d", "r", 6, 3],
  ["Ie", "Thief's Wit", [["lr", 7]], Exilus, "-", "n", 2],

  // 技能强化
  ["JX", "Seeking Shuriken", [["Shuriken Augment"]], "Ash", "=", "r", 6, 3],
  ["JY", "Smoke Shadow", [["Smoke Screen Augment"]], "Ash", "=", "r", 6, 3],
  ["JZ", "Fatal Teleport", [["Teleport Augment"]], "Ash", "=", "r", 6, 3],
  ["Ja", "Rising Storm", [["Blade Storm Augment"]], "Ash", "=", "r", 6, 3],
  ["Jb", "Path of Statues", [["Landslide Augment"]], "Atlas", "=", "r", 6, 3],
  ["Jc", "Titanic Rumbler", [["Rumblers Augment"]], "Atlas", "=", "r", 6, 3],
  ["Jd", "Tectonic Fracture", [["Tectonics Augment"]], "Atlas", "=", "r", 6, 3],
  ["Je", "Ore Gaze", [["Petrify Augment"]], "Atlas", "=", "r", 6, 3],
  ["Jf", "Resonance", [["Sonar Augment"]], "Banshee", "=", "r", 6, 3],
  ["Jg", "Savage Silence", [["Silence Augment"]], "Banshee", "=", "r", 6, 3],
  ["Jh", "Sonic Fracture", [["Sonic Boom Augment"]], "Banshee", "=", "r", 6, 3],
  ["Ji", "Resonating Quake", [["Sound Quake Augment"]], "Banshee", "=", "r", 6, 3],
  ["Jj", "Guided Effigy", [["Effigy Augment"]], "Chroma", "=", "r", 6, 3],
  ["Jk", "Vexing Retaliation", [["Vex Armor Augment"]], "Chroma", "=", "r", 6, 3],
  ["Jl", "Everlasting Ward", [["Elemental Ward Augment"]], "Chroma", "=", "r", 6, 3],
  ["Jm", "Afterburn", [["Spectral Scream Augment"]], "Chroma", "=", "r", 6, 3],
  ["Jn", "Fire Fright", [["Fire Blast Augment"]], "Ember", "=", "r", 6, 3],
  ["Jo", "Firequake", [["World On Fire Augment"]], "Ember", "=", "r", 6, 3],
  ["Jp", "Fireball Frenzy", [["Fireball Augment"]], "Ember", "=", "r", 6, 3],
  ["Jq", "Flash Accelerant", [["Accelerant Augment"]], "Ember", "=", "r", 6, 3],
  ["Jr", "Duality", [["Metamorphosis Augment"]], "Equinox", "=", "r", 6, 3],
  ["Js", "Calm & Frenzy", [["Rest & Rage Augment"]], "Equinox", "=", "r", 6, 3],
  ["Jt", "Peaceful Provocation", [["Pacify & Provoke Augment"]], "Equinox", "=", "r", 6, 3],
  ["Ju", "Energy Transfer", [["Mend & Maim Augment"]], "Equinox", "=", "r", 6, 3],
  ["Jv", "Chromatic Blade", [["Exalted Blade Augment"]], "Excalibur", "=", "r", 6, 3],
  ["Jw", "Surging Dash", [["Slash Dash Augment"]], "Excalibur", "=", "r", 6, 3],
  ["Jx", "Furious Javelin", [["Radial Javelin Augment"]], "Excalibur", "=", "r", 6, 3],
  ["Jy", "Radiant Finish", [["Radial Blind Augment"]], "Excalibur", "=", "r", 6, 3],
  ["Jz", "Icy Avalanche", [["Avalanche Augment"]], "Frost", "=", "r", 6, 3],
  ["K0", "Chilling Globe", [["Snow Globe Augment"]], "Frost", "=", "r", 6, 3],
  ["K1", "Freeze Force", [["Freeze Augment"]], "Frost", "=", "r", 6, 3],
  ["K2", "Ice Wave Impedance", [["Ice Wave Augment"]], "Frost", "=", "r", 6, 3],
  ["K3", "Mending Splinters", [["Splinter Storm Augment"]], "Gara", "=", "r", 6, 3],
  ["K4", "Warding Thurible", [["Thurible Augment"]], "Harrow", "=", "r", 6, 3],
  ["K5", "Lasting Covenant", [["Covenant Augment"]], "Harrow", "=", "r", 6, 3],
  ["K6", "Tidal Impunity", [["Tidal Surge Augment"]], "Hydroid", "=", "r", 6, 3],
  ["K7", "Curative Undertow", [["Undertow Augment"]], "Hydroid", "=", "r", 6, 3],
  ["K8", "Corroding Barrage", [["Tempest Barrage Augment"]], "Hydroid", "=", "r", 6, 3],
  ["K9", "Pilfering Swarm", [["Tentacle Swarm Augment"]], "Hydroid", "=", "r", 6, 3],
  ["KA", "Elemental Sandstorm", [["Sandstorm Augment"]], "Inaros", "=", "r", 6, 3],
  ["KB", "Negation Swarm", [["Scarab Swarm Augment"]], "Inaros", "=", "r", 6, 3],
  ["KC", "Empowered Quiver", [["Quiver Augment"]], "Ivara", "=", "r", 6, 3],
  ["KD", "Infiltrate", [["Prowl Augment"]], "Ivara", "=", "r", 6, 3],
  ["KE", "Piercing Navigator", [["Navigator Augment"]], "Ivara", "=", "r", 6, 3],
  ["KF", "Concentrated Arrow", [["Artemis Bow Augment"]], "Ivara", "=", "r", 6, 3],
  ["KG", "Accumulating Whipclaw", [["Whipclaw Augment"]], "Khora", "=", "r", 6, 3],
  ["KH", "Cataclysmic Continuum", [["Cataclysm Augment"]], "Limbo", "=", "r", 6, 3],
  ["KI", "Rift Torrent", [["Rift Surge Augment"]], "Limbo", "=", "r", 6, 3],
  ["KJ", "Rift Haven", [["Banish Augment"]], "Limbo", "=", "r", 6, 3],
  ["KK", "Safeguard Switch", [["Switch Teleport Augment"]], "Loki", "=", "r", 6, 3],
  ["KL", "Savior Decoy", [["Decoy Augment"]], "Loki", "=", "r", 6, 3],
  ["KM", "Irradiating Disarm", [["Radial Disarm Augment"]], "Loki", "=", "r", 6, 3],
  ["KN", "Hushed Invisibility", [["Invisibility Augment"]], "Loki", "=", "r", 6, 3],
  ["KO", "Counter Pulse", [["Polarize Augment"]], "Mag", "=", "r", 6, 3],
  ["KP", "Magnetized Discharge", [["Magnetize Augment"]], "Mag", "=", "r", 6, 3],
  ["KQ", "Greedy Pull", [["Pull Augment"]], "Mag", "=", "r", 6, 3],
  ["KR", "Fracturing Crush", [["Crush Augment"]], "Mag", "=", "r", 6, 3],
  ["KS", "Mesa's Waltz", [["Peacemaker Augment"]], "Mesa,Exilus", "=", "r", 6, 3],
  ["KT", "Staggering Shield", [["Shatter Shield Augment"]], "Mesa", "=", "r", 6, 3],
  ["KU", "Ballistic Bullseye", [["Ballistic Battery Augment"]], "Mesa", "=", "r", 6, 3],
  ["KV", "Muzzle Flash", [["Shooting Gallery Augment"]], "Mesa", "=", "r", 6, 3],
  ["KW", "Total Eclipse", [["Eclipse Augment"]], "Mirage", "=", "r", 6, 3],
  ["KX", "Hall of Malevolence", [["Hall of Mirrors Augment"]], "Mirage", "=", "r", 6, 3],
  ["KY", "Explosive Legerdemain", [["Sleight of Hand Augment"]], "Mirage", "=", "r", 6, 3],
  ["KZ", "Soul Survivor", [["Soul Punch Augment"]], "Nekros", "=", "r", 6, 3],
  ["Ka", "Shield of Shadows", [["Shadows of the Dead Augment"]], "Nekros", "=", "r", 6, 3],
  ["Kb", "Despoil", [["Desecrate Augment"]], "Nekros", "=", "r", 6, 3],
  ["Kc", "Creeping Terrify", [["Terrify Augment"]], "Nekros", "=", "r", 6, 3],
  ["Kd", "Reaping Chakram", [["Blazing Chakram Augment"]], "Nezha", "=", "r", 6, 3],
  ["Ke", "Pyroclastic Flow", [["Fire Walker Augment"]], "Nezha", "=", "r", 6, 3],
  ["Kf", "Safeguard", [["Warding Halo Augment"]], "Nezha", "=", "r", 6, 3],
  ["Kg", "Insatiable", [["Ravenous Augment"]], "Nidus", "=", "r", 6, 3],
  ["Kh", "Larva Burst", [["Larva Augment"]], "Nidus", "=", "r", 6, 3],
  ["Ki", "Neutron Star", [["Null Star Augment"]], "Nova", "=", "r", 6, 3],
  ["Kj", "Antimatter Absorb", [["Antimatter Drop Augment"]], "Nova", "=", "r", 6, 3],
  ["Kk", "Escape Velocity", [["Worm Hole Augment"]], "Nova,Exilus", "=", "r", 6, 3],
  ["Kl", "Assimilate", [["Absorb Augment"]], "Nyx", "=", "r", 6, 3],
  ["Km", "Pacifying Bolts", [["Psychic Bolts Augment"]], "Nyx", "=", "r", 6, 3],
  ["Kn", "Chaos Sphere", [["Chaos Augment"]], "Nyx", "=", "r", 6, 3],
  ["Ko", "Mind Freak", [["Mind Control Augment"]], "Nyx", "=", "r", 6, 3],
  ["Kp", "Phoenix Renewal", [["Renewal Augment"]], "Oberon", "=", "r", 6, 3],
  ["Kq", "Hallowed Eruption", [["Hallowed Ground Augment"]], "Oberon", "=", "r", 6, 3],
  ["Kr", "Smite Infusion", [["Smite Augment"]], "Oberon", "=", "r", 6, 3],
  ["Ks", "Hallowed Reckoning", [["Reckoning Augment"]], "Oberon", "=", "r", 6, 3],
  ["Kt", "Partitioned Mallet", [["Mallet Augment"]], "Octavia", "=", "r", 6, 3],
  ["Ku", "Conductor", [["Resonator Augment"]], "Octavia,Exilus", "=", "r", 6, 3],
  ["Kv", "Piercing Roar", [["Roar Augment"]], "Rhino", "=", "r", 6, 3],
  ["Kw", "Iron Shrapnel", [["Iron Skin Augment"]], "Rhino", "=", "r", 6, 3],
  ["Kx", "Reinforcing Stomp", [["Rhino Stomp Augment"]], "Rhino", "=", "r", 6, 3],
  ["Ky", "Ironclad Charge", [["Rhino Charge Augment"]], "Rhino", "=", "r", 6, 3],
  ["Kz", "Contagion Cloud", [["Toxic Lash Augment"]], "Saryn", "=", "r", 6, 3],
  ["L0", "Venom Dose", [["Spores Augment"]], "Saryn", "=", "r", 6, 3],
  ["L1", "Regenerative Molt", [["Molt Augment"]], "Saryn", "=", "r", 6, 3],
  ["L2", "Razorwing Blitz", [["Razorwing Augment"]], "Titania", "=", "r", 6, 3],
  ["L3", "Beguiling Lantern", [["Lantern Augment"]], "Titania", "=", "r", 6, 3],
  ["L4", "Vampire Leech", [["Energy Vampire Augment"]], "Trinity", "=", "r", 6, 3],
  ["L5", "Pool of Life", [["Well of Life Augment"]], "Trinity", "=", "r", 6, 3],
  ["L6", "Abating Link", [["Link Augment"]], "Trinity", "=", "r", 6, 3],
  ["L7", "Swing Line", [["Rip Line Augment"]], "Valkyr", "=", "r", 6, 3],
  ["L8", "Eternal War", [["Warcry Augment"]], "Valkyr", "=", "r", 6, 3],
  ["L9", "Hysterical Assault", [["Hysteria Augment"]], "Valkyr,Exilus", "=", "r", 6, 3],
  ["LA", "Prolonged Paralysis", [["Paralysis Augment"]], "Valkyr", "=", "r", 6, 3],
  ["LB", "Perpetual Vortex", [["Vortex Augment"]], "Vauban", "=", "r", 6, 3],
  ["LC", "Tesla Link", [["Tesla Augment"]], "Vauban", "=", "r", 6, 3],
  ["LD", "Repelling Bastille", [["Bastille Augment"]], "Vauban", "=", "r", 6, 3],
  ["LE", "Transistor Shield", [["Electric Shield Augment"]], "Volt", "=", "r", 6, 3],
  ["LF", "Shocking Speed", [["Speed Augment"]], "Volt", "=", "r", 6, 3],
  ["LG", "Shock Trooper", [["Shock Augment"]], "Volt", "=", "r", 6, 3],
  ["LH", "Capacitance", [["Discharge Augment"]], "Volt", "=", "r", 6, 3],
  ["LI", "Enveloping Cloud", [["Cloud Walker Augment"]], "Wukong", "=", "r", 6, 3],
  ["LJ", "Primal Rage", [["Primal Fury Augment"]], "Wukong", "=", "r", 6, 3],
  ["LK", "Iron Vault", [["Iron Jab Augment"]], "Wukong", "=", "r", 6, 3],
  ["LL", "Jet Stream", [["Turbulence Augment"]], "Zephyr", "=", "r", 6, 3],
  ["LM", "Funnel Clouds", [["Tornado Augment"]], "Zephyr", "=", "r", 6, 3],
  ["LN", "Target Fixation", [["Tail Wind Augment"]], "Zephyr", "=", "r", 6, 3],
  ["LO", "Spectrosiphon", [["Spectrorage Augment"]], "Gara", "=", "r", 6, 3],
  ["LP", "Dread Ward", [["Dread Mirror Augment"]], "Garuda", "=", "r", 6, 3],
  ["LQ", "Desiccation's Curse", [["Desiccation Augment"]], "Inaros", "=", "r", 6, 3],
  ["LR", "Venari Bodyguard", [["Venari Augment"]], "Khora", "=", "r", 6, 3],
  ["LS", "Pilfering Strangledome", [["Strangledome Augment"]], "Khora", "=", "r", 6, 3],
  ["LT", "Teeming Virulence", [["Virulence Augment"]], "Nidus", "=", "r", 6, 3],
  ["LU", "Molecular Fission", [["Molecular Prime Augment"]], "Nova", "=", "r", 6, 3],
  ["LV", "Blinding Reave", [["Reave Augment"]], "Revenant", "=", "r", 6, 3],

  // Archwing
  ["Q0", "Hyperion Thrusters", [["fl", 2.5]], Archwing, "-", "r", 10, 10],
  ["Q1", "Superior Defenses", [["r", 25]], Archwing, "d", "c", 4, 3],
  ["Q2", "Energy Inversion", [["s", 30]], Archwing, "d", "n", 2, 3],
  ["Q3", "Auxiliary Power", [["e", 15]], Archwing, "r", "c", 6],
  ["Q4", "Enhanced Durability", [["h", 25]], Archwing, "d", "c", 4],
  ["Q5", "Argon Plating", [["a", 15]], Archwing, "d", "n", 4],
  ["Q6", "Morphic Transformer", [["t", 5]], Archwing, "r", "r", 6, 3],
  ["Q7", "Energy Amplifier", [["g", 10]], Archwing, "-", "c", 6],
  ["Q8", "System Reroute", [["x", 5]], Archwing, "-", "r", 6, 10],
  ["Q9", "Efficient Transferral", [["u", 7.5]], Archwing, "d", "r", 4, 3],
  ["QA", "Kinetic Diversion", [["rg", 10]], Archwing, "r", "r", 6, 3],
  ["QB", "Primed Morphic Transformer", [["t", 5]], Archwing, "r", "l", 6, 10],
  ["QC", "Cold Snap", [["Cosmic Crush Augment"]], "Itzal", "=", "r", 6, 3],
  ["QD", "Energy Field", [["Energy Shell Augment"]], "Odonata", "=", "r", 6, 3],
  ["QE", "Afterburner", [["Core Vent Augment"]], "Elytron", "=", "r", 6, 3],

  // Archgun
  ["T0", "Venomous Clip", [["6", 20]], Archgun, "d", "c", 4],
  ["T1", "Polar Magazine", [["5", 20]], Archgun, "d", "c", 4],
  ["T2", "Combustion Rounds", [["4", 20]], Archgun, "r", "c", 4],
  ["T3", "Electrified Barrel", [["7", 20]], Archgun, "-", "c", 4],
  ["T4", "Modified Munitions", [["2", 10]], Archgun, "d", "c", 4],
  ["T5", "Marked Target", [["2", 20]], Archgun, "-", "r", 6],
  ["T6", "Sabot Rounds", [["D", 10], ["P", 0.5]], Archgun, "-", "r", 10],
  ["T7", "Automatic Trigger", [["R", 10]], Archgun, "r", "r", 10],
  ["T8", "Dual Rounds", [["S", 10]], Archgun, "r", "r", 6],
  ["T9", "Rubedo-Lined Barrel", [["D", 100 / 6]], Archgun, "r", "c", 6],
  ["TA", "Primed Rubedo-Lined Barrel", [["D", 17]], Archgun, "r", "c", 6, 10],
  ["TB", "Hollowed Bullets", [["1", 20]], Archgun, "r", "r", 4, 3],
  ["TC", "Parallax Scope", [["0", 25]], Archgun, "-", "n", 4, 3],
  ["TD", "Critical Focus", [["cd", 10]], Archgun, "r", "r", 6],
  ["TE", "Magazine Extension", [["L", 10]], Archgun, "-", "n", 4],
  ["TF", "Shell Rush", [["ca", 12.5]], Archgun, "d", "c", 4, 3],
  ["TG", "Archgun Ace", [["onHeadshotKill"], ["rc", 8], ["F", 17]], Archgun, "r", "r", 6],
  ["TH", "Contamination Casing", [["6", 15], ["2", 15]], Archgun, "r", "r", 4, 3],
  ["TI", "Magma Chamber", [["4", 15], ["2", 15]], Archgun, "r", "r", 4, 3],
  ["TJ", "Charged Bullets", [["7", 15], ["2", 15]], Archgun, "r", "r", 4, 3],
  ["TK", "Hypothermic Shell", [["5", 15], ["2", 15]], Archgun, "r", "r", 4, 3],
  ["TL", "Zodiac Shred", [["A", 15]], Archgun, "-", "r", 2],
  ["TM", "Quasar Drill", [["9", 15]], Archgun, "-", "r", 2],
  ["TN", "Comet Blast", [["8", 15]], Archgun, "-", "r", 2],
  ["TO", "Deadly Efficiency", [["onReloadFromEmpty"], ["D", 20]], Archgun, "r", "r", 4],
  ["TP", "Resolute Focus", [["ck", 17], ["spr", -8]], Archgun, "-", "c", 4],
  ["TQ", "Quick Reload", [["F", 25]], Archgun, "-", "c", 2, 3],
  ["TR", "Ammo Chain", [["M", 16.7]], Archgun, "-", "c", 2],

  // Archmelee
  ["V0", "Poisonous Sting", [["6", 20]], Archmelee, "-", "c", 4],
  ["V1", "Glacial Edge", [["5", 20]], Archmelee, "d", "c", 4],
  ["V2", "Blazing Steel", [["4", 20]], Archmelee, "r", "c", 4],
  ["V3", "Galvanized Blade", [["7", 20]], Archmelee, "-", "c", 6],
  ["V4", "Sudden Impact", [["2", 10]], Archmelee, "d", "n", 4],
  ["V5", "Astral Autopsy", [["scan"]], Archmelee, "d", "r", 10, 0],
  ["V6", "Extend", [["T", 20]], Archmelee, "r", "n", 6, 3],
  ["V7", "Furor", [["J", 2.5]], Archmelee, "r", "c", 4, 3],
  ["V8", "Cutting Edge", [["K", 10]], Archmelee, "r", "n", 6],
  ["V9", "Bleeding Edge", [["1", 10]], Archmelee, "r", "n", 4, 10],
  ["VA", "Tempered Blade", [["0", 25]], Archmelee, "r", "n", 4],
  ["VB", "Searing Steel", [["4", 15], ["2", 15]], Archmelee, "r", "r", 4, 3],
  ["VC", "Astral Slash", [["A", 15]], Archmelee, "-", "r", 2],
  ["VD", "Nebula Bore", [["9", 15]], Archmelee, "-", "r", 2],
  ["VE", "Meteor Crash", [["8", 15]], Archmelee, "-", "r", 2],
  ["VF", "Infectious Injection", [["6", 15], ["2", 15]], Archmelee, "r", "r", 4, 3],
  ["VG", "Ion Infusion", [["7", 15], ["2", 15]], Archmelee, "r", "r", 4, 3],
  ["VH", "Cryo Coating", [["5", 15], ["2", 15]], Archmelee, "r", "r", 4, 3],

  // Companion
  ["W8", "Animal Instinct", [["lr", 5], ["er", 3]], Companion, "-", "r", 6],
  ["W9", "Primed Animal Instinct", [["lr", 5], ["er", 3]], Companion, "-", "l", 6, 10],
  ["WA", "Enhanced Vitality", [["h", 20]], Companion, "d", "n", 2, 10],
  ["W6", "Calculated Redirection", [["s", 25]], Companion, "d", "n", 4, 10],
  ["WD", "Metal Fiber", [["a", 10]], Companion, "d", "n", 4, 10],

  // 动物
  ["WJ", "Link Health", [["hl", 15]], Animal, "d", "c", 2, 10],
  ["WI", "Link Shields", [["sl", 10]], Animal, "d", "c", 4, 10],
  ["WK", "Link Armor", [["al", 10]], Animal, "d", "c", 4, 10],
  ["WH", "Loyal Companion", [["bl", 15]], Animal, "d", "n", 2],
  ["WR", "Medi-Pet Kit", [["hps", 1], ["br", 12]], Animal, "d", "r", 4],
  ["WF", "Pack Leader", [["vl", 6]], Animal, "r", "n", 4],
  ["WM", "Primed Pack Leader", [["vl", 6]], Animal, "r", "l", 4, 10],

  // 机器
  ["Wr", "Coolant Leak", [["-"]], Robotic, "y", "r", 4, 0],
  ["Wn", "Guardian", [["!every", 30], ["When Shield runs out"], ["!gd", 50], ["gd", 25 / 3]], Robotic, "y", "n", 2],
  ["Wx", "Medi-Ray", [["!every", 15], ["!over", 4], ["rh", 2]], Robotic, "y", "c", 0],
  ["Wa", "Sanctuary", [["!cs", 50], ["cs", 50]], Robotic, "d", "r", 6, 10],
  ["Wy", "Shield Charger", [["ws", 10], ["wr", 10], ["!over", 5]], Robotic, "y", "r", 0],
  ["WU", "Vacuum", [["!va", 5.5], ["va", 1]], Robotic, "y", "n", 2],
  ["Wl", "Odomedic", [["!wrm", 15], ["wrm", -3], ["rh", 10], ["over", 1]], Robotic, "y", "r", 2, 3],
  ["Ww", "Anti-Grav Array", [["ava", 10]], Robotic, "y", "r", 4, 3],

  // 守护
  ["W5", "Accelerated Deflection", [["r", 15]], Sentinel, "d", "c", 4],
  ["WZ", "Assault Mode", [["!an", 15], ["an", 2.5]], Sentinel, "y", "n", 0],
  ["W7", "Fired Up", [["{0} Heat at Max Overheat", 10]], Sentinel, "r", "r", 6],
  ["We", "Regen", [["!rmh", 49], ["rmh", 8.5], ["reg", 0.3], ["!reg", -0.5], ["ivt", 1]], Sentinel, "y", "n", 2],
  ["Wg", "Primed Regen", [["!rmh", 45], ["rmh", 5], ["reg", 0.3], ["!reg", -0.5], ["ivt", 1]], Sentinel, "y", "l", 4, 10],
  ["XY", "Repair Kit", [["hps", 1]], Sentinel, "d", "c", 4],
  ["Wb", "Sacrifice", [["-"]], Sentinel, "y", "r", 6, 3],
  ["WB", "Self Destruct", [["-"]], Sentinel, "r", "r", 2],
  ["WC", "Spare Parts", [["+7.5% Rare Item Drop Chance On Death"]], Sentinel, "-", "c", 2],
  ["W1", "Synth Deconstruct", [["Enemies injured by the Sentinel have 2% chance to drop a Health Orb when killed."]], Sentinel, "r", "r", 4],
  ["W0", "Synth Fiber", [["Health Orbs increase Armor for Sentinel by 25% for 3s."]], Sentinel, "r", "r", 4, 3],

  // 恐鸟
  ["Wz", "Tractor Beam", [["+20% Aim Glide Duration", 0], ["-12.5% Gravity"]], MOA, "y", "n", 2, 3],
  ["X0", "Whiplash Mine", [["-"]], MOA, "y", "n", 2, 3],
  ["X2", "Shockwave Actuators", [["-"]], MOA, "y", "n", 2, 3],
  ["X1", "Stasis Field", [["-"]], MOA, "y", "n", 4],
  ["X3", "Anti-Grav Grenade", [["-"]], MOA, "y", "n", 2, 3],
  ["X4", "Security Override", [["-"]], MOA, "y", "n", 2],

  // 野兽
  ["W2", "Hunter Synergy", [["cl", 5]], Beast, "r", "c", 4],
  ["W3", "Hunter Recovery", [["rl", 5]], Beast, "r", "n", 4],
  ["W4", "Hunter Command", [["-"]], Beast, "r", "r", 4],
  ["X6", "Shelter", [["-"]], Beast, "d", "c", 6, 10],
  ["Wt", "Fetch", [["!va", 7.5], ["va", 1]], Beast, "y", "c", 2],
  ["X5", "Scavenge", [["chf", 5], ["Open a locked locker"]], Beast, "y", "n", 0],
  ["WG", "Maul", [["K", 30]], Beast, "r", "c", 4, 10],
  ["WL", "Bite", [["0", 30], ["1", 20]], Beast, "r", "r", 6, 10],
  ["WP", "Flame Gland", [["4", 15], ["2", 15]], Beast, "r", "r", 4, 3],
  ["WO", "Frost Jaw", [["5", 15], ["2", 15]], Beast, "r", "r", 4, 3],
  ["WQ", "Shock Collar", [["7", 15], ["2", 15]], Beast, "r", "r", 4, 3],
  ["WN", "Venom Teeth", [["6", 15], ["2", 15]], Beast, "r", "r", 4, 3],

  // Kubrow
  ["XN", "Mecha Overdrive", [["pl", 10], ["3", 15]], Kubrow, "r", "r", 6],
  ["XM", "Mecha Recharge", [["r", 15]], Kubrow, "r", "r", 4],
  ["WE", "Hastened Deflection", [["r", 15]], Kubrow, "d", "c", 4],

  // Kavat
  ["XF", "Pounce", [["The Kavat pounces at an enemy, dealing 60% Damage and stunning them for a short duration."]], Kavat, "r", "c", 2, 3],
  ["XB", "Sense Danger", [["The Kavat alerts their master of nearby enemies within 25m for 10s."]], Kavat, "y", "c", 2, 3],
  ["XD", "Sharpened Claws", [["A vicious attack dealing 150% damage that sunders armor by 30% and rends flesh."]], Kavat, "r", "c", 2, 3],
  ["XC", "Swipe", [["Strikes 1 additional enemies and increases Attack Range by 0.5m."]], Kavat, "r", "c", 2, 3],
  ["XA", "Tek Assault", [["Kavat has 15% chance to ignore Lethal Damage and be immune for 1s."]], Kavat, "r", "r", 6, 3],
  ["X9", "Tek Enhance", [["u", 5]], Kavat, "r", "r", 6],
  ["XG", "Territorial Aggression", [["The Kavat marks their territory, pacifying any wild creature within 10m for 5s."]], Kavat, "y", "c", 2, 3],

  // Other
  ["Wh", "Looter", [["Destroys loot crates within 4.5m."]], "Carrier", "y", "r", 2],
  ["Wj", "Ammo Case", [["Increases Ammo Capacity by 5% and converts Ammo Pickups into ammo for equipped weapons after 5s."]], "Carrier", "y", "n", 2],

  ["Wk", "Energy Generator", [["Dethcube drops an Energy Orb after assisting in 15 kills."]], "Dethcube", "y", "r", 4],
  ["WT", "Vaporize", [["Sentinel will deal 150 Damage to an enemy within 2.3m."]], "Dethcube", "y", "n", 2],

  ["WX", "Electro Pulse", [["Every 10s, Sentinel will continually zap an enemy within 15m, trapping them in a stunned state."]], "Diriga", "y", "n", 2],
  ["Wv", "Arc Coil", [["Sentinel will zap up to 2 enemies within 10m, dealing 100 Electricity Damage with a 10% Status Chance."]], "Diriga", "y", "n", 2],
  ["Wm", "Calculated Shot", [["Sentinel charges a powerful shot and fires at the first enemy within 40.8m."]], "Diriga", "y", "n", 0],

  ["Wu", "Fatal Attraction", [["Enemies within 10m will be attracted. Once they come within 3.5m, explode for 100 Damage."]], "Djinn", "y", "n", 2],
  ["Wd", "Reawaken", [["Upon death, automatically revives itself after 165s."]], "Djinn", "y", "r", 4],
  ["WV", "Thumper", [["Djinn will attack the first visible enemy within 35m."]], "Djinn", "y", "n", 0],

  ["Ws", "Investigator", [["Helios Sentinel will scan objects and enemies within 20m over 5s. This consumes codex scanner charges."]], "Helios", "y", "n", 4],
  ["WS", "Detect Vulnerability", [["Upon completing research on an enemy, subsequent scans will reveal their weak points."]], "Helios", "y", "r", 6],
  ["WW", "Targeting Receptor", [["Causes the Helios Sentinel to attack targets within 10m with 1 glaives."]], "Helios", "y", "n", 0, 3],

  ["WY", "Molecular Conversion", [["Blast enemies within 10m, converting 50 Damage into Shields for the Warframe."]], "Taxon", "y", "n", 2],

  ["Wq", "Crowd Dispersion", [["Unleashes a 6.0m radial knockdown when multiple enemies are nearby, dealing 6.0 Damage."]], "Wyrm", "y", "n", 2],
  ["Wf", "Negate", [["Sentinel prevents Status Effects from applying to its owner once every 15s."]], "Wyrm", "y", "r", 4],

  ["Wi", "Scan Matter", [["Resource containers within 15m are revealed on the Minimap for 2s every 30s."]], "Oxylus", "y", "n", 0, 3],
  ["XZ", "Scan Aquatic Lifeforms", [["Reveals hotspots within 25m and applies Luminous Dye to fish within 40m."]], "Oxylus", "y", "n", 0, 3],

  ["Wp", "Ghost", [["Cloaks owner when enemies are within 5.8m. The cloak is disrupted if owner attacks."]], "Shade", "y", "n", 2],
  ["Wo", "Ambush", [["When Ghost invisibility is broken, Shade's owner is granted +30% Weapon Damage for 3s."]], "Shade", "y", "r", 6, 3],
  ["Wc", "Revenge", [["Sentinel will not attack an enemy unless that enemy has attacked the Sentinel's master within 5.8m."]], "Shade", "y", "n", 0],

  ["X7", "Proboscis", [["-"]], "Helminth Charger", "y", "r", 0, 3],
  ["XK", "Strain Fever", [["-"]], "Helminth Charger", "r", "r", 6, 3],
  ["XL", "Strain Eruption", [["-"]], "Helminth Charger", "-", "r", 2, 3],
  ["X8", "Trample", [["The Helminth Charger rushes an enemy, dealing 35 Damage to all in its path."]], "Helminth Charger", "y", "r", 0],

  ["XJ", "Cat's Eye", [["-"]], "Adarza Kavat", "y", "r", 0, 3],
  ["XE", "Reflect", [["-"]], "Adarza Kavat", "y", "r", 0, 3],

  ["XH", "Charm", [["-"]], "Smeeta Kavat", "y", "r", 0, 3],
  ["XI", "Mischief", [["-"]], "Smeeta Kavat", "y", "r", 0, 3],

  ["XU", "Neutralize", [["-"]], "Chesa Kubrow", "y", "r", 0],
  ["XS", "Retrieve", [["-"]], "Chesa Kubrow", "y", "n", 0],

  ["XX", "Hunt", [["-"]], "Huras Kubrow", "y", "r", 0],
  ["XW", "Stalk", [["-"]], "Huras Kubrow", "y", "r", 0],

  ["XT", "Howl", [["-"]], "Raksa Kubrow", "y", "r", 0],
  ["XR", "Protect", [["-"]], "Raksa Kubrow", "y", "r", 0],

  ["XV", "Dig", [["-"]], "Sahasa Kubrow", "y", "r", 0],
  ["XO", "Ferocity", [["-"], ["X", 20]], "Sahasa Kubrow", "y", "r", 0],

  ["XP", "Savagery", [["-"], ["X", 20]], "Sunika Kubrow", "y", "r", 0],
  ["XQ", "Unleashed", [["-"]], "Sunika Kubrow", "y", "r", 0],

  ["XR", "Draining Bite", [["-"]], "Vasca Kavat", "y", "r", 0, 3],
  ["XS", "Transfusion", [["-"]], "Vasca Kavat", "y", "r", 0, 3],
] as [string, string, [string, number][], Tags, Polarity, Rarity, number, number?][];

type Tags = string | string[];

export default data;
