# 三线琴图形化编曲工具

## 功能

- [x] 键盘或鼠标输入音符
- [x] 导入现有代码（支持自动调整BPM）
- [x] 切换BPM
- [x] 实时录制
- [x] 播放预览和切换不同的三线琴音色（虽然现在只有两种）

## 如何选择BPM【重要】

BPM即每分钟节拍数，计算方式为每秒内节拍数*60，也就是一秒2拍对应120BPM。

由于没有做八分音符和十六分音符，如果你所用的谱子用到了请将BPM乘以2或者4（比如120BPM下用到了十六分音符 则需要使用480BPM 并将所有十六分换为四分 原先四分变为全音符 以此类推）

由于游戏代码精确度限制无法做到任意调整BPM 如果你的曲子有标定BPM请用最接近的选项（同时按上面规则调整）

## 操作

注意上方工具栏的一排按钮，有那3个图标就是切换当前使用的工具。

默认是移动工具，支持框选，用过类似软件的同学应该比较熟悉。

第二个是添加音符工具，同样是点击空白处可以添加音符。

第三个是删除音符工具，点击音符即可删除，当然删除快捷键是键盘上的DEL，如果需要批量删除可以用移动工具先框选音符之后用DEL全部删除。

## 转调

当谱子音域可能不够用时，则需要使用一定程度的转调来使音域刚好落在区间内。

比如权御天下这首 原曲音域在低5到高1 而大调音域在低1到高5 因此使用G调来使大调的低1变成低5就可以放下所有音符了

这里列出比较常用的转调:

- 小调转D (低音2到中音6 缺7)
- 小调转F (低音4到高音1 缺7)
- 大调转G (低音5到高音2 缺4)
- 小调转A (低音6到高音3)
- 五声小调转D (低音2到高音4)
- Yo调式转bG (低音5到高音6)
- 五声小调转A (低音6到高高音1)
- 五声小调转E (低音3到高音5 23567)
- 五声大调转G (低音5到高音6 23567)
- Yo调式转bD (低音2到高音3 23567)
- Yo调式转B (中音1到高高音2 12456)

## 简谱代码

简谱代码是为了方便导入和转调的一种可读性编码。可以快速将现有谱子导入本工具。多数情况需结合转调工具使用。

**注意导入的只是音符信息，速度请自行调节BPM。**

例: (离去之原 C大调 240BPM)
```
}000[35]|66[65]5|[35350321]|15[50]3|[4323]00|
667^1|[7^1750321]|15[53]3|[4321]0[35]|
66[6555]|[35350321]|[11555334]|[4323]00|
[66]67^1|[^2^17^10665]|667^1|[{3121}]00|000[07]|
[7767]5[05]|{[33]3[3432]|1,[2]2}[05]|{[22]2[2432]|
1,[2]35|10_61|2[1]_7[101]|3[450]1[2|0]1,0[0_5]|
[33]3[3432]|1,[2]2[0_5]|2[202432]|1,[2]35|
10[0_601]|4[320]1[1]|_700[0_6]|100[01]}
```

## MIDI

视频教程 [https://www.bilibili.com/video/av70918823/](https://www.bilibili.com/video/av70918823/)

### 符号列表

除以下字符外 其他字符均无意义 可做排版使用

- `. - =` 分别表示之后音符为全音符 二分音符 四分音符 对之后所有音符均有效
- `[ ]` 分别表示之后音符长度为之前的一半/两倍 如-123=45-1也可写为-123[45]1
- `_(或/) ^(或+)` 分别表示低音 高音 只能修饰一个音符
- `{ }` 分别表示之后音符为之前高/低一个八度 如_1_2_3123^1^2^3也可写为}123{123{123
- `# b` 表示升降 只能修饰一个音符
- `,` 表示附点 如=3003也可写为-3,=3
- 若开头未写`.或=`则默认以二分音符开始

## 和弦

目前已支持游戏内所有同时出现的音符(和弦)的导入和导出

导入这段代码来查看所有支持的组合: `5BAACAIEAQJAYKAgMAoRAwSA4UBAhBIiBQkBYDBgGBoFBwLB4OCANCITCQWCYVCgjComCwlC4HDAPDIXDQnDYZDgaDocDwpD4qEAsEIxEQyEY0Eg5Eo6Ew8E4bFAdFI/FQtFYeFguFozFw1F47GA9GI2GQ+GYfGgvGo`

## 键盘快捷键

`Ctrl+Z`：撤销

`Ctrl+Shift+Z`：重做

`DEL`：删除选择的音符

`Shift+DEL`：波纹删除选择的音符（即将删除的空间用后面音符往前移进行填补

`BACKSPACE`：删除最后一个音符

`Q~]`：输入音符

`1~7`：同上，也是输入音符，不同的是匹配简谱 默认是低音 Shift中音 Alt高音

`S、0`：休止符

`JKL`：切换音符持续时间

`↑/↓`：选择上一个/下一个音符

`←/→`：向前/后移动光标

`Shift+←/→`：从已选择的音符开始选择到开头/末尾

`Shift+↑/↓`：缩放当前音符（调整单个音符的时值）

`Ctrl+Shift+↑/↓`：缩放当前音符并移动后面音符

`Ctrl+↑/↓/←/→`：向上/下/左/右移动音符

`INS`：在当前选择音符前插入空白 `Shift+INS` 2格 `Ctrl+INS` 4格 `Alt+INS` -1格

`Shift+左键`：从已选择的音符开始选择到当前点击的音符

`Ctrl+左键`：多选音符

`Home/End`: 跳转到第一个/最后一个音符

## 相关

开源仓库地址 [GitHub-极镜](https://github.com/pa001024/riven-mirror)

工具链接：[https://riven.im/music](https://riven.im/music)

示例：[示例音乐](https://warframe.huijiwiki.com/p/31525) [示例简谱代码](https://github.com/pa001024/riven-mirror/blob/dev/src/views/music/song.txt)
