export const SVGData: { [key: string]: { size: number; path: string } } = {
  logo: {
    size: 32,
    path:
      "M19.815 12.277l0.068 6.983-5.356-3.322zM22.188 13.633v4.407l3.797-2.169zM20.493 0.345l-0.678 3.267v4.801l-10.441 7.864 10.508 6.915v4.936l0.542 2.658-2.42-3.687-15.072-10.55 14.694-11.448zM29.374 10.786c0 0-0.416 0.243-0.91 0.537l0.028 2.92-5.356-3.322 5.288-3.661 0.029 2.946zM29.442 20.82l-0.909 0.41 0.028 2.844-5.356-3.322 5.288-3.661 0.031 3.209z",
  },
  loop: {
    size: 32,
    path: "M4 10h20v6l8-8-8-8v6h-24v12h4zM28 22h-20v-6l-8 8 8 8v-6h24v-12h-4z",
  },
  stop: {
    size: 32,
    path:
      "M16 0c-8.837 0-16 7.163-16 16s7.163 16 16 16 16-7.163 16-16-7.163-16-16-16zM16 29c-7.18 0-13-5.82-13-13s5.82-13 13-13 13 5.82 13 13-5.82 13-13 13zM10 10h12v12h-12z",
  },
  shawzin: {
    size: 32,
    path:
      "M24.275 0.924c0 0-0.196-0.262 0.301-0.602s0.772-0.353 0.902-0.301 0.235 1.338 0.602 1.809c0.366 0.471 1.203 1.809 1.203 1.809s-0.248-1.286 0-1.504c0.248-0.222 1.439-0.070 1.805 0.301s0.946 1.718 0.902 2.411c-0.044 0.693-0.065 0.981-0.301 0.902-0.235-0.074-0.602-0.301-0.602-0.301s1.356 1.452 1.805 1.809c0.449 0.357 0.301 0.902 0.301 0.902s-0.658 0.711-0.902 0c-0.244-0.711-1.805-2.712-1.805-2.712s-0.275 0.096-0.301 0.602c-0.026 0.506 0.793 1.735 1.203 2.11 0.41 0.371 0.902 0.602 0.902 0.602s0.209 0.706-0.602 0.902c-0.811 0.201-0.536-0.541-0.602-0.602s-0.841-1.609-1.203-1.809c-0.362-0.196-0.876 0.031-1.203 0s-7.682 7.381-8.724 9.038c-1.042 1.657-2.066 2.511-2.707 7.228-0.645 4.739-1.718 5.415-3.008 6.326s-1.574 1.064-2.407 0.902c-0.833-0.157-1.548-0.676-3.008 0s-2.232 1.456-2.707 1.203c-0.475-0.253-1.129-0.658-1.203-1.203-0.074-0.549 0-0.902 0-0.902s-0.667 0.013-1.203-0.301c-0.536-0.314-1.055-0.331-0.902-1.203 0.174-0.998 1.535-1.988 1.504-3.313s-0.423-1.548-0.602-2.411 0.27-1.77 0.602-2.11c0.331-0.336 0.78-0.462 0.902-0.301s0 0.902 0 0.902 0.776-0.767 1.504-1.504c0.728-0.737 2.707-1.726 4.813-2.11 2.106-0.379 4.752-1.007 8.122-3.915 3.37-2.912 6.88-6.221 7.22-6.928s0.283-2.036 0.602-2.411c0.318-0.375 1.247 0.105 1.504 0s-0.048-0.528-0.602-1.203c-0.554-0.676-1.177-1.687-1.504-1.809s-0.602-0.305-0.602-0.305zM2.672 21.45c0.035 0.126 0.571 1.984 0.663 2.89 0.174 1.678-0.876 3.462-1.33 3.828-0.026 0.022-0.126 0.1-0.131 0.209-0.017 0.283 0.558 0.667 0.854 0.514 0.087-0.044 0.179-0.153 0.17-0.266-0.009-0.122-0.131-0.183-0.166-0.288-0.070-0.196 0.074-0.41 0.122-0.484 0.153-0.24 0.318-0.872 0.545-1.395 0.776-1.805 0.039-4.207-0.044-4.46-0.087-0.27-0.262-0.528-0.501-0.689-0.087-0.061-0.148-0.083-0.183-0.061-0.044 0.035-0.017 0.14 0 0.201zM4.124 29.973c-0.153 0.126-0.253 0.353-0.183 0.484 0.065 0.122 0.575-0.078 0.968-0.122 0.488-0.052 0.894-0.449 1.059-0.523 0.392-0.183 1.155-0.279 1.36-0.323 0.767-0.174 1.426 0.057 2.481 0.301 0.157 0.035 0.528 0.201 0.606 0.061 0.048-0.087-0.061-0.231-0.122-0.301-0.292-0.34-0.793-0.353-1.090-0.362-0.558-0.022-1.173-0.201-1.875-0.122-0.519 0.057-1.016 0.187-1.269 0.301-0.179 0.078-0.606 0.427-1.029 0.484-0.401 0.052-0.671-0.074-0.907 0.122z",
  },
  kuva: {
    size: 32,
    path:
      "M23.755 15.232c-3.68-0.48-4.555-0.213-10.315-0.213-4.224 0-7.776-2.955-8.256-5.995s0.48-6.72 0.48-6.72-4.16 3.52-4.32 8c-0.16 4.48 2.901 12.416 8.405 15.339 7.285 3.872 12.725 3.371 15.765 2.891s4.736-1.781 5.376-5.749c0.8-4.96-3.445-7.072-7.136-7.552zM18.475 16.267c-0.043 0.107-0.203 0.149-0.416 0.213s-0.907 0.128-1.099-0.149c-0.192-0.277 0.608-0.448 0.949-0.416s0.608 0.256 0.565 0.352zM21.451 17.152c-0.96-0.704-0.619-0.736-0.448-0.8 0.171-0.075 0.576-0.096 1.397-0.096 0.949 0 2.955 0.981 2.976 1.323 0.021 0.331-2.965 0.267-3.925-0.427z",
  },
  radio: {
    size: 32,
    path:
      "M32 16c0-8.837-7.163-16-16-16s-16 7.163-16 16c0 6.877 4.339 12.739 10.428 15.002l-0.428 0.998h12l-0.428-0.998c6.089-2.263 10.428-8.125 10.428-15.002zM15.212 19.838c-0.713-0.306-1.212-1.014-1.212-1.838 0-1.105 0.895-2 2-2s2 0.895 2 2c0 0.825-0.499 1.533-1.212 1.839l-0.788-1.839-0.788 1.838zM16.821 19.915c1.815-0.379 3.179-1.988 3.179-3.915 0-2.209-1.791-4-4-4s-4 1.791-4 4c0 1.928 1.364 3.535 3.18 3.913l-2.332 5.441c-2.851-1.223-4.848-4.056-4.848-7.355 0-4.418 3.582-8.375 8-8.375s8 3.957 8 8.375c0 3.299-1.997 6.131-4.848 7.355l-2.331-5.439zM21.514 30.866l-2.31-5.39c3.951-1.336 6.796-5.073 6.796-9.476 0-5.523-4.477-10-10-10s-10 4.477-10 10c0 4.402 2.845 8.14 6.796 9.476l-2.31 5.39c-4.987-2.14-8.481-7.095-8.481-12.866 0-7.729 6.266-14.37 13.995-14.37s13.995 6.641 13.995 14.37c0 5.771-3.494 10.726-8.481 12.866z",
  },
  stats: {
    size: 32,
    path:
      "M4 28h28v4h-32v-32h4zM9 26c-1.657 0-3-1.343-3-3s1.343-3 3-3c0.088 0 0.176 0.005 0.262 0.012l3.225-5.375c-0.307-0.471-0.487-1.033-0.487-1.638 0-1.657 1.343-3 3-3s3 1.343 3 3c0 0.604-0.179 1.167-0.487 1.638l3.225 5.375c0.086-0.007 0.174-0.012 0.262-0.012 0.067 0 0.133 0.003 0.198 0.007l5.324-9.316c-0.329-0.482-0.522-1.064-0.522-1.691 0-1.657 1.343-3 3-3s3 1.343 3 3c0 1.657-1.343 3-3 3-0.067 0-0.133-0.003-0.198-0.007l-5.324 9.316c0.329 0.481 0.522 1.064 0.522 1.691 0 1.657-1.343 3-3 3s-3-1.343-3-3c0-0.604 0.179-1.167 0.487-1.638l-3.225-5.375c-0.086 0.007-0.174 0.012-0.262 0.012s-0.176-0.005-0.262-0.012l-3.225 5.375c0.307 0.471 0.487 1.033 0.487 1.637 0 1.657-1.343 3-3 3z",
  },
  compass: {
    size: 32,
    path:
      "M17 32c-0.072 0-0.144-0.008-0.217-0.024-0.458-0.102-0.783-0.507-0.783-0.976v-15h-15c-0.469 0-0.875-0.326-0.976-0.783s0.129-0.925 0.553-1.123l30-14c0.381-0.178 0.833-0.098 1.13 0.199s0.377 0.749 0.199 1.13l-14 30c-0.167 0.358-0.524 0.577-0.906 0.577zM5.508 14h11.492c0.552 0 1 0.448 1 1v11.492l10.931-23.423-23.423 10.931z",
  },
  tenno: {
    size: 32,
    path:
      "M15.094 8.447c0.422-0.516 0.825-1.106 0.884-1.787 0.059 0.616 0.394 1.159 0.766 1.637 0.613 0.769 1.369 1.416 2.141 2.019 1.028 0.794 2.122 1.503 3.234 2.169 0.916 0.547 1.844 1.063 2.794 1.547 0.116 0.625 0.141 1.266 0.116 1.9-0.066 1.447-0.45 2.884-1.134 4.159-0.5 0.934-1.156 1.784-1.922 2.516-0.025-0.012-0.078-0.034-0.103-0.047 0.691-0.744 1.3-1.584 1.681-2.531 0.281-0.703 0.428-1.475 0.316-2.228-0.1-0.697-0.438-1.347-0.922-1.853-0.022-0.022-0.044-0.041-0.069-0.053-2.297-1.356-4.594-2.709-6.891-4.066-2.294 1.353-4.591 2.706-6.884 4.063-0.025 0.016-0.050 0.034-0.072 0.053-0.528 0.534-0.875 1.244-0.95 1.994-0.088 0.803 0.109 1.609 0.441 2.341 0.384 0.847 0.944 1.606 1.575 2.284-0.034 0.016-0.069 0.031-0.106 0.047-1.297-1.234-2.269-2.816-2.728-4.547-0.344-1.313-0.447-2.697-0.213-4.031 1.094-0.556 2.159-1.156 3.206-1.797 1.009-0.619 2-1.278 2.934-2.006 0.681-0.541 1.344-1.113 1.906-1.781zM15.634 14.022c0.172-0.256 0.316-0.544 0.334-0.856 0.056 0.531 0.394 0.972 0.741 1.356 0.653 0.703 1.434 1.272 2.228 1.803 0.931 0.616 1.9 1.175 2.894 1.681 0.203 1.178 0.022 2.413-0.459 3.506-0.344 0.778-0.856 1.478-1.469 2.069-0.019-0.009-0.053-0.022-0.069-0.031 0.409-0.444 0.778-0.938 1.028-1.491 0.225-0.494 0.359-1.047 0.288-1.591-0.056-0.469-0.278-0.909-0.603-1.25-0.031-0.031-0.072-0.056-0.109-0.078-1.491-0.875-2.975-1.759-4.469-2.631-1.503 0.894-3.016 1.778-4.519 2.672-0.409 0.384-0.65 0.941-0.666 1.503-0.019 0.531 0.137 1.053 0.375 1.522 0.247 0.497 0.591 0.941 0.963 1.35-0.044 0.025-0.081 0.022-0.109-0.012-0.813-0.784-1.428-1.775-1.734-2.866-0.241-0.866-0.313-1.784-0.159-2.669 1.012-0.519 2-1.087 2.947-1.716 0.55-0.369 1.084-0.759 1.584-1.194 0.359-0.328 0.709-0.675 0.984-1.078zM4.194 17.169c0.537-0.266 1.081-0.522 1.588-0.844 0.1 0.541 0.225 1.075 0.4 1.594-0.978 0.438-1.912 0.959-2.816 1.534 0.394 1.206 0.847 2.397 1.409 3.534 0.259 0.512 0.541 1.019 0.903 1.469 0.309 0.384 0.728 0.663 1.163 0.884-0.756-0.153-1.513-0.309-2.269-0.466-0.044-0.003-0.072-0.028-0.088-0.066-0.563-1.188-1.125-2.378-1.684-3.566-0.119-0.25-0.237-0.497-0.344-0.75-0.394-0.859-0.913-1.681-1.644-2.291-0.178-0.159-0.397-0.262-0.613-0.359 0.403 0.134 0.831 0.163 1.25 0.137 0.962-0.066 1.884-0.391 2.744-0.813zM25.822 17.919c0.175-0.519 0.3-1.056 0.4-1.594 0.484 0.313 1.009 0.559 1.525 0.816 0.8 0.4 1.653 0.712 2.547 0.816 0.503 0.053 1.022 0.047 1.506-0.116-0.209 0.097-0.419 0.194-0.594 0.347-0.709 0.584-1.219 1.375-1.609 2.197-0.334 0.753-0.697 1.494-1.047 2.241-0.344 0.728-0.688 1.456-1.034 2.188-0.016 0.044-0.050 0.066-0.097 0.069-0.753 0.153-1.506 0.309-2.259 0.462 0.462-0.231 0.903-0.534 1.219-0.95 0.5-0.653 0.859-1.397 1.2-2.141 0.403-0.909 0.753-1.847 1.063-2.794-0.906-0.581-1.841-1.103-2.819-1.541zM15.822 18.116c0.078-0.134 0.137-0.284 0.147-0.444 0.044 0.359 0.275 0.659 0.512 0.916 0.372 0.394 0.806 0.722 1.253 1.028 0.659 0.45 1.353 0.853 2.066 1.219 0.194 1.181-0.156 2.441-0.934 3.353-0.106 0.116-0.203 0.244-0.328 0.337-0.012 0-0.034 0.003-0.047 0.003 0.209-0.25 0.425-0.503 0.578-0.794 0.191-0.347 0.322-0.744 0.294-1.144-0.019-0.331-0.166-0.653-0.391-0.894-0.059-0.056-0.137-0.091-0.206-0.134-0.931-0.55-1.859-1.097-2.791-1.647-0.984 0.581-1.972 1.159-2.953 1.744-0.316 0.284-0.472 0.728-0.438 1.15 0.037 0.494 0.272 0.95 0.563 1.341 0.097 0.131 0.209 0.25 0.309 0.378-0.037 0.006-0.069-0.006-0.094-0.034-0.403-0.397-0.731-0.869-0.95-1.394-0.294-0.712-0.394-1.503-0.272-2.266 0.959-0.497 1.9-1.047 2.744-1.722 0.356-0.288 0.703-0.6 0.938-0.997zM6.656 19.456c0.016-0.003 0.047-0.012 0.059-0.016 0.172 0.25 0.35 0.5 0.541 0.738-0.331 0.163-0.659 0.334-0.981 0.519 0.269 0.625 0.556 1.244 0.884 1.841 0.194 0.347 0.397 0.694 0.65 1.003 0.166 0.203 0.369 0.372 0.578 0.525-0.487-0.113-0.978-0.222-1.466-0.334-0.059-0.012-0.091-0.072-0.116-0.125-0.303-0.634-0.612-1.266-0.916-1.897-0.247-0.522-0.503-1.050-0.888-1.488-0.15-0.169-0.319-0.328-0.534-0.406 0.291 0.084 0.597 0.084 0.894 0.044 0.45-0.059 0.884-0.209 1.294-0.403zM24.744 20.178c0.194-0.241 0.372-0.494 0.547-0.75 0.462 0.225 0.959 0.397 1.475 0.45 0.256 0.025 0.519 0.016 0.766-0.059-0.231 0.084-0.409 0.259-0.566 0.441-0.275 0.325-0.484 0.694-0.675 1.075-0.369 0.766-0.741 1.531-1.109 2.297-0.025 0.056-0.069 0.103-0.131 0.109-0.481 0.109-0.959 0.219-1.441 0.328 0.228-0.166 0.444-0.353 0.619-0.575 0.238-0.303 0.434-0.637 0.622-0.975 0.322-0.591 0.609-1.2 0.872-1.819-0.319-0.188-0.647-0.356-0.978-0.522z",
  },
  t2: {
    size: 32,
    path:
      "M16 5.563v0q-2.063 0-3.875 0.781-1.781 0.781-3.141 2.141t-2.109 3.141q-0.781 1.813-0.781 3.875v0 0 0q0 2.063 0.781 3.875t2.125 3.156 3.156 2.125 3.844 0.781q2.063 0 3.875-0.781t3.156-2.125 2.125-3.156 0.781-3.875-0.781-3.844q-0.781-1.813-2.125-3.172t-3.156-2.141-3.875-0.781v0 0 0zM16 6.719v0 0q1.844 0 3.438 0.688 1.594 0.719 2.781 1.906t1.875 2.781 0.688 3.406-0.688 3.438q-0.688 1.594-1.875 2.781t-2.781 1.875-3.438 0.688q-1.813 0-3.406-0.688t-2.781-1.875-1.875-2.781q-0.688-1.625-0.688-3.438v0 0 0q0-1.813 0.688-3.406t1.875-2.781 2.781-1.875q1.594-0.719 3.406-0.719v0 0zM20.125 15.469q0 1.688-1.188 2.891t-2.906 1.203q-1.688 0-2.891-1.203t-1.203-2.891 1.203-2.891 2.891-1.203q1.719 0 2.906 1.203t1.188 2.891v0zM16.031 1.125l3.75 7.469h-7.469zM16.031 29.844l-3.719-7.531h7.438z",
  },
  t4: {
    size: 32,
    path:
      "M16 5.563v0q-2.063 0-3.875 0.781-1.781 0.781-3.141 2.141t-2.109 3.141q-0.781 1.813-0.781 3.875v0 0 0q0 2.063 0.781 3.875t2.125 3.156 3.156 2.125 3.844 0.781q2.063 0 3.875-0.781t3.156-2.125 2.125-3.156 0.781-3.875-0.781-3.844q-0.781-1.813-2.125-3.172t-3.156-2.141-3.875-0.781v0 0 0zM16 6.719v0 0q1.844 0 3.438 0.688 1.594 0.719 2.781 1.906t1.875 2.781 0.688 3.406-0.688 3.438q-0.688 1.594-1.875 2.781t-2.781 1.875-3.438 0.688q-1.813 0-3.406-0.688t-2.781-1.875-1.875-2.781q-0.688-1.625-0.688-3.438v0 0 0q0-1.813 0.688-3.406t1.875-2.781 2.781-1.875q1.594-0.719 3.406-0.719v0 0zM20.125 15.469q0 1.688-1.188 2.891t-2.906 1.203q-1.688 0-2.891-1.203t-1.203-2.891 1.203-2.891 2.891-1.203q1.719 0 2.906 1.203t1.188 2.891v0zM16.031 1.125l3.75 7.469h-7.469zM16.031 29.844l-3.719-7.531h7.438zM1.375 15.969l7.5-3.719v7.438zM30.719 15.969l-7.531 3.719v-7.438z",
  },
  t1: {
    size: 32,
    path:
      "M16 5.563v0q-2.063 0-3.875 0.781-1.781 0.781-3.141 2.141t-2.109 3.141q-0.781 1.813-0.781 3.875v0 0 0q0 2.063 0.781 3.875t2.125 3.156 3.156 2.125 3.844 0.781q2.063 0 3.875-0.781t3.156-2.125 2.125-3.156 0.781-3.875-0.781-3.844q-0.781-1.813-2.125-3.172t-3.156-2.141-3.875-0.781v0 0 0zM16 6.719v0 0q1.844 0 3.438 0.688 1.594 0.719 2.781 1.906t1.875 2.781 0.688 3.406-0.688 3.438q-0.688 1.594-1.875 2.781t-2.781 1.875-3.438 0.688q-1.813 0-3.406-0.688t-2.781-1.875-1.875-2.781q-0.688-1.625-0.688-3.438v0 0 0q0-1.813 0.688-3.406t1.875-2.781 2.781-1.875q1.594-0.719 3.406-0.719v0 0zM20.125 15.469q0 1.688-1.188 2.891t-2.906 1.203q-1.688 0-2.891-1.203t-1.203-2.891 1.203-2.891 2.891-1.203q1.719 0 2.906 1.203t1.188 2.891v0zM16.031 1.125l3.75 7.469h-7.469z",
  },
  t3: {
    size: 32,
    path:
      "M16.031 5.531v0 0 0q-2.188 0-4.094 0.813-1.938 0.844-3.359 2.266t-2.266 3.359q-0.813 1.906-0.813 4.094v0q0 2.188 0.813 4.125 0.844 1.906 2.266 3.344t3.359 2.25q1.906 0.844 4.094 0.844t4.094-0.844q1.938-0.813 3.359-2.25t2.266-3.344q0.844-1.938 0.844-4.125t-0.844-4.094q-0.844-1.938-2.266-3.359t-3.359-2.266q-1.906-0.813-4.094-0.813zM16.031 6.75q1.938 0 3.625 0.75 1.688 0.719 2.953 1.984t2.016 2.953q0.719 1.688 0.719 3.625t-0.719 3.625q-0.75 1.688-2.016 2.953t-2.953 2.016q-1.688 0.719-3.625 0.719t-3.625-0.719q-1.688-0.75-2.953-2.016t-1.984-2.953q-0.75-1.688-0.75-3.625v0q0-1.938 0.75-3.625 0.719-1.688 1.984-2.953t2.953-1.984q1.688-0.75 3.625-0.75v0 0 0 0zM20.438 16.031q0 1.781-1.281 3.063t-3.063 1.281q-1.813 0-3.078-1.281t-1.266-3.063q0-1.813 1.266-3.094t3.078-1.281q1.781 0 3.063 1.281t1.281 3.094zM16.094 0.813l3.969 7.938h-7.938zM4.188 25.656l3.5-8.188 5.125 6zM29.031 24.625l-8.813-1.125 4.344-6.563z",
  },
  fortuna: {
    size: 32,
    path:
      "M4.656 0.5v12.875l6.75 4.313v-12.688zM4.563 14.688v1.5l6.938 4.5 0.094-1.5zM4.563 17.406l0.094 1.406-1.688-0.75-0.094 1.406 8.625 5.438 0.094-2.906zM13.469 6.406v17.938l4.969-3.094-0.094-14.844-2.25 1.5zM13.375 26.406v3.875l2.438 1.406v-1.5l2.719-1.875-0.188-5.188zM20.438 5.094v14.75l6.844-4.313-0.094-15.125zM20.344 21.906v2.906l8.625-5.438-0.094-1.219-1.688 0.656-0.188-1.406z",
  },
  setting: {
    size: 32,
    path:
      "M14 4v-0.5q0-0.625-0.438-1.063t-1.063-0.438h-5q-0.625 0-1.063 0.438t-0.438 1.063v0.5h-6v4h6v0.5q0 0.625 0.438 1.063t1.063 0.438h5q0.625 0 1.063-0.438t0.438-1.063v-0.5h18v-4h-18zM8 8v-4h4v4h-4zM26 13.5q0-0.625-0.438-1.063t-1.063-0.438h-5q-0.625 0-1.063 0.438t-0.438 1.063v0.5h-18v4h18v0.5q0 0.625 0.438 1.063t1.063 0.438h5q0.625 0 1.063-0.438t0.438-1.063v-0.5h6v-4h-6v-0.5zM20 18v-4h4v4h-4zM14 23.5q0-0.625-0.438-1.063t-1.063-0.438h-5q-0.625 0-1.063 0.438t-0.438 1.063v0.5h-6v4h6v0.5q0 0.625 0.438 1.063t1.063 0.438h5q0.625 0 1.063-0.438t0.438-1.063v-0.5h18v-4h-18v-0.5zM8 28v-4h4v4h-4z",
  },
  umbra: {
    size: 32,
    path:
      "M5.25 3.938q-0.781-1.156-1.422-1.734l-0.641-0.578 1.813-1.156 1.422 1.359t1.922 1.734q-2.625 3.344-2.594 5.938 0.031 2.625 1.188 4.453t2.75 2.859q1.563 1 2.094 1.156 1.563 0.281 2.516-0.953l0.953-1.234-0.75-5 1.531-2.188 1.656 1.906-0.906 5.406 1.047 1.094t2.672 1.094q1.344-0.125 2.625-1.656 1.25-1.5 2-3.547t0.75-4.234q0.031-2.188-1.125-3.688 1.063-1.625 1.813-2.672l0.75-1.047 1.406 1.813q-0.531 0.469-1 0.969t-0.906 1.031l-0.031 0.063q1.781 3.75 0.844 6.594-0.969 2.844-2.828 4.75t-3.703 2.844l-1.875 0.969 0.188 1.188q0.156 1.219 0.016 2.906t-0.828 3.5q-0.719 1.844-2.438 3.094-1.688-1.469-2.344-3.25-0.656-1.813-0.766-3.406t0.109-2.688l0.188-1.094-2-0.688q-2.031-0.688-4.031-2.531t-3.031-5.063q-1-3.219 0.969-8.313v0zM16.156 18.875l-0.813 1.359t-0.719 3.391 0.875 3.266l0.781 1.234 0.766-1.453t0.766-2.922q0-1.438-0.828-3.156l-0.828-1.719z",
  },
  sun: {
    size: 32,
    path:
      "M10.75 9.313l-1.813-1.813-1.5 1.5 1.813 1.813 1.5-1.5zM7.938 15.031h-3v2h3v-2zM17 5.094h-2.031v2.906h2.031v-2.906zM24.531 9l-1.531-1.5-1.781 1.813 1.406 1.406 1.906-1.719zM21.219 22.75l1.781 1.813 1.438-1.406-1.813-1.813zM24.031 17.031h3v-2h-3v2zM15.969 10q-1.219 0-2.344 0.469-1.094 0.469-1.906 1.297t-1.281 1.922q-0.5 1.094-0.5 2.344t0.5 2.344q0.469 1.094 1.281 1.906t1.906 1.313q1.125 0.469 2.344 0.469 1.25 0 2.344-0.469 1.094-0.5 1.922-1.313t1.297-1.906 0.469-2.344-0.469-2.344-1.297-1.922-1.922-1.297-2.344-0.469zM14.969 26.969h2.031v-2.906h-2.031v2.906zM7.438 23.063l1.5 1.5 1.813-1.813-1.406-1.406z",
  },
  night: {
    size: 32,
    path:
      "M15.781 27.469q-2.281 0-4.344-0.844-2.031-0.844-3.609-2.281t-2.547-3.406q-1-1.938-1.188-4.188 0-0.438 0.313-0.75t0.75-0.313q0.25 0 0.469 0.109t0.375 0.266q0 0.031 0.016 0.016l0.016-0.016q0.969 1.031 2.313 1.641t2.875 0.609q1.5 0 2.781-0.563 1.313-0.563 2.297-1.547t1.547-2.297 0.563-2.781q0-1.563-0.609-2.906t-1.672-2.313h0.016t0.016-0.031q-0.188-0.125-0.281-0.344t-0.094-0.469q0-0.438 0.313-0.75t0.75-0.344q2.25 0.219 4.219 1.188 1.938 1 3.391 2.578t2.266 3.609q0.844 2.031 0.844 4.344 0 2.438-0.938 4.594-0.906 2.125-2.5 3.719t-3.75 2.531-4.594 0.938v0z",
  },
  earth: {
    size: 32,
    path:
      "M16 0q-3.313 0-6.219 1.25-2.938 1.25-5.109 3.422t-3.422 5.109q-1.25 2.906-1.25 6.219t1.25 6.219q1.25 2.938 3.422 5.109t5.109 3.422q2.906 1.25 6.219 1.25t6.219-1.25q2.938-1.25 5.109-3.422t3.422-5.109q1.25-2.906 1.25-6.219t-1.25-6.219q-1.25-2.938-3.422-5.109t-5.109-3.422q-2.906-1.25-6.219-1.25zM16 30q-1.469 0-2.859-0.297t-2.672-0.828l7.281-8.219q0.125-0.125 0.188-0.297t0.063-0.359v-3q0-0.406-0.297-0.703t-0.703-0.297q-1.313 0-2.625-0.563-1.313-0.594-2.344-1.281t-1.656-1.281q-0.656-0.563-0.656-0.594-0.156-0.125-0.344-0.203t-0.375-0.078h-4q-0.406 0-0.703 0.297t-0.297 0.703v6q0 0.281 0.156 0.531t0.406 0.375l3.438 1.719v5.875q-1.375-0.969-2.469-2.219-1.094-1.219-1.891-2.703t-1.203-3.141q-0.438-1.656-0.438-3.438 0-1.625 0.344-3.125t1-2.875h3.656q0.188 0 0.375-0.078t0.344-0.203l4-4q0.125-0.156 0.203-0.344t0.078-0.375v-2.406q0.938-0.281 1.953-0.438t2.047-0.156q1.656 0 3.203 0.359t2.922 1.047q-0.094 0.094-0.188 0.172t-0.188 0.172q-0.844 0.844-1.297 1.953t-0.453 2.297 0.453 2.297 1.297 1.953q0.875 0.844 1.969 1.297t2.281 0.453h0.281q0.188 0.594 0.375 1.688 0.156 1.063 0.219 2.547t-0.125 3.359q-0.156 1.844-0.719 4.031 0 0.031-0.016 0.078t-0.016 0.078q-0.938 1-2.094 1.75-1.125 0.781-2.391 1.328t-2.641 0.859q-1.406 0.281-2.875 0.281z",
  },
  alert: {
    size: 32,
    path:
      "M16 2.906l13.406 26.719h-26.813l13.406-26.719zM16 0q-0.531 0-1.016 0.344t-0.891 1.063l-13.656 27.219q-0.781 1.375-0.203 2.375t2.172 1h27.188q1.594 0 2.172-1t-0.203-2.375v0l-13.656-27.219q-0.406-0.719-0.891-1.063t-1.016-0.344v0 0zM18 26q0 0.844-0.578 1.422t-1.422 0.578-1.422-0.578-0.578-1.422 0.578-1.422 1.422-0.578 1.422 0.578 0.578 1.422zM16 22q-0.844 0-1.422-0.578t-0.578-1.422v-6q0-0.844 0.578-1.422t1.422-0.578 1.422 0.578 0.578 1.422v6q0 0.844-0.578 1.422t-1.422 0.578z",
  },
  ostrons: {
    size: 32,
    path:
      "M18.531 25.125q-0.531 0.531-1.656 0.906-1.125 0.406-2.172 0.094t-1.672-1.563-0.156-3.969q0.094-0.5 0.594-1.5t1.047-2.422 0.953-3.234q0.406-1.781 0.281-3.844 0-0.813-0.188-1.969-0.156-1.156-0.453-2.406t-0.734-2.5q-0.406-1.25-1-2.25 0.75 2.531 0.656 4.625-0.063 2.125-0.75 3.984t-1.875 3.547q-1.188 1.656-2.688 3.313-1.625 1.594-2.438 3.188-0.781 1.625-0.938 3.094t0.281 2.719q0.406 1.281 1.219 2.188-0.656 0.031-1.391-0.25t-1.078-0.563q-0.188-0.125 0.219 0.531 0.375 0.656 1.281 1.516t2.313 1.641 3.313 0.875q2.375 0.125 3.781-0.531 1.375-0.688 2.109-1.672t0.953-1.984q0.188-1 0.188-1.563v0zM21.406 2.25q-0.906 1.344-1.656 3t-1.156 3.375-0.375 3.375q0 1.656 0.625 2.938 0.375 1 1 2.406t1.141 2.969 0.797 3.094q0.25 1.563-0.063 2.813-0.656 2.531-1.938 3.313t-2.438 1.563q1.594 0.438 3.219 0.188 1.594-0.281 2.938-1.031t2.281-1.906q0.938-1.125 1.188-2.406 0.219-1.313-0.188-2.75t-1.078-2.766-1.391-2.422q-0.75-1.094-1.125-1.688-0.563-0.813-1.281-2.125t-1.156-3.094-0.406-4q0.063-2.219 1.063-4.844v0z",
  },
  corpus: {
    size: 32,
    path:
      "M16.173 0.533c-8.564 0-15.506 6.942-15.506 15.506s6.942 15.506 15.506 15.506c8.564 0 15.506-6.942 15.506-15.506s-6.943-15.506-15.506-15.506zM29.147 16.039c0 1.937-0.425 3.774-1.186 5.424l-10.901-18.368c6.752 0.457 12.087 6.077 12.087 12.944zM21.869 15.723c0 3.146-2.55 5.696-5.696 5.696s-5.696-2.55-5.696-5.696 2.549-5.696 5.696-5.696 5.696 2.55 5.696 5.696zM15.258 3.098l-10.611 18.902c-0.925-1.785-1.447-3.811-1.447-5.961-0.001-6.858 5.321-12.473 12.059-12.942zM16.173 29.013c-4.703 0-8.821-2.502-11.097-6.247l22.352-0.27c-2.239 3.895-6.442 6.517-11.255 6.517z",
  },
  darvo: {
    size: 32,
    path:
      "M16 32q-3.313 0-6.219-1.25-2.938-1.25-5.109-3.422t-3.422-5.109q-1.25-2.906-1.25-6.219t1.25-6.219q1.25-2.938 3.422-5.109t5.109-3.422q2.906-1.25 6.219-1.25t6.219 1.25q2.938 1.25 5.109 3.422t3.422 5.109q1.25 2.906 1.25 6.219t-1.25 6.219q-1.25 2.938-3.422 5.109t-5.109 3.422q-2.906 1.25-6.219 1.25zM1 15.906v0 0q0 1.938 0.469 3.719 0.469 1.813 1.328 3.406t2.078 2.906q1.219 1.344 2.719 2.344l0.031 0.031 1.938-0.469-4.344-18.781-2.875 0.656q-0.656 1.344-1 2.922t-0.344 3.234v0.031zM12.344 26.719q0.031 0.125 0.141 0.219t0.234 0.094q0.188 0 0.297-0.125t0.109-0.281v-0.094l-4.125-17.906q-0.031-0.125-0.141-0.203t-0.266-0.078-0.266 0.109-0.109 0.266v0.094zM15.906 1v0 0q-2.063 0-3.969 0.531-1.875 0.5-3.531 1.469t-3.031 2.313q-1.344 1.375-2.313 3l-0.031 0.063 10.406-2.375 0.281 1.156-1.75 0.375 4.313 18.688 1.75-0.406 0.25 1.156-9.281 2.156q1.5 0.781 3.25 1.234t3.656 0.453q1.875 0 3.625-0.438t3.313-1.266 2.875-1.984 2.344-2.594l0.031-0.031-8.344 1.844-0.25-1.156 5.969-1.375-3.125-14.031-6 1.344-0.25-1.156 5.969-1.344-0.781-3.5-5.969 1.375-0.25-1.156 8.906-2q-1.719-1.094-3.766-1.719t-4.297-0.625v0 0 0 0zM25.156 4.219l-1.375 0.313 4.188 18.719 1.031-0.25q0.875-1.531 1.344-3.344t0.469-3.75q0-1.781-0.406-3.438-0.375-1.656-1.109-3.141t-1.766-2.766q-1.063-1.281-2.344-2.313l-0.031-0.031z",
  },
  void: {
    size: 32,
    path:
      "M11.79 0.5c0 0 6.98 0.72 9.44 3.8s-1.030 7.7-2.050 9.14c-1.030 1.44-4.62 6.26-4.31 10.060s1.33 4.41 2.26 5.54c0.92 1.13 3.49 2.36 3.49 2.36s-4.52-0.51-5.13-0.72c-0.62-0.21-4.82-1.54-5.85-3.8s-1.64-4.31-0.31-7.29 5.24-6.060 6.36-7.7 2.16-2.67 1.85-5.34c-0.31-2.67-1.33-3.9-2.98-4.72s-2.77-1.33-2.77-1.33zM12.73 12.96l2.11-2.29c-0.4-0.33-0.68-0.58-0.78-0.73-0.51-0.72-1.54-1.23-1.13-2.87s1.33-2.77 1.33-2.77-3.8 3.8-2.26 7.29c0.21 0.47 0.45 0.93 0.73 1.37zM21.65 16.62c-0.5-0.6-1.19-1.27-1.94-1.94l-2.22 3.44c0.35 0.3 0.65 0.56 0.88 0.76 1.23 1.13 2.050 1.95 2.36 4.52s-0.82 5.65-0.82 5.65 2.77-2.98 3.18-4.93 0.61-5.040-1.44-7.5z",
  },
  grineer: {
    size: 32,
    path: "M14.544 14.176v-3.095h-8.334v10.001h8.334v-2.858h-2.858v-4.048zM7.401 0.842h18.335v30.479h-18.335l12.62-14.287-12.62-16.192z",
  },
  infested: {
    size: 32,
    path:
      "M11.068 14.998c0 0-0.972-0.723-0.826-1.101 0.146-0.377 1.734-2.147 2.477-2.752 0.742-0.604 1.725-1.715 2.202-1.651s0.303 0.986 0.299 1.331c-0.027 2.138-0.482 2.976-0.849 3.622-0.623 1.094-1.046 2.045-1.101 2.202s-0.275 0.55-0.275 0.55 0.446-0.554 0.826-0.55h4.457c0.379-0.003 0.826 0.55 0.826 0.55s-0.221-0.394-0.275-0.55c-0.053-0.157-0.478-1.106-1.101-2.202-0.367-0.646-0.822-1.484-0.849-3.622-0.004-0.346-0.178-1.267 0.299-1.331s1.459 1.047 2.202 1.651c0.742 0.604 2.331 2.374 2.477 2.752 0.146 0.377-0.826 1.101-0.826 1.101s3.092-1.626 3.027-2.202c-0.043-0.378-2.839-3.629-4.128-4.954-1.287-1.324-3.906-6.053-3.906-6.053s-2.564 4.73-3.853 6.053c-1.287 1.324-4.085 4.576-4.128 4.954-0.065 0.576 3.027 2.202 3.027 2.202zM27.897 21.541c-0.503-1.777-1.92-5.825-2.226-6.051-0.466-0.345-3.42 1.521-3.42 1.521s1.113-0.48 1.366-0.164c0.254 0.315 0.993 2.576 1.145 3.521s0.623 2.351 0.33 2.732c-0.294 0.381-1.005-0.23-1.302-0.407-1.838-1.092-2.336-1.905-2.713-2.546-0.637-1.087-1.247-1.929-1.356-2.054-0.109-0.125-0.339-0.513-0.339-0.513s0.256 0.663 0.064 0.99l-2.228 3.859c-0.187 0.33-0.89 0.439-0.89 0.439s0.451 0.005 0.614 0.037c0.163 0.032 1.198 0.14 2.457 0.147 0.743 0.005 1.696 0.030 3.562 1.075 0.302 0.17 1.186 0.479 1.004 0.924s-1.636 0.74-2.53 1.081c-0.894 0.341-3.221 0.831-3.621 0.769s-0.541-1.265-0.541-1.265-0.139 3.49 0.393 3.722c0.349 0.151 4.562-0.645 6.353-1.098 1.791-0.453 7.196-0.356 7.196-0.356s-2.813-4.583-3.316-6.362zM14.863 22.428l-2.228-3.859c-0.193-0.326 0.064-0.99 0.064-0.99s-0.23 0.388-0.339 0.513c-0.109 0.125-0.719 0.967-1.356 2.054-0.375 0.641-0.874 1.454-2.713 2.546-0.298 0.177-1.008 0.788-1.302 0.407s0.177-1.787 0.33-2.732c0.151-0.945 0.892-3.205 1.145-3.521 0.254-0.315 1.366 0.164 1.366 0.164s-2.954-1.865-3.42-1.521c-0.306 0.226-1.723 4.274-2.226 6.051s-3.29 6.41-3.29 6.41 5.378-0.144 7.169 0.309c1.791 0.453 6.005 1.25 6.353 1.098 0.531-0.231 0.393-3.722 0.393-3.722s-0.141 1.203-0.541 1.265c-0.4 0.062-2.727-0.428-3.621-0.769s-2.348-0.636-2.53-1.081c-0.182-0.445 0.702-0.755 1.004-0.924 1.865-1.045 2.818-1.071 3.562-1.075 1.26-0.009 2.293-0.115 2.457-0.147s0.614-0.037 0.614-0.037-0.703-0.11-0.89-0.441zM17.015 21.215c0.246-0.316 1.45-2.363 1.532-2.665 0.074-0.272 0.076-0.549-0.122-0.735-0.218-0.206-0.425-0.317-0.65-0.326-0.206-0.038-0.739-0.093-1.071-0.094-0.834-0.003-0.917 0.003-1.622 0-0.338-0.001-1.265 0.002-1.393 0.558-0.027 0.116-0.014 0.247 0.018 0.377 0.009 0.303 1.358 2.73 1.797 3.376 0.122 0.179 0.54 0.198 0.629 0.198 0.437 0 0.705-0.464 0.881-0.689z",
  },
  sentient: {
    size: 32,
    path:
      "M15.509 6.263c0.561-0.023 1.152-0.059 1.679 0.171 0.501 0.23 0.692 0.88 0.483 1.372-0.378 0.886-0.772 1.766-1.154 2.649-0.094 0.207-0.214 0.45-0.456 0.507-0.264 0.039-0.436-0.216-0.533-0.424-0.39-0.883-0.774-1.768-1.162-2.652-0.178-0.383-0.151-0.87 0.128-1.198 0.243-0.303 0.649-0.378 1.014-0.424zM12.356 7.982c0.256-0.086 0.557-0.031 0.753 0.158 0.241 0.217 0.297 0.551 0.398 0.844 0.098 0.333 0.251 0.661 0.24 1.016-0.009 0.502-0.206 1.013-0.579 1.356-0.916 0.752-1.745 1.637-2.314 2.684-0.426 0.783-0.674 1.697-0.51 2.587 0.198 1.102 0.849 2.060 1.59 2.874 0.482 0.526 1.022 0.994 1.594 1.419 0.573 0.508 0.957 1.251 0.988 2.021 0.054 0.706 0.111 1.413 0.167 2.119 0.010 0.201 0.026 0.422-0.080 0.602-0.060 0.119-0.227 0.106-0.329 0.057-0.162-0.102-0.283-0.254-0.419-0.385-0.521-0.506-1.086-0.964-1.674-1.389-1.331-1.023-2.553-2.197-3.57-3.535-0.526 0.31-1.039 0.641-1.573 0.936-0.389 0.184-0.821 0.365-1.259 0.301-0.333-0.131-0.652-0.3-0.968-0.469-0.112-0.045-0.070-0.184-0.007-0.253 0.195-0.233 0.473-0.374 0.739-0.511 0.774-0.375 1.546-0.753 2.321-1.126-0.366-0.63-0.665-1.302-0.844-2.009-1.839 0.131-3.679 0.261-5.518 0.394-0.322 0.019-0.669 0.060-0.968-0.091-0.137-0.059-0.214-0.236-0.12-0.364 0.282-0.461 0.578-0.915 0.904-1.346 0.404-0.402 0.999-0.556 1.555-0.579 1.346 0.018 2.692 0.051 4.039 0.072 0.089-0.622 0.284-1.224 0.541-1.796-0.569-0.144-1.14-0.284-1.709-0.425-0.361-0.086-0.709-0.232-1.016-0.44-0.225-0.154-0.444-0.351-0.522-0.622-0.131-0.381-0.276-0.759-0.377-1.149-0.039-0.137 0.112-0.221 0.226-0.229 0.323-0.036 0.637 0.076 0.938 0.178 1.111 0.386 2.222 0.769 3.333 1.154 0.93-1.344 2.073-2.531 3.324-3.579 0.222-0.176 0.43-0.388 0.706-0.478zM18.856 8.174c0.164-0.175 0.414-0.263 0.651-0.223 0.267 0.034 0.481 0.211 0.681 0.376 1.314 1.080 2.515 2.311 3.484 3.713 1.163-0.402 2.326-0.805 3.489-1.207 0.266-0.084 0.55-0.169 0.831-0.116 0.099 0.018 0.214 0.106 0.177 0.22-0.107 0.405-0.256 0.799-0.394 1.194-0.073 0.224-0.251 0.389-0.434 0.527-0.317 0.231-0.683 0.391-1.063 0.484-0.578 0.144-1.156 0.285-1.734 0.431 0.256 0.572 0.453 1.175 0.542 1.797 1.324-0.024 2.648-0.052 3.973-0.074 0.565 0.008 1.167 0.158 1.592 0.549 0.305 0.371 0.55 0.787 0.819 1.184 0.069 0.124 0.194 0.253 0.143 0.406-0.066 0.139-0.226 0.196-0.366 0.229-0.349 0.069-0.706 0.009-1.058-0.010-1.737-0.124-3.473-0.249-5.21-0.372-0.177 0.708-0.481 1.378-0.841 2.011 0.733 0.351 1.462 0.71 2.194 1.064 0.297 0.147 0.608 0.294 0.837 0.541 0.064 0.061 0.074 0.153 0.104 0.233-0.271 0.16-0.556 0.293-0.839 0.431-0.381 0.22-0.834 0.047-1.212-0.093-0.646-0.289-1.222-0.711-1.838-1.055-0.743 0.987-1.609 1.877-2.536 2.691-0.915 0.82-1.977 1.464-2.828 2.357-0.149 0.149-0.336 0.379-0.573 0.266-0.154-0.156-0.141-0.398-0.136-0.601 0.053-0.707 0.113-1.415 0.166-2.122 0.023-0.913 0.523-1.794 1.277-2.302 0.876-0.684 1.671-1.491 2.255-2.441 0.489-0.797 0.804-1.747 0.661-2.69-0.165-1.106-0.783-2.086-1.501-2.92-0.301-0.347-0.624-0.674-0.968-0.978-0.197-0.178-0.424-0.326-0.579-0.544-0.302-0.42-0.442-0.966-0.337-1.477 0.068-0.276 0.17-0.541 0.251-0.813 0.075-0.233 0.139-0.486 0.318-0.664zM15.707 14.954c0.236-0.082 0.503-0.059 0.724 0.054 0.579 0.294 1.156 0.595 1.736 0.889 0.142 0.075 0.309 0.175 0.333 0.351 0.017 0.187-0.154 0.311-0.301 0.387-0.579 0.297-1.159 0.594-1.738 0.892-0.267 0.149-0.606 0.159-0.878 0.017-0.592-0.302-1.184-0.607-1.776-0.911-0.146-0.076-0.317-0.202-0.299-0.388 0.031-0.207 0.244-0.301 0.409-0.388 0.599-0.296 1.183-0.624 1.789-0.904z",
  },
  invasion: {
    size: 32,
    path:
      "M2.781 30.5q0.625-0.281 1.688-0.563 1.031-0.25 2.141-0.406t2.078-0.25q0.969-0.063 1.438 0 0.25-0.531 0.266-0.875t0.641-0.344q0.594 0 0.609 0.531t0.297 1q2.781-0.125 5.109 0.563t3.141 0.969q0.75-0.969-0.234-2.156l-0.984-1.188 12.188-8.844 0.094-1.625q0.063-1.625 0.094-3.641t-0.063-3.828-0.438-2.156q-0.563-0.313-2.25-0.375t-3.609 0.031-3.672 0.281q-1.719 0.188-2.344 0.344-1.156 0.281-2.594 0.656t-2 1.188q-0.531 0.813 0.359 2.047t2.391 1.891q1.844 0.688 2.875-0.234t1.719-1.266q0.656-0.344 0.609 0.641t-0.328 1.172q-0.375 0.063-1.344 0.219t-2.109 0.391-2.203 0.547q-1.094 0.313-1.656 0.688-0.594 0.375-1.563 1.5-0.969 1.156-1.906 2.375t-1.625 2.156l-0.688 0.969 3.656-7h-1.125t-2.563-0.031-2.781-0.094-1.781-0.188q-0.875-0.281-1.391-1.375t-0.422-1.375q0.063-0.281 0.641-0.438l0.578-0.156-0.938-1.531-0.547 0.031t-0.984 1.188q-0.406 1.156 0.109 2.859l0.516 1.703 0.094 1.891t0.531 2.391q0.406 0.469 0.813 0.531l0.406 0.063-2.156 9.125 0.406-0.063t0.813 0.063v0zM4 13.75q-0.188-0.094-0.688-0.906-0.5-0.844-1.016-1.969t-0.922-2.344-0.406-2.063q0-1.75 2.063-2.922t3.125-1.047q0.656 0.875 1.031 2.594t0.5 3.5 0.031 3.188q-0.094 1.438-0.344 1.688-0.5 0.469-1.75 0.469t-1.625-0.188v0zM13.156 0.969q-1.375-0.344-3.141-0.125t-2.641 1.969q0.156 2.438 0.859 4.422t0.953 5.922q0.969 0.969 2.016 0.813t1.641-0.813q0.313-0.344 0.531-2.031 0.188-1.719 0.25-3.766t-0.063-3.891q-0.094-1.844-0.406-2.5v0zM13.781 1.594q1.531-1.031 3.078-0.953t2.391 0.641q0.469 1.031 0.313 2.344t-0.594 2.531q-0.469 1.219-2.047 1.375t-2.547-0.156q-0.438-0.656-0.438-2.484t-0.156-3.297v0zM21.094 1.594q0.813-0.719 2.891 0.422t2.297 1.703q0.188 0.563 0.203 1.344t-0.516 1.094q-0.5 0.313-2.844 0.516t-2.938-0.203q-0.313-0.563-0.109-2.375t1.016-2.5v0z",
  },
  orokin: {
    size: 32,
    path:
      "M29.938 28.938l-2.188 2.281-5.969-5.781q-1.313 0.969-2.922 1.516t-3.391 0.547q-1.531 0-2.938-0.406t-2.625-1.156l0.031 0.031-5.625 5.313-2.156-2.25 5.375-5.063q-1.281-1.375-2.016-3.188t-0.734-3.844v0q0-2.031 0.75-3.813 0.719-1.813 1.984-3.219t2.984-2.313 3.719-1.125v-5.656h3.125v5.75q1.875 0.344 3.5 1.25 1.594 0.938 2.781 2.313t1.844 3.125q0.688 1.75 0.688 3.688 0 1.781-0.578 3.406t-1.578 2.938l0.031-0.031zM15.469 25.625v0h0.031q1.5 0 2.875-0.484t2.5-1.328h-0.031l-4.781-4.469q-0.125 0.031-0.25 0.047t-0.281 0.016v0l-4.969 4.719q1.031 0.719 2.281 1.109t2.625 0.391v0 0 0 0zM9.563 23.375l4.563-4.344q-0.375-0.25-0.656-0.625t-0.406-0.813l-0.031-0.031h-6.313q0.125 1.75 0.875 3.234t1.969 2.547v0.031zM15.469 8.25q-1.75 0-3.281 0.625t-2.719 1.719-1.906 2.563q-0.75 1.469-0.844 3.156h6.313q0.25-0.813 0.906-1.328t1.531-0.516 1.531 0.516 0.875 1.328h6.344q-0.094-1.688-0.844-3.156-0.719-1.469-1.906-2.563t-2.719-1.719-3.281-0.625v0zM24.219 17.563h-6.313q-0.125 0.406-0.344 0.734t-0.5 0.578v0l4.688 4.156q1.031-1.063 1.703-2.453t0.766-2.984v-0.031z",
  },
  sortie: {
    size: 32,
    path:
      "M15.938 0.094l6.094 6.125-6.094 6.094-6.125-6.094zM7.656 8.281l6.125 6.125-6.125 6.125-6.125-6.125zM24.125 8.281l6.125 6.125-6.125 6.125-6.125-6.125zM9.125 31.844v-8.188l6.938-6.781 6.563 6.688v8.281l-6.563-6.688z",
  },
  voidtrader: {
    size: 32,
    path:
      "M28.906 27.281v-5.406l-9.813 9.813-2.656-3 9.813-10.844h3.063l-10.625 11.438 0.594 0.813 10.438-11.438h0.406v8.625h-1.219zM23.594 13.219h1.844l0.813 1.031 1.031-1.031h1.625l-2.656 2.813zM26.25 11.438l-0.813 1h-1.844l2.656-2.813 2.656 2.813h-1.625zM25.031 16.438h-2.063l-6.938-7.406-6.969 7.406h-2.031l5.5-6.219-2.656-2.594h2.469l1.438 1.406 2.25-2.219 2.031 2.219 1.438-1.406h2.438l-2.438 2.594zM18.281 6.813h-1.031l-1.219-1.406-1.25 1.406h-1l2.25-2.406zM16.031 3l-3.688 3.813h-2.469l5.938-6.438 6.125 6.625h-2.438zM2.938 13.219h1.844l0.813 1.031 1.031-1.031h1.625l-2.656 2.813zM5.594 11.438l-0.813 1h-1.844l2.656-2.813 2.656 2.813h-1.625zM5.781 17.844l9.844 10.844-2.688 3-9.813-9.813v5.406h-1.219v-8.625h0.406l10.438 11.438 0.625-0.813-10.656-11.438h3.063zM25.031 17.844l-9 10.031-9-10.031h2.031l6.969 7.844 7.156-7.844h1.844zM16.031 23.875l-5.531-5.813h1.844l0.719 1.703t2.969 1.703 2.969-1.703l0.719-1.703h1.813zM10.5 16.438l5.531-5.813 5.5 5.813h-1.813l-0.719-1.703t-2.969-1.703-2.969 1.703l-0.719 1.703h-1.844zM16.031 19.469q-1.313-0.031-1.578-1.125l-0.266-1.094h3.688l-0.281 1.109t-1.563 1.109v0zM13.375 17.031l0.375-1.422t2.281-1.359q1.875 0.031 2.266 1.406l0.391 1.375h-0.813l-0.172-1t-1.672-1-1.672 1l-0.172 1h-0.813zM17.875 31.688h-0.844l-1-1.188-1.25 1.188h-0.813l2.063-2z",
  },
  koneksi: {
    size: 32,
    path:
      "M11.844 26.625q-0.563 0.156-1.375 0.844t-2.844 2.438q-0.281-0.531-1.156-2.781t-1.438-5.516-0.406-7.234q0.188-3.938 2-7.906-0.313-0.375-2.047-1.156t-2.578-1.469q5.094 0.875 5.625-0.094t1.406-1.906q0.5 0.563 1 1.688l0.5 1.125 13.438 0.094 0.766-0.266t1.453-0.734q0.75 0.531 1.563 2.813 0.844 2.281 1.25 5.484t0.156 6.922q-0.25 3.75-1.656 7.25 0.656 0.063 1.578 0.625l0.922 0.563-3.906 0.313-1.313 2.094-0.25-0.891t-0.75-1.422q-0.25-0.25-2.063-0.438-1.781-0.219-3.891-0.344t-3.922-0.156-2.063 0.063v0zM15.344 8.25q-2.281-0.344-3.906 1.531-1.594 1.875-2.453 4.359t-0.922 4.797 0.75 2.844q0.906 0.219 2.375 0.5 1.469 0.25 3 0.516t2.875 0.453q1.375 0.188 2.094 0.25 1.469 0.125 3.578-0.656t3.859-4.469q1.281-5.281 0.984-7l-0.297-1.719-1.344 0.063t-3.234-0.031-3.922-0.406q-2.063-0.313-3.438-1.031v0z",
  },
  madurai: {
    size: 32,
    path:
      "M6.375 8.438l-1.641-0.734t-2.578-1.047q4.031-1.344 6.031-2.516l2-1.172-0.156 1.875q-0.125 1.875-0.203 4.203t0.016 4.359q0.094 2.063 0.594 2.406 1.625-0.156 3.844-1.625 2.188-1.5 4.266-3.25t3.641-3.281 1.906-1.781q0.469-0.281 1.438-0.031t1.922 0.719 1.703 1q0.719 0.5 0.688 0.75-2.719 0.375-6.25 2.156-3.563 1.75-7.125 4.516t-6.75 6.391q-3.188 3.594-5.125 7.656 0.813-3.875 1.188-7.563 0.375-3.719 0.5-6.609t0.125-4.672l-0.031-1.75z",
  },
  naramon: {
    size: 32,
    path:
      "M5.719 17.781l-1.344 2.688-0.391-1.5t-0.859-2.125q-0.469-0.5-1.297-1.688t-0.578-1.125h25.438l1.031-2.5q0.25 1.031 0.516 1.938t0.609 1.781l-0.063-0.188q0.594 0.906 1.047 1.344t0.297 1.375h-24.406z",
  },
  penjaga: { size: 32, path: "M5.438 3.906l7.156-2.781-0.219 25.156 3.625 1.688-7.469 3 0.094-25.063zM20.594 13.688l5.75-2.438 0.219 5.531-5.875 2.25z" },
  unairu: {
    size: 32,
    path:
      "M5.875 16.094q-0.844 0.313-1.609 2.078t-0.109 11.359q-1.406-2.844-2.094-5.375-0.656-2.563-0.625-4.875t0.781-4.469 2.156-4.219q1.344-2 4.063-3.563 2.688-1.531 5.438-2.438t4.875-1.125q2.156-0.188 2.375 0.469-7.469 3.156-7.844 5.188t0.438 2.656q1.75 0.875 4.688 1.656 2.969 0.75 5.797 1.313t4.922 0.906l2.063 0.313-2.344-0.344q-2.375-0.344-6.047-0.563t-8.172-0.094q-4.5 0.156-8.75 1.125v0z",
  },
  vazarin: {
    size: 32,
    path:
      "M1.375 1.438q3.969 2.281 7.813 5.656 3.844 3.406 7.016 7.313t5.453 8.094q2.25 4.219 3.125 8.125 0.531 0.063 1.938-3.125t2.406-7.766 0.906-9.672q-0.063-5.094-2.5-8.844-1-0.031-4.656 0-3.625 0.031-7.891 0.078t-8.172 0.078q-3.906 0.063-5.438 0.063v0zM15.313 7.875h2.188q1.563-0.031 3.281-0.047t3.188-0.016q1.469-0.031 1.875 0 0.969 1.531 1 3.594t-0.359 3.922-0.984 3.172q-0.563 1.281-0.781 1.281-0.344-1.625-1.25-3.313-0.906-1.719-2.188-3.313t-2.813-2.969-3.156-2.313v0z",
  },
  zenurik: {
    size: 32,
    path:
      "M5.469 12.969q-0.75-0.75-2.094-2.313t-2.5-3q5.156-0.781 9-0.469 3.813 0.313 6.406 1.063t4 1.625q1.406 0.844 1.688 1.125-2.906-0.344-5.406-0.469-2.5-0.094-4.547 0.109t-3.703 0.766q-1.625 0.563-2.844 1.563v0zM14.5 22.969q-0.781-0.75-2.125-2.313t-2.5-3q5.156-0.781 9-0.469 3.813 0.313 6.406 1.078t4 1.609 1.688 1.156q-2.906-0.375-5.406-0.5-2.469-0.094-4.531 0.109t-3.719 0.766q-1.625 0.563-2.813 1.563v0z",
  },
  aura: {
    size: 32,
    path:
      "M12.8 20l3.1-3.3 3.3 3.1c1-0.9 1.7-2.2 1.7-3.7 0-2.7-2.2-5-5-5s-5 2.2-5 5c0.1 1.5 0.8 2.9 1.9 3.9zM16 28.5c-2.6 0-5-0.8-7-2.2l-1 1.1c2.3 1.6 5 2.5 8 2.5 3.2 0 6.2-1.1 8.6-2.9l-1.1-1c-2.1 1.6-4.7 2.5-7.5 2.5zM29.8 13.6c-1.2-6.6-6.9-11.6-13.8-11.6-7 0-12.9 5.2-13.8 12-0.1 0.7-1.6 1.9-1.6 1.9s1.5 1.3 1.6 1.9c0.4 3.4 2.1 6.4 4.6 8.6l1-1.1c-2.6-2.3-4.2-5.6-4.2-9.3-0.1-6.9 5.5-12.5 12.4-12.5s12.5 5.6 12.5 12.5c0 3.5-1.5 6.7-3.8 9l1.1 1c2.1-2.1 3.6-4.9 4.1-7.9 0.1-0.7 1.6-2 1.6-2s-1.6-1.7-1.7-2.5zM15.9 7.6c-4.6 0-8.4 3.8-8.4 8.4 0 2.6 1.2 4.9 3 6.4l0.9-0.9c-1.5-1.3-2.5-3.2-2.5-5.4-0.1-4 3.1-7.1 7-7.1s7.1 3.2 7.1 7.1c0 2.1-0.9 3.9-2.3 5.2l0.9 0.8c1.6-1.5 2.6-3.7 2.6-6.1 0.1-4.6-3.7-8.4-8.3-8.4zM26.9 15.9c0-6-4.9-10.9-11-10.9-6 0-10.9 4.9-10.9 10.9 0 3.3 1.5 6.3 3.8 8.3l0.9-0.9c-2.1-1.8-3.4-4.4-3.4-7.4 0-5.4 4.3-9.7 9.7-9.7s9.7 4.3 9.7 9.7c0 2.8-1.2 5.3-3 7.1l0.9 0.9c2-2 3.3-4.8 3.3-8zM10 25.2c1.7 1.1 3.7 1.7 5.9 1.7 2.4 0 4.6-0.8 6.4-2.1l-6.3-6.3-1.9 2.1-1.5 1.6-0.8 0.9-0.1 0.1-0.8 0.9-0.9 1.1z",
  },
  exilus: {
    size: 32,
    path:
      "M5.45 15.95c0-3.97 4.13-8.26 4.13-8.26s0.32-0.64 0.16-1.11c-0.16-0.48-1.11-0.48-1.75-0.48s-1.11-0.64-2.22-0.79c-1.11-0.16-3.020 1.75-2.86 2.38 0.16 0.64 1.75 1.43 1.59 2.22s-1.43 1.91-1.91 2.38-1.59 0.96-1.9 1.6c-0.32 0.64-0.32 2.7 0 3.34s1.75 0.64 2.38 0.95 1.11 1.43 1.11 2.070c0 0.64-1.11 1.75-1.11 2.86s1.91 3.020 2.38 3.020 1.75-1.59 2.38-1.59c0.64 0 3.020 2.54 3.18 2.070 0.16-0.48 0-2.86-0.79-3.97s-4.77-2.71-4.77-6.69zM31.32 13.89c-0.32-0.64-1.43-1.11-1.91-1.59s-1.75-1.59-1.91-2.38c-0.16-0.79 1.43-1.59 1.59-2.22 0.16-0.64-1.75-2.54-2.86-2.38s-1.59 0.79-2.22 0.79c-0.64 0-1.59 0-1.75 0.48s0.16 1.11 0.16 1.11 4.13 4.29 4.13 8.26-3.97 5.56-4.77 6.67-0.95 3.5-0.79 3.97c0.16 0.48 2.54-2.070 3.18-2.070s1.91 1.59 2.38 1.59 2.38-1.91 2.38-3.020-1.11-2.22-1.11-2.86c0-0.64 0.48-1.75 1.11-2.070s2.070-0.32 2.38-0.95c0.33-0.63 0.33-2.69 0.010-3.33zM15.97 7.7v0c-0.010 0-0.010 0-0.010 0s-0.010 0-0.010 0v0c-1.13 0.060-4.11 3.66-4.42 4.6-0.32 0.95-0.95 1.59 0 2.070s2.070-0.16 2.38-0.48 1.27-2.070 1.75-2.070c0.080 0 0.19-0.010 0.3-0.030 0.12 0.020 0.22 0.030 0.3 0.030 0.48 0 1.43 1.75 1.75 2.070s1.43 0.95 2.38 0.48c0.95-0.48 0.32-1.11 0-2.070-0.32-0.94-3.29-4.55-4.42-4.6zM15.97 15v0c-0.010 0-0.010 0-0.010 0s-0.010 0-0.010 0v0c-1.13 0.060-4.11 3.66-4.42 4.6-0.32 0.95-0.95 1.59 0 2.070s2.070-0.16 2.38-0.48 1.27-2.070 1.75-2.070c0.080 0 0.19-0.010 0.3-0.030 0.12 0.020 0.22 0.030 0.3 0.030 0.48 0 1.43 1.75 1.75 2.070s1.43 0.95 2.38 0.48c0.95-0.48 0.32-1.11 0-2.070-0.32-0.94-3.29-4.54-4.42-4.6z",
  },
  impact: {
    size: 32,
    path:
      "M8.9 1.76v1.74c0 0.22 0.090 0.42 0.25 0.57l5.26 4.73c0.31 0.28 0.85 1.21 0.57 1.52l-0.41 0.61-3.24 3.040-2.030 1.64-8.73 9.71c-0.11 0.13-0.18 0.28-0.19 0.45-0.050 0.61-0.14 2.14 0.020 2.78 0.2 0.81 0.81 1.62 1.22 2.030s2.23 0.61 2.84 0.2c0.61-0.41-0.2-1.82 0.61-2.23s7.29-7.7 7.7-8.1c0.41-0.41 1.42-2.63 2.23-3.44s2.84-2.63 2.84-2.63 0.61-0.61 1.62 0.41c0.82 0.82 4.56 4.96 5.95 6.5 0.29 0.32 0.78 0.34 1.090 0.040l4.97-4.81c0.3-0.29 0.31-0.76 0.030-1.060l-13.060-14.21c-0.14-0.16-0.35-0.25-0.56-0.25h-8.22c-0.42 0-0.76 0.34-0.76 0.76z",
  },
  physical: {
    size: 32,
    path:
      "M0.98 11.030c-0.51 1.54-0.69 3.19 1.75 6.62 2.19 3.080 5.83 5.11 6.87 5.44 1.81 0.56 3.37 0.060 3.75 0s0.19-0.56 0.19-0.56-1.46 0.15-2.37-0.25c-1.56-0.69-2.69-1.5-4.44-3.18-1.46-1.41-3-3.81-3.18-5.060-0.19-1.25-0.32-1.75-0.060-2.19 0.25-0.44 0.87-0.69 1.56-0.5s0.94 0.19 0.87-0.060c-0.060-0.25-1.5-1.31-2.43-1.31s-2.32 0.49-2.51 1.050zM24.63 19.65c0.16-0.14 0.23-0.36 0.21-0.61-2.61-3.39-5.51-7.13-5.51-7.13s-0.61-0.4-0.88-0.33c-0.27 0.070-0.54 0.21-0.54 0.21-0.33 0.27-0.46 0.68-0.12 1.15 0.19 0.25 3.38 3.73 6.25 6.84 0.23 0.040 0.44 0 0.59-0.13zM26.070 21.3c-0.13 0.11-0.2 0.26-0.21 0.44 1.59 1.72 2.78 3 2.78 3s0.2 0.060 0.34 0 0.13-0.14 0-0.34c-0.040-0.060-1.1-1.43-2.49-3.24-0.16 0-0.31 0.040-0.42 0.14zM23.91 16.39c-0.16 0.2-0.2 0.18-0.17 0.32 0.14 0.060 0.32-0.19 0.61-0.32 1.95-1.39 3.62-2.070 4.040-1.58 0.53 0.63-1.12 2.88-3.68 5.040s-5.050 3.4-5.58 2.77c-0.39-0.46 0.41-1.81 1.88-3.36 0.25-0.29 0.55-0.54 0.57-0.73-0.14-0.060-0.19-0.020-0.41 0.16-2.61 2.51-4.040 5-3.28 5.9 0.88 1.040 4.35-0.45 7.76-3.33s5.47-6.050 4.59-7.090c-0.75-0.89-3.43 0.1-6.33 2.22zM10.8 5.43v0.75c0 0.1 0.040 0.18 0.11 0.25l2.27 2.040c0.13 0.12 0.37 0.52 0.25 0.66l-0.18 0.26-1.4 1.31-0.88 0.71-3.77 4.2c-0.050 0.060-0.080 0.12-0.080 0.19-0.020 0.26-0.060 0.92 0.010 1.2 0.090 0.35 0.35 0.7 0.53 0.88s0.96 0.26 1.23 0.090-0.090-0.79 0.26-0.96c0.35-0.18 3.15-3.33 3.33-3.5 0.18-0.18 0.61-1.14 0.96-1.49s1.23-1.14 1.23-1.14 0.26-0.26 0.7 0.18c0.35 0.35 1.97 2.14 2.57 2.81 0.13 0.14 0.34 0.15 0.47 0.020l2.15-2.080c0.13-0.13 0.13-0.33 0.010-0.46l-5.64-6.14c-0.060-0.070-0.15-0.11-0.24-0.11h-3.55c-0.19 0-0.34 0.15-0.34 0.33z",
  },
  puncture: {
    size: 32,
    path:
      "M17.89 19.22c0.38-0.32 0.54-0.84 0.49-1.41-6.050-7.84-12.76-16.51-12.76-16.51s-1.41-0.92-2.030-0.76c-0.62 0.16-1.24 0.48-1.24 0.48-0.77 0.63-1.070 1.57-0.28 2.65 0.43 0.59 7.82 8.63 14.47 15.83 0.51 0.11 1 0.020 1.35-0.28zM21.23 23.020c-0.29 0.25-0.46 0.61-0.49 1.020 3.68 3.98 6.43 6.94 6.43 6.94s0.47 0.15 0.78-0.010c0.31-0.16 0.31-0.32-0.010-0.78-0.1-0.15-2.54-3.31-5.76-7.49-0.37 0-0.7 0.1-0.95 0.32zM16.21 11.66c-0.38 0.46-0.47 0.41-0.39 0.75 0.32 0.14 0.74-0.43 1.41-0.75 4.52-3.21 8.38-4.8 9.35-3.65 1.22 1.45-2.59 6.67-8.51 11.67s-11.69 7.87-12.91 6.42c-0.9-1.070 0.94-4.2 4.35-7.77 0.57-0.66 1.28-1.26 1.32-1.7-0.32-0.14-0.44-0.040-0.96 0.38-6.030 5.82-9.34 11.58-7.59 13.66 2.030 2.4 10.070-1.050 17.96-7.71s12.66-14.010 10.63-16.41c-1.74-2.070-7.93 0.2-14.66 5.11z",
  },
  slash: {
    size: 32,
    path:
      "M1.81 2.98c-1.18 3.57-1.59 7.38 4.050 15.33 5.060 7.13 13.49 11.83 15.91 12.58 4.19 1.3 7.81 0.14 8.68 0s0.43-1.3 0.43-1.3-3.38 0.35-5.49-0.58c-3.61-1.59-6.22-3.47-10.27-7.37-3.39-3.27-6.94-8.82-7.37-11.71s-0.73-4.060-0.15-5.070c0.58-1.010 2.020-1.59 3.61-1.16s2.17 0.43 2.020-0.14c-0.14-0.58-3.46-3.040-5.63-3.040s-5.35 1.16-5.79 2.46z",
  },
  cold: {
    size: 32,
    path:
      "M30.4 24.28l-1.94-4.57c-0.050-0.12-0.19-0.18-0.32-0.14l-2.41 0.91c-0.070 0.030-0.16 0.020-0.22-0.020l-0.060-0.040c-0.16-0.1-0.15-0.34 0.020-0.43l1.76-0.95c0.17-0.090 0.18-0.33 0.020-0.43l-0.38-0.24c-0.070-0.040-0.15-0.050-0.22-0.020l-2.52 0.95c-0.070 0.030-0.16 0.020-0.22-0.020l-1.99-1.29c-0.010 0-0.010-0.010-0.020-0.010l1.3-1.98-1.26-1.9 1.72-1.12c0.070-0.040 0.15-0.050 0.22-0.020l2.52 0.95c0.070 0.030 0.16 0.020 0.22-0.020l0.38-0.24c0.16-0.1 0.15-0.34-0.020-0.43l-1.76-0.95c-0.17-0.090-0.18-0.33-0.020-0.43l0.060-0.040c0.070-0.040 0.15-0.050 0.22-0.020l2.41 0.91c0.13 0.050 0.27-0.010 0.32-0.14l1.94-4.57c0.070-0.16-0.050-0.34-0.22-0.35l-4.96-0.1c-0.13 0-0.25 0.1-0.25 0.23l-0.16 2.57c0 0.080-0.050 0.15-0.11 0.19l-0.060 0.040c-0.16 0.1-0.37 0-0.38-0.19l-0.14-2c-0.010-0.19-0.23-0.29-0.38-0.19l-0.38 0.24c-0.070 0.040-0.11 0.12-0.11 0.19l-0.16 2.69c0 0.080-0.050 0.15-0.11 0.19l-1.74 1.13-0.82-1.23 0.45-2.040-1.41 1.3h-2.23v-2.11c0-0.080 0.040-0.15 0.1-0.2l2.13-1.57c0.060-0.050 0.1-0.12 0.1-0.2v-0.44c0-0.19-0.2-0.3-0.36-0.21l-1.72 0.95c-0.16 0.090-0.36-0.030-0.36-0.21v-0.070c0-0.080 0.040-0.15 0.1-0.2l2.040-1.5c0.11-0.080 0.13-0.23 0.060-0.33l-2.76-4.050c-0.1-0.14-0.31-0.14-0.41 0l-2.73 4.040c-0.070 0.11-0.050 0.26 0.060 0.33l2.040 1.5c0.060 0.050 0.1 0.12 0.1 0.2v0.070c0 0.19-0.2 0.3-0.36 0.21l-1.72-0.95c-0.16-0.090-0.36 0.030-0.36 0.21v0.44c0 0.080 0.040 0.15 0.1 0.2l2.13 1.57c0.060 0.050 0.1 0.12 0.1 0.2v2.15h-2.11l-1.41-1.3 0.42 1.91-0.89 1.33-1.87-1.21c-0.070-0.040-0.11-0.12-0.11-0.19l-0.16-2.69c0-0.080-0.050-0.15-0.11-0.19l-0.38-0.24c-0.16-0.1-0.37 0-0.38 0.19l-0.14 2c-0.010 0.19-0.23 0.29-0.38 0.19l-0.060-0.040c-0.070-0.040-0.11-0.12-0.11-0.19l-0.16-2.57c-0.010-0.13-0.12-0.24-0.25-0.23l-4.96 0.1c-0.18 0-0.29 0.18-0.22 0.35l1.94 4.57c0.050 0.12 0.19 0.18 0.32 0.14l2.41-0.91c0.070-0.030 0.16-0.020 0.22 0.020l0.060 0.040c0.16 0.1 0.15 0.34-0.020 0.43l-1.78 0.91c-0.17 0.090-0.18 0.33-0.020 0.43l0.38 0.24c0.070 0.040 0.15 0.050 0.22 0.020l2.52-0.95c0.070-0.030 0.16-0.020 0.22 0.020l1.85 1.2-0.95 1.44-1.73 0.47 1.8 0.64 0.83 1.24c-0.010 0.010-0.030 0.010-0.040 0.020l-1.99 1.29c-0.070 0.040-0.15 0.050-0.22 0.020l-2.52-0.95c-0.070-0.030-0.16-0.020-0.22 0.020l-0.38 0.24c-0.16 0.1-0.15 0.34 0.020 0.43l1.76 0.95c0.17 0.090 0.18 0.33 0.020 0.43l-0.060 0.040c-0.070 0.040-0.15 0.050-0.22 0.020l-2.41-0.91c-0.13-0.050-0.27 0.010-0.32 0.14l-1.94 4.57c-0.070 0.16 0.050 0.34 0.22 0.35l4.96 0.1c0.13 0 0.25-0.1 0.25-0.23l0.16-2.57c0-0.080 0.050-0.15 0.11-0.19l0.060-0.040c0.16-0.1 0.37 0 0.38 0.19l0.14 2c0.010 0.19 0.23 0.29 0.38 0.19l0.38-0.24c0.070-0.040 0.11-0.12 0.11-0.19l0.16-2.69c0-0.080 0.050-0.15 0.11-0.19l1.99-1.29c0.020-0.010 0.040-0.030 0.050-0.050l0.86 1.3-0.45 2.040 1.41-1.3h2.23v2.1c0 0.080-0.040 0.15-0.1 0.2l-2.13 1.57c-0.060 0.050-0.1 0.12-0.1 0.2v0.44c0 0.19 0.2 0.3 0.36 0.21l1.72-0.95c0.16-0.090 0.36 0.030 0.36 0.21v0.070c0 0.080-0.040 0.15-0.1 0.2l-2.040 1.5c-0.11 0.080-0.13 0.23-0.060 0.33l2.73 4.040c0.1 0.14 0.31 0.14 0.41 0l2.73-4.040c0.070-0.11 0.050-0.26-0.060-0.33l-2.040-1.5c-0.060-0.050-0.1-0.12-0.1-0.2v-0.070c0-0.19 0.2-0.3 0.36-0.21l1.72 0.95c0.16 0.090 0.36-0.030 0.36-0.21v-0.44c0-0.080-0.040-0.15-0.1-0.2l-2.13-1.57c-0.060-0.050-0.1-0.12-0.1-0.2v-2.1h2.11l1.41 1.3-0.42-1.91 0.86-1.3c0.010 0.010 0.020 0.020 0.040 0.030l1.99 1.29c0.070 0.040 0.11 0.12 0.11 0.19l0.16 2.69c0 0.080 0.050 0.15 0.11 0.19l0.38 0.24c0.16 0.1 0.37 0 0.38-0.19l0.14-2c0.010-0.19 0.23-0.29 0.38-0.19l0.060 0.040c0.070 0.040 0.11 0.12 0.11 0.19l0.16 2.57c0.010 0.13 0.12 0.24 0.25 0.23l4.96-0.1c0.23 0 0.35-0.18 0.28-0.34zM18.47 19.55h-4.73l-2.36-3.55 2.36-3.55h4.73l2.36 3.55-2.36 3.55zM15.24 15.37l-0.16 0.23c-0.17 0.24-0.17 0.57 0 0.81l0.16 0.23c0.13 0.19 0.35 0.31 0.59 0.31h0.55c0.24 0 0.46-0.12 0.59-0.31l0.16-0.23c0.17-0.24 0.17-0.57 0-0.81l-0.16-0.23c-0.13-0.19-0.35-0.31-0.59-0.31h-0.55c-0.23 0-0.45 0.11-0.59 0.31z",
  },
  electricity: {
    size: 32,
    path:
      "M13.38 0.4h9.030c0.25 0 0.43 0.26 0.33 0.49l-4.5 11.34c-0.090 0.24 0.080 0.49 0.33 0.49h7.21c0.3 0 0.47 0.35 0.28 0.59l-14.64 17.76c-0.24 0.29-0.7 0.070-0.63-0.3l3.030-14.85c0.040-0.22-0.12-0.43-0.34-0.43l-7.6-0.19c-0.27-0.010-0.43-0.29-0.31-0.53l7.49-14.18c0.060-0.12 0.19-0.19 0.32-0.19z",
  },
  heat: {
    size: 32,
    path:
      "M3.9 10.9c2.3 0.2 2.71 1.090 3.7 2.8 1.16 2.020 0.95 4.95 1.4 5.7 0.6 1 1 1.5 1.4-0.6 0.1-0.53-0.66-2.23 0.1-5.8s2.3-6.29 5.22-8.89 4-3.14 4.44-3.35 2.27-0.32 2.27-0.32-1.19 0.87-1.41 1.62-1.080 2.81-0.65 5.95 2.81 6.060 4.33 8.33 2.49 3.9 1.95 6.71-3.46 7.030-4.76 7.68-2.69 0.47-2.69 0.47 0.6-1.6 1.28-3.060c0.74-1.6 1.65-4.27 2.72-5.64-1.23 0.53-2 0.5-3.9 2.2 0.6-2.9-0.33-4.25-0.33-4.25s-0.97-2.38-2.38-2.92c-1.030-0.4-2.72-2.080-1.58 0.17 0.5 0.98 0.18 3.29-0.15 4.81s-1.84 1.62-2.38 2.49-0.76 1.41-0.54 2.6 1.19 3.57 1.19 3.57-2.93-0.44-4.34-2.17-3.99-3.52-3.49-6.4c0.48-2.77 0.5-4.87 0.14-7.23-0.24-1.57-0.94-2.37-1.54-4.47z",
  },
  toxin: {
    size: 32,
    path:
      "M29.25 23.12c-0.020 0-0.060 0-0.090-0.010-1.58 0.19-3.58-0.81-4.68 0.69-0.24 0.4-0.18 0.78-0.010 1.18 0.010 0.030 0.030 0.070 0.050 0.1 0.67 1.42 0.37 3.11 1.86 4.010 0.010 0.010 0.030 0.020 0.060 0.030 0.23 0.090 1.060 0.3 1.34-0.43 0.32-0.84-0.45-1.25 0.5-2.2 0.35-0.35 1.12 0.31 1.6-0.2 0.47-0.5 1.080-1.73 0.9-2.3-0.020-0.030-0.090-0.74-1.53-0.87zM31.37 8.33c-0.2-0.5-0.6-0.8-1.2-1-0.7-0.2-0.1-0.9-0.3-1.4-0.1-0.5-0.5-0.9-1.1-1.1-0.4-0.070-0.8 0-1.11 0.21-0.030 0.020-0.050 0.040-0.080 0.060-0.11 0.14-0.31 0.24-0.32 0.41 0.020 0.62-0.28 1.12-0.8 1.51-0.040 0.020-0.070 0.040-0.1 0.060-0.29 0.15-0.62 0.27-0.98 0.36-0.4 0.1-1 0.5-0.51 0.97 0.010 0.020 0.030 0.060 0.050 0.080 0.76 2.44 3.26 1.44 5.15 1.44 0.7 0 1.5-0.7 1.3-1.6zM6.76 24.16c-0.21-0.080-0.5-0.24-0.78-0.35-0.080-0.050-0.17-0.1-0.26-0.15-0.2-0.11-0.41-0.18-0.62-0.090-0.16 0.060-0.28 0.19-0.4 0.33-0.030 0.030-0.040 0.050-0.050 0.060-0.83 0.95-1.93 0.65-2.96 0.71-0.020 0.020-0.050 0.030-0.080 0.050-0.12 0.1-0.23 0.24-0.31 0.42-0.2 0.46-0.38 1.21-0.070 1.84 0.020 0.030 0.030 0.070 0.050 0.1 0.24 0.32 0.54 0.32 0.85 0.38 0.040 0 0.070 0 0.1-0.010 0.18-0.020 0.36 0 0.52 0.1 0.020 0.010 0.050 0.030 0.070 0.050 0.060 0.18 0.19 0.33 0.3 0.47 0.020 0.020 0.040 0.050 0.060 0.080 0.050 0.1 0.070 0.23 0.1 0.35 0.010 0.060 0.040 0.14 0.060 0.2 0.17 0.2 0.37 0.5 0.74 0.42 0.060 0.010 0.13 0.010 0.2 0.020 0.27 0.010 0.57-0.010 0.91-0.070 0.020 0 0.060-0.010 0.12-0.020 0.19-0.040 0.32-0.1 0.41-0.18 0.020-0.020 0.050-0.050 0.060-0.070 0.24-1.2 0.34-2.29 0.68-3.49 0.010-0.030 0.020-0.070 0.030-0.1 0.020-0.060 0.040-0.12 0.070-0.17 0.010-0.020 0.030-0.060 0.040-0.090 0.080-0.18 0.16-0.35 0.24-0.53 0.010-0.020 0.010-0.040 0.010-0.060 0.030-0.090 0-0.17-0.090-0.2zM2.16 9c0.020 0 0.040 0 0.070 0.010 0.090 0.020 0.29 0.020 0.39 0.050 1.1-0.12 2.6 0.58 3.52-0.36 0.010-0.020 0.030-0.030 0.050-0.050 0.39-0.42 0.7-0.89 0.63-1.51-0.1-0.1-0.3-0.2-0.42-0.38-0.030-0.020-0.060-0.050-0.080-0.070-0.83-0.75-1.18-2.030-2-2.84-0.6-0.5-1.5-0.4-1.9 0.3-0.4 0.6 0.3 1.3-0.23 1.89-0.030 0-0.070-0.010-0.1 0-0.83-0.030-1.66 0.74-1.56 1.7 0.1 0.5 0.3 1.1 0.9 1.2 0.24 0.010 0.48 0.030 0.73 0.060zM23.88 15.34c0-0.22 0-0.42-0.020-0.58 0-0.030-0.010-0.070-0.010-0.1-0.030-0.37-0.010-0.73 0.11-1.1 0.020-0.020 0.040-0.050 0.060-0.070 0.010-0.030 0.030-0.050 0.040-0.060 1.11 0.8 0.31 2.39 1.11 3.39 0.1 0.1 0.4 0.2 0.5 0.1 0.9-1.6 0.7-3.69-0.27-5.23-0.020-0.040-0.030-0.070-0.050-0.1-0.58-1.15-1.28-2.19-1.99-3.21-0.030-0.040-0.050-0.070-0.070-0.1-0.17-0.24-0.34-0.47-0.53-0.72-2.33-3.040-5.59-3.55-9.13-3.21-3.66 0.36-7.97 4.95-8.71 8.5-0.090 0.44-0.19 1.46-0.14 2.28 0 0.020 0 0.040 0 0.060 0.040 0.24 0.040 0.54 0.14 0.74 0.3 0.1 0.4-0.2 0.44-0.37 0.010-0.020 0.020-0.040 0.030-0.060 0.37-0.85 0.21-2 0.84-2.84 0.010-0.010 0.030-0.030 0.080-0.070 0.050-0.030 0.1-0.060 0.15-0.080 0.040-0.010 0.070-0.010 0.1-0.020 0.030 0 0.040 0 0.040 0.010 0.18 0.030 0.13 0.68 0.010 1.42 0 0.020-0.010 0.050-0.010 0.070-0.13 1.27-0.7 2.3-1.42 3.27-0.020 0.030-0.030 0.040-0.040 0.060-1.31 1.41-1.11 3.6 0.28 4.81 0.020 0.020 0.040 0.040 0.060 0.050 1.1 1.020 2.62 1.87 3.55 1.5 1.72-0.69 1.99-0.28 2 1.28 0.010 0.77-0.34 1.65 0.41 2.3 0.53-0.17 0.54-0.61 0.63-1.060-0.010-0.91 0.1-1.94 0.97-1.81 0.27 0.040 0.42 0.2 0.51 0.42 0 0.54-0.010 1.090 0 1.63 0 0.25-0.070 0.68 0.19 0.84 0.080 0.050 0.16 0.060 0.23 0.040 0.15 0.050 0.28 0.030 0.38-0.050 1.44-0.61-0.16-2.24 1.12-2.77 0.1 0.040 0.2 0.070 0.3 0.080 0.68 0.76-0.32 1.92 0.57 2.59 0.87 0.010 0.58-0.83 0.74-1.4 0.010-0.46 0.1-0.9 0.39-1.13 0.18 0.010 0.36 0.020 0.53 0.020 0.12 0.020 0.24 0.030 0.37 0.050 0.020 0.020 0.040 0.030 0.060 0.050 0.11 0.59-0.020 1.31 0.12 1.91 0.010 0.29 0.080 0.59 0.32 0.71 0.080 0.040 0.16 0.050 0.23 0.050 0.14 0.11 0.29 0.050 0.38-0.11 0.020-0.010 0.030-0.020 0.040-0.030 0.010 0 0.010 0.010 0.020 0.010 0.020-0.020 0.030-0.030 0.040-0.050 0.010-0.010 0.030-0.020 0.040-0.030 0 0 0 0 0 0s0 0 0 0c0.010-0.010 0.020-0.020 0.030-0.020 0.030-0.030 0.050-0.060 0.050-0.090 0.82-1.13-0.45-2.8 0.78-3.8 0.4 0 0.8 0 1.2 0 0.040 0 0.080 0 0.1 0 0.39 0.050 0.81 0.070 1.19-0.010 0.040-0.010 0.070-0.020 0.1-0.030 1.060-0.55 2.14-1.55 2.55-2.7 0.010-0.020 0.010-0.040 0.020-0.060 0.44-1.14 0.27-2.43-0.69-3.16-0.050-0.030-0.070-0.040-0.090-0.050-0.68-0.49-0.88-1.19-0.98-1.96v0zM10.71 18.91c-1.63 0.83-2.74-0.11-2.69-2.59 0.1-0.8 0.27-1.24 0.9-1.4 0.070-0.050 1.8-0.9 2.59-1.1 0.76-0.19 2.38 0.4 2.49 1.15 0.21 1.32-2.31 3.44-3.29 3.94zM17.66 22.12c-0.020 0.010-0.060 0.010-0.1 0.010-0.27-0.020-0.47-0.12-0.73-0.27-0.030-0.020-0.070-0.040-0.11-0.060-0.060-0.030-0.11-0.070-0.16-0.11-0.17-0.18-0.37-0.48-0.6-0.65-0.060-0.010-0.11-0.010-0.15 0.010-0.080 0.030-0.15 0.090-0.22 0.15-0.020 0.020-0.030 0.040-0.050 0.060-0.040 0.040-0.070 0.090-0.1 0.13-0.17 0.16-0.27 0.36-0.43 0.49-0.040 0.020-0.070 0.040-0.1 0.060-0.12 0.070-0.23 0.1-0.33 0.090-0.030 0-0.060-0.010-0.090-0.010-0.28-0.11-0.58-0.31-0.76-0.46-0.020-0.020-0.040-0.040-0.060-0.060-0.040-0.040-0.090-0.080-0.13-0.12-0.84-0.76-0.030-1.060 0.35-1.4 0.37-0.34-0.050-1.85 0.65-1.38 0.030 0.020 0.060 0.040 0.090 0.060 0.15 0.21 0.37 0.38 0.55 0.57 0.020 0.020 0.060 0.050 0.070 0.070 0.26 0.12 0.76 0.42 1-0.1 0.010-0.020 0.030-0.050 0.040-0.070s0.020-0.030 0.030-0.040c0.080-0.37 0.28-0.67 0.68-0.66 0.030 0 0.060 0.010 0.090 0.020 0.080 0.030 0.14 0.1 0.17 0.22 0 0.030 0 0.060 0 0.090-0.010 0.13-0.020 0.25 0.010 0.36 0.020 0.020 0.040 0.050 0.060 0.070 0.020 0.010 0.040 0.030 0.060 0.030 0.020 0.010 0.060 0.020 0.080 0.040 0.27 0.14 0.47 0.42 0.54 0.99 0.1 0.97 0.080 1.76-0.35 1.87zM20.6 18.81c-0.98-0.5-3.5-2.62-3.29-3.94 0.12-0.75 1.73-1.34 2.49-1.15 0.79 0.2 2.52 1.050 2.59 1.1 0.63 0.16 0.8 0.6 0.9 1.4 0.050 2.48-1.060 3.42-2.69 2.59z",
  },
  blast: {
    size: 32,
    path:
      "M3.23 3.63l5.94 9.82c0.060 0.11-0.050 0.23-0.16 0.18l-3.31-1.62c-0.13-0.060-0.24 0.1-0.14 0.2l3.73 3.82c0.050 0.060 0.050 0.15-0.020 0.19l-8.66 5.83c-0.11 0.070-0.050 0.24 0.080 0.23l9.21-0.8c0.11-0.010 0.17 0.11 0.12 0.2l-5.34 7.96c-0.080 0.12 0.070 0.26 0.18 0.17l9.7-7.27c0.070-0.050 0.17-0.020 0.2 0.070l2.34 8.91c0.030 0.13 0.21 0.12 0.24 0l2.44-9.75c0.020-0.090 0.14-0.13 0.21-0.060l8.69 8.060c0.1 0.1 0.26-0.030 0.2-0.15l-5.76-11.060c-0.040-0.080 0.020-0.18 0.11-0.18l7.92-0.090c0.13 0 0.17-0.17 0.060-0.24l-9.31-5.2c-0.070-0.040-0.090-0.13-0.030-0.19l7.95-9.1c0.1-0.11-0.040-0.27-0.17-0.19l-9.62 6.56c-0.080 0.060-0.2 0-0.2-0.11l0.18-7.28c0-0.13-0.17-0.18-0.23-0.070l-3.4 5.92c-0.050 0.090-0.18 0.080-0.22-0.010l-3.35-7.75c-0.050-0.12-0.24-0.090-0.24 0.050l-0.18 11.2c0 0.11-0.13 0.16-0.21 0.090l-8.76-8.49c-0.1-0.11-0.27 0.030-0.19 0.15z",
  },
  corrosive: {
    size: 32,
    path:
      "M24.7 23.7c0.7 0.5 2-0.2 2.4-0.7s0.6-1.8 0-2.9-2-2.7-2-2.7-0.1 2.4-0.4 3-0.8 0.9-0.9 1.7 0.2 1.1 0.9 1.6zM28 27c0 0 0 0.9-0.5 1.6s-1.5 1-2.4 1.1-2.2-0.5-2.6-1-0.6-1.7-0.6-1.7h-21.7v4.6h31.6v-4.6h-3.8zM1.78 18.21c1.020 1.63 3.24 1.86 4.090 1.89 0 0 12.070-4.2 14.28-4.98 0.030-0.010 0.060-0.020 0.080-0.020 0.83-0.14 1.62 0.12 2.23 0.68 0.040 0.030 0.070 0.070 0.1 0.1 0.18 0.14 0.36 0.27 0.53 0.39 0.030 0.020 0.090 0.050 0.16 0.070 0.060 0.010 0.12 0.020 0.17 0.020 0.010 0 0.020 0 0.040 0 0.34 0.060 0.44-0.24 0.51-0.43 0-0.020 0.010-0.050 0.010-0.070 0.030-0.34-0.040-0.66-0.14-0.98-0.010-0.020-0.010-0.050-0.020-0.060-0.21-0.51-0.21-1.010-0.47-1.5 0-0.010-0.010-0.030-0.010-0.050 0-0.010 0-0.030-0.010-0.040s-0.010-0.030-0.010-0.040c-0.010-0.030-0.020-0.060-0.030-0.1-0.010 0-0.020 0-0.030 0 0 0-2.47-6.94-2.92-8.22 0-0.010-0.010-0.020-0.010-0.040-0.020-0.32-0.22-0.52-0.4-0.63-0.010 0-0.030-0.010-0.050-0.010-0.58-0.080-0.69-0.040-0.96 0.52 0 0 0.3 2.3-1 2.8s-14.020 4.19-14.82 4.89-2 0.8-1.9 3.7c0.020 0.47 0.080 1.33 0.58 2.11zM7.38 12.12c0.040-0.020 0.080-0.040 0.12-0.050 1.75-0.73 4.42-1.65 5.49-1.96 1.090-0.32 3.62-1.010 5.29-1.54 0.030-0.010 0.060-0.020 0.080-0.030 1.24-0.24 1.54-1.64 1.54-2.66 0-0.060 0-0.11 0-0.15 0-0.14 0-0.22 0-0.22 0-0.13 0.15-0.38 0.27-0.62l2.96 8.19c-3.48-0.19-17.39 0.040-17.42-0.070-0.050-0.16 0.52-0.46 1.67-0.89z",
  },
  gas: {
    size: 32,
    path:
      "M8.84 23.84c0.25-1.55 0.19-3.26-0.58-4.71-0.31-0.42-0.73-0.73-1.25-0.42-0.21 0.21 0 0.63-0.16 0.86 0 0.040-0.010 0.070-0.010 0.1-0.010 0.2 0 0.42 0.020 0.63 0 0.010 0 0.030 0 0.040 0.040 0.87 0.25 1.6 0.22 2.43 0 0.010 0 0.020 0 0.050 0 0.66 0.12 1.25 0.86 1.51 0.010 0 0.030 0 0.040 0 0.020 0 0.050 0 0.080 0 0.050 0 0.11 0 0.18-0.010 0.020 0 0.040-0.010 0.050-0.010 0.010-0.010 0.030-0.020 0.040-0.030 0.13-0.070 0.24-0.16 0.35-0.24 0.040-0.060 0.1-0.13 0.16-0.2zM25.16 19.050c0.030-0.020 0.030-0.13 0.040-0.12 0.010-0.030 0.020-0.060 0.030-0.080 0.15-0.4 0.42-1-0.090-1.15-0.030 0-0.060 0-0.090 0-0.41 0.040-0.63 0.35-0.8 0.59-0.54 0.7-1.010 1.53-1.28 2.39-0.010 0.040-0.020 0.070-0.030 0.11-0.050 0.32-0.26 0.73-0.19 1.020 0 0.040-0.010 0.080-0.010 0.11-0.020 0.45 0.020 0.9 0.16 1.33 0.010 0.030 0.020 0.050 0.030 0.090 0.060 0.49 0.8 1.74 1.11 1.010 0.73-1.57 0.21-3.66 1.11-5.29 0.010 0 0.010-0.010 0.010-0.010zM30.61 20.74c0.33-0.25 0.65-0.56 0.69-0.99 0.010-0.040 0.020-0.070 0.030-0.11 0.1-0.48 0.060-0.97-0.18-1.42-0.020-0.020-0.050-0.050-0.080-0.070-0.15-0.11-0.35-0.17-0.58-0.19-0.040 0-0.080 0-0.12 0-0.65 0-1.25 0.35-1.41 1.080-0.070 0.42-0.090 0.93 0.1 1.31 0.020 0.030 0.030 0.060 0.060 0.090 0.29 0.37 0.61 0.42 0.93 0.39 0.030 0 0.070-0.010 0.1-0.010 0.17 0.090 0.27-0.12 0.46-0.080v0zM27.010 23.41c-0.050-0.94 0.060-1.83 0.36-2.72 0.25-0.75 0.49-1.57 0.92-2.24 0.080-0.13 0.22-0.14 0.33-0.1 0.26-0.57 0.52-1.13 0.77-1.7 0.030-0.070 0.030-0.18-0.060-0.21-1.21-0.52-2.27 0.36-2.86 1.37-0.77 1.29-1.22 2.79-1.37 4.28-0.13 1.33-0.13 2.99 0.52 4.2 0.4 0.74 1.26 1.26 2.040 1h0.14c0.070-0.020 0.13-0.060 0.17-0.13 0.010-0.010 0.010-0.020 0.020-0.030-0.25-0.3-0.45-0.63-0.59-1.010-0.29-0.84-0.34-1.83-0.39-2.71zM29.58 23.36c-0.010-0.010-0.020-0.020-0.040-0.030-0.48-0.3-0.38-0.72-0.33-1.14-0.010-0.040-0.010-0.050-0.010-0.060 0.090-0.43-0.11-0.73-0.39-1-0.010-0.020-0.030-0.030-0.040-0.050-0.14-0.19-0.25-0.4-0.33-0.62-0.010-0.010-0.010-0.030-0.020-0.040-0.040-0.22-0.040-0.22-0.27-0.2-0.010 0-0.020 0.010-0.030 0.010-0.050 0.030-0.090 0.080-0.12 0.16 0 0.010-0.010 0.030-0.010 0.040-0.040 0.13-0.090 0.26-0.13 0.39-0.26 0.78-0.38 1.56-0.35 2.39s0.090 1.73 0.32 2.54c0.070 0.24 0.17 0.46 0.29 0.66 0.56 0 1.12 0.020 1.68 0.040 0.020 0 0.040 0 0.070 0 0.72-0.25 0.69-1.020 0.61-1.72 0-0.010 0-0.020 0-0.040 0.12-0.59-0.28-1.090-0.9-1.33 0 0 0 0 0 0zM2.97 20.57c0.31-0.37 0.4-0.82 0.41-1.3 0-0.030 0-0.050 0-0.080-0.030-0.48 0.080-1.21-0.52-1.56-0.020 0-0.060-0.020-0.1-0.030-0.31-0.080-0.64-0.090-0.96-0.070-0.040 0-0.070 0-0.11 0.010-0.44 0.020-0.75 0.44-0.85 0.75-0.21 0.73-0.52 2.2 0.59 2.52 0.020 0 0.040 0.010 0.060 0.010 0.43 0.030 0.95 0.040 1.3-0.13 0.030-0.010 0.060-0.030 0.080-0.050 0.040-0.010 0.070-0.040 0.1-0.070zM3.78 20.5c-0.020 0.010-0.030 0.020-0.040 0.030-0.14 0.1-0.14 0.2-0.18 0.39 0 0.010-0.010 0.030-0.010 0.040-0.32 1.010-0.84 1.97-1.55 2.88-0.21 0.31-0.42 0.63-0.28 1.080 0 0.020-0.010 0.040-0.010 0.060-0.060 0.5-0.010 0.98 0.34 1.24 0.030 0.020 0.050 0.040 0.090 0.060 0.76 0.11 1.68 0.2 2.22-0.26 0.13-1.66 0.11-3.33-0.18-4.95 0-0.010 0-0.020-0.010-0.030-0.070-0.24-0.070-0.54-0.39-0.54v0zM6.61 23.46c0-0.020 0-0.050 0-0.090 0.010-0.050 0.010-0.1 0.020-0.16 0-0.020 0-0.060 0-0.080 0-0.84-0.050-1.67-0.16-2.51-0.070-0.52-0.15-1.030-0.25-1.54 0-0.020-0.010-0.040-0.010-0.060-0.030-0.62-0.14-1.14-0.44-1.7-0.020-0.030-0.040-0.060-0.060-0.1-0.1-0.16-0.23-0.31-0.38-0.43-0.020-0.020-0.030-0.030-0.050-0.040-0.61-0.54-1.51-0.75-2.44-0.44 0.28 0.46 0.59 0.94 0.82 1.45 0.010 0.030 0.030 0.070 0.040 0.1s0.030 0.070 0.040 0.1c0.010 0.030 0.030 0.070 0.040 0.1 0.020 0.060 0.040 0.12 0.060 0.18 0.030 0.030 0.060 0.060 0.080 0.11 0.98 2.35 1.13 4.88 0.97 7.39 0.020 0.51 0.050 1.040 0.25 1.51 0.030 0.020 0.060 0.040 0.090 0.050 0.090 0.050 0.18 0.11 0.27 0.16 0.040 0 0.080 0.010 0.11 0 0.19-0.030 0.37-0.12 0.53-0.32 0.040-0.050 0.080-0.11 0.12-0.17 0.020-0.030 0.030-0.060 0.050-0.090 0.29-0.97 0.29-1.91 0.34-2.9-0.060-0.14-0.060-0.35-0.040-0.52zM24.14 17.6c0.020-0.030 0.050-0.060 0.080-0.090 0.75-0.86 1.7-1.61 2.87-2.25 1.36-0.84 0-2.93-0.33-4.46-0.010-0.030-0.020-0.060-0.040-0.090-0.99-2.060-2.82-3.75-4.84-4.9-0.050-0.020-0.1-0.050-0.15-0.070-2.85-1.3-6.2-1.36-9.23-0.86-0.060 0.020-0.11 0.030-0.16 0.050-1.91 0.6-3.76 1.63-5.090 3.070-0.030 0.040-0.070 0.080-0.1 0.11-1.28 2.13-3.68 4.64-1.9 7.040 0.71 1.010 1.71 1.78 2.58 2.61 0.030 0.030 0.060 0.050 0.080 0.080 0.060 0.13 0.16 0.23 0.32 0.33 0.020 0.030 0.050 0.060 0.080 0.080 0.69 0.76 1.22 1.62 1.29 2.77 0 0.050 0.010 0.1 0.010 0.15 0.060 0.94 0.010 1.9 0.11 2.82 0.010 0.030 0.030 0.090 0.040 0.13 0.050 0.12 0.11 0.23 0.2 0.32 0.73 0.73 3.24 2.51 4.18 2.72 0.71 0.16 1.76 0.25 2.95-0.010 0.030-0.010 0.060-0.010 0.090-0.020 0.19-0.17 0.4-0.070 0.58-0.070 0.89-0.5 2.030-0.84 2.84-1.33 0.030-0.020 0.070-0.040 0.1-0.060 0.33-0.59 1.48-0.49 1.48-1.22 0.2-2.39-0.010-5.11 1.96-6.85zM16.31 18.51c0.75 0 1.36 0.61 1.36 1.36s-0.61 1.36-1.36 1.36-1.36-0.61-1.36-1.36 0.61-1.36 1.36-1.36zM9.41 15.4c-0.030-0.010-0.080-0.020-0.15-0.050-0.050-0.030-0.1-0.060-0.15-0.090-0.020-0.020-0.050-0.030-0.070-0.050-0.26-0.050-0.36-0.16-0.56-0.24 0 0 0 0 0 0-0.64-0.43-0.75-1.27-0.54-2.050 0.010-0.050 0.020-0.1 0.030-0.15 0.17-0.93 0.35-1.83 0.27-2.81 0.010-0.030 0.030-0.050 0.050-0.090 0.48-0.92 2.080-0.38 3.050-0.43 0.5-0.020 1.030-0.14 1.5-0.040 0.030 0.010 0.060 0.020 0.080 0.030 0.77 0.39 1.71 1.020 1.5 1.96-0.41 2.31-2.39 4.82-5.010 4.010zM11.96 20.020c-0.010-2.2 1.6-4.040 3.71-4.36l0.010 1.49c-1.3 0.3-2.26 1.47-2.26 2.87 0 0.52 0.14 1.010 0.39 1.44l-1.050 1.070c-0.5-0.72-0.8-1.58-0.8-2.51zM16.37 24.39c-0.97 0.010-1.86-0.3-2.59-0.83l1.040-1.060c0.45 0.27 0.97 0.43 1.54 0.43 0.53 0 1.030-0.15 1.46-0.4l1.090 1.030c-0.71 0.51-1.59 0.82-2.54 0.83zM19.99 22.45l-1.090-1.030c0.24-0.43 0.37-0.92 0.37-1.44-0.010-1.36-0.95-2.5-2.21-2.82l-0.010-1.49c2.080 0.34 3.67 2.13 3.68 4.31 0.010 0.91-0.27 1.76-0.74 2.47zM23.77 14.71c-0.020 0.040-0.060 0.090-0.080 0.13-0.27 0.22-0.48 0.54-0.95 0.55-0.16 0.090-0.37-0.020-0.61 0.15-0.070 0-0.12-0.010-0.16-0.030-0.97-0.25-1.83-0.97-2.42-1.81-0.73-0.84-1.78-1.99-1.25-3.24 0.42-0.84 1.46-0.73 2.3-0.98 0.050 0 0.1 0 0.14 0 0.33 0 0.67 0.030 0.98 0.030 0.35 0 1.28-0.14 1.79-0.050 0.010 0 0.030 0 0.040 0.010 0.64 0.13 0.44 0.93 0.36 1.43 0 0.010-0.010 0.030-0.010 0.040-0.21 0.87 0.13 1.82 0.030 2.76 0.010 0.36-0.020 0.72-0.16 1.010z",
  },
  magnetic: {
    size: 32,
    path:
      "M27.3 10.5l3.5-2.5-1.6-0.1 0.9-1.3-3.2 1.8h1.9zM30 20.8l-3.2 1.8h1.9l-1.5 2.1 3.5-2.5-1.6-0.1zM1.2 15.86c0 5.56 3.64 10.34 8.13 10.34h9.97v-5.97h-7.53c-2.81 0-5.080-1.82-5.080-4.070s2.28-4.070 5.080-4.070h7.53v-6.29h-9.97c-4.49 0-8.13 4.5-8.13 10.060zM21.1 20.23h3v5.97h-3v-5.97zM21.1 5.8h3v6.3h-3v-6.3z",
  },
  radiation: {
    size: 32,
    path:
      "M19.070 15.26c0 1.64-1.33 2.97-2.97 2.97s-2.97-1.33-2.97-2.97c0-1.64 1.33-2.97 2.97-2.97s2.97 1.33 2.97 2.97zM22.41 13.57l8.99-1.32c-1.030-5.040-4.49-9.2-9.1-11.2l-3.7 8.26c1.84 0.76 3.26 2.33 3.81 4.26zM13.49 9.36l-3.4-8.39c-4.74 1.98-8.29 6.23-9.31 11.38l8.94 1.47c0.49-2 1.9-3.65 3.77-4.46zM16.1 21.95c-1 0-1.94-0.22-2.78-0.62-0.98 1.91-3.010 5.82-4.17 8.030 2.090 1.050 4.45 1.64 6.95 1.64 2.8 0 5.43-0.74 7.7-2.030l-4.74-7.72c-0.88 0.45-1.89 0.7-2.96 0.7z",
  },
  viral: {
    size: 32,
    path:
      "M26.9 7.53c0.19-0.44 0.51-0.76 0.89-0.98 0.030-0.030 0.050-0.060 0.080-0.080 0.34-0.36 0.66-0.76 0.82-1.29-0.030-0.010-0.050-0.020-0.080-0.020s-0.050 0-0.080 0.010c-0.69 0.22-1.23 0.76-1.64 1.39-0.020 0.030-0.050 0.060-0.070 0.080-0.15 0.16-0.33 0.29-0.58 0.36 0.080-0.25 0.21-0.47 0.35-0.68 0.020-0.030 0.040-0.060 0.060-0.090 0.020-0.3 0.34-0.4 0.33-0.67 0.010-0.040 0.020-0.070 0.030-0.11 0.020-0.070 0.030-0.15 0.030-0.23 0-0.040 0-0.070 0-0.11-0.010-0.14-0.040-0.29-0.12-0.43-0.020-0.020-0.040-0.040-0.070-0.050-0.040-0.020-0.090-0.020-0.13-0.010-0.030 0.010-0.050 0.020-0.080 0.040-0.62 0.73-0.73 1.7-1.26 2.44 0-0.11 0-0.32-0.020-0.42 0-0.040 0-0.070 0-0.11 0.010-0.63 0.070-1.29-0.51-1.71-0.030 0.030-0.050 0.050-0.080 0.080-0.26 0.31-0.33 0.71-0.37 1.12 0 0.030-0.010 0.070-0.010 0.1 0.010 0.22 0.040 0.42 0.040 0.62 0 0.030 0 0.070 0 0.1s0 0.060-0.010 0.1c0 0.030 0 0.070-0.010 0.1-0.010 0.33-0.010 0.54-0.010 0.86-0.21-0.96-0.64-1.92-1.51-2.6-0.040 0-0.070 0.010-0.1 0.010s-0.070 0.010-0.1 0.030c-0.32 0.21-0.53 0.53-0.54 0.82-0.010 0.030-0.020 0.070-0.030 0.1-0.18 0.57 0.040 1.1 0.14 1.64-0.32-0.53-0.53-1.17-1.050-1.49-0.030-0.010-0.060-0.020-0.090-0.030-0.77-0.21-1.4 0.92-0.57 2.59-1.33-2.45-2.86-1.33-1.64 1.25-1.34-2.5-3.14-1.080-1.61 1.31-1.7-2.26-3.24-0.93-1.61 1.33-1.82-2.12-3.37-1.020-1.64 1.3-1.83-2.24-3.020-1.38-1.69 1.22-1.29-2.34-2.47-1.65-1.95 0.48 0 0.010 0 0.010 0 0.020-0.1 0.24 0.12 0.45 0.12 0.67-0.11-0.21-0.11-0.53-0.34-0.68 0 0-0.010-0.010-0.010-0.010-0.99-1.5-2.23-0.030-0.95 1.9-1.48-2.1-2.75-0.94-1.23 1.33-1.080-1.54-1.9-1.6-1.82-0.66 0 0.030 0 0.040 0.010 0.060 0.020 0.18 0.070 0.35 0.14 0.52 0.010 0.020 0.020 0.050 0.030 0.070 0.1 0.45 0.45 0.68 0.59 1.010 0.010 0.020 0.010 0.030 0.020 0.050-0.060 0.15 0.15 0.26 0.15 0.37-0.64-0.43-0.96-1.070-1.62-1.44-0.010 0-0.030-0.010-0.040-0.010-0.77-0.22-0.97 0.88 0.58 2.33-2.29-2.090-3.53-0.4-0.57 1.16-2.97-1.55-3.25-0.32-0.36 1.24-2.89-1.56-2.81 0.49-0.030 1.91-2.78-1.41-2.53 1.010 0.6 1.79-3.13-0.78-2.1 1.68 1.23 1.4-3.33 0.28-1.18 2.23 1.64 0.72-2.81 1.51 0.13 2.61 1.82 0.1-1.65 2.51 1.74 2.29 1.79-0.43 0.080 2.68 2.59 1.66 1.62-0.82 1.18 2.36 2.92 1.16 1.49-1.070 1.69 2.040 2.83 0.7 1.4-1.19 1.77 1.61 2.76 0.48 1.42-1.27 1.73 1.41 2.78 0.32 1.4-1.29 1.81 1.25 3.39 0.51 1.38-1.32 2.25 1.61 3.4 0.62 1.35-1.34 2.2 1.82 3.23 0.78 1.32-1.37 2.010 2.050 3.040 0.89 1.28-1.4 1.91 2.14 3.87-0.68 1.24-1.44 2.76 0.61 3.64-0.87 1.2-1.48 2.45 0.59 2.51 0.51 0.99-1.35 1.060 1.29 1.54 1.34 1.4 0.39-0.010-0.040-0.010-0.080-0.020-0.12-0.1-0.64-0.95-0.96-0.74-1.71 0.11 0.64 0.75 0.96 1.4 1.050 0.020-0.010 0.040-0.020 0.050-0.030 0.020-0.020 0.030-0.030 0.050-0.050 0.32-0.43 0-0.96-0.38-1.19-0.020-0.030-0.050-0.060-0.070-0.090-0.35-0.45-0.53-1-1.15-1.18 0.75 0.11 1.070 0.96 1.91 1.090 0.030 0 0.050-0.010 0.080-0.030 0.12-0.060 0.18-0.21 0.23-0.4 0-0.040 0-0.070-0.010-0.12-0.4-0.98-1.14-1.83-2.31-1.7-0.040 0.010-0.070 0.020-0.11 0.040-0.040 0.010-0.080 0.030-0.12 0.050 0.040-0.010 0.070-0.020 0.11-0.030s0.070-0.020 0.11-0.020c0.53-0.16 1.060 0.050 1.6-0.030 0.040 0 0.080 0 0.12 0 0.12 0 0.24-0.010 0.36-0.030 0.040-0.010 0.080-0.020 0.11-0.030 0.11-0.030 0.21-0.070 0.31-0.13 0.030-0.020 0.060-0.040 0.090-0.060 0.080-0.070 0.16-0.15 0.22-0.24 0-0.030-0.010-0.060-0.010-0.1-0.020-0.1-0.060-0.21-0.12-0.31-0.020-0.030-0.040-0.070-0.060-0.1-0.38-1.040-1.66-0.83-2.67-0.68-0.040 0.010-0.070 0.020-0.11 0.030-0.26 0.060-0.53 0.090-0.8-0.070 0.27 0 0.59-0.080 0.89-0.22 0.020-0.010 0.040-0.020 0.060-0.030 0.12-0.18 0.33-0.070 0.46-0.27 0.020-0.010 0.030-0.030 0.050-0.040 0.39-0.31 0.64-0.7 0.51-1.070-0.040 0-0.080 0.010-0.12 0.010-0.96 0.090-1.85 0.46-2.67 0.97 0 0.010 0 0.010 0 0zM9.91 24.95c-0.85 0.21-1.76-0.050-2.5-0.53-0.070-0.050-0.14-0.1-0.18-0.17s-0.050-0.16-0.050-0.25c0-0.3 0.050-0.68 0.16-1.090s0.26-0.83 0.45-1.19 0.42-0.68 0.7-0.85c0.53-0.35 1.12-0.24 1.63 0.060 0.51 0.31 0.94 0.81 1.16 1.28 0.13 0.27 0.21 0.57 0.22 0.87 0 0.89-0.74 1.66-1.59 1.87zM11.77 19.43c-0.23-0.27-0.3-0.67-0.15-0.98 0.19-0.4 0.64-0.59 1.060-0.75l-0.15 0.14c0.28-0.2 0.69-0.17 1.050-0.13 0.42 0.050 0.94 0.21 0.98 0.63 0.030 0.3-0.23 0.55-0.46 0.74-0.41 0.34-0.85 0.69-1.38 0.72-0.36 0.030-0.73-0.1-0.95-0.37zM15.44 22.83c-0.19 0.28-0.42 0.54-0.73 0.69-0.3 0.14-0.69 0.15-0.95-0.070-0.37-0.3-0.34-0.86-0.28-1.33 0.030-0.26 0.070-0.53 0.22-0.75 0-0.21 0.32-0.27 0.55-0.23 0.32 0.050 0.65 0.1 0.94 0.26 0.28 0.16 0.52 0.45 0.52 0.78-0.010 0.24-0.14 0.46-0.27 0.65zM14.13 2.25c-1.93-1.41-3.86 1.18-5.33 2-1.98 1.12-3.83 2.47-5.49 4.030-1.33 1.24-2.63 2.87-2.39 4.68 1.28 0.42 2.47 1.26 3.82 1.22 0.97-0.030 1.87-0.53 2.61-1.15 0.75-0.63 1.36-1.39 2.050-2.080 1.83-1.84 4.26-3.29 5.21-5.71 0.39-1.010 0.4-2.35-0.48-2.99zM5.11 10.66c-0.13 0.62-0.98 1.22-1.55 1.38-0.1 0.030-0.2 0.040-0.3 0.010-0.62-0.19-0.4-1.4-0.15-1.8 0.24-0.38 0.7-0.66 1.16-0.63 0.54 0.030 0.96 0.5 0.84 1.040zM6.070 8.85c-0.010 0.16-0.11 0.35-0.27 0.35-0.17 0-0.27-0.19-0.29-0.35-0.030-0.25 0.050-0.52 0.21-0.71l-0.050 0.11c0.14 0 0.26 0.080 0.33 0.2s0.080 0.26 0.070 0.4zM7.040 10.51c-0.040 0.27-0.12 0.53-0.25 0.77-0.060 0.1-0.12 0.2-0.23 0.25-0.1 0.050-0.24 0.040-0.31-0.050-0.070-0.1-0.030-0.24 0-0.36 0.080-0.3 0.060-0.6 0-0.9-0.040-0.19-0.22-0.52-0.070-0.7 0.3-0.37 0.82 0.27 0.86 0.57 0.040 0.13 0.020 0.27 0 0.42z",
  },
  true: {
    size: 32,
    path:
      "M10.067 9.025c2.877-2.685 5.645-5.538 7.527-9.025 1.882 3.487 4.65 6.34 7.527 9.025 2.212-2.293 4.534-4.432 6.976-6.431l0.142-0.113c-1.665 2.888-3.403 5.717-5.257 8.473 2.516 2.049 5.165 3.979 8.209 5.165-3.907 1.367-5.753 5.154-7.694 8.474 0.589-2.885 1.418-5.427 2.497-7.833l-0.094 0.235c-1.642-1.055-3.259-2.11-4.89-3.165q-2.355 3.022-4.805 5.945c3.476 4.123 7.275 7.97 10.633 12.186-3.704 0.024-7.395 0.012-11.098 0.024 1.413-0.467 2.816-0.971 4.231-1.427-2.050-2.646-4.243-5.163-6.376-7.74-2.151 2.577-4.338 5.117-6.52 7.658 1.462 0.491 2.913 1.031 4.374 1.522-3.704-0.036-7.394-0.012-11.098-0.036 3.356-4.219 7.155-8.066 10.633-12.186-1.63-1.953-3.235-3.931-4.793-5.945-1.643 1.055-3.26 2.122-4.898 3.177 0.997 2.173 1.829 4.711 2.369 7.356l0.039 0.23c-1.941-3.32-3.787-7.108-7.694-8.474 3.044-1.186 5.693-3.116 8.209-5.165-1.858-2.756-3.595-5.597-5.257-8.473 2.58 2.11 4.899 4.249 7.085 6.517l0.023 0.024zM12.752 11.654c1.522 1.821 3.153 3.571 4.842 5.237q2.534-2.498 4.842-5.237-2.446-2.072-4.842-4.21c-1.606 1.425-3.211 2.832-4.842 4.207z",
  },
  renew: {
    size: 24,
    path:
      "M18.75 7.734c0.797 1.219 1.266 2.719 1.266 4.266 0 4.406-3.609 8.016-8.016 8.016v3l-3.984-4.031 3.984-3.984v3c3.328 0 6-2.672 6-6 0-1.031-0.281-1.969-0.703-2.813zM12 6c-3.328 0-6 2.672-6 6 0 1.031 0.234 1.969 0.703 2.813l-1.453 1.453c-0.797-1.219-1.266-2.719-1.266-4.266 0-4.406 3.609-8.016 8.016-8.016v-3l3.984 4.031-3.984 3.984v-3z",
  },
  palette: {
    size: 24,
    path:
      "M17.484 12c0.844 0 1.5-0.656 1.5-1.5s-0.656-1.5-1.5-1.5-1.5 0.656-1.5 1.5 0.656 1.5 1.5 1.5zM14.484 8.016c0.844 0 1.5-0.656 1.5-1.5s-0.656-1.5-1.5-1.5-1.5 0.656-1.5 1.5 0.656 1.5 1.5 1.5zM9.516 8.016c0.844 0 1.5-0.656 1.5-1.5s-0.656-1.5-1.5-1.5-1.5 0.656-1.5 1.5 0.656 1.5 1.5 1.5zM6.516 12c0.844 0 1.5-0.656 1.5-1.5s-0.656-1.5-1.5-1.5-1.5 0.656-1.5 1.5 0.656 1.5 1.5 1.5zM12 3c4.969 0 9 3.609 9 8.016 0 2.766-2.25 4.969-5.016 4.969h-1.734c-0.844 0-1.5 0.656-1.5 1.5 0 0.375 0.141 0.703 0.375 0.984s0.375 0.656 0.375 1.031c0 0.844-0.656 1.5-1.5 1.5-4.969 0-9-4.031-9-9s4.031-9 9-9z",
  },
  date: {
    size: 24,
    path:
      "M18.984 20.016v-11.016h-13.969v11.016h13.969zM18.984 3.984c1.078 0 2.016 0.938 2.016 2.016v14.016c0 1.078-0.938 1.969-2.016 1.969h-13.969c-1.125 0-2.016-0.891-2.016-1.969v-14.016c0-1.078 0.891-2.016 2.016-2.016h0.984v-1.969h2.016v1.969h7.969v-1.969h2.016v1.969h0.984zM17.016 11.016v1.969h-2.016v-1.969h2.016zM12.984 11.016v1.969h-1.969v-1.969h1.969zM9 11.016v1.969h-2.016v-1.969h2.016z",
  },
  extension: {
    size: 24,
    path:
      "M20.484 11.016c1.359 0 2.531 1.125 2.531 2.484s-1.172 2.484-2.531 2.484h-1.5v4.031c0 1.078-0.891 1.969-1.969 1.969h-3.797v-1.5c0-1.5-1.219-2.672-2.719-2.672s-2.719 1.172-2.719 2.672v1.5h-3.797c-1.078 0-1.969-0.891-1.969-1.969v-3.797h1.5c1.5 0 2.672-1.219 2.672-2.719s-1.172-2.719-2.672-2.719h-1.5v-3.797c0-1.078 0.891-1.969 1.969-1.969h4.031v-1.5c0-1.359 1.125-2.531 2.484-2.531s2.484 1.172 2.484 2.531v1.5h4.031c1.078 0 1.969 0.891 1.969 1.969v4.031h1.5z",
  },
  fingerprint: {
    size: 24,
    path:
      "M14.906 21.984h-0.141c-1.594-0.422-2.625-1.031-3.703-2.109-1.406-1.406-2.156-3.234-2.156-5.203 0-1.641 1.359-2.953 3.047-2.953s3.094 1.313 3.094 2.953c0 1.078 0.891 1.922 2.063 1.922s2.109-0.844 2.109-1.922c0-3.75-3.281-6.844-7.266-6.844-2.859 0-5.438 1.594-6.609 4.031-0.375 0.797-0.563 1.781-0.563 2.813 0 0.797 0.047 2.016 0.656 3.609 0.215 0.644-0.725 0.859-0.938 0.328-0.469-1.313-0.75-2.578-0.75-3.938 0-1.219 0.234-2.297 0.703-3.234 1.313-2.813 4.266-4.641 7.5-4.641 4.547 0 8.25 3.563 8.25 7.875 0 1.641-1.406 2.906-3.094 2.906s-3.047-1.266-3.047-2.906c0-1.078-0.938-1.969-2.109-1.969s-2.063 0.891-2.063 1.969c0 1.688 0.656 3.281 1.875 4.5 0.938 0.938 1.875 1.453 3.281 1.828 0.281 0.047 0.375 0.328 0.328 0.609-0.047 0.234-0.281 0.375-0.469 0.375zM12.422 14.672c0 2.286 1.889 4.266 4.5 4.266 0.467 0 1.536-0.345 1.641 0.281 0.047 0.281-0.141 0.563-0.422 0.609-0.563 0.094-1.078 0.094-1.219 0.094-1.172 0-2.25-0.281-3.094-0.891-1.5-1.031-2.391-2.625-2.391-4.359 0-0.281 0.234-0.516 0.516-0.516s0.469 0.234 0.469 0.516zM9.75 21.797c-0.141 0-0.234-0.047-0.328-0.141-0.891-0.891-1.359-1.453-2.016-2.672-0.703-1.219-1.078-2.719-1.078-4.313 0-2.953 2.531-5.391 5.672-5.391s5.672 2.438 5.672 5.391c0 0.281-0.234 0.469-0.516 0.469s-0.516-0.188-0.516-0.469c0-2.438-2.063-4.406-4.641-4.406s-4.641 1.969-4.641 4.406c0 1.453 0.281 2.766 0.891 3.844 0.656 1.172 1.125 1.641 1.875 2.438 0.188 0.188 0.188 0.516 0 0.703-0.094 0.094-0.234 0.141-0.375 0.141zM3.516 9.703c-0.413 0-0.651-0.368-0.422-0.75 0.984-1.406 2.25-2.531 3.75-3.281 3.141-1.641 7.172-1.641 10.313 0 1.5 0.75 2.766 1.828 3.75 3.234 0.141 0.234 0.094 0.563-0.141 0.703s-0.563 0.094-0.703-0.141c-0.891-1.266-2.016-2.203-3.375-2.906-2.859-1.453-6.516-1.5-9.375 0-1.359 0.703-2.531 1.688-3.422 2.953-0.094 0.141-0.234 0.188-0.375 0.188zM17.813 4.453c-0.094 0-0.188 0-0.234-0.047-1.922-0.984-3.609-1.406-5.578-1.406s-3.891 0.469-5.578 1.406c-0.548 0.329-1.014-0.563-0.469-0.891 1.875-1.031 3.891-1.5 6.047-1.5 2.109 0 3.984 0.469 6.047 1.5 0.427 0.256 0.244 0.938-0.234 0.938z",
  },
  people: {
    size: 24,
    path:
      "M15.984 12.984c2.344 0 7.031 1.172 7.031 3.516v2.484h-6v-2.484c0-1.5-0.797-2.625-1.969-3.469 0.328-0.047 0.656-0.047 0.938-0.047zM8.016 12.984c2.344 0 6.984 1.172 6.984 3.516v2.484h-14.016v-2.484c0-2.344 4.688-3.516 7.031-3.516zM8.016 11.016c-1.641 0-3-1.359-3-3s1.359-3 3-3 2.953 1.359 2.953 3-1.313 3-2.953 3zM15.984 11.016c-1.641 0-3-1.359-3-3s1.359-3 3-3 3 1.359 3 3-1.359 3-3 3z",
  },
  help: {
    size: 24,
    path:
      "M15.047 10.266c0.563-0.563 0.938-1.359 0.938-2.25 0-2.203-1.781-4.031-3.984-4.031s-3.984 1.828-3.984 4.031h1.969c0-1.078 0.938-2.016 2.016-2.016s2.016 0.938 2.016 2.016c0 0.563-0.234 1.031-0.609 1.406l-1.219 1.266c-0.703 0.75-1.172 1.734-1.172 2.813v0.516h1.969c0-1.5 0.469-2.109 1.172-2.859zM12.984 18v-2.016h-1.969v2.016h1.969zM18.984 2.016c1.078 0 2.016 0.891 2.016 1.969v14.016c0 1.078-0.938 2.016-2.016 2.016h-3.984l-3 3-3-3h-3.984c-1.125 0-2.016-0.938-2.016-2.016v-14.016c0-1.078 0.891-1.969 2.016-1.969h13.969z",
  },
  menu: { size: 24, path: "M3 6h18v2.016h-18v-2.016zM3 12.984v-1.969h18v1.969h-18zM3 18v-2.016h18v2.016h-18z" },
  world: {
    size: 24,
    path:
      "M17.906 17.391c1.313-1.406 2.109-3.328 2.109-5.391 0-3.328-2.063-6.234-5.016-7.406v0.422c0 1.078-0.938 1.969-2.016 1.969h-1.969v2.016c0 0.563-0.469 0.984-1.031 0.984h-1.969v2.016h6c0.563 0 0.984 0.422 0.984 0.984v3h0.984c0.891 0 1.641 0.609 1.922 1.406zM11.016 19.922v-1.922c-1.078 0-2.016-0.938-2.016-2.016v-0.984l-4.781-4.781c-0.141 0.563-0.234 1.172-0.234 1.781 0 4.078 3.094 7.453 7.031 7.922zM12 2.016c5.531 0 9.984 4.453 9.984 9.984s-4.453 9.984-9.984 9.984-9.984-4.453-9.984-9.984 4.453-9.984 9.984-9.984z",
  },
  settings: {
    size: 24,
    path:
      "M15 9v-6h2.016v2.016h3.984v1.969h-3.984v2.016h-2.016zM21 12.984h-9.984v-1.969h9.984v1.969zM6.984 9h2.016v6h-2.016v-2.016h-3.984v-1.969h3.984v-2.016zM12.984 21h-1.969v-6h1.969v2.016h8.016v1.969h-8.016v2.016zM3 5.016h9.984v1.969h-9.984v-1.969zM3 17.016h6v1.969h-6v-1.969z",
  },
  motion: {
    size: 24,
    path:
      "M21.984 12c0 5.156-3.938 9.422-8.953 9.938v-2.016c3.938-0.516 6.984-3.891 6.984-7.922s-3.047-7.406-6.984-7.922v-2.016c5.016 0.516 8.953 4.781 8.953 9.938zM5.672 19.734l1.406-1.406c1.125 0.844 2.484 1.406 3.938 1.594v2.016c-2.016-0.188-3.844-0.984-5.344-2.203zM4.078 12.984c0.188 1.453 0.75 2.813 1.594 3.891l-1.406 1.453c-1.219-1.5-2.016-3.328-2.203-5.344h2.016zM5.672 7.078c-0.844 1.125-1.406 2.484-1.594 3.938h-2.016c0.188-2.016 0.984-3.844 2.203-5.344zM11.016 4.078c-1.453 0.188-2.813 0.75-3.938 1.594l-1.406-1.406c1.5-1.219 3.328-2.016 5.344-2.203v2.016zM13.031 9.797l2.953 2.203c-2.007 1.493-4.007 2.993-6 4.5z",
  },
  translate: {
    size: 24,
    path:
      "M15.891 17.016h3.234l-1.641-4.359zM18.516 9.984l4.5 12h-2.016l-1.125-3h-4.734l-1.125 3h-2.016l4.5-12h2.016zM12.891 15.047l-0.797 2.063-3.094-3.094-5.016 4.969-1.406-1.406 5.109-5.016c-1.266-1.406-2.25-2.906-3-4.547h2.016c0.609 1.172 1.359 2.297 2.297 3.328 1.453-1.594 2.531-3.422 3.188-5.344h-11.203v-2.016h7.031v-1.969h1.969v1.969h7.031v2.016h-2.953c-0.75 2.344-1.969 4.594-3.703 6.516l-0.047 0.047z",
  },
  watch: {
    size: 24,
    path:
      "M16.219 16.219l0.797-1.313-4.5-2.719v-5.203h-1.5v6zM12 2.016c5.484 0 9.984 4.5 9.984 9.984s-4.5 9.984-9.984 9.984-9.984-4.5-9.984-9.984 4.5-9.984 9.984-9.984z",
  },
  hot: {
    size: 24,
    path:
      "M11.719 18.984c2.672 0 4.781-2.109 4.781-4.781 0-1.406-0.188-2.719-0.563-4.031-1.031 1.359-2.859 2.203-4.641 2.578s-2.813 1.453-2.813 3.094c0 1.734 1.453 3.141 3.234 3.141zM13.5 0.656c3.891 3.141 6.516 7.969 6.516 13.359 0 4.406-3.609 7.969-8.016 7.969s-8.016-3.563-8.016-7.969c0-3.375 1.219-6.516 3.234-8.906v0.375c0 2.063 1.547 3.703 3.609 3.703s3.422-1.641 3.422-3.703c0-2.156-0.75-4.828-0.75-4.828z",
  },
  mail: {
    size: 24,
    path:
      "M20.016 8.016v-2.016l-8.016 5.016-8.016-5.016v2.016l8.016 4.969zM20.016 3.984c1.078 0 1.969 0.938 1.969 2.016v12c0 1.078-0.891 2.016-1.969 2.016h-16.031c-1.078 0-1.969-0.938-1.969-2.016v-12c0-1.078 0.891-2.016 1.969-2.016h16.031z",
  },
  lock: {
    size: 24,
    path:
      "M15.094 8.016v-2.016c0-1.688-1.406-3.094-3.094-3.094s-3.094 1.406-3.094 3.094v2.016h6.188zM12 17.016c1.078 0 2.016-0.938 2.016-2.016s-0.938-2.016-2.016-2.016-2.016 0.938-2.016 2.016 0.938 2.016 2.016 2.016zM18 8.016c1.078 0 2.016 0.891 2.016 1.969v10.031c0 1.078-0.938 1.969-2.016 1.969h-12c-1.078 0-2.016-0.891-2.016-1.969v-10.031c0-1.078 0.938-1.969 2.016-1.969h0.984v-2.016c0-2.766 2.25-5.016 5.016-5.016s5.016 2.25 5.016 5.016v2.016h0.984z",
  },
  copy: {
    size: 24,
    path:
      "M18.984 21v-14.016h-10.969v14.016h10.969zM18.984 5.016c1.078 0 2.016 0.891 2.016 1.969v14.016c0 1.078-0.938 2.016-2.016 2.016h-10.969c-1.078 0-2.016-0.938-2.016-2.016v-14.016c0-1.078 0.938-1.969 2.016-1.969h10.969zM15.984 0.984v2.016h-12v14.016h-1.969v-14.016c0-1.078 0.891-2.016 1.969-2.016h12z",
  },
  switch: {
    size: 24,
    path:
      "M14.176 24h3.674c3.376 0 6.15-2.774 6.15-6.15V6.15C24 2.775 21.226 0 17.85 0H14.1c-.074 0-.15.074-.15.15v23.7c-.001.076.075.15.226.15zm4.574-13.199c1.351 0 2.399 1.125 2.399 2.398 0 1.352-1.125 2.4-2.399 2.4-1.35 0-2.4-1.049-2.4-2.4-.075-1.349 1.05-2.398 2.4-2.398zM11.4 0H6.15C2.775 0 0 2.775 0 6.15v11.7C0 21.226 2.775 24 6.15 24h5.25c.074 0 .15-.074.15-.149V.15c.001-.076-.075-.15-.15-.15zM9.676 22.051H6.15c-2.326 0-4.201-1.875-4.201-4.201V6.15c0-2.326 1.875-4.201 4.201-4.201H9.6l.076 20.102zM3.75 7.199c0 1.275.975 2.25 2.25 2.25s2.25-.975 2.25-2.25c0-1.273-.975-2.25-2.25-2.25s-2.25.977-2.25 2.25z",
  },
  ps4: {
    size: 24,
    path:
      "M8.985 2.596v17.548l3.915 1.261V6.688c0-.69.304-1.151.794-.991.636.181.76.814.76 1.505v5.876c2.441 1.193 4.362-.002 4.362-3.153 0-3.237-1.126-4.675-4.438-5.827-1.307-.448-3.728-1.186-5.391-1.502h-.002zm4.656 16.242l6.296-2.275c.715-.258.826-.625.246-.818-.586-.192-1.637-.139-2.357.123l-4.205 1.499v-2.385l.24-.085s1.201-.42 2.913-.615c1.696-.18 3.785.029 5.437.661 1.848.601 2.041 1.472 1.576 2.072s-1.622 1.036-1.622 1.036l-8.544 3.107v-2.297l.02-.023zM1.808 18.6c-1.9-.545-2.214-1.668-1.352-2.321.801-.585 2.159-1.051 2.159-1.051l5.616-2.013v2.313L4.206 17c-.705.271-.825.632-.239.826.586.195 1.637.15 2.343-.12L8.248 17v2.074c-.121.029-.256.044-.391.073-1.938.331-3.995.196-6.037-.479l-.012-.068z",
  },
  xbox: {
    size: 24,
    path:
      "M4.102 21.033C6.211 22.881 8.977 24 12 24c3.026 0 5.789-1.119 7.902-2.967 1.877-1.912-4.316-8.709-7.902-11.417-3.582 2.708-9.779 9.505-7.898 11.417zm11.16-14.406c2.5 2.961 7.484 10.313 6.076 12.912C23.002 17.48 24 14.861 24 12.004c0-3.34-1.365-6.362-3.57-8.536 0 0-.027-.022-.082-.042-.063-.022-.152-.045-.281-.045-.592 0-1.985.434-4.805 3.246zM3.654 3.426c-.057.02-.082.041-.086.042C1.365 5.642 0 8.664 0 12.004c0 2.854.998 5.473 2.661 7.533-1.401-2.605 3.579-9.951 6.08-12.91-2.82-2.813-4.216-3.245-4.806-3.245-.131 0-.223.021-.281.046v-.002zM12 3.551S9.055 1.828 6.755 1.746c-.903-.033-1.454.295-1.521.339C7.379.646 9.659 0 11.984 0H12c2.334 0 4.605.646 6.766 2.085-.068-.046-.615-.372-1.52-.339C14.946 1.828 12 3.545 12 3.545v.006z",
  },
};
