# -*- encoding:utf-8 -*-
"""
 * Copyright (C) 2017 OwnThink.
 *
 * Name        : test_textrank.py
 * Author      : zengbin93 <zeng_bin8888@163.com>
 * Version     : 0.01
 * Description : TextRank算法 Unittest
"""
import unittest
import re
from jiagu import utils
import jiagu


class TestTextRank(unittest.TestCase):
    def setUp(self):
        pass

    def tearDown(self):
        pass

    def test_default_stopwords(self):
        file = utils.default_stopwords_file()
        stopwords = [x.strip() for x in open(file, 'r', encoding='utf-8')]
        self.assertTrue(len(stopwords) > 0)

    def test_keywords(self):
        text = '''
        该研究主持者之一、波士顿大学地球与环境科学系博士陈池（音）表示，
        “尽管中国和印度国土面积仅占全球陆地的9%，但两国为这一绿化过程
        贡献超过三分之一。考虑到人口过多的国家一般存在对土地过度利用的
        问题，这个发现令人吃惊。”
        NASA埃姆斯研究中心的科学家拉玛·内曼尼（Rama Nemani）说，“这一
        长期数据能让我们深入分析地表绿化背后的影响因素。我们一开始以为，
        植被增加是由于更多二氧化碳排放，导致气候更加温暖、潮湿，适宜生长。”
        “MODIS的数据让我们能在非常小的尺度上理解这一现象，我们发现人类活动
        也作出了贡献。”
        NASA文章介绍，在中国为全球绿化进程做出的贡献中，有42%来源于植树造林
        工程，对于减少土壤侵蚀、空气污染与气候变化发挥了作用。
        据观察者网过往报道，2017年我国全国共完成造林736.2万公顷、森林抚育
        830.2万公顷。其中，天然林资源保护工程完成造林26万公顷，退耕还林工程
        完成造林91.2万公顷。京津风沙源治理工程完成造林18.5万公顷。三北及长江
        流域等重点防护林体系工程完成造林99.1万公顷。完成国家储备林建设任务68万公顷。
        '''

        keywords = jiagu.keywords(text, 5)  # 关键词
        self.assertTrue(len(keywords) == 5)

    def test_summarize(self):
        text = ''''江西省上饶市信州区人民法院 刑事判决书 （2016）赣1102刑初274号 公诉机关
        上饶市信州区人民检察院。 被告人曾榴仙，女，1954年11月22日出生于江西省上饶市信州区，
        汉族，文盲，无业，家住上饶市信州区，因涉嫌过失致人死亡罪，2016年4月27日被上饶市公
        安局信州区分局刑事拘留，2016年6月1日被执行逮捕。 辩护人毛巧云，江西盛义律师事务所
        律师。 上饶市信州区人民检察院以饶信检公诉刑诉［2016］260号起诉书指控被告人曾榴仙犯
        过失致人死亡罪，于2016年8月22日向本院提起公诉。本院依法组成合议庭，公开开庭审理了
        本案。上饶市信州区人民检察院指派检察员苏雪莉出庭支持公诉，被告人曾榴仙及辩护人毛巧云，
        到庭参加诉讼。现已审理终结。 公诉机关指控： 被告人曾榴仙与被害人祝某两家系位于信州区
        沙溪镇向阳村柘阳的多年邻居，被害人祝某有多年心脏病史，被告人曾榴仙对此事明知。
        2016年4月27日7时许，被告人曾榴仙的丈夫徐某1在修理两家相邻路埂时因权属问题遭到对方阻拦，
        被告人曾榴仙和其丈夫徐某1分别与被害人祝某及其丈夫徐某2发生争吵、拉扯，被告人曾榴仙与
        被害人祝某拉扯至祝某家的厕所边，后被害人祝某心脏病发作倒地，在送往医院途中死亡。
        经江西上饶司法鉴定中心鉴定，被害人祝某额部及全身多处皮肤因外力作用致软组织挫擦伤，
        生前患有心肌肥大，心瓣膜病等器质性疾病导致心源性猝死是主因，本次与他人发生争吵、
        拉扯系导致心源性猝死的诱因。 2016年4月27日，被告人曾榴仙得知祝某死亡的消息后，
        在其丈夫徐某1的陪同下到沙溪派出所投案自首。 被告人曾榴仙对起诉书指控的犯罪事实不持异议。
         辩护人毛巧云提出辩护意见，其对起诉书指控的犯罪事实不持异议，但认为本案系意外事件。
         理由如下：1、被告人曾榴仙是否知道祝某有心脏病；2、被告人曾榴仙即便是知道祝某有心脏病，
         这一明知并不能等同于对死亡结果有预见。同时认为被告人曾榴仙具有如下量刑情节：
         1、自首；2、当庭认罪；3、一贯表现良好；4、有悔罪表现。 经审理查明： 
         被告人曾榴仙与被害人祝某两家系位于信州区沙溪镇向阳村柘阳的多年邻居，被害人祝某有多年
         心脏病史，被告人曾榴仙对此事明知。2016年4月27日7时许，被告人曾榴仙的丈夫徐某1在修理
         两家相邻路埂时因权属问题遭到对方阻拦，被告人曾榴仙和其丈夫徐某1分别与被害人祝某及其
         丈夫徐某2发生争吵、拉扯，被告人曾榴仙与被害人祝某拉扯至祝某家的厕所边，后被害人
         祝某心脏病发作倒地，在送往医院途中死亡。经江西上饶司法鉴定中心鉴定，被害人祝某额
         部及全身多处皮肤因外力作用致软组织挫擦伤，生前患有心肌肥大，心瓣膜病等器质性疾病
         导致心源性猝死是主因，本次与他人发生争吵、拉扯系导致心源性猝死的诱因。 
         2016年4月27日，被告人曾榴仙得知祝某死亡的消息后，在其丈夫徐某1的陪同下
         到沙溪派出所投案自首。 本案在审理过程中，被告人曾榴仙家属赔偿了被害人祝某家属的损失，
         并取得了谅解。 上述事实，被告人曾榴仙在开庭审理过程中亦无异议，且有被告人曾榴仙的
         常住人口信息，归案情况说明，证人徐某1、冯某、徐某3、徐某2、黄某、郑某的证言，
         被告曾榴仙的供述及辨认笔录，鉴定意见，现场勘查笔录等证据证实，足以认定。 本院认为，
         被告人曾榴仙明知被害人祝某有心脏病，应当预见其行为可能导致祝某病发死亡的后果，
         因轻信能够避免而与被害人祝某发生争吵和拉扯，导致被害人病发死亡。其行为已触犯刑法，
         构成过失致人死亡罪。公诉机关指控的罪名成立，本院予以支持。辩护人毛巧云辩称该案系意外
         事件的意见本院不予支持。案发后，被告人曾榴仙主动到公安机关投案，并如实供述自己的罪行，
         系自首，依法具备可以从轻或减轻处罚情节；被告人曾榴仙家属赔偿了被害人祝某家属的损失，
         并取得了谅解，被告人曾榴仙具备酌情从轻处罚情节。本案系因邻里纠纷矛盾激化引发，被告人
         曾榴仙具备酌情从轻处罚情节。依照《中华人民共和国刑法》第二百三十三条、
         第六十七条第一款、第七十二条第一款、第七十三条第二款、第三款的规定，
         判决如下： 被告人曾榴仙犯过失致人死亡罪，判处有期徒刑一年，缓刑一年。 
         （缓刑考验期限，从判决确定之日起计算） 如不服本判决，可在接到判决书的第二日起十日内，
         通过本院或者直接向江西省上饶市中级人民法院提出上诉。书面上诉的，
         应当提交上诉状正本一份，副本二份。 审判长程明 人民陪审员钱进 人民陪审员郑艳 
         二〇一六年十一月十四日 书记员郭建锋 " value="江西省上饶市信州区人民法院 
         刑事判决书 （2016）赣1102刑初274号 公诉机关上饶市信州区人民检察院。 
         被告人曾榴仙，女，1954年11月22日出生于江西省上饶市信州区，汉族，文盲，无业，
         家住上饶市信州区，因涉嫌过失致人死亡罪，2016年4月27日被上饶市公安局信州区分局刑事
         拘留，2016年6月1日被执行逮捕。 辩护人毛巧云，江西盛义律师事务所律师。 
         上饶市信州区人民检察院以饶信检公诉刑诉［2016］260号起诉书指控被告人
         曾榴仙犯过失致人死亡罪，于2016年8月22日向本院提起公诉。本院依法组成合议庭，
         公开开庭审理了本案。上饶市信州区人民检察院指派检察员苏雪莉出庭支持公诉，
         被告人曾榴仙及辩护人毛巧云，到庭参加诉讼。现已审理终结。 公诉机关指控： 
         被告人曾榴仙与被害人祝某两家系位于信州区沙溪镇向阳村柘阳的多年邻居，
         被害人祝某有多年心脏病史，被告人曾榴仙对此事明知。
         2016年4月27日7时许，被告人曾榴仙的丈夫徐某1在修理两家相邻路埂时因权属问题遭到
         对方阻拦，被告人曾榴仙和其丈夫徐某1分别与被害人祝某及其丈夫徐某2发生争吵、拉扯，
         被告人曾榴仙与被害人祝某拉扯至祝某家的厕所边，后被害人祝某心脏病发作倒地，
         在送往医院途中死亡。经江西上饶司法鉴定中心鉴定，被害人祝某额部及全身多处皮肤因外力
         作用致软组织挫擦伤，生前患有心肌肥大，心瓣膜病等器质性疾病导致心源性猝死是主因，
         本次与他人发生争吵、拉扯系导致心源性猝死的诱因。 2016年4月27日，被告人曾榴仙得
         知祝某死亡的消息后，在其丈夫徐某1的陪同下到沙溪派出所投案自首。 被告人曾榴仙对
         起诉书指控的犯罪事实不持异议。 辩护人毛巧云提出辩护意见，其对起诉书指控的犯罪事
         实不持异议，但认为本案系意外事件。理由如下：1、被告人曾榴仙是否知道祝某有心脏病；
         2、被告人曾榴仙即便是知道祝某有心脏病，这一明知并不能等同于对死亡结果有预见。
         同时认为被告人曾榴仙具有如下量刑情节：1、自首；2、当庭认罪；3、一贯表现良好；
         4、有悔罪表现。 经审理查明： 被告人曾榴仙与被害人祝某两家系位于信州区沙溪镇向阳村
         柘阳的多年邻居，被害人祝某有多年心脏病史，被告人曾榴仙对此事明知。'''
        text = re.sub('\\n| ', '', text)
        summarize = jiagu.summarize(text, 3)  # 摘要
        print(summarize)
        self.assertTrue(len(summarize) == 3)

    def test_cut_sentences(self):
        text = '''江西省上饶市信州区人民法院 刑事判决书 （2016）赣1102刑初274号 公诉机关
                上饶市信州区人民检察院。 被告人曾榴仙，女，1954年11月22日出生于江西省上饶市信州区，
                汉族，文盲，无业，家住上饶市信州区，因涉嫌过失致人死亡罪，2016年4月27日被上饶市公
                安局信州区分局刑事拘留，2016年6月1日被执行逮捕。辩护人毛巧云，江西盛义律师事务所
                律师。 上饶市信州区人民检察院以饶信检公诉刑诉［2016］260号起诉书指控被告人曾榴仙犯
                过失致人死亡罪，于2016年8月22日向本院提起公诉。'''
        text = re.sub('\\n| ', '', text)
        sentences = list(utils.cut_sentences(text))
        self.assertEqual(len(sentences), 4)

    def test_short_text_summarize(self):
        text = '''江西省上饶市信州区人民法院 刑事判决书 （2016）赣1102刑初274号 公诉机关
        上饶市信州区人民检察院。 被告人曾榴仙，女，1954年11月22日出生于江西省上饶市信州区，
        汉族，文盲，无业，家住上饶市信州区，因涉嫌过失致人死亡罪，2016年4月27日被上饶市公
        安局信州区分局刑事拘留，2016年6月1日被执行逮捕。辩护人毛巧云，江西盛义律师事务所
        律师。 上饶市信州区人民检察院以饶信检公诉刑诉［2016］260号起诉书指控被告人曾榴仙犯
        过失致人死亡罪，于2016年8月22日向本院提起公诉。'''
        text = re.sub('\\n| ', '', text)
        summarize = jiagu.summarize(text, 5)  # 设定摘要句子数大于文本句子数
        print(summarize)
        print(len(summarize))


if __name__ == '__main__':
    unittest.main()
