# Contribution Guidelines

Already JS / VueJS developer? Pick an existing issue, push a PR and become a vue-cloudfront contributor!
I'll mark some issues as [contribution welcome](https://github.com/ovanta/vue-cloudfront/labels/contribution%20welcome) which are not that hard and can be easily fixed / implemented (if feature).

Before you create a PR or issue please take a look at the [README](https://github.com/ovanta/vue-cloudfront/blob/master/README.md)

While writing issues / making PRs, please be as specific as possible.

## Branches
You should fork the project or create branch for new features. The main branches which are currently used are:

* master - latest 'stable' release of the app 
* develop - the most recent version of the app - kind of 'nightly' build.

Please use "develop" for development purposes or, if related to a new feature, the corresponding feature branch.

#### Issue checklist

 1. Try the [dev](https://github.com/ovanta/vue-cloudfront/tree/dev) -branch, perhaps the problem has been solved.
 2. [Use the search](https://github.com/ovanta/vue-cloudfront/search?type=Issues), maybe there is already an answer.
 3. If not found, [create an issue](https://github.com/ovanta/vue-cloudfront/issues/new), please don't forget to carefully describe how to reproduce it / pay attention to the issue-template.

#### Pull request checklist

 1. Before a Pull request run `npm run lint` and `npm run build` and resolve remaining issues.
 2. Please take care about basic commit message convetions, see [Writing Good Commit Messages](https://github.com/erlang/otp/wiki/writing-good-commit-messages).
 3. Pull requests only into [dev](https://github.com/ovanta/vue-cloudfront/tree/dev) or for new features in the corresponding branch.
 4. Reference any relevant issues / PRs in your PR.
 
