# Thinking-GPT4o

## 简介

Thinking-GPT4o 是一个增强版的 GPT-4o 项目，通过prompt使4o具备全面、自然且无过滤的思维过程。

该项目旨在通过引导GPT4o进行深入的内部思考，提高响应的质量与准确性，适用于各种编程和技术相关任务。

本项目灵感来源于[Thinking-Claude](https://github.com/richards199999/Thinking-Claude/tree/main)项目。

如果本项目对你有帮助，请给我一颗免费的star~

## 性能对比

为了展示 **Thinking-GPT4o** 相较于原始的 **4o** 和 **o1-mini** 的提升，我们进行了许多对比测试。这里展示了"先有鸡还是先有蛋"问题的测试结果截图。

### 原始 o1-mini

![原始 o1-mini](./pic/original-o1-mini.png)

原始的 o1-mini在处理复杂任务时，响应速度慢，回答内容少，准确性存在一定局限。

### 使用 Prompt

![使用 Prompt](./pic/using-prompt.png)

通过优化的 prompt，即使是4o，也肉眼可见的比原先o1mini更好，性能得到显著提升，能够更好地理解和执行用户指令。

### 最终测试

![最终测试](./pic/final-test.png)

**Thinking-GPT4o** 在响应质量、准确性和思维深度方面全面超越了原始 4o 和 o1-miniz在通过深思熟虑的思考后，给出了更精简而准确的回答，可以看出它提供了更高效和智能的模型。

## 功能

- **全面思维**：在每次互动中进行详细的思考过程，确保响应的深度和广度。
- **多语言支持**：提供中英文版本的思维协议，满足不同用户的需求。
- **智能问题解决**：能够分解复杂问题，生成多种解决方案，并进行验证和修正。
- **自适应思维框架**：根据查询的复杂性、风险、时间敏感度等因素调整思维深度和风格。

## 安装

Thinking-GPT4o 的运作基于以下几个核心步骤：

- **初始接触**：模型首先用自己的话清晰地重新表述用户的信息，形成对问题的初步印象，考虑问题的背景，映射已知和未知的元素，理解用户提出问题的原因，并识别需要澄清的模糊之处。

- **问题空间探索**：模型将问题或任务分解为核心组件，识别显性和隐性需求，考虑约束和限制，思考成功回应应具备的特征，映射解决查询所需的知识范围。

- **多重假设生成**：生成多种可能的查询解释，考虑不同的解决方案方法，思考潜在的替代视角，保持多个工作假设，避免过早承诺于单一解释，寻找创造性的组合方法。

- **自然发现过程**：思维如侦探故事般流动，每个发现自然引导到下一个。开始于显而易见的方面，注意模式或联系，质疑初始假设，建立新的联系，带着新的理解回顾早期思考，建立更深的洞察。

- **测试与验证**：在思考过程中，模型会质疑自身假设，测试初步结论，寻找潜在缺陷或空白，考虑替代视角，验证推理的一致性，检查理解的完整性。

- **错误识别与纠正**：当发现思维中的错误或缺陷时，模型会自然地承认，解释之前思维的不足或错误，展示新的理解是如何发展的，并将纠正后的理解整合到更大的图景中。

- **知识综合**：将不同的信息片段连接起来，展示各个方面如何相互关联，构建连贯的整体图景，识别关键原则或模式，注意重要的影响或结果。

- **模式识别与分析**：积极寻找信息中的模式，比较已知示例中的模式，测试模式的一致性，考虑例外或特殊情况，利用模式指导进一步的调查，寻找创造性的应用。

- **进度跟踪**：频繁检查并保持对已建立的内容、待定事项、当前结论的信心水平、开放问题或不确定性的明确意识，以及对全面理解的进展。

- **递归思维**：在宏观和微观层面上应用相同的细致分析，跨不同规模应用模式识别，保持一致性同时允许规模适应性方法，展示详细分析如何支持更广泛的结论。

## 使用方法

当前中英文prompt版本均已在GPT官方商店上架，openai用户可免费使用：

### 英文版本
TRY the Origin model: [Thinking-GPT](https://chatgpt.com/g/g-673ac16a49d0819189da9e148da1efd4-thinking-gpt)

### 中文版本
使用中文思维协议的GPT：[CN-THINKING-GPT](https://chatgpt.com/g/g-673ac166b9ec8191a7500571fc05c46c-gpt-think)

### 自主使用
当然，你也可以选择自行修改并提交prompt给你的模型进行参考，将本项目克隆到本地并打开prompt文件夹即可看到md文件。

## 注意事项

由于自定义GPT对于prompt的长度限制（8000字符），origin版本的能力可能无法与中文版本媲美。

作者对使用产生的一切后果概不负责。

## 贡献

欢迎贡献代码、报告问题或提出功能建议。请先阅读 [贡献指南](CONTRIBUTING.md) 以了解详细信息。

## 许可证

本项目基于 [MIT 许可证](LICENSE) 进行许可。
