DROP TABLE IF EXISTS `ourphp_productset`;
CREATE TABLE `ourphp_productset` (
`id` int(10) unsigned NOT NULL auto_increment,
`OP_Pattern` int(11) NOT NULL default '0', /*1产品展示模式 2商城模式*/
`OP_Scheme` int(11) NOT NULL default '0', /*1统一价格 2详细价格*/
`OP_Stock` int(11) NOT NULL default '0', /*库存数量报警*/
`OP_buy` int(11) NOT NULL default '0', /*游客是否可以提交订单 1可以 2不可以*/
`OP_Sendout` text, /*发货方式*/
`time` datetime,
`OP_Delivery` int(11) NOT NULL default '0', /*货到付款 0=NO 1=YES*/
`OP_Userbuysms` int(11) NOT NULL default '0',
`OP_Coinname` varchar(255) NOT NULL default '',
PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ourphp_webdeploy`;
CREATE TABLE `ourphp_webdeploy` (
`id` int(10) unsigned NOT NULL auto_increment,
`OP_Weboff` int(11) NOT NULL default '0', /*开站开关 1等于开 2关*/
`OP_Webofftext` text,
`OP_Webrewrite` int(11) NOT NULL default '0', /*伪静态开关 1等于开 2关*/
`OP_Webpage` text, /*翻页*/
`OP_Webkeywords` int(11) NOT NULL default '0', /*关键词优化*/
`OP_Webkeywordsto` text,
`OP_Webdescriptions` text,
`OP_Webfenci` int(11) NOT NULL default '0', /*分词开关 1等于开 2关*/
`OP_Webservice` varchar(255) NOT NULL default '',
`OP_Webocomment` int(11) NOT NULL default '2', /*其它评论开关 1等于开 2关 3登录可以评论*/
`OP_Webpcomment` int(11) NOT NULL default '2', /*商品评论开关 1等于开 2关  3登录可以评论 4只有购买者可以评论*/
`OP_Webweight` int(11) NOT NULL default '1', /*权限方式 1权限 2权重*/
`time` datetime,
`OP_Webfile` int(11) NOT NULL default '1', /*删除附件 1不删 2删*/
`OP_Ucenter` int(11) NOT NULL default '0', 
`OP_Searchtime` int(11) NOT NULL default '10',
`OP_Home` varchar(255) NOT NULL default 'cn|cn|cn', /*网站默认语言*/
`OP_Sensitive` text, /*网站过滤敏感词*/
`OP_Bookuser` int(11) NOT NULL default '0', 
`OP_Adminrecord` text,
`OP_Pagestype` int(11) NOT NULL default '0',
`OP_Pages` text NOT NULL,
`OP_Pagefont` varchar(255) NOT NULL default '',
`OP_Login` text,
`OP_Empower` text,
`OP_Empowerlist` text,
`OP_Empowerright` text,
`OP_Wapurl` varchar(255) NOT NULL default '',
`OP_Webupdate` int(11) NOT NULL default '0',
`OP_Extfile` varchar(255) NOT NULL default '',
PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ourphp_orders`;
CREATE TABLE `ourphp_orders` (
`id` int(10) unsigned NOT NULL auto_increment,
`OP_Ordersname` text, 
`OP_Ordersid` int(11) NOT NULL default '0', 
`OP_Ordersnum` int(11) NOT NULL default '0', 
`OP_Ordersemail` varchar(255) NOT NULL default '', 
`OP_Ordersusername` varchar(255) NOT NULL default '', 
`OP_Ordersusertel` varchar(255) NOT NULL default '', 
`OP_Ordersuseradd` text, 
`OP_Ordersusetext` text, 
`OP_Ordersproductatt` text, 
`OP_Orderswebmarket` decimal(10,2) NOT NULL default '0',
`OP_Ordersusermarket` decimal(10,2) NOT NULL default '0',
`OP_Ordersweight` int(11) NOT NULL default '1', /*重量*/
`OP_Ordersfreight` int(11) NOT NULL default '1', /*运费价格*/
`OP_Ordersexpress` varchar(255) NOT NULL default '', 
`OP_Ordersexpressnum` varchar(255) NOT NULL default '', 
`time` datetime,
`OP_Ordersnumber` varchar(255) NOT NULL default '', 
`OP_Orderspay` int(11) NOT NULL default '1',  /*1 未付款 2已付款*/
`OP_Orderssend` int(11) NOT NULL default '1',  /*1 未发货 2已发货*/
`OP_Ordersgotime` varchar(255) NOT NULL default '2015-01-01 12:00:00',
`OP_Integralok` int(11) NOT NULL default '0', /*是否允许用积分对换 0=普通商品 1=积分兑换*/
`OP_Sign` int(11) NOT NULL default '0', /*是否签收*/
`OP_Ordersclassid` int(11) NOT NULL default '0',
`OP_Ordersadminoper` int(11) NOT NULL default '0',
`OP_Usermoneyback` int(11) NOT NULL default '1',
`OP_Tuanset` int(11) NOT NULL default '1',
`OP_Tuanid` int(11) NOT NULL default '0',
`OP_Ordersimg` varchar(255) NOT NULL default '', /*产品图片*/
`OP_Orderspaytime` varchar(255) NOT NULL default '', 
PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ourphp_shoppingcart`;
CREATE TABLE `ourphp_shoppingcart` (
`id` int(10) unsigned NOT NULL auto_increment,
`OP_Shopproductid` int(11) NOT NULL default '0', 
`OP_Shopnum` int(11) NOT NULL default '0', 
`OP_Shopusername` varchar(255) NOT NULL default '', 
`OP_Shopatt` text, 
`OP_Shopkc` varchar(255) NOT NULL default '', 
`OP_Shophh` varchar(255) NOT NULL default '', 
`time` datetime,
PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ourphp_api`;
CREATE TABLE `ourphp_api` (
`id` int(10) unsigned NOT NULL auto_increment,
`OP_Key` text,  
`time` datetime,
`OP_Keyid` varchar(255) NOT NULL default '',
PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ourphp_freight`;
CREATE TABLE `ourphp_freight` (
`id` int(10) unsigned NOT NULL auto_increment,
`OP_Freightname` varchar(255) NOT NULL default '', 
`OP_Freighttext` text,  
`OP_Freightdefault` int(11) NOT NULL default '0', 
`OP_Freightweight` int(11) NOT NULL default '0', 
`time` datetime,
PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ourphp_search`;
CREATE TABLE `ourphp_search` (
`id` int(10) unsigned NOT NULL auto_increment,
`OP_Searchtext` text,  
`OP_Searchclick` int(11) NOT NULL default '0', 
`time` datetime,
PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ourphp_comment`;
CREATE TABLE `ourphp_comment` (
`id` int(10) unsigned NOT NULL auto_increment,
`OP_Content` text,  /*内容*/
`OP_Class` int(11) NOT NULL default '0', /*分类*/
`OP_Type` varchar(255) NOT NULL default '', /*类别*/
`OP_Name` varchar(255) NOT NULL default '', /*姓名*/
`OP_Ip` varchar(255) NOT NULL default '', /*IP*/
`OP_Vote` int(11) NOT NULL default '0', /*好评*/
`OP_Scoring` varchar(255) NOT NULL default '', /*打分*/
`OP_Gocontent` text,  /*回复*/
`OP_Gotime` varchar(255) NOT NULL default '', /*回复时间*/
`time` datetime,
`OP_Usernick` varchar(255) NOT NULL default '',
`OP_Userimg` varchar(255) NOT NULL default '',
PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ourphp_plus`;
CREATE TABLE `ourphp_plus` (
`id` int(10) unsigned NOT NULL auto_increment,
`OP_Name` varchar(255) NOT NULL default '', /*插件名称*/
`OP_Version` varchar(255) NOT NULL default '', /*插件版本*/
`OP_Versiondate` varchar(255) NOT NULL default '', /*更新日期*/
`OP_Author` varchar(255) NOT NULL default '', /*插件作者*/
`OP_Fraction` varchar(255) NOT NULL default '', /*分数*/
`OP_About` text, /*插件介绍*/
`OP_Pluspath` text, /*管理路径*/
`OP_Time` date, /*安装日期*/
`OP_Off` int(11) NOT NULL default '1', /* 1关闭 2开启*/
`OP_Plugid` varchar(255) NOT NULL default '', /* 插件ID*/
`OP_Plugclass` varchar(255) NOT NULL default '', /* 插件类型*/
`OP_Plugmysql` varchar(255) NOT NULL default '', /* 插件数据表*/
`OP_Plugadminid` int(11) NOT NULL default '0',
PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ourphp_integral`;
CREATE TABLE `ourphp_integral` (
`id` int(10) unsigned NOT NULL auto_increment,
`OP_Iid` int(11) NOT NULL default '0', /* 产品ID*/
`OP_Iname` varchar(255) NOT NULL default '', /*产品名称*/
`OP_Imarket` decimal(10,2) NOT NULL default '0',/*产品价格*/
`OP_Iwebmarket` decimal(10,2) NOT NULL default '0',/*本站价格*/
`OP_Iintegral` decimal(10,2) NOT NULL default '0', /*积分*/
`OP_Ivirtual` int(11) NOT NULL default '0', /*虚拟实物 0=实物 1=虚拟*/
`OP_Iconfirm` int(11) NOT NULL default '0', /*确认领取 0=未领 1=领取*/
`OP_Iuseremail` varchar(255) NOT NULL default '', /*会员账号*/
`OP_Iadmin` int(11) NOT NULL default '0', /*管理权限 0=会员 1=管理*/
`OP_ITime` varchar(255) NOT NULL default '', /*领取时间*/
`time` datetime, /*产生时间*/
PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;