DROP TABLE IF EXISTS `ourphp_watermark`;
CREATE TABLE `ourphp_watermark` (
`id` int(10) unsigned NOT NULL auto_increment,
`OP_Watermarkimg` varchar(255) NOT NULL default '',
`OP_Watermarkfont` varchar(255) NOT NULL default '',
`OP_Watermarkcolor` varchar(255) NOT NULL default '',
`OP_Watermarksize` varchar(255) NOT NULL default '',
`OP_Watermarkposition` int(11) NOT NULL default '0',
`OP_Watermarkoff` int(11) NOT NULL default '0', /*1打开 2关闭*/
`OP_Imgcompress` varchar(255) NOT NULL default 'ourphp',
PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ourphp_temp`;
CREATE TABLE `ourphp_temp` (
`id` int(10) unsigned NOT NULL auto_increment,
`OP_Temppath` varchar(255) NOT NULL default '',
`OP_Tempauthor` varchar(255) NOT NULL default '',
PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ourphp_lang`;
CREATE TABLE `ourphp_lang` (
`id` int(10) unsigned NOT NULL auto_increment,
`OP_Lang` varchar(255) NOT NULL default '',
`OP_Font` varchar(255) NOT NULL default '',
`OP_Default` varchar(255) NOT NULL default '',
`OP_Note` varchar(255) NOT NULL default '',
`OP_Langtitle` varchar(255) NOT NULL default '',
`OP_Langkeywords` text,
`OP_Langdescription` text,
`OP_Webname` varchar(255) NOT NULL default '',
`OP_Webadd` varchar(255) NOT NULL default '',
`OP_Weblinkman` varchar(255) NOT NULL default '',
PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ourphp_adminclick`;
CREATE TABLE `ourphp_adminclick` (
`id` int(10) unsigned NOT NULL auto_increment,
`OP_Title` varchar(255) NOT NULL default '',
`OP_Url` varchar(255) NOT NULL default '',
`OP_Click` int(11) NOT NULL default '0',
PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ourphp_mail`;
CREATE TABLE `ourphp_mail` (
`id` int(10) unsigned NOT NULL auto_increment,
`OP_Mailsmtp` varchar(255) NOT NULL default '',
`OP_Mailport` int(11) NOT NULL default '0',
`OP_Mailusermail` varchar(255) NOT NULL default '',
`OP_Mailuser` varchar(255) NOT NULL default '',
`OP_Mailpass` varchar(255) NOT NULL default '',
`OP_Mailsubject` varchar(255) NOT NULL default '',
`OP_Mailcontent` text,
`OP_Mailtype` varchar(255) NOT NULL default '',
`OP_Mailtitle` varchar(255) NOT NULL default '', /*邮件类型*/
`OP_Mailclass` int(11) NOT NULL default '0', /*1开启 2关闭*/
PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ourphp_column`;
CREATE TABLE `ourphp_column` (
`id` int(10) unsigned NOT NULL auto_increment,
`OP_Uid` int(11) NOT NULL default '0',
`OP_Lang` varchar(255) NOT NULL default '',  /*语言类别*/
`OP_Columntitle` varchar(255) NOT NULL default '',  /*主标题*/
`OP_Columntitleto` varchar(255) NOT NULL default '', /*副标题*/
`OP_Model` varchar(255) NOT NULL default '', /*模型*/
`OP_Templist` varchar(255) NOT NULL default '', /*列表页模板*/
`OP_Tempview` varchar(255) NOT NULL default '', /*内容页模板*/
`OP_Url` varchar(255) NOT NULL default '', /*外部链接地址*/
`OP_About` text, /*单页面*/
`OP_About_wap` text, /*单页面*/
`OP_Hide` int(11) NOT NULL default '0', /*栏目隐藏与显示，0为显示 1为隐藏*/
`OP_Sorting` int(11) NOT NULL default '0', /*栏目排序*/
`OP_Briefing` text, /*栏目介绍*/
`OP_Img` varchar(255) NOT NULL default '', /*栏目图片*/
`OP_Userright` varchar(255) NOT NULL default '', /*栏目权限*/
`OP_Weight` int(11) NOT NULL default '0', /*栏目权重*/
`OP_Adminopen` text, /*管理权限*/
`OP_Total` int(11) NOT NULL default '0',
`OP_Click` int(11) NOT NULL default '0',
`OP_Tag` varchar(255) NOT NULL default '',
`OP_Description` text,
`OP_Fielddiy` text,
PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ourphp_product`;
CREATE TABLE `ourphp_product` (
`id` int(10) unsigned NOT NULL auto_increment,
`OP_Class` int(11) NOT NULL default '0',
`OP_Lang` varchar(255) NOT NULL default '',  /*语言类别*/
`OP_Title` varchar(255) NOT NULL default '',  /*标题*/
`OP_Number` varchar(255) NOT NULL default '',  /*编号*/
`OP_Goodsno` varchar(255) NOT NULL default '',  /*货号*/
`OP_Brand` varchar(255) NOT NULL default '',  /*品牌*/
`OP_Market` decimal(10,2) NOT NULL default '0',  /*市场价*/
`OP_Webmarket` decimal(10,2) NOT NULL default '0',  /*本站价*/
`OP_Stock` int(11) NOT NULL default '0',  /*库存*/
`OP_Usermoney` text,  /*会员价格*/
`OP_Specificationsid` varchar(255) NOT NULL default '',  /*规格ID*/
`OP_Specificationstitle` text,  /*规格标题*/
`OP_Specifications` text,  /*产品规格*/
`OP_Pattribute` text,  /*产品属性*/
`OP_Minimg` varchar(255) NOT NULL default '',  /*缩略图*/
`OP_Maximg` varchar(255) NOT NULL default '',  /*大图*/
`OP_Img` text,  /*组图*/
`OP_Content` text,  /*内容*/
`OP_Content_wap` text,  /*内容*/
`OP_Down` int(11) NOT NULL default '0', /*下架 1下架 2不下架*/
`OP_Weight` int(11) NOT NULL default '1', /*重量*/
`OP_Freight` int(11) NOT NULL default '1', /*运费模板*/
`OP_Tag` varchar(255) NOT NULL default '', /*标签*/
`OP_Sorting` int(11) NOT NULL default '0', /*排序*/
`OP_Attribute` varchar(255) NOT NULL default '', /*属性*/
`OP_Url` varchar(255) NOT NULL default '',
`OP_Description` text, /*描述*/
`OP_Click` int(11) NOT NULL default '0', /*点击量*/
`time` datetime,
`OP_Integral` decimal(10,2) NOT NULL default '0', /*商品赠送积分 v1.2.2*/
`OP_Integralok` int(11) NOT NULL default '0', /*是否允许用积分对换 0=否 1=是*/
`OP_Integralexchange` decimal(10,2) NOT NULL default '0', /*兑换积分*/
`OP_Suggest` varchar(255) NOT NULL default '', /*一句话介绍*/
`OP_Productimgname` varchar(255) NOT NULL default '',
`OP_Usermoneyclass` int(11) NOT NULL default '1',
`OP_Tuanset` int(11) NOT NULL default '1',
`OP_Tuanusernum` int(11) NOT NULL default '0',
`OP_Tuantime` varchar(255) NOT NULL default '',
`OP_Tuannumber` int(11) NOT NULL default '0',
`OP_Buynum` int(11) NOT NULL default '0',
`OP_Couponset` varchar(255) NOT NULL default '0',
`OP_Buyoffnum` int(11) NOT NULL default '0',
`OP_Buytotalnum` int(11) NOT NULL default '0',
`OP_Distribution` int(11) NOT NULL default '0',
`OP_Fielddiy` text,
`OP_Searchtop` int(11) NOT NULL default '0',
PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ourphp_productcp`;
CREATE TABLE `ourphp_productcp` (
`id` int(10) unsigned NOT NULL auto_increment,
`OP_Vender` varchar(255) NOT NULL default '', 
`OP_Brand` varchar(255) NOT NULL default '', 
`OP_Class` int(11) NOT NULL default '0', /*1厂商 2品牌*/
`OP_Img` varchar(255) NOT NULL default '',  /*品牌图片*/
`time` datetime,
PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ourphp_productattribute`;
CREATE TABLE `ourphp_productattribute` (
`id` int(10) unsigned NOT NULL auto_increment,
`OP_Title` varchar(255) NOT NULL default '', 
`OP_Class` varchar(255) NOT NULL default '', 
`OP_Text` text,
`OP_Sorting` int(11) NOT NULL default '0', /*排序*/
`time` datetime,
PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ourphp_productspecifications`;
CREATE TABLE `ourphp_productspecifications` (
`id` int(10) unsigned NOT NULL auto_increment,
`OP_Title` varchar(255) NOT NULL default '', 
`OP_Titleto` varchar(255) NOT NULL default '',
`OP_Value` text, /*值*/
`OP_Class` int(11) NOT NULL default '0', /*1文字 2图片*/
`OP_Img` varchar(255) NOT NULL default '', 
`OP_Sorting` int(11) NOT NULL default '0', /*排序*/
`time` datetime,
PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;