# GitTraining

This repository is designed to walk you through some of the more common Git operations you will need to know and use as a developer.

# Getting started
Clone this repository to your local machine. You may need to [install Git](https://git-scm.com/downloads) if it isn't already installed.
If you aren't sure if you have Git or not, simply run `git --help` from the command line.
It will return a helpful message with some common commands if it is installed.


### Git Basics
* [What is source control?](http://slides.com/justinc/deck#/)
* [Learn You a Git](http://slides.com/justinc/learn-you-a-git#/)
* [Github Interactive Tutorial](https://try.github.io/levels/1/challenges/1)

### Configure who you are
- Set your user name with `git config --global user.name "your name"`
- Set your email with `git config --global user.email "you@email.domain"`

### Useful references
If you have questions or get stuck the following resources may help you.

- [The official Git documentation](https://git-scm.com/docs)
- Google and StackOverflow
- GitHub and Atlassian have some well written general Git documentation
- Your coworkers


# Section 1: Tracking Changes
**Topics:** Checkout, commit, revert, merge, log, move, and remove.

Files for the section can be found in the `section1` directory.

## Committing Changes
- Checkout the `dev` branch.
- Make a new branch and add your self to the list of people in `people.md`.
- Commit your changes.
- You will be asked to make a commit message. This will open a text editor. Save and quit the text editor to complete the commit. **Note:** Git uses the system default editor. On vanilla Git Bash in Windows the default text editor is Vim.
- If you need to edit the commit message for your last commit you can use the `git commit --amend` command.

## Undoing Changes

### Uncommitted Changes
- Make a change to any of the files in the repository.
- Run `git status` to see what files were changed.
- Stage the file using `git add`, but do not commit.
- Unstage the file with `git reset`.
- Use git to undo the changes you made and reset the file to the state it was in when it was committed. `git status` should report no modified files.


### Committed Changes
Tony made 3 commits to the dev branch. He misunderstood the project requirements and the changes introduced with his two last commits need to be removed.
- Checkout the dev branch.
- Determine what changed between his first and last commit, then revert the two most recent of his commits. Git has diff and log tools which will help.
- There are a few ways to undo commits. It is best practice to preserve history whenever possible. The `git revert` command which will keep the commits in the repository history, but remove the changes introduced by the commit.
    - **TIP:** If you are reverting multiple commits that modify one file it is easiest to start at the most recent commit you want to revert and work backwards.
- You will need to make a commit when you revert the changes.

### Rewriting History
Sometimes you may want to undo a commit you have made or even erase it from existence. 

**WARNING:** This is generally considered bad practice. Only do this for commits you have not pushed to a remote repository (more on those later).

- Make a change to a local file.
- Add and commit the file.

#### Undoing a commit:
- run `git reset HEAD~1`
- This will put you back 1 commit behind the latest but preserve the changes that were committed with it. Your changes will still be there and you can see the modified files with `git status`.

#### Removing a commit from existence:
- run `git reset --hard HEAD~1`
- This will put you back 1 commit behind the latest and nuke the previous from existence.


## Moving, removing, and ignoring files
Someone checked in a temp file generated by their text editor. Stop git from tracking this file, remove it, and update the `.gitignore` file to prevent `.tmp` files from being tracked in the future.

Someone misnamed the `rename_me.md` file. Git has a command to move or rename a file while retaining its history. Use this to rename the file to `newname.md`.

# Section 2: Working with multiple branches, and merging the work of others
**Topics:** Stash, diff, merge, merge conflicts

Files for this section can be found in the `section2` directory.

### Merging
Sometimes two people will make changes to the same file on separate branches. 
When these branches are merged it can cause a merge conflict. 
As the developer performing the merge it is your job to decide what changes to keep.

You have been tasked with updating the installation instructions for your product.
- Checkout your branch again.
- Open the `installation.md` file and add install instructions (It doesn't matter what they actually say).
- Commit your changes.
- Andrew tells you he has been working on the installation instructions, and updated the uninstall section.
- Merge Andrew's branch into yours and resolve the conflict so the file contains both of your changes.
- After you have finished your changes your manager wants to see them in the dev branch. Merge your branch into dev. This time there should not be any conflicts.

### Stashing changes
Git has a function to stash local changes without committing them.

You are working on your local branch, when your coworker Taylor comes over and asks you to try running their code. You are not yet ready to commit your code, but you want to look at Taylor's branch without losing your progress.
- Make some changes to the `stash_me.md` file.
- Use the `git stash` command to stash your work.
- Checkout Taylor's branch.
- Checkout your branch again.
- Use `git stash pop` to get your work back.
- You can discard these changes or commit them.


# Section 3: Remotes and sharing your changes
**Topics:** Remote repositories, syncing changes, and forking a repository.

At the beginning you cloned this repository from GitHub. You have all of your changes stored locally, now you need to share them. 
Git uses the concept of remotes to track where you cloned a repository from. you may also hear these referred to as the upstream repository. 
Right now the remote for your repository is set to the repository you cloned from.

To send you changes to a remote repository so others can view and use them you need to push them using the `git push` command. 
You can see if any changes have been made to the remote repository by running `git fetch`. 
To pull changes for the current branch into your local copy of the repository use the `git pull` command.
It is good practice to check for changes before pushing to a remote.

If you try to run `git push` right now you will get a message that you do not have permission to push to this repository. Most remote repositories have security in place to prevent just anyone from pushing their changes. You will make another remote copy of the repository that you can push your changes to.

 Visit the repository on GitHub and fork it so you have a copy under your user account. 
 Now update the remote for the copy of the repository you changed, and push your changes to the `dev` branch to your fork on GitHub. 
 If a branch does not exist in the remote repository git will inform you.
 Try pushing your branch. What is the message? 
 What do you need to do to push your new branch?
