"""
    Model store which provides pretrained models.
"""

__all__ = ['get_model_file']

import os
import zipfile
import logging
from mxnet.gluon.utils import download, check_sha1

_model_sha1 = {name: (error, checksum, repo_release_tag) for name, error, checksum, repo_release_tag in [
    ('alexnet', '1610', '4dd7cfb6275229c3b3889ec7ad29f8d48a499193', 'v0.0.481'),
    ('alexnetb', '1705', '0181007ac2ba5d5c051346af1eea4a00c36f34e9', 'v0.0.485'),
    ('zfnet', '1678', '3299fdce9712697f9e03e1a0cf741745553a28cf', 'v0.0.395'),
    ('zfnetb', '1459', '7a654810eced689323e414030165cf1392c9684f', 'v0.0.400'),
    ('vgg11', '1016', '3d78e0ec95d358577acf8b2e2f768a72ec319ee3', 'v0.0.381'),
    ('vgg13', '0950', 'd2bcaaf3704afb47b2818066255b3de65d0c03e1', 'v0.0.388'),
    ('vgg16', '0832', '22fe503aa438ebfd1f3128b676db21a06de3cd59', 'v0.0.401'),
    ('vgg19', '0767', 'e198aa1f6519b3331e5ebbe782ca35fd2aca6213', 'v0.0.420'),
    ('bn_vgg11', '0934', '3f79cab1e9e0bab0d57c0f80a6c9782e5cdc765d', 'v0.0.339'),
    ('bn_vgg13', '0887', '540243b0a3eb2ae3974c2d75cf82e655fa4f0dda', 'v0.0.353'),
    ('bn_vgg16', '0757', '90441925c7c19c9db6bf96824c2440774c0e54df', 'v0.0.359'),
    ('bn_vgg19', '0689', 'cd8f4229e5e757ba951afc6eb1a4ec7a471022f7', 'v0.0.360'),
    ('bn_vgg11b', '0975', '685ae89dcf3916b9c6e887d4c5bc441a34253744', 'v0.0.407'),
    ('bn_vgg13b', '0912', 'fc678318391d45465bda4aa17744dc0d148135e3', 'v0.0.488'),
    ('bn_vgg16b', '0775', '77dad99b4f72176870655ffbf59e96f3b9570a0b', 'v0.0.489'),
    ('bn_vgg19b', '0735', '8d9a132bfd9230304e588ec159170ee3173d64ba', 'v0.0.490'),
    ('bninception', '0754', '75225419bae387931f6c8ccc19dc48fb1cc8cdae', 'v0.0.405'),
    ('resnet10', '1220', '83ebb0937d85142c3f827be56f08a57a5996c90b', 'v0.0.569'),
    ('resnet12', '1203', 'a41948541130b9ebf8285412b38c668198e4ad4f', 'v0.0.485'),
    ('resnet14', '1086', '5d9f22a7aa6c821eb69fc043af2da040f36110eb', 'v0.0.491'),
    ('resnetbc14b', '1033', '4ff348bebc7696cd219be605668bb76546dd9641', 'v0.0.481'),
    ('resnet16', '0978', '2c28373c9ce1f50ff6a4b47a16a3d1bc2e557c75', 'v0.0.493'),
    ('resnet18_wd4', '1740', 'a74ea15d056a84133e02706a6c7f8ed8f50c8462', 'v0.0.262'),
    ('resnet18_wd2', '1284', '9a5154065311c8ffbbc57b20a443b205c7a910fa', 'v0.0.263'),
    ('resnet18_w3d4', '1066', '1a574a4198a5bbf01572c2b3f091eb824ff8196e', 'v0.0.266'),
    ('resnet18', '0867', '711ed8ab624c4c580e90321989aef6174ad2991d', 'v0.0.478'),
    ('resnet26', '0823', 'a2746eb21d73c3c85edacabe36d680988986f890', 'v0.0.489'),
    ('resnetbc26b', '0758', '2b5e8d0888936a340ea13c7e8ba30b237cd62f1c', 'v0.0.313'),
    ('resnet34', '0743', '5cdeeccda6f87fe13aed279213006061a8b42037', 'v0.0.291'),
    ('resnetbc38b', '0672', '820944641ba54f4aaa43d2a305ab52b9dcb740c7', 'v0.0.328'),
    ('resnet50', '0604', 'a71d1d2a8e8e4259742bbd67c386623233b57c6c', 'v0.0.329'),
    ('resnet50b', '0611', 'ca12f8d804000bf5202e2e3838dec7ef6b772149', 'v0.0.308'),
    ('resnet101', '0516', '75a3105c609aedb89d63dd3dc47b578f41fff6be', 'v0.0.499'),
    ('resnet101b', '0512', 'af5c4233b28c8b7acd3b3ebe02f9f2eda2c77824', 'v0.0.357'),
    ('resnet152', '0444', '15f2dd80f964225e685e7564cecd04911feb97ee', 'v0.0.518'),
    ('resnet152b', '0429', '45a3ad0f989852a4456c907fa3b40b00dd24937c', 'v0.0.517'),
    ('preresnet10', '1401', '2b96c0818dbabc422e98d8fbfc9b684c023922ed', 'v0.0.249'),
    ('preresnet12', '1321', 'b628efb5415784075e18b6734b1ba1e5c7280dee', 'v0.0.257'),
    ('preresnet14', '1218', 'd65fa6287414d9412e34ac0df6921eaa5646a2b6', 'v0.0.260'),
    ('preresnetbc14b', '1151', 'c712a235b75ad4956411bab265dfd924c748726e', 'v0.0.315'),
    ('preresnet16', '1081', '5b00b55f74adb9ee4a6ba5f946aafd48b4d8aa47', 'v0.0.261'),
    ('preresnet18_wd4', '1778', '3d949d1ae20b9188a423b56a1f7a89b4bcecc3d2', 'v0.0.272'),
    ('preresnet18_wd2', '1319', '63e55c24bc0ae93a8f8daefa4b35dc3e70147f65', 'v0.0.273'),
    ('preresnet18_w3d4', '1068', 'eb5698616757fd0947851f62c33fc4d7b4a5f23a', 'v0.0.274'),
    ('preresnet18', '0951', '71279a0b7339f1efd12bed737219a9ed76175a9d', 'v0.0.140'),
    ('preresnet26', '0834', 'c2ecba0948934c28d459b7f87fbc1489420fd4fb', 'v0.0.316'),
    ('preresnetbc26b', '0786', '265f591f320db0915c18c16f4ed0e2e53ee46567', 'v0.0.325'),
    ('preresnet34', '0751', 'ba9c829e72d54f8b02cf32ea202c195d36568467', 'v0.0.300'),
    ('preresnetbc38b', '0633', '809d2defea82276fdd7ff2faafc1f6ffe57c93b5', 'v0.0.348'),
    ('preresnet50', '0620', '50f13b2d3fd197c8aa721745adaf2d6615fd8c16', 'v0.0.330'),
    ('preresnet50b', '0632', '951de2dc558f94f489ce62fedf979ccc08361641', 'v0.0.307'),
    ('preresnet101', '0534', 'ea9a1724662744fe349c0aa8dd0ec42708fe88c7', 'v0.0.504'),
    ('preresnet101b', '0540', '3839a4733a8a614bb6b7b4f555759bb5b8013d42', 'v0.0.351'),
    ('preresnet152', '0446', '3b41bd93a7a2807e8cc88ae75ec0cde69af1e786', 'v0.0.510'),
    ('preresnet152b', '0438', 'ebf71d023e88d006c55946e3c6cf38c5d0cffeb2', 'v0.0.523'),
    ('preresnet200b', '0446', '70135e6618bd8e870574a2667d3ec592238b3a3c', 'v0.0.529'),
    ('preresnet269b', '0501', '6e56119dc52a38af690bb41d4ae1683007558233', 'v0.0.545'),
    ('resnext14_16x4d', '1223', '1f8072e8d01d1427941a06bbca896211e98e2b75', 'v0.0.370'),
    ('resnext14_32x2d', '1247', '2ca8cc2544045c21d0a7ca740483097491ba0855', 'v0.0.371'),
    ('resnext14_32x4d', '1110', '9be6190e328c15a06703be3ba922d707c2f4d8e7', 'v0.0.327'),
    ('resnext26_32x2d', '0850', 'a1fb4451be6336d9f648ccc2c2dedacc5704904a', 'v0.0.373'),
    ('resnext26_32x4d', '0721', '5264d7efd606e1c95a2480050e9f03a7a2f02b09', 'v0.0.332'),
    ('resnext50_32x4d', '0545', '748e53b31fe716b5fdd059107d22bdfec3a31839', 'v0.0.498'),
    ('resnext101_32x4d', '0418', 'c07faa66647bd25dd222b44d8782c59fcc2e3708', 'v0.0.530'),
    ('resnext101_64x4d', '0439', '178e79057f27afec04219aa1a1a96abbbd8763a9', 'v0.0.544'),
    ('seresnet10', '1169', '675d4b5bbaaab1b87988df96819cd19e5323512c', 'v0.0.486'),
    ('seresnet12', '1176', 'df10dd88759750bb042ce7b09dd8a78f32d78e12', 'v0.0.544'),
    ('seresnet14', '1095', '579e2fecfe37d1c9422f6521fef610bfde6fcaaa', 'v0.0.545'),
    ('seresnet16', '0972', 'ef50864856c2120082e3db7d4193f31ec77624c6', 'v0.0.545'),
    ('seresnet18', '0920', '85a6b1da19645419cc3075852588cc7e7da5715f', 'v0.0.355'),
    ('seresnet26', '0803', '9f9004192240ae0125399d2f6acbb5359027039d', 'v0.0.363'),
    ('seresnetbc26b', '0682', '15ae6e19b1626107029df18bf3f5140e6fcb2b02', 'v0.0.366'),
    ('seresnetbc38b', '0575', 'f80f0c3c2612e1334204df1575b8a7cd18f851ff', 'v0.0.374'),
    ('seresnet50', '0560', 'e75ef498abfc021f356378b2c806de8927287fe7', 'v0.0.441'),
    ('seresnet50b', '0533', '0d8f0d23bb980621095e41de69e3a68d7aaeba45', 'v0.0.387'),
    ('seresnet101', '0441', 'f9cb9df623683520522c5fe8577e8a93cf253f46', 'v0.0.533'),
    ('seresnet101b', '0462', '59fae71a5db6ad1f1b5a79f7339920aa1191ed70', 'v0.0.460'),
    ('seresnet152', '0430', 'c712f55410938861c32740fe93770b0d54e094a3', 'v0.0.538'),
    ('sepreresnet10', '1221', 'c3ab94ee5c938f53a8a61849be3a463458444a1f', 'v0.0.544'),
    ('sepreresnet12', '1180', 'd6b7260b4931e8806368c42b8bb605b9a8afaa23', 'v0.0.543'),
    ('sepreresnet16', '0956', 'b5e4e06f6f5394f7557986193700a8ecf23ffdc7', 'v0.0.543'),
    ('sepreresnet18', '0881', 'b018c6e38601b0719445e302ea64196924319814', 'v0.0.543'),
    ('sepreresnet26', '0804', 'a2e48457a44958ed7f20940997f419080b1d14e8', 'v0.0.543'),
    ('sepreresnetbc26b', '0636', '33c94c9dd2986d0643f7c432d5203294ecf2124e', 'v0.0.399'),
    ('sepreresnetbc38b', '0563', 'd8f0fbd35b840743e312b9ec944c7fc141824ace', 'v0.0.409'),
    ('sepreresnet50b', '0532', '5b620ff7175c674ef41647e2e79992dceefeec19', 'v0.0.461'),
    ('seresnext50_32x4d', '0433', 'd74d1d0a5bd1449562e9f1de92b1389c647fdd13', 'v0.0.505'),
    ('seresnext101_32x4d', '0444', '3c89aec5b98c1bfca13bc8c21e07dba82243c012', 'v0.0.529'),
    ('seresnext101_64x4d', '0408', '2e039a419e4eb84ce93d1515027099c4dc13f5a1', 'v0.0.561'),
    ('senet16', '0806', 'ba26802160725af926e5a3217f8848bd3a6599fd', 'v0.0.341'),
    ('senet28', '0591', 'd5297a35a2e56ecc892499c1bd4373125a40b783', 'v0.0.356'),
    ('senet154', '0440', 'c0e2d2b9e70894e28e4f957296229bdd89b70607', 'v0.0.522'),
    ('resnestabc14', '0634', '4b0cbe8c59e9d764027f51670096037e2f058970', 'v0.0.493'),
    ('resnesta18', '0689', '8f37b6927751b27a72c1b8c625de265da9b31570', 'v0.0.489'),
    ('resnestabc26', '0470', 'f88d49d7bd6cdf1f448afdf4bc5dadd9921798dd', 'v0.0.495'),
    ('resnesta50', '0438', '6ce54a97d6e6fe8aa66755669b8f47a0790bfeb6', 'v0.0.531'),
    ('resnesta101', '0399', 'ab6c6f89407d7b2cf89406f7bb62a48e86d7cabc', 'v0.0.465'),
    ('resnesta152', '0451', '532c448de0011e90924b3c1e829f9525c6a5420e', 'v0.0.540'),
    ('resnesta200', '0340', '3bd1f0c8d9a2862b89590c1c490a38d6d982522c', 'v0.0.465'),
    ('resnesta269', '0336', '8333862a0c016432f6cd5b45f7e9de7ee6e3f319', 'v0.0.465'),
    ('ibn_resnet50', '0559', '0f75710a144ea1483e6235f6909f8b8c3555ec01', 'v0.0.495'),
    ('ibn_resnet101', '0489', 'db938be9060c0ea48913fa0fa9794bf6bcacea7f', 'v0.0.552'),
    ('ibnb_resnet50', '0579', '146aa6e143d582cd33af23c942e3e0b2fe152817', 'v0.0.552'),
    ('ibn_resnext101_32x4d', '0487', '1398597e25f0be2d7b05f190c5c53f7b8d5265e6', 'v0.0.553'),
    ('ibn_densenet121', '0646', '82ee3ff44fd308107ec07d759c52a99e94af7041', 'v0.0.493'),
    ('ibn_densenet169', '0608', 'b509f33947b2f205f03e49ce2d5ee87855bbf708', 'v0.0.500'),
    ('airnet50_1x64d_r2', '0523', '1f982e0e8b3af40a5d67ca854f18ca837aa332f4', 'v0.0.522'),
    ('airnet50_1x64d_r16', '0544', '09a9f13b9d5f3e27eb26271070cc4bf8dd72cf9f', 'v0.0.519'),
    ('airnext50_32x4d_r2', '0504', '664dd077a978562a376e8ab70b5d740893873111', 'v0.0.521'),
    ('bam_resnet50', '0538', 'fa612c3da552cd26094634c359413db69d0ef97b', 'v0.0.499'),
    ('cbam_resnet50', '0488', 'ebd4af235d763f4ecce6dd4e09b508ba61b561f7', 'v0.0.537'),
    ('scnet50', '0511', '359d35d017e838d3c3c2bdf1cc83074610dc3c5b', 'v0.0.493'),
    ('scnet101', '0446', 'bc5cade042e78813db4ce5878d733daa0ce7f89d', 'v0.0.507'),
    ('scneta50', '0459', 'c1f6f0286ed942bbc468395b82b7be84312f3c73', 'v0.0.509'),
    ('regnetx002', '1038', '7800b310f45b4666ef6c862bc8a2573f65ddaa40', 'v0.0.475'),
    ('regnetx004', '0855', 'b933a72fe7304a31391a9e9fcdf7ffc47ea05353', 'v0.0.479'),
    ('regnetx006', '0756', 'd41aa087bd288266105142b88b03b67d74352a46', 'v0.0.482'),
    ('regnetx008', '0724', '79309908dee31eda64e824a9b3bd33c0afaaf5a8', 'v0.0.482'),
    ('regnetx016', '0613', '018dbe2d89d2bac26f41d98b09ba57b049ed4cfe', 'v0.0.486'),
    ('regnetx032', '0568', '6d4372fcf0b9d6e3edefa99e72dd411b6a0c676c', 'v0.0.492'),
    ('regnetx040', '0469', 'c22092c7ceeac713a9102c697f23bec0b7cfaec0', 'v0.0.495'),
    ('regnetx064', '0458', '473342937e02dce6244a62780f98aed1f5eb831d', 'v0.0.535'),
    ('regnetx080', '0466', '4086910ad9df1693db658c86f874f686a279175c', 'v0.0.515'),
    ('regnetx120', '0518', 'ea20b368214230ce65c14218aedba07b68235e38', 'v0.0.542'),
    ('regnetx160', '0456', '941840a38b20e5b5c6ca092bed3f2ea0ff602895', 'v0.0.532'),
    ('regnetx320', '0394', 'a120c8d2d181dacffde8a3029292ee59da12e9be', 'v0.0.548'),
    ('regnety002', '0953', 'b37fcac05e59ba5e751701da8e81195bbfbf3db8', 'v0.0.476'),
    ('regnety004', '0747', '5626bdf45eaf0f23ddc6e1b68f6ad2db7ca119cf', 'v0.0.481'),
    ('regnety006', '0697', '81372679b5f9601a5bc72caa13aff378d2ac4233', 'v0.0.483'),
    ('regnety008', '0645', 'd92881be768a267f1cd2b540d087884bbe93f644', 'v0.0.483'),
    ('regnety016', '0568', 'c4541a25e92ebf31d9bddb4975738c08fe929836', 'v0.0.486'),
    ('regnety032', '0413', '9066698526cbc930706fe00b21ca56c31ad7e2e4', 'v0.0.473'),
    ('regnety040', '0467', '6039a215ee79a7855156c5166df4c6b34f8d501d', 'v0.0.494'),
    ('regnety064', '0445', '8ae16f971eacad369df091e68c26e63b8c6da9a5', 'v0.0.513'),
    ('regnety080', '0436', '4cd7fc61d54ec63bfeff11246e8258188351e7ed', 'v0.0.516'),
    ('regnety120', '0431', 'effa35b601ffbdced20342d9bfe3917a8279880a', 'v0.0.526'),
    ('regnety160', '0430', '8273156944dea5a439ef55e7ed84a10524be090c', 'v0.0.527'),
    ('regnety320', '0373', 'd26a5f80c1d67e3527ddbdce75683370c5799e06', 'v0.0.550'),
    ('pyramidnet101_a360', '0520', '3a98a2bfc4e74b00b5fff20783613281121a6d37', 'v0.0.507'),
    ('diracnet18v2', '1117', '27601f6fa54e3b10d77981f30650d7a9d4bce91e', 'v0.0.111'),
    ('diracnet34v2', '0946', '1faa6f1245e152d1a3e12de4b5dc1ba554bc3bb8', 'v0.0.111'),
    ('crunet56', '0536', 'd7112ed431630f4162fb2ebe7a7c0666fa1718a8', 'v0.0.558'),
    ('densenet121', '0685', 'd3a1fae8b311343498f736e494d60d32e35debfb', 'v0.0.314'),
    ('densenet161', '0592', '29897d410ea5ae427278df060de578911df74667', 'v0.0.432'),
    ('densenet169', '0605', '9c045c864828e773f92f998199821fc0c21e0eb4', 'v0.0.406'),
    ('densenet201', '0590', '89aa8c295b21fdd682df0027d2232e6dabf2cace', 'v0.0.426'),
    ('condensenet74_c4_g4', '0864', 'cde68fa2fcc9197e336717a17753a15a6efd7596', 'v0.0.4'),
    ('condensenet74_c8_g8', '1049', '4cf4a08e7fb46f5821049dcae97ae442b0ceb546', 'v0.0.4'),
    ('peleenet', '0979', '758d3cf992a6c92731069be091be2e8ebd3209e2', 'v0.0.496'),
    ('wrn50_2', '0606', '5ff344cae22c8ce3f21e042be5a5d899681d89a0', 'v0.0.520'),
    ('drnc26', '0711', 'e69a4e7bc94aab58e05880c886e8e829584845c3', 'v0.0.508'),
    ('drnc42', '0614', '6ee5008a3e66476380f4fadf3cf2633c32a596c9', 'v0.0.556'),
    ('drnc58', '0515', '418d18b26f32347e695b85a60d2bf658409be28d', 'v0.0.559'),
    ('drnd22', '0744', 'aecf15fc2171d29d8ea765afa540e4ddb40a9b19', 'v0.0.498'),
    ('drnd38', '0624', '4a86d6ebd970e02792068c46c80ae00686d759cc', 'v0.0.552'),
    ('drnd54', '0497', '117ca29b47a6e640269d455dfcc12e9958f5f1e1', 'v0.0.554'),
    ('drnd105', '0487', '52286b345e48cc873bbc0239cdd91b03beae655d', 'v0.0.564'),
    ('dpn68', '0658', '07251919c08640c94375670cbc5f0fbc312ed59b', 'v0.0.310'),
    ('dpn98', '0422', '1ace57dc702d5b6ca7eccb657036f682605d7efc', 'v0.0.540'),
    ('dpn131', '0477', 'e814a53cc6cddc0b6f2a11393a88c44723a8ec0c', 'v0.0.534'),
    ('darknet_tiny', '1746', '16501793621fbcb137f2dfb901760c1f621fa5ec', 'v0.0.69'),
    ('darknet_ref', '1668', '3011b4e14b629f80da54ab57bef305d588f748ab', 'v0.0.64'),
    ('darknet53', '0550', '1d0b4f620071d544a3a1ccbe437267b8925ecc63', 'v0.0.501'),
    ('irevnet301', '0735', '4378cc1061da0377a3c7fc00c6be49c3875c997a', 'v0.0.564'),
    ('bagnet9', '2536', '6b5d69dac8fd780e9ac26b2b964370445662c610', 'v0.0.553'),
    ('bagnet17', '1523', 'cc7b9a74ec742972fc289686bdaf5b1f5731121f', 'v0.0.558'),
    ('bagnet33', '1041', '3b20fa3a31aa08f216d7091749f59154b6357397', 'v0.0.561'),
    ('dla34', '0705', '557c5f4f1db66481af6101c75d9ba52b486eda25', 'v0.0.486'),
    ('dla46c', '1286', '5b38b67fecf2d701b736eb23e1301b6dd7eb5fb9', 'v0.0.282'),
    ('dla46xc', '1225', 'e570f5f00a098b0de34e657f9d8caeda524d39f3', 'v0.0.293'),
    ('dla60', '0554', '88b141c4ca81598dbe4333bd4ddd5a1554772348', 'v0.0.494'),
    ('dla60x', '0553', '58924af84faf6ac0d980b047ccb505619925d97d', 'v0.0.493'),
    ('dla60xc', '1074', '1b4e4048847e1ba060eb76538ee09e760f40be11', 'v0.0.289'),
    ('dla102', '0517', '0e5d954cee3bb260a679425524deab61871bd0bf', 'v0.0.505'),
    ('dla102x', '0470', 'ea82787ce2b3c79cff32ccf54461507cc09c58ce', 'v0.0.528'),
    ('dla102x2', '0423', 'dde259b3525fb6dae7e445f6e534a13159b3b365', 'v0.0.542'),
    ('dla169', '0460', '71971da4e881084851c9b581e719ce4edfb8292d', 'v0.0.539'),
    ('fishnet150', '0466', 'ed21862d14bb0a4e9d1723b7c639e455a7b141c0', 'v0.0.502'),
    ('espnetv2_wd2', '1971', '2821c339eb68154129e2864f1b5d74d876a08d77', 'v0.0.567'),
    ('espnetv2_w1', '1383', '3e031b749057f0237b3ebd7954b175b4bb13200f', 'v0.0.569'),
    ('espnetv2_w5d4', '1226', '2a498c6d631c54dfacdd5cf9b4c6a07a6db82b2d', 'v0.0.564'),
    ('espnetv2_w3d2', '1086', 'e869dabdd427a4ab38016d375d5e1b2f29758cde', 'v0.0.566'),
    ('espnetv2_w2', '0941', 'ef6b1cc026609da7a8df81360e36ecb04985ad28', 'v0.0.566'),
    ('dicenet_wd5', '3051', '46077eac47e2a299dc1d4edc0128bd3cbd8e9ea9', 'v0.0.563'),
    ('dicenet_wd2', '2308', 'c03d6d00b8f9ecc8ad87c1ee4bd82a0291a0af06', 'v0.0.561'),
    ('dicenet_w3d4', '1618', 'eefcffc69e24e6ba0df06db03d0fef8be6afdfe1', 'v0.0.567'),
    ('dicenet_w1', '1411', '93e2e0df3b9cb62c8ba08d3f3d61237e20fce9e2', 'v0.0.513'),
    ('dicenet_w5d4', '1251', '710737608fb6e2282cdd3903d4a703eb1989b594', 'v0.0.515'),
    ('dicenet_w3d2', '1144', 'bb2a902d7adbe96472157e131153f48dfea9f37f', 'v0.0.522'),
    ('dicenet_w7d8', '1081', '37b9276b8b97c87554652d6963a566cbd189b054', 'v0.0.527'),
    ('dicenet_w2', '0915', 'c301319d2d2867f155227389ea7402106858c6d4', 'v0.0.569'),
    ('hrnet_w18_small_v1', '0873', '1060c1c562770adb94115de1cad797684dbb5703', 'v0.0.492'),
    ('hrnet_w18_small_v2', '0602', '1f319e1b1990818754b97104467cfecf3401ae4e', 'v0.0.499'),
    ('hrnetv2_w18', '0500', '0a70090294c726c1f303e9114d23c9373695eb44', 'v0.0.508'),
    ('hrnetv2_w30', '0508', 'eb6afc492537295615dc465236934a9a970c1bef', 'v0.0.525'),
    ('hrnetv2_w32', '0496', '9c6c47dcce100ff006509ed559158862a53436a6', 'v0.0.528'),
    ('hrnetv2_w40', '0481', '2382694cceff60b32b4702e64945706f183e3e1c', 'v0.0.534'),
    ('hrnetv2_w44', '0486', 'f5882024ac9513c2d6c2b41bc774862e392f69ad', 'v0.0.541'),
    ('hrnetv2_w48', '0484', '936bb78f8c187ca3cc96c7564fa3ff8ad9cb68a6', 'v0.0.541'),
    ('hrnetv2_w64', '0478', '4c18c51411db532c3b8168f0a1ae3e461e703d68', 'v0.0.543'),
    ('vovnet27s', '0980', '2a44d455a86e740bd1be61d204553af213ca3ac6', 'v0.0.551'),
    ('vovnet39', '0548', '20b60ee6bb8c59c684f8ffed7fbda3d76b1a7280', 'v0.0.493'),
    ('vovnet57', '0510', 'ed3cad779b94c4f4f531d6c37f90f1a5209d3b1c', 'v0.0.505'),
    ('selecsls42b', '0596', 'f5a35c74880fbe94fbe3770a96968fc81186b42b', 'v0.0.493'),
    ('selecsls60', '0511', '960edec5159b56bdba4ce606df203c8ce14cb8ba', 'v0.0.496'),
    ('selecsls60b', '0537', '7f83801b1c158502d93a4523bdecda43017448d5', 'v0.0.495'),
    ('hardnet39ds', '0864', '72e8423ee0b496c10b48ae687a417385d9667394', 'v0.0.485'),
    ('hardnet68ds', '0738', '012bf3ac31f38c78d5cdef1367cc3c27447236af', 'v0.0.487'),
    ('hardnet68', '0702', '6667306df893290d38510a76fd42ec82e05e2f68', 'v0.0.557'),
    ('hardnet85', '0572', '3baa0a7dd204196fd1afa631cf6de082a5cc0a36', 'v0.0.495'),
    ('squeezenet_v1_0', '1734', 'e6f8b0e8253cef1c5c071dfaf2df5fdfc6a64f8c', 'v0.0.128'),
    ('squeezenet_v1_1', '1739', 'd7a1483aaa1053c7cd0cf08529b2b87ed2781b35', 'v0.0.88'),
    ('squeezeresnet_v1_0', '1767', '66474b9b6a771055b28c37b70621c026a1ef6ef4', 'v0.0.178'),
    ('squeezeresnet_v1_1', '1784', '26064b82773e7a7175d6038976a73abfcd5ed2be', 'v0.0.70'),
    ('sqnxt23_w1', '1866', '73b700c40de5f7be9d2cf4ed30cc8935c670a3c3', 'v0.0.171'),
    ('sqnxt23v5_w1', '1743', '7a83722e7d362cef950d8534020f837caf9e6314', 'v0.0.172'),
    ('sqnxt23_w3d2', '1321', '4d733bcd19f1e502ebc46b52f0b69d959636902e', 'v0.0.210'),
    ('sqnxt23v5_w3d2', '1268', '4f98bbd3841d8d09a067100841f64ce3eccf184a', 'v0.0.212'),
    ('sqnxt23_w2', '1063', '95d9b55a5e857298bdb7974db6e3dbd9ecc94401', 'v0.0.240'),
    ('sqnxt23v5_w2', '1024', '707246f323bc95d0ea2d5608e9e85ae9fe59773a', 'v0.0.216'),
    ('shufflenet_g1_wd4', '3677', 'ee58f36811d023e1b2e651469c470e588c93f9d3', 'v0.0.134'),
    ('shufflenet_g3_wd4', '3617', 'bd08e3ed6aff4993cf5363fe8acaf0b22394bea0', 'v0.0.135'),
    ('shufflenet_g1_wd2', '2238', 'f77dcd18d3b759a3046bd4a2443c40e4ff455313', 'v0.0.174'),
    ('shufflenet_g3_wd2', '2060', 'ea6737a54bce651a0e8c0b533b982799842cb1c8', 'v0.0.167'),
    ('shufflenet_g1_w3d4', '1675', '2f1530aa72ee04e3599c5296b590a835d9d50e7f', 'v0.0.218'),
    ('shufflenet_g3_w3d4', '1609', 'e008e926f370af28e587f349384238d240a0fc02', 'v0.0.219'),
    ('shufflenet_g1_w1', '1350', '01934ee8f4bf7eaf4e36dd6442debb84ca2a2849', 'v0.0.223'),
    ('shufflenet_g2_w1', '1332', 'f5a1479fd8523032ee17a4de00fefd33ff4d31e6', 'v0.0.241'),
    ('shufflenet_g3_w1', '1329', 'ac58d62c5f277c0e9e5a119cc1f48cb1fcfc8306', 'v0.0.244'),
    ('shufflenet_g4_w1', '1310', '73c039ebf56f9561dd6eecc4cbad1ab1db168ed1', 'v0.0.245'),
    ('shufflenet_g8_w1', '1319', '9a50ddd9ce67ec697e3ed085d6c39e3d265f5719', 'v0.0.250'),
    ('shufflenetv2_wd2', '1830', '156953de22d0e749c987da4a58e0e53a5fb18291', 'v0.0.90'),
    ('shufflenetv2_w1', '1123', '27435039ab7794c86ceab11bd93a19a5ecab78d2', 'v0.0.133'),
    ('shufflenetv2_w3d2', '0913', 'f132506c9fa5f0eb27398f9936b53423d0cd5b66', 'v0.0.288'),
    ('shufflenetv2_w2', '0823', '2d67ac62057103fd2ed4790ea0058e0922abdd0f', 'v0.0.301'),
    ('shufflenetv2b_wd2', '1782', '845a9c43cf4a9873f89c6116634e74329b977e64', 'v0.0.157'),
    ('shufflenetv2b_w1', '1101', 'f679702f7c626161413320160c6c9c199de9b667', 'v0.0.161'),
    ('shufflenetv2b_w3d2', '0879', '4022da3a5922127b1acf5327bd9f1d4d55726e05', 'v0.0.203'),
    ('shufflenetv2b_w2', '0810', '7429df751916bf24bd7fb86bc137ae36275b9d19', 'v0.0.242'),
    ('menet108_8x1_g3', '2030', 'aa07f925180834389cfd3bf50cb22d2501225118', 'v0.0.89'),
    ('menet128_8x1_g4', '1913', '0c890a76fb23c0af50fdec076cb16d0f0ee70355', 'v0.0.103'),
    ('menet160_8x1_g8', '2028', '4f28279a94e631f6a51735de5ea29703cca69845', 'v0.0.154'),
    ('menet228_12x1_g3', '1289', '2dc2eec7c9ebb41c459450e1843503b5ac7ecb3a', 'v0.0.131'),
    ('menet256_12x1_g4', '1216', '7caf63d15190648e266a4e7520c3ad677716f388', 'v0.0.152'),
    ('menet348_12x1_g3', '0936', '62c72b0b56460f062d4da7155bd64a524f42fb88', 'v0.0.173'),
    ('menet352_12x1_g8', '1167', '5892fea4e44eb27814a9b092a1a06eb81cea7844', 'v0.0.198'),
    ('menet456_24x1_g3', '0780', '7a89b32c89f878ac63fc96ddc71cb1a5e91c84d6', 'v0.0.237'),
    ('mobilenet_wd4', '2218', '3185cdd29b3b964ad51fdd7820bd65f091cf281f', 'v0.0.62'),
    ('mobilenet_wd2', '1330', '94f13ae1375b48892d8ecbb4a253bb583fe27277', 'v0.0.156'),
    ('mobilenet_w3d4', '1051', '6361d4b4192b5fc68f3409100d825e8edb28876b', 'v0.0.130'),
    ('mobilenet_w1', '0865', 'eafd91e9369abb09726f2168aba24453b17fc22e', 'v0.0.155'),
    ('mobilenetb_wd4', '2165', '2070764e0b3be74922eb5fa0a4342c693821ba90', 'v0.0.481'),
    ('mobilenetb_wd2', '1271', '799ef980b2726a77d4b68d99f520d9d6bc7d86dc', 'v0.0.480'),
    ('mobilenetb_w3d4', '1020', 'b01c8bacda6f8e26b34a0313a4dc3883511760f7', 'v0.0.481'),
    ('mobilenetb_w1', '0788', '82664eb4c1f2ddd0ac163f50263237f7667223f3', 'v0.0.489'),
    ('fdmobilenet_wd4', '3053', 'd4f18e5b4ed63e5426eafbf5db7f8e2a97c28581', 'v0.0.177'),
    ('fdmobilenet_wd2', '1969', '242b9fa82d54f54f08b4bdbb194b7c89030e7bc4', 'v0.0.83'),
    ('fdmobilenet_w3d4', '1601', 'cb10c3e129706d3023d752e7402965af08f91ca7', 'v0.0.159'),
    ('fdmobilenet_w1', '1312', '95fa0092aac013c88243771faf66ef1134b7574d', 'v0.0.162'),
    ('mobilenetv2_wd4', '2412', 'd92b5b2dbb52e27354ddd673e6fd240a0cf27175', 'v0.0.137'),
    ('mobilenetv2_wd2', '1442', 'd7c586c716e3ea85e793f7c5aaf9cae2a907117b', 'v0.0.170'),
    ('mobilenetv2_w3d4', '1044', '768454f4bdaae337c180bb81248b8c5b8d31040b', 'v0.0.230'),
    ('mobilenetv2_w1', '0864', '6e58b1cb96852e4c6de6fc9cd11241384af21df9', 'v0.0.213'),
    ('mobilenetv2b_wd4', '2338', '77ba7e8d41542d311e240dab75e4d29fa0677fb9', 'v0.0.483'),
    ('mobilenetv2b_wd2', '1373', '3bfc8a592a0881c2cb025f52a09fb5057a7896be', 'v0.0.486'),
    ('mobilenetv2b_w3d4', '1064', '5d4dc4e5622043697382272183a3d0bd43dbc218', 'v0.0.483'),
    ('mobilenetv2b_w1', '0884', 'ab0ea3993e7c533f0aea5793331dc6302d715e9c', 'v0.0.483'),
    ('mobilenetv3_large_w1', '0729', 'db741a9938acc8a5fd9544aaf53b41aebb98e021', 'v0.0.491'),
    ('igcv3_wd4', '2830', '71abf6e0b6bff1d3a3938bfea7c752b59ac05e9d', 'v0.0.142'),
    ('igcv3_wd2', '1703', '145b7089e1d0e0ce88f17393a357d5bb4ae37734', 'v0.0.132'),
    ('igcv3_w3d4', '1096', '3c7c86fc43df2e5cf95a451ebe07fccf2d9dc076', 'v0.0.207'),
    ('igcv3_w1', '0900', 'e2c3da1cffd8e42da7a052b80db2f86758c8d35b', 'v0.0.243'),
    ('mnasnet_b1', '0723', 'a6f74cf912fa5b1ee4bb9825f3143a0c1ced03be', 'v0.0.493'),
    ('mnasnet_a1', '0705', '3efe98a3bd6ea0a8cb0902a4dba424c134145d5f', 'v0.0.486'),
    ('darts', '0756', 'c2c7c33ba60d1052f95bcae72128fc47b1214cff', 'v0.0.485'),
    ('proxylessnas_cpu', '0750', '256da7c8a05cd87a59e30e314b22dc1d4565946e', 'v0.0.324'),
    ('proxylessnas_gpu', '0724', 'd9ce80964e37fb30bddcc552f1d68361b1a94873', 'v0.0.333'),
    ('proxylessnas_mobile', '0780', 'b8bb5a64f333562475dcfc09eeb7e603d6e66afb', 'v0.0.326'),
    ('proxylessnas_mobile14', '0651', 'f08baec85343104994b821581cde3ee965a2c593', 'v0.0.331'),
    ('fbnet_cb', '0761', '3db688f2fa465bc93bc546b4432389fe33aec5b3', 'v0.0.486'),
    ('xception', '0511', '9755eb77589d627d816fe9806a2b2aa931b6c2f6', 'v0.0.544'),
    ('inceptionv3', '0533', '4a05a7ffcb5963d44678933596ef85a0f724ebab', 'v0.0.552'),
    ('inceptionv4', '0488', 'a828ae6ccccb3178257d20e5f17cc8c6ac4348cc', 'v0.0.543'),
    ('inceptionresnetv1', '0481', '3cc3b4959349e56d6b29619b07ae020e19039f67', 'v0.0.552'),
    ('inceptionresnetv2', '0470', '4ea29355ae39ececb733e949dfdcbdff72272559', 'v0.0.547'),
    ('polynet', '0453', '742803144e5a2a6148212570726350da09adf3f6', 'v0.0.96'),
    ('nasnet_4a1056', '0790', 'f89dd74f47e42c35c9a1182f248df1d319524db7', 'v0.0.495'),
    ('nasnet_6a4032', '0424', '73cca5fee009db77412c5fca7c826b3563752757', 'v0.0.101'),
    ('pnasnet5large', '0428', '998a548f44ac1b1ac6c4959a721f2675ab5c48b9', 'v0.0.114'),
    ('spnasnet', '0776', '09cc881e024d69ab3bd88bef332becb6147a0651', 'v0.0.490'),
    ('efficientnet_b0', '0722', '041a8346ad6a13dbb66384d9a41ed20d959d3e77', 'v0.0.364'),
    ('efficientnet_b1', '0626', '455dcb2a05a1295c8f6b728d4f6c72c507e1369a', 'v0.0.376'),
    ('efficientnet_b0b', '0670', '8892ba581b0d81dbc8fe56c49d81d3dd007b1db8', 'v0.0.403'),
    ('efficientnet_b1b', '0565', 'c29a1b67804b70856ed3cc329256b80e3afc04ad', 'v0.0.403'),
    ('efficientnet_b2b', '0516', '7532826e5c14f7ade9e8ea9ac92044d817575b06', 'v0.0.403'),
    ('efficientnet_b3b', '0431', '1e342ec2160e6de813f9bd4d0ab9ce3b5749780e', 'v0.0.403'),
    ('efficientnet_b4b', '0376', 'b60e177974539fc6dcc9fef3b90591bfc9949514', 'v0.0.403'),
    ('efficientnet_b5b', '0334', 'cd70ae717ddca72430efe91cf7a3c4e28bcd61ac', 'v0.0.403'),
    ('efficientnet_b6b', '0312', 'f581d9f046032e28e532082fa49bfd373952db4f', 'v0.0.403'),
    ('efficientnet_b7b', '0311', '2b8a6040588aea44b57df89e2d9239d906737508', 'v0.0.403'),
    ('efficientnet_b0c', '0646', '81eabd2992ba7bb80c1c1a7e20373e7c65aa1286', 'v0.0.433'),
    ('efficientnet_b1c', '0555', '10b5589de6ee9af3c67f0ae35a424b4adc0a9e35', 'v0.0.433'),
    ('efficientnet_b2c', '0489', '6f649ece72d0334e5191da78767f2ac9149e85f0', 'v0.0.433'),
    ('efficientnet_b3c', '0434', 'e1e2a1b7f3457bdd8f46a5858472ad4acd3d2362', 'v0.0.433'),
    ('efficientnet_b4c', '0359', 'cdb2012d6688b0208527d36817589095a1db1031', 'v0.0.433'),
    ('efficientnet_b5c', '0302', '3240f368eb5e7ed78b9ac0d68800fbea9b220e9b', 'v0.0.433'),
    ('efficientnet_b6c', '0285', 'e71a1ccc3e876a7d64818c83518dd0e64c630d3e', 'v0.0.433'),
    ('efficientnet_b7c', '0277', 'feea7daf3478645131c94319c71141df559dce19', 'v0.0.433'),
    ('efficientnet_b8c', '0270', '050ec6358583d0a48c74b02563474ecc1d9dacba', 'v0.0.433'),
    ('efficientnet_edge_small_b', '0629', '5b398abc73c4c4870d88c62452ff919bec2440c9', 'v0.0.434'),
    ('efficientnet_edge_medium_b', '0553', '0b3c86d49b3684d19e6589030aeceb918faa648c', 'v0.0.434'),
    ('efficientnet_edge_large_b', '0477', '055436da0fa440933b906c528cb34b200e28f73c', 'v0.0.434'),
    ('mixnet_s', '0703', '135aa0426712a9f60afe2cfff2df9607f3fc2d68', 'v0.0.493'),
    ('mixnet_m', '0631', '0881aba9281e3cae3e7cddd75d385c3cccdf7e25', 'v0.0.493'),
    ('mixnet_l', '0557', '94cbf10cb34c3e3940117d86c28bcc6dbfe9e005', 'v0.0.500'),
    ('resneta10', '1159', 'a66e01d9f567ce747e7c255adac848a33c54a3a5', 'v0.0.484'),
    ('resnetabc14b', '0956', '6f8c36067feb2d27b5e0813bf18ef29038db0d70', 'v0.0.477'),
    ('resneta18', '0802', '225dd3ae0eac3ce3815732ac4ab0e25df709a75c', 'v0.0.486'),
    ('resneta50b', '0534', '28eff48a72d892802dde424db3fd0e1a9c12be16', 'v0.0.492'),
    ('resneta101b', '0442', 'cdf5f7ac2ad291cdc35b351e9220a490c8cc996c', 'v0.0.532'),
    ('resneta152b', '0424', 'deaaaabf413821eb543621826c368493b9041438', 'v0.0.524'),
    ('resnetd50b', '0549', '17d6004b5c6c1b97cfb47377ae5076810c5d88be', 'v0.0.296'),
    ('resnetd101b', '0461', 'fead1bcb86bba2be4ed7f0033fa972dc613e3280', 'v0.0.296'),
    ('resnetd152b', '0467', 'd0fe2fe09c6462de17aca4a72bbcb08b76a66e02', 'v0.0.296'),
    ('nin_cifar10', '0743', '9696dc1a8f67e7aa233836bcbdb99625769b1e86', 'v0.0.175'),
    ('nin_cifar100', '2839', 'eed0e9af2cd8e5aa77bb063204525812dbd9190f', 'v0.0.183'),
    ('nin_svhn', '0376', '7cb750180b0a981007194461bf57cfd90eb59c88', 'v0.0.270'),
    ('resnet20_cifar10', '0597', '13c5ab19145591d75873da3497be1dd1bd2afd46', 'v0.0.163'),
    ('resnet20_cifar100', '2964', '4e1443526ee96648bfe4d4954871a97a9c9622f4', 'v0.0.180'),
    ('resnet20_svhn', '0343', '7ac0d94a4563c9611092ce08f2124a3828103139', 'v0.0.265'),
    ('resnet56_cifar10', '0452', 'a73e63e9d0f3f7adde59b4142323c0dd05930de7', 'v0.0.163'),
    ('resnet56_cifar100', '2488', '590977100774a289b91088245dd2bd0cbe6567e6', 'v0.0.181'),
    ('resnet56_svhn', '0275', 'e676e4216a771b7d0339e87284c7ebb03af8ed25', 'v0.0.265'),
    ('resnet110_cifar10', '0369', 'f89f1c4d9fdd9e5cd00949a872211376979ff703', 'v0.0.163'),
    ('resnet110_cifar100', '2280', '6c5fa14bb4ced2dffe6ee1536306687aae57f9cb', 'v0.0.190'),
    ('resnet110_svhn', '0245', '0570b5942680cf88c66ae9a76c0e7ff0a41e71a6', 'v0.0.265'),
    ('resnet164bn_cifar10', '0368', 'e7941eeeddef9336664522eaa3af92d77128cac0', 'v0.0.179'),
    ('resnet164bn_cifar100', '2044', 'c7db7b5e6fbe6dc0f9501d25784f1a107c6e0315', 'v0.0.182'),
    ('resnet164bn_svhn', '0242', '8cdce67452d2780c7c69f4d0b979e80189d4bff8', 'v0.0.267'),
    ('resnet272bn_cifar10', '0333', '99dc36ca2abc91f3f82db181a14c5364cd5526be', 'v0.0.368'),
    ('resnet272bn_cifar100', '2007', '088af5c23634fe75206081d946fc82fdc9e999ad', 'v0.0.368'),
    ('resnet272bn_svhn', '0243', '39d741c8d081ebd2266a114e82363839ffdf8ebb', 'v0.0.368'),
    ('resnet542bn_cifar10', '0343', 'e687b254e1eace223ceef39ad17106e61b8649ba', 'v0.0.369'),
    ('resnet542bn_cifar100', '1932', 'df8bd5264c1db11dd545f62e9c750c7976edccc9', 'v0.0.369'),
    ('resnet542bn_svhn', '0234', '4f78075cbcba196fc8f5297b71730906c1bf7d8a', 'v0.0.369'),
    ('resnet1001_cifar10', '0328', 'bb979d53089138b5060b418cad6c8ad9a940bf81', 'v0.0.201'),
    ('resnet1001_cifar100', '1979', '692d9516620bc8b7a4da30a98ebcb7432243f5e9', 'v0.0.254'),
    ('resnet1001_svhn', '0241', '031fb0ce5e5ddbebca2fd7d856d63ddd147fe933', 'v0.0.408'),
    ('resnet1202_cifar10', '0353', '377510a63595e544333f6f57523222cd845744a8', 'v0.0.214'),
    ('resnet1202_cifar100', '2156', '1d94f9ccdd81e1785ea6ec02a861a4a05f39e5c9', 'v0.0.410'),
    ('preresnet20_cifar10', '0651', 'daa895737a34edda75c40f2d8566660590c84a3f', 'v0.0.164'),
    ('preresnet20_cifar100', '3022', '37f15365d48768f792f4551bd6ccf5259bc70530', 'v0.0.187'),
    ('preresnet20_svhn', '0322', '608cee12c0bc3cb59feea96386f6c12c6da91ba5', 'v0.0.269'),
    ('preresnet56_cifar10', '0449', 'cb37cb9d4524d4e0f5724aeed9face455f527efc', 'v0.0.164'),
    ('preresnet56_cifar100', '2505', '4c39e83f567f15d6ee0d69bf2dcaccd62067dfe5', 'v0.0.188'),
    ('preresnet56_svhn', '0280', 'b974c2c96a18ff2278f1d33df58c8537f9139ed9', 'v0.0.269'),
    ('preresnet110_cifar10', '0386', 'd6d4b7bd9f154eca242482a7559413d5c7b6d465', 'v0.0.164'),
    ('preresnet110_cifar100', '2267', '18cf4161c67c03e50cff7eb30988a559f3f97260', 'v0.0.191'),
    ('preresnet110_svhn', '0279', '6804450b744fa922d9ec22aa4c792d3a5da812f6', 'v0.0.269'),
    ('preresnet164bn_cifar10', '0364', '7ecf30cb818f80908ef4a77af4660c1080d0df81', 'v0.0.196'),
    ('preresnet164bn_cifar100', '2018', 'a20557c8968c04d8d07e40fdc5b0d1ec1fb3339d', 'v0.0.192'),
    ('preresnet164bn_svhn', '0258', '4aeee06affea89767c058fe1650b7476f05d8563', 'v0.0.269'),
    ('preresnet272bn_cifar10', '0325', '944ba29df55afcf2789399de552e91578edd4295', 'v0.0.389'),
    ('preresnet272bn_cifar100', '1963', '38e296beff0cd92697235c717a801ec422cdafe3', 'v0.0.389'),
    ('preresnet272bn_svhn', '0234', '7ff97873447fbfb1d823fd43439e34351f149c13', 'v0.0.389'),
    ('preresnet542bn_cifar10', '0314', 'ac40a67bb3b7f02179ff3c4fa0d6533ff3e2dd9f', 'v0.0.391'),
    ('preresnet542bn_cifar100', '1871', 'd536ad01fc40fe19605a3409efb995bf8593aa29', 'v0.0.391'),
    ('preresnet542bn_svhn', '0236', '3a4633f14e96cce30086ef4149b52c0b7cbccce6', 'v0.0.391'),
    ('preresnet1001_cifar10', '0265', '50507ff74b6047abe6d04af6471d9bacafa05e24', 'v0.0.209'),
    ('preresnet1001_cifar100', '1841', '185e033d77e61cec588196e3fe8bf8dcb43acfab', 'v0.0.283'),
    ('preresnet1202_cifar10', '0339', '942cf6f22d80b5428256825234a252b8d6ebbe9d', 'v0.0.246'),
    ('resnext20_1x64d_cifar10', '0433', '0661d12e534a87bd5f3305d541afce5730d45492', 'v0.0.365'),
    ('resnext20_1x64d_cifar100', '2197', 'e7073542469be79876e3b3aeccb767638a136b93', 'v0.0.365'),
    ('resnext20_1x64d_svhn', '0298', '3c7febc8eee0887ebc54d5e1a4411a46066f0624', 'v0.0.365'),
    ('resnext20_2x32d_cifar10', '0453', 'afb48ca4764efaff92e4cc50ec11566993180ac1', 'v0.0.365'),
    ('resnext20_2x32d_cifar100', '2255', '995281ee5b0d021bf6e9e984802e30a0042e0290', 'v0.0.365'),
    ('resnext20_2x32d_svhn', '0296', '54189677f599b4f42d2469ad75921165f84d82dc', 'v0.0.365'),
    ('resnext20_2x64d_cifar10', '0403', '6f0c138fe13a73c9f149053065f1f430761e75be', 'v0.0.365'),
    ('resnext20_2x64d_cifar100', '2060', '5f6dfa3ff5f1b0e3e1441f554a80c504c1991a03', 'v0.0.365'),
    ('resnext20_2x64d_svhn', '0283', '9c77f074dcd6333a859da6ddd833a662031406ea', 'v0.0.365'),
    ('resnext20_4x16d_cifar10', '0470', 'ae1ba8697ec0a62a58edb9c87ef0d9f290d3c857', 'v0.0.365'),
    ('resnext20_4x16d_cifar100', '2304', '2c9d578ab797ef887b3e8c51d897a8e720880bfd', 'v0.0.365'),
    ('resnext20_4x16d_svhn', '0317', '6691c8f56f7a63b5638408356a7f9fe4931d7ac9', 'v0.0.365'),
    ('resnext20_4x32d_cifar10', '0373', 'cf6960607fb51269cb80d6900eadefd16c6bb511', 'v0.0.365'),
    ('resnext20_4x32d_cifar100', '2131', '2c558efca7c66c412843603cff137e9565d7c016', 'v0.0.365'),
    ('resnext20_4x32d_svhn', '0298', '1da9a7bf6bed55f89b1c19a9b6ff97f7fa674c81', 'v0.0.365'),
    ('resnext20_8x8d_cifar10', '0466', '280e5f89e24ca765a771e733f53377ede244207f', 'v0.0.365'),
    ('resnext20_8x8d_cifar100', '2282', '363f03e8040da3a2f1cfe88df99481b23382e28c', 'v0.0.365'),
    ('resnext20_8x8d_svhn', '0318', 'c1536efbb2d7c78ee5b9323b43e3d0d56e9d2aa4', 'v0.0.365'),
    ('resnext20_8x16d_cifar10', '0404', '4d7f72818137674c3c17257427b0c5788b250320', 'v0.0.365'),
    ('resnext20_8x16d_cifar100', '2172', '3fc47c7072039fd5437ed276e92a0840c94fe82e', 'v0.0.365'),
    ('resnext20_8x16d_svhn', '0301', '41b28fd308e8195ee74050a2c56e2085552a55e0', 'v0.0.365'),
    ('resnext20_16x4d_cifar10', '0404', '426b5b2f994bc8154cb17957cf7d487b156d4fe2', 'v0.0.365'),
    ('resnext20_16x4d_cifar100', '2282', '508d32271ea1d34d40305a67d64cf1547ca58ae6', 'v0.0.365'),
    ('resnext20_16x4d_svhn', '0321', '854df3b71743fe871b5cd9b72ff6197b34c57b5e', 'v0.0.365'),
    ('resnext20_16x8d_cifar10', '0394', 'f81d05668bf293e5d84150ec54f94c4a50b79d9c', 'v0.0.365'),
    ('resnext20_16x8d_cifar100', '2173', 'a246aea51d1fd165c9f6db2aa528a2afa6a03dcd', 'v0.0.365'),
    ('resnext20_16x8d_svhn', '0293', '31f4b14e3113085a6b9a8e384a3131af764afe82', 'v0.0.365'),
    ('resnext20_32x2d_cifar10', '0461', '2d6ee8362c497b7782b91f85d5c9fd0f4ac0470e', 'v0.0.365'),
    ('resnext20_32x2d_cifar100', '2322', 'ce65201429a93cf9175c0e2b8601ceaf538a2438', 'v0.0.365'),
    ('resnext20_32x2d_svhn', '0327', '2499ff6de736f1241bc58422ae9d1d39d8ac1014', 'v0.0.365'),
    ('resnext20_32x4d_cifar10', '0420', 'a365893948daea8ef5b20b61bc3519fe199381af', 'v0.0.365'),
    ('resnext20_32x4d_cifar100', '2213', '5b2ffba877ea3dd0aa86d7c38ab5467d4ed856e6', 'v0.0.365'),
    ('resnext20_32x4d_svhn', '0309', 'ddbef9ac7da748e162ac886621833a5aef84cb86', 'v0.0.365'),
    ('resnext20_64x1d_cifar10', '0493', '6618e9ac6df3bc2614c23ba0e39ea0d0d5d21eec', 'v0.0.365'),
    ('resnext20_64x1d_cifar100', '2353', '9c789af45dd1455b4b7fe94a21709bb9dc8c411b', 'v0.0.365'),
    ('resnext20_64x1d_svhn', '0342', '2591ea440078f6c089513ace548ed79fb0f9bb76', 'v0.0.365'),
    ('resnext20_64x2d_cifar10', '0438', '32fe188b44b9e7f80ddec8024799be871dd63c4e', 'v0.0.365'),
    ('resnext20_64x2d_cifar100', '2235', '62fcc38a8e37550ace0f67927d2f5a74990de920', 'v0.0.365'),
    ('resnext20_64x2d_svhn', '0314', '4c01490b9566eeb2aaf27446ca8f5bac621894f0', 'v0.0.365'),
    ('resnext29_32x4d_cifar10', '0315', 'c8a1beda8ba616dc9af682d3ac172bfdd7a2472d', 'v0.0.169'),
    ('resnext29_32x4d_cifar100', '1950', '5f2eedcdd5cea6fdec1508f261f556a953ae28c2', 'v0.0.200'),
    ('resnext29_32x4d_svhn', '0280', 'dcb6aef96fbd76aa249e8f834093e2384b898404', 'v0.0.275'),
    ('resnext29_16x64d_cifar10', '0241', '76b97a4dd6185602a8ca8bdd77a70f8ddfcd4e83', 'v0.0.176'),
    ('resnext29_16x64d_cifar100', '1693', '1fcec90d6425e0405c61a1e90a80701ea556beca', 'v0.0.322'),
    ('resnext29_16x64d_svhn', '0268', 'c57307f3bf70d0f39d6cfb1dc2c82d8ef9e89603', 'v0.0.358'),
    ('resnext56_1x64d_cifar10', '0287', '8edd977c69cfec45604f1b0dbbe36fb2b65f122d', 'v0.0.367'),
    ('resnext56_1x64d_cifar100', '1825', 'b78642c10e21afc477c27076e2ab9ec6854cca13', 'v0.0.367'),
    ('resnext56_1x64d_svhn', '0242', '860c610caa23e742093d7c7677253ee5b917af44', 'v0.0.367'),
    ('resnext56_2x32d_cifar10', '0301', 'd0284dff7382d969c59e602f66b25a72b8d9e232', 'v0.0.367'),
    ('resnext56_2x32d_cifar100', '1786', '32205070280db6bd6431a6b7ad0537524af5a6f0', 'v0.0.367'),
    ('resnext56_2x32d_svhn', '0246', 'ffb8df9ba6a5053c79dbdecf7d0b6f1d248fcfdf', 'v0.0.367'),
    ('resnext56_4x16d_cifar10', '0311', 'add022e7dd21245720e789a0a16a7475d15b5702', 'v0.0.367'),
    ('resnext56_4x16d_cifar100', '1809', '366de7b5abba9b09d1ffde87e3e9f379db73d691', 'v0.0.367'),
    ('resnext56_4x16d_svhn', '0244', 'f7b697f924eeb64ed14d21f576a4a82007937bbe', 'v0.0.367'),
    ('resnext56_8x8d_cifar10', '0307', '4f0b72469f9890079471db355e9bfb405d443317', 'v0.0.367'),
    ('resnext56_8x8d_cifar100', '1806', '827a485e2d5f3154251d6453563a73a511028445', 'v0.0.367'),
    ('resnext56_8x8d_svhn', '0247', 'f0550cd045d9f4a4f8648f0c9c517421a34f4a11', 'v0.0.367'),
    ('resnext56_16x4d_cifar10', '0312', '93d71b610a356f8e285dde08ad4fe96d79efcadd', 'v0.0.367'),
    ('resnext56_16x4d_cifar100', '1824', '9cb7a1326870878315dccb50b0be51968d6ddfa7', 'v0.0.367'),
    ('resnext56_16x4d_svhn', '0256', '943386bd2e0fabba153955d80171016a95482609', 'v0.0.367'),
    ('resnext56_32x2d_cifar10', '0314', 'ea8b43351206a567f865a9a53ecae65790da8a60', 'v0.0.367'),
    ('resnext56_32x2d_cifar100', '1860', '3f65de935e532fe3c18324f645260983c61c0c76', 'v0.0.367'),
    ('resnext56_32x2d_svhn', '0253', 'ba8c809dcaa9f6f6e3b2e12dfd9df1b123d11be7', 'v0.0.367'),
    ('resnext56_64x1d_cifar10', '0341', '12a684ad58d1d3407d61b7de4b2cedc042225d20', 'v0.0.367'),
    ('resnext56_64x1d_cifar100', '1816', 'b80f4315d53963dd3d1ac856d3c2dbf660b836eb', 'v0.0.367'),
    ('resnext56_64x1d_svhn', '0255', '144bab62a5ed27bcb2465d9ab8b9b4ce0bf31dc5', 'v0.0.367'),
    ('resnext272_1x64d_cifar10', '0255', 'c1a3fddc4de9f6ebee2a588bd585ede68974da4f', 'v0.0.372'),
    ('resnext272_1x64d_cifar100', '1911', 'e0b3656a204c40e0b4ee6ade1e8d262c521e842d', 'v0.0.372'),
    ('resnext272_1x64d_svhn', '0235', '025ee7b915fa25d617e9774b0303f35488445d78', 'v0.0.372'),
    ('resnext272_2x32d_cifar10', '0274', '23b391ce58d9694ea35240ec3b76ce8b0ebf66b8', 'v0.0.375'),
    ('resnext272_2x32d_cifar100', '1834', '4802083b5fda38a4a30b8a2b1f24eb4b8fdf55ad', 'v0.0.375'),
    ('resnext272_2x32d_svhn', '0244', 'b65ddfe317dabceb4d4d7e910ca07c0c575ad9b8', 'v0.0.375'),
    ('seresnet20_cifar10', '0601', '3411e5ad1060975c45fe6d0d836755a92e3bb27c', 'v0.0.362'),
    ('seresnet20_cifar100', '2854', '184ad148171fd9244bf8570eee6647a996678ab4', 'v0.0.362'),
    ('seresnet20_svhn', '0323', 'a3a3c67731eb8bea0cd3af3b8b2f88c1cc70987e', 'v0.0.362'),
    ('seresnet56_cifar10', '0413', '21bac136e4cac21abb3e08b60254c73b16f0190f', 'v0.0.362'),
    ('seresnet56_cifar100', '2294', '989d4d9227c4fc33440c267f1e1ac324fd246ad4', 'v0.0.362'),
    ('seresnet56_svhn', '0264', '63a155acd6407b5e96516b86f6a7cd9e6855c372', 'v0.0.362'),
    ('seresnet110_cifar10', '0363', 'fa3f09a88d24282e938488c4588968e273770605', 'v0.0.362'),
    ('seresnet110_cifar100', '2086', '5345be4166268ce2cd44d88eb9edba9f86ccc864', 'v0.0.362'),
    ('seresnet110_svhn', '0235', 'd129498ad625983d92048f32b80de5d16987779a', 'v0.0.362'),
    ('seresnet164bn_cifar10', '0339', '11c923152587746a5539a9e4f140db847b9b61c1', 'v0.0.362'),
    ('seresnet164bn_cifar100', '1995', '6c9dc66b86de6be67df1e59d4aff4a592d7d98b8', 'v0.0.362'),
    ('seresnet164bn_svhn', '0245', 'd97ea6c83b0fd1da3a976d518977b19bd466d015', 'v0.0.362'),
    ('seresnet272bn_cifar10', '0339', 'da4073add21614f22b231d8663867007f3f2312d', 'v0.0.390'),
    ('seresnet272bn_cifar100', '1907', '754af9375f060f55f8c3393a70659df460b8d47d', 'v0.0.390'),
    ('seresnet272bn_svhn', '0238', '9ffe8acad2a03cd98f6746d3f1528fe5f294aea4', 'v0.0.390'),
    ('seresnet542bn_cifar10', '0347', 'e64d9ca4b98349973b802572af6625879bc3c4a4', 'v0.0.385'),
    ('seresnet542bn_cifar100', '1887', 'cd76c769c06b886d2a94268c95691dfc905bac64', 'v0.0.385'),
    ('seresnet542bn_svhn', '0226', '05ce3771c46aa8b7af7c2056398f83b2b9f116db', 'v0.0.385'),
    ('sepreresnet20_cifar10', '0618', 'e55551e6e35d04fe8e35d24a5e3d608a08e8dfa2', 'v0.0.379'),
    ('sepreresnet20_cifar100', '2831', 'ee5d3bd66ce643950e54d54825036b98b13b31cd', 'v0.0.379'),
    ('sepreresnet20_svhn', '0324', 'd5bb6768cc3134137371a832c5ebc289d982a8db', 'v0.0.379'),
    ('sepreresnet56_cifar10', '0451', '56c299345242bcfca52c83f77cfff80b7058b1fe', 'v0.0.379'),
    ('sepreresnet56_cifar100', '2305', '313a7a30a129c174ecaf3de6a94a5fd34dc8d711', 'v0.0.379'),
    ('sepreresnet56_svhn', '0271', 'f556af3db771e6e4e5b847bd4eddef71b879b8d0', 'v0.0.379'),
    ('sepreresnet110_cifar10', '0454', '67eea1cc03f76ee0054d39f004ab10f7a70978bb', 'v0.0.379'),
    ('sepreresnet110_cifar100', '2261', '3291a56be67afd1154d9d2d05e2e1411c12dcb4a', 'v0.0.379'),
    ('sepreresnet110_svhn', '0259', '5c09cacbcf786e18509947c40de695883d6b3328', 'v0.0.379'),
    ('sepreresnet164bn_cifar10', '0373', 'ac72ac7fa9d78e66a719717f922f738bbe7f9699', 'v0.0.379'),
    ('sepreresnet164bn_cifar100', '2005', 'd93993672a414e8f19cb12d2489be930e8605b8f', 'v0.0.379'),
    ('sepreresnet164bn_svhn', '0256', 'a45d1a65092900bb768969c52f26c61292838caa', 'v0.0.379'),
    ('sepreresnet272bn_cifar10', '0339', '3e47d575280a70c1726d6b2eb8d0d7c069a3e472', 'v0.0.379'),
    ('sepreresnet272bn_cifar100', '1913', 'd243b0580717b197bf9eb32a8959c83d21a3124f', 'v0.0.379'),
    ('sepreresnet272bn_svhn', '0249', '34b910cdfa34bf318f58c3312bc074059c7c669f', 'v0.0.379'),
    ('sepreresnet542bn_cifar10', '0308', '05f7d4a6bfb1af1825b734eac99b3b46dd8c4b91', 'v0.0.382'),
    ('sepreresnet542bn_cifar100', '1945', '4dd0e21d02fef2ae1fe3fb3a8cd8c72db11bb685', 'v0.0.382'),
    ('sepreresnet542bn_svhn', '0247', '456035daf4daecd909e957da090078deba6cb449', 'v0.0.382'),
    ('pyramidnet110_a48_cifar10', '0372', '35b94d0575c2081a142e71955c8ceea8c51ec5e5', 'v0.0.184'),
    ('pyramidnet110_a48_cifar100', '2095', '00fd42a00492b2bbb28cacfb7b1a6c63072c37a3', 'v0.0.186'),
    ('pyramidnet110_a48_svhn', '0247', 'd8a5c6e20b6cc01989a52f9e307caf640169ed0a', 'v0.0.281'),
    ('pyramidnet110_a84_cifar10', '0298', '81710d7ab90838a8a299bf5f50aed2a3fa41f0e3', 'v0.0.185'),
    ('pyramidnet110_a84_cifar100', '1887', '6712d5dc69452f2fde1fcc3ee32c3164dcaffc4e', 'v0.0.199'),
    ('pyramidnet110_a84_svhn', '0243', '473cc640c4ad0a1642500c84f2ef848498d12a37', 'v0.0.392'),
    ('pyramidnet110_a270_cifar10', '0251', '1e769ce50ef915a807ee99907912c87766fff60f', 'v0.0.194'),
    ('pyramidnet110_a270_cifar100', '1710', '2732fc6430085192189fd7ccfd287881cc5a6c0d', 'v0.0.319'),
    ('pyramidnet110_a270_svhn', '0238', '034be5421b598e84f395f421182f664495ca62ca', 'v0.0.393'),
    ('pyramidnet164_a270_bn_cifar10', '0242', 'c4a79ea3d84344b9d352074122e37f593ee98fd2', 'v0.0.264'),
    ('pyramidnet164_a270_bn_cifar100', '1670', '08f46c7ff99e9c3fd7b5262e34dc8a00b316646f', 'v0.0.312'),
    ('pyramidnet164_a270_bn_svhn', '0233', '27b67f1494ed508e0192e3e0f09ac86e32e1e734', 'v0.0.396'),
    ('pyramidnet200_a240_bn_cifar10', '0244', '52f4d43ec4d952f847c3a8e0503d5a4e6286679c', 'v0.0.268'),
    ('pyramidnet200_a240_bn_cifar100', '1609', 'e61e7e7eb6675aaf7a18461fea9bb3a53538d43b', 'v0.0.317'),
    ('pyramidnet200_a240_bn_svhn', '0232', '02bf262e70d9b3ce8038255d0abdec2bc5161f6d', 'v0.0.397'),
    ('pyramidnet236_a220_bn_cifar10', '0247', '1bd295a7fb834f639b238ffee818b3bde4126c81', 'v0.0.285'),
    ('pyramidnet236_a220_bn_cifar100', '1634', 'f066b3c6a4d217c42f5e8872fe23d343afe378ec', 'v0.0.312'),
    ('pyramidnet236_a220_bn_svhn', '0235', '1a0c0711f013035c0e05145501c93fa2519603ea', 'v0.0.398'),
    ('pyramidnet272_a200_bn_cifar10', '0239', 'd7b23c5460f059ac82ebc7b2cd992a203e098476', 'v0.0.284'),
    ('pyramidnet272_a200_bn_cifar100', '1619', '486e942734d91cd62d6bcbc283e1d7b56b734507', 'v0.0.312'),
    ('pyramidnet272_a200_bn_svhn', '0240', 'dcd9af34f57708f598bba723824bf3525f6e42c7', 'v0.0.404'),
    ('densenet40_k12_cifar10', '0561', '28dc0035549e51dcb53d1360707bd6f1558a5dcd', 'v0.0.193'),
    ('densenet40_k12_cifar100', '2490', '908f02ba7dbd7b8138f264193189e762a5590b1c', 'v0.0.195'),
    ('densenet40_k12_svhn', '0305', '645564c186a4e807293a68fb388803e36916e7b2', 'v0.0.278'),
    ('densenet40_k12_bc_cifar10', '0643', '7fdeda31c5accbddf47ab0f0b9a32cff723bf70d', 'v0.0.231'),
    ('densenet40_k12_bc_cifar100', '2841', '35cd8e6a2ae0896a8af2b689e076057fa19efa9b', 'v0.0.232'),
    ('densenet40_k12_bc_svhn', '0320', '6f2f98243fac9da22be26681bcd0a4d08e0f4baf', 'v0.0.279'),
    ('densenet40_k24_bc_cifar10', '0452', '13fa807e095b44ecaf3882e488b33a890d9d1e29', 'v0.0.220'),
    ('densenet40_k24_bc_cifar100', '2267', '2c4ef7c4bbe7f64784ad18b3845f4bf533f2ce57', 'v0.0.221'),
    ('densenet40_k24_bc_svhn', '0290', '03e136dd71bc85966fd2a4cb15692cfff3886df2', 'v0.0.280'),
    ('densenet40_k36_bc_cifar10', '0404', '4c154567e25619994a2f86371afbf1ad1e7475e9', 'v0.0.224'),
    ('densenet40_k36_bc_cifar100', '2050', 'd7275d39bcf439151c3bbeb707efa54943714b03', 'v0.0.225'),
    ('densenet40_k36_bc_svhn', '0260', 'b81ec8d662937851beecc62f36209fd8db464265', 'v0.0.311'),
    ('densenet100_k12_cifar10', '0366', '4e371ccb315d0fcd727a76255ca62ae9e92059cc', 'v0.0.205'),
    ('densenet100_k12_cifar100', '1964', '2ed5ec27a4d4a63876a4cacf52be53c91fbecb5f', 'v0.0.206'),
    ('densenet100_k12_svhn', '0260', '3e2b34b2087fe507a3672bfce1520747fca58046', 'v0.0.311'),
    ('densenet100_k24_cifar10', '0313', '9f795bac946d1390cf59f686b730fe512c406bd2', 'v0.0.252'),
    ('densenet100_k24_cifar100', '1808', '9bfa3e9c736a80906d163380cb361b940c2188bf', 'v0.0.318'),
    ('densenet100_k12_bc_cifar10', '0416', '6685d1f4844b092471f7d03dfc3fa64a302008e6', 'v0.0.189'),
    ('densenet100_k12_bc_cifar100', '2119', 'fbd8a54c1c9e4614f950b8473f8524d25caba4a7', 'v0.0.208'),
    ('densenet190_k40_bc_cifar10', '0252', '87b15be0620c0adff249d33540c20314188b16d7', 'v0.0.286'),
    ('densenet250_k24_bc_cifar10', '0267', 'dad68693d83a276d14a87dce6cebc5aceebca775', 'v0.0.290'),
    ('densenet250_k24_bc_cifar100', '1739', '598e91b7906f427296ab72cf40032f0846a52d91', 'v0.0.303'),
    ('xdensenet40_2_k24_bc_cifar10', '0531', '66c9d384d3ef4ec4095c9759bb8b7986f2f58e26', 'v0.0.226'),
    ('xdensenet40_2_k24_bc_cifar100', '2396', '73d5ba88a39b971457b9cea2cd72d1e05ab4d165', 'v0.0.227'),
    ('xdensenet40_2_k24_bc_svhn', '0287', '745f374b398bce378903af8c71cb3c67f6891d7f', 'v0.0.306'),
    ('xdensenet40_2_k36_bc_cifar10', '0437', 'e9bf419295f833b56fa3da27218107ed42310307', 'v0.0.233'),
    ('xdensenet40_2_k36_bc_cifar100', '2165', '78b6e754d90774d7b6ec3d811e6e57192148cfbf', 'v0.0.234'),
    ('xdensenet40_2_k36_bc_svhn', '0274', '4377e8918c1e008201aafc448f642642474eab14', 'v0.0.306'),
    ('wrn16_10_cifar10', '0293', 'ecf1c17c0814763095df562cb27d15a5aeb51836', 'v0.0.166'),
    ('wrn16_10_cifar100', '1895', 'bcb5c89ca71ffc99bc09b861b339724047724659', 'v0.0.204'),
    ('wrn16_10_svhn', '0278', '76f4e1361f9eca82fa4c2764b530f57280a34cfe', 'v0.0.271'),
    ('wrn28_10_cifar10', '0239', '16f3c8a249993f23b0f81d9ce3650faef5e455d8', 'v0.0.166'),
    ('wrn28_10_cifar100', '1788', '67ec43c6e913d43c8936809f04b0780035a24835', 'v0.0.320'),
    ('wrn28_10_svhn', '0271', 'fcd7a6b03a552b22ec25ee9a3833dc260976a757', 'v0.0.276'),
    ('wrn40_8_cifar10', '0237', '3b81d261706b751f5b731149b05fa92f500218e8', 'v0.0.166'),
    ('wrn40_8_cifar100', '1803', '114f6be2d5f8d561a5e3b4106fac30028defe300', 'v0.0.321'),
    ('wrn40_8_svhn', '0254', 'be7a21da6bc958c79725d7a29502c6a781cc67d9', 'v0.0.277'),
    ('wrn20_10_1bit_cifar10', '0326', 'c1a8ba4f1e1336a289c4b2eec75e25445b511ca6', 'v0.0.302'),
    ('wrn20_10_1bit_cifar100', '1904', 'adae01d6bec92d4fe388cddbb7f7eb598b1655d1', 'v0.0.302'),
    ('wrn20_10_1bit_svhn', '0273', 'ce9f819cf117fa66af112d9cbb0b65568623118d', 'v0.0.302'),
    ('wrn20_10_32bit_cifar10', '0314', '355496184493a55323c99bad9f79b0803548d373', 'v0.0.302'),
    ('wrn20_10_32bit_cifar100', '1812', 'd064f38aeaa14e9a2f4e9893ef6cca65615c53f9', 'v0.0.302'),
    ('wrn20_10_32bit_svhn', '0259', 'd9e8b46e180a34c0a765e22d24741f3849fca13a', 'v0.0.302'),
    ('ror3_56_cifar10', '0543', 'ee31a69a0503b41878c49d8925ac8e7ee813293b', 'v0.0.228'),
    ('ror3_56_cifar100', '2549', '4334559313cd9291af3d6ec0df144b21e695228b', 'v0.0.229'),
    ('ror3_56_svhn', '0269', '56617cf90e0902e88686af14939605c45d1170cf', 'v0.0.287'),
    ('ror3_110_cifar10', '0435', '0359916596cba01dfa481f105094c1047f592980', 'v0.0.235'),
    ('ror3_110_cifar100', '2364', 'b8c4d317241f54990180443d7fd9702d79c57ccc', 'v0.0.236'),
    ('ror3_110_svhn', '0257', '0677b7dfee32659a92719a5a16a7f387a5635f0b', 'v0.0.287'),
    ('ror3_164_cifar10', '0393', 'cc11aa06d928d0805279baccbf2b82371c31f503', 'v0.0.294'),
    ('ror3_164_cifar100', '2234', 'eb6a7fb8128240d84843a8e39adb00f606b6e2cf', 'v0.0.294'),
    ('ror3_164_svhn', '0273', 'b008c1b01386aca1803a1286607c5e1f843fc919', 'v0.0.294'),
    ('rir_cifar10', '0328', '5bed6f3506055b3ab5c4780a540cfebe014490ec', 'v0.0.292'),
    ('rir_cifar100', '1923', 'c42563834a971e18eacfc2287585aa2efa8af3eb', 'v0.0.292'),
    ('rir_svhn', '0268', '1c0718deaef5836efca4d5ded6140f0cd51424ab', 'v0.0.292'),
    ('shakeshakeresnet20_2x16d_cifar10', '0515', 'a7b8a2f77457e151da5d5ad3b9a2473594fecfc0', 'v0.0.215'),
    ('shakeshakeresnet20_2x16d_cifar100', '2922', 'e46e31a7d8308b57d9c0687000c40f15623998c2', 'v0.0.247'),
    ('shakeshakeresnet20_2x16d_svhn', '0317', '7a48fde5e1ccd5ff695892adf7094c15368ec778', 'v0.0.295'),
    ('shakeshakeresnet26_2x32d_cifar10', '0317', '21e60e626765001aaaf4eb26f7cb8f4a69ea3dc1', 'v0.0.217'),
    ('shakeshakeresnet26_2x32d_cifar100', '1880', 'bd46a7418374e3b3c844b33e12b09b6a98eb4e6e', 'v0.0.222'),
    ('shakeshakeresnet26_2x32d_svhn', '0262', 'f1dbb8ef162d9ec56478e2579272f85ed78ad896', 'v0.0.295'),
    ('diaresnet20_cifar10', '0622', '3e47641d76c1992652d8f973294f4763ecef1987', 'v0.0.340'),
    ('diaresnet20_cifar100', '2771', '3a58490ea95538ad5809c05739b4362088ea6961', 'v0.0.342'),
    ('diaresnet20_svhn', '0323', '579535ddc8b7c9becfe9bf97393ab33d9d5e7d0b', 'v0.0.342'),
    ('diaresnet56_cifar10', '0505', '45df69745c9692168697a7b980ade080ef7af07d', 'v0.0.340'),
    ('diaresnet56_cifar100', '2435', 'e45b7f281bb63c90104ff79d1519b4785a975a92', 'v0.0.342'),
    ('diaresnet56_svhn', '0268', '8f2c0574380bf14b0e9711d6370b2898f337cab0', 'v0.0.342'),
    ('diaresnet110_cifar10', '0410', '56f547ec833f419ea216f51439de50287dfef3c3', 'v0.0.340'),
    ('diaresnet110_cifar100', '2211', 'e99fad4ef0b2e7f09376beb314d672db7c3b6a55', 'v0.0.342'),
    ('diaresnet110_svhn', '0247', 'c587ac09f45fd7a29adfc1da62ad50174fd248ec', 'v0.0.342'),
    ('diaresnet164bn_cifar10', '0350', '533e7c6a30fce31c4f65686782cf761e7913750c', 'v0.0.340'),
    ('diaresnet164bn_cifar100', '1953', '43fa3821ab72e94187c12f7f950a2343649b3657', 'v0.0.342'),
    ('diaresnet164bn_svhn', '0244', 'eba062dce4033fd85ff78c2530b363b3768c036e', 'v0.0.342'),
    ('diapreresnet20_cifar10', '0642', 'ec36098cfbbb889fdd124083e785d0e21ba34792', 'v0.0.343'),
    ('diapreresnet20_cifar100', '2837', '32f0f1be9aa1da73f8fdb74f27ebaa49e7f9ace6', 'v0.0.343'),
    ('diapreresnet20_svhn', '0303', 'e33be387b0e71a4b0597558157ffbdb79c6db30c', 'v0.0.343'),
    ('diapreresnet56_cifar10', '0483', 'cba6950f21643a70b8e61b7197ca9cee9b2d0545', 'v0.0.343'),
    ('diapreresnet56_cifar100', '2505', 'c9f8bd4380d35e3806e1697c1c8d80bf7341c04e', 'v0.0.343'),
    ('diapreresnet56_svhn', '0280', '98a2a0bab42ff2605bd2cd4e63280b3631b042cb', 'v0.0.343'),
    ('diapreresnet110_cifar10', '0425', 'f4eae5abe2edebb1e224f7cf092ba02a873eb781', 'v0.0.343'),
    ('diapreresnet110_cifar100', '2269', '78d79bab215a5dc7221859d0b2688d040a55afb2', 'v0.0.343'),
    ('diapreresnet110_svhn', '0242', 'decb3765e92f5620580fe6b440ee2a82811d412e', 'v0.0.343'),
    ('diapreresnet164bn_cifar10', '0356', '9cf07392dc9714324e470fd50efb92ef286296ac', 'v0.0.343'),
    ('diapreresnet164bn_cifar100', '1999', '1625154f3cce7e131f25d8ee0b315b3fcc6fb760', 'v0.0.343'),
    ('diapreresnet164bn_svhn', '0256', '8476c5c9176abf21ea380dd00074b0ec30bbc530', 'v0.0.343'),
    ('resnet10_cub', '2765', '9dab9a498c380e6b7447827e00996d7cc61cc414', 'v0.0.335'),
    ('resnet12_cub', '2658', 'a46b8ec2d8dcd66a628dcfcb617acb15ef786b95', 'v0.0.336'),
    ('resnet14_cub', '2435', '0b9801b2e3aa3908bbc98f50d3ae3e986652742b', 'v0.0.337'),
    ('resnet16_cub', '2321', '031374ada9830869372a63e132c2477a04425444', 'v0.0.338'),
    ('resnet18_cub', '2330', 'e72712003928ed70ccf44b953e9cec4f78a75eea', 'v0.0.344'),
    ('resnet26_cub', '2252', '61cce1ea575f650a7e12a08b1a09335afa6cb605', 'v0.0.345'),
    ('seresnet10_cub', '2739', '7060c03f78bc60df09288b433eb6117c0e167210', 'v0.0.361'),
    ('seresnet12_cub', '2604', 'ee095118bde6e05ea102f5b945401a7221b7b7fb', 'v0.0.361'),
    ('seresnet14_cub', '2363', '5d2049d53c0445d7c66c849a5cd805ce39a37ddb', 'v0.0.361'),
    ('seresnet16_cub', '2321', '576e58eff57730a516094b8ba79452092187b693', 'v0.0.361'),
    ('seresnet18_cub', '2308', '3d2496d66efd6a00ca516c1a7a5a091f90043237', 'v0.0.361'),
    ('seresnet26_cub', '2251', '8d54edb2800b2ff071ee5beedde285eb9553bc22', 'v0.0.361'),
    ('mobilenet_w1_cub', '2346', 'efcad3dcf1975552f15028255a15f86a16b60987', 'v0.0.346'),
    ('proxylessnas_mobile_cub', '2188', '36d33231029b466638b3b1f8b2d1392e22d1afa7', 'v0.0.347'),
    ('ntsnet_cub', '1326', '75ae8cdcf4beb1ab60c1a983c9f143baaebbdea0', 'v0.0.334'),
    ('pspnet_resnetd101b_voc', '8144', 'e15319bf5428637e7fc00dcd426dd458ac937b08', 'v0.0.297'),
    ('pspnet_resnetd50b_ade20k', '3687', 'f0dcdf734f8f32a879dec3c4e7fe61d629244030', 'v0.0.297'),
    ('pspnet_resnetd101b_ade20k', '3797', 'c1280aeab8daa31c0893f7551d70130c2b68214a', 'v0.0.297'),
    ('pspnet_resnetd101b_cityscapes', '7172', 'd5ad2fa4c4208f439ab0b98267babe0c4d9e6e94', 'v0.0.297'),
    ('pspnet_resnetd101b_coco', '6741', '87582b79c48c4e995de808ff0cbc162c55b52031', 'v0.0.297'),
    ('deeplabv3_resnetd101b_voc', '8024', '8ee3099c5c983ef1cc0ce23b23d91db40b2986b8', 'v0.0.298'),
    ('deeplabv3_resnetd152b_voc', '8120', '88fb315dc3c58a84f325e63105fbfe322932073f', 'v0.0.298'),
    ('deeplabv3_resnetd50b_ade20k', '3713', '5d5e2f74008ab3637a05b6b1357c9c339296188c', 'v0.0.298'),
    ('deeplabv3_resnetd101b_ade20k', '3784', '6224836f8f31a00be1718a530a20670136bb3958', 'v0.0.298'),
    ('deeplabv3_resnetd101b_coco', '6773', '74dc9914078e47feb3ff64fba717d1d4040d8235', 'v0.0.298'),
    ('deeplabv3_resnetd152b_coco', '6899', 'edd79b4ca095f1674e7a68ee0dc8ed8bcd0b6a26', 'v0.0.298'),
    ('fcn8sd_resnetd101b_voc', '8040', 'f6c67c75bce4f9a3e17bf555369c0c9332ab5c1f', 'v0.0.299'),
    ('fcn8sd_resnetd50b_ade20k', '3339', '9856c5ee8186d1ac4b0eb5177c73e76c4cd63bb0', 'v0.0.299'),
    ('fcn8sd_resnetd101b_ade20k', '3588', '081774b2fb373d7b759cda2160fa0d2599b1c5f1', 'v0.0.299'),
    ('fcn8sd_resnetd101b_coco', '6011', '05e97cc5f5fcdf1c5ec5c617062d43adfe150d88', 'v0.0.299'),
    ('icnet_resnetd50b_cityscapes', '6402', '6c8f86a53526ae107e58d5f645bc4de0da9c1bb1', 'v0.0.457'),
    ('fastscnn_cityscapes', '6576', '9e0d75e56bde8d1643d3ff0053e55114c0a77ee9', 'v0.0.474'),
    ('sinet_cityscapes', '6031', '47d8ae7824bd297bbf25c2f33e3d4a86a503aefa', 'v0.0.437'),
    ('bisenet_resnet18_celebamaskhq', '0000', 'd72f0cf3101625bb4265e4cf5ae557b994f84d67', 'v0.0.462'),
    ('danet_resnetd50b_cityscapes', '6799', '9880a0eb9523ba2c1f98025f7d7115a2a4c1f376', 'v0.0.468'),
    ('danet_resnetd101b_cityscapes', '6810', 'ea69dcea31f5b250254a226f70df130875ff18b2', 'v0.0.468'),
    ('alphapose_fastseresnet101b_coco', '7415', '70082a53d3cdeb7ebe4c7d8c16a6a39830f1ed23', 'v0.0.454'),
    ('simplepose_resnet18_coco', '6631', '5a6198e5103a28faab4e49c687121634c7f7d196', 'v0.0.455'),
    ('simplepose_resnet50b_coco', '7102', '6315ffa72993eea3f573ae1cc23f84d0275f0fbe', 'v0.0.455'),
    ('simplepose_resnet101b_coco', '7244', '0491ab951827782492ffbd8fa57aa6dd599c7e9f', 'v0.0.455'),
    ('simplepose_resnet152b_coco', '7253', '4590c1c555eb54c4e9afdc83fa8a199132afd212', 'v0.0.455'),
    ('simplepose_resneta50b_coco', '7170', 'fa09a84ee2e085ad6b641c4fe0cc483651861789', 'v0.0.455'),
    ('simplepose_resneta101b_coco', '7297', '7ddd6cb20bcd626e05e8a627601bf19b704ba6a9', 'v0.0.455'),
    ('simplepose_resneta152b_coco', '7344', '9ec1a3dc2a23a19cb7f5ac5466cebba8069a0f93', 'v0.0.455'),
    ('simplepose_mobile_resnet18_coco', '6625', '8ff93eed70ac73503c8c1e346ddd1ade5d9e3edf', 'v0.0.456'),
    ('simplepose_mobile_resnet50b_coco', '7110', 'e0f2e587ffdf5e074a29f877890b13b99a58c6c2', 'v0.0.456'),
    ('simplepose_mobile_mobilenet_w1_coco', '6410', '0867e5aa76d5ec37cde08c71de8324a9c2913922', 'v0.0.456'),
    ('simplepose_mobile_mobilenetv2b_w1_coco', '6374', '07e9c6295a8aa2b7bb9a1d0b7c716141e7ee71dc', 'v0.0.456'),
    ('simplepose_mobile_mobilenetv3_small_w1_coco', '5434', 'cb837c0e32edec68dc8598d71599ea7404936f96', 'v0.0.456'),
    ('simplepose_mobile_mobilenetv3_large_w1_coco', '6367', '7ba036a5ade736042531a0fe500ecec368dbf157', 'v0.0.456'),
    ('lwopenpose2d_mobilenet_cmupan_coco', '3999', 'b4a22e7c2a05e53fe22185002c48e81f76c2d918', 'v0.0.458'),
    ('lwopenpose3d_mobilenet_cmupan_coco', '3999', '4658738ec27d46ee01f2cad4aa975914e9f7108c', 'v0.0.458'),
    ('ibppose_coco', '6486', '024d1fafb7471572129ccbb07d662f6d8ccdc758', 'v0.0.459'),
    ('jasperdr10x5_en', '2190', '1ce0ab1cd891294988d7f34d2153fabd968aa876', 'v0.0.555'),
    ('jasperdr10x5_en_nr', '1789', '49b0b7718e69265c288c163fa6bbb68eb4db79e4', 'v0.0.555'),
    ('quartznet5x5_en_ls', '4468', 'b37c8cb2e84b2573ed4364d3786e5d06f36cba92', 'v0.0.555'),
    ('quartznet15x5_en', '1677', 'bf63d3ffbd117d7e6c36bcd7725c998b8ab06754', 'v0.0.555'),
    ('quartznet15x5_en_nr', '1774', '5a70b9ec078945392c9e5a4161a36f431b1966ab', 'v0.0.555'),
    ('quartznet15x5_de', '1166', '5e254c91fe57bb2ed5bae62eb5067fc4922f4184', 'v0.0.555'),
    ('quartznet15x5_fr', '1388', 'f2236953caa996832118c7a412c839395237b5c2', 'v0.0.555'),
    ('quartznet15x5_it', '1502', '2df788c3c06415237e254ea91ab2994b35c32e71', 'v0.0.555'),
    ('quartznet15x5_es', '1295', '117352a802814689275b03a161c537ae91e68a9f', 'v0.0.555'),
    ('quartznet15x5_ca', '0842', 'da40489e324b6a790638d8ed164be3728f4caf3c', 'v0.0.555'),
    ('quartznet15x5_pl', '1359', '0df08d125314b5a728cd22b77bb8c6dc2b9c2cd1', 'v0.0.555'),
    ('quartznet15x5_ru', '1648', 'aecf49e137f8041cebc5fcfe8d1834420f03d98b', 'v0.0.555'),
    ('quartznet15x5_ru34', '0968', 'ff446c0cca42687330ade49dfb6bac05d7251803', 'v0.0.555'),
]}

imgclsmob_repo_url = 'https://github.com/osmr/imgclsmob'


def get_model_name_suffix_data(model_name):
    if model_name not in _model_sha1:
        raise ValueError("Pretrained model for {name} is not available.".format(name=model_name))
    error, sha1_hash, repo_release_tag = _model_sha1[model_name]
    return error, sha1_hash, repo_release_tag


def get_model_file(model_name,
                   local_model_store_dir_path=os.path.join("~", ".mxnet", "models")):
    """
    Return location for the pretrained on local file system. This function will download from online model zoo when
    model cannot be found or has mismatch. The root directory will be created if it doesn't exist.

    Parameters
    ----------
    model_name : str
        Name of the model.
    local_model_store_dir_path : str, default $MXNET_HOME/models
        Location for keeping the model parameters.

    Returns
    -------
    file_path
        Path to the requested pretrained model file.
    """
    error, sha1_hash, repo_release_tag = get_model_name_suffix_data(model_name)
    short_sha1 = sha1_hash[:8]
    file_name = "{name}-{error}-{short_sha1}.params".format(
        name=model_name,
        error=error,
        short_sha1=short_sha1)
    local_model_store_dir_path = os.path.expanduser(local_model_store_dir_path)
    file_path = os.path.join(local_model_store_dir_path, file_name)
    if os.path.exists(file_path):
        if check_sha1(file_path, sha1_hash):
            return file_path
        else:
            logging.warning("Mismatch in the content of model file detected. Downloading again.")
    else:
        logging.info("Model file not found. Downloading to {}.".format(file_path))

    if not os.path.exists(local_model_store_dir_path):
        os.makedirs(local_model_store_dir_path)

    zip_file_path = file_path + ".zip"
    download(
        url="{repo_url}/releases/download/{repo_release_tag}/{file_name}.zip".format(
            repo_url=imgclsmob_repo_url,
            repo_release_tag=repo_release_tag,
            file_name=file_name),
        path=zip_file_path,
        overwrite=True)
    with zipfile.ZipFile(zip_file_path) as zf:
        zf.extractall(local_model_store_dir_path)
    os.remove(zip_file_path)

    if check_sha1(file_path, sha1_hash):
        return file_path
    else:
        raise ValueError("Downloaded file has different hash. Please try again.")
