---
title: "Two weeks of binsider (0.2.0)"
---

:::tip[😼]

<img class="light:sl-hidden" src="https://raw.githubusercontent.com/orhun/binsider/main/website/src/assets/binsider-text-dark.png" width="200"/>
<img class="dark:sl-hidden" src="https://raw.githubusercontent.com/orhun/binsider/main/website/src/assets/binsider-text-light.png" width="200"/>

`binsider` is a terminal UI tool for analyzing the binary files.

Take a look at the [documentation](https://binsider.dev/) if you are new around here 😎

:::

### Stats

It's been only two weeks and `binsider` already reached **1.7k** stars on [GitHub](https://github.com/orhun/binsider):

<a href="https://star-history.com/#orhun/binsider&Date">
 <picture>
   <img class="dark:sl-hidden" alt="Star History Chart" src="https://api.star-history.com/svg?repos=orhun/binsider&type=Date" />
   <img class="light:sl-hidden" alt="Star History Chart" src="https://api.star-history.com/svg?repos=orhun/binsider&type=Date&theme=dark" />
 </picture>
</a>

<br/>

Analytics from [Umami](https://umami.orhun.dev/share/Zbh61KU5IaDT4DiZ/binsider.dev):

![dynamic analysis](../../assets/blog/umami-2024927.png)

I would like to thank everyone who supported the project by starring, sharing, and contributing! 🖤

### Discord

I created a Discord server for discussing the development, features, and issues:

<a href="https://discord.gg/zphNxEcEK7">
   <img src="https://discord.com/api/guilds/1289166752311148554/embed.png?style=banner2"></a>

If you are a reverse engineering enthusiast, Rust developer, or just curious about the project, feel free to join the server by clicking the link above!

## What's new?

Click [here](https://github.com/orhun/binsider/blob/main/CHANGELOG.md) for the full changelog.

### Better platform support

The [dynamic analysis feature](/usage/dynamic-analysis) is now optional and gated behind the `dynamic-analysis` feature flag.

This change allows `binsider` to run on platforms where the dynamic analysis is not supported, e.g., macOS and Windows.

To build, run the following command:

```bash
cargo build --no-default-features
```

### Run with args

Now it is possible to [dynamically analyze](/usage/dynamic-analysis) binaries with their CLI arguments. This feature is useful for analyzing binaries that require specific arguments to run correctly, e.g:

```sh
binsider "python test.py"
```

### Nix flake

I know y'all like Nix, so we have a Nix flake for `binsider` now! ❄️

```bash
nix run "github:orhun/binsider"
```

### `binsider` as a library

`binsider` is now available as a Rust library if you want to integrate it into your TUI/Ratatui project!

```toml
[dependencies]
binsider = "0.1"
ratatui = "0.28"
```

See the [documentation](/extras/library/) for more information.

### Improved white theme support

Moths and other creatures that prefer light themes can now enjoy `binsider` too! 🦋

We now check the background color of the terminal and use appropriate accent colors. (e.g. white text on a black background)

### Reorder symbol table

The symbols and dynamic symbols table in [static analysis](/usage/static-analysis) are now reordered for better readability:

- Name, Type, Value, Size, Bind, Visibility, Ndx
- Name, Requirements, Type, Value, Size, Bind, Visibility, Ndx

![static analysis](../../assets/blog/0.2.0-static.gif)

### Sorted shared libraries

The shared libraries in the [general analysis](/usage/general-analysis) are now sorted alphabetically for better readability.

![general analysis](../../assets/blog/0.2.0-libs.png)

### Squashed bugs

- _(dynamic)_ Fix locating the binary ([#48](https://github.com/orhun/binsider/pull/48))
- _(strings)_ Replace unicode whitespace for correct rendering ([#28](https://github.com/orhun/binsider/pull/28))
- _(file)_ Do not panic if creation time is not supported ([#25](https://github.com/orhun/binsider/pull/25))
- _(tui)_ Stop the event handler on quit ([#24](https://github.com/orhun/binsider/pull/24))
- _(flake)_ Fix test failure on Nix ([#30](https://github.com/orhun/binsider/pull/30))
- _(test)_ Ensure that binary is built before the test runs ([#11](https://github.com/orhun/binsider/pull/11))

## Seeking contributors

I'm looking for new contributors to help with the development and fixing bugs!

Here is a list of issues that need attention:

| Issue                                              | Title                                                                            | Importance  | Type    |
| -------------------------------------------------- | -------------------------------------------------------------------------------- | ----------- | ------- |
| [#43](https://github.com/orhun/binsider/issues/43) | Tracing system call error: ESRCH: No such process                                | Help Needed | Bug     |
| [#35](https://github.com/orhun/binsider/issues/35) | Support displaying general file information on Windows                           | Help Needed | Feature |
| [#17](https://github.com/orhun/binsider/issues/17) | Print the list of linked libraries as a tree and indicate how they were resolved | Medium      | Feature |
| [#45](https://github.com/orhun/binsider/issues/45) | Support searching for shared libraries                                           | Medium      | Feature |
| [#22](https://github.com/orhun/binsider/issues/22) | Sort Symbols by Name or Address                                                  | Medium      | Feature |
| [#7](https://github.com/orhun/binsider/issues/7)   | Support tweaking dynamic analysis options                                        | Medium      | Feature |
| [#5](https://github.com/orhun/binsider/issues/5)   | Improve the test suite                                                           | Medium      | Feature |
| [#47](https://github.com/orhun/binsider/issues/47) | Human readable output for static analysis                                        | Easy        | Feature |
| [#6](https://github.com/orhun/binsider/issues/6)   | Launch TUI from selected tab                                                     | Easy        | Feature |
| [54](https://github.com/orhun/binsider/issues/54)  | Show the number of shared libraries                                              | Easy        | Feature |

Also, if you are feeling like researching/brainstorming, here are some issues that needs some thought:

| Issue                                              | Title                           |
| -------------------------------------------------- | ------------------------------- |
| [#46](https://github.com/orhun/binsider/issues/46) | Support diffing binaries        |
| [#26](https://github.com/orhun/binsider/issues/26) | Support more platforms via LIEF |
| [#16](https://github.com/orhun/binsider/issues/16) | Binwalk/unblob                  |

Feel free to ask questions in issues or [the Discord server](#discord) - always happy to guide you through the code!

## Reproducible builds

Last week I had the chance to attend the [Reproducible Builds Summit](https://reproducible-builds.org/events/hamburg2024/) in Hamburg, Germany. A lot of topics has been discussed - `binsider` was one of them and I got some feedback/thoughts from people with different backgrounds.

![reprobuilds](../../assets/blog/20240917_122011.jpg)

One of the reoccurring ideas was to add [diffoscope](https://diffoscope.org/) support to `binsider` for comparing binaries. Leave a comment on [#46](https://github.com/orhun/binsider/issues/46) if you think that would be useful - I might start working on it in the upcoming weeks.

## Support the development

[Become a sponsor](https://github.com/sponsors/orhun) of my work 🖤 or simply [buy me a coffee](https://buymeacoffee.com/orhun) ☕
